#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <getopt.h>
#include <ctime>
using namespace std;

#include "shared/F.h"
#include "shared/Graph.h"
#include "shared/GraphBuilder.h"
#include "nulla/Nullstellensatz.h"
#include "border/BorderSpace.h"
#include "coloring/trick.h"
#include "coloring/ColoringIdealBuilder.h"
#include "coloring/Sat3Color.h"
#include "coloring/Branching.h"

/* forward declaration */
void print_usage();
void process_command_line(int argc, char *argv[], std::string& filename, int& k, int& f);

int main(int argc, char* argv[])
{
    int k = 3;
    int f = 0;
    std::string filename;
    process_command_line(argc, argv, filename, k, f);

    GraphBuilder gb;
    ColoringIdealBuilder cib;

    unsigned int seed = time(NULL);
    std::cout << "Seed = " << seed << "\n";
    srand(seed);

#if 1
    int num_trials = 10;
    int num_vertices = 100;
    float incr = 0.0025;
    for (float p = incr; p <= 0.10001; p+=incr) {
        int nulla_infeas3 = 0;
        int nulla_infeas4 = 0;
        int border_infeas3 = 0;
        int border_feas3 = 0;
        int border_infeas4 = 0;
        int border_feas4 = 0;
        double border_time = 0;
        long long int border_iterations = 0;
        //int trick_infeas = 0;
        //int trick_feas = 0;
        int sat_infeas = 0;
        int sat_feas = 0;
        double sat_time = 0;
        int branching_infeas = 0;
        int branching_feas = 0;
        double branching_time = 0;
        for (int i = 0; i < num_trials; ++i) {
            if (i % 100 == 0) { std::cout << " " << i << std::flush; }
            //std::cout << "\r" << i << "/" << num_trials << std::flush;
            //std::cout << i << "/" << num_trials << std::endl;
            Graph* g = gb.buildGraph(num_vertices, p);
            //std::cout << "|V| = " << g->getNumVertices() << " ";
            //std::cout << "|E| = " << g->getNumEdges() << " ";
#if 1
            double start = tic();
            int result = sat3color(*g);
            sat_time += tic() - start;
            if (result == SATISFIABLE) { ++sat_feas; }
            else if (result == UNSATISFIABLE) { ++sat_infeas; }
#endif
#if 0
            int lower_bound, upper_bound;
            trick_coloring(*g, lower_bound, upper_bound);
            if (lower_bound >= 4) { ++trick_infeas; }
            if (upper_bound <= 3) { ++trick_feas; continue; }
            //std::cout << "Range: " << lower_bound << " - " << upper_bound << "\n";
#endif
            Ideal<F2>* ideal = cib.buildColoringIdeal<F2>(*g,3);

            if (1) {
                double start = tic();
                if (branching3color(*g)) { ++branching_feas; }
                else { ++branching_infeas; }
                branching_time += tic() - start;
            }

            if (0) { //(result == UNSATISFIABLE) {
                Nullstellensatz<F2> nulla(*ideal, 3,3);
                nulla.set_output_level(0);
                if (nulla.isVarietyEmpty()) { ++nulla_infeas3; }
                //else {
                //    Nullstellensatz<F2> nulla(*ideal, 4,4);
                //    nulla.set_output_level(0);
                //    if (nulla.isVarietyEmpty()) { ++nulla_infeas4; }
                //}
            }

            if (0) { //(result == UNSATISFIABLE) { // (1) {
                double start = tic();
                BorderSpace<F2> border(*ideal, 3);
                border.set_output_level(0);
                int result = border.isVarietyEmpty();
                border_time += tic()-start;
                border_iterations += border.get_num_iterations();
                if (result == 0) {
                    if (border.get_degree()==2) { ++border_infeas3; }
                    else if (border.get_degree()==3) { ++border_infeas4; }
                }
                else if (result > 0) { 
                    if (border.get_degree() == 2) { ++border_feas3; }
                    else if (border.get_degree() == 3) { ++border_feas4; }
                }
            }

            delete g;
            delete ideal;
        }
        std::cout << "\r";
        //std::cout << "\n";
        std::cout << "p = " << p;
#if 0
        std::cout << " NulLA3 = " << (float) 100*nulla_infeas3/num_trials << "%";
        //nulla_infeas4 += nulla_infeas3;
        //std::cout << " NulLA4 = " << (float) 100*nulla_infeas4/num_trials << "%";
#endif
#if 0
        std::cout << " Border3 = " << (float) 100*border_infeas3/num_trials << "/";
        std::cout << (float) 100*border_feas3/num_trials << "%";
        border_infeas4 += border_infeas3;
        border_feas4 += border_feas3;
        std::cout << " Border4 = " << (float) 100*border_infeas4/num_trials << "/";
        std::cout << (float) 100*border_feas4/num_trials << "%";
        std::cout << " " << border_time/num_trials << "s";
        std::cout << " #" << (float) border_iterations/num_trials;
#endif
        std::cout << " Sat = " << (float) 100*sat_infeas/num_trials << "/";
        std::cout << (float) 100*sat_feas/num_trials << "%";
        std::cout << " " << sat_time/num_trials << "s";
        //std::cout << " Trick = " << (float) 100*trick_infeas/num_trials << "/";
        //std::cout << (float) 100*trick_feas/num_trials << "%";
        std::cout << " Branching = " << (float) 100*branching_infeas/num_trials << "/";
        std::cout << (float) 100*branching_feas/num_trials << "%";
        std::cout << " " << branching_time/num_trials << "s";
        std::cout << std::endl;
    }
    return 0;
#endif

    Graph* g = gb.buildGraph(filename.c_str());
    switch (f) {
        case 0: {
            Ideal<Q>* ideal = cib.buildColoringIdeal<Q>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
        case 2: {
            Ideal<F2>* ideal = cib.buildColoringIdeal<F2>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
        case 4: {
            Ideal<F4>* ideal = cib.buildColoringIdeal<F4>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
        default: {
            FP::initialise(f);
            Ideal<FP>* ideal = cib.buildColoringIdeal<FP>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
    }

    return 0;
}

void print_usage()
{
	std::cout << "Usage: ./coloring [options] <filename>\n";
	std::cout << "Options:\n";
	std::cout << "\t-k, --numcolors\tNumber of colors to color the graph. Default is 3.\n";
	std::cout << "\t-f, --field\tThe field characteristic of the ideal. Default is 0.\n";
}

void process_command_line(int argc, char *argv[], std::string& filename, int& k, int& f)
{
	char c;
	int option_index(0);

	/* add more options here */
	struct option long_options[] =
	{
		{"numcolors", optional_argument, 0, 'k'},
		{"field", optional_argument, 0, 'f'},
        {"random", required_argument, 0, 'r'},
        {"probability", required_argument, 0, 'p'},
		{"help", optional_argument, 0, 'h'}
	};

	while ((c =
		getopt_long(argc, argv, "f:k:r:p:", long_options, &option_index)) != -1) {
		switch (c) {
			case 'f': /* externally generated graph */
				if (optarg) { f = atoi(optarg); }
				break;
			case 'k': /* number of colors */ 
				if (optarg) { k = atoi(optarg); }
				break;
			case 'h': 
				print_usage();
				break;
		}
	}

    if (optind == argc-1) { 
        filename = argv[optind];
    }
}
