#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <getopt.h>
using namespace std;

#include "F.h"
#include "IdealFactory.h"

/* forward declaration */
void print_usage();

int main(int argc, char* argv[])
{
    if (argc == 1) { print_usage(); }

    std::string filename = argv[argc-1];
    IdealAPI* ideal = IdealFactory().buildIdeal(filename.c_str());

	char c;
	int option_index(0);

	/* add more options here */
	struct option long_options[] =
	{
		{"m2", optional_argument, 0, 'm'},
		{"magma", optional_argument, 0, 'l'},
		{"cocoa", optional_argument, 0, 'c'}
	};

	while ((c =
		getopt_long(argc, argv, "mlc", long_options, &option_index)) != -1) {
		switch (c) {
			case 'm':
				ideal->print_m2();
				break;
			case 'l':
				ideal->print_magma();
				break;
			case 'c': 
				ideal->print_cocoa();
				break;
		}
	}
}

void print_usage()
{
	std::cout << "Usage: ./convert [--cocoa|--magma|--m2] <filename>\n";
}
