#ifndef IDEAL_BUILDER_H
#define IDEAL_BUILDER_H

#include "Ideal.h"
#include "Graph.h"
#include <map>

/* wrapper class for GMP's polynomial number for exact arithmetic */
class FlowIdealBuilder {
	private:

	public:
		/* default constructor */
		FlowIdealBuilder() {};
		/* destructor */
		~FlowIdealBuilder();

		/* construct a k flow ideal */
        template <class K>
		Ideal<K>* buildFlowIdeal(const Graph& g, const int& k_flow);
};

template <class K>
Ideal<K> *
FlowIdealBuilder::buildFlowIdeal(const Graph& g, const int& k_flow)
{
    int num_vars = g.getNumEdges();
	const std::vector<Graph::Edge>& edges = g.getEdges();
	Ideal<K>* I = new Ideal<K>(g.getNumEdges());

    std::map<Graph::Edge, int> edge_index_map;
    for (size_t e = 0; e < edges.size(); e++) {
        edge_index_map.insert(std::pair<Graph::Edge, int>(edges[e],e));
    }

	/* create a vector of size num_vertices, initialized to 0 */
	Term<K> term(num_vars);
    term.coeff = 1;
	Term<K> term_neg_one(num_vars);
    term_neg_one.coeff = -1;
	for (size_t e = 0; e < edges.size(); e++) {
	    /* add edge polynomial to the ideal, x_i^{k-1} - 1 */
	    Polynomial<K> p(num_vars);
	    term.mon[e] = k_flow-1;
	    p.addeq(term);
	    /* reset monomial */
	    term.mon[e] = 0;
	    p.addeq(term_neg_one);
	    I->addPoly(p);
    }

    //g.print_adj_list();
    term.coeff = 1;
    const std::vector<std::vector<int> >& adj_list = g.getAdjList();
	/* walk all vertices */
	for (int v = 0; v < g.getNumVertices(); ++v) {
		Polynomial<K> vp(num_vars);
        for (int i = 0; i < (int) adj_list[v].size(); ++i) {
            Graph::Edge e(v, adj_list[v][i]);
            int edge_index = (edge_index_map.find(e))->second;
            //std::cout << "Parsing (" << e.i << "," << e.j << ") : " << edge_index << "\n";
            term.mon[edge_index] = 1;
            if (adj_list[v][i] > v) { term.coeff = -1; }
            vp.addeq(term);
            term.mon[edge_index] = 0;
            term.coeff = 1;
        }
	    I->addPoly(vp);
	}

	/* return graph k-flowing ideal */
	return I;	
}

#endif
