#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <getopt.h>
using namespace std;

#include "F.h"
#include "Graph.h"
#include "GraphBuilder.h"
#include "FlowIdealBuilder.h"

/* forward declaration */
void print_usage();
void process_command_line(int argc, char *argv[], std::string& filename, int& k, int& f);

int main(int argc, char* argv[])
{
    int k = 3;
    int f = 0;
    std::string filename;
    process_command_line(argc, argv, filename, k, f);
 
    GraphBuilder gb;
    Graph* g = gb.buildGraph(filename.c_str());
    FlowIdealBuilder cib;
    switch (f) {
        case 0: {
            Ideal<Q>* ideal = cib.buildFlowIdeal<Q>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
        case 2: {
            Ideal<F2>* ideal = cib.buildFlowIdeal<F2>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
        case 4: {
            Ideal<F4>* ideal = cib.buildFlowIdeal<F4>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
        default: {
            FP::initialise(f);
            Ideal<FP>* ideal = cib.buildFlowIdeal<FP>(*g, k);
            ideal->print();
            delete ideal;
            break;
        }
    }

    return 0;
}

void print_usage()
{
	std::cout << "Usage: ./coloring [options] <filename>\n";
	std::cout << "Options:\n";
	std::cout << "\t-k, --numflow\tThe modular flow number. Default is 3.\n";
	std::cout << "\t-f, --field\tThe field characteristic of the ideal. Default is 0.\n";
}

void process_command_line(int argc, char *argv[], std::string& filename, int& k, int& f)
{
	char c;
	int option_index(0);

	/* add more options here */
	struct option long_options[] =
	{
		{"numflow", optional_argument, 0, 'k'},
		{"field", optional_argument, 0, 'f'},
		{"help", optional_argument, 0, 'h'}
	};

	while ((c =
		getopt_long(argc, argv, "f:k:", long_options, &option_index)) != -1) {
		switch (c) {
			case 'f': /* externally generated graph */
				if (optarg) { f = atoi(optarg); }
				break;
			case 'k': /* number of colors */ 
				if (optarg) { k = atoi(optarg); }
				break;
			case 'h': 
				print_usage();
				break;
		}
	}

    if (optind != argc-1) { 
        std::cerr << "ERROR: expected filename.\n";
        print_usage();
        exit(1);
    }
    filename = argv[optind];
}
