#include <fstream>
#include "F2.h"
#include "F4.h"
#include "FP.h"
#include "Q.h"
#include "NullstellensatzFactory.h"
#include "Polynomial.h"

NullstellensatzFactory::NullstellensatzFactory()
    : IdealFactory()
{
}

NullstellensatzInterface*
NullstellensatzFactory::buildNullstellensatz(const char* filename, int alpha_deg)
{
	std::ifstream in(filename);
	std::string line;
	std::string s;

	/* check if file opened sucessfully */	
	if (!in) {
		std::cout << "ERROR: Unable to open file " << filename << "\n";
		exit(1);
	}

	/* Strip comments. */
	while (in.peek() == COMMENT) { getline(in, line); }

	/* Find the characteristic of the field. */
	int fieldChar = 0;
	getline(in, line);
	if (sscanf(line.c_str(), "FIELD=F%d", &fieldChar) == 0) {
		std::cout << "ERROR! Field information for ideal not found.\n"; 
		exit(1);
	}

    NullstellensatzInterface* nulla = 0;

	switch (fieldChar) {
	case 0:
        nulla = new Nullstellensatz<Q>(*buildIdeal<Q>(in), alpha_deg);
		break;
	case 2:
        nulla = new Nullstellensatz<F2>(*buildIdeal<F2>(in), alpha_deg);
		break;
	case 4:
        nulla = new Nullstellensatz<F4>(*buildIdeal<F4>(in), alpha_deg);
		break;
	default:
		FP::initialise(fieldChar);
        nulla = new Nullstellensatz<FP>(*buildIdeal<FP>(in), alpha_deg);
	}

	in.close();

    return nulla;
}
