#include <ctime>
#include <cmath>
#include <string>
#include <fstream>
#include <iostream>
#include <sstream>
#include <getopt.h>

#include "NullstellensatzFactory.h"
#include "Nullstellensatz.h"
#include "MyTime.h"

using namespace std;

/* forward declaration */
bool process_cmd_line(int argc, char* argv[], std::string& filename, int& degree, bool& print, bool& check);
void print_usage();

int main(int argc, char *argv[])
{
    /* time functions */
    double start = tic();

    std::string filename;
    int alpha_deg(-1);
    bool check = false;
    bool print = false;

    if (!process_cmd_line(argc, argv, filename, alpha_deg, print, check)) {
        print_usage();
        return 1;
    }

    /* create an ideal from a file */
    NullstellensatzFactory factory;
    NullstellensatzInterface* nulla = 
                factory.buildNullstellensatz(filename.c_str(), alpha_deg);

    bool isInfeasible = nulla->isVarietyEmpty();
    if (isInfeasible) {
        if (print) { nulla->print_certificate(); }
        if (check) { nulla->check_certificate(); }
        cout << "System of equations is NOT feasible.\n";
    } else {
        cout << "System of equations MAY BE feasible... try a higher degree for alpha.\n";
    }
    delete nulla;
    cout << "TOTAL TIME: " << toc(start) << "\n"; 

    return 0;
}

void print_usage() {
    cout << "Usage:\n";
    cout << "\t ./nulla -p -c -d DEGREE <filename>\n";
    cout << "\t ./nulla --print --check --degree DEGREE <filename>\n";
    exit(0);
}

bool
process_cmd_line(int argc, char* argv[], std::string& filename, int& alpha_deg, bool& print, bool& check)
{
    alpha_deg = -1;
    char c;
    int option_index(0);
    /* add more options here */
    struct option long_options[] = {
        {"degree", required_argument, 0, 'd'},
        {"print", 0, 0, 'p'},
        {"check", 0, 0, 'c'}
    };

    while ((c =
        getopt_long(argc, argv, "d:pc", long_options, &option_index)) != -1) {
        switch (c) {
            case 'd':
                if (!optarg) { print_usage(); }
                else { alpha_deg = atoi(optarg); }
                break;
            case 'p':
                print = true;
                break;
            case 'c':
                check = true;
                break;
            default:
                std::cerr << "ERROR: Unrecognised option character '" << c << "'.\n";
        }
    }
    if (optind != argc-1) { return false; }
    if (alpha_deg == -1) { return false; }
    filename = argv[optind];
    return true;
}
