#include "SatIdealBuilder.h"
#include "Ideal.h"
#include "Polynomial.h"

#include <string>
#include <sstream>
#include <assert.h>

using namespace std;

const int NUM_LITERALS = 3;

/* default destructor */
SatIdealBuilder::~SatIdealBuilder()
{
}

Ideal<F2>*
SatIdealBuilder::buildSatIdeal(int num_vars, int num_clauses, int num_lits)
{
    std::vector<std::vector<int> > cnf(num_clauses);
    for (int c = 0; c < num_clauses; ++c) {
        for (int i = 0; i < num_lits; ++i) {
            int v = rand()%num_vars+1;
            if (rand() % 2 == 1) { v *= -1; }
            cnf[c].push_back(v);
        }
    }
    return buildSatIdeal(num_vars, cnf);
}

Ideal<F2>*
SatIdealBuilder::buildSatIdeal(
        int num_vars, 
        const std::vector<std::vector<int> >& cnf)
{
    int num_clauses = cnf.size();
    Ideal<F2>* I = new Ideal<F2>(num_vars);

    Term<F2> term(num_vars);
    for (int i = 0; i < num_vars; ++i) {
        Polynomial<F2> p(num_vars);
        term.mon.set_constant();
        term.mon[i]=1;
        p.addeq(term);
        term.mon[i]=2;
        p.addeq(term);
        I->addPoly(p);
    }

    Term<F2> one(num_vars);
    for (int c = 0; c < num_clauses; ++c) {
        Polynomial<F2> p(num_vars);
        p.addeq(one);
        term.mon.set_constant();
        for (unsigned int l = 0; l < cnf[c].size(); ++l) {
            int v = cnf[c][l];
            if (v < 0) { term.mon[-v-1] = 1; }
            if (v > 0) { 
                Polynomial<F2> npoly(num_vars);
                npoly.addeq(one);
                Term<F2> nterm(num_vars);
                nterm.mon[v-1] = 1;
                npoly.addeq(nterm);
                p.muleq(npoly);
            }
        }
        p.muleq(term);
        I->addPoly(p);
    }

    return I;    
}


Ideal<F2>*
SatIdealBuilder::buildSatIdeal(std::istream& in)
{
    int num_vars, num_clauses;
    in >> num_vars >> num_clauses;

    std::vector<std::vector<int> > cnf(num_clauses);

    for (int c = 0; c < num_clauses; ++c) {
        while (1) {
            int v; in >> v;
            if (v == 0) { break; }
            cnf[c].push_back(c);
        }
    }

    return buildSatIdeal(num_vars, cnf);    
}

