#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <getopt.h>
using namespace std;

#include "shared/F.h"
#include "shared/MyTime.h"
#include "SatIdealBuilder.h"
#include "nulla/Nullstellensatz.h"
#include "border/BorderSpace.h"
#include "zchaff/SAT.h"

/* forward declaration */
void print_usage();
void process_command_line(int argc, char *argv[], std::string& filename);
int sat_solver(int num_vars, std::vector<std::vector<int> >& cnf);
void rand_sat(int num_vars, int num_clauses, int num_lits,
        std::vector<std::vector<int> >& cnf);
void print_cnf(int num_vars, const std::vector<std::vector<int> >& cnf);

int main(int argc, char* argv[])
{
    std::string filename;
    process_command_line(argc, argv, filename);
    std::ifstream file(filename.c_str());

    SatIdealBuilder sib;
    int num_trials = 100;
    int num_vars = 20;
    int num_lits = 3;
    for (int num_clauses = 10; num_clauses <= 200; num_clauses += 10) {
        int nulla_infeas3 = 0;
        int nulla_infeas4 = 0;
        int border_infeas = 0;
        int border_feas = 0;
        double border_time = 0;
        long long int border_iterations = 0;
        int sat_feas = 0;
        int sat_infeas = 0;
        double sat_time = 0;
        for (int i = 0; i < num_trials; ++i) {
            std::vector<std::vector<int> > cnf(num_clauses);
            rand_sat(num_vars, num_clauses, num_lits, cnf);
            //print_cnf(num_vars, cnf);
#if 1
            {
            double start = tic();
            int result = sat_solver(num_vars, cnf);
            sat_time += tic()-start;
            if (result == SATISFIABLE) { ++sat_feas; ; }  //continue; }
            else if (result == UNSATISFIABLE) { ++sat_infeas; }
            }
#endif
            Ideal<F2>* ideal = sib.buildSatIdeal(num_vars, cnf);
            //ideal->print();
#if 0
            Nullstellensatz<F2> nulla(*ideal, 3,3);
            nulla.set_output_level(0);
            if (nulla.isVarietyEmpty()) { ++nulla_infeas3; }
            else if (1) {
                Nullstellensatz<F2> nulla(*ideal, 4,4);
                nulla.set_output_level(0);
                if (nulla.isVarietyEmpty()) { ++nulla_infeas4; }
            }
#endif
#if 1
            {
            double start = tic();
            BorderSpace<F2> border(*ideal, 3);
            border.set_output_level(0);
            int result = border.isVarietyEmpty();
            border_time += tic()-start;
            border_iterations += border.get_num_iterations();
            if (result == 0) { ++border_infeas; }
            else if (result > 0) { ++border_feas; }
            }
#endif
            delete ideal;
        }
        std::cout << " " << num_vars << " " << num_clauses << ": ";
        //std::cout << " NulLA3 = " << (float) 100*nulla_infeas3/num_trials << "%";
        //nulla_infeas4 += nulla_infeas3;
        //std::cout << " NulLA4 = " << (float) 100*nulla_infeas4/num_trials << "%";
        std::cout << " Border = " << (float) (100*border_infeas/num_trials) << "/";
        std::cout << (float) 100*border_feas/num_trials << "%";
        std::cout << " " << border_time/num_trials << "s";
        std::cout << " #" << (float) border_iterations/num_trials;
        std::cout << " Sat = " << (float) 100*sat_infeas/num_trials << "/";
        std::cout << (float) 100*sat_feas/num_trials << "%";
        std::cout << " " << sat_time/num_trials << "s";
        std::cout << std::endl;
    }
    return 0;

    Ideal<F2>* ideal = sib.buildSatIdeal(file);
    ideal->print();
    delete ideal;

    return 0;
}

void print_usage()
{
    std::cout << "Usage: ./sat <filename>\n";
}

void process_command_line(int argc, char *argv[], std::string& filename)
{
#if 0
    if (argc != 2) { 
        std::cerr << "ERROR: expected one argument -- the input filename.\n";
        print_usage();
        exit(1);
    }
#endif
    if (argc == 2) { filename = argv[argc-1]; }
}

int sat_solver(int num_vars, std::vector<std::vector<int> >& cnf)
{
    SAT_Manager mng = SAT_InitManager();
    SAT_SetNumVariables(mng, num_vars);
    for (unsigned int c = 0; c < cnf.size(); ++c) {
        int* clause = new int[cnf[c].size()];
        for (unsigned int l = 0; l < cnf[c].size(); ++l) {
            int v = cnf[c][l];
            if (v > 0) { clause[l] = 2*v; }
            else { clause[l] = -2*v+1; }
        }
        SAT_AddClause(mng, clause, cnf[c].size());
    }
    int result = SAT_Solve(mng);
    SAT_ReleaseManager(mng);
    return result;
}

void rand_sat(int num_vars, int num_clauses, int num_lits,
        std::vector<std::vector<int> >& cnf)
{
    cnf.clear();
    cnf.resize(num_clauses);
    for (int c = 0; c < num_clauses; ++c) {
        for (int i = 0; i < num_lits; ++i) {
            int v = rand()%num_vars+1;
            if (rand() % 2 == 1) { v *= -1; }
            cnf[c].push_back(v);
        }
    }
}

void print_cnf(int num_vars, const std::vector<std::vector<int> >& cnf)
{
    std::cout << "p cnf " << num_vars << " " << cnf.size() << "\n";
    for (unsigned int c = 0; c < cnf.size(); ++c) {
        for (unsigned int l = 0; l < cnf[c].size(); ++l) {
            std::cout << " " << cnf[c][l];
        }
        std::cout << " 0\n";
    }
}
