#ifndef _F2_H_
#define _F2_H_

#include <cassert>

class F2
{
	public:
		F2();
		F2(int);
		F2(const F2& x);
		F2& operator=(const F2& x);
		F2& operator=(int);

		bool operator==(const F2& x) const; 
		bool operator!=(const F2& x) const;

		F2 operator+() const;
		F2 operator-() const;
		F2 operator+(const F2& x) const;
		F2 operator-(const F2& x) const;
		F2 operator*(const F2& x) const;
		F2 operator/(const F2& x) const;
		void operator+=(const F2& x);
		void operator-=(const F2& x);
		void operator*=(const F2& x);
		void operator/=(const F2& x);

		static void add(const F2& x1, const F2& x2, F2& x);
		static void sub(const F2& x1, const F2& x2, F2& x);
		static void mul(const F2& x1, const F2& x2, F2& x);
		static void div(const F2& x1, const F2& x2, F2& x);

        static int getFieldCharacteristic();
        static int getFieldExponent();

		friend std::ostream& operator<<(std::ostream& os, const F2& x);
		friend std::istream& operator>>(std::istream& is, F2& x);

	private:
		unsigned short int v;
};

inline F2::F2() { v = 0; }
inline F2::F2(int i) { if (i % 2 == 0) { v = 0; } else { v = 1; } }
inline F2::F2(const F2& x) { v = x.v; }
inline F2& F2::operator=(const F2& x) { v = x.v; return *this; }
inline F2& F2::operator=(int i) { if (i % 2 == 0) { v = 0; } else { v = 1; } return *this; }

inline bool F2::operator==(const F2& x) const { return v == x.v; }
inline bool F2::operator!=(const F2& x) const { return v != x.v; }

inline F2 F2::operator+() const { return *this; }
inline F2 F2::operator-() const { return *this; }
inline F2 F2::operator+(const F2& x) const { return F2(v ^ x.v); }
inline F2 F2::operator-(const F2& x) const { return F2(v ^ x.v); }
inline F2 F2::operator*(const F2& x) const { return F2(v & x.v); }
inline F2 F2::operator/(const F2& x) const { assert(x.v); return F2(v); }

inline void F2::operator+=(const F2& x) { v ^= x.v; }
inline void F2::operator-=(const F2& x) { v ^= x.v; }
inline void F2::operator*=(const F2& x) { v &= x.v; }
inline void F2::operator/=(const F2& x) { assert(x.v); }

inline void F2::add(const F2& x1, const F2& x2, F2& x) { x.v=x1.v^x2.v; }
inline void F2::sub(const F2& x1, const F2& x2, F2& x) { x.v=x1.v^x2.v; }
inline void F2::mul(const F2& x1, const F2& x2, F2& x) { x.v=x1.v&x2.v; }
inline void F2::div(const F2& x1, const F2& x2, F2& x) { assert(x2.v); x.v=x1.v; }

inline int F2::getFieldCharacteristic() { return 2; }
inline int F2::getFieldExponent() { return 1; }

inline std::ostream& operator<<(std::ostream& os, const F2& x) { os << x.v; return os; } 
inline std::istream& operator>>(std::istream& is, F2& x) {
	is >> x.v;
	if (x.v % 2 == 0) { x.v = 0; } else { x.v = 1; }
	return is;
}

#endif
