#include "FP.h"
#include <iostream>

UINT FP::p = 0;
UINT* FP::inverse = 0;

void
FP::initialise(UINT _p)
{
	if (p) {
		std::cerr << "ERROR: cannot initialise FP class twice.\n";
		exit(1);
	}
	assert(_p);
	p = _p;
	inverse = new UINT[p];
	memset(inverse, 0, sizeof(UINT)*p);
	for (UINT i = 1; i < p; ++i) {
		if (!inverse[i]) {
			UINT j = compute_inverse(i);
			// If j the inverse of i, then i is the inverse of j.
			inverse[i] = j;
			inverse[j] = i;
		}
	}
}

UINT
FP::compute_inverse(UINT b)
{
	UINT a = p;

	int m0 = 0;
	int m1 = 1;

	int t = -1;
	int temp;
 
	while(b){
		temp=m0+(a/b)*m1;
		m0=m1;
		m1=temp;

		temp=a%b;
		a=b;
		b=temp;

		t*=-1;
	}

	m0*=t;
	if (m0 < 0) { m0 += p; }
	if (a != 1) { // a is the gcd of b and p.
		std::cerr << p << " is not a prime.\n";
		exit(1);
	}	
	return m0;
}
