#include "Graph.h"

#include <iostream>
#include <assert.h>

Graph::Edge::Edge(int _i, int _j)
{
    if (_i < _j) { i = _i; j = _j; } else { i = _j; j = _i; }
}

bool
Graph::Edge::operator<(const Edge& e) const
{
    if (i < e.i) { return true; }
    else if (i == e.i && j < e.j) { return true; }
    return false;
}

Graph::Graph(const int& num_v, const std::vector<Edge>& all_edges) :
	num_vertices(num_v), edges(all_edges), adj_list(num_v)
{
   //cout << "Graph::num_v = " << num_v << "\n";
   //cout << "Graph::num_e = " << edges.size() << "\n";

	/* note adj_list is indexed from 0 */
	for (size_t e = 0; e < edges.size(); e++) {
		adj_list[edges[e].i].push_back(edges[e].j);
		adj_list[edges[e].j].push_back(edges[e].i);
	}
}

/* adding the edge to the graph */ 
void Graph::addEdge(const int& i, const int& j)
{
	/* 
	 * Assume edges are not duplicated
	 */
	Edge e;
	e.i = i; e.j = j; 
	edges.push_back(e);

	/* add entry to adjacency list */
	/* assume we are not adding a new vertex */
	assert(e.i < num_vertices && e.j < num_vertices);
	assert(e.i > 0 && e.j > 0);
	adj_list[i].push_back(j);
	adj_list[j].push_back(i);
}

Graph::~Graph()
{
	/* clean up */
	edges.clear();
	adj_list.clear();
}

/* for debugging purposes */
void Graph::print_adj_list() const
{
	for (size_t i = 0; i < adj_list.size(); i++) {
		std::cout << i << " adj "; 
		for (size_t j = 0; j < adj_list[i].size(); j++) {
			std::cout << (adj_list[i])[j] << ", "; 
		}
		std::cout << "\n"; 
	}
}

void
Graph::get_spanning_tree(std::vector<int>& span)
{
    std::vector<bool> used(num_vertices, false);
}
