#ifndef GRAPH_H
#define GRAPH_H

#include <vector>

class Graph 
{  
public:
    /* struct for edge vertices */
    class Edge
    {
    public:
        Edge() {}
        Edge(const Edge& e) { i = e.i; j = e.j; }
        Edge(int _i, int _j);
        bool operator<(const Edge& e) const;
        int i;
        int j;
    };

private:
    /* total number of vertices in graph */
    int num_vertices;

    /* stores the list of edges */
    std::vector<Edge> edges;

    /* adjacency list for matrix */
    std::vector<std::vector<int> > adj_list;

public:
    /* default constructor */
    Graph(int n) : num_vertices(n), adj_list(n) {};

    /* standard constructor */
    Graph(const int&, const std::vector<Edge>&);

    virtual ~Graph();

    /* get total number of vertices in graph */
    int getNumVertices() const {return num_vertices;}; 

    /* get total number of vertices in graph */
    int getNumEdges() const {return (int) edges.size();};

    /* add edges to graph */
    void addEdge(const int&, const int&);

    const std::vector<Edge>& getEdges() const {return edges;};
    const Edge& getEdge(int i) const {return edges[i];};

    /* span is set to be a list of edges giving a spanning tree of the graph */
    /* it is assumed that the graph is connected. */
    void get_spanning_tree(std::vector<int>& span);

    /* get adj list, vertices are now indexed from 0 */
    const std::vector<std::vector<int> > getAdjList() const {return adj_list;};

    // Get the degree of the ith node.
    int getDegree(int i) const { return adj_list[i].size(); }

    /* for debugging purposes */
    void print_adj_list() const;
};

#endif
