#ifndef GRAPH_BUILDER_H
#define GRAPH_BUILDER_H

#include "Graph.h"

using namespace std;

/* wrapper class for GMP's polynomial number for exact arithmetic */
class GraphBuilder {
private:
    /* construct graph from file */
    Graph *get_file_instance(const char *);

    /* parsing the edge string (i,j) */ 
    void parse_edge(const string&, Graph::Edge *e);

    /* reading num_v and num_e from graph file */
    bool get_NumVertAndNumEdgefromDIMACSformat(const string &, int &, int &);

public:
    /* default constructor */
    GraphBuilder();

    /* destructor */
    ~GraphBuilder();

    /* construct graph from a file */
    Graph *buildGraph(const char *);
    /* construct a random graph */
    Graph *buildGraph(int n, float p);
};

#endif
