#include <fstream>
#include "F2.h"
#include "F4.h"
#include "FP.h"
#include "Q.h"
#include "IdealFactory.h"
#include "Polynomial.h"

IdealFactory::IdealFactory()
    : COMMENT('#')
{
}

IdealAPI*
IdealFactory::buildIdeal(const char* filename)
{
	std::ifstream in(filename);
	std::string line;
	std::string s;

	/* check if file opened sucessfully */	
	if (!in) {
		std::cout << "ERROR: Unable to open file " << filename << "\n";
		exit(1);
	}

	/* Strip comments. */
	while (in.peek() == COMMENT) { getline(in, line); }

	/* Find the characteristic of the field. */
	int fieldChar = 0;
	getline(in, line);
	if (sscanf(line.c_str(), "FIELD=F%d", &fieldChar) == 0) {
		std::cout << "ERROR! Field information for ideal not found.\n"; 
		exit(1);
	}

    IdealAPI* ideal = 0;

	switch (fieldChar) {
	case 0:
        ideal = buildIdeal<Q>(in);
		break;
	case 2:
        ideal = buildIdeal<F2>(in);
		break;
	case 4:
        ideal = buildIdeal<F4>(in);
		break;
	default:
		FP::initialise(fieldChar);
        ideal = buildIdeal<FP>(in);
	}

	in.close();

    return ideal;
}


