#include "MonExpEnum.h"
#include <stdlib.h> 
#include <string.h> 
#include <iostream>

using namespace std;

/* use initialization list which is faster */
MonExpEnum::MonExpEnum(int num_vars, int deg) :
		  n(num_vars), d(deg), next(num_vars)
{
	cur_col = 0;
	next[cur_col] = d;
}

MonExpEnum::~MonExpEnum()
{
}

void
MonExpEnum::reset_deg(int deg)
{
	/* reset degree, and all corresponding member variables */
	d = deg;
	cur_col = 0;
   next.set_constant(); // Set all exponents to zero.
	next[cur_col] = d;

   //print_debug();
}

bool
MonExpEnum::next_mon()
{
	if (is_last()) { return false; }

	// now calculate the "next next" exponent.
	if (cur_col < (n - 1)) {
		// decrement exp in cur_col, and then add it to the next variable
		// ...x[i]^k*x[i+1]^j... --> ....x[i]^(k-1)*x[i+1]^(j+1)...
		--next[cur_col];
		cur_col++;
		++next[cur_col];
	} else { // our current column is the last column
		// walk backwards from cur_col - 1 (currently n - 2), looking for the
		// first non-zero entry. There should always be a non-zero entry.
		int i = cur_col-1;
		while (!next[i]) { --i; }
	
		int tmp = next[cur_col];
		next[cur_col] = 0; // reset the current column.
		// having found our root parent, decrement and then add
		// deg + 1 (+ 1 for the decrementing of the parten) to the new cur_col
		--next[i];
		next[i+1] += tmp+1;
		cur_col = i+1;
	}

   return true;
}

bool
MonExpEnum::is_last() const
{
   /*
    * The enumerator is finished when the last column of next = d
	 * In other words, when x_n^d has already been returned.
	 * We exclude cur_col == 0 in case this is the d = 0 monomial
    */ 
	return (next[n - 1] == d);
}

void MonExpEnum::print_debug() {
   cout << "MonExpEnum:: Begin print_debug...\n";
   cout << "deg = " << d << ", cur_col = " << cur_col << ", n = " << n << "\n";
   cout << "next = ";
   for (int i = 0; i < n; i++) {
      cout << next[i] << ",";
   }
   cout << "\n";
   cout << "MonExpEnum:: End print_debug...\n";
}
