#ifndef _MonExpEnum_H
#define _MonExpEnum_H
#include "Monomial.h"

/*
 * This class enumerates all of the monomials of a given degree in a reverse
 * lexicographic ordering.
 * For example, all monomials of degree 2 in two variables are
 * x^2, xy, y^2
 */

class MonExpEnum
{  
   private:
      /* number of variables */ 
      int n; 
      /* degree of monomials */ 
      int d; 
      /* current column to increment */ 
      int cur_col; 
      /* next exp */ 
      Monomial next; 
      /* for debugging purposes  */ 
      void print_debug();

   public:
      /* constructor */
      MonExpEnum(int num_vars, int deg);
      /* destructor */
      ~MonExpEnum(); 
      /* dynamically set the degree of the monomials */ 
      void reset_deg(int deg);
      /* if the current monomial is the last  */ 
      bool is_last() const;
      /* get next exp */ 
      const Monomial& get_mon() const;
		/* update the next monomial. */
		bool next_mon();
};

inline
const Monomial&
MonExpEnum::get_mon() const
{
	return next;
}

#endif

