#include "MonomialGenerator.h"

using namespace std;

MonomialGenerator::MonomialGenerator(
					 const Monomial& m,
                     int min_degree,
					 int max_degree,
					 int offset,
                     int _poly)
		: curr_deg(0), mon_deg(0), poly(_poly),
		  orig_mon(m), enumerator(m.get_num_vars(), 0), mon(m)
{
	// Add the offset to the list of monomial indices.
	mon_indices.push_back(offset);
	// Construct the list of degrees from min_degree to max_degree.
	for (int i = min_degree; i <= max_degree; ++i) { degrees.push_back(i); }
	// Compute the degree of the monomial.
	for (int i = 0; i < mon.get_num_vars(); ++i) { mon_deg += mon[i]; }
}

// NB: degrees is a list of degrees that is assumed to be sorted in increasing
// order.
MonomialGenerator::MonomialGenerator(
					 const Monomial& m,
					 const std::vector<int>& degs,
					 int offset)
		: degrees(degs), curr_deg(0), mon_deg(0),
		  orig_mon(m), enumerator(m.get_num_vars(), 0), mon(m)
{
	// Add the offset to the list of monomial indices.
	mon_indices.push_back(offset);
	// Set the first degree.
	assert(!degrees.empty());
	if (degrees[0] != 0) {
		enumerator.reset_deg(degrees[0]);
		const Monomial& gen = enumerator.get_mon();
		Monomial::mul(gen, orig_mon, mon);
	}
	// Compute the degree of the monomial.
	for (int i = 0; i < mon.get_num_vars(); ++i) { mon_deg += mon[i]; }
}

// NB: degrees is a list of degrees that is assumed to be sorted in increasing
// order.
MonomialGenerator::MonomialGenerator(
					 const Monomial& m,
					 const std::vector<int>& degs,
					 const std::vector<int>& indices)
		: degrees(degs), curr_deg(0), mon_deg(0), mon_indices(indices),
		  orig_mon(m), enumerator(m.get_num_vars(), 0), mon(m)
{
	// Set the first degree.
	assert(!degrees.empty());
	if (degrees[0] != 0) {
		enumerator.reset_deg(degrees[0]);
		const Monomial& gen = enumerator.get_mon();
		Monomial::mul(gen, orig_mon, mon);
	}
	// Compute the degree of the monomial.
	for (int i = 0; i < mon.get_num_vars(); ++i) { mon_deg += mon[i]; }
}

bool
MonomialGenerator::next_mon()
{
	if (!enumerator.next_mon()) {
		++curr_deg;
		if (curr_deg >= (int) degrees.size()) { return false; }
		mon_deg += degrees[curr_deg] - degrees[curr_deg-1];
		enumerator.reset_deg(degrees[curr_deg]);
	}
	const Monomial& gen = enumerator.get_mon();
	Monomial::mul(gen, orig_mon, mon);
	for (size_t i = 0; i < mon_indices.size(); ++i) { mon_indices[i]++; }

	return true;
}

bool
mg_cmp(const MonomialGenerator* mg1, const MonomialGenerator* mg2)
{
	return (*mg2) < (*mg1);
}
