#ifndef _TermGenerator_H
#define _TermGenerator_H

#include "MonomialGenerator.h"

template <class K>
class TermGenerator : public MonomialGenerator
{
	public:
		/** Constructor. */
		TermGenerator(
							const Term<K>& t,
							int max_degree,
							int min_degree,
							int offset,
                            int poly = 0);
		/** Constructor. */
		TermGenerator(
							const Term<K>& t,
							const std::vector<int>& degrees,
							int offset);
		/** Constructor. */
		TermGenerator(
							const Monomial& m,
							const std::vector<int>& degrees,
							const std::vector<int>& offsets,
							const std::vector<K>& coeffs);

		/** Get the coefficient of the monomial. */
		const K& get_coeff() const;
		/** Get the coefficients of the monomial. */
		const std::vector<K>& get_coeffs() const;

	private:
		/// The coefficients of the generated monomial.
		std::vector<K> coeffs;
};

template <class K>
inline const std::vector<K>&
TermGenerator<K>::get_coeffs() const
{
	return coeffs;
}

template <class K>
inline const K&
TermGenerator<K>::get_coeff() const
{
	assert(coeffs.size() == 1);
	return coeffs[0];
}

/** Constructor. */
template <class K>
inline
TermGenerator<K>::TermGenerator(
			const Term<K>& t,
			int min_degree,
			int max_degree,
			int offset,
            int poly)
		: MonomialGenerator(t.mon, min_degree, max_degree, offset, poly)
{
	coeffs.push_back(t.coeff);
}

/** Constructor. */
template <class K>
inline
TermGenerator<K>::TermGenerator(
			const Term<K>& t,
			const std::vector<int>& degrees,
			int offset)
		: MonomialGenerator(t.mon, degrees, offset)
{
	coeffs.push_back(t.coeff);
}

/** Constructor. */
template <class K>
inline
TermGenerator<K>::TermGenerator(
			const Monomial& m,
			const std::vector<int>& degrees,
			const std::vector<int>& offsets,
			const std::vector<K>& _coeffs)
		: MonomialGenerator(m, degrees, offsets), coeffs(_coeffs)
{
}

#endif
