#ifndef _Util_H_
#define _Util_H_

#include "Z.h"
#include "Q.h"

/* number of monomials of degree d is n + d - 1 choose n - 1 */
inline
int
calculate_num_d_monomials(int n, int d)
{
    mpz_t ROP;
    int num_m;

    mpz_init(ROP);
    mpz_bin_uiui(ROP, n + d - 1, n - 1);
    num_m = mpz_get_ui(ROP);

    /* clean up */
    mpz_clear(ROP);

    return (num_m);
}

/*
 ** The number of monomials of degree less than or equal to d is n + d choose n.
 */
inline
int
calculate_num_lte_d_monomials(int n, int d)
{
    mpz_t ROP;
    int num_m;

    mpz_init(ROP);
    mpz_bin_uiui(ROP, n + d, n);
    num_m = mpz_get_ui(ROP);

    /* clean up */
    mpz_clear(ROP);

    return (num_m);
}


#endif
