#include "NullstellensatzFactory.h"


using namespace std;


TestSGE::TestSGE(): ls(0), rowSize(0), colSize(0), prob(0)
{
	seed = time(NULL);
	srand(seed);
    // int = rand() % 10 + 1 ==> 1 to 10
}
// ----------------------------------------------------------------------------------------

//adds [A*x].

void TestSGE::addRHSb_fromX()
{
	vector<int> b;
	ls->matrixVectorMultiplication(xVar, b);

	
	
	//if ( count_if( b.begin(), b.end(), bind2nd(greater<int>(), rowSize-1)))
	//	throw exception();
	
	for(int i = 0; i < (int) b.size(); ++i)
		if ( b[i] >= rowSize) {
			cout << "error TestSGE::addRHSb_fromX() b[i]=" << b[i] << " rowSiz=" << rowSize << " i=" << i << endl;
			exit(1);
		}
		else 
			ls->addRHSEntry(b[i], 1); //
}

// ----------------------------------------------------------------------------------------

//adds [x].

void TestSGE::addRHSb_justX()
{
	if ( count_if( xVar.begin(), xVar.end(), bind2nd(greater<int>(), rowSize)))
		throw exception();
		
	for(int i = 0; i < (int) xVar.size(); ++i)
		ls->addRHSEntry(xVar[i], 1); //add 1 to row xVar[i];
}

// ----------------------------------------------------------------------------------------

void TestSGE::clear()
{
	if(ls) {
		delete(ls);
		ls = 0;
	}
	xVar.clear();
	rowSize = colSize = 0;
	prob = 0;
	
}

// ----------------------------------------------------------------------------------------

const char * TestSGE::printProb(double num) const
{

    stringstream outString;               //print to string

	outString << setiosflags(ios::fixed) << setprecision(8) << num;
	string answer = string( outString.str() );
	return answer.substr(2, answer.length()).c_str();
}

// ----------------------------------------------------------------------------------------


//loops over each element

void TestSGE::setRandomMatrixClass1()   
{
	if (! ls)
		ls = new LinearSystem<F2>(1);	
	
	
	//             make room for b
	ls->updateRowCol(rowSize, colSize + 1);
	xVar.clear();
	
	
    for(int i = 0; i < rowSize; ++i)
    	for(int j = 0; j < colSize; ++j)
    		if ( rand() < prob * (double) RAND_MAX)
    			ls->addEntry(i,j);		
				
	for(int i = 0; i < colSize; ++i)
		if (rand() < prob)
			xVar.push_back(i); 
			
	addRHSb_fromX();
}//setRandomMatrisClass1     

// ----------------------------------------------------------------------------------------

//fills (row*col*prob) elements randomly

void TestSGE::setRandomMatrixClass2()
{
	int currentCount = 0, value;
	
	if(! ls)
		ls = new LinearSystem<F2>(1);
		
	//             make room for b
	
	ls->updateRowCol(rowSize, colSize + 1);
	xVar.clear();
	
	while ( currentCount <= ((double)rowSize * ((double) colSize * prob)) ) {
		if (ls->addEntryIfNoExist( rand() % rowSize, rand() % colSize) )
			currentCount++;
			
		//if ( currentCount % 50000 == 0)
		if ( currentCount % 100000 == 0 ) 
			cout << currentCount << endl;
	}//while. build matrix.

/*	
	if ( ls->getNumNonZeros() == 0)
	{
		cout << " rowSize=" << rowSize
		     << " colSize=" << colSize
		     << " prob="    << prob
		     << " currentcount=" << currentCount
		     << " (times)=" << ((double)rowSize * ((double) colSize * prob))
		     << '\n';
		     
	   
		ls->print();
		cout << "exit called in TestSGE::setRandomMatrixClass2()\n";
		exit(1);
	}
*/		     

	currentCount = 0;
	while ( currentCount <= ( (double) colSize * prob)) {
		value = rand() % colSize;
		if ( xVar.end() == find(xVar.begin(), xVar.end(), value)) {
			xVar.push_back(value);
			currentCount++;
		}
	}//while. build xVar
	sort(xVar.begin(), xVar.end());

	addRHSb_fromX();

}//setRandomMatrixClass2

// ----------------------------------------------------------------------------------------


void TestSGE::setValues(int _rowSize, int _colSize, double _prob)
{
	rowSize = _rowSize;
	colSize = _colSize;
	prob    = _prob;
	prob    = _prob;
}

// ----------------------------------------------------------------------------------------
bool TestSGE::testClass(double & timeEnd_ge, double & timeEnd_sge)
{
    bool solved_ge, solved_sge;
	double start;
	long int numNonZero;
    LinearSystem<F2> * ls_ge;
	
	numNonZero = ls->getNumNonZeros();
	

	
	ls_ge = new LinearSystem<F2>(*ls);

	start = tic();
	solved_ge = ls_ge->isConsistent(0); //normal_ge_consistent();
	timeEnd_ge = toc(start);
	delete ls_ge;
	

	
	start = tic();
	solved_sge = ls->isConsistent(1); //striped_ge_consistent();
	timeEnd_sge = toc(start);
	

	
	cout << "SGE: " << timeEnd_sge << " VS. "<< "GE: " << timeEnd_ge 
	     << "  Stats: [" << rowSize << "," << colSize << "] " << " fill=" << numNonZero << " prob=" << prob << '\n';
	
	
	
	if ( solved_ge == solved_sge )	
	{
		if (solved_ge)
			cout << "true\n";
		else
			cout << "false\n"; 
		return solved_ge;
	}
	else
	{
		cout <<  "solved_ge =" << solved_ge << ", solved_sge=" << solved_sge << endl; 
		throw exception();
	}

	return false; //never gets called. Need this to please g++ -Wall.

}

// ----------------------------------------------------------------------------------------
/*
 * Same as testClass() only with 3 functions
 */
bool TestSGE::testClass(double & timeEnd_ge, double & timeEnd_sge, double & timeEnd_sge_noGC)
{
    bool solved_ge, solved_sge, solved_sge_noGC;
	double start;
	long int numNonZero;
    LinearSystem<F2> * ls2;
	
	numNonZero = ls->getNumNonZeros();
	

	
	ls2 = new LinearSystem<F2>(*ls);

	start = tic();
	solved_ge = ls2->isConsistent(0); //normal_ge_consistent();
	timeEnd_ge = toc(start);
	delete ls2;
	
	
	ls2 = new LinearSystem<F2>(*ls);
	start = tic();
	solved_sge_noGC = ls2->isConsistent(2);//striped_ge_noGrayCode_consistent();
	timeEnd_sge_noGC = toc(start);
	delete ls2;

	ls2 = new LinearSystem<F2>(*ls);
	start = tic();
	solved_sge = ls2->isConsistent(1); //striped_ge_consistent();
	timeEnd_sge = toc(start);
	delete ls2;
	

	
	cout << "SGE: " << timeEnd_sge << " VS. " << "SGE_noGC: " << timeEnd_sge_noGC << " VS. " << "GE: " << timeEnd_ge 
	     << "  Stats: [" << rowSize << "," << colSize << "] " << " fill=" << numNonZero << " prob=" << prob << '\n';
	
	
	
	if ( solved_ge == solved_sge && solved_sge_noGC == solved_ge )	
	{
		if (solved_ge)
			cout << "true\n";
		else
			cout << "false\n"; 
		return solved_ge;
	}
	else
	{
		cout <<  "solved_ge =" << solved_ge << ", solved_sge=" << solved_sge << ", solved_sge_noGC=" << solved_sge_noGC << endl; 
		throw exception();
	}

	return false; //never gets called. Need this to please g++ -Wall.


}

// ----------------------------------------------------------------------------------------

//sge vs ge for class 1 matrix.
//assumes setValues has been called.

bool TestSGE::testClass1(double & time_ge, double & time_sge)
{
	setRandomMatrixClass1() ;
	
	return testClass(time_ge, time_sge);
}//testClass1 

// ----------------------------------------------------------------------------------------

bool TestSGE::testClass2(double & time_ge, double & time_sge)
{
	setRandomMatrixClass2() ;
	
	return testClass(time_ge, time_sge);
}//testClass1 

// ----------------------------------------------------------------------------------------


bool TestSGE::testClass4(double & time_ge, double & time_sge, double & time_sge_noGC)
{
	setRandomMatrixClass2() ;
	
	return testClass(time_ge, time_sge, time_sge_noGC);
}//testClass1 


// ----------------------------------------------------------------------------------------        

//loops over all the element.
//Do not use, it takes too long on larger matrices.
void TestSGE::testRangeClass1(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{

    int row, col;
    double time_ge, time_sge;
	

	
	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass1(time_ge, time_sge);
			cout << "not saving times\n";
		}

}


// ---------------------------------------------------------------------------------------- 

void TestSGE::testRangeClass2(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{
	int row, col;						 //current row and col size.
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge;
	
	             //        |--> type 2
	outString << "testFiles/testRange2_" << startRow << "_" << startCol << "_" << endRow << "_" 
							     << endCol << "_" << printProb(_prob) << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_ge.open  ((baseFileName + string("_ge.csv")).c_str() );
    
				     

	
	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass2(time_ge, time_sge);
			writeTimes(time_ge, time_sge, col == startCol, row == startRow, (col + stepSize > endCol));
		}
		
	timeFile_sge.close();
	timeFile_ge.close();
	
	writeMfile(startRow, startCol, endRow, endCol, _prob, stepSize, baseFileName);	

}

// ----------------------------------------------------------------------------------------
/*
 * Same as testRangeClass2 only tests 3 functions.
 */
void TestSGE::testRangeFunct3(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{
	int row, col;						 //current row and col size.
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge, time_sge_noGC;
	
	             //        |--> type 2
	outString << "testFiles/testRange4_" << startRow << "_" << startCol << "_" << endRow << "_" 
							     << endCol << "_" << printProb(_prob) << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open      ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_sge_noGC.open ((baseFileName + string("_sgeNoGC.csv")).c_str() );
	timeFile_ge.open       ((baseFileName + string("_ge.csv")).c_str() );
    

	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass4(time_ge, time_sge, time_sge_noGC);
			writeTimes4(time_ge, time_sge, time_sge_noGC, col == startCol, row == startRow, (col + stepSize > endCol));
		}
		
	timeFile_sge.close();
	timeFile_ge.close();
	timeFile_sge_noGC.close();
	
	
	writeMfile4(startRow, startCol, endRow, endCol, _prob, stepSize, baseFileName);	


}


// ----------------------------------------------------------------------------------------

//vary the fill in.
void TestSGE::testRangeProbability(int oneRow, int oneCol, double startProb, double endProb, double probStepSize)
{
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge;
	
	             
	outString << "testFiles/testProb3_" << oneRow << "_" << oneCol << "_" << printProb(startProb) << "_"
	          << printProb(endProb) << "_" << printProb(probStepSize);
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_ge.open  ((baseFileName + string("_ge.csv")).c_str() );
    
    
	for(double currentProb = startProb; currentProb <= endProb; currentProb = currentProb + probStepSize) {
		clear();
		setValues(oneRow, oneCol, currentProb);
		testClass2(time_ge, time_sge);
		writeTimesProb(time_ge, time_sge, (currentProb + probStepSize > endProb));
	}
		
	timeFile_sge.close();
	timeFile_ge.close();
	
	writeMfileProb(oneRow, oneCol, startProb, endProb, probStepSize, baseFileName)	;


}


// ---------------------------------------------------------------------------------------- 

void TestSGE::writeTimes(double time_ge, double time_sge, bool col, bool row, bool printCamma)
{
	if ( col && ! row ) {
		timeFile_sge << '\n';
		timeFile_ge  << '\n';
	}
	timeFile_sge << time_sge << ( printCamma ?  "" : "," ) ;
	timeFile_ge  << time_ge  << ( printCamma ?  "" : "," ) ;
}
// ----------------------------------------------------------------------------------------


void TestSGE::writeTimes4(double time_ge, double time_sge,  double time_sge_noGC, bool col, bool row, bool printCamma)
{
	if ( col && ! row ) {
		timeFile_sge      << '\n';
		timeFile_ge       << '\n';
		timeFile_sge_noGC << '\n';
	}
	timeFile_sge       << time_sge       << ( printCamma ?  "" : "," ) ;
	timeFile_ge        << time_ge        << ( printCamma ?  "" : "," ) ;
	timeFile_sge_noGC  << time_sge_noGC  << ( printCamma ?  "" : "," ) ;
}

// ----------------------------------------------------------------------------------------
//write times for different probability
void TestSGE::writeTimesProb(double time_ge, double time_sge, bool printLast)
{
	timeFile_sge << time_sge << ( printLast ?  "" : "," ) ;
	timeFile_ge  << time_ge  << ( printLast ?  "" : "," ) ;
}
	



// ----------------------------------------------------------------------------------------

void TestSGE::writeMfile(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName)	
{

	string fileSGE = baseFileName + string("_sge.csv");
	string fileGE  = baseFileName + string("_ge.csv");
	ofstream mFile;
	


	mFile.open ((baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "[timeMatrix_col, timeMatrix_row] = meshgrid( " << startCol << ":" << stepSize << ":" << endCol <<  " , " << startRow << ":" << stepSize << ":" << endRow << " );\n";
    mFile << "geTimes = csvread('" << fileGE.c_str() << "');\n"; 
    mFile << "sgeTimes = csvread('" << fileSGE.c_str() << "');\n"; 
    

    mFile << "figure;\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, geTimes, 'FaceColor','green');\n"
    	  << "hold on\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, sgeTimes, 'FaceColor','red');\n"
    	  << "alpha(.4);\n"
    	  << "xlabel('Row Size');\n"
    	  << "ylabel('Col Size');\n"
    	  << "zlabel('Time (sec)');\n"
    	  << "legend('GE','Striped GE',2)\n"
    	  << "title('StripedGE vs GE with Std. Gray Code in C++, " << _prob << "');\n"
    	  << "hold off";
    
	mFile.close();
}

void TestSGE::writeMfile4(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName)
{
	string fileSGE      = baseFileName + string("_sge.csv");
	string fileGE       = baseFileName + string("_ge.csv");
	string fileSGE_noGC = baseFileName + string("_sgeNoGC.csv");
	ofstream mFile;
	


	mFile.open ((baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "[timeMatrix_col, timeMatrix_row] = meshgrid( " << startCol << ":" << stepSize << ":" << endCol <<  " , " << startRow << ":" << stepSize << ":" << endRow << " );\n";
    mFile << "geTimes = csvread('" << fileGE.c_str() << "');\n"; 
    mFile << "sgeTimes = csvread('" << fileSGE.c_str() << "');\n"; 
    mFile << "sgeNoGCTimes = csvread('" << fileSGE_noGC.c_str() << "');\n"; 
    

    mFile << "figure;\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, geTimes, 'FaceColor','green');\n"
    	  << "hold on\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, sgeTimes, 'FaceColor','red');\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, sgeNoGCTimes, 'FaceColor','blue');\n"
    	  << "alpha(.4);\n"
    	  << "xlabel('Row Size');\n"
    	  << "ylabel('Col Size');\n"
    	  << "zlabel('Time (sec)');\n"
    	  << "legend('GE','Striped GE', 'Striped GE w/o Gray Codes', 3)\n"
    	  << "title('GE vs Striped GE with Std. Gray Code vs Striped GE w/o Gray Code in C++, " << _prob << "');\n"
    	  << "hold off";
    
	mFile.close();

}



// ---------------------------------------------------------------------------------------- 

//write an m-file script to graph ge vs sge. 2d plot
void TestSGE::writeMfileProb(int oneRow, int oneCol, double startProb, double endProb, double probStepSize, const string & baseFileName)
{
	string fileSGE = baseFileName + string("_sge.csv");
	string fileGE  = baseFileName + string("_ge.csv");
	ofstream mFile;
	
	


	mFile.open ((baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "geTimes = csvread('" << fileGE.c_str() << "');\n"; 
    mFile << "sgeTimes = csvread('" << fileSGE.c_str() << "');\n"; 
    
    mFile << "prob = [";

    double currentProb;
    for( currentProb = startProb; currentProb <= endProb; currentProb = currentProb + probStepSize) {
    	if ( (currentProb + probStepSize) > endProb)
    		mFile << setiosflags(ios::fixed) << setprecision(8)  << currentProb << "";
    	else
    	   	mFile << setiosflags(ios::fixed) << setprecision(8)  << currentProb << ", ";
    }
    mFile << " ];\n";


    
//    << startProb << ":" << probStepSize << ":" << endProb << ";\n";
    

    mFile << "figure;\n"
    	  << "plot(prob, geTimes, '--gd');\n"
    	  << "hold on\n"
    	  << "plot(prob, sgeTimes, '--ro');\n"
    	  << "xlabel('Fill in');\n"
    	  << "ylabel('Time (sec)');\n"
    	  << "legend('GE','Striped GE',2)\n"
    	  << "title('StripedGE vs GE with Std. Gray Code in C++, [" << oneRow << " , " << oneCol  << "]');\n"
    	  << "hold off";    
    
	mFile.close();
}
	
	


