#ifndef _NullstellensatzFactory_H_
#define _NullstellensatzFactory_H_

#include <string>
#include <sstream>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <ctime>
#include <vector>
#include <exception>
#include "Nullstellensatz.h"
#include "IdealFactory.h"
#include "Index.h"
#include "MyTime.h"
#include "Ideal.h" 
#include "LinearSystem.h" 
#include "LinearSystemF2.h"
#include "TermGenerator.h"
#include "MonExpEnum.h"
#include "Polynomial.h"
#include "Util.h"
#include "Q.h"
#include "F2.h"
#include "F4.h"
#include "FP.h"

using namespace std;


class TestSGE
{
private:

  
	LinearSystem<F2>* ls;
	int rowSize, colSize;
	double prob;
	vector<int> xVar;                    //Ax = b
 	ofstream timeFile_sge;
	ofstream timeFile_ge; 
	ofstream timeFile_sge_noGC; 		//sge w/o gray codes  
	int seed;							//for srand()
  
    void addRHSb_fromX();   
    
    const char * printProb(double num) const;
    
                 //adds [A*x].
	void TestSGE::addRHSb_justX();       //adds [b]
	bool testClass(double & time_ge, double & time_sge);
	bool testClass(double & time_ge, double & time_sge, double & time_sge_noGC);
	
	//write times for differnet sizes
	void writeTimes(double time_ge, double time_sge,  bool col, bool row, bool printCamma);		
	void writeTimes4(double time_ge, double time_sge,  double time_sge_noGC, bool col, bool row, bool printCamma);	
	
	//write times for different probability
	void writeTimesProb(double time_ge, double time_sge, bool printLast);                       

	
	void writeMfile(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName);     //write an m-file script to graph ge vs sge. 3d plot
	void writeMfile4(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName);	
	void writeMfileProb(int oneRow, int oneCol, double startProb, double endProb, double probStepSize, const string & baseFileName); //write an m-file script to graph ge vs sge. 2d plot
	
public:  
	TestSGE();
	//A B C D E F G H I J K L M N O P Q R S T U V W X Y Z

	void clear();
	void setRandomMatrixClass1();        //loops through each element
	void setRandomMatrixClass2();        //fills (row*col*prob) elements randomly
    void setValues(int _rowSize, int _colSize, double _prob);
	
		
	bool testClass1(double & time_ge, double & time_sge);                         //sge vs ge for class 1 matrix.
	bool testClass2(double & time_ge, double & time_sge);                         //sge vs ge for class 2 matrix.
	bool testClass4(double & time_ge, double & time_sge, double & time_sge_noGC); //sge vs ge vs sgeNoGC for class 2 matrix.
	void testRangeClass1(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testRangeClass2(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testRangeFunct3(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testRangeProbability(int oneRow, int oneCol, double startProb, double endProb, double probStepSize); //vary the fill in.
};

#endif
