#include "tSGE.h"


using namespace std;


TestSGE::TestSGE(int s): ls(0), rowSize(0), colSize(0), prob(0)
{
	if ( s )
		seed = s;
	else
		seed = time(NULL);
	srand(seed);
    // int = rand() % 10 + 1 ==> 1 to 10
}
// ----------------------------------------------------------------------------------------

//adds [A*x].

void TestSGE::addRHSb_fromX()
{
	vector<int> b;
	ls->matrixVectorMultiplication(xVar, b);

	
	
	//if ( count_if( b.begin(), b.end(), bind2nd(greater<int>(), rowSize-1)))
	//	throw exception();
	
	for(int i = 0; i < (int) b.size(); ++i)
		if ( b[i] >= rowSize) {
			cout << "error TestSGE::addRHSb_fromX() b[i]=" << b[i] << " rowSiz=" << rowSize << " i=" << i << endl;
			exit(1);
		}
		else 
			ls->addRHSEntry(b[i], 1); //
}

// ----------------------------------------------------------------------------------------

//adds [x].

void TestSGE::addRHSb_justX()
{
	if ( count_if( xVar.begin(), xVar.end(), bind2nd(greater<int>(), rowSize)))
		throw exception();
		
	for(int i = 0; i < (int) xVar.size(); ++i)
		ls->addRHSEntry(xVar[i], 1); //add 1 to row xVar[i];
}

// ----------------------------------------------------------------------------------------

void TestSGE::clear()
{
	if(ls) {
		delete(ls);
		ls = 0;
	}
	xVar.clear();
	rowSize = colSize = 0;
	prob = 0;
	
}

// ----------------------------------------------------------------------------------------

const string TestSGE::printProb(double num) const
{

    stringstream outString;               //print to string

	outString << setiosflags(ios::fixed) << setprecision(8) << num;
	string answer = string( outString.str() );
	return answer.substr(2, answer.length());
}

// ----------------------------------------------------------------------------------------


//loops over each element

void TestSGE::setRandomMatrixClass1()   
{
	if (! ls)
		ls = new LinearSystem<F2>(1);	
	
	
	//             make room for b
	ls->updateRowCol(rowSize, colSize + 1);
	xVar.clear();
	
	
    for(int i = 0; i < rowSize; ++i)
    	for(int j = 0; j < colSize; ++j)
    		if ( rand() < prob * (double) RAND_MAX)
    			ls->addEntry(i,j);		
				
	for(int i = 0; i < colSize; ++i)
		if (rand() < prob)
			xVar.push_back(i); 
			
	addRHSb_fromX();
}//setRandomMatrisClass1     

// ----------------------------------------------------------------------------------------

//fills (row*col*prob) elements randomly

void TestSGE::setRandomMatrixClass2()
{
	int currentCount = 0, value;
	
	if(! ls)
		ls = new LinearSystem<F2>(1);
		
	//             make room for b
	
	ls->updateRowCol(rowSize, colSize + 1);
	xVar.clear();
	
	while ( currentCount <= ((double)rowSize * ((double) colSize * prob)) ) {
		if (ls->addEntryIfNoExist( rand() % rowSize, rand() % colSize) )
			currentCount++;
			
		//if ( currentCount % 50000 == 0)
		if ( currentCount % 100000 == 0 ) 
			cout << currentCount << endl;
	}//while. build matrix.

/*	
	if ( ls->getNumNonZeros() == 0)
	{
		cout << " rowSize=" << rowSize
		     << " colSize=" << colSize
		     << " prob="    << prob
		     << " currentcount=" << currentCount
		     << " (times)=" << ((double)rowSize * ((double) colSize * prob))
		     << '\n';
		     
	   
		ls->print();
		cout << "exit called in TestSGE::setRandomMatrixClass2()\n";
		exit(1);
	}
*/		     

	currentCount = 0;
	while ( currentCount <= ( (double) colSize * prob)) {
		value = rand() % colSize;
		if ( xVar.end() == find(xVar.begin(), xVar.end(), value)) {
			xVar.push_back(value);
			currentCount++;
		}
	}//while. build xVar
	sort(xVar.begin(), xVar.end());

	addRHSb_fromX();

}//setRandomMatrixClass2

// ----------------------------------------------------------------------------------------


void TestSGE::setValues(int _rowSize, int _colSize, double _prob)
{
	rowSize = _rowSize;
	colSize = _colSize;
	prob    = _prob;
	prob    = _prob;
}

// ----------------------------------------------------------------------------------------
bool TestSGE::testClass(double & timeEnd_ge, double & timeEnd_sge)
{
    bool solved_ge, solved_sge;
	double start;
	long int numNonZero;
    LinearSystem<F2> * ls_ge;
	
	numNonZero = ls->getNumNonZeros();
	

	
	ls_ge = new LinearSystem<F2>(*ls);

	start = tic();
	solved_ge = ls_ge->isConsistent(0); //normal_ge_consistent();
	timeEnd_ge = toc(start);
	delete ls_ge;
	

	
	start = tic();
	solved_sge = ls->isConsistent(1); //striped_ge_consistent();
	timeEnd_sge = toc(start);
	

	
	cout << "SGE: " << timeEnd_sge << " VS. "<< "GE: " << timeEnd_ge 
	     << "  Stats: [" << rowSize << "," << colSize << "] " << " fill=" << numNonZero << " prob=" << prob << '\n';
	
	
	
	if ( solved_ge == solved_sge )	
	{
		if (solved_ge)
			cout << "true\n";
		else
			cout << "false\n"; 
		return solved_ge;
	}
	else
	{
		cout <<  "solved_ge =" << solved_ge << ", solved_sge=" << solved_sge << endl; 
		throw exception();
	}

	return false; //never gets called. Need this to please g++ -Wall.

}

// ----------------------------------------------------------------------------------------
/*
 * Same as testClass() only with 3 functions
 */
bool TestSGE::testClass(double & timeEnd_ge, double & timeEnd_sge, double & timeEnd_sge_noGC)
{
    bool solved_ge, solved_sge, solved_sge_noGC;
	double start;
	long int numNonZero;
    LinearSystem<F2> * ls2;
	
	numNonZero = ls->getNumNonZeros();
	

	
	ls2 = new LinearSystem<F2>(*ls);

	start = tic();
	solved_ge = ls2->isConsistent(0); //normal_ge_consistent();
	timeEnd_ge = toc(start);
	delete ls2;
	
	
	ls2 = new LinearSystem<F2>(*ls);
	start = tic();
	solved_sge_noGC = ls2->isConsistent(3);//was 2=striped_ge_noGrayCode_consistent(); 3=striped_ge_original();
	timeEnd_sge_noGC = toc(start);
	delete ls2;

	ls2 = new LinearSystem<F2>(*ls);
	start = tic();
	solved_sge = ls2->isConsistent(1); //striped_ge_consistent();
	timeEnd_sge = toc(start);
	delete ls2;
	

	
	cout << "SGE: " << timeEnd_sge << " VS. " << "SGE_noGC: " << timeEnd_sge_noGC << " VS. " << "GE: " << timeEnd_ge 
	     << "  Stats: [" << rowSize << "," << colSize << "] " << " fill=" << numNonZero << " prob=" << prob << '\n';
	
	
	
	if ( solved_ge == solved_sge && solved_sge_noGC == solved_ge )	
	{
		if (solved_ge)
			cout << "true\n";
		else
			cout << "false\n"; 
		return solved_ge;
	}
	else
	{
		cout <<  "solved_ge =" << solved_ge << ", solved_sge=" << solved_sge << ", solved_sge_noGC=" << solved_sge_noGC << endl; 
		throw exception();
	}

	return false; //never gets called. Need this to please g++ -Wall.


}

// ----------------------------------------------------------------------------------------

//sge vs ge for class 1 matrix.
//assumes setValues has been called.

bool TestSGE::testClass1(double & time_ge, double & time_sge)
{
	setRandomMatrixClass1() ;
	
	return testClass(time_ge, time_sge);
}//testClass1 

// ----------------------------------------------------------------------------------------

bool TestSGE::testClass2(double & time_ge, double & time_sge)
{
	setRandomMatrixClass2() ;
	
	return testClass(time_ge, time_sge);
}//testClass1 

// ----------------------------------------------------------------------------------------


bool TestSGE::testClass4(double & time_ge, double & time_sge, double & time_sge_noGC)
{
	
	setRandomMatrixClass2() ;
	return testClass(time_ge, time_sge, time_sge_noGC);
}//testClass1 


/*
 * Same as  testClass but with dufferent functions.
*/
bool TestSGE::testClass7(double & timeEnd_ge, double & timeEnd_sge, double & timeEnd_sge_original)//sge vs ge vs sge original
{
	setRandomMatrixClass2();


    bool solved_ge, solved_sge, solved_sge_original;
	double start;
	long int numNonZero;
    LinearSystem<F2> * ls2;
	
	numNonZero = ls->getNumNonZeros();
	

	
	ls2 = new LinearSystem<F2>(*ls);

	start = tic();
	solved_ge = ls2->isConsistent(0); //normal_ge_consistent();
	timeEnd_ge = toc(start);
	delete ls2;
	
	
	ls2 = new LinearSystem<F2>(*ls);
	start = tic();
	solved_sge_original = ls2->isConsistent(3);//striped_ge_original();
	timeEnd_sge_original = toc(start);
	delete ls2;

	ls2 = new LinearSystem<F2>(*ls);
	start = tic();
	solved_sge = ls2->isConsistent(1); //striped_ge_consistent();
	timeEnd_sge = toc(start);
	delete ls2;
	

	
	cout << "SGE: " << timeEnd_sge << " VS. " << "SGE_original: " << timeEnd_sge_original << " VS. " << "GE: " << timeEnd_ge 
	     << "  Stats: [" << rowSize << "," << colSize << "] " << " fill=" << numNonZero << " prob=" << prob << '\n';
	
	
	
	if ( solved_ge == solved_sge && solved_sge_original == solved_ge )	
	{
		if (solved_ge)
			cout << "true\n";
		else
			cout << "false\n"; 
		return solved_ge;
	}
	else
	{
		cout <<  "solved_ge =" << solved_ge << ", solved_sge=" << solved_sge << ", solved_sge_original=" << solved_sge_original << endl; 
		ls->print_dense();
		throw exception();
	}

	return false; //never gets called. Need this to please g++ -Wall.
}




// ----------------------------------------------------------------------------------------        

//loops over all the element.
//Do not use, it takes too long on larger matrices.
void TestSGE::testRangeClass1(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{

    int row, col;
    double time_ge, time_sge;
	

	
	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass1(time_ge, time_sge);
			cout << "not saving times\n";
		}

}


// ---------------------------------------------------------------------------------------- 

void TestSGE::testRangeClass2(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{
	int row, col;						 //current row and col size.
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge;
	
	             //        |--> type 2
	outString << "testFiles/testRange2_" << startRow << "_" << startCol << "_" << endRow << "_" 
							     << endCol << "_" << printProb(_prob).c_str() << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_ge.open  ((baseFileName + string("_ge.csv")).c_str() );
    
				     

	
	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass2(time_ge, time_sge);
			writeTimes(time_ge, time_sge, col == startCol, row == startRow, (col + stepSize > endCol));
		}
		
	timeFile_sge.close();
	timeFile_ge.close();
	
	writeMfile(startRow, startCol, endRow, endCol, _prob, stepSize, baseFileName);	

}

// ----------------------------------------------------------------------------------------
/*
 * Same as testRangeClass2 only tests 3 functions.
 */
void TestSGE::testRangeFunct3(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{
	int row, col;						 //current row and col size.
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge, time_sge_noGC;
	
	             //        |--> type 2
	outString << "testFiles/testRange4_" << startRow << "_" << startCol << "_" << endRow << "_" 
							     << endCol << "_" << printProb(_prob).c_str() << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open      ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_sge_noGC.open ((baseFileName + string("_sgeNoGC.csv")).c_str() );
	timeFile_ge.open       ((baseFileName + string("_ge.csv")).c_str() );
    

	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass4(time_ge, time_sge, time_sge_noGC);
			writeTimes4(time_ge, time_sge, time_sge_noGC, col == startCol, row == startRow, (col + stepSize > endCol));
		}
		
	timeFile_sge.close();
	timeFile_ge.close();
	timeFile_sge_noGC.close();
	
	MFileData mData(3);
	mData.baseFileName = baseFileName;
	mData.addData(0, "_sge.csv", 		"FaceColor", 	"red",		"SGE");
	mData.addData(1, "_sgeNoGC.csv",	"FaceColor",	"blue",		"SGE w/o gray codes");
	mData.addData(2, "_ge.csv", 		"FaceColor", 	"green", 	"GE");
	mData.title = "GE vs SGE vs SGE w/0 BRGC , 0." + printProb(_prob);
	writeMfile3d(startRow, startCol, endRow, endCol, stepSize, mData);

}

// ----------------------------------------------------------------------------------------
/*
 * Same as testRangeClass2 only tests different functions.
 */
void TestSGE::testRangeGE_SGE_originalSGE(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize)
{
	int row, col;						 //current row and col size.
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge, time_sge_original;
	
	             
	outString << "testFiles/testRange7_" << startRow << "_" << startCol << "_" << endRow << "_" 
							     << endCol << "_" << printProb(_prob).c_str() << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open          ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_sge_original.open ((baseFileName + string("_sge_original.csv")).c_str() );
	timeFile_ge.open           ((baseFileName + string("_ge.csv")).c_str() );
    

	for(row = startRow; row <= endRow; row = row + stepSize)
		for(col = startCol; col <= endCol; col = col + stepSize) {
			clear();
			setValues(row, col, _prob);
			testClass7(time_ge, time_sge, time_sge_original);
			writeTimes_ge_sge_sgeOriginal(time_ge, time_sge, time_sge_original, col == startCol, row == startRow, (col + stepSize > endCol));
		}
		
	timeFile_sge.close();
	timeFile_ge.close();
	timeFile_sge_original.close();
	
	MFileData mData(3);
	mData.baseFileName = baseFileName;
	mData.addData(0, "_sge.csv",	 		"FaceColor", 	"red",		"SGE");
	mData.addData(1, "_sge_original.csv",	"FaceColor",	"blue",		"SGE Original");
	mData.addData(2, "_ge.csv", 			"FaceColor", 	"green", 	"GE");
	mData.title = "GE vs SGE vs SGE Original , 0." + printProb(_prob);
	writeMfile3d(startRow, startCol, endRow, endCol, stepSize, mData);

}
// ----------------------------------------------------------------------------------------
//same as testRangeGE_SGE_originalSGE, only does less tests
void TestSGE::testEdgeDiagRange(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize) 
{

	int row, col;						 //current row and col size.
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge, time_sge_original;
	ofstream matlabRows, matlabCols, matlabDiag;
	vector<Vec> times;
	
	             //        |--> type 2
	outString << "testFiles/testRange8_" << startRow << "_" << startCol << "_" << endRow << "_" 
							     << endCol << "_" << printProb(_prob).c_str() << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
	
						     
	matlabRows.open          ((baseFileName + string("_sge_sgeo_ge_varyRows.m")).c_str() );
	matlabCols.open          ((baseFileName + string("_sge_sgeo_ge_varyCols.m")).c_str() );
	matlabDiag.open          ((baseFileName + string("_sge_sgeo_ge_varyDiag.m")).c_str() );

	for(row = startRow; row <= endRow; row = row + stepSize)
	{
		clear();
		setValues(row, startCol, _prob);
		testClass7(time_ge, time_sge, time_sge_original);
		times.push_back(Vec(row, startCol, time_sge, time_sge_original, time_ge));	
	}
	
	matlabRows << "\n"
		   << "rowSize = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabRows << times[i].row << ", ";
	matlabRows << "];\n";
	
	matlabRows << "\n"
		   << "timeSGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabRows << times[i].timeSGE << ", ";
	matlabRows << "];\n";
	
	matlabRows << "\n"
		   << "timeSGE_orig = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabRows << times[i].timeSGE_o << ", ";
	matlabRows << "];\n";	
	
	matlabRows << "\n"
		   << "timeGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabRows << times[i].timeGE << ", ";
	matlabRows << "];\n";
	
    matlabRows << "figure;\n"
    	  << "plot(rowSize, timeSGE, '-gd');\n"
    	  << "hold on\n"
    	  << "plot(rowSize, timeSGE_orig, '-ro');\n"
    	  << "plot(rowSize, timeGE, '-bs');\n"
    	  << "xlabel('n by " << times[0].col << "matrices');\n"
    	  << "ylabel('Time (sec)');\n"
    	  << "legend('SGE','SGE Origional', 'GE' ,3);\n"
    	  << "title('Random Matrices with fillin prob. " << _prob << "');\n"
    	  << "hold off\n"; 
	
	times.clear();
	matlabRows.clear();
	//-----------
	
	for(col = startCol; col <= endCol; col = col + stepSize)
	{
		clear();
		setValues(startRow, col, _prob);
		testClass7(time_ge, time_sge, time_sge_original);
		times.push_back(Vec(startRow, col, time_sge, time_sge_original, time_ge));	
	}
	
	matlabCols << "\n"
		   << "colSize = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabCols << times[i].col << ", ";
	matlabCols << "];\n";
	
	matlabCols << "\n"
		   << "timeSGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabCols << times[i].timeSGE << ", ";
	matlabCols << "];\n";
	
	matlabCols << "\n"
		   << "timeSGE_orig = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabCols << times[i].timeSGE_o << ", ";
	matlabCols << "];\n";	
	
	matlabCols << "\n"
		   << "timeGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabCols << times[i].timeGE << ", ";
	matlabCols << "];\n";
	
    matlabCols << "figure;\n"
    	  << "plot(colSize, timeSGE, '-gd');\n"
    	  << "hold on\n"
    	  << "plot(colSize, timeSGE_orig, '-ro');\n"
    	  << "plot(colSize, timeGE, '-bs');\n"
    	  << "xlabel('" << times[0].row << "by n matrices');\n"
    	  << "ylabel('Time (sec)');\n"
    	  << "legend('SGE','SGE Origional', 'GE' ,3);\n"
    	  << "title('Random Matrices with fillin prob. " << _prob << "');\n"
    	  << "hold off\n"; 
	
	times.clear();	
	matlabCols.close();
	
	//-------
	for(row = startRow; row <= endRow; row = row + stepSize)
	{
		clear();
		setValues(row, row, _prob);
		testClass7(time_ge, time_sge, time_sge_original);
		times.push_back(Vec(row, row, time_sge, time_sge_original, time_ge));	
	}

	matlabDiag << "\n"
		   << "diagSize = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabDiag << times[i].row << ", ";
	matlabDiag << "];\n";
	
	matlabDiag << "\n"
		   << "timeSGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabDiag << times[i].timeSGE << ", ";
	matlabDiag << "];\n";
	
	matlabDiag << "\n"
		   << "timeSGE_orig = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabDiag << times[i].timeSGE_o << ", ";
	matlabDiag << "];\n";	
	
	matlabDiag << "\n"
		   << "timeGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		matlabDiag << times[i].timeGE << ", ";
	matlabDiag << "];\n";
	
    matlabDiag << "figure;\n"
    	  << "plot(diagSize, timeSGE, '-gd');\n"
    	  << "hold on\n"
    	  << "plot(diagSize, timeSGE_orig, '-ro');\n"
    	  << "plot(diagSize, timeGE, '-bs');\n"
    	  << "xlabel('n by n matrices');\n"
    	  << "ylabel('Time (sec)');\n"
    	  << "legend('SGE','SGE Origional', 'GE' ,3);\n"
    	  << "title('Random Matrices with fillin prob. " << _prob << "');\n"
    	  << "hold off\n"; 
	
	times.clear();
	matlabDiag.close();
}

// ----------------------------------------------------------------------------------------
//vary the fill in.
void TestSGE::testRangeProbability(int oneRow, int oneCol, double startProb, double endProb, double probStepSize)
{
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge;
	
	             
	outString << "testFiles/testProb3_" << oneRow << "_" << oneCol << "_" << printProb(startProb).c_str() << "_"
	          << printProb(endProb).c_str() << "_" << printProb(probStepSize).c_str();
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_ge.open  ((baseFileName + string("_ge.csv")).c_str() );
    
    
	for(double currentProb = startProb; currentProb <= endProb; currentProb = currentProb + probStepSize) {
		clear();
		setValues(oneRow, oneCol, currentProb);
		testClass2(time_ge, time_sge);
		writeTimesProb(time_ge, time_sge, (currentProb + probStepSize > endProb));
	}
		
	timeFile_sge.close();
	timeFile_ge.close();
	
	writeMfileProb(oneRow, oneCol, startProb, endProb, probStepSize, baseFileName);


}
// ----------------------------------------------------------------------------------------
/*
 * test random matrix from a graph 3-coloring. 
 * keep prob constant and increase size of graph.
 */
void TestSGE::testGraphRangeClass1(int startVertex, int endVertex,  double _prob,  int stepSize)
{
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge, time_sge_noGC;
	GraphBuilder gb;
    ColoringIdealBuilder cib;
    Graph * g;
    Ideal<F2>* ideal ;
    vector<Vec> times;
    ofstream mfile;
	             
	outString << "testFiles/testGraph5_" << startVertex << "_" << endVertex << "_" << printProb(_prob).c_str() 
	           << "_" << stepSize;
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open      ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_sge_noGC.open ((baseFileName + string("_sge0.csv")).c_str() );
	timeFile_ge.open       ((baseFileName + string("_ge.csv")).c_str() );
    mfile.open             ((baseFileName + string("_sge_sgeo_ge.m")).c_str() );

	for(int vertex = startVertex; vertex <= endVertex; vertex = vertex + stepSize)
	{
		g = gb.buildGraph(vertex, _prob);
		ideal = cib.buildColoringIdeal<F2>(*g,3);
		Nullstellensatz<F2> nulla(*ideal, 3,3);
		ls = nulla.constructGet_linear_system();
		//clear();
		//setValues(row, col, _prob);
		//testClass4(time_ge, time_sge, time_sge_noGC);
		rowSize = ls->getNumRows(); 
		colSize = ls->getNumCols();
		prob = _prob;
		cout << "testing vertex = " << vertex << "\n";
		testClass(time_ge, time_sge, time_sge_noGC);
		writeTimes4(time_ge, time_sge, time_sge_noGC, true, true, ( vertex + stepSize > endVertex));
		
		times.push_back(Vec(vertex, vertex, time_sge, time_sge_noGC, time_ge));
		//nulla deletes self in loop
		ls = 0;
		delete ideal;
		delete g;
	}
		
    mfile << "\n"
          << "vertex = [";

    
    		
	timeFile_sge.close();
	timeFile_ge.close();
	timeFile_sge_noGC.close();
	
	
	for ( int i = 0; i < (int)times.size(); ++i)
		mfile << times[i].row << ", ";
	mfile << "];\n";
	
	mfile << "\n"
		   << "timeSGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		mfile << times[i].timeSGE << ", ";
	mfile << "];\n";
	
	mfile << "\n"
		   << "timeSGE_orig = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		mfile << times[i].timeSGE_o << ", ";
	mfile << "];\n";	
	
	mfile << "\n"
		   << "timeGE = [ ";
	for ( int i = 0; i < (int)times.size(); ++i)
		mfile << times[i].timeGE << ", ";
	mfile << "];\n";
	
    mfile << "figure;\n"
    	  << "plot(vertex, timeSGE, '-gd');\n"
    	  << "hold on\n"
    	  << "plot(vertex, timeSGE_orig, '-ro');\n"
    	  << "plot(vertex, timeGE, '-bs');\n"
    	  << "xlabel('Vertex number');\n"
    	  << "ylabel('Time (sec)');\n"
    	  << "legend('SGE','SGE Origional', 'GE' ,3);\n"
    	  << "title('First Degree Poly. solution to 3-colorings of random matrices with density " << _prob << "');\n"
    	  << "hold off\n"; 
	
	times.clear();
	mfile.close();	
	
	//writeMfile5(startRow, startCol, endRow, endCol, _prob, stepSize, baseFileName);	
}

// ---------------------------------------------------------------------------------------- 
/*
 * test random matrix from a graph 3-coloring. 
 * keep size of graph constant and increase prob.
 */
void TestSGE::testGraphRangeClass2(int startVertex, double startP, double endP, double probStepSize)
{
    stringstream outString;              //print to string
	string baseFileName;                 //file name...almost.
	double time_ge, time_sge, time_sge_noGC;
	GraphBuilder gb;
    ColoringIdealBuilder cib;
    Graph * g;
    Ideal<F2>* ideal ;
    vector<Vec> times;
	             
	outString << "testFiles/testGraph6_" << startVertex << "_" <<  printProb(startP).c_str() << "_" << printProb(endP).c_str() << "_"
	           << "_" << printProb(probStepSize).c_str();
	baseFileName = string( outString.str() );
							     
							     
	timeFile_sge.open      ((baseFileName + string("_sge.csv")).c_str() );
	timeFile_sge_noGC.open ((baseFileName + string("_sgeo.csv")).c_str() );
	timeFile_ge.open       ((baseFileName + string("_ge.csv")).c_str() );
    

	for(double currentProb = startP; currentProb <= endP; currentProb = currentProb + probStepSize)
   {
		g = gb.buildGraph(startVertex, currentProb);
		ideal = cib.buildColoringIdeal<F2>(*g,3);
		Nullstellensatz<F2> nulla(*ideal, 3,3);
		ls = nulla.constructGet_linear_system();
		//clear();
		//setValues(row, col, _prob);
		//testClass4(time_ge, time_sge, time_sge_noGC);
		rowSize = ls->getNumRows(); 
		colSize = ls->getNumCols();
		prob = currentProb;
		testClass(time_ge, time_sge, time_sge_noGC);
		writeTimes4(time_ge, time_sge, time_sge_noGC, true, true, ( currentProb + probStepSize > endP));
		
		//nulla deletes self in loop
		ls = 0;
		delete ideal;
		delete g;
	}
		
	timeFile_sge.close();
	timeFile_ge.close();
	timeFile_sge_noGC.close();
	
	
	//writeMfile4(startRow, startCol, endRow, endCol, _prob, stepSize, baseFileName);
}


// ---------------------------------------------------------------------------------------- 

void TestSGE::writeTimes(double time_ge, double time_sge, bool col, bool row, bool printCamma)
{
	if ( col && ! row ) {
		timeFile_sge << '\n';
		timeFile_ge  << '\n';
	}
	timeFile_sge << time_sge << ( printCamma ?  "" : "," ) ;
	timeFile_ge  << time_ge  << ( printCamma ?  "" : "," ) ;
}
// ----------------------------------------------------------------------------------------


void TestSGE::writeTimes4(double time_ge, double time_sge,  double time_sge_noGC, bool col, bool row, bool printCamma)
{
	if ( col && ! row ) {
		timeFile_sge      << '\n';
		timeFile_ge       << '\n';
		timeFile_sge_noGC << '\n';
	}
	timeFile_sge       << time_sge       << ( printCamma ?  "" : "," ) ;
	timeFile_ge        << time_ge        << ( printCamma ?  "" : "," ) ;
	timeFile_sge_noGC  << time_sge_noGC  << ( printCamma ?  "" : "," ) ;
}


/*
 * same as write Times 4 but with different files
 */
void TestSGE::writeTimes_ge_sge_sgeOriginal(double time_ge, double time_sge,  double time_sge_original, bool col, bool row, bool printCamma)
{
	if ( col && ! row ) {
		timeFile_sge      << '\n';
		timeFile_ge       << '\n';
		timeFile_sge_original << '\n';
	}
	timeFile_sge    	   << time_sge   	     << ( printCamma ?  "" : "," ) ;
	timeFile_ge     	   << time_ge    	     << ( printCamma ?  "" : "," ) ;
	timeFile_sge_original  << time_sge_original  << ( printCamma ?  "" : "," ) ;
}
// ----------------------------------------------------------------------------------------
//write times for different probability
void TestSGE::writeTimesProb(double time_ge, double time_sge, bool printLast)
{
	timeFile_sge << time_sge << ( printLast ?  "" : "," ) ;
	timeFile_ge  << time_ge  << ( printLast ?  "" : "," ) ;
}
	



// ----------------------------------------------------------------------------------------

void TestSGE::writeMfile(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName)	
{

	string fileSGE = baseFileName + string("_sge.csv");
	string fileGE  = baseFileName + string("_ge.csv");
	ofstream mFile;
	


	mFile.open ((baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "[timeMatrix_col, timeMatrix_row] = meshgrid( " << startCol << ":" << stepSize << ":" << endCol <<  " , " << startRow << ":" << stepSize << ":" << endRow << " );\n";
    mFile << "geTimes = csvread('" << fileGE.c_str() << "');\n"; 
    mFile << "sgeTimes = csvread('" << fileSGE.c_str() << "');\n"; 
    

    mFile << "figure;\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, geTimes, 'FaceColor','green');\n"
    	  << "hold on\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, sgeTimes, 'FaceColor','red');\n"
    	  << "alpha(.4);\n"
    	  << "xlabel('Row Size');\n"
    	  << "ylabel('Col Size');\n"
    	  << "zlabel('Time (sec)');\n"
    	  << "legend('GE','Striped GE',2)\n"
    	  << "title('StripedGE vs GE with Std. Gray Code in C++, " << _prob << "');\n"
    	  << "hold off";
    
	mFile.close();
}

# if 0
void TestSGE::writeMfile4(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName)
{
	string fileSGE      = baseFileName + string("_sge.csv");
	string fileGE       = baseFileName + string("_ge.csv");
	string fileSGE_noGC = baseFileName + string("_sgeNoGC.csv");
	ofstream mFile;
	


	mFile.open ((baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "[timeMatrix_col, timeMatrix_row] = meshgrid( " << startCol << ":" << stepSize << ":" << endCol <<  " , " << startRow << ":" << stepSize << ":" << endRow << " );\n";
    mFile << "geTimes = csvread('" << fileGE.c_str() << "');\n"; 
    mFile << "sgeTimes = csvread('" << fileSGE.c_str() << "');\n"; 
    mFile << "sgeNoGCTimes = csvread('" << fileSGE_noGC.c_str() << "');\n"; 
    

    mFile << "figure;\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, geTimes, 'FaceColor','green');\n"
    	  << "hold on\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, sgeTimes, 'FaceColor','red');\n"
    	  << "surf(timeMatrix_row, timeMatrix_col, sgeNoGCTimes, 'FaceColor','blue');\n"
    	  << "alpha(.4);\n"
    	  << "xlabel('Row Size');\n"
    	  << "ylabel('Col Size');\n"
    	  << "zlabel('Time (sec)');\n"
    	  << "legend('GE','Striped GE', 'Striped GE w/o Gray Codes', 3)\n"
    	  << "title('GE vs Striped GE with Std. Gray Code vs Striped GE w/o Gray Code in C++, " << _prob << "');\n"
    	  << "hold off";
    
	mFile.close();

}
#endif



// ---------------------------------------------------------------------------------------- 

//write an m-file script to graph ge vs sge. 2d plot
void TestSGE::writeMfileProb(int oneRow, int oneCol, double startProb, double endProb, double probStepSize, const string & baseFileName)
{
	string fileSGE = baseFileName + string("_sge.csv");
	string fileGE  = baseFileName + string("_ge.csv");
	ofstream mFile;
	
	


	mFile.open ((baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "geTimes = csvread('" << fileGE.c_str() << "');\n"; 
    mFile << "sgeTimes = csvread('" << fileSGE.c_str() << "');\n"; 
    
    mFile << "prob = [";

    double currentProb;
    for( currentProb = startProb; currentProb <= endProb; currentProb = currentProb + probStepSize) {
    	if ( (currentProb + probStepSize) > endProb)
    		mFile << setiosflags(ios::fixed) << setprecision(8)  << currentProb << "";
    	else
    	   	mFile << setiosflags(ios::fixed) << setprecision(8)  << currentProb << ", ";
    }
    mFile << " ];\n";


    
//    << startProb << ":" << probStepSize << ":" << endProb << ";\n";
    

    mFile << "figure;\n"
    	  << "plot(prob, geTimes, '--gd');\n"
    	  << "hold on\n"
    	  << "plot(prob, sgeTimes, '--ro');\n"
    	  << "xlabel('Fill in');\n"
    	  << "ylabel('Time (sec)');\n"
    	  << "legend('GE','Striped GE',2)\n"
    	  << "title('StripedGE vs GE with Std. Gray Code in C++, [" << oneRow << " , " << oneCol  << "]');\n"
    	  << "hold off";    
    
	mFile.close();
}

void TestSGE::writeMfile3d(int startRow, int startCol, int endRow, int endCol, int stepSize, const MFileData & d)
{
	ofstream mFile;
	
	mFile.open ((d.baseFileName + string("_matlab.m")).c_str() );

    mFile << '\n'; //matlab needs this?
    mFile << "seed = " << seed << ";\n";
    mFile << "[timeMatrix_col, timeMatrix_row] = meshgrid( " << startCol << ":" << stepSize << ":" << endCol <<  " , " << startRow << ":" << stepSize << ":" << endRow << " );\n";
    
    for(int i = 0; i < d.size; ++i)
    	mFile << "csvFile" << i << " = csvread('" << d.getFileName(i).c_str() << "');\n";
   
    mFile << "figure;\n";
    
    for(int i = 0; i < d.size; ++i)
    {
    	mFile << "surf(timeMatrix_row, timeMatrix_col, " 
    	                            << "csvFile" << i 
    	                            << ", " << d.colorType[i].c_str() 
    	                            << ", " << d.colorName[i].c_str()
    	                            << ");\n";
    	if ( i == 0) mFile << "hold on\n"; //needed by matlab.
    }//for i
    mFile << "alpha(.4);\n"
    	  << "xlabel('Row Size');\n"
    	  << "ylabel('Col Size');\n"
    	  << "zlabel('Time (sec)');\n"
    	  << "legend(";
    	 
    for(int i = 0; i < d.size; ++i)
    	mFile << d.legend[i] << ", ";
    
    mFile << d.size << ")\n"
    	  << "title('" << d.title.c_str() << "');\n"
    	  << "hold off\n";
    
	mFile.close();


}
	
// ---------------------------------------------------------------------------------------- 
// ---------------------------------------------------------------------------------------- 
// ---------------------------------------------------------------------------------------- 
// ---------------------------------------------------------------------------------------- 


MFileData::MFileData(int s): size(s)
{
    baseFileName.erase();
    title.erase();
	fileName.resize(s);
	colorType.resize(s);
	colorName.resize(s);
	legend.resize(s);
}
	
void MFileData::addData(int i, const char * fn, const char * ct, const char * cn, const char * le)
{
	fileName[i] = fn;
	colorType[i] = string("'") + ct + string("'");
	colorName[i] = string("'") + cn + string("'");
	legend[i] = string("'") + le + string("'");
}


string MFileData::getFileName(int i) const { return baseFileName + fileName[i]; }

