#ifndef _TSGE_H_
#define _TSGE_H_

#include <string>
#include <sstream>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <ctime>
#include <vector>
#include <exception>
#include "IdealFactory.h"
#include "Index.h"
#include "MyTime.h"
#include "Ideal.h" 
#include "LinearSystem.h" 
#include "LinearSystemF2.h"
#include "TermGenerator.h"
#include "MonExpEnum.h"
#include "Polynomial.h"
#include "Util.h"
#include "Q.h"
#include "F2.h"
#include "F4.h"
#include "FP.h"


#include "Graph.h"
#include "GraphBuilder.h"
#include "nulla/Nullstellensatz.h"
#include "nulla/NullstellensatzFactory.h"
#include "border/BorderSpace.h"
#include "coloring/trick.h"
#include "coloring/ColoringIdealBuilder.h"
#include "coloring/Sat3Color.h"
#include "coloring/Branching.h"


using namespace std;

class MFileData;

class TestSGE
{
private:

  
	LinearSystem<F2>* ls;
	int rowSize, colSize;
	double prob;
	vector<int> xVar;                    //Ax = b
 	ofstream timeFile_sge;
	ofstream timeFile_ge; 
	ofstream timeFile_sge_noGC; 		//sge w/o gray codes  
	ofstream timeFile_sge_original; 	//for orig. sge
	int seed;							//for srand()
  
    void addRHSb_fromX();   
    
    const string printProb(double num) const;
    
                 //adds [A*x].
	void TestSGE::addRHSb_justX();       //adds [b]
	bool testClass(double & time_ge, double & time_sge);
	bool testClass(double & time_ge, double & time_sge, double & time_sge_noGC);
	
	//write times for differnet sizes
	void writeTimes(double time_ge, double time_sge,  bool col, bool row, bool printCamma);		
	void writeTimes4(double time_ge, double time_sge,  double time_sge_noGC, bool col, bool row, bool printCamma);	
	void writeTimes_ge_sge_sgeOriginal(double time_ge, double time_sge,  double time_sge_original, bool col, bool row, bool printCamma);	
	
	//write times for different probability
	void writeTimesProb(double time_ge, double time_sge, bool printLast);                       

	void writeMfile3d(int startRow, int startCol, int endRow, int endCol, int stepSize, const MFileData & names);
	void writeMfile(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName);     //write an m-file script to graph ge vs sge. 3d plot
	void writeMfile4(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize, const string &baseFileName);	
	void writeMfileProb(int oneRow, int oneCol, double startProb, double endProb, double probStepSize, const string & baseFileName); //write an m-file script to graph ge vs sge. 2d plot
	
public:  
	TestSGE(int s);
	//A B C D E F G H I J K L M N O P Q R S T U V W X Y Z

	void clear();
	void setRandomMatrixClass1();        //loops through each element
	void setRandomMatrixClass2();        //fills (row*col*prob) elements randomly
    void setValues(int _rowSize, int _colSize, double _prob);
	
	// random matrix
	bool testClass1(double & time_ge, double & time_sge);                         //sge vs ge for class 1 matrix.
	bool testClass2(double & time_ge, double & time_sge);                         //sge vs ge for class 2 matrix.
	bool testClass4(double & time_ge, double & time_sge, double & time_sge_noGC); //sge vs ge vs sgeNoGC for class 2 matrix.
	bool testClass7(double & time_ge, double & time_sge, double & time_sge_original);//sge vs ge vs sge original
	void testRangeClass1(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testRangeClass2(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testRangeFunct3(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testRangeGE_SGE_originalSGE(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize);
	void testEdgeDiagRange(int startRow, int startCol, int endRow, int endCol, double _prob, int stepSize); //only run tests for 1:m, 1:n, and n:n.
	void testRangeProbability(int oneRow, int oneCol, double startProb, double endProb, double probStepSize); //vary the fill in.
	
	
	//random graph.
	void testGraphRangeClass1(int startRow, int endRow,  double _prob,  int stepSize);
	void testGraphRangeClass2(int startVertex, double _prob, double _prob2, double probStepSize);
};


class MFileData
{

 public:
 	int size;
    string baseFileName;
    string title;
	vector<string> fileName;
	vector<string> colorType;
	vector<string> colorName;
	vector<string> legend;

    MFileData(int s);
    
	void addData(int index, const char * fn, const char * ct, const char * cn, const char * le);
	string getFileName(int i) const;
}; // MFileData


class Vec
{
public:
	int row;
	int col;
	double timeSGE;
	double timeSGE_o;
	double timeGE;
	
	Vec(): row(0), col(0), timeSGE(0), timeSGE_o(0), timeGE(0) { }
	Vec(int r, int c, double ts, double tso, double tge): row(r), col(c), timeSGE(ts), timeSGE_o(tso), timeGE(tge) { }

};

#endif
