#include <ctime>
#include <cmath>
#include <string>
#include <fstream>
#include <iostream>
#include <sstream>
#include <getopt.h>

#include "tSGE.h"

#include "MyTime.h"

using namespace std;

//functions
int printMenu();
void getDataRangeClasses(int & startRow, int & startCol, int & endRow, int & endCol, double & prob, int &stepSize);
void getRangeProbability(int & startRow, int & startCol, double & prob, double & prob2, double & probStepSize);
void getGraphSizeRange(int &startRow, int & endRow,  double &prob, int & stepsize);
int getSeed();


//class 1 = loops over each element
//class 2 = fills (row*col*prob) elements.
int main()
{
	int startCol, endCol, startRow, endRow, stepSize;
	double prob, prob2, probStepSize;
	int classType;
	
    /* time functions */
    double start = tic();

    TestSGE sge(getSeed());
	//         bits     range             Accuracy 	
	//float 	4 	-3.4E38..+3.4E38 	6-7 digits 	
	//double	8 	-1.7E308..+1.7E308	14-15 digits


	
	
	while(1) {
		classType = printMenu();
		if (classType == 0)
			break;
			
		//get data	
		if ( classType == 1 || classType == 2 || classType == 4 || classType == 7 || classType == 8)
			getDataRangeClasses(startRow, startCol, endRow, endCol, prob, stepSize);
		else if (classType == 3 || classType == 6)
			getRangeProbability(startRow, startCol, prob, prob2, probStepSize);
		else if ( classType == 5)
			getGraphSizeRange(startRow, endRow, prob, stepSize);
		
		
		//do math.
		if (classType == 1)
			sge.testRangeClass1(startRow, startCol, endRow, endCol, prob, stepSize);
		else if( classType == 2)
			sge.testRangeClass2(startRow, startCol, endRow, endCol, prob, stepSize);//loops over each element
		else if ( classType == 3)
			sge.testRangeProbability(startRow, startCol, prob, prob2, probStepSize);
		else if ( classType == 4)
			sge.testRangeFunct3(startRow, startCol, endRow, endCol, prob, stepSize);
		else if ( classType == 5)
			sge.testGraphRangeClass1(startRow, endRow, prob, stepSize);
		else if ( classType == 6)
			sge.testGraphRangeClass2(startRow, prob, prob2, probStepSize);
		else if ( classType == 7)
			sge.testRangeGE_SGE_originalSGE(startRow, startCol, endRow, endCol, prob, stepSize);
		else if (classType == 8)
			sge.testEdgeDiagRange(startRow, startCol, endRow, endCol, prob, stepSize);
		sge.clear();
	
	}
	
	
	//sge.testRangeClass2(10000,35000, 20000, 60000,  .0001, 1000);//loops over each element

	//sge.setValues(35000,10000,.001);
    //sge.setRandomMatrixClass2();//fills (row*col*prob) elements randomly
    //sge.clear();

    cout << "TOTAL TIME: " << toc(start) << "\n"; 

    return 0;
}

// ------------------------------------------------------------------------------


int printMenu()
{
	int type;
	do {
		cout << "Menu\n"
		     << "0. Exit\n"
		     << "1. Run with class 1. Loops over each element\n"
		     << "2. Run with class 2. Fills (row*col*prob) elements.\n"
		     << "3. Run with different fills\n"
		     << "4. Run with 3 functions using class 2 matrix.\n"
		     << "5. Run with graph matrix. Vary size.\n"
		     << "6. Run with graph matrix. Vary prob.\n"
		     << "7. Run ge vs origional ge vs new sge with different sizes.\n"
		     << "8. Same as 7 but with edges and diag. of the range of matrix sizes\n"
		     << "\n  type >> ";
		cin >> type;
		
		if ( type < 0 || type > 8)
		{
			cout << "Ops\n";
			cin.ignore(1000, '\n');
		}
	} while ( type < 0 || type > 8);
	     
	return type;
}

// ------------------------------------------------------------------------------
int getSeed()
{
	int s;
	cout << "seed =";
	cin >> s;
	return s;
}

// ------------------------------------------------------------------------------

void getDataRangeClasses(int & startRow, int & startCol, int & endRow, int & endCol, double & prob, int &stepSize)
{
	cout << "StartRow = ";
	cin >> startRow;
	
	cout << "startCol = ";
	cin >> startCol;
	
	cout << "endRow = ";
	cin >> endRow;
	
	cout << "endCol = ";
	cin >> endCol;
	
	cout << "Density (< 1) = ";
	cin >> prob;
	
	cout << "stepSize = ";
	cin >> stepSize;

}

// ------------------------------------------------------------------------------

void getRangeProbability(int & startRow, int & startCol, double & prob, double & prob2, double & probStepSize)
{
	cout << "RowSize = ";
	cin >> startRow;
	
	cout << "colSize = ";
	cin >> startCol;
	
	cout << "startProbability = ";
	cin >> prob;
	
	cout << "endProbability = ";
	cin >> prob2;
	
	cout << "probStepSize = ";
	cin >> probStepSize;
	
}
// ------------------------------------------------------------------------------
void getGraphSizeRange(int &startRow, int & endRow,  double &prob, int & stepSize)
{
	cout << "startRow = ";
	cin >> startRow;

	cout << "endRow = ";
	cin >> endRow;
		
	cout << "fillProbability = ";
	cin >> prob;
	
	cout << "rowStepSize = ";
	cin >> stepSize;
}



