#include "bastat.h"

/* \section{Variables globales} */

void baniere()
{
    printf("\n");
    printf("           CALCUL DE BASES STANDARD D'IDEAUX TORIQUES    \n");
    printf("-------------------------------------------------------------------------------\n");
    printf("Loi(tre(accent aigu)ma)c Pottier                                              \n");
    printf("\n");
    printf("Projet SAFIR (Systemes Algebriques Formels pour l'Industrie et la Recherche)\n");
    printf("INRIA Sophia Antipolis \n");
    printf("2004 route des Lucioles\n");
    printf("06565 Valbonne Cedex FRANCE\n");
    printf("Tel: 93 65 78 19\n");
    printf("Fax: 93 65 77 66\n");
    printf("Courrier electronique: pottier@sophia.inria.fr\n");
    printf("-------------------------------------------------------------------------------\n");
    printf("\n");
    printf("                         avril 1994                       \n");
    printf("\n");
    
}
/* \section{Fonctions sur les exposants et les listes d'entiers.} 
 Cr\'eation d'une liste d'entiers.  */
lint *make_lint(b,rem)
     int b;
     lint *rem;
{
    lint *l;
    l=(lint *)malloc(sizeof(lint));
    l->first = b;
    l->rem = rem;
    return(l);
}

/* Impression. */
print_lint(l)
     lint *l;
{
    printf("[");
    while(l)
    {
	printf("%d ",l->first);
	l=l->rem;
    }
    printf("]\n");
}
/*  Min de deux entiers */
int min_int(x,y)
     int x,y;
{
    if (x>y)
    return(y);
    else return(x);
}

/*  Max de deux entiers */
int max_int(x,y)
     int x,y;
{
    if (x>y)
    return(x);
    else return(y);
}
/*  Cr\'eation d'un exposant \`a partir d'une liste d'entiers. */
exponent make_exp(l)
     lint *l;
{
    int i;
    exponent e1;
    e1= (exponent)malloc(sizeof(int)*dim);
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=l->first;
	l=l->rem;
    }
    return(e1);
}

/* Copie */
exponent copy_exp(e)
     exponent e;
{
    int i;
    exponent e1;
    e1= (exponent)malloc(sizeof(int)*dim);
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=e[i];
    }
    return(e1);
}

/*  Impression  */
print_exp(e)
     exponent e;
{
    int i;
    printf("%s","[");
    for  (i=0 ; i<(dim -1); i++)
    {
	printf("%d ",e[i]);
    }
    printf("%d]\n",e[i]);
}

print_exp_lisp(e)
     exponent e;
{
    int i;
    printf("%s","(");
    for  (i=0 ; i<(dim -1); i++)
    {
	printf("%d ",e[i]);
    }
    printf("%d)\n",e[i]);
}
/* Op\'erations sur les exposants.  */
exponent opp_exp(e1)
     exponent e1;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=-e1[i];
    }
    return(e1);
}

equal_exp(e1,e2)
     exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (!(e1[i]==e2[i]))
	return(0);
    }
    return(1);
}

equal_pos_exp(e1,e2)
     exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if ((e1[i]>0 || e2[i]>0) && !(e1[i]==e2[i]))
	return(0);
    }
    return(1);
}

exponent add_exp(e1,e2)
     exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=e1[i]+e2[i];
    }
    return(e1);
}

exponent sub_exp(e1,e2)
     exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=e1[i]-e2[i];
    }
    return(e1);
}
/*  Soustrait q fois e2 de e1.  */
exponent subq_exp(e1,e2,q)
     exponent e1,e2;
     int q;
{
    int i;
    if (!(q==0))
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=e1[i]-q*e2[i];
    }
    return(e1);
}
/* Ajoute q fois e2 \`a e1.  */
exponent addq_exp(e1,e2,q)
     exponent e1,e2;
     int q;
{
    int i;
    if (!(q==0))
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=e1[i]+q*e2[i];
    }
    return(e1);
}
/* Teste si le premier coefficient non nul est positif. */
pos1_exp(e)
     exponent e;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (e[i]<0)
	return(0);
	else if (e[i]>0)
	return(1);
    }
    return(1);
}
/* Teste si le dernier coefficient non nul est n\'egatif. */
neg1_exp(e)
     exponent e;
{
    int i;
    for  (i=dim-1 ; i>=0 ; i=i-1)
    {
	if (e[i]>0)
	return(0);
	else if (e[i]<0)
	return(1);
    }
    return(1);
}
/* Op\'erations sur les parties positives.  */
exponent pos_exp(e)
     exponent e;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (e[i]<0)
	e[i]=0;
    }
    return(e);
}

exponent neg_exp(e)
     exponent e;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (e[i]>0)
	e[i]=0;
	else
	e[i]=-e[i];
    }
    return(e);
}
/*   Normalise un bin\^ome: rend sa partie positive plus grande que sa partie
n\'egative pour l'ordre sp\'ecifi\'e par binomial_order.
  	0: lex.
	1: lexico sur la premiere variable, revlex sur les autres. */	

exponent normalize_exp(b)
     exponent b;
{
    int i;
    if (binomial_order==0) 
    return(norm_lex(b));
    else if (binomial_order==1)
    return(norm_lex1_revlex(b));
}

exponent norm_revlex(b) 
    exponent b;
{
    int i,dp,dm;
    dp=0;
    dm=0;
    for  (i=0 ; i<dim ; i++)
    {
	if (b[i]>0)
	dp=dp+b[i];
	else
	dm=dm-b[i];
    }
    if (dp>dm)
    return(b);
    else if (dp<dm)
    return(opp_exp(b));
    else if (neg1_exp(b))
    return(b);
    else
    return(opp_exp(b));
}

exponent norm_lex1_revlex(b) 
    exponent b;
{
    if (b[0]>0)
    return(b);
    else if (b[0]<0)
    return(opp_exp(b));
    else
    return(norm_revlex(b));
}

exponent norm_lex(b) 
    exponent b;
{
    if (pos1_exp(b))
    return(b);
    else
    return(opp_exp(b));
}

order_exp(e1,e2)
     exponent e1,e2;
{
    if (binomial_order==0)
    return(lex_exp(e1,e2));
    else if (binomial_order==1)
    return(normm1_order_exp(e1,e2));
}


/* Ordre lexicographique sur les parties positives: rend -1 0 ou 1  */

int lex_exp(e1,e2)
     exponent e1,e2;
{
    int k;
    k=0;
    while (k<dim)
    {
	if (e1[k]>=0 && e2[k]>=0 && e1[k]>e2[k])
	return(1);
	else
	{
	    if (e1[k]>=0 && e2[k]>=0 && e1[k]<e2[k])
	    return(-1);
	    else k++;
	}
    }
    return(0);
}


/* Ordre de la norme -1 + lexico.  */

normm1_order_exp(e1,e2)
     exponent e1,e2;
{
    int n1,n2;
    n1=normm1_exp(e1);
    n2=normm1_exp(e2);
    if (n1<n2)
    return(-1);
    else if (n1>n2)
    return(1);
    else
    return(lex_exp(e1,e2));
}
    

/* La norme -1 d'un exposant.  */

normm1_exp(e)
     exponent e;
{
    int i,dp,dm;
    dp=0;
    dm=0;
    for  (i=0 ; i<dim ; i++)
    {
	if (e[i]>0)
	dp=dp+e[i];
	else
	dm=dm-e[i];
    }
    return(max_int(dp,dm));
}

trivial_exp(e)
     exponent e;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (!(e[i]==0))
	return(0);
    }
    return(1);
}

disjoint_exp(e1,e2)
    exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if ((e1[i]>0) && (e2[i]>0))
	return(0);
    }
    return(1);
}

exponent max_exp(e1,e2)
     exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (e1[i]<=0)
	{
	    if (e2[i]<=0)
	    e1[i]=0;
	    else
	    e1[i]=e2[i];
	}
	else if (e1[i]<e2[i])
	e1[i]=e2[i];
    }
    return(e1);
}


/* Teste si e1+ divise e2+.*/

div_exp(e1,e2)
   exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if (e1[i]>0&& e1[i]>e2[i])
	return(0);
    }
    return(1);
}

/* Teste si e1+ divise e2-.*/

div_exp_neg(e1,e2)
   exponent e1,e2;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if ((e1[i]>=0) && (e1[i]>-e2[i]))
	return(0);
    }
    return(1);
}


/* Teste si e1+ divise strictement e2+.*/

divs_exp(e1,e2)
   exponent e1,e2;
{
    int i,s;
    for  (i=0 ; i<dim ; i++)
    {
	if (e1[i]>=0)
	{
	    if (e1[i]>e2[i])
	    return(0);
	    else if (e1[i]<e2[i])
	    s=1;
	}
    }
    if (s==1)
    return(1);
    else
    return(0);
}


/*  Degr\'e total (somme des coefficients). */

int deg_exp(e)
     exponent e;
{
    int i,d;
    d=0;
    for  (i=0 ; i<dim ; i++)
    {
	d=d+e[i];
    }
    
    return(d);
}
int deg_pos_exp(e)
     exponent e;
{
    int i,d;
    d=0;
    if (e)
    for  (i=0 ; i<dim ; i++)
    {
	if (e[i]>0) d=d+e[i];
    }
    
    return(d);
}



/* \section{Fonctions sur les bin\^omes.} */

trivial_ibin(b)
     int b;
{
    return(trivial_exp(all_bin[b]));
}


/* Cr\'eation d'un nouveau bin\^ome dans le tableau all\_bin */
/* Rend son indice. */

int new_bin(b)
     exponent b;
{
    b=normalize_exp(b);
    all_bin_max++;
    all_bin[all_bin_max]=b;
    return(all_bin_max);
}


/* \section{Fonctions sur les listes d'indices de bin\^omes} */



/* Cr\'eation */

lint *make_libin(b,rem)
     int b;
     lint *rem;
{
    lint *l;
    l=(lint *)malloc(sizeof(lint));
    l->first = b;
    l->rem = rem;
    return(l);
}


/* Copie.  */

lint *copy_libin(l)
     lint *l;
{
    if (l)
    return(make_libin(l->first,copy_libin(l->rem)));
    else
    return(0);
}


/* Impression des listes de bin\^omes */

print_libin(s)
     lint *s;
{
    printf("{\n");
    print_libin_rec(s);
    printf("}\n");
}
  
print_libin_rec(s)
     lint *s;
{
    if (s)
    {
/*	printf("  %d:  ", s->first);*/
	print_exp(all_bin[s->first]);
	print_libin_rec(s->rem);
    }
}
print_libin_lisp(s)
     lint *s;
{
    printf("(\n");
    print_libin_lisp_rec(s);
    printf(")\n");
}
  
print_libin_lisp_rec(s)
     lint *s;
{
    if (s)
    {
	print_exp_lisp(all_bin[s->first]);
	print_libin_lisp_rec(s->rem);
    }
}
print_bin(b)
     exponent *b;
{
    exponent e1,e2;
    int i;
    
    e1=pos_exp(copy_exp(b));
    e2=neg_exp(copy_exp(b));
    printf("%s","[");
    for  (i=0 ; i<(dim -1); i++)
    {
	printf("%d,",e1[i]);
    }
    printf("%d] - [",e1[i]);
    for  (i=0 ; i<(dim -1); i++)
    {
	printf("%d,",e2[i]);
    }
    printf("%d]\n",e2[i]);
}
  


/* Inversion d'une liste d'indices de bin\^omes. */

lint *rev_libin(l)
     lint *l;
{
    lint *r;
    r=0;
    
    while (l)
    {
	r=make_libin(l->first,r);
	l=l->rem;
    }
    return(r);
}


/* Concat\'enation physique de deux listes d'indices de binomes */

lint *append_libin(l1,l2)
     lint *l1,*l2;
{
    lint *laux;
    laux=l1;
    if (l1==0)
    return(l2);
    else
    {
	while (laux->rem != 0)
	{
	    laux=laux->rem;
	}
	laux->rem=l2;
	return(l1);
    }
}
length_libin(lcp)
     lint *lcp;
{
    int res;
    res=0;
    while (lcp)
    {
	res++;
	lcp=lcp->rem;
    }
    return(res);
}



/* Tri d'une liste de bin\^omes 
(lex d\'ecroissant si ordre lex, norme -1 d\'ecroissante si revlex). */

lint *qsort_libin(l)
     lint *l;
{
    int x,y;
    lint *l1,*l2;
    l1=0;
    l2=0;
    if (length_libin(l)<2)
    return(l);
    else
    {
	x=l->first;
	l=l->rem;
	while (l)
	{
	    y=l->first;
	    l=l->rem;
	    if (order_exp(all_bin[x],all_bin[y])==-1)
	    l1=make_libin(y,l1);
	    else
	    l2=make_libin(y,l2);
	}
	return(append_libin(qsort_libin(l1),
			    make_libin(x,qsort_libin(l2))));
    }
}


/* Divisions d'exposants par des bin\^omes. */


/*  Quotient de e1 par e2.
 rend q max tel que e1+ - q*e2+ >= 0 
Une des fonctions qui bouffent du temps */

int quo_exp_pos (e1,e2)
     exponent e1,e2;
{
    int i,q;
    q=-1;        
    for  (i=0 ; i<dim ; i++)
    {
	if (e2[i]>0)
	{
	    if (e1[i]<=0)
	    return(0);
	    else if (q==-1)
	    q=e1[i]/e2[i];
	    else q=min_int(q,e1[i]/e2[i]);
	}
    }
    if (q==-1)
    return(0);
    else
    return(q);
}

/*  Quotient de -e1 par e2.
 rend q max tel que e1- - q*e2+ >= 0 
Une des fonctions qui bouffent du temps
}*/

int quo_exp_neg (e1,e2) 
     exponent e1,e2;
{
    int i,q;
    q=-1;     
    for  (i=0 ; i<dim ; i++)
    {
	if (e2[i]>0)
	{
	    if (e1[i]>=0)
	    return(0);
	    else if (q == -1)
	    q= -e1[i]/e2[i];
	    else
	    q=min_int(q,-e1[i]/e2[i]);
	}
    }
    if (q == -1) 
    return(0);
    else
    return(q);
}

/*  Division d'exposants .
On utilise le lemme 2: r\'eduction de la partie positive en forme normale,
puis r\'eduction de la partie n\'egative, le r\'esultat est en forme normale.
On rend :
0 si pas de reduction,
2 si la partie positive a change
1 sinon */

rem_exp_bin(e1,e2)
     exponent e1,e2;
{
    int change;
    exponent e1p;
    e1p=pos_exp(copy_exp(e1));
    change=rem_exp_bin_pos(e1,e2);
    change=max_int(change,rem_exp_bin_neg(e1,e2));
    if (change==0)
    return(0);
    else
    {
	e1=normalize_exp(e1);
	if (equal_pos_exp(e1p,e1))
	return(1);
	else
	return(2);
    }
}

rem_exp_bin_pos(e1,e2)
     exponent e1,e2;
{
    int q;
    q=quo_exp_pos(e1,e2);
    if (q)
    {
	e1=subq_exp(e1,e2,q);
	return(1);
    }
    else
    return(0);
}
rem_exp_bin_neg(e1,e2)
     exponent e1,e2;
{
    int q;
    q=quo_exp_neg(e1,e2);
    if (q)
    {
	e1=addq_exp(e1,e2,q);
	return(1);
    }
    else
    return(0);
}



/* Division par une liste de bin\^omes. */

int rem_exp_libin(e,lb)
     exponent e;
     lint *lb;
{
    int change;
    lint *lb1;
    exponent ep;
    ep=pos_exp(copy_exp(e));
    change=rem_exp_libin_pos(e,lb);
    change=max_int(change,rem_exp_libin_neg(e,lb));
    
    if (change==0)
    return(0);
    else
    {
	e=normalize_exp(e);
	if (equal_pos_exp(ep,e))
	return(1);
	else
	return(2);
    }
}


/* Division des parties positives */

int rem_exp_libin_pos(e,lb)
     exponent e;
     lint *lb;
{
    int q,change;
    lint *lb1;
    change=0;
    lb1=lb;
    while (lb1)
    {
	change=max_int(change,rem_exp_bin_pos(e,all_bin[lb1->first]));
	lb1=lb1->rem;
    }
    if (change)
    {
	change=rem_exp_libin_pos(e,lb);
	return(1);
    }
    else
    return(0);
}


/* Division des parties n\'egatives */

int rem_exp_libin_neg(e,lb)
     exponent e;
     lint *lb;
{
    int q,change;
    lint *lb1;
    change=0;
    lb1=lb;
    while (lb1)
    {
	change=max_int(change,rem_exp_bin_neg(e,all_bin[lb1->first]));
	lb1=lb1->rem;
    }
    if (change)
    {
	change=rem_exp_libin_neg(e,lb);
	return(1);
    }
    else
    return(0);
}


/* Division par deux listes de bin\^omes. */

int rem_exp_2libin(e,lb1,lb2)
     exponent e;
     lint *lb1,*lb2;
{
    int change;
    exponent ep;
    ep=pos_exp(copy_exp(e));

    change=rem_exp_2libin_pos(e,lb1,lb2);
    change=max_int(change,rem_exp_2libin_neg(e,lb1,lb2));
    if (change==0)
    return(0);
    else
    {
	e=normalize_exp(e);
	if (equal_pos_exp(ep,e))
	return(1);
	else
	return(2);
    }
}

int rem_exp_2libin_pos(e,lb1,lb2)
     exponent e;
     lint *lb1,*lb2;
{
    int change;
    lint *lb1aux,*lb2aux;
    change=0;
    lb1aux=lb1;
    lb2aux=lb2;
    while (lb1aux)
    {
	change=max_int(change,rem_exp_bin_pos(e,all_bin[lb1aux->first]));
	lb1aux=lb1aux->rem;
    }
    while (lb2aux)
    {
	change=max_int(change,rem_exp_bin_pos(e,all_bin[lb2aux->first]));
	lb2aux=lb2aux->rem;
    }
    if (change)
    {
	change =rem_exp_2libin_pos(e,lb1,lb2);
	return(1);
    }
    else
    return(0);
}

int rem_exp_2libin_neg(e,lb1,lb2)
     exponent e;
     lint *lb1,*lb2;
{
    int change;
    lint *lb1aux,*lb2aux;
    change=0;
    lb1aux=lb1;
    lb2aux=lb2;
    while (lb1aux)
    {
	change=max_int(change,rem_exp_bin_neg(e,all_bin[lb1aux->first]));
	lb1aux=lb1aux->rem;
    }
    while (lb2aux)
    {
	change=max_int(change,rem_exp_bin_neg(e,all_bin[lb2aux->first]));
	lb2aux=lb2aux->rem;
    }
    if (change)
    {
	change =rem_exp_2libin_neg(e,lb1,lb2);
	return(1);
    }
    else
    return(0);
}


/* Division de binomes. */

rem_ibin_ibin(b,b2)
     int b,b2;
{
    if (b==b2)
    return(0);
    else
    return(rem_exp_bin(all_bin[b],all_bin[b2]));
}


rem_ibin_libin(b,lb)
     int b;
     lint *lb;
{
    return(rem_exp_libin(all_bin[b],lb));
}

rem_ibin_2libin(b,lb1,lb2)
     int b;
     lint *lb1,*lb2;
{
    return(rem_exp_2libin(all_bin[b],lb1,lb2));
}

rem_neg_ibin_2libin(b,lb1,lb2)
     int b;
     lint *lb1,*lb2;
{
    return(rem_exp_2libin_neg(all_bin[b],lb1,lb2));
}


/* \section{Interr\'eduction.} */
/* Les indices des bin\^omes dont la t\^ete a \'et\'e r\'eduite  */
/* sont mis dans la liste left\_reduced. */
/* Ceux reduits a zero sont mis dans zero\_reduced. */ 
/* Interr\'eduit \`a partir d'une liste d'indices de bin\^omes d\'ej\`a */
/* interr\'eduits. Le premier de l2 est d\'ej\`a r\'eduit par l1. */
/* Rend les bin\^omes de l1 dont la t\^ete n'a pas \'et\'e r\'eduite. Les */
/* autres sont mis dans la variable globale new\_libin.  */
/* Les bin\^omes r\'eduits \`a 0 sont mis dans la variable globale  */
/* zero\_reduced.*/

struct lint *interred2(l1,l2)
     struct lint *l1,*l2;
{
    int change;
    int i1,i2;
    lint *laux1,*laux2,*laux3,*l1lr,*laux;
    laux1=make_libin(0,0);
    l1lr=0;

/* l1 + l1lr est suppose interreduit. */
    while (l2)
    {
	i2=l2->first; /* i2 est suppose reduit pour l1+l1lr */

	l1= interred_aux(l1,i2,laux1,l2);/* reduction de l1 par i2 */

	l1lr= interred_aux(l1lr,i2,laux1,l2);/* reduction de l1lr par i2 */

	/* on met i2 au debut de l1lr */

	laux=l2->rem;
	l2->rem=l1lr;
	l1lr=l2;
	l2=laux;
	/* on reduit le premier de l2 par l1 + l1lr 
	   jusqu'\`a ce qu'il ne donne pas 0.*/
	change=0;
	while (l2 && change==0)
	{
	    i2=l2->first;
	    change=rem_ibin_2libin(i2,l1,l1lr);
	    if (trivial_ibin(i2))
	    {
		laux=l2->rem;
		l2->rem=zero_reduced;
		zero_reduced=l2;
		nbin_reduced_0++;
		l2=laux;
		change=0;
	    }
	    else
	    change=1;
	}
    }
    /* reste a reduire les parties droites de l1 et l1lr entre elles.
     Les parties gauches ne changent pas car elles sont irreductibles
     entre elles (lemme - ... - + => +)
     On peut virer cette etape si on ne veut pas une base dont les parties
     droites sont reduites.  */
    if (right_reduce)
    {
	laux=l1;
	while (laux)
	{
	    change=rem_neg_ibin_2libin(laux->first,l1,l1lr);
	    laux=laux->rem;
	}
	laux=l1lr;
	while (laux)
	{
	    change=rem_neg_ibin_2libin(laux->first,l1,l1lr);
	    laux=laux->rem;
	}
    }
    
    left_reduced=l1lr;
    return(l1);
}

/* Met dans l2 ceux de l dont la tete est reduite par i2, laisse les autres.
 i2 est le premier de l2. */

lint *interred_aux(l,i2,laux1,l2)
     lint *l,*laux1,*l2;
     int i2;
{
    int change;
    int i1;
    lint *laux2,*laux3,*laux;
    
    laux1->rem=l;
    laux2=laux1;
    laux3=laux2->rem;
    while (laux3)
    {
	i1=laux3->first;
	change=rem_ibin_ibin(i1,i2);
	if (change<2)  /* on continue */
	{
	    laux2=laux2->rem;
	    laux3=laux2->rem;
	}
	else if (trivial_ibin(i1)) /* on met i1 dans zero_reduced */
	{
	    laux=laux3->rem;
	    laux3->rem=zero_reduced;
	    zero_reduced=laux3;
	    nbin_reduced_0++;
	    laux2->rem=laux;
	    laux3=laux;
	}
	else    /* on met i1 apres i2 dans l2 */
	{
	    laux=laux3->rem;
	    laux3->rem=l2->rem;
	    l2->rem=laux3;
	    laux2->rem=laux;
	    laux3=laux;
	}
    }
    return(laux1->rem);
}
   
void interred_right(l)
     lint *l;
{
    lint *laux;
    if (right_reduce==0)
    {
	laux=l;
	while (laux)
	{
	    rem_neg_ibin_2libin(laux->first,l,0);
	    laux=laux->rem;
	}
    }
}

    

/* Interreduit l.  */


struct lint *interred(l)
     struct lint *l;
{
    if (l==0)
    return(l);
    else
    l=interred2(0,l);
    return(append_libin(l,left_reduced));
    
}


/* \section{Fonctions sur les paires critiques et les listes de paires  */
/* critiques.} */



/* Cr\'eation d'une paire critique. */

cpair *make_cpair(i1,i2)
     int i1,i2;
{
    cpair *cp;
    cp=(cpair *)malloc(sizeof(cpair));
    cp->i1=i1;
    cp->i2=i2;
    ncpair_created++;
    return(cp);
}


/* Impression d'une paire critique. */

print_cpair(cp)
     cpair *cp;
{
    printf("Paire (%d,%d)\ntete:  ",cp->i1,cp->i2);
}


/* Le tableau des paires critiques. */

void add_cpair(cp)
     cpair *cp;
{
    last_cpair++;
    all_cpair[last_cpair]=cp;
}
cpair *next_cpair()
{
    cpair *cp;
    cp = all_cpair[first_cpair];
    all_cpair[first_cpair]=0;
    first_cpair++;
    return(cp);
}


/* Paire critique de deux indices de bin\^omes. */
/* Les champs head et spol ne sont pas remplis. */
/* Rend le pointeur 0 s'il n'y */
/* en a pas */

cpair *cpair_ibin(i,j)
     int i,j;
{
    exponent e,ei,ej;
    if (i==j)
    return(0);
    else if (i>j)
    return(cpair_ibin(j,i));
    else
    {
	ei=all_bin[i];
	ej=all_bin[j];
	if (disjoint_exp(ei,ej))
	return(0);
	else 
	return(make_cpair(i,j));
    }
}



/* Remplit les champs head et spol d'une paire critique. */

exponent head_cpair(cp)
     cpair *cp;
{
    exponent ei,ej;
    int i,j;
    i=cp->i1;
    j=cp->i2;
    ei=all_bin[i];
    ej=all_bin[j];
    return(max_exp(copy_exp(ei),ej));
}
exponent spol_cpair(cp)
     cpair *cp;
{
    exponent ei,ej;
    int i,j;
    i=cp->i1;
    j=cp->i2;
    ei=all_bin[i];
    ej=all_bin[j];
    return(sub_exp(copy_exp(ei),ej));
}


/* Liste des paires critiques d'un indice de binome et d'une liste d'indices */
/* de bin\^omes. */

void lcpair_ibin_libin(i,l2)
     lint *l2;
     int i;
{
    cpair *cp;
    lint *l2aux;
    int j;
    
    l2aux=l2;
    while (l2aux)
    {
	j=l2aux->first;
	l2aux=l2aux->rem;
	cp=cpair_ibin(i,j);
	if (cp)
	add_cpair(cp);
    }
}


/* Liste des paires critiques de deux listes d'indices de bin\^omes. */

void lcpair_libin(l1,l2)
     lint *l1,*l2;
{
    cpair *cp;
    lint *l2aux;
    int i,j;
    
    if (l2!=0)
    while (l1)
    {
	i=l1->first;
	l1=l1->rem;
	l2aux=l2;
	while (l2aux)
	{
	    j=l2aux->first;
	    l2aux=l2aux->rem;
	    cp=cpair_ibin(i,j);
	    if (cp)
	    add_cpair(cp);
	}
    }
}


/* Crit\`ere d'\'elimination des paires critiques. */

elim_cpair(cp,head)
     cpair *cp;
     exponent head;
{
    lint *li;
    li = base;
    while (li)
    {
	if (elim_cpair_ibin(cp,head,li->first) == 1)
	return(1);
	else
	li=li->rem;
    }
    return(0);
}

elim_cpair_ibin(cp,head,k)
     cpair *cp;
     exponent head;
     int k;
{
    exponent ek,ei,ej;
    int i,j,d;
    i=cp->i1;
    j=cp->i2;
    if ((k==i)||(k==j))
    return(0);
    else 
    {
	ek=all_bin[k];
	ei=all_bin[i];
	ej=all_bin[j];
	if (div_exp(ek,head)==0)
	return(0);
	else
	{
	    return( ( (k<i) || divs_exp3(ek,ei,head) )
		   &&
		   ( (k<j) || divs_exp3(ek,ej,head) ) );
	}
    }
    
}


/* Teste si ppcm(ek,ei) divise stritement eij (eij >=0), sachant que ek divise
eij.   */

divs_exp3(ek,ei,eij)
     exponent ek,ei,eij;
{
    int i;
    for  (i=0 ; i<dim ; i++)
    {
	if ((ek[i]>=0) && (ei[i]>=0)
	    && (max_int(ek[i],ei[i])<eij[i]))
	return(1);
    }
    return(0);
}

/* Ne garder que les paires de lcp dont les indices sont dans l. 
La fonction qui bouffe du temps */

void remove_lcpair(l)
     lint *l;
{
    lint *l1;
    cpair *cp;
    int i,ncp;
    ncp=-1;
    for (i=0;i<=all_bin_max;i++) all_ibin[i]=0;
    l1=l;
    while(l1)
    {
	all_ibin[l1->first]=1;
	l1=l1->rem;
    }
    for(i=first_cpair;i<=last_cpair;i++)
    {
	cp=all_cpair[i];
	if ((all_ibin[cp->i1]==0) || (all_ibin[cp->i2]==0))
	{
	    all_cpair[i]=0;
	    ncpair_interred++;
	}
	else
	{
	    ncp++;
	    all_cpair[i]=0;
	    all_cpair[ncp]=cp;
	}
    }
    last_cpair=ncp;
    first_cpair=0;
}
	    
void remove_lcpair_old(l)
     lint *l;
{
    cpair *cp;
    int i,ncp;
    ncp=-1;
    
    for(i=first_cpair;i<=last_cpair;i++)
    {
	cp=all_cpair[i];
	if ( !(member_libin(cp->i1,l)) ||
	    !(member_libin(cp->i2,l)))
	{
	    all_cpair[i]=0;
	    ncpair_interred++;
	}
	else
	{
	    ncp++;
	    all_cpair[i]=0;
	    all_cpair[ncp]=cp;
	}
    }
    last_cpair=ncp;
    first_cpair=0;
}
	    
member_libin(b,l)
     lint *l;
     int b;
{
    while (l)
    {
	if (b==l->first)
	return(1);
	else
	l=l->rem;
    }
    return(0);
}


/* R\'eseaux de $Z^n$. */

lattice *read_lattice()
{
    lattice *lat;
    int rank;
    exponent b;
    int i,r;
    
    printf("Dimension du reseau: \n");
    scanf("%d",&dim);
    printf("Rang du reseau: \n");
    scanf("%d",&rank);
    printf("Donnez les generateurs ligne par ligne:\n");
    
    lat=0;
    for (r=1; r<=rank; r++)
    {
	b=(exponent)malloc(sizeof(int)*dim);
	for (i=0;i<dim; i++)
	{
	    scanf("%d",&b[i]);
	}
	lat=make_lattice(b,lat);
    }
    dim_sg=rank;
    return(lat);
}
	

/* Cr\'eation d'un r\'eseau: liste d'exposants.  */

lattice *make_lattice(b,rem)
     exponent b;
     lattice *rem;
{
    lattice *l;
    l=(lattice *)malloc(sizeof(lattice));
    l->first = b;
    l->rem = rem;
    return(l);
}


/* Impression d'un r\'eseau. */

print_lattice(s)
     lattice *s;
{
    printf("reseau:\n{\n");
    print_lattice_rec(s);
    printf("}\n");
}
    
print_lattice_rec(s)
     lattice *s;
{
    if (s)
    {
	print_exp(s->first);
	print_lattice_rec(s->rem);
    }
    ;
} 


/* Cr\'eation d'un id\'eal. */

ideal *make_ideal(b,rem)
     exponent b;
     ideal *rem;
{
    ideal *l;
    l=(ideal *)malloc(sizeof(ideal));
    l->first = b;
    l->rem = rem;
    return(l);
}
ideal *append_ideal(l1,l2)
     ideal *l1,*l2;
{
    ideal *laux;
    laux=l1;
    if (l1==0)
    return(l2);
    else
    {
	while (laux->rem != 0)
	{
	    laux=laux->rem;
	}
	laux->rem=l2;
	return(l1);
    }
}
length_ideal(lcp)
     ideal *lcp;
{
    int res;
    res=0;
    while (lcp)
    {
	res++;
	lcp=lcp->rem;
    }
    return(res);
}


/* Impression d'un id\'eal. */

print_ideal(s)
     ideal *s;
{
    printf("ideal \n(\n");
    print_ideal_rec(s);
    printf(")\n");
}
    
print_ideal_rec(s)
     ideal *s;
{
    if (s)
    {
	print_exp(s->first);
	print_ideal_rec(s->rem);
    }
    ;
} 


/* Id\'eal torique associ\'e \`a un r\'eseau.  */
/* dim est la dimension du r\'eseau. */

ideal *ideal_lattice(l)
     lattice *l;
{
    ideal *id;
    exponent e,e1;
    int i;
    id=0;
    dim++;

    e1= (exponent)malloc(sizeof(int)*dim);
    for  (i=0 ; i<dim ; i++)
    {
	e1[i]=1;
    }
    id=make_ideal(e1,id);
    while (l)
    {
	e1= (exponent)malloc(sizeof(int)*dim);
	e=l->first;
	l=l->rem;
	e1[0]=0;
	for  (i=0 ; i<(dim-1) ; i++)
	{
	    e1[i+1]=e[i];
	}
	id=make_ideal(e1,id);
    }
    return(id);
}

/*  La m\^eme chose mais sans TX1-1.  */

ideal *ideal2_lattice(l)
     lattice *l;
{
    ideal *id;
    exponent e,e1;
    int i;
    id=0;
    while (l)
    {
	id=make_ideal(copy_exp(l->first),id);
	l=l->rem;
    }
    return(id);
}

/* Construction d'un fichier d'entree pour Macaulay, a partir de l'ideal (liste d'indices de binomes) dont on calcule la base standard */
make_input_for_macaulay(lint *id)
{
   FILE *f;
   int n,i;
   lint *idaux;
   exponent e;
   int c;
   n=0;
   idaux = id;

   while (idaux)
   {
      n++;
      idaux=idaux->rem;
   }
   f=fopen("input-macaulay","w");
   fprintf(f,"monitor output-macaulay\nring R\n");
   fprintf(f,"\n%d\n",dim);
   for(i=0;i<dim;i++)
      fprintf(f,"x[%d]",i);
   fprintf(f,"\n\n1 %d\n\n",dim-1);
   fprintf(f,"ideal I\n%d\n",n);
   while (id)
   {
      e=all_bin[id->first];
      id=id->rem;
      c=0;
      for(i=0;i<dim;i++)
	 if (e[i]>0)
	 {
	    fprintf(f,"x[%d]%d",i,e[i]);
	    c=1;
	 }
      if (c==0) fprintf(f,"1");
      c=0;
      fprintf(f,"-");
      for(i=0;i<dim;i++)
	 if (e[i]<0)
	 {
	    fprintf(f,"x[%d]%d",i,-e[i]);
	    c=1;
	 }
      if (c==0) fprintf(f,"1");
      fprintf(f,"\n");
   }
   fprintf(f,"<inhomog_std I J\nelim J H\nputstd H\n");
   fclose(f);
}

/* Base standard d'un r\'eseau. */

lint *basta_lattice(l)
     lattice *l;
{
    lint *libin;
    ideal *id;
    id=ideal_lattice(l);
    libin=0;
    while (id)
    {
	libin=make_libin(new_bin(id->first),libin);
	id=id->rem;
    }
    libin=basta_toric(libin);

    return(libin);
    
}


/* \section{Calcul d'une base standard d'une liste d'indices de bin\^omes.} */

/*  Initialisation des variables d'info du calcul de base standard.

 Info sur un calcul de bases standard.  */

void init_info_basta()
{
    ncpair_created=0;
    ncpair_treated=0;
    ncpair_interred=0;
    ncpair_eliminated=0;
    ncpair_reduced_0=0;
    ncpair_reduced_not_0=0;
    nbin_reduced_0=0;
    zero_reduced=0;

 }

void print_info_basta ()
{
    printf("\nPaires creees: %d\n",ncpair_created);
    printf("Paires traitees: %d\n",ncpair_treated);
    printf("Paires eliminees par interreduction: %d\n",ncpair_interred);
    printf("Paires eliminees par le critere: %d\n",ncpair_eliminated);
    printf("Paires reduites a zero: %d\n",ncpair_reduced_0);
    printf("Paires donnant un nouveau binome: %d\n",ncpair_reduced_not_0);
    printf("Nombre de binomes crees: %d\n",all_bin_max);
    printf("Nombre de binomes reduits a zero: %d\n",nbin_reduced_0);
    printf("Nombre de binomes dans la base: %d\n",length_libin(base));
}
void print_info_in_algo()
{
    info_loop++;
    if (info_loop%1==0)
    {
	printf("[%d,%d]",
	       length_libin(base),
	       last_cpair-first_cpair+1
	       );
	fflush(stdout);
    }
}

/* \subsection{Algorithme avec interr\'eduction.} */

lint *basta(libin)
     lint *libin;
{
    cpair *cp;
    exponent b;
    int i;
    int change;
    right_reduce=0;
    last_cpair=-1;
    first_cpair=0;
    info_loop=0;
    base=libin;
    left_reduced=0;
    base=interred(base);
    lcpair_libin(base,base);
/*     ajour_pc();
    go_xjauge();*/
    while (first_cpair<=last_cpair)
    {
	cp=next_cpair();
	ncpair_treated++;

	if (elim_cpair(cp,head_cpair(cp)) == 1)
	ncpair_eliminated++;
	else
	{
	    b=spol_cpair(cp);
	    change = rem_exp_libin(b,base);
	    if (trivial_exp(b))
	    ncpair_reduced_0++;
	    else
	    {
		ncpair_reduced_not_0++;
		print_info_in_algo();
		i=new_bin(b);
		/* ajour_pc();*/
		/*	print_info_basta();	*/
		left_reduced=0;
		base=interred2(base,make_libin(i,0));
		remove_lcpair(base);
		lcpair_libin(base,left_reduced);
		lcpair_libin(left_reduced,left_reduced);
		base=append_libin(base,left_reduced);
	    }
	}
    }
    interred_right(base);
    /* ajour_pc();*/
    return(qsort_libin(base));
}


void go_xjauge()
{
    system("ksh -c \`xjauge -file all_cpair -yfactor 1000 -update 1 -label Paires_critiques_unite_1000\`&");
}

void ajour_pc()
{
    FILE *f;
    f=fopen("paires_critiques","w");
    fprintf(f,"%d\n",
	    ncpair_created - ncpair_treated - ncpair_interred);
    fclose(f);
}


	

/* Calcul d'une base standard torique d'une liste d'indices de bin\^omes. */

lint *basta_toric(libin)
     lint *libin;
{
    lint *l1,*l2,*l;
    
    init_info_basta();
    make_input_for_macaulay(libin);
    l1=copy_libin(libin);
    l1=basta(l1);
    
    return(l1);    
}



/* Base standard de l'id\'eal torique: on vire la premiere variable.*/

ideal *bs_ideal(bs)
     lint *bs;
{
    exponent b;
    
    if (!bs)
    return(0);
    else
    {
	b=all_bin[bs->first];
	if (b[0]==0)
	return(make_ideal(b+1,bs_ideal(bs->rem)));
	else
	return(bs_ideal(bs->rem));
    }
}
	


/* \section{Matrices}
   
Vecteur de lignes (exposants).   
Les dimensions sont dans les variables globales nlig et ncol */

mat new_mat(nlig,ncol)
     int nlig,ncol;
{
    int i,j;
    mat m;
    exponent e;
    m=(mat)malloc(nlig*sizeof(exponent));
    for(i=0;i<nlig;i++)
    {
	e=(exponent)malloc(ncol*sizeof(int));
	for (j=0;j<ncol;j++) e[j]=0;
	m[i]=e;
    }
    return(m);
}
mat cp_mat(m)
     mat m;
{
    mat mc;
    int i,j;
    
    mc=new_mat(nlig,ncol);
    for (i=0;i<nlig;i++)
    for (j=0;j<ncol;j++)
    mc[i][j]=m[i][j];
    return mc;
}

mat read_mat()
{
    mat m;
    int i,j;
    printf("Nombre de colonnes: \n");
    scanf("%d",&ncol);
    printf("Nombre de lignes: \n");
    scanf("%d",&nlig);
    m=new_mat(nlig,ncol);
    printf("Donnez les coefficients de la matrice ligne par ligne:\n");
    for (i=0;i<nlig;i++)
    {
	for (j=0;j<ncol;j++)
	{
	    /*	    printf("(%d,%d)",i,j);*/
	    scanf("%d",&(m[i][j]));
	}
    }
    return(m);
}  
/* Construction d'un fichier d'entree pour Macaulay, a partir de la matrice des parametres de la variete */
make_input_mat_for_macaulay(mat m)
{
   FILE *f;
   int i,g;
   exponent e;
   int c;

   f=fopen("input-mat-macaulay","w");
   fprintf(f,"monitor output-macaulay\nring R\n");
   fprintf(f,"\n%d\n",1+nlig+ncol);
   fprintf(f,"u");
   for(i=0;i<nlig;i++)  fprintf(f,"t[%d]",i+1);
   for(i=0;i<ncol;i++)  fprintf(f,"x[%d]",i+1);
   fprintf(f,"\n\n%d %d\n\n",1+nlig,ncol);
   fprintf(f,"ideal I\n%d\n",1+ncol);
   for(g=0;g<ncol;g++)
   {
      fprintf(f,"x[%d]",g+1);
      for(i=0;i<nlig;i++) if (m[i][g]<0) fprintf(f,"t[%d]%d",i+1,-m[i][g]);
      fprintf(f,"-");
      c=0;
      for(i=0;i<nlig;i++)
	 if (m[i][g]>0)
	    {
	       fprintf(f,"t[%d]%d",i+1,m[i][g]);
	       c=1;
	    }
      if (c==0) fprintf(f,"1");
      fprintf(f,"\n");
   }
   fprintf(f,"u");
   for(i=0;i<nlig;i++)  fprintf(f,"t[%d]",i+1);
   for(i=0;i<ncol;i++)  fprintf(f,"x[%d]",i+1);
   fprintf(f,"-1\n");
   fprintf(f,"<inhomog_std I J\nelim J H\nputstd H\n");
   fclose(f);
}

void print_mat(m)
     mat m;
{
    int i,j;
    printf("Matrice:\n");
    for(i=0;i<nlig;i++)
    {
	for(j=0;j<ncol;j++)
	printf("%3d ",m[i][j]);
	printf("\n");
    }
}

/* Base du noyau  (vecteurs=lignes de la matrice rendue)*/

mat kernel(m)
     mat m;
{
    mat m1, mk;
    int i,j,j0,r;
        
    m1=new_mat(nlig+ncol,ncol);
    for(i=0;i<nlig;i++)
    for(j=0;j<ncol;j++)
    m1[i][j]=m[i][j];
    for(i=0;i<ncol;i++)
    m1[i+nlig][i]=1;

    nlig_max=nlig;
    nlig=nlig+ncol;
    
    j0=triang_ij(m1,0,0);
    
    r=ncol-j0;
    nlig=nlig-ncol;
    mk=new_mat(r,ncol);
    for (i=0;i<r;i++)
    for (j=0;j<ncol;j++)
    mk[i][j]=m1[nlig+j][j0+i];
    nlig=r;
    ncol=ncol;
    return(mk);
}


/* Transpos\'ee */

mat transpose_mat(m)
     mat m;
{
    mat mt;
    int i,j;
    
    mt=new_mat(ncol,nlig);
    for(i=0;i<nlig;i++)
    for(j=0;j<ncol;j++)
    mt[j][i]=m[i][j];
    return(mt);
}


/* Forme d'Hermite  (colonnes \'eventuellement permut\'ees)*/

mat Hermite(m)
     mat m;
{
    mat mh;
    mh=cp_mat(m);
    triang(mh);
    return(mh);
}



/* Forme de Smith (colonnes et lignes \'eventuellement permut\'ees) */

mat Smith(m)
     mat m;
{
    mat ms;
    int aux;
    
    ms=cp_mat(m);
    triang(ms);
    ms=transpose_mat(ms);
    aux=ncol;
    ncol=nlig;
    nlig=aux;
    triang(ms);
    ms=transpose_mat(ms);
    aux=ncol;
    ncol=nlig;
    nlig=aux;
    
    return(ms);
}


/* D\'eterminant de la matrice Graham d'une matrice (vecteurs=lignes) */

int det_Graham(m)
     mat m;
{
    mat g;
    int i,j,k,det,vivj,ncol_old;
    g=new_mat(nlig,nlig);
    for(i=0;i<nlig;i++)
    for(j=0;j<nlig;j++)
    {
	vivj=0;
	for(k=0;k<ncol;k++)
	vivj=vivj+m[i][k]*m[j][k];
	g[i][j]=vivj;
    }
    ncol_old=ncol;
    ncol=nlig;
    triang(g);
    det=1;
    for(i=0;i<nlig;i++)
    det=det*g[i][i];
    ncol=ncol_old;
    return(abs(det));
}


/* Triangularise par manipulations unimodulaires des colonnes.
Rend l'indice de colonne d'arr\^et .
Modifie physiquement la matrice.*/

int triang(m)
     mat m;
{
    nlig_max=nlig;
    return triang_ij(m,0,0);
}

/* A partir du coefficient ligne i, colonne j */

int triang_ij(m,i,j)
     mat m;
     int i,j;
{
    if (i<nlig_max && j<ncol)
    {
	if (m[i][j]!=0)
	return triang_ij_n0(m,i,j);
	else
	return triang_ij_0(m,i,j);
    }
    return(j);
}
int  triang_ij_n0(m,i0,j0)
     mat m;
     int i0,j0;
{
    int i,j;
	exponent bez;
    for (j=j0+1;j<ncol;j++)
    {
	int a,b,x,y;
	a=m[i0][j0];
	b=m[i0][j];
	bez=bezout(a,b);
	for (i=0;i<nlig;i++)
	{
	    x=m[i][j0];
	    y=m[i][j];
	    m[i][j0]=x*bez[1]+y*bez[2];
	    m[i][j]=(x*b-y*a)/bez[0];
	}
    }
    return triang_ij(m,i0+1,j0+1);
}
int  triang_ij_0(m,i0,j0)
     mat m;
     int i0,j0;
{
    int i,j,j1;
    j1=0;
    /* for(j=j0+1;j<ncol;j++)*/
    for (j=ncol-1;j>j0;j--)
    {
	if (m[i0][j]!=0)
	j1=j;
    }
    if (j1==0)
    return triang_ij(m,i0+1,j0);
    else
    {
	for(i=0;i<nlig;i++)
	{
	    int aux;
	    aux=m[i][j0];
	    m[i][j0]=m[i][j1];
	    m[i][j1]=aux;
	}
	return triang_ij_n0(m,i0,j0);
    }
}

/* Bezout: rend un exposant
res[0]=pgcd(a,b) res[1] = u res[2]=v avec au+bv =pgcd(a,b) */

exponent bezout(a,b)
     int a,b;
{
    exponent res;
    int a0,b0,a1,a2,b1,b2,q,r;
    a0=a;
    b0=b;
    a1=1;
    a2=0;
    b1=0;
    b2=1;
    while (a0!=0 && b0!=0)
    {
	if (abs(a0)>abs(b0))
	{
	    r=a0%b0;
	    q=(a0-r)/b0;
	    a0=a0-q*b0;
	    a1=a1-q*b1;
	    a2=a2-q*b2;
	}
	else
	{
	    r=b0%a0;
	    q=(b0-r)/a0;
	    b0=b0-q*a0;
	    b1=b1-q*a1;
	    b2=b2-q*a2;
	}
    }
    res=(exponent)malloc(3*sizeof(int));
    if (a0!=0)
    {
	res[0]=a0;
	res[1]=a1;
	res[2]=a2;
    }
    else
    {
	res[0]=b0;
	res[1]=b1;
	res[2]=b2;
    }
    return(res);
}



/* Escalier d'un id\'eal. 
On l'ordonne par ordre lexico d\'ecroissant.*/

ideal *escalier(i)
     ideal *i;
{
    ideal *esc;
    esc=0;
    while (i)
    {
	esc=make_ideal(pos_exp(copy_exp(i->first)),esc);
	i=i->rem;
    }
    return(qsort_ideal(esc));
}

ideal *qsort_ideal(l)
     ideal *l;
{
    exponent x,y;
    ideal *l1,*l2;
    l1=0;
    l2=0;
    if (length_ideal(l)<2)
    return(l);
    else
    {
	x=l->first;
	l=l->rem;
	while (l)
	{
	    y=l->first;
	    l=l->rem;
	    if (lex_exp(x,y)==-1)
	    l1=make_ideal(y,l1);
	    else
	    l2=make_ideal(y,l2);
	}
	return(append_ideal(qsort_ideal(l1),
			    make_ideal(x,qsort_ideal(l2))));
    }
}



/* Max d'un exposant avec un escalier non vide
rend l'escalier minimal.*/

ideal *inter_exp_esc(e,esc)
     exponent e;
     ideal *esc;
{
    ideal *res;
    res=0;
    while (esc)
    {
	res=make_ideal(max_exp(copy_exp(e),esc->first),res);
	esc=esc->rem;
    }
    return(min_el_esc(res));
}


/* El\'ements minimaux d'un escalier */

ideal *min_el_esc(esc)
     ideal *esc;
{
    if (esc->rem==0) 
    return(esc);
    else
    {
	ideal *esc1,*esc2,*res;
	exponent x,y;
	res=0;
	
	x=esc->first;
	esc1=min_el_esc(esc->rem);
	esc2=esc1;
	
	while (esc2)
	{
	    y=esc2->first;
	    if (div_exp(y,x)==1)
	    return(esc1);
	    else if (div_exp(x,y)==0)
	    res=make_ideal(y,res);
	    esc2=esc2->rem;
	}
	return(make_ideal(x,res));
    }
}


/*   Coefficient du bin\^ome: C(n,p)
 */

double binomial_coef(n,p)
     int n,p;
{
    double res;
    int i;
    if (n>=0 && p>n)
    res=0;
    else
    {
	res=1;
	for(i=0;i<p;i++)
	res=res*(n-i)/(p-i);
    }
    return(res);
}


/* Contribution d'un exposant au degr\'e de la vari\'et\'e:
   dim est le nombre variables,
   dim_sg est la dimension su sous-groupe.
   C(dim-a,dim_sg)  */

double contrib_exp(e)
     exponent e;
{
    double res;
    res=binomial_coef(dim-1-deg_exp(e),dim_sg);
    return(res);
}


/* Contribution d'un escalier */

double contrib_esc(esc)
     ideal *esc;
{
    double p;
    if (esc->rem==0)
    p=contrib_exp(esc->first);
    else
    p=(contrib_exp(esc->first)+contrib_esc(esc->rem))
      -contrib_esc(inter_exp_esc(esc->first,esc->rem));
    return(p);
}

/* Degr\'e d'un escalier */

double deg_esc(esc)
     ideal *esc;
{
    double res;
    res=binomial_coef(dim-1,dim_sg) - contrib_esc(esc);
    return(res);
}
/* Homogeneise une matrice rajoute une ligne telle que la somme des colonnes donne 1 */
mat homog_mat(m)
     mat m;
{
    int i,j,s;
    mat mh;
    mh=new_mat(nlig+1,ncol);
    for(j=0;j<ncol;j++)
    for(i=0;i<nlig;i++)
    mh[i][j]=m[i][j];
    for(j=0;j<ncol;j++)
    {
	s=0;
	for(i=0;i<nlig;i++)
	s=s+mh[i][j];
	mh[nlig][j]=1-s;
    }
    nlig++;
    return(mh);
}
/* Teste si une matrice est homogene: la somme des colonnes est constante */
int is_homog_mat(m)
     mat m;
{
    int i,j,s,sj;
    s=0;
    for(i=0;i<nlig;i++)
    s=s+m[i][0];
    for(j=1;j<ncol;j++)
    {
	sj=0;
	for(i=0;i<nlig;i++)
	sj=sj+m[i][j];
	if (s!=sj) return(0);
    }
    return(1);
}
/* Lancement */
main()
{
    lattice *lat;
    lint *bs;
    ideal *i;
    struct rusage rusage1,rusage2;
    float u_time1, s_time1,u_time2, s_time2;
    mat m;
    int j,aux,m_homog;

    m_homog=0;
    all_bin_max=0;
    getrusage(RUSAGE_SELF, &rusage1);
    baniere();
    printf("Ordre sur les monomes:\n");
    scanf("%d",&binomial_order);
    if (binomial_order>1 || binomial_order<0)
    {
	/* cas ou on bonne le reseau par ses generateurs
           l'ordre est le modulo 2*/
	binomial_order=binomial_order%2;
	lat=read_lattice();
    }
    else
    {
	printf("Matrice des monomes (= colonnes) definissant la variete:\n");
	m=read_mat();
	make_input_mat_for_macaulay(m);
	m_homog=is_homog_mat(m);
	/*	m=homog_mat(m); */ /* si on veut homogeneiser la variete */
	m=kernel(m);
	print_mat(m);
	
	/* printf("Determinant de la matrice de Graham: %d\n",det_Graham(m));*/
	lat=0;
	dim=ncol;
	for(j=0;j<nlig;j++)
	lat=make_lattice(m[j],lat);
	dim_sg=nlig;
    }
    /* verifie que les bases lex et revlex s'autoreduisent */
    /* verif(lat); */
    
    bs=basta_lattice(lat);
    i=bs_ideal(bs);
    dim--;
    printf("\nBase standard de l'");
    print_ideal(i);
    /* print_info_basta();*/
    getrusage(RUSAGE_SELF, &rusage2);
    u_time1 = rusage1.ru_utime.tv_sec + 10e-7 * rusage1.ru_utime.tv_usec;
    s_time1 = rusage1.ru_stime.tv_sec + 10e-7 * rusage1.ru_stime.tv_usec;
    u_time2 = rusage2.ru_utime.tv_sec + 10e-7 * rusage2.ru_utime.tv_usec;
    s_time2 = rusage2.ru_stime.tv_sec + 10e-7 * rusage2.ru_stime.tv_usec;
    printf("Temps: %.2fs\n",u_time2-u_time1);
    printf("Nombre de binomes dans la base standard: %d\n",
	   length_ideal(i));
    printf("Dimension de la variete: %d\n",dim-dim_sg);
    if (m_homog)
    {
	printf("L'ideal est homogene.\n");
	printf("Calcul du degre de la variete?(repondre par 0 ou 1):\n");
	scanf("%d",&aux);
	if (aux)
	{
	    double degree;
	    i=escalier(i);
	    getrusage(RUSAGE_SELF, &rusage1);
	    degree=deg_esc(i);
	    printf("Degre %.0f\n",degree); 
	    getrusage(RUSAGE_SELF, &rusage2);
            u_time1 = rusage1.ru_utime.tv_sec + 10e-7 * rusage1.ru_utime.tv_usec;
	    s_time1 = rusage1.ru_stime.tv_sec + 10e-7 * rusage1.ru_stime.tv_usec;
	    u_time2 = rusage2.ru_utime.tv_sec + 10e-7 * rusage2.ru_utime.tv_usec;
	    s_time2 = rusage2.ru_stime.tv_sec + 10e-7 * rusage2.ru_stime.tv_usec;
	    printf("Temps: %.2fs\n",u_time2-u_time1);
	}
    }
}
/* V\'erification lex revlex */
               
void verif(lat)
     lattice *lat;
{
    lint *blex,*brevlex,*bl,*br;
    exponent e;
    
    binomial_order=0;
    blex=basta_lattice(lat);
    dim--;
    binomial_order=1;
    brevlex=basta_lattice(lat);
    bl=blex;
    br=brevlex;
    binomial_order=1;
    while(bl)
    {
	e=copy_exp(all_bin[bl->first]);
	rem_exp_libin(e,brevlex);
	if (!trivial_exp(e))
	{
	    printf("Probleme dans lex: ");
	    print_exp(all_bin[bl->first]);
	}
	bl=bl->rem;
    }
    binomial_order=0;
    while(br)
    {
	e=copy_exp(all_bin[br->first]);
	rem_exp_libin(e,blex);
	if (!trivial_exp(e))
	{
	    printf("Probleme dans revlex: ");
	    print_exp(all_bin[br->first]);
	}
	br=br->rem;
    }
    dim--;
}
    

/* exemples
--------
Morales et Gimenez

courbe parametree:
y=s281t500
z=st780
x=s781
w=t781

matrice:
281 1      781 0
500 780 0     781

basta:
2

4
2

-1 281 0 -280
-3 62   1 -60

donne

[0 -1 281 0 -280]
[1 -38 26 15 1]
[0 -3 62 1 -60]
[1 -24 -3 10 21]
[1 1 1 1 1]
[0 39 -25 -14 0]
[1 4 -61 0 61]
[1 15 -28 -4 21]
[0 2 219 -1 -220]
[0 25 4 -9 -20]
[1 2 -280 1 281]
[0 -14 29 5 -20]
[0 5 157 -2 -160]
[1 -10 -32 5 41]
[1 -1 -218 2 221]
[1 -7 -94 4 101]
[0 8 95 -3 -100]
[0 11 33 -4 -40]
[1 -4 -156 3 161]

------ 
noyau de magic3
a   b   c   d   e   f   g   h   i   j
1 -1  0 -1  1  0   0   0  0  0 
0  1 -1  0 -1  1   0   0  0  0 
0  0 -1  -1 0  0   0 -1 0 -1 
0  0  0   1 -1  0 -1   1 0   0 
0  0  0   0 -1  1   0   1 -1 0


avec macaulay:
 set maxdegree 4000
ring R

11
 tabcdefghij

1 10

ideal I
6
 tabcdefghij-1
ae-bd
bf-ce
cdhj-1
dh-eg
fh-ei

<inhomog_std I bs
type bs

avec basta:
2
10
5
1 -1  0 -1  1  0   0   0  0  0 
0  1 -1  0 -1  1   0   0  0  0 
0  0 -1  -1 0  0   0 -1 0 -1 
0  0  0   1 -1  0 -1   1 0   0 
0  0  0   0 -1  1   0   1 -1 0


les escaliers sont les memes. */                      



