#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
/***********************************************************************/
/*
 Le GC de St\'ephane. 
*/
/***********************************************************************/
#include "gc.h"
#define malloc(n) GC_malloc(n)
/***********************************************************************/
/* 
\section{Les types de donn\'ees pour les calcul de bases standard toriques.}

Exposants=monomes=binomes=vecteurs 
 */
/***********************************************************************/
typedef int *exponent;
typedef double coef;
typedef coef *coefs;
typedef struct pol
{
    int deg;
    coefs coef;
}
pol;

/***********************************************************************/
/* liste d'entiers  */
/***********************************************************************/
typedef struct lint
{
    int first;
    struct lint *rem;
}
lint;
/***********************************************************************/
/* Les paires critiques */
/***********************************************************************/
typedef struct cpair
{
    int i1;
    int i2;
}
cpair;

typedef struct lcpair
{
    cpair *first;
    struct lcpair *rem;
}
lcpair;

/***********************************************************************/
/* R\'eseaux d'entiers. */
/*  */
/* Un vecteur est repr\'esent\'e par un exposant (voir binom.c) */
/* Un r\'eseau est repr\'esent\'e par une liste d'exposants (ses */
/* g\'en\'erateurs.  */
/***********************************************************************/

typedef struct lattice
{
    exponent first;
    struct lattice *rem;
}
lattice;

/***********************************************************************/
/* Id\'eaux toriques. */
/***********************************************************************/

typedef struct ideal
{
    exponent first;
    struct ideal *rem;
}
ideal;


/***********************************************************************/
/* Matrices d'entiers */
/***********************************************************************/
typedef exponent *mat;

/* \section{Variables globales} */

int dim; /* dimension des monomes */
int dim_sg; /* dimension du sous-groupe */
cpair *all_cpair[1000000];  /* les paires critiques */
int last_cpair; /* la derniere */
int first_cpair; /* la premiere */
lint *base; /* la base en construction */
exponent all_bin[10000]; /* les binomes crees */
int all_ibin[10000]; /* la fonction caracteristique de la base */
int all_bin_max;   /* le dernier binome cree */
lint *left_reduced; /* les binomes de tete reduite dans l'interreduction*/
lint *zero_reduced;/* les binomes reduits a zero dans l'interreduction*/
int nbin_reduced_0; /* leur nombre */
int right_reduce; /* indique si on reduit les parties droite dans  l'interreduction*/
int info_loop; /* le nombre de boucles de l'algorithme de calcul de base standard*/
int ncpair_created; /* le nombre de paires critiques creees */
int ncpair_treated;/* le nombre de paires critiques traitees */
int ncpair_eliminated;/* le nombre de paires critiques eliminees par le critere*/
int ncpair_interred;/* le nombre de paires critiques eliminees par l'interreduction*/
int ncpair_reduced_0;/* le nombre de paires critiques reduites a zero*/
int ncpair_reduced_not_0;/* le nombre de paires critiques donnant un nouveau binome*/
int binomial_order; /* l'ordre sur les binomes 0 lex 1 revlex */
int nlig,nlig_max, ncol; /* les dimensions des matrices */
int homog; /* les binomes sont homogenes */


