#include "bastat.h"
/* Minima successifs d'un ideal, le exposants sont ranges par norme -1 decroissantes  dans i, et dans le resultat.*/
ideal *minima(i)
     ideal *i;
{
    ideal *ir,*im;
    mat m;
    int r,j,rm;
    
    ir=0;
    while(i)
    {
	ir=make_ideal(i->first,ir);
	i=i->rem;
    }
    m=new_mat(dim,dim);
    ncol=dim;
    nlig=1;
    m[0]=ir->first;
    ir=ir->rem;
    r=1;
    
    while(ir)
    {
	m[nlig]=ir->first;
	nlig++;
	rm=rank(m);
	if (rm<=r)
	nlig--;
	else
	r++;
	ir=ir->rem;  
    }
    ir=0;
    for(j=0;j<nlig;j++)
    ir=make_ideal(m[j],ir);
    return(ir);
}

lattice *input_lattice()
{
    lattice *lat;
    mat m;
    printf("Ordre sur les monomes:\n");
    scanf("%d",&binomial_order);
    if (binomial_order>1 || binomial_order<0)
    {
	/* cas ou on bonne le reseau par ses generateurs
           l'ordre est le modulo 2*/
	binomial_order=binomial_order%2;
	lat=read_lattice();
    }
    else
    {
	printf("Matrice dont le reseau est le noyau:\n");
	m=read_mat();
	m=kernel(m);
	lat=mat_to_lattice(m);
    }
    return(lat);
}
/* Reseau aleatoire, dimension d, rang r, coef majores par c */
lattice *random_lattice(d,r,c)
     int d,r,c;
{
    mat m;
    int i,j;
    dim=d;
    nlig=r;
    ncol=dim;
    m=new_mat(nlig,ncol);
    
    for(i=0;i<nlig;i++)
    for(j=0;j<ncol;j++)
    m[i][j]=random()%c-c/2;
    dim_sg=rank(m);
    binomial_order=1;
    
    return(mat_to_lattice(m));
}
/* homogene */
lattice *random_lattice_hom(d,r,c)
     int d,r,c;
{
    mat m;
    int i,j,s;
    dim=d;
    nlig=r;
    ncol=dim;
    m=new_mat(nlig,ncol);
    
    for(i=0;i<nlig;i++)
    {
	s=0;
	for(j=0;j<(ncol-1);j++)
	{
	    m[i][j]=random()%c-c/2;
	    s=s+m[i][j];
	}
	m[i][ncol-1]=-s;
    }
    dim_sg=rank(m);
    binomial_order=1;
    
    return(mat_to_lattice(m));
}    
void treat_lattice()
{
    lattice *lat;
    lint *bs;
    ideal *i,*im;
    mat m;
    int j,aux,m_homog,glat,gmin;

    m_homog=0;
    all_bin_max=0;

   lat=input_lattice();
/*    lat=random_lattice_hom(100,5,2);*/
    print_lattice(lat);
     
    bs=basta_lattice(lat);
    i=bs_ideal(bs);
    dim--;
    print_ideal(i);
    
    printf("Plus grande norme dans la base standard: %d\n",
	   normm1_exp(i->first));
    printf("Nombre de binomes dans la base standard: %d\n",
	   length_ideal(i));
    im=minima(i);
   printf("Minima successifs:\n");
    printf("(les normes sont les valeurs de la norme -1,\n");
    printf("a doubler pour obtenir la norme 1 dans le cas d'un reseau homogene)\n");
    
    print_ideal(im);

/*    m=lattice_to_mat(lat);
    glat=det_Graham(m);
    m=ideal_to_mat(im);
    gmin=det_Graham(m);
    if ((gmin!=glat) && (glat!=0))
    {
	printf("Determinants differents: %d, %d, rapport %d \n",
	       glat,gmin,gmin/glat);
	print_lattice(lat);
	printf("Minima successifs:\n");
	print_ideal(im);
	exit(0);
    }*/

}
main()
{
    int i;
/*    while (1)*/
    treat_lattice();

}
/*
Des reseaux ou les determinants sont differents:

Determinants differents: 132096, 528384, rapport 4
reseau:
{
[3 -4 -3 -2 6]
[1 -4 3 4 -4]
[-3 4 -5 2 2]
}
Minima successifs:
ideal
(
norme 8 [-4 8 0 -2 -2]
norme 8 [0 0 8 0 -8]
norme 6 [-2 0 -2 6 -2]
)

Determinants differents: 6137856, 24551424 (= 4*6137856)
reseau:
{
[-2 -5 -4 1 2 8]
[3 2 -3 2 1 -5]
[4 -3 2 -1 -4 2]
[1 0 -1 -2 -5 7]
}
Minima successifs:
ideal
(
norme 9 [-1 8 1 -2 -3 -3]
norme 8 [-1 0 1 2 5 -7]
norme 8 [7 -1 -1 1 -3 -3]
norme 6 [0 -5 6 -1 0 0]
)
*/
