/*------------------------------------MATRIX.H----------------------------------------
|public:                                                                             |
|                                                                                    |
| matrix (): COLS(0), ROWS(0) {};                                                    |
|                                                                                    |
| matrix (int num_cols, int num_rows);                                               |
|                                                                                    |
| matrix (int num_cols, int num_rows, double ** entries);                            |
|                                                                                    |
| matrix (char * filename);                                                          |
|                                                                                    |
| matrix (char * filename, int dummy);                                               |
|                                                                                    |
| ~matrix ();                                                                        |
|                                                                                    |
| void delEntries ();                                                                |
|                                                                                    |
| void delAllDets ();                                                                |
|                                                                                    |
| friend ostream & operator << (ostream & a_stream, const matrix & mtrx);            |
|                                                                                    |
| int rows ();                                                                       |
|                                                                                    |
| int cols ();                                                                       |
|                                                                                    |
| double entry (int row, int col);                                                   |
|                                                                                    |
| int get_det_sign (int place);                                                      |
|                                                                                    |
| int * get_cocircuit (int which);                                                   |
|                                                                                    |
| matrix * fillSquareMatrix (int * sub_rows, int * sub_cols, const int size,         |
|                            matrix * square_matrix);                                |
|                                                                                    |
| void put_cocircuit (int where, int * cocirc);                                      |
|                                                                                    |
| void changeEntry (int row, int col, double new_entry);                             |
|                                                                                    |
| void enter_det_sign (int place, int det_sign);                                     |
|                                                                                    |
|private:                                                                            |
|                                                                                    |
| int COLS, ROWS;                                                                    |
| int * ALL_DETS;                                                                    |
| int ** COCIRCUITS;                                                                 |
| double ** ENTRIES;                                                                 |
-------------------------------------------------------------------------------------*/


# include <stdio.h>
# include <iostream.h>
# include <stdlib.h>
# include <fstream.h>
# include "math.h"


/**************************************************************************
* THIS FILE CONTAINS:
* delcarations of member functions and member data for the "matrix" data type
***************************************************************************/


#ifndef MATRIX_H
#define MATRIX_H


class matrix {

public:


//CONSTUCTORS


/*******************************************************************
* purpose: default constructor for a matrix
* date: 05.25.98
* notes/explanation: 
********************************************************************/
 
  matrix (): COLS(0), ROWS(0) {};


/*******************************************************************
* purpose: creates an empty matrix with the specified number of rows and columns
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  matrix (int num_cols, int num_rows);


/*******************************************************************
* purpose: constructs a matrix from an input number of d rows and n columns and a d by
*          n array of floating point elements.
* date: 05.25.98
* notes/explanation: 
********************************************************************/
 
  matrix (int num_cols, int num_rows, double ** entries);


/*******************************************************************
* purpose: constructs a matrix from a file
* date: 05.25.98
* notes/explanation: the input file should have the number of rows first, followed by the
*                    number of columns, and then the entries listed by all the elements 
*                    of the first row, followed by all the elements of the second row,
*                    etc.
********************************************************************/

  matrix (char * filename);


/*******************************************************************
* purpose: constructs an exact matrix from a file
* date: 05.25.98
* notes/explanation: the input file should have the number of rows first, followed by the
*                    number of columns and then the number of non-zero entries.
*                    Values for the entries should be preceded by the row number and 
*                    column number for that entry.
********************************************************************/

  matrix (char * filename, int);



//DESTRUCTORS


/*******************************************************************
* purpose: destructor for a matrix
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  ~matrix ();


/*******************************************************************
* purpose: destroy the allocated space for the entries
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  void delEntries ();


/*******************************************************************
* purpose: destroy the allocated space for the determinants
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  void delAllDets ();



//OPERATORS


/*******************************************************************
* purpose: a layer of abstraction by which matrices may be output.
* date: 05.25.98
* notes/explanation: overrides the "<<" operator
********************************************************************/

  friend ostream & operator << (ostream & a_stream, const matrix & mtrx);



//DATA ACQUISITION


/*******************************************************************
* purpose: accesses the private data member for the number of rows in the matrix
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  int rows ();


/*******************************************************************
* purpose: accesses the private data member for the number of columns in the matrix
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  int cols ();


/*******************************************************************
* purpose: accesses a desired element of the matrix indexed by the row and then the col
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  double entry (int row, int col);


/*******************************************************************
* purpose: accesses the private data member of the sign of the determinant for the given
*          index of the member array "ALL_DETS"
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  int get_det_sign (int place);


/*******************************************************************
* purpose: accesses the private data member for the cocircuit list from the given index
*          of the double member array "COCIRCUITS"
* date: 06.10.98
* notes/explanation: 
********************************************************************/

  int * get_cocircuit (int which);


/*******************************************************************
* purpose: fills the empty input square matrix with the entries from the specified 
*          sub_rows and sub_columns of the larger matrix
* date: 05.25.98
* notes/explanation: note that the input arrays sub_rows and sub_cols must both have 
*                    number of elements equal to the input size.  If the sub_rows or 
*                    sub_cols are null (0), then the function uses all rows or columns of
*                    the larger matrix respectively.
********************************************************************/

  void fillSquareMatrix (int * sub_rows, int * sub_cols, int size, 
			 matrix * square_matrix);



//MODIFIERS


/*******************************************************************
* purpose: places the given cocircuit equation into the input slot of the private data 
*          member array "COCIRCUITS"
* date: 06.10.98
* notes/explanation: 
********************************************************************/

  void put_cocircuit (int where, int * cocirc);


/*******************************************************************
* purpose: changes the entry index by the row and column number to the input new entry
* date: 06.10.98
* notes/explanation: 
********************************************************************/

  void changeEntry (int row, int col, double new_entry);


/*******************************************************************
* purpose: places the given determinant sign (+1, -1, or 0) into the input slot of the 
*          private data member "ALL_DETS"
* date: 06.10.98
* notes/explanation: 
********************************************************************/

  void enter_det_sign (int place, int det_sign);


//MEMBER DATA

  
private:

  int COLS, ROWS;             //STORES THE NUMBER OF COLUMNS AND ROWS IN THE MATRIX

  int * ALL_DETS;             //STORES THE SIGNS (+1, -1, or 0) OF ALL POSSIBLE N CHOOSE
                              //D DETERMINANTS

  int ** COCIRCUITS;          //A DOUBLY INDEXED ARRAY OF INTEGERS CONTAINING ALL OF THE
                              //N CHOOSE D - 1 COCIRCUIT EQUATIONS FOR THE MATRIX

  double ** ENTRIES;          //A DOUBLY INDEXED ARRAY OF DOUBLES CONTAINING ALL ELEMENTS
                              //OF THE MATRIX
};
  

#endif













