/*-------------------------------UTILITIES.LINALG.H-------------------------------------
|                                                                                      |
| double abs (double x);                                                               |
|                                                                                      |
| double LU_decomp (matrix * mtrx);                                                    |
|                                                                                      |
| double determinant (matrix * mtrx);                                                  |
|                                                                                      |
| double allDets (matrix * mtrx);                                                      |
|                                                                                      |
---------------------------------------------------------------------------------------*/


# include "matrix.h"


/*********************************************************
* THIS FILE CONTAINS:
* declarations for linear algebraic utility functions
**********************************************************/


#ifndef UTILITIES_LINALG_H
#define UTILITIES_LINALG_H



/*********************************************************
* purpose: computes the absolute value.
* date: 06.08.98
* notes/explanation: 
*********************************************************/

double abs (double x);


/*********************************************************
* purpose: Computes the LU-decomposition of a square matrix A
* date: 06.08.98
* notes/explanation: Code modified from the book numerical recipes
* in C, by W. Press, B. Flannery, S. Teukolsky and W. Vetterling.
* Cambridge Press 1989.
*
* Idea: If one can decompose the square matrix A
* product of matrices LU, with L lower triangular and U upper
* triangular then the evaluation of the determinant is just
* the product of the products of the diagonal elements.
* One computes first a decomposition of the rowwise permutation
* of A. One keeps track of k= number of interchanges and adjust
* the product by the corresponding sign (-1)^k.
*
* REMARK: For large matrices overflow may occur with respect to
* the floating point range in the computer. The solution is that
* we actually do NOT need the determinants but only its sign!!!
* so we would just recover this from the diagonal signs.
*********************************************************/

double LU_decomp (matrix * mtrx);


/*********************************************************
* purpose: computes the determinant of a square matrix.
* date: 06.08.98
* notes/explanation: once we have LU decomposition it is
* simply a matter of multiplying the diagonal elements.
*********************************************************/

double determinant (matrix * mtrx);


/*********************************************************
* purpose: computes ALL the dxd determinants of a dxn matrix and returns an array 
*          consisting of all simplices whose determinant is zero.
* date: 06.08.98
* notes/explanation: 
*********************************************************/

int * allDets (matrix * mtrx);


#endif
