/*---------------------------------------------------------------------------+
| This file contains two classes                                             |
|                                                                            |
|    exp_T   implementation of an expression tree with variable and          |
|            function lookup                                                 |
|    Matrix  implementation of a sparse matrix with symbolic entries         |
|                                                                            |
| The class lookup is a simple (and not very efficient) lookup table         |
+---------------------------------------------------------------------------*/
#pragma  hdrstop
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "exp.h"

static char*    funcNames[] = {
    "acos",
    "asin",
    "atan",
    "cos",
    "cosh",
    "exp",
    "ln",
    "log",
    "sin",
    "sinh",
    "sqrt",
    "tan",
    "tanh"};

static DFuncD   functions[] = {acos, asin, atan, cos,
                               cosh, exp, log, log10, sin, sinh, sqrt, tan, tanh};


/*---------------------------------------------------------------------------+
| getFunc
|
| This is a utility function to retrieve a pointer to a function when given
|    the name of the function.
|
| The function names are stored in the array functions in increasing
|    alphabetic order
*/
DFuncD
getFunc(char* name)
{
    int mid;
    int start = 0;
    int stop = 12;
    while (start <= stop) {
        mid = (start + stop) / 2;
        int comp;
        comp = strcmp(name, funcNames[mid]);
        if (comp < 0) {
            stop = mid-1;
        } else if (comp > 0) {
            start = mid+1;
        } else {
            return functions[mid];
        }
    }
    return 0;
}

char*
funcName(DFuncD func)
{
    int n = sizeof(functions)/sizeof(functions[0]);
    while (n > 0) {
        if (func == functions[--n])
            return funcNames[n];
    }
    return "Not found";
}




















