/*---------------------------------------------------------------------------+
| This file contains two classes                                             |
|                                                                            |
|    exp_T   implementation of an expression tree with variable and          |
|            function lookup                                                 |
|    Matrix  implementation of a sparse matrix with symbolic entries         |
|                                                                            |
| The class lookup is a simple (and not very efficient) lookup table         |
+---------------------------------------------------------------------------*/
#pragma  hdrstop
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "exp.h"

/*---------------------------------------------------------------------------+
| lookup::is_var
|
| given a character string, variable, return true if the character string
|    is stored as a variable in the lookup table
*/
bool
lookup::is_var(const char* variable)
{
    for (unsigned int i=0; i<nr; i++) {
        if (!strcmp(names[i], variable))
            return true;
    }
    return false;
}

/*---------------------------------------------------------------------------+
| lookup::value
|
| Given a character string, variable, return the value that is stored in
|    the lookup table for the string.  If the string is not stored in the
|    lookup table, return 0
*/
double
lookup::value(const char* variable) const
{
    for (unsigned int i=0; i<nr; i++) {
        if (!strcmp(names[i], variable))
            return val[i];
    }
    return 0;
}

/*---------------------------------------------------------------------------+
| lookup::insert
|
| Given a character string, variable, and a value, change the value of the
|    variable if it is stored in the lookup table. If it is not stored in
|    the lookup table, create a new entry in the lookup table.
*/
void
lookup::insert(const char* variable, double value)
{
    for (int i=0; i<nr; i++) {
        if (!strcmp(names[i], variable)) {
            val[i] = value;
            return;
        }
    }
    strncpy(names[nr], variable, 10);
    names[nr][9] = 0;
    val[nr++] = value;
}

/*---------------------------------------------------------------------------+
| lookup::init
|
| Given the name of a file with entries of the form
|        string    value
|    store the pairs in the lookup table.  If there are any existing entries
|    in the lookup table, they are deleted before the new entries are
|    stored in the table
*/
void
lookup::init(const char* filename)
{
    FILE* foo = fopen(filename, "r");
    char  line[256];
    nr = 0;
    while (fgets(line, 256, foo)) {
        sscanf(line, "%s%lf", names[nr], &val[nr]);
        ++nr;
    }
    fclose(foo);
}
