/*---------------------------------------------------------------------------+
| This file contains two classes                                             |
|                                                                            |
|    exp_T   implementation of an expression tree with variable and          |
|            function lookup                                                 |
|    Matrix  implementation of a sparse matrix with symbolic entries         |
|                                                                            |
| The class lookup is a simple (and not very efficient) lookup table         |
+---------------------------------------------------------------------------*/
#pragma  hdrstop
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "exp.h"

// lookup Matrix::table;

/*---------------------------------------------------------------------------+
| Matrix::Matrix
|
|    Given a filename which contains data for the matrix and a second file
|    name which consists of values for a lookup table, initialize an
|    instance of the class
|
|    The first file consists of rows of two types.  The first row contains
|    the number of rows, columns and number of non-zero entries in the
|    matrix.  The rest of the file contains lines of the form
|        row col variable-name
|    There are as many such rows as the third entry of the first row
*/
Matrix::Matrix(const char* filename, const char* initvalues)
{
    FILE* foo = fopen(filename, "r");
    char line[256];
    fgets(line, 256, foo);
    sscanf(line, "%d%d%d", &rows, &cols, &nr);
    matrix = new MatEntry[nr];

    int i = 0;
    while (fgets(line, 256, foo)) {
        sscanf(line, "%d%d%s", &matrix[i].row, &matrix[i].col, matrix[i].variable);
        ++i;
    }
//  if (initvalues)  Matrix::table.init(initvalues);
}

/*---------------------------------------------------------------------------+
| Matrix::genMatrix
|
| This method returns a standard matrix from the given instance.
*/
double**
Matrix::genMatrix()
{
    double **mat = new double* [rows];
    char buffer[256];
//    exp_T  express(Matrix::table);
    exp_T* e;
    for (int i=0; i<rows; i++) {
        mat[i] = new double[cols];
        for (int j=0; j<cols; j++) {
            mat[i][j] = 0;
        }
    }
    for (int i=0; i<nr; i++) {
        strcpy(buffer, matrix[i].variable);
        char* token = getToken(buffer);
        if ((*token == '+') || (*token == '-') || (*token == '*') || (*token == '/')) {
            sprintf(buffer, "0 %s", matrix[i].variable);
            token = getToken(buffer);
	  }
        try {
            e = BuildExpression(&token);
	  } 
        catch (const char* error) {
            cerr << error;
            continue;
	}
        if (!e) {
            cout << "Bad expression" << endl;
	  } else {
//      mat[matrix[i].row][matrix[i].col] = Matrix::table.value(matrix[i].variable);
        mat[matrix[i].row][matrix[i].col] = e->value();
        delete e;
      }
    }
    return mat;
}

/*---------------------------------------------------------------------------+
| Matrix::update
|
| Given a variable name and a value, update the lookup table for the matrix.
*/
void
Matrix::update(const char* variable, double value)
{
//    Matrix::table.insert(variable, value);
}

/*---------------------------------------------------------------------------+
| Matrix::show
|
| Print the instance of the matrix given the current values of the
|    variables.
*/
void
Matrix::show()
{
    double** mat = genMatrix();
    for (int i=0; i<rows; i++) {
        for (int j=0; j<cols; j++) {
            cout << setw(6) << setprecision(3) << mat[i][j];
//          printf("%6.3f ", mat[i][j]);
        }
        cout << endl;
//      printf("\n");
    }
    for (int i=0; i<rows; i++) {
        delete [] mat[i];
    }
    delete [] mat;
}
