%  Example driver for band_Arnoldi.m
%    
%  This driver runs the band Arnoldi process applied to a random sparse N x N
%  matrix A, which is generated by the function "make_sparse_randn_matrix_A",
%  and a N x m starting block R, which is generated by the function 
%  "make_some_starting_block".
%
% -----------------------------------------------------------------------------
%
%  BANDITS: a Matlab Package of Band Krylov Subspace Iterations
%
%  Copyright (c) 2018-2019 Roland W. Freund
%  See LICENSE.txt for license
%
% -----------------------------------------------------------------------------

N = input('Size N of the N x N sparse matrix A = ')
%
density = input('Density of the sparse matrix A = ')
%
rflag = input('Real or complex A and R (real = 1, complex = 2): ')
%
A = make_sparse_randn_matrix_A(N,rflag-1,density);
%
R = make_some_starting_blocks(A,1,rflag);
%
nmax = input('Number nmax of Arnoldi vectors to be generated = ')
%
tol.defl_tol = sqrt(eps);
tol.defl_flag = 1;
tol.normA_flag = 1;
%
fprintf(' \n')
disp('**-----------------------------------**')
disp('** First run: all nmax steps at once **')
disp('**-----------------------------------**'), fprintf(' \n')
%
result = band_Arnoldi(A,R,nmax,tol,0,[]);
%
fprintf(' \n')
disp('**--------------------------------**')
disp('** Second run: one step at a time **')
disp('**--------------------------------**'), fprintf(' \n')
%
resulti = band_Arnoldi(@(x) MultA(x,A),R,1,tol,0,[]);

for n = 1 : nmax-1,

  resulti = band_Arnoldi(@(x) MultA(x,A),R,n+1,[],resulti.n,resulti);
  
end  

