%  Example driver for band_Lanczos.m
%    
%  This driver runs the band Lanczos method applied to a random sparse N x N
%  matrix A, which is generated by the function "make_sparse_randn_matrix_A",
%  and N x m and N x p right and left starting blocks R and L, respectively,
%  which are generated by the function "make_some_starting_blocks".
%
% -----------------------------------------------------------------------------
%
%  BANDITS: a Matlab Package of Band Krylov Subspace Iterations
%
%  Copyright (c) 2018-2019 Roland W. Freund
%  See LICENSE.txt for license
%
% -----------------------------------------------------------------------------

N = input('Size N of the N x N sparse matrix A = ')
%
density = input('Density of the sparse matrix A = ')
%
rflag = input('Real or complex A, R, and L (real = 1, complex = 2): ')
%
A = make_sparse_randn_matrix_A(N,rflag-1,density);
%
[R,L] = make_some_starting_blocks(A,2,rflag);
%
sflag = input('Store all Lanczos vectors (no = 0, yes = 1): ')
%
nmax = input('Number nmax of pairs of Lanczos vectors to be generated = ')
%
tol.defl_tol = sqrt(eps);
tol.defl_flag = 1;
tol.normA_flag = 1;
tol.brk_tol = 1.e-14;
%
fprintf(' \n')
disp('**-----------------------------------**')
disp('** First run: all nmax steps at once **')
disp('**-----------------------------------**'), fprintf(' \n')
%
result = band_Lanczos(@(x,tfl) MultA2(x,tfl,A),R,L,nmax,sflag,tol,0,[]);
%
fprintf(' \n')
disp('**--------------------------------**')
disp('** Second run: one step at a time **')
disp('**--------------------------------**'), fprintf(' \n')
%
resulti = band_Lanczos(A,R,L,1,sflag,tol,0,[]);

for n = 1 : nmax-1,

  resulti = band_Lanczos(A,R,L,n+1,sflag,[],resulti.n,resulti);
  
end  

