		#a is the knapsack coefficients
		# iP = sum of the numbers in a
		a := [12137, 24269, 36405, 36407, 48545, 60683];iP:=218446;


		read("CTEuclid6.mpl"):

		#convert the list a into the expression 1/\prod_i (1-x^{a_i})		
		KnapGen:=proc(a)
			p := 1;
			k:=1;
			for i in a do:
				p:= p * (1/(1-x^i));
				k:=k+1;
			end;

			return p;
		end:

		#returns the lowest common multiple of the numbers in list a
		mylcm:=proc(a)
			l:=1;
			for i in a do:
				l:=ilcm(i,l);
			end;
			return l;
		end;
	
		#iP:=add(a[i],i=1..nops(a));
		
		#Goal: find the constant term of FG, which gives the number of ways
		#the coefficients of "a" add up to iP
		FG:=KnapGen(a)/(x^iP);


		print("calling CTE");
		ctime:=time():
		iCount := CTEuclid(FG, t, [x]);
		ctime:= time() - ctime:
		print("CTE took ", ctime);
		print("CTE total time est", ctime*mylcm(a)*nops(a)); #for polynomial interpolation
		fptr:=fopen("CTEoutput.txt", APPEND);
		fprintf(fptr, "a=%a; point count = %d; time=%a; est time=%a\n", a, iCount, ctime, ctime*mylcm(a)*nops(a));
		fclose(fptr);
		quit;
	
