/* glpbfx.h (basis factorization interface, bignum arithmetic) */

/* (reserved for copyright notice) */

#ifndef _GLPBFX_H
#define _GLPBFX_H

#include "glpgmp.h"

#define bfx_create_binv       glp_bfx_create_binv
#define bfx_is_valid          glp_bfx_is_valid
#define bfx_invalidate        glp_bfx_invalidate
#define bfx_factorize         glp_bfx_factorize
#define bfx_ftran             glp_bfx_ftran
#define bfx_btran             glp_bfx_btran
#define bfx_update            glp_bfx_update
#define bfx_delete_binv       glp_bfx_delete_binv

#ifndef _GLPBFX_DEFINED
#define _GLPBFX_DEFINED
typedef struct { int foo_; } BFX;
#endif

BFX *bfx_create_binv(void);
/* create factorization of the basis matrix */

int bfx_is_valid(BFX *binv);
/* check if factorization is valid */

void bfx_invalidate(BFX *binv);
/* invalidate factorization of the basis matrix */

int bfx_factorize(BFX *binv, int m, int (*col)(void *info, int j,
      int ind[], mpq_t val[]), void *info);
/* compute factorization of the basis matrix */

void bfx_ftran(BFX *binv, mpq_t x[], int save);
/* perform forward transformation (FTRAN) */

void bfx_btran(BFX *binv, mpq_t x[]);
/* perform backward transformation (BTRAN) */

int bfx_update(BFX *binv, int j);
/* update factorization of the basis matrix */

void bfx_delete_binv(BFX *binv);
/* delete factorization of the basis matrix */

#endif

/* eof */
