/* glpbfx.c */

/* (reserved for copyright notice) */

#include <stddef.h>
typedef struct BFX BFX;
#define _GLPBFX_DEFINED
#include "glpbfx.h"
#include "glplib.h"
#include "glplux.h"

struct BFX
{     int valid;
      LUX *lux;
};

BFX *bfx_create_binv(void)
{     /* create factorization of the basis matrix */
      BFX *bfx;
      bfx = umalloc(sizeof(BFX));
      bfx->valid = 0;
      bfx->lux = NULL;
      return bfx;
}

int bfx_factorize(BFX *binv, int m, int (*col)(void *info, int j,
      int ind[], mpq_t val[]), void *info)
{     /* compute factorization of the basis matrix */
      int ret;
      insist(m > 0);
      if (binv->lux != NULL && binv->lux->n != m)
      {  lux_delete(binv->lux);
         binv->lux = NULL;
      }
      if (binv->lux == NULL)
         binv->lux = lux_create(m);
      ret = lux_decomp(binv->lux, col, info);
      binv->valid = (ret == 0);
      return ret;
}

void bfx_ftran(BFX *binv, mpq_t x[], int save)
{     /* perform forward transformation (FTRAN) */
      insist(binv->valid);
      lux_solve(binv->lux, 0, x);
      insist(save == save);
      return;
}

void bfx_btran(BFX *binv, mpq_t x[])
{     /* perform backward transformation (BTRAN) */
      insist(binv->valid);
      lux_solve(binv->lux, 1, x);
      return;
}

int bfx_update(BFX *binv, int j)
{     /* update factorization of the basis matrix */
      insist(binv->valid);
      insist(1 <= j && j <= binv->lux->n);
      return 1;
}

void bfx_delete_binv(BFX *binv)
{     /* delete factorization of the basis matrix */
      if (binv->lux != NULL)
         lux_delete(binv->lux);
      ufree(binv);
      return;
}

/* eof */
