/* automatically generated by sed scripts from the c source named below: */
/* cddlp.c:  dual simplex method c-code
   written by Komei Fukuda, fukuda@ifor.math.ethz.ch
   Version 0.93a, August 11, 2003
*/

/* cddlp.c : C-Implementation of the dual simplex method for
   solving an LP: max/min  A_(m-1).x subject to  x in P, where
   P= {x :  A_i.x >= 0, i=0,...,m-2, and  x_0=1}, and
   A_i is the i-th row of an m x n matrix A.
   Please read COPYING (GNU General Public Licence) and
   the manual cddlibman.tex for detail.
*/

#include "setoper.h"  /* set operation library header (Ver. May 18, 2000 or later) */
#include "cdd_f.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <string.h>

#if defined ddf_GMPRATIONAL
#include "cdd_f.h"
#endif

#define ddf_CDDLPVERSION  "Version 0.93a (August 11, 2003)"

#define ddf_FALSE 0
#define ddf_TRUE 1

typedef set_type rowset;  /* set_type defined in setoper.h */
typedef set_type colset;

void ddf_CrissCrossSolve(ddf_LPPtr lp,ddf_ErrorType *);
void ddf_DualSimplexSolve(ddf_LPPtr lp,ddf_ErrorType *);
void ddf_CrissCrossMinimize(ddf_rowrange,ddf_colrange,ddf_Amatrix,ddf_Bmatrix T,ddf_rowset,
  ddf_rowrange,ddf_colrange,
  ddf_LPStatusType *,myfloat *optvalue,ddf_Arow,ddf_Arow,ddf_colindex,
  ddf_rowrange *,ddf_colrange *,long *,ddf_ErrorType *);
void ddf_CrissCrossMaximize(ddf_rowrange,ddf_colrange,ddf_Amatrix,ddf_Bmatrix T,ddf_rowset,
  ddf_rowrange,ddf_colrange,
  ddf_LPStatusType *,myfloat *optvalue,ddf_Arow,ddf_Arow,ddf_colindex,
  ddf_rowrange *,ddf_colrange *,long *,ddf_ErrorType *);
void ddf_DualSimplexMinimize(ddf_rowrange,ddf_colrange, ddf_Amatrix,ddf_Bmatrix,ddf_rowset,
  ddf_rowrange,ddf_colrange,
  ddf_LPStatusType *,myfloat *,ddf_Arow,ddf_Arow,ddf_colindex,
  ddf_rowrange *,ddf_colrange *,long *,ddf_ErrorType *);
void ddf_DualSimplexMaximize(ddf_rowrange,ddf_colrange,ddf_Amatrix,ddf_Bmatrix,ddf_rowset,
  ddf_rowrange,ddf_colrange,
  ddf_LPStatusType *,myfloat *,ddf_Arow,ddf_Arow,ddf_colindex,
  ddf_rowrange *,ddf_colrange *,long *,ddf_ErrorType *);
void ddf_FindLPBasis(ddf_rowrange,ddf_colrange,ddf_Amatrix,ddf_Bmatrix,ddf_rowindex,ddf_rowset,
    ddf_colindex,ddf_rowindex,ddf_rowrange,ddf_colrange,
    ddf_colrange *,int *,ddf_LPStatusType *,long *);
void ddf_FindDualFeasibleBasis(ddf_rowrange,ddf_colrange,ddf_Amatrix,ddf_Bmatrix,ddf_rowindex,
    ddf_colindex,long *,ddf_rowrange,ddf_colrange,
    ddf_colrange *,ddf_ErrorType *,ddf_LPStatusType *,long *, long maxpivots);


#ifdef ddf_GMPRATIONAL
void ddf_BasisStatus(ddf_LPPtr lpf, ddf_LPPtr lp, ddf_boolean*);
void ddf_BasisStatusMinimize(ddf_rowrange,ddf_colrange, ddf_Amatrix,ddf_Bmatrix,ddf_rowset,
    ddf_rowrange,ddf_colrange,ddf_LPStatusType, myfloat *,ddf_Arow,ddf_Arow,ddf_colindex,
    ddf_rowrange,ddf_colrange,long *, int *, int *);
void ddf_BasisStatusMaximize(ddf_rowrange,ddf_colrange, ddf_Amatrix,ddf_Bmatrix,ddf_rowset,
    ddf_rowrange,ddf_colrange,ddf_LPStatusType, myfloat *,ddf_Arow,ddf_Arow,ddf_colindex,
    ddf_rowrange,ddf_colrange,long *, int *, int *);
#endif

void ddf_WriteBmatrix(FILE *f,ddf_colrange d_size,ddf_Bmatrix T);
void ddf_SetNumberType(char *line,ddf_NumberType *number,ddf_ErrorType *Error);
void ddf_ComputeRowOrderVector2(ddf_rowrange m_size,ddf_colrange d_size,ddf_Amatrix A,
    ddf_rowindex OV,ddf_RowOrderType ho,unsigned int rseed);
void ddf_SelectPreorderedNext2(ddf_rowrange m_size,ddf_colrange d_size,
    rowset excluded,ddf_rowindex OV,ddf_rowrange *hnext);
void ddf_SetSolutions(ddf_rowrange,ddf_colrange,
   ddf_Amatrix,ddf_Bmatrix,ddf_rowrange,ddf_colrange,ddf_LPStatusType,
   myfloat *,ddf_Arow,ddf_Arow,ddf_colindex,ddf_rowrange,ddf_colrange);


ddf_LPSolutionPtr ddf_CopyLPSolution(ddf_LPPtr lp)
{
  ddf_LPSolutionPtr lps;
  ddf_colrange j;
  long i;

  lps=(ddf_LPSolutionPtr) calloc(1,sizeof(ddf_LPSolutionType));
  for (i=1; i<=ddf_filenamelen; i++) lps->filename[i-1]=lp->filename[i-1];
  lps->objective=lp->objective;
  lps->solver=lp->solver; 
  lps->m=lp->m;
  lps->d=lp->d;
  lps->numbtype=lp->numbtype;

  lps->LPS=lp->LPS;  /* the current solution status */
  ddf_init(lps->optvalue);
  ddf_set(lps->optvalue,lp->optvalue);  /* optimal value */
  ddf_InitializeArow(lp->d+1,&(lps->sol));
  ddf_InitializeArow(lp->d+1,&(lps->dsol));
  lps->nbindex=(long*) calloc((lp->d)+1,sizeof(long));  /* dual solution */
  for (j=0; j<=lp->d; j++){
    ddf_set(lps->sol[j],lp->sol[j]);
    ddf_set(lps->dsol[j],lp->dsol[j]);
    lps->nbindex[j]=lp->nbindex[j];
  }
  lps->pivots[0]=lp->pivots[0];
  lps->pivots[1]=lp->pivots[1];
  lps->pivots[2]=lp->pivots[2];
  lps->pivots[3]=lp->pivots[3];
  lps->pivots[4]=lp->pivots[4];
  lps->total_pivots=lp->total_pivots;

  return lps;
}


ddf_LPPtr ddf_CreateLPData(ddf_LPObjectiveType obj,
   ddf_NumberType nt,ddf_rowrange m,ddf_colrange d)
{
  ddf_LPType *lp;

  lp=(ddf_LPPtr) calloc(1,sizeof(ddf_LPType));
  lp->solver=ddf_DualSimplex;  /* set the default lp solver */
  lp->d=d;
  lp->m=m;
  lp->numbtype=nt;
  lp->objrow=m;
  lp->rhscol=1L;
  lp->objective=ddf_LPnone;
  lp->LPS=ddf_LPSundecided;
  lp->eqnumber=0;  /* the number of equalities */

  lp->nbindex=(long*) calloc(d+1,sizeof(long));
  lp->given_nbindex=(long*) calloc(d+1,sizeof(long));
  set_initialize(&(lp->equalityset),m);  
    /* ith component is 1 if it is equality, -1 if it is strict inequality, 0 otherwise. */

  lp->m_alloc=lp->m+2;
  lp->d_alloc=lp->d+2;
  lp->objective=obj;
  ddf_InitializeBmatrix(lp->d_alloc,&(lp->B));
  ddf_InitializeAmatrix(lp->m_alloc,lp->d_alloc,&(lp->A));
  ddf_InitializeArow(lp->d_alloc,&(lp->sol));
  ddf_InitializeArow(lp->d_alloc,&(lp->dsol));
  ddf_init(lp->optvalue);
  return lp;
}


ddf_LPPtr ddf_Matrix2LP(ddf_MatrixPtr M, ddf_ErrorType *err)
{
  ddf_rowrange m, i, irev, linc;
  ddf_colrange d, j;
  ddf_LPType *lp;
  ddf_boolean localdebug=ddf_FALSE;

  *err=ddf_NoError;
  linc=set_card(M->linset);
  m=M->rowsize+1+linc; 
     /* We represent each equation by two inequalities.
        This is not the best way but makes the code simple. */
  d=M->colsize;
  if (localdebug) fprintf(stderr,"number of equalities = %ld\n", linc);
  
  lp=ddf_CreateLPData(M->objective, M->numbtype, m, d);
  lp->Homogeneous = ddf_TRUE;
  lp->eqnumber=linc;  /* this records the number of equations */

  irev=M->rowsize; /* the first row of the linc reversed inequalities. */
  for (i = 1; i <= M->rowsize; i++) {
    if (set_member(i, M->linset)) {
      irev=irev+1;
      set_addelem(lp->equalityset,i);    /* it is equality. */
                                         /* the reversed row irev is not in the equality set. */
      for (j = 1; j <= M->colsize; j++) {
        ddf_neg(lp->A[irev-1][j-1],M->matrix[i-1][j-1]);
      }  /*of j*/
      if (localdebug) fprintf(stderr,"equality row %ld generates the reverse row %ld.\n",i,irev);
    }
    for (j = 1; j <= M->colsize; j++) {
      ddf_set(lp->A[i-1][j-1],M->matrix[i-1][j-1]);
      if (j==1 && i<M->rowsize && ddf_Nonzero(M->matrix[i-1][j-1])) lp->Homogeneous = ddf_FALSE;
    }  /*of j*/
  }  /*of i*/
  for (j = 1; j <= M->colsize; j++) {
    ddf_set(lp->A[m-1][j-1],M->rowvec[j-1]);  /* objective row */
  }  /*of j*/

  return lp;
}


void ddf_FreeLPData(ddf_LPPtr lp)
{
  if ((lp)!=NULL){
    ddf_clear(lp->optvalue);
    ddf_FreeArow(lp->d_alloc,lp->dsol);
    ddf_FreeArow(lp->d_alloc,lp->sol);
    ddf_FreeBmatrix(lp->d_alloc,lp->B);
    ddf_FreeAmatrix(lp->m_alloc,lp->d_alloc,lp->A);
    set_free(lp->equalityset);
    free(lp->nbindex);
    free(lp->given_nbindex);
    free(lp);
  }
}

void ddf_FreeLPSolution(ddf_LPSolutionPtr lps)
{
  if (lps!=NULL){
    free(lps->nbindex);
    ddf_FreeArow(lps->d+1,lps->dsol);
    ddf_FreeArow(lps->d+1,lps->sol);
    ddf_clear(lps->optvalue);
    
    free(lps);
  }
}

int ddf_LPReverseRow(ddf_LPPtr lp, ddf_rowrange i)
{
  ddf_colrange j;
  int success=0;

  if (i>=1 && i<=lp->m){
    lp->LPS=ddf_LPSundecided;
    for (j=1; j<=lp->d; j++) {
      ddf_neg(lp->A[i-1][j-1],lp->A[i-1][j-1]);
      /* negating the i-th constraint of A */
    }
    success=1;
  }
  return success;
}

int ddf_LPReplaceRow(ddf_LPPtr lp, ddf_rowrange i, ddf_Arow a)
{
  ddf_colrange j;
  int success=0;

  if (i>=1 && i<=lp->m){
    lp->LPS=ddf_LPSundecided;
    for (j=1; j<=lp->d; j++) {
      ddf_set(lp->A[i-1][j-1],a[j-1]);
      /* replacing the i-th constraint by a */
    }
    success=1;
  }
  return success;
}

ddf_Arow ddf_LPCopyRow(ddf_LPPtr lp, ddf_rowrange i)
{
  ddf_colrange j;
  ddf_Arow a;

  if (i>=1 && i<=lp->m){
    ddf_InitializeArow(lp->d, &a);
    for (j=1; j<=lp->d; j++) {
      ddf_set(a[j-1],lp->A[i-1][j-1]);
      /* copying the i-th row to a */
    }
  }
  return a;
}


void ddf_SetNumberType(char *line,ddf_NumberType *number,ddf_ErrorType *Error)
{
  if (strncmp(line,"integer",7)==0) {
    *number = ddf_Integer;
    return;
  }
  else if (strncmp(line,"rational",8)==0) {
    *number = ddf_Rational;
    return;
  }
  else if (strncmp(line,"real",4)==0) {
    *number = ddf_Real;
    return;
  }
  else { 
    *number=ddf_Unknown;
    *Error=ddf_ImproperInputFormat;
  }
}


void ddf_WriteTableau(FILE *f,ddf_rowrange m_size,ddf_colrange d_size,ddf_Amatrix A,ddf_Bmatrix T,
  ddf_colindex nbindex,ddf_rowindex bflag)
/* Write the tableau  A.T   */
{
  ddf_colrange j;
  ddf_rowrange i;
  myfloat x;
  
  ddf_init(x);
  fprintf(f," %ld  %ld  real\n",m_size,d_size);
  fprintf(f,"          |");
  for (j=1; j<= d_size; j++) {
    fprintf(f," %ld",nbindex[j]);
  } fprintf(f,"\n");
  for (j=1; j<= d_size+1; j++) {
    fprintf(f," ----");
  } fprintf(f,"\n");
  for (i=1; i<= m_size; i++) {
    fprintf(f," %3ld(%3ld) |",i,bflag[i]);  
    for (j=1; j<= d_size; j++) {
      ddf_TableauEntry(&x,m_size,d_size,A,T,i,j);
      ddf_WriteNumber(f,x);
    }
    fprintf(f,"\n");
  }
  fprintf(f,"end\n");
  ddf_clear(x);
}


void ddf_SelectDualSimplexPivot(ddf_rowrange m_size,ddf_colrange d_size,
    int Phase1,ddf_Amatrix A,ddf_Bmatrix T,ddf_rowindex OV,
    ddf_colindex nbindex,ddf_rowindex bflag,
    ddf_rowrange objrow,ddf_colrange rhscol,
    ddf_rowrange *r,ddf_colrange *s,int *selected,ddf_LPStatusType *lps)
{ 
  /* selects a dual simplex pivot (*r,*s) if the current
     basis is dual feasible and not optimal. If not dual feasible,
     the procedure returns *selected=ddf_FALSE and *lps=LPSundecided.
     If Phase1=ddf_TRUE, the RHS column will be considered as the negative
     of the column of the largest variable (==m_size).  For this case, it is assumed
     that the caller used the auxiliary row (with variable m_size) to make the current
     dictionary dual feasible before calling this routine so that the nonbasic
     column for m_size corresponds to the auxiliary variable.
  */
  int colselected=ddf_FALSE,rowselected=ddf_FALSE,
    dualfeasible=ddf_TRUE,localdebug=ddf_FALSE;
  ddf_rowrange i;
  ddf_colrange j;
  myfloat val,minval,rat,minrat;
  static ddf_Arow rcost;
  static ddf_colrange d_last=0;

  ddf_init(val); ddf_init(minval); ddf_init(rat); ddf_init(minrat);
  if (d_last<d_size) {
    if (d_last>0) {
      for (j=1; j<=d_last; j++){ ddf_clear(rcost[j-1]);}
      free(rcost);
    }
    rcost=(myfloat*) calloc(d_size,sizeof(myfloat));
    for (j=1; j<=d_size; j++){ ddf_init(rcost[j-1]);}
  }
  d_last=d_size;

  *r=0; *s=0;
  *selected=ddf_FALSE;
  *lps=ddf_LPSundecided;
  for (j=1; j<=d_size; j++){
    if (j!=rhscol){
      ddf_TableauEntry(&(rcost[j-1]),m_size,d_size,A,T,objrow,j);
      if (ddf_Positive(rcost[j-1])) { 
        dualfeasible=ddf_FALSE;
      }
    }
  }
  if (dualfeasible){
    while ((*lps==ddf_LPSundecided) && (!rowselected) && (!colselected)) {
      for (i=1; i<=m_size; i++) {
        if (i!=objrow && bflag[i]==-1) {  /* i is a basic variable */
          if (Phase1){
            ddf_TableauEntry(&val, m_size,d_size,A,T,i,bflag[m_size]);
            ddf_neg(val,val);
            /* for dual Phase I */
          } 
          else {ddf_TableauEntry(&val,m_size,d_size,A,T,i,rhscol);}
          if (ddf_Smaller(val,minval)) {
            *r=i;
            ddf_set(minval,val);
          }
        }
      }
      if (ddf_Nonnegative(minval)) {
        *lps=ddf_Optimal;
      }
      else {
        rowselected=ddf_TRUE;
        for (j=1; j<=d_size; j++){
          ddf_TableauEntry(&val,m_size,d_size,A,T,*r,j);
          if (j!=rhscol && ddf_Positive(val)) {
            ddf_div(rat,rcost[j-1],val);
            ddf_neg(rat,rat);
            if (*s==0 || ddf_Smaller(rat,minrat)){
              ddf_set(minrat,rat);
              *s=j;
            }
          }
        }
        if (*s>0) {colselected=ddf_TRUE; *selected=ddf_TRUE;}
        else *lps=ddf_Inconsistent;
      }
    } /* end of while */
  }
  if (localdebug) {
     if (Phase1) fprintf(stderr,"Phase 1 : select %ld,%ld\n",*r,*s);
     else fprintf(stderr,"Phase 2 : select %ld,%ld\n",*r,*s);
  }
  ddf_clear(val); ddf_clear(minval); ddf_clear(rat); ddf_clear(minrat);
}

void ddf_TableauEntry(myfloat *x,ddf_rowrange m_size, ddf_colrange d_size, ddf_Amatrix X, ddf_Bmatrix T,
				ddf_rowrange r, ddf_colrange s)
/* Compute the (r,s) entry of X.T   */
{
  ddf_colrange j;
  myfloat temp;

  ddf_init(temp);
  ddf_set(*x,ddf_purezero);
  for (j=0; j< d_size; j++) {
    ddf_mul(temp,X[r-1][j], T[j][s-1]);
    ddf_add(*x, *x, temp);
  }
  ddf_clear(temp);
}

void ddf_SelectPivot2(ddf_rowrange m_size,ddf_colrange d_size,ddf_Amatrix A,ddf_Bmatrix T,
            ddf_RowOrderType roworder,ddf_rowindex ordervec, rowset equalityset,
            ddf_rowrange rowmax,rowset NopivotRow,
            colset NopivotCol,ddf_rowrange *r,ddf_colrange *s,
            ddf_boolean *selected)
/* Select a position (*r,*s) in the matrix A.T such that (A.T)[*r][*s] is nonzero
   The choice is feasible, i.e., not on NopivotRow and NopivotCol, and
   best with respect to the specified roworder 
 */
{
  int stop;
  ddf_rowrange i,rtemp;
  rowset rowexcluded;
  myfloat Xtemp;
  ddf_boolean localdebug=ddf_FALSE;

  stop = ddf_FALSE;
  localdebug=ddf_debug;
  ddf_init(Xtemp);
  set_initialize(&rowexcluded,m_size);
  set_copy(rowexcluded,NopivotRow);
  for (i=rowmax+1;i<=m_size;i++) {
    set_addelem(rowexcluded,i);   /* cannot pivot on any row > rmax */
  }
  *selected = ddf_FALSE;
  do {
    rtemp=0; i=1;
    while (i<=m_size && rtemp==0) {  /* equalityset vars have highest priorities */
      if (set_member(i,equalityset) && !set_member(i,rowexcluded)){
        if (localdebug) fprintf(stderr,"marked set %ld chosen as a candidate\n",i);
        rtemp=i;
      }
      i++;
    }
    if (rtemp==0) ddf_SelectPreorderedNext2(m_size,d_size,rowexcluded,ordervec,&rtemp);;
    if (rtemp>=1) {
      *r=rtemp;
      *s=1;
      while (*s <= d_size && !*selected) {
        ddf_TableauEntry(&Xtemp,m_size,d_size,A,T,*r,*s);
        if (!set_member(*s,NopivotCol) && ddf_Nonzero(Xtemp)) {
          *selected = ddf_TRUE;
          stop = ddf_TRUE;
        } else {
          (*s)++;
        }
      }
      if (!*selected) {
        set_addelem(rowexcluded,rtemp);
      }
    }
    else {
      *r = 0;
      *s = 0;
      stop = ddf_TRUE;
    }
  } while (!stop);
  set_free(rowexcluded); ddf_clear(Xtemp);
}

void ddf_GaussianColumnPivot(ddf_rowrange m_size, ddf_colrange d_size, 
    ddf_Amatrix X, ddf_Bmatrix T, ddf_rowrange r, ddf_colrange s)
/* Update the Transformation matrix T with the pivot operation on (r,s) 
   This procedure performs a implicit pivot operation on the matrix X by
   updating the dual basis inverse  T.
 */
{
  ddf_colrange j, j1;
  myfloat Xtemp0, Xtemp1, Xtemp;
  static ddf_Arow Rtemp;
  static ddf_colrange last_d=0;
  ddf_boolean localdebug=ddf_debug;

  ddf_init(Xtemp0); ddf_init(Xtemp1); ddf_init(Xtemp);
  if (last_d!=d_size){
    if (last_d>0) {
      for (j=1; j<=last_d; j++) ddf_clear(Rtemp[j-1]);
      free(Rtemp);
    }
    Rtemp=(myfloat*)calloc(d_size,sizeof(myfloat));
    for (j=1; j<=d_size; j++) ddf_init(Rtemp[j-1]);
    last_d=d_size;
  }

  for (j=1; j<=d_size; j++) {
    ddf_TableauEntry(&(Rtemp[j-1]), m_size, d_size, X, T, r,j);
  }
  ddf_set(Xtemp0,Rtemp[s-1]);
  if (localdebug) {
    fprintf(stderr,"Gaussian Pivot: pivot entry = "); ddf_WriteNumber(stderr,Xtemp0);
    fprintf(stderr,"\n");
  }
  for (j = 1; j <= d_size; j++) {
    if (j != s) {
      ddf_div(Xtemp,Rtemp[j-1],Xtemp0);
      ddf_set(Xtemp1,ddf_purezero);
      for (j1 = 1; j1 <= d_size; j1++){
        ddf_mul(Xtemp1,Xtemp,T[j1-1][s - 1]);
        ddf_sub(T[j1-1][j-1],T[j1-1][j-1],Xtemp1);
 /*     T[j1-1][j-1] -= T[j1-1][s - 1] * Xtemp / Xtemp0;  */
        if (localdebug){
          ddf_WriteNumber(stderr, T[j1-1][j-1]);
        }
      }
      if (localdebug) fprintf(stderr,"\n");
    }
    if (localdebug) fprintf(stderr,"\n");
  }
  for (j = 1; j <= d_size; j++)
    ddf_div(T[j-1][s - 1],T[j-1][s - 1],Xtemp0);

  ddf_clear(Xtemp0); ddf_clear(Xtemp1); ddf_clear(Xtemp);
}

void ddf_GaussianColumnPivot2(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A,ddf_Bmatrix T,ddf_colindex nbindex,ddf_rowindex bflag,ddf_rowrange r,ddf_colrange s)
/* Update the Transformation matrix T with the pivot operation on (r,s) 
   This procedure performs a implicit pivot operation on the matrix A by
   updating the dual basis inverse  T.
 */
{
  int localdebug=ddf_FALSE;
  long entering;

  ddf_GaussianColumnPivot(m_size,d_size,A,T,r,s);
  entering=nbindex[s];
  bflag[r]=s;     /* the nonbasic variable r corresponds to column s */
  nbindex[s]=r;   /* the nonbasic variable on s column is r */
  if (localdebug) {
    fprintf(stderr,"Column pivot: (leaving, entering) = (%ld, %ld)\n", r,entering);
    fprintf(stderr, "bflag[%ld] is set to %ld\n", r, s);
    if (d_size <=20 && m_size <40){
      ddf_WriteBmatrix(stderr,d_size,T);
      ddf_WriteTableau(stderr,m_size,d_size,A,T,nbindex,bflag);
    }
  }

  if (entering>0) bflag[entering]=-1;
     /* original variables have negative index and should not affect the row index */
}


void ddf_ResetTableau(ddf_rowrange m_size,ddf_colrange d_size,ddf_Bmatrix T,
    ddf_colindex nbindex,ddf_rowindex bflag,ddf_rowrange objrow,ddf_colrange rhscol)
{
  ddf_rowrange i;
  ddf_colrange j;
  
  /* Initialize T and nbindex */
  for (j=1; j<=d_size; j++) nbindex[j]=-j;
  nbindex[rhscol]=0; 
    /* RHS is already in nonbasis and is considered to be associated
       with the zero-th row of input. */
  ddf_SetToIdentity(d_size,T);
  
  /* Set the bflag according to nbindex */
  for (i=1; i<=m_size; i++) bflag[i]=-1;  
    /* all basic variables have index -1 */
  bflag[objrow]= 0; 
    /* bflag of the objective variable is 0,
       different from other basic variables which have -1 */
  for (j=1; j<=d_size; j++) if (nbindex[j]>0) bflag[nbindex[j]]=j;
    /* bflag of a nonbasic variable is its column number */

}

void ddf_SelectCrissCrossPivot(ddf_rowrange m_size,ddf_colrange d_size,ddf_Amatrix A,ddf_Bmatrix T,
    ddf_rowindex bflag,ddf_rowrange objrow,ddf_colrange rhscol,
    ddf_rowrange *r,ddf_colrange *s,
    int *selected,ddf_LPStatusType *lps)
{
  int colselected=ddf_FALSE,rowselected=ddf_FALSE;
  ddf_rowrange i;
  myfloat val;
  
  ddf_init(val);
  *selected=ddf_FALSE;
  *lps=ddf_LPSundecided;
  while ((*lps==ddf_LPSundecided) && (!rowselected) && (!colselected)) {
    for (i=1; i<=m_size; i++) {
      if (i!=objrow && bflag[i]==-1) {  /* i is a basic variable */
        ddf_TableauEntry(&val,m_size,d_size,A,T,i,rhscol);
        if (ddf_Negative(val)) {
          rowselected=ddf_TRUE;
          *r=i;
          break;
        }
      }
      else if (bflag[i] >0) { /* i is nonbasic variable */
        ddf_TableauEntry(&val,m_size,d_size,A,T,objrow,bflag[i]);
        if (ddf_Positive(val)) {
          colselected=ddf_TRUE;
          *s=bflag[i];
          break;
        }
      }
    }
    if  ((!rowselected) && (!colselected)) {
      *lps=ddf_Optimal;
      return;
    }
    else if (rowselected) {
     for (i=1; i<=m_size; i++) {
       if (bflag[i] >0) { /* i is nonbasic variable */
          ddf_TableauEntry(&val,m_size,d_size,A,T,*r,bflag[i]);
          if (ddf_Positive(val)) {
            colselected=ddf_TRUE;
            *s=bflag[i];
            *selected=ddf_TRUE;
            break;
          }
        }
      }
    }
    else if (colselected) {
      for (i=1; i<=m_size; i++) {
        if (i!=objrow && bflag[i]==-1) {  /* i is a basic variable */
          ddf_TableauEntry(&val,m_size,d_size,A,T,i,*s);
          if (ddf_Negative(val)) {
            rowselected=ddf_TRUE;
            *r=i;
            *selected=ddf_TRUE;
            break;
          }
        }
      }
    }
    if (!rowselected) {
      *lps=ddf_DualInconsistent;
    }
    else if (!colselected) {
      *lps=ddf_Inconsistent;
    }
  }
  ddf_clear(val);
}

void ddf_CrissCrossSolve(ddf_LPPtr lp, ddf_ErrorType *err)
{
  switch (lp->objective) {
    case ddf_LPmax:
         ddf_CrissCrossMaximize(lp->m,lp->d,lp->A,lp->B,lp->equalityset,lp->objrow,lp->rhscol,
           &(lp->LPS),&(lp->optvalue),lp->sol,lp->dsol,lp->nbindex,&(lp->re),&(lp->se),lp->pivots,err);
      break;
      
    case ddf_LPmin:
         ddf_CrissCrossMinimize(lp->m,lp->d,lp->A,lp->B,lp->equalityset,lp->objrow,lp->rhscol,
           &(lp->LPS),&(lp->optvalue),lp->sol,lp->dsol,lp->nbindex,&(lp->re),&(lp->se),lp->pivots,err);
      break;

    case ddf_LPnone: *err=ddf_NoLPObjective; break;
  }

}

void ddf_DualSimplexSolve(ddf_LPPtr lp, ddf_ErrorType *err)
{
  switch (lp->objective) {
    case ddf_LPmax:
         ddf_DualSimplexMaximize(lp->m,lp->d,lp->A,lp->B,lp->equalityset,lp->objrow,lp->rhscol,
           &(lp->LPS),&(lp->optvalue),lp->sol,lp->dsol,lp->nbindex,&(lp->re),&(lp->se),lp->pivots,err);
      break;
      
    case ddf_LPmin:
         ddf_DualSimplexMinimize(lp->m,lp->d,lp->A,lp->B,lp->equalityset,lp->objrow,lp->rhscol,
           &(lp->LPS),&(lp->optvalue),lp->sol,lp->dsol,lp->nbindex,&(lp->re),&(lp->se),lp->pivots,err);
      break;

    case ddf_LPnone: *err=ddf_NoLPObjective; break;
  }
}

#ifdef ddf_GMPRATIONAL

ddf_LPStatusType LPSf2LPS(ddf_LPStatusType lpsf)
{
   ddf_LPStatusType lps=ddf_LPSundecided;

   switch (lpsf) {
   case ddf_LPSundecided: lps=ddf_LPSundecided; break;
   case ddf_Optimal: lps=ddf_Optimal; break;
   case ddf_Inconsistent: lps=ddf_Inconsistent; break; 
   case ddf_DualInconsistent: lps=ddf_DualInconsistent; break;
   case ddf_StrucInconsistent: lps=ddf_StrucInconsistent; break; 
   case ddf_StrucDualInconsistent: lps=ddf_StrucDualInconsistent; break;
   case ddf_Unbounded: lps=ddf_Unbounded; break;
   case ddf_DualUnbounded: lps=ddf_DualUnbounded; break;
   }
   return lps;
}


void ddf_BasisStatus(ddf_LPPtr lpf, ddf_LPPtr lp, ddf_boolean *LPScorrect)
{
  int i;
  ddf_colrange j;
  ddf_boolean basisfound; 
 
  switch (lp->objective) {
    case ddf_LPmax:
      ddf_BasisStatusMaximize(lp->m,lp->d,lp->A,lp->B,lp->equalityset,lp->objrow,lp->rhscol,
           lpf->LPS,&(lp->optvalue),lp->sol,lp->dsol,lpf->nbindex,lpf->re,lpf->se,lp->pivots, 
           &basisfound, LPScorrect);
      if (*LPScorrect) {
         /* printf("BasisStatus Check: the current basis is verified with GMP\n"); */
         lp->LPS=LPSf2LPS(lpf->LPS);
         lp->re=lpf->re;
         lp->se=lpf->se;
         for (i=1; i<=5; i++) lp->pivots[i-1]+=lpf->pivots[i-1]; 
         for (j=1; j<=lp->d; j++) lp->nbindex[j]=lpf->nbindex[j]; 
      }
      break;
    case ddf_LPmin:
      ddf_BasisStatusMinimize(lp->m,lp->d,lp->A,lp->B,lp->equalityset,lp->objrow,lp->rhscol,
           lpf->LPS,&(lp->optvalue),lp->sol,lp->dsol,lpf->nbindex,lpf->re,lpf->se,lp->pivots, 
           &basisfound, LPScorrect);
      if (*LPScorrect) {
         /* printf("BasisStatus Check: the current basis is verified with GMP\n"); */
         lp->LPS=LPSf2LPS(lpf->LPS);
         lp->re=lpf->re;
         lp->se=lpf->se;
         for (i=1; i<=4; i++) lp->pivots[i-1]+=lpf->pivots[i-1]; 
         for (j=1; j<=lp->d; j++) lp->nbindex[j]=lpf->nbindex[j]; 
      }
      break;
    case ddf_LPnone:  break;
   }      
}
#endif

void ddf_CrissCrossMinimize(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A,ddf_Bmatrix T,ddf_rowset equalityset,
    ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType *LPS,
    myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
    ddf_rowrange *re,ddf_colrange *se,long *pivots,ddf_ErrorType *err)
{
   ddf_colrange j;

   *err=ddf_NoError;
   for (j=1; j<=d_size; j++)
     ddf_neg(A[objrow-1][j-1],A[objrow-1][j-1]);
   ddf_CrissCrossMaximize(m_size,d_size,A,T,equalityset, objrow,rhscol,
     LPS,optvalue,sol,dsol,nbindex,re,se,pivots,err);
   ddf_neg(*optvalue,*optvalue);
   for (j=1; j<=d_size; j++){
     ddf_neg(dsol[j-1],dsol[j-1]);
     ddf_neg(A[objrow-1][j-1],A[objrow-1][j-1]);
   }
}

void ddf_CrissCrossMaximize(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A,ddf_Bmatrix T,ddf_rowset equalityset,
    ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType *LPS,
    myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
    ddf_rowrange *re,ddf_colrange *se,long *pivots,ddf_ErrorType *err)
/* 
When LP is inconsistent then *re returns the evidence row.
When LP is dual-inconsistent then *se returns the evidence column.
*/
{
  int stop,chosen,found;
  long pivots0,pivots1;
  ddf_rowrange i,r;
  ddf_colrange s;
  static ddf_rowindex bflag;
  static long mlast=0;
  static ddf_rowindex OrderVector;  /* the permutation vector to store a preordered row indeces */
  unsigned int rseed=1;
  ddf_colindex nbtemp;

  *err=ddf_NoError;
  nbtemp=(long *) calloc(d_size+1,sizeof(long*));
  for (i=0; i<= 4; i++) pivots[i]=0;
  if (bflag==NULL || mlast!=m_size){
     if (mlast!=m_size && mlast>0) {
       free(bflag);   /* called previously with different m_size */
       free(OrderVector);
     }
     bflag=(long *) calloc(m_size+1,sizeof(long*));
     OrderVector=(long *)calloc(m_size+1,sizeof(long*)); 
     /* initialize only for the first time or when a larger space is needed */
     
     mlast=m_size;
  }
  /* Initializing control variables. */
  ddf_ComputeRowOrderVector2(m_size,d_size,A,OrderVector,ddf_MinIndex,rseed);

  *re=0; *se=0; pivots1=0;

  ddf_ResetTableau(m_size,d_size,T,nbindex,bflag,objrow,rhscol);

  ddf_FindLPBasis(m_size,d_size,A,T,OrderVector, equalityset,
      nbindex,bflag, objrow,rhscol,&s,&found,LPS,&pivots0);
  pivots[0]=pivots0;

  if (!found){
     *se=s;
     goto _L99;
     /* No LP basis is found, and thus Inconsistent.  
     Output the evidence column. */
  }

  stop=ddf_FALSE;
  do {   /* Criss-Cross Method */
    ddf_SelectCrissCrossPivot(m_size,d_size,A,T,bflag,
       objrow,rhscol,&r,&s,&chosen,LPS);
    if (chosen) {
      ddf_GaussianColumnPivot2(m_size,d_size,A,T,nbindex,bflag,r,s);
      pivots1++;
    } else {
      switch (*LPS){
        case ddf_Inconsistent: *re=r;
        case ddf_DualInconsistent: *se=s;
        default: break;
      }
      stop=ddf_TRUE;
    }
  } while(!stop);
  pivots[1]=pivots1;
  
_L99:

  ddf_SetSolutions(m_size,d_size,A,T,
   objrow,rhscol,*LPS,optvalue,sol,dsol,nbindex,*re,*se);
  free(nbtemp);

}

void ddf_FindLPBasis(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A, ddf_Bmatrix T,ddf_rowindex OV,ddf_rowset equalityset, ddf_colindex nbindex,
    ddf_rowindex bflag,ddf_rowrange objrow,ddf_colrange rhscol,
    ddf_colrange *cs,int *found,ddf_LPStatusType *lps,long *pivot_no)
{ 
  /* Find a LP basis using Gaussian pivots.
     If the problem has an LP basis,
     the procedure returns *found=ddf_TRUE,*lps=LPSundecided and an LP basis.
     If the constraint matrix A (excluding the rhs and objective) is not
     column indepent, there are two cases.  If the dependency gives a dual
     inconsistency, this returns *found=ddf_FALSE, *lps=ddf_StrucDualInconsistent and 
     the evidence column *s.  Otherwise, this returns *found=ddf_TRUE, 
     *lps=LPSundecided and an LP basis of size less than d_size.  Columns j
     that do not belong to the basis (i.e. cannot be chosen as pivot because
     they are all zero) will be indicated in nbindex vector: nbindex[j] will
     be negative and set to -j.
  */
  int chosen,stop;
  long pivots_p0=0,rank;
  colset ColSelected;
  rowset RowSelected;
  myfloat val;

  ddf_rowrange r;
  ddf_colrange j,s;

  ddf_init(val);
  *found=ddf_FALSE; *cs=0; rank=0;
  *lps=ddf_LPSundecided;

  set_initialize(&RowSelected,m_size);
  set_initialize(&ColSelected,d_size);
  set_addelem(RowSelected,objrow);
  set_addelem(ColSelected,rhscol);

  stop=ddf_FALSE;
  do {   /* Find a LP basis */
    ddf_SelectPivot2(m_size,d_size,A,T,ddf_MinIndex,OV,equalityset,
      m_size,RowSelected,ColSelected,&r,&s,&chosen);
    if (chosen) {
      set_addelem(RowSelected,r);
      set_addelem(ColSelected,s);
      ddf_GaussianColumnPivot2(m_size,d_size,A,T,nbindex,bflag,r,s);
      pivots_p0++;
      rank++;
    } else {
      for (j=1;j<=d_size  && *lps==ddf_LPSundecided; j++) {
        if (j!=rhscol && nbindex[j]<0){
          ddf_TableauEntry(&val,m_size,d_size,A,T,objrow,j);
          if (ddf_Nonzero(val)){  /* dual inconsistent */
            *lps=ddf_StrucDualInconsistent;
            *cs=j;
            /* dual inconsistent because the nonzero reduced cost */
          }
        }
      }
      if (*lps==ddf_LPSundecided) *found=ddf_TRUE;  
         /* dependent columns but not dual inconsistent. */
      stop=ddf_TRUE;
    }
    if (rank==d_size-1) {
      stop = ddf_TRUE;
      *found=ddf_TRUE;
    }
  } while (!stop);

  *pivot_no=pivots_p0;
  set_free(RowSelected);
  set_free(ColSelected);
  ddf_clear(val);
}


void ddf_FindLPBasis2(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A, ddf_Bmatrix T,ddf_rowindex OV,ddf_rowset equalityset, ddf_colindex nbindex,
    ddf_rowindex bflag,ddf_rowrange objrow,ddf_colrange rhscol,
    ddf_colrange *cs,int *found,long *pivot_no)
{ 
  /* Similar to ddf_FindLPBasis but it is much simpler.  This tries to recompute T for
  the specified basis given by nbindex.  It will return *found=ddf_FALSE if the specified
  basis is not a basis.
  */
  int chosen,stop;
  long pivots_p0=0,rank;
  ddf_colset ColSelected,DependentCols;
  ddf_rowset RowSelected, NopivotRow;
  myfloat val;
  ddf_boolean localdebug=ddf_FALSE;

  ddf_rowrange r,negcount=0;
  ddf_colrange j,s;

  ddf_init(val);
  *found=ddf_FALSE; *cs=0; rank=0;

  set_initialize(&RowSelected,m_size);
  set_initialize(&DependentCols,d_size);
  set_initialize(&ColSelected,d_size);
  set_initialize(&NopivotRow,m_size);
  set_addelem(RowSelected,objrow);
  set_addelem(ColSelected,rhscol);
  set_compl(NopivotRow, NopivotRow);  /* set NopivotRow to be the groundset */
  
  for (j=2; j<=d_size; j++) 
    if (nbindex[j]>0) 
       set_delelem(NopivotRow, nbindex[j]);
    else if (nbindex[j]<0){ 
       negcount++;       
       set_addelem(DependentCols, -nbindex[j]); 
       set_addelem(ColSelected, -nbindex[j]); 
    }
 
  set_uni(RowSelected, RowSelected, NopivotRow);  /* RowSelected is the set of rows not allowed to poviot on */

  stop=ddf_FALSE;
  do {   /* Find a LP basis */
    ddf_SelectPivot2(m_size,d_size,A,T,ddf_MinIndex,OV,equalityset, m_size,RowSelected,ColSelected,&r,&s,&chosen);
    if (chosen) {
      set_addelem(RowSelected,r);
      set_addelem(ColSelected,s);

      ddf_GaussianColumnPivot2(m_size,d_size,A,T,nbindex,bflag,r,s);
      if (localdebug && m_size <=10){
        ddf_WriteBmatrix(stderr,d_size,T);
        ddf_WriteTableau(stderr,m_size,d_size,A,T,nbindex,bflag);
      }
      pivots_p0++;
      rank++;
    } else{
      *found=ddf_FALSE;   /* cannot pivot on any of the spacified positions. */
      stop=ddf_TRUE;
    }
    if (rank==d_size-1-negcount) {
      if (negcount){
        /* Now it tries to pivot on rows that are supposed to be dependent. */ 
        set_diff(ColSelected, ColSelected, DependentCols); 
        ddf_SelectPivot2(m_size,d_size,A,T,ddf_MinIndex,OV,equalityset, m_size,RowSelected,ColSelected,&r,&s,&chosen);
        if (chosen) *found=ddf_FALSE;  /* not supposed to be independent */
        else *found=ddf_TRUE;
        if (localdebug){
          printf("Try to check the dependent cols:");
          set_write(DependentCols);
          if (chosen) printf("They are not dependent.  Can still pivot on (%ld, %ld)\n",r, s);
          else printf("They are indeed dependent.\n");
        }
      } else {
        *found=ddf_TRUE;
     }   
     stop = ddf_TRUE;
    }
  } while (!stop);

  for (j=1; j<=d_size; j++) if (nbindex[j]>0) bflag[nbindex[j]]=j;
  *pivot_no=pivots_p0;
  set_free(RowSelected);
  set_free(ColSelected);
  set_free(NopivotRow);
  set_free(DependentCols);
  ddf_clear(val);
}

void ddf_FindDualFeasibleBasis(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A,ddf_Bmatrix T,ddf_rowindex OV,
    ddf_colindex nbindex,ddf_rowindex bflag,ddf_rowrange objrow,ddf_colrange rhscol,
    ddf_colrange *s,ddf_ErrorType *err,ddf_LPStatusType *lps,long *pivot_no, long maxpivots)
{ 
  /* Find a dual feasible basis using Phase I of Dual Simplex method.
     If the problem is dual feasible,
     the procedure returns *err=NoError, *lps=LPSundecided and a dual feasible
     basis.   If the problem is dual infeasible, this returns
     *err=NoError, *lps=DualInconsistent and the evidence column *s.
     Caution: matrix A must have at least one extra row:  the row space A[m_size] must
     have been allocated.
  */
  int phase1,dualfeasible=ddf_TRUE,localdebug=ddf_FALSE,chosen,stop;
  ddf_LPStatusType LPSphase1;
  long pivots_p1=0;
  ddf_rowrange i,r_val;
  ddf_colrange j,l,ms=0,s_val,local_m_size;
  myfloat x,val,maxcost;
  static ddf_colrange d_last=0;
  static ddf_Arow rcost;

  ddf_init(x); ddf_init(val);
  ddf_init(maxcost);  ddf_set(maxcost,ddf_minuszero);
  if (d_last<d_size) {
    if (d_last>0) {
      for (j=1; j<=d_last; j++){ ddf_clear(rcost[j-1]);}
      free(rcost);
    }
    rcost=(myfloat*) calloc(d_size,sizeof(myfloat));
    for (j=1; j<=d_size; j++){ ddf_init(rcost[j-1]);}
  }
  d_last=d_size;

  *err=ddf_NoError; *lps=ddf_LPSundecided; *s=0;
  local_m_size=m_size+1;  /* increase m_size by 1 */

  ms=0;  /* ms will be the index of column which has the largest reduced cost */
  for (j=1; j<=d_size; j++){
    if (j!=rhscol){
      if (localdebug) fprintf(stderr,"checking the column %ld var %ld\n",j,nbindex[j]); 
      ddf_TableauEntry(&(rcost[j-1]),local_m_size,d_size,A,T,objrow,j);
      if (localdebug) {fprintf(stderr,"reduced cost = "); ddf_WriteNumber(stderr, rcost[j-1]); }
      if (ddf_Larger(rcost[j-1],maxcost)) {ddf_set(maxcost,rcost[j-1]); ms = j;}
    }
  }
  if (ddf_Positive(maxcost)) dualfeasible=ddf_FALSE;

  if (!dualfeasible){
    for (j=1; j<=d_size; j++){
      ddf_set(A[local_m_size-1][j-1], ddf_purezero);
      for (l=1; l<=d_size; l++){
        if (nbindex[l]>0) {
          ddf_sub(A[local_m_size-1][j-1],A[local_m_size-1][j-1],A[nbindex[l]-1][j-1]); 
          /* To make the auxiliary row (0,-1,-1,...,-1).  */
        }
      }
    }
    if (localdebug){
      fprintf(stderr,"ddf_FindDualFeasibleBasis: curruent basis is not dual feasible.\n");
      fprintf(stderr,"because of the column %ld assoc. with var %ld   dual cost =",
       ms,nbindex[ms]);
      ddf_WriteNumber(stderr, maxcost);
    }

    /* Pivot on (local_m_size,ms) so that the dual basic solution becomes feasible */
    ddf_GaussianColumnPivot2(local_m_size,d_size,A,T,nbindex,bflag,local_m_size,ms);
    pivots_p1=pivots_p1+1;

    phase1=ddf_TRUE; stop=ddf_FALSE;
    do {   /* Dual Simplex Phase I */
      chosen=ddf_FALSE; LPSphase1=ddf_LPSundecided;
      if (pivots_p1>maxpivots) {
        *err=ddf_LPCycling;
        fprintf(stderr,"max number %ld of pivots performed in Phase I. Switch to the anticycling phase.\n", maxpivots);
        goto _L99;  /* failure due to max no. of pivots performed */
      }
      ddf_SelectDualSimplexPivot(local_m_size,d_size,phase1,A,T,OV,nbindex,bflag,
        objrow,rhscol,&r_val,&s_val,&chosen,&LPSphase1);
      if (!chosen) {
        /* The current dictionary is terminal.  There are two cases:
           ddf_TableauEntry(local_m_size,d_size,A,T,objrow,ms) is negative or zero.
           The first case implies dual infeasible,
           and the latter implies dual feasible but local_m_size is still in nonbasis.
           We must pivot in the auxiliary variable local_m_size. 
        */

        myfloat minval;
        ddf_init(minval);
        r_val=0;
        for (i=1; i<=local_m_size; i++){
          if (bflag[i]<0) { 
             /* i is basic and not the objective variable */
            ddf_TableauEntry(&val,local_m_size,d_size,A,T,i,ms);  /* auxiliary column*/
            if (ddf_Smaller(val, minval)) {
              r_val=i;
              ddf_set(minval,val);
              if (localdebug) {
                fprintf(stderr,"update minval with = ");
                ddf_WriteNumber(stderr, minval);
                fprintf(stderr,"  r_val = %ld\n",r_val);
              }
            }
          }
        }
        ddf_clear(minval);

        ddf_GaussianColumnPivot2(local_m_size,d_size,A,T,nbindex,bflag,r_val,ms);
        pivots_p1=pivots_p1+1;

        ddf_TableauEntry(&x,local_m_size,d_size,A,T,objrow,ms);
        if (ddf_Negative(x)){
          *err=ddf_NoError; *lps=ddf_DualInconsistent;  *s=ms;
        }
        stop=ddf_TRUE;
      } else {
        ddf_GaussianColumnPivot2(local_m_size,d_size,A,T,nbindex,bflag,r_val,s_val);
        pivots_p1=pivots_p1+1;
        if (bflag[local_m_size]<0) {
          stop=ddf_TRUE; 
          if (localdebug) 
            fprintf(stderr,"Dual Phase I: the auxiliary variable entered the basis, go to phase II\n");
        }
      }
    } while(!stop);
  }
_L99:
  *pivot_no=pivots_p1;
  ddf_clear(x); ddf_clear(val); ddf_clear(maxcost);
}

void ddf_DualSimplexMinimize(ddf_rowrange m_size,ddf_colrange d_size,
   ddf_Amatrix A,ddf_Bmatrix T,ddf_rowset equalityset,
   ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType *LPS,
   myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
   ddf_rowrange *re,ddf_colrange *se,long *pivots,ddf_ErrorType *err)
{
   ddf_colrange j;

   *err=ddf_NoError;
   for (j=1; j<=d_size; j++)
     ddf_neg(A[objrow-1][j-1],A[objrow-1][j-1]);
   ddf_DualSimplexMaximize(m_size,d_size,A,T,equalityset, objrow,rhscol,
     LPS,optvalue,sol,dsol,nbindex,re,se,pivots,err);
   ddf_neg(*optvalue,*optvalue);
   for (j=1; j<=d_size; j++){
     ddf_neg(dsol[j-1],dsol[j-1]);
     ddf_neg(A[objrow-1][j-1],A[objrow-1][j-1]);
   }
}

void ddf_DualSimplexMaximize(ddf_rowrange m_size,ddf_colrange d_size,
   ddf_Amatrix A,ddf_Bmatrix T,ddf_rowset equalityset,
   ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType *LPS,
   myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
   ddf_rowrange *re,ddf_colrange *se,long *pivots,ddf_ErrorType *err)
/* 
When LP is inconsistent then *re returns the evidence row.
When LP is dual-inconsistent then *se returns the evidence column.
*/
{
  int stop,chosen,phase1,found;
  long pivots_ds=0,pivots_p0=0,pivots_p1=0,pivots_pc=0,maxpivots,maxpivfactor=40;
  ddf_rowrange i,r;
  ddf_colrange s;
  static ddf_rowindex bflag;
  static long mlast=0,nlast=0;
  static ddf_rowindex OrderVector;  /* the permutation vector to store a preordered row indeces */
  unsigned int rseed=1;
  
  /* *err=ddf_NoError; */
  for (i=0; i<= 4; i++) pivots[i]=0;
  maxpivots=maxpivfactor*d_size;  /* maximum pivots to be performed before cc pivot is applied. */
  if (mlast!=m_size || nlast!=d_size){
     if (mlast>0) { /* called previously with different m_size */
       free(OrderVector);
       free(bflag);
     }
     OrderVector=(long *)calloc(m_size+1,sizeof(*OrderVector));
     bflag=(long *) calloc(m_size+2,sizeof(*bflag));  /* one more element for an auxiliary variable  */
     mlast=m_size;nlast=d_size;
  }
  /* Initializing control variables. */
  ddf_ComputeRowOrderVector2(m_size,d_size,A,OrderVector,ddf_MinIndex,rseed);

  *re=0; *se=0;
  
  ddf_ResetTableau(m_size,d_size,T,nbindex,bflag,objrow,rhscol);
   
  ddf_FindLPBasis(m_size,d_size,A,T,OrderVector,equalityset,nbindex,bflag,
      objrow,rhscol,&s,&found,LPS,&pivots_p0);
  pivots[0]=pivots_p0;

  if (!found){
     *se=s;
     goto _L99;
     /* No LP basis is found, and thus Inconsistent.  
     Output the evidence column. */
  }

  ddf_FindDualFeasibleBasis(m_size,d_size,A,T,OrderVector,nbindex,bflag,
      objrow,rhscol,&s, err, LPS,&pivots_p1, maxpivots);
  pivots[1]=pivots_p1;

  if (*err==ddf_LPCycling){
    if (ddf_debug) fprintf(stderr, "Phase I failed and thus switch to the Criss-Cross method\n");
    ddf_CrissCrossMaximize(m_size,d_size,A,T,equalityset,
    objrow,rhscol,LPS,optvalue,sol,dsol,nbindex,re,se,pivots,err);
    return;
  }
  if (*LPS==ddf_DualInconsistent){
     *se=s;
     goto _L99;
     /* No dual feasible basis is found, and thus DualInconsistent.  
     Output the evidence column. */
  }

  /* Dual Simplex Method */
  stop=ddf_FALSE;
  do {
    chosen=ddf_FALSE; *LPS=ddf_LPSundecided; phase1=ddf_FALSE;
    if (pivots_ds<maxpivots) {
      ddf_SelectDualSimplexPivot(m_size,d_size,phase1,A,T,OrderVector,nbindex,bflag,
        objrow,rhscol,&r,&s,&chosen,LPS);
    }
    if (chosen) pivots_ds=pivots_ds+1;
    if (!chosen && *LPS==ddf_LPSundecided) {  
      if (ddf_debug) fprintf(stderr,"Warning: an emergency CC pivot in Phase II is performed\n");
      /* In principle this should not be executed because we already have dual feasibility
         attained and dual simplex pivot should have been chosen.  This might occur
         under floating point computation, or the case of cycling.
      */
      ddf_SelectCrissCrossPivot(m_size,d_size,A,T,bflag,
        objrow,rhscol,&r,&s,&chosen,LPS);
      if (chosen) pivots_pc=pivots_pc+1;
    }
    if (chosen) {
      ddf_GaussianColumnPivot2(m_size,d_size,A,T,nbindex,bflag,r,s);
    } else {
      switch (*LPS){
        case ddf_Inconsistent: *re=r;
        case ddf_DualInconsistent: *se=s;
        default: break;
      }
      stop=ddf_TRUE;
    }
  } while(!stop);
  pivots[2]=pivots_ds;
  pivots[3]=pivots_pc;

_L99: 
  ddf_SetSolutions(m_size,d_size,A,T,objrow,rhscol,*LPS,optvalue,sol,dsol,nbindex,*re,*se);
}

void ddf_SetSolutions(ddf_rowrange m_size,ddf_colrange d_size,
   ddf_Amatrix A,ddf_Bmatrix T,
   ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType LPS,
   myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
   ddf_rowrange re,ddf_colrange se)
/* 
Assign the solution vectors to sol,dsol,*optvalue after solving
the LP.
*/
{
  ddf_colrange j;
  myfloat x,sw;
  int localdebug=ddf_FALSE;
  
  ddf_init(x); ddf_init(sw);
  switch (LPS){
  case ddf_Optimal:
    for (j=1;j<=d_size; j++) {
      ddf_set(sol[j-1],T[j-1][rhscol-1]);
      ddf_TableauEntry(&x,m_size,d_size,A,T,objrow,j);
      ddf_neg(dsol[j-1],x);
      ddf_TableauEntry(optvalue,m_size,d_size,A,T,objrow,rhscol);
      if (localdebug) {fprintf(stderr,"dsol[%ld]= ",nbindex[j]); ddf_WriteNumber(stderr, dsol[j-1]); }
    }
    break;
  case ddf_Inconsistent:
    if (localdebug) fprintf(stderr,"DualSimplexSolve: LP is inconsistent.\n");
    for (j=1;j<=d_size; j++) {
      ddf_set(sol[j-1],T[j-1][rhscol-1]);
      ddf_TableauEntry(&x,m_size,d_size,A,T,re,j);
      ddf_neg(dsol[j-1],x);
      if (localdebug) {fprintf(stderr,"dsol[%ld]= ",nbindex[j]); ddf_WriteNumber(stderr,dsol[j-1]);}
    }
    break;
  case ddf_DualInconsistent:
    for (j=1;j<=d_size; j++) {
      ddf_set(sol[j-1],T[j-1][se-1]);
      ddf_TableauEntry(&x,m_size,d_size,A,T,objrow,j);
      ddf_neg(dsol[j-1],x);
      if (localdebug) {fprintf(stderr,"dsol[%ld]= \n",nbindex[j]);ddf_WriteNumber(stderr,dsol[j-1]);}
    }
    if (localdebug) printf( "DualSimplexSolve: LP is dual inconsistent.\n");
    break;

  case ddf_StrucDualInconsistent:
    ddf_TableauEntry(&x,m_size,d_size,A,T,objrow,se);
    if (ddf_Positive(x)) ddf_set(sw,ddf_one);
    else ddf_neg(sw,ddf_one);
    for (j=1;j<=d_size; j++) {
      ddf_mul(sol[j-1],sw,T[j-1][se-1]);
      ddf_TableauEntry(&x,m_size,d_size,A,T,objrow,j);
      ddf_neg(dsol[j-1],x);
      if (localdebug) {fprintf(stderr,"dsol[%ld]= ",nbindex[j]);ddf_WriteNumber(stderr,dsol[j-1]);}
    }
    if (localdebug) fprintf(stderr,"DualSimplexSolve: LP is dual inconsistent.\n");
    break;

  default:break;
  }
  ddf_clear(x); ddf_clear(sw);
}


void ddf_RandomPermutation2(ddf_rowindex OV,long t,unsigned int seed)
{
  long k,j,ovj;
  double u,xk,r,rand_max=(double) RAND_MAX;
  int localdebug=ddf_FALSE;

  srand(seed);
  for (j=t; j>1 ; j--) {
    r=rand();
    u=r/rand_max;
    xk=(double)(j*u +1);
    k=(long)xk;
    if (localdebug) fprintf(stderr,"u=%g, k=%ld, r=%g, randmax= %g\n",u,k,r,rand_max);
    ovj=OV[j];
    OV[j]=OV[k];
    OV[k]=ovj;
    if (localdebug) fprintf(stderr,"row %ld is exchanged with %ld\n",j,k); 
  }
}

void ddf_ComputeRowOrderVector2(ddf_rowrange m_size,ddf_colrange d_size,ddf_Amatrix A,
    ddf_rowindex OV,ddf_RowOrderType ho,unsigned int rseed)
{
  long i,itemp;
  
  OV[0]=0;
  switch (ho){
  case ddf_MaxIndex:
    for(i=1; i<=m_size; i++) OV[i]=m_size-i+1;
    break;

  case ddf_LexMin:
    for(i=1; i<=m_size; i++) OV[i]=i;
    ddf_QuickSort(OV,1,m_size,A,d_size);
   break;

  case ddf_LexMax:
    for(i=1; i<=m_size; i++) OV[i]=i;
    ddf_QuickSort(OV,1,m_size,A,d_size);
    for(i=1; i<=m_size/2;i++){   /* just reverse the order */
      itemp=OV[i];
      OV[i]=OV[m_size-i+1];
      OV[m_size-i+1]=itemp;
    }
    break;

  case ddf_RandomRow:
    for(i=1; i<=m_size; i++) OV[i]=i;
    if (rseed<=0) rseed=1;
    ddf_RandomPermutation2(OV,m_size,rseed);
    break;

  case ddf_MinIndex: 
    for(i=1; i<=m_size; i++) OV[i]=i;
    break;

  default: 
    for(i=1; i<=m_size; i++) OV[i]=i;
    break;
 }
}

void ddf_SelectPreorderedNext2(ddf_rowrange m_size,ddf_colrange d_size,
    rowset excluded,ddf_rowindex OV,ddf_rowrange *hnext)
{
  ddf_rowrange i,k;
  
  *hnext=0;
  for (i=1; i<=m_size && *hnext==0; i++){
    k=OV[i];
    if (!set_member(k,excluded)) *hnext=k ;
  }
}

#ifdef ddf_GMPRATIONAL

ddf_LPObjectiveType Obj2Obj(ddf_LPObjectiveType obj)
{
   ddf_LPObjectiveType objf=ddf_LPnone;

   switch (obj) {
   case ddf_LPnone: objf=ddf_LPnone; break;
   case ddf_LPmax: objf=ddf_LPmax; break;
   case ddf_LPmin: objf=ddf_LPmin; break;
   }
   return objf;
}

ddf_LPPtr ddf_LPgmp2LPf(ddf_LPPtr lp)
{
  ddf_rowrange i;
  ddf_colrange j;
  ddf_LPType *lpf;
  double val;
  ddf_boolean localdebug=ddf_FALSE;

  if (localdebug) fprintf(stderr,"Converting a GMP-LP to a float-LP.\n");
  
  lpf=ddf_CreateLPData(Obj2Obj(lp->objective), ddf_Real, lp->m, lp->d);
  lpf->Homogeneous = lp->Homogeneous;
  lpf->eqnumber=lp->eqnumber;  /* this records the number of equations */

  for (i = 1; i <= lp->m; i++) {
    if (set_member(i, lp->equalityset)) set_addelem(lpf->equalityset,i);    
          /* it is equality. Its reversed row will not be in this set */
      for (j = 1; j <= lp->d; j++) {
        val=mpq_get_d(lp->A[i-1][j-1]);
        ddf_set_d(lpf->A[i-1][j-1],val);
      }  /*of j*/
  }  /*of i*/

  return lpf;
}


#endif


ddf_boolean ddf_LPSolve(ddf_LPPtr lp,ddf_LPSolverType solver,ddf_ErrorType *err)
/* 
The current version of ddf_LPSolve that solves an LP with floating-arithmetics first
and then with the specified arithimetics if it is GMP.

When LP is inconsistent then *re returns the evidence row.
When LP is dual-inconsistent then *se returns the evidence column.
*/
{
  int i;
  ddf_boolean found=ddf_FALSE;
#ifdef ddf_GMPRATIONAL
  ddf_LPPtr lpf;
  ddf_ErrorType errf;
  ddf_boolean LPScorrect=ddf_FALSE;
  ddf_boolean localdebug=ddf_FALSE;
#endif

  *err=ddf_NoError;
  lp->solver=solver;
  time(&lp->starttime);

#ifndef ddf_GMPRATIONAL
  switch (lp->solver) {
    case ddf_CrissCross:
      ddf_CrissCrossSolve(lp,err);
      break;
    case ddf_DualSimplex:
      ddf_DualSimplexSolve(lp,err);
      break;
  }
#else
  lpf=ddf_LPgmp2LPf(lp);
  switch (lp->solver) {
    case ddf_CrissCross:
      ddf_CrissCrossSolve(lpf,&errf);                /* First, run with double float. */
      ddf_BasisStatus(lpf,lp, &LPScorrect);    /* Check the basis. */
      if (!LPScorrect) {
         if (localdebug) printf("BasisStatus: the current basis is NOT verified with GMP. Rerun with GMP.\n");
         ddf_CrissCrossSolve(lp,err);  /* Rerun with GMP if fails. */
      } else {
         if (localdebug) printf("BasisStatus: the current basis is verified with GMP. The LP Solved.\n");
      }
      break;
    case ddf_DualSimplex:
      ddf_DualSimplexSolve(lpf,&errf);                /* First, run with double float. */
      ddf_BasisStatus(lpf,lp, &LPScorrect);    /* Check the basis. */
      if (!LPScorrect){
         if (localdebug) printf("BasisStatus: the current basis is NOT verified with GMP. Rerun with GMP.\n");
         ddf_DualSimplexSolve(lp,err);  /* Rerun with GMP if fails. */
         if (localdebug){
            printf("*total number pivots = %ld (ph0 = %ld, ph1 = %ld, ph2 = %ld, ph3 = %ld, ph4 = %ld)\n",
               lp->total_pivots,lp->pivots[0],lp->pivots[1],lp->pivots[2],lp->pivots[3],lp->pivots[4]);
            ddf_WriteLPResult(stdout, lpf, errf);
            ddf_WriteLP(stdout, lp);
         }
      } else {
         if (localdebug) printf("BasisStatus: the current basis is verified with GMP. The LP Solved.\n");
      }
      break;
  }
  ddf_FreeLPData(lpf);
#endif

  time(&lp->endtime);
  lp->total_pivots=0;
  for (i=0; i<=4; i++) lp->total_pivots+=lp->pivots[i];
  if (*err==ddf_NoError) found=ddf_TRUE;
  return found;
}


ddf_boolean ddf_LPSolve0(ddf_LPPtr lp,ddf_LPSolverType solver,ddf_ErrorType *err)
/* 
The original version of ddf_LPSolve that solves an LP with specified arithimetics.

When LP is inconsistent then *re returns the evidence row.
When LP is dual-inconsistent then *se returns the evidence column.
*/
{
  int i;
  ddf_boolean found=ddf_FALSE;

  *err=ddf_NoError;
  lp->solver=solver;
  time(&lp->starttime);

  switch (lp->solver) {
    case ddf_CrissCross:
      ddf_CrissCrossSolve(lp,err);
      break;
    case ddf_DualSimplex:
      ddf_DualSimplexSolve(lp,err);
      break;
  }

  time(&lp->endtime);
  lp->total_pivots=0;
  for (i=0; i<=4; i++) lp->total_pivots+=lp->pivots[i];
  if (*err==ddf_NoError) found=ddf_TRUE;
  return found;
}

ddf_LPPtr ddf_MakeLPforInteriorFinding(ddf_LPPtr lp)
/* Delete the objective row,
   add an extra column with -1's to the matrix A,
   add an extra row with (bceil, 0,...,0,-1),
   add an objective row with (0,...,0,1), and 
   rows & columns, and change m_size and d_size accordingly, to output new_A.
  This sets up the LP:
  maximize      x_{d+1}
  s.t.    A x + x_{d+1}  <=  b
                x_{d+1}  <=  bm * bmax,
  where bm is set to 2 by default, and bmax=max{1, b[1],...,b[m_size]}.
*/
{
  ddf_rowrange m;
  ddf_colrange d;
  ddf_NumberType numbtype;
  ddf_LPObjectiveType obj;
  ddf_LPType *lpnew;
  ddf_rowrange i; 
  ddf_colrange j;
  myfloat bm,bmax,bceil;
  int localdebug=ddf_FALSE;

  ddf_init(bm); ddf_init(bmax); ddf_init(bceil);
  ddf_add(bm,ddf_one,ddf_one); ddf_set(bmax,ddf_one);
  numbtype=lp->numbtype;
  m=lp->m+1;
  d=lp->d+1;
  obj=ddf_LPmax;

  lpnew=ddf_CreateLPData(obj, numbtype, m, d);

  for (i=1; i<=lp->m; i++) {
    if (ddf_Larger(lp->A[i-1][lp->rhscol-1],bmax)) 
      ddf_set(bmax,lp->A[i-1][lp->rhscol-1]);
  }
  ddf_mul(bceil,bm,bmax);
  if (localdebug) {fprintf(stderr,"bceil is set to "); ddf_WriteNumber(stderr, bceil);}
  
  for (i=1; i <= lp->m; i++) {
    for (j=1; j <= lp->d; j++) {
      ddf_set(lpnew->A[i-1][j-1],lp->A[i-1][j-1]);
    }
  }

  for (i=1;i<=lp->m; i++){
    ddf_neg(lpnew->A[i-1][lp->d],ddf_one);  /* new column with all minus one's */
  }

  for (j=1;j<=lp->d;j++){
    ddf_set(lpnew->A[m-2][j-1],ddf_purezero);   /* new row (bceil, 0,...,0,-1) */
  }
  ddf_set(lpnew->A[m-2][0],bceil);  /* new row (bceil, 0,...,0,-1) */

  for (j=1;j<= d-1;j++) {
    ddf_set(lpnew->A[m-1][j-1],ddf_purezero);  /* new obj row with (0,...,0,1) */
  }
  ddf_set(lpnew->A[m-1][d-1],ddf_one);    /* new obj row with (0,...,0,1) */
 
  if (localdebug) ddf_WriteAmatrix(stderr, lp->A, lp->m, lp->d);
  if (localdebug) ddf_WriteAmatrix(stderr, lpnew->A, lpnew->m, lpnew->d);
  ddf_clear(bm); ddf_clear(bmax); ddf_clear(bceil);

  return lpnew;
}


void ddf_WriteLPResult(FILE *f,ddf_LPPtr lp,ddf_ErrorType err)
{
  long j;

  fprintf(f,"* cdd LP solver result\n");
  
  if (err!=ddf_NoError) {
    ddf_WriteErrorMessages(f,err);
    goto _L99;
  }

  ddf_WriteProgramDescription(f);

  fprintf(f,"* #constraints = %ld\n",lp->m-1);
  fprintf(f,"* #variables   = %ld\n",lp->d-1);

  switch (lp->solver) {
    case ddf_DualSimplex:
      fprintf(f,"* Algorithm: dual simplex algorithm\n");break; 
    case ddf_CrissCross:
      fprintf(f,"* Algorithm: criss-cross method\n");break;
  }

  switch (lp->objective) {
    case ddf_LPmax:
      fprintf(f,"* maximization is chosen\n");break; 
    case ddf_LPmin:
      fprintf(f,"* minimization is chosen\n");break;
    case ddf_LPnone:
      fprintf(f,"* no objective type (max or min) is chosen\n");break;
  }
  
  if (lp->objective==ddf_LPmax||lp->objective==ddf_LPmin){
    fprintf(f,"* Objective function is\n");  
    for (j=0; j<lp->d; j++){
      if (j>0 && ddf_Nonnegative(lp->A[lp->objrow-1][j]) ) fprintf(f," +");
      if (j>0 && (j % 5) == 0) fprintf(f,"\n");
      ddf_WriteNumber(f,lp->A[lp->objrow-1][j]);
      if (j>0) fprintf(f," X[%3ld]",j);
    }
    fprintf(f,"\n");
  }

  switch (lp->LPS){
  case ddf_Optimal:
    fprintf(f,"* LP status: a dual pair (x,y) of optimal solutions found.\n");
    fprintf(f,"begin\n");
    fprintf(f,"  primal_solution\n");
    for (j=1; j<lp->d; j++) {
      fprintf(f,"  %3ld : ",j);
      ddf_WriteNumber(f,lp->sol[j]);
      fprintf(f,"\n");
    }
    fprintf(f,"  dual_solution\n");
    for (j=1; j<lp->d; j++){
      if (lp->nbindex[j+1]>0) {
        fprintf(f,"  %3ld : ",lp->nbindex[j+1]);
        ddf_WriteNumber(f,lp->dsol[j]); fprintf(f,"\n");
      }
    }
    fprintf(f,"  optimal_value : "); ddf_WriteNumber(f,lp->optvalue);
    fprintf(f,"\nend\n");
    break;

  case ddf_Inconsistent:
    fprintf(f,"* LP status: LP is inconsistent.\n");
    fprintf(f,"* The positive combination of original inequalities with\n");
    fprintf(f,"* the following coefficients will prove the inconsistency.\n");
    fprintf(f,"begin\n");
    fprintf(f,"  dual_direction\n");
    fprintf(f,"  %3ld : ",lp->re);
    ddf_WriteNumber(f,ddf_one);  fprintf(f,"\n");
    for (j=1; j<lp->d; j++){
      if (lp->nbindex[j+1]>0) {
        fprintf(f,"  %3ld : ",lp->nbindex[j+1]);
        ddf_WriteNumber(f,lp->dsol[j]); fprintf(f,"\n");
      }
    }
    fprintf(f,"end\n");
    break;

  case ddf_DualInconsistent: case ddf_StrucDualInconsistent:
    fprintf(f,"* LP status: LP is dual inconsistent.\n");
    fprintf(f,"* The linear combination of columns with\n");
    fprintf(f,"* the following coefficients will prove the dual inconsistency.\n");
    fprintf(f,"* (It is also an unbounded direction for the primal LP.)\n");
    fprintf(f,"begin\n");
    fprintf(f,"  primal_direction\n");
    for (j=1; j<lp->d; j++) {
      fprintf(f,"  %3ld : ",j);
      ddf_WriteNumber(f,lp->sol[j]);
      fprintf(f,"\n");
    }
    fprintf(f,"end\n");
    break;

  default:
    break;
  }
  fprintf(f,"* number of pivot operations = %ld (ph0 = %ld, ph1 = %ld, ph2 = %ld, ph3 = %ld, ph4 = %ld)\n",lp->total_pivots,lp->pivots[0],lp->pivots[1],lp->pivots[2],lp->pivots[3],lp->pivots[4]);
  ddf_WriteLPTimes(f, lp);
_L99:;
}

ddf_LPPtr ddf_CreateLP_H_Redundancy(ddf_MatrixPtr M, ddf_rowrange itest)
{
  ddf_rowrange m, i, irev, linc;
  ddf_colrange d, j;
  ddf_LPPtr lp;
  ddf_boolean localdebug=ddf_FALSE;

  linc=set_card(M->linset);
  m=M->rowsize+1+linc; 
     /* We represent each equation by two inequalities.
        This is not the best way but makes the code simple. */
  d=M->colsize;
  
  lp=ddf_CreateLPData(M->objective, M->numbtype, m, d);
  lp->Homogeneous = ddf_TRUE;
  lp->objective = ddf_LPmin;
  lp->eqnumber=linc;  /* this records the number of equations */

  irev=M->rowsize; /* the first row of the linc reversed inequalities. */
  for (i = 1; i <= M->rowsize; i++) {
    if (set_member(i, M->linset)) {
      irev=irev+1;
      set_addelem(lp->equalityset,i);    /* it is equality. */
            /* the reversed row irev is not in the equality set. */
      for (j = 1; j <= M->colsize; j++) {
        ddf_neg(lp->A[irev-1][j-1],M->matrix[i-1][j-1]);
      }  /*of j*/
      if (localdebug) fprintf(stderr,"equality row %ld generates the reverse row %ld.\n",i,irev);
    }
    for (j = 1; j <= M->colsize; j++) {
      ddf_set(lp->A[i-1][j-1],M->matrix[i-1][j-1]);
      if (j==1 && i<M->rowsize && ddf_Nonzero(M->matrix[i-1][j-1])) lp->Homogeneous = ddf_FALSE;
    }  /*of j*/
  }  /*of i*/
  for (j = 1; j <= M->colsize; j++) {
    ddf_set(lp->A[m-1][j-1],M->matrix[itest-1][j-1]);
      /* objective is to violate the inequality in question.  */
  }  /*of j*/
  ddf_add(lp->A[itest-1][0],lp->A[itest-1][0],ddf_one); /* relax the original inequality by one */

  return lp;
}

ddf_LPPtr ddf_CreateLP_V_Redundancy(ddf_MatrixPtr M, ddf_rowrange itest)
{
  ddf_rowrange m, i, irev, linc;
  ddf_colrange d, j;
  ddf_LPPtr lp;
  ddf_boolean localdebug=ddf_FALSE;

  linc=set_card(M->linset);
  m=M->rowsize+1+linc; 
     /* We represent each equation by two inequalities.
        This is not the best way but makes the code simple. */
  d=(M->colsize)+1;  
     /* One more column.  This is different from the H-reprentation case */
  
/* The below must be modified for V-representation!!!  */

  lp=ddf_CreateLPData(M->objective, M->numbtype, m, d);
  lp->Homogeneous = ddf_FALSE;
  lp->objective = ddf_LPmin;
  lp->eqnumber=linc;  /* this records the number of equations */

  irev=M->rowsize; /* the first row of the linc reversed inequalities. */
  for (i = 1; i <= M->rowsize; i++) {
    if (i==itest){
      ddf_set(lp->A[i-1][0],ddf_one); /* this is to make the LP bounded, ie. the min >= -1 */
    } else {
      ddf_set(lp->A[i-1][0],ddf_purezero);  /* It is almost completely degerate LP */
    }
    if (set_member(i, M->linset)) {
      irev=irev+1;
      set_addelem(lp->equalityset,i);    /* it is equality. */
            /* the reversed row irev is not in the equality set. */
      for (j = 2; j <= (M->colsize)+1; j++) {
        ddf_neg(lp->A[irev-1][j-1],M->matrix[i-1][j-2]);
      }  /*of j*/
      if (localdebug) fprintf(stderr,"equality row %ld generates the reverse row %ld.\n",i,irev);
    }
    for (j = 2; j <= (M->colsize)+1; j++) {
      ddf_set(lp->A[i-1][j-1],M->matrix[i-1][j-2]);
    }  /*of j*/
  }  /*of i*/
  for (j = 2; j <= (M->colsize)+1; j++) {
    ddf_set(lp->A[m-1][j-1],M->matrix[itest-1][j-2]);
      /* objective is to violate the inequality in question.  */
  }  /*of j*/
  ddf_set(lp->A[m-1][0],ddf_purezero);   /* the constant term for the objective is zero */

  if (localdebug) ddf_WriteLP(stdout, lp);

  return lp;
}

ddf_LPPtr ddf_CreateLP_V_SRedundancy(ddf_MatrixPtr M, ddf_rowrange itest)
{
/*
     V-representation (=boundary problem)
       g* = maximize  
         1^T b_{I-itest} x_0 + 1^T A_{I-itest}    (the sum of slacks)
       subject to
         b_itest x_0     + A_itest x      =  0 (the point has to lie on the boundary)
         b_{I-itest} x_0 + A_{I-itest} x >=  0 (all nonlinearity generators in one side)
         1^T b_{I-itest} x_0 + 1^T A_{I-itest} x <=  1 (to make an LP bounded)
         b_L x_0         + A_L x = 0.  (linearity generators)
         
    The redundant row is strongly redundant if and only if g* is zero.
*/

  ddf_rowrange m, i, irev, linc;
  ddf_colrange d, j;
  ddf_LPPtr lp;
  ddf_boolean localdebug=ddf_FALSE;

  linc=set_card(M->linset);
  m=M->rowsize+1+linc+2; 
     /* We represent each equation by two inequalities.
        This is not the best way but makes the code simple.
        Two extra constraints are for the first equation and the bouding inequality.
        */
  d=(M->colsize)+1;  
     /* One more column.  This is different from the H-reprentation case */
  
/* The below must be modified for V-representation!!!  */

  lp=ddf_CreateLPData(M->objective, M->numbtype, m, d);
  lp->Homogeneous = ddf_FALSE;
  lp->objective = ddf_LPmax;
  lp->eqnumber=linc;  /* this records the number of equations */

  irev=M->rowsize; /* the first row of the linc reversed inequalities. */
  for (i = 1; i <= M->rowsize; i++) {
    if (i==itest){
      ddf_set(lp->A[i-1][0],ddf_purezero);  /* this is a half of the boundary constraint. */
    } else {
      ddf_set(lp->A[i-1][0],ddf_purezero);  /* It is almost completely degerate LP */
    }
    if (set_member(i, M->linset) || i==itest) {
      irev=irev+1;
      set_addelem(lp->equalityset,i);    /* it is equality. */
            /* the reversed row irev is not in the equality set. */
      for (j = 2; j <= (M->colsize)+1; j++) {
        ddf_neg(lp->A[irev-1][j-1],M->matrix[i-1][j-2]);
      }  /*of j*/
      if (localdebug) fprintf(stderr,"equality row %ld generates the reverse row %ld.\n",i,irev);
    }
    for (j = 2; j <= (M->colsize)+1; j++) {
      ddf_set(lp->A[i-1][j-1],M->matrix[i-1][j-2]);
      ddf_add(lp->A[m-1][j-1],lp->A[m-1][j-1],lp->A[i-1][j-1]);  /* the objective is the sum of all ineqalities */
    }  /*of j*/
  }  /*of i*/
  for (j = 2; j <= (M->colsize)+1; j++) {
    ddf_neg(lp->A[m-2][j-1],lp->A[m-1][j-1]);
      /* to make an LP bounded.  */
  }  /*of j*/
  ddf_set(lp->A[m-2][0],ddf_one);   /* the constant term for the bounding constraint is 1 */

  if (localdebug) ddf_WriteLP(stdout, lp);

  return lp;
}

ddf_boolean ddf_Redundant(ddf_MatrixPtr M, ddf_rowrange itest, ddf_Arow certificate, ddf_ErrorType *error)  
  /* 092 */
{
  /* Checks whether the row itest is redundant for the representation.
     All linearity rows are not checked and considered NONredundant. 
     This code works for both H- and V-representations.  A certificate is
     given in the case of non-redundancy, showing a solution x violating only the itest
     inequality for H-representation, a hyperplane RHS and normal (x_0, x) that
     separates the itest from the rest.  More explicitly, the LP to be setup is

     H-representation
       f* = minimize  
         b_itest     + A_itest x
       subject to
         b_itest + 1 + A_itest x     >= 0 (relaxed inequality to make an LP bounded)
         b_{I-itest} + A_{I-itest} x >= 0 (all inequalities except for itest)
         b_L         + A_L x = 0.  (linearity)

     V-representation (=separation problem)
       f* = minimize  
         b_itest x_0     + A_itest x
       subject to
         b_itest x_0     + A_itest x     >= -1 (to make an LP bounded)
         b_{I-itest} x_0 + A_{I-itest} x >=  0 (all nonlinearity generators except for itest in one side)
         b_L x_0         + A_L x = 0.  (linearity generators)
    
    Here, the input matrix is considered as (b, A), i.e. b corresponds to the first column of input
    and the row indices of input is partitioned into I and L where L is the set of linearity.
    In both cases, the itest data is nonredundant if and only if the optimal value f* is negative.
    The certificate has dimension one more for V-representation case.
  */

  ddf_colrange j;
  ddf_LPPtr lp;
  ddf_LPSolutionPtr lps;
  ddf_ErrorType err=ddf_NoError;
  ddf_boolean answer=ddf_FALSE,localdebug=ddf_FALSE;

  *error=ddf_NoError;
  if (set_member(itest, M->linset)){
    if (localdebug) printf("The %ld th row is linearity and redundancy checking is skipped.\n",itest);
    goto _L99;
  }
  
  /* Create an LP data for redundancy checking */
  if (M->representation==ddf_Generator){
    lp=ddf_CreateLP_V_Redundancy(M, itest);
  } else {
    lp=ddf_CreateLP_H_Redundancy(M, itest);
  }

  ddf_LPSolve(lp,ddf_DualSimplex,&err);
  if (err!=ddf_NoError){
    *error=err;
    goto _L999;
  } else {
    lps=ddf_CopyLPSolution(lp);

    for (j=0; j<lps->d; j++) {
      ddf_set(certificate[j], lps->sol[j]);
    }

    if (ddf_Negative(lps->optvalue)){
      answer=ddf_FALSE;
      if (localdebug) fprintf(stderr,"==> %ld th inequality is nonredundant.\n",itest);
    } else {
      answer=ddf_TRUE;
      if (localdebug) fprintf(stderr,"==> %ld th inequality is redundant.\n",itest);
    }
    ddf_FreeLPSolution(lps);
  }
  _L999:
  ddf_FreeLPData(lp);
_L99:
  return answer;
}

ddf_rowset ddf_RedundantRows(ddf_MatrixPtr M, ddf_ErrorType *error)  /* 092 */
{
  ddf_rowrange i,m;
  ddf_colrange d;
  ddf_rowset redset;
  ddf_MatrixPtr Mcopy;
  ddf_Arow cvec; /* certificate */  
  ddf_boolean localdebug=ddf_FALSE;

  m=M->rowsize;
  if (M->representation==ddf_Generator){
    d=(M->colsize)+1;
  } else {
    d=M->colsize;
  }
  Mcopy=ddf_MatrixCopy(M);
  ddf_InitializeArow(d,&cvec); 
  set_initialize(&redset, m);
  for (i=m; i>=1; i--) {
    if (ddf_Redundant(Mcopy, i, cvec, error)) {
      if (localdebug) printf("ddf_RedundantRows: the row %ld is redundant.\n", i);
      set_addelem(redset, i);
      ddf_MatrixRowRemove(&Mcopy, i);
    } else {
      if (localdebug) printf("ddf_RedundantRows: the row %ld is essential.\n", i);
    }
    if (*error!=ddf_NoError) goto _L99;
  }
_L99:
  ddf_FreeMatrix(Mcopy);
  ddf_FreeArow(d, cvec);
  return redset;
}

ddf_boolean ddf_SRedundant(ddf_MatrixPtr M, ddf_rowrange itest, ddf_Arow certificate, ddf_ErrorType *error)  
  /* 093a */
{
  /* Checks whether the row itest is strongly redundant for the representation.
     A row is strongly redundant in H-representation if every point in
     the polyhedron satisfies it with strict inequality.
     A row is strongly redundant in V-representation if this point is in
     the interior of the polyhedron.
     
     All linearity rows are not checked and considered NOT strongly redundant. 
     This code works for both H- and V-representations.  A certificate is
     given in the case of non-redundancy, showing a solution x violating only the itest
     inequality for H-representation, a hyperplane RHS and normal (x_0, x) that
     separates the itest from the rest.  More explicitly, the LP to be setup is

     H-representation
       f* = minimize  
         b_itest     + A_itest x
       subject to
         b_itest + 1 + A_itest x     >= 0 (relaxed inequality to make an LP bounded)
         b_{I-itest} + A_{I-itest} x >= 0 (all inequalities except for itest)
         b_L         + A_L x = 0.  (linearity)

     V-representation (=separation problem)
       f* = minimize  
         b_itest x_0     + A_itest x
       subject to
         b_itest x_0     + A_itest x     >= -1 (to make an LP bounded)
         b_{I-itest} x_0 + A_{I-itest} x >=  0 (all nonlinearity generators except for itest in one side)
         b_L x_0         + A_L x = 0.  (linearity generators)
    
    Here, the input matrix is considered as (b, A), i.e. b corresponds to the first column of input
    and the row indices of input is partitioned into I and L where L is the set of linearity.
    In H-representation, the itest data is strongly redundant if and only if the optimal value f* is positive.
    In V-representation, the itest data is redundant if and only if the optimal value f* is zero (as the LP
    is homogeneous and the optimal value is always non-positive).  To recognize strong redundancy, one
    can set up a second LP
    
     V-representation (=boundary problem)
       g* = maximize  
         1^T b_{I-itest} x_0 + 1^T A_{I-itest}    (the sum of slacks)
       subject to
         b_itest x_0     + A_itest x      =  0 (the point has to lie on the boundary)
         b_{I-itest} x_0 + A_{I-itest} x >=  0 (all nonlinearity generators in one side)
         1^T b_{I-itest} x_0 + 1^T A_{I-itest} x <=  1 (to make an LP bounded)
         b_L x_0         + A_L x = 0.  (linearity generators)
         
    The redundant row is strongly redundant if and only if g* is zero.

    The certificate has dimension one more for V-representation case.
  */

  ddf_colrange j;
  ddf_LPPtr lp;
  ddf_LPSolutionPtr lps;
  ddf_ErrorType err=ddf_NoError;
  ddf_boolean answer=ddf_FALSE,localdebug=ddf_FALSE;

  *error=ddf_NoError;
  if (set_member(itest, M->linset)){
    if (localdebug) printf("The %ld th row is linearity and strong redundancy checking is skipped.\n",itest);
    goto _L99;
  }
  
  /* Create an LP data for redundancy checking */
  if (M->representation==ddf_Generator){
    lp=ddf_CreateLP_V_Redundancy(M, itest);
  } else {
    lp=ddf_CreateLP_H_Redundancy(M, itest);
  }

  ddf_LPSolve(lp,ddf_DualSimplex,&err);
  if (err!=ddf_NoError){
    *error=err;
    goto _L999;
  } else {
    lps=ddf_CopyLPSolution(lp);

    for (j=0; j<lps->d; j++) {
      ddf_set(certificate[j], lps->sol[j]);
    }

    if (localdebug){
      printf("Optimum value:");
      ddf_WriteNumber(stdout, lps->optvalue);
      printf("\n");
    }

    if (M->representation==ddf_Inequality){
       if (ddf_Positive(lps->optvalue)){
          answer=ddf_TRUE;
          if (localdebug) fprintf(stderr,"==> %ld th inequality is strongly redundant.\n",itest);
        } else {
          answer=ddf_FALSE;
          if (localdebug) fprintf(stderr,"==> %ld th inequality is not strongly redundant.\n",itest);
        } 
    } else {
       if (ddf_Negative(lps->optvalue)){
          answer=ddf_FALSE;
          if (localdebug) fprintf(stderr,"==> %ld th point is not strongly redundant.\n",itest);
        } else {
          /* for V-representation, we have to solve another LP */
          ddf_FreeLPData(lp);
          ddf_FreeLPSolution(lps);
          lp=ddf_CreateLP_V_SRedundancy(M, itest);
          ddf_LPSolve(lp,ddf_DualSimplex,&err);
          lps=ddf_CopyLPSolution(lp);
          if (localdebug) ddf_WriteLPResult(stdout,lp,err);
          if (ddf_Positive(lps->optvalue)){
            answer=ddf_FALSE;
            if (localdebug) fprintf(stderr,"==> %ld th point is not strongly redundant.\n",itest);
          } else {
            answer=ddf_TRUE;
            if (localdebug) fprintf(stderr,"==> %ld th point is strongly redundant.\n",itest);
          }
       }
    } 
    ddf_FreeLPSolution(lps);
  }
  _L999:
  ddf_FreeLPData(lp);
_L99:
  return answer;
}

ddf_rowset ddf_SRedundantRows(ddf_MatrixPtr M, ddf_ErrorType *error)  /* 093a */
{
  ddf_rowrange i,m;
  ddf_colrange d;
  ddf_rowset redset;
  ddf_MatrixPtr Mcopy;
  ddf_Arow cvec; /* certificate */  
  ddf_boolean localdebug=ddf_FALSE;

  m=M->rowsize;
  if (M->representation==ddf_Generator){
    d=(M->colsize)+1;
  } else {
    d=M->colsize;
  }
  Mcopy=ddf_MatrixCopy(M);
  ddf_InitializeArow(d,&cvec); 
  set_initialize(&redset, m);
  for (i=m; i>=1; i--) {
    if (ddf_SRedundant(Mcopy, i, cvec, error)) {
      if (localdebug) printf("ddf_SRedundantRows: the row %ld is strongly redundant.\n", i);
      set_addelem(redset, i);
      ddf_MatrixRowRemove(&Mcopy, i);
    } else {
      if (localdebug) printf("ddf_SRedundantRows: the row %ld is not strongly redundant.\n", i);
    }
    if (*error!=ddf_NoError) goto _L99;
  }
_L99:
  ddf_FreeMatrix(Mcopy);
  ddf_FreeArow(d, cvec);
  return redset;
}

ddf_rowset ddf_RedundantRowsViaShooting(ddf_MatrixPtr M, ddf_ErrorType *error)  /* 092 */
{
  /* 
     For H-representation only and not quite reliable,
     especially when floating-point arithmetic is used.
     Use the ordinary (slower) method ddf_RedundantRows.
  */

  ddf_rowrange i,m, ired, irow=0;
  ddf_colrange j,k,d;
  ddf_rowset redset;
  ddf_rowindex rowflag; 
    /* ith comp is negative if the ith inequality (i-1 st row) is redundant.
                   zero     if it is not decided.
                   k > 0    if it is nonredundant and assigned to the (k-1)th row of M1.
    */
  ddf_MatrixPtr M1;
  ddf_Arow shootdir, cvec=NULL;
  ddf_LPPtr lp0, lp;
  ddf_LPSolutionPtr lps; 
  ddf_ErrorType err;
  ddf_LPSolverType solver=ddf_DualSimplex; 
  ddf_boolean localdebug=ddf_FALSE;

  m=M->rowsize;
  d=M->colsize;
  M1=ddf_CreateMatrix(m,d);
  M1->rowsize=0;  /* cheat the rowsize so that smaller matrix can be stored */
  set_initialize(&redset, m);
  ddf_InitializeArow(d, &shootdir);
  ddf_InitializeArow(d, &cvec);

  rowflag=(long *)calloc(m+1, sizeof(long)); 

  /* First find some (likely) nonredundant inequalities by Interior Point Find. */
  lp0=ddf_Matrix2LP(M, &err);
  lp=ddf_MakeLPforInteriorFinding(lp0);
  ddf_FreeLPData(lp0); 
  ddf_LPSolve(lp, solver, &err);  /* Solve the LP */
  lps=ddf_CopyLPSolution(lp);

  if (ddf_Positive(lps->optvalue)){
    /* An interior point is found.  Use rayshooting to find some nonredundant
       inequalities. */
    for (j=1; j<d; j++){
      for (k=1; k<=d; k++) ddf_set(shootdir[k-1], ddf_purezero);
      ddf_set(shootdir[j], ddf_one);  /* j-th unit vector */
      ired=ddf_RayShooting(M, lps->sol, shootdir);
      if (localdebug) printf("nonredundant row %3ld found by shooting.\n", ired);
      if (ired>0 && rowflag[ired]<=0) {
        irow++;
        rowflag[ired]=irow;
        for (k=1; k<=d; k++) ddf_set(M1->matrix[irow-1][k-1], M->matrix[ired-1][k-1]); 
      }
        
      ddf_neg(shootdir[j], ddf_one);  /* negative of the j-th unit vector */
      ired=ddf_RayShooting(M, lps->sol, shootdir);
      if (localdebug) printf("nonredundant row %3ld found by shooting.\n", ired);
      if (ired>0 && rowflag[ired]<=0) {
        irow++;
        rowflag[ired]=irow;
        for (k=1; k<=d; k++) ddf_set(M1->matrix[irow-1][k-1], M->matrix[ired-1][k-1]); 
      }
    }

    M1->rowsize=irow;
    if (localdebug) {
      printf("The initial nonredundant set is:");
      for (i=1; i<=m; i++) if (rowflag[i]>0) printf(" %ld", i);
      printf("\n");
    }
    
    i=1;
    while(i<=m){
      if (rowflag[i]==0){ /* the ith inequality is not yet checked */
        if (localdebug) fprintf(stderr, "Checking redundancy of %ld th inequality\n", i);
        irow++;  M1->rowsize=irow;
        for (k=1; k<=d; k++) ddf_set(M1->matrix[irow-1][k-1], M->matrix[i-1][k-1]);
        if (!ddf_Redundant(M1, irow, cvec, &err)){
          for (k=1; k<=d; k++) ddf_sub(shootdir[k-1], cvec[k-1], lps->sol[k-1]); 
          ired=ddf_RayShooting(M, lps->sol, shootdir);
          rowflag[ired]=irow;
          for (k=1; k<=d; k++) ddf_set(M1->matrix[irow-1][k-1], M->matrix[ired-1][k-1]);
          if (localdebug) {
            fprintf(stderr, "The %ld th inequality is nonredundant for the subsystem\n", i);
            fprintf(stderr, "The nonredundancy of %ld th inequality is found by shooting.\n", ired);
          }
        } else {
          if (localdebug) fprintf(stderr, "The %ld th inequality is redundant for the subsystem and thus for the whole.\n", i);
          rowflag[i]=-1;
          set_addelem(redset, i);
          i++;
        }
      } else {
        i++;
      }
    } /* endwhile */
  } else {
    /* No interior point is found.  Apply the standard LP technique.  */
    redset=ddf_RedundantRows(M, error);
  }

  ddf_FreeLPData(lp);
  ddf_FreeLPSolution(lps);

  M1->rowsize=m; M1->colsize=d;  /* recover the original sizes */
  ddf_FreeMatrix(M1);
  ddf_FreeArow(d, shootdir);
  ddf_FreeArow(d, cvec);
  free(rowflag);
  return redset;
}

ddf_SetFamilyPtr ddf_Matrix2Adjacency(ddf_MatrixPtr M, ddf_ErrorType *error)  /* 093 */
{
  /* This is to generate the (facet) graph of a polyheron (H) V-represented by M using LPs.
     Since it does not use the representation conversion, it should work for a large
     scale problem.
  */
  ddf_rowrange i,m;
  ddf_colrange d;
  ddf_rowset redset;
  ddf_MatrixPtr Mcopy;
  ddf_SetFamilyPtr F=NULL;

  m=M->rowsize;
  d=M->colsize;
  if (m<=0 ||d<=0) {
    *error=ddf_EmptyRepresentation;
    goto _L999;
  }
  Mcopy=ddf_MatrixCopy(M);
  F=ddf_CreateSetFamily(m, m);
  for (i=1; i<=m; i++) {
    if (!set_member(i, M->linset)){
      set_addelem(Mcopy->linset, i);
      redset=ddf_RedundantRows(Mcopy, error);  /* redset should contain all nonadjacent ones */
      set_uni(redset, redset, Mcopy->linset); /* all linearity elements should be nonadjacent */
      set_compl(F->set[i-1], redset); /* set the adjacency list of vertex i */
      set_delelem(Mcopy->linset, i);
      set_free(redset);
      if (*error!=ddf_NoError) goto _L99;
    }
  }
_L99:
  ddf_FreeMatrix(Mcopy);
_L999:
  return F;
}

ddf_SetFamilyPtr ddf_Matrix2WeakAdjacency(ddf_MatrixPtr M, ddf_ErrorType *error)  /* 093a */
{
  /* This is to generate the weak-adjacency (facet) graph of a polyheron (H) V-represented by M using LPs.
     Since it does not use the representation conversion, it should work for a large
     scale problem.
  */
  ddf_rowrange i,m;
  ddf_colrange d;
  ddf_rowset redset;
  ddf_MatrixPtr Mcopy;
  ddf_SetFamilyPtr F=NULL;

  m=M->rowsize;
  d=M->colsize;
  if (m<=0 ||d<=0) {
    *error=ddf_EmptyRepresentation;
    goto _L999;
  }
  Mcopy=ddf_MatrixCopy(M);
  F=ddf_CreateSetFamily(m, m);
  for (i=1; i<=m; i++) {
    if (!set_member(i, M->linset)){
      set_addelem(Mcopy->linset, i);
      redset=ddf_SRedundantRows(Mcopy, error);  /* redset should contain all weakly nonadjacent ones */
      set_uni(redset, redset, Mcopy->linset); /* all linearity elements should be nonadjacent */
      set_compl(F->set[i-1], redset); /* set the adjacency list of vertex i */
      set_delelem(Mcopy->linset, i);
      set_free(redset);
      if (*error!=ddf_NoError) goto _L99;
    }
  }
_L99:
  ddf_FreeMatrix(Mcopy);
_L999:
  return F;
}


ddf_boolean ddf_ImplicitLinearity(ddf_MatrixPtr M, ddf_rowrange itest, ddf_Arow certificate, ddf_ErrorType *error)  
  /* 092 */
{
  /* Checks whether the row itest is implicit linearity for the representation.
     All linearity rows are not checked and considered non implicit linearity (ddf_FALSE). 
     This code works for both H- and V-representations.  A certificate is
     given in the case of ddf_FALSE, showing a feasible solution x satisfying the itest
     strict inequality for H-representation, a hyperplane RHS and normal (x_0, x) that
     separates the itest from the rest.  More explicitly, the LP to be setup is
     the same thing as redundancy case but with maximization:

     H-representation
       f* = maximize  
         b_itest     + A_itest x
       subject to
         b_itest + 1 + A_itest x     >= 0 (relaxed inequality. This is not necessary but kept for simplicity of the code)
         b_{I-itest} + A_{I-itest} x >= 0 (all inequalities except for itest)
         b_L         + A_L x = 0.  (linearity)

     V-representation (=separation problem)
       f* = maximize  
         b_itest x_0     + A_itest x
       subject to
         b_itest x_0     + A_itest x     >= -1 (again, this is not necessary but kept for simplicity.)
         b_{I-itest} x_0 + A_{I-itest} x >=  0 (all nonlinearity generators except for itest in one side)
         b_L x_0         + A_L x = 0.  (linearity generators)
    
    Here, the input matrix is considered as (b, A), i.e. b corresponds to the first column of input
    and the row indices of input is partitioned into I and L where L is the set of linearity.
    In both cases, the itest data is implicit linearity if and only if the optimal value f* is nonpositive.
    The certificate has dimension one more for V-representation case.
  */

  ddf_colrange j;
  ddf_LPPtr lp;
  ddf_LPSolutionPtr lps;
  ddf_ErrorType err=ddf_NoError;
  ddf_boolean answer=ddf_FALSE,localdebug=ddf_FALSE;

  *error=ddf_NoError;
  if (set_member(itest, M->linset)){
    if (localdebug) printf("The %ld th row is linearity and redundancy checking is skipped.\n",itest);
    goto _L99;
  }
  
  /* Create an LP data for redundancy checking */
  if (M->representation==ddf_Generator){
    lp=ddf_CreateLP_V_Redundancy(M, itest);
  } else {
    lp=ddf_CreateLP_H_Redundancy(M, itest);
  }

  lp->objective = ddf_LPmax;  /* the lp->objective is set by CreateLP* to LPmin */
  ddf_LPSolve(lp,ddf_DualSimplex,&err);
  if (err!=ddf_NoError){
    *error=err;
    goto _L999;
  } else {
    lps=ddf_CopyLPSolution(lp);

    for (j=0; j<lps->d; j++) {
      ddf_set(certificate[j], lps->sol[j]);
    }

    if (lps->LPS==ddf_Optimal && ddf_EqualToZero(lps->optvalue)){
      answer=ddf_TRUE;
      if (localdebug) fprintf(stderr,"==> %ld th data is an implicit linearity.\n",itest);
    } else {
      answer=ddf_FALSE;
      if (localdebug) fprintf(stderr,"==> %ld th data is not an implicit linearity.\n",itest);
    }
    ddf_FreeLPSolution(lps);
  }
  _L999:
  ddf_FreeLPData(lp);
_L99:
  return answer;
}


ddf_rowset ddf_ImplicitLinearityRows(ddf_MatrixPtr M, ddf_ErrorType *error)  /* 092 */
{
  ddf_rowrange i,m;
  ddf_colrange d;
  ddf_rowset eqset;
  ddf_Arow cvec; /* certificate */

  if (M->representation==ddf_Generator){
    d=(M->colsize)+1;
  } else {
    d=M->colsize;
  }

  ddf_InitializeArow(d,&cvec);
  m=M->rowsize;
  set_initialize(&eqset, m);
  for (i=m; i>=1; i--) {
    if (ddf_ImplicitLinearity(M, i, cvec, error)) {
      set_addelem(eqset, i);
    }
    if (*error!=ddf_NoError) goto _L99;
  }
_L99:
  ddf_FreeArow(d, cvec);
  return eqset;
}

ddf_rowrange ddf_RayShooting(ddf_MatrixPtr M, ddf_Arow p, ddf_Arow r)
{
/* 092, find the first inequality "hit" by a ray from an intpt.  */
  ddf_rowrange imin=-1,i,m;
  ddf_colrange j, d;
  ddf_Arow vecmin, vec;
  myfloat min,t1,t2,alpha, t1min;  
  ddf_boolean started=ddf_FALSE;
  ddf_boolean localdebug=ddf_FALSE;

  m=M->rowsize;
  d=M->colsize;
  if (!ddf_Equal(ddf_one, p[0])){
    fprintf(stderr, "Warning: RayShooting is called with a point with first coordinate not 1.\n");
    ddf_set(p[0],ddf_one);
  }
  if (!ddf_EqualToZero(r[0])){
    fprintf(stderr, "Warning: RayShooting is called with a direction with first coordinate not 0.\n");
    ddf_set(r[0],ddf_purezero);
  }

  ddf_init(alpha); ddf_init(min); ddf_init(t1); ddf_init(t2); ddf_init(t1min);
  ddf_InitializeArow(d,&vecmin);
  ddf_InitializeArow(d,&vec);

  for (i=1; i<=m; i++){
    ddf_InnerProduct(t1, d, M->matrix[i-1], p);
    if (ddf_Positive(t1)) {
      ddf_InnerProduct(t2, d, M->matrix[i-1], r);
      ddf_div(alpha, t2, t1);
      if (!started){
        imin=i;  ddf_set(min, alpha);
        ddf_set(t1min, t1);  /* store the denominator. */
        started=ddf_TRUE;
        if (localdebug) {
          fprintf(stderr," Level 1: imin = %ld and min = ", imin);
          ddf_WriteNumber(stderr, min);
          fprintf(stderr,"\n");
        }
      } else {
        if (ddf_Smaller(alpha, min)){
          imin=i;  ddf_set(min, alpha);
          ddf_set(t1min, t1);  /* store the denominator. */
          if (localdebug) {
            fprintf(stderr," Level 2: imin = %ld and min = ", imin);
            ddf_WriteNumber(stderr, min);
            fprintf(stderr,"\n");
          }
        } else {
          if (ddf_Equal(alpha, min)) { /* tie break */
            for (j=1; j<= d; j++){
              ddf_div(vecmin[j-1], M->matrix[imin-1][j-1], t1min);
              ddf_div(vec[j-1], M->matrix[i-1][j-1], t1);
            }
            if (ddf_LexSmaller(vec,vecmin, d)){
              imin=i;  ddf_set(min, alpha);
              ddf_set(t1min, t1);  /* store the denominator. */
              if (localdebug) {
                fprintf(stderr," Level 3: imin = %ld and min = ", imin);
                ddf_WriteNumber(stderr, min);
                fprintf(stderr,"\n");
              }
            }
          }
        }
      }       
    }
  }

  ddf_clear(alpha); ddf_clear(min); ddf_clear(t1); ddf_clear(t2); ddf_clear(t1min);
  ddf_FreeArow(d, vecmin);
  ddf_FreeArow(d, vec);
  return imin;
}

#ifdef ddf_GMPRATIONAL
void ddf_BasisStatusMaximize(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A,ddf_Bmatrix T,ddf_rowset equalityset,
    ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType LPS,
    myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
    ddf_rowrange re,ddf_colrange se,long *pivots, int *found, int *LPScorrect)
/*  This is just to check whether the status LPS of the basis given by 
nbindex with extra certificates se or re is correct.  It is done
by recomputing the basis inverse matrix T.  It does not solve the LP
when the status *LPS is undecided.  Thus the input is
m_size, d_size, A, equalityset, LPS, nbindex, re and se.
Other values will be recomputed from scratch.

The main purpose of the function is to verify the correctness
of the result of floating point computation with the GMP rational
arithmetics.
*/
{
  long pivots0,pivots1;
  ddf_rowrange i,is;
  ddf_colrange s,j;
  static ddf_rowindex bflag;
  static long mlast=0;
  static ddf_rowindex OrderVector;  /* the permutation vector to store a preordered row indeces */
  unsigned int rseed=1;
  myfloat val;
  ddf_colindex nbtemp;
  ddf_LPStatusType ddlps;
  ddf_boolean localdebug=ddf_FALSE;


  ddf_init(val);
  nbtemp=(long *) calloc(d_size+1,sizeof(long*));
  for (i=0; i<= 4; i++) pivots[i]=0;
  if (bflag==NULL || mlast!=m_size){
     if (mlast!=m_size && mlast>0) {
       free(bflag);   /* called previously with different m_size */
       free(OrderVector);
     }
     bflag=(long *) calloc(m_size+1,sizeof(long*));
     OrderVector=(long *)calloc(m_size+1,sizeof(long*)); 
     /* initialize only for the first time or when a larger space is needed */
      mlast=m_size;
  }

  /* Initializing control variables. */
  ddf_ComputeRowOrderVector2(m_size,d_size,A,OrderVector,ddf_MinIndex,rseed);

  pivots1=0;

  ddf_ResetTableau(m_size,d_size,T,nbtemp,bflag,objrow,rhscol);

  if (localdebug){
     printf("\nnbindex:");
     for (j=1; j<=d_size; j++) printf(" %ld", nbindex[j]);
     printf("\n");
     printf("re = %ld,   se=%ld\n", re, se);
  }
  
  is=nbindex[se];
  if (localdebug) printf("se=%ld,  is=%ld\n", se, is);
  
  ddf_FindLPBasis2(m_size,d_size,A,T,OrderVector, equalityset,nbindex,bflag,
      objrow,rhscol,&s,found,&pivots0);
      
  pivots[4]=pivots0;  /*GMP postopt pivots */

  if (!(*found)){
    if (localdebug) {
       printf("ddf_BasisStatusMaximize: a specified basis DOES NOT exist.\n");
    }

       goto _L99;
     /* No speficied LP basis is found. */
  }

  if (localdebug) {
    printf("ddf_BasisStatusMaximize: a specified basis exists.\n");
    if (m_size <=100 && d_size <=20)
    ddf_WriteTableau(stdout,m_size,d_size,A,T,nbindex,bflag);
  }

  /* Check whether a recomputed basis is of the type specified by LPS */
  *LPScorrect=ddf_TRUE;
  switch (LPS){
     case ddf_Optimal: 
       for (i=1; i<=m_size; i++) {
         if (i!=objrow && bflag[i]==-1) {  /* i is a basic variable */
            ddf_TableauEntry(&val,m_size,d_size,A,T,i,rhscol);
            if (ddf_Negative(val)) {
               if (localdebug) printf("RHS entry for %ld is negative\n", i);
               *LPScorrect=ddf_FALSE;
               break;
            }
          } else if (bflag[i] >0) { /* i is nonbasic variable */
            ddf_TableauEntry(&val,m_size,d_size,A,T,objrow,bflag[i]);
            if (ddf_Positive(val)) {
               if (localdebug) printf("Reduced cost entry for %ld is positive\n", i);
               *LPScorrect=ddf_FALSE;
               break;
            }
          }
       };
       break;
     case ddf_Inconsistent: 
       for (j=1; j<=d_size; j++){
          ddf_TableauEntry(&val,m_size,d_size,A,T,re,j);
          if (j==rhscol){
             if (ddf_Nonnegative(val)){
               if (localdebug) printf("RHS entry for %ld is nonnegative\n", re);
               *LPScorrect=ddf_FALSE;
               break;             
             }
           } else if (ddf_Positive(val)){
               if (localdebug) printf("the row entry for(%ld, %ld) is positive\n", re, j);
               *LPScorrect=ddf_FALSE;
               break;             
           }
       };
       break;
     case ddf_DualInconsistent:
        for (i=1; i<=m_size; i++){
          ddf_TableauEntry(&val,m_size,d_size,A,T,i,bflag[is]);
          if (i==objrow){
             if (ddf_Nonpositive(val)){
               if (localdebug) printf("Reduced cost entry for %ld is nonpositive\n", bflag[is]);
               *LPScorrect=ddf_FALSE;
               break;             
             }
           } else if (ddf_Negative(val)){
               if (localdebug) printf("the column entry for(%ld, %ld) is positive\n", i, bflag[is]);
               *LPScorrect=ddf_FALSE;
               break;             
           }
       };
       break;
;
     default: break;
  }

  ddlps=LPSf2LPS(LPS);

  ddf_SetSolutions(m_size,d_size,A,T,
   objrow,rhscol,ddlps,optvalue,sol,dsol,nbindex,re,se);

  
_L99:
  ddf_clear(val);
  free(nbtemp);
}

void ddf_BasisStatusMinimize(ddf_rowrange m_size,ddf_colrange d_size,
    ddf_Amatrix A,ddf_Bmatrix T,ddf_rowset equalityset,
    ddf_rowrange objrow,ddf_colrange rhscol,ddf_LPStatusType LPS,
    myfloat *optvalue,ddf_Arow sol,ddf_Arow dsol,ddf_colindex nbindex,
    ddf_rowrange re,ddf_colrange se,long *pivots, int *found, int *LPScorrect)
{
   ddf_colrange j;
   
   for (j=1; j<=d_size; j++) ddf_neg(A[objrow-1][j-1],A[objrow-1][j-1]);
   ddf_BasisStatusMaximize(m_size,d_size,A,T,equalityset, objrow,rhscol,
     LPS,optvalue,sol,dsol,nbindex,re,se,pivots,found,LPScorrect);
   ddf_neg(*optvalue,*optvalue);
   for (j=1; j<=d_size; j++){
     ddf_neg(dsol[j-1],dsol[j-1]);
     ddf_neg(A[objrow-1][j-1],A[objrow-1][j-1]);
   }
}
#endif

/* end of cddlp.c */

