(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    381923,      11729]*)
(*NotebookOutlinePosition[    382799,      11759]*)
(*  CellTagsIndexPosition[    382755,      11755]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Mathematica",
    FontSize->18,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" and cddmathlink\nUsing cddmathlink to compute complex convex \
hulls and drawing with ",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["Mathematica",
    FontSize->18,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\nby Komei Fukuda\nwith \na nice zonotope example\nof Russell \
Towle\n",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" (Revised December 17, 2002)",
    FontSize->14,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1]]
}], "Title",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Off[General::spell1];Off[General::spell]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\

(* Russell Towle's codes to create projections (zonotopes) of
hypercubes.  *)

cross[ {ax_, ay_, az_}, {bx_, by_, bz_} ] := (*cross product*)
   {ay bz - az by, az bx - ax bz, ax by - ay bx}

mag[v_]:= Sqrt[Plus@@(v^2)] (*magnitude of a vector*)

unit[v_]:= v/Sqrt[v.v] (*make unit vector*)

tolerance=0.000001;
collinear[ v1_, v2_ ] := (*test for collinearity*)
   Apply[And, Map[Abs[#]<tolerance&, cross[v1,v2]]]

setStar[vlist_] := (*discard collinear vectors*)
   Module[{selected={}},
    Scan[Function[v, If[v!={0,0,0} &&
                        Select[selected,
                               collinear[v,#]&]=={},
                        AppendTo[selected,v]] ],
         vlist];

    Print[Length[selected],\" zonal directions.\"];
    gStar=selected] (*gStar is global, list of non-collinear vectors*)

\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
(* Here I set to a directory where I store
the packages I need *)

SetDirectory[\"~/Math\"]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("/Users/fukuda/Math"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["cddml=Install[\"~/Math/cddmathlink\"]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(LinkObject["/Users/fukuda/Math/cddmathlink", 4, 4]\)], "Output"]
}, Open  ]],

Cell["Needs[\"ExtendGraphics`View3D`\"];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<<UnfoldPolytope.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<<Combinatorica5.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<<PolytopeSkeleton.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["<<IOPolyhedra.m", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
(*the vectors which determine an n-merous polar zonohedron*)
(*3<=n, 0<=pitch<=90 degrees*)

vectors[n_Integer,pitch_]:=
Table[N[{Cos[Degree pitch] Cos[2Pi i/n],
\tCos[Degree pitch] Sin[2Pi i/n],
\t-Sin[Degree pitch]},15],
\t{i,n}]      (* modified by KF, precision 15 added *)\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
(*the pitch at which a polar zonohedron is
an isometric shadow of an n-cube*)

N[1/Degree * ArcTan[(1/2)^(1/2)],15];
\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
(*Here, we obtain the vectors for an isometric projection of
a d-cube into cyclic symmetry*)

dim=8;
gen=Zonotope[vectors[dim, N[ 1/Degree * ArcTan[(1/2)^(1/2)],15 ] ] ];
genc = Chop[gen,10^(-12)];\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
extlist=Map[Prepend[#,1]&,genc];
{n,d}=Dimensions[extlist]\
\>", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({256, 4}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
{{inelist,equalities}, icd, iad,ecd,ead}=
\tAllFacetsWithAdjacency[n,d,Flatten[extlist]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["{m,d}=Dimensions[inelist]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({56, 4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["facets=Map[(Part[genc,#]) &, icd];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Length[facets]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(56\)], "Output"]
}, Open  ]],

Cell["facets1=OrderFacets[facets];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["viewpt={2, -2.4, 1}", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({2, \(-2.4`\), 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show[poly=Graphics3D[Polygon /@ facets1],Boxed->False,
ViewPoint->viewpt];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06327 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0913892 1.19942 0 1.19942 [
[ 0 0 0 0 ]
[ 1 1.06327 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.06327 L
0 1.06327 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.48195 .7694 m .60081 .69021 L .48246 .60675 L p .722 .54 .643 r
F P
0 g
s
.48246 .60675 m .36266 .68431 L .48195 .7694 L p .722 .54 .643 r
F P
0 g
s
.36266 .68431 m .48246 .60675 L .40429 .49697 L p .787 .68 .746 r
F P
0 g
s
.40429 .49697 m .48246 .60675 L .57453 .50225 L p .714 .663 .798 r
F P
0 g
s
.57453 .50225 m .48246 .60675 L .60081 .69021 L p .651 .564 .744 r
F P
0 g
s
.6956 .58662 m .60081 .69021 L .69944 .75291 L p .53 .386 .63 r
F P
0 g
s
.69944 .75291 m .60081 .69021 L .48195 .7694 L p .608 .341 .488 r
F P
0 g
s
.60081 .69021 m .6956 .58662 L .57453 .50225 L p .651 .564 .744 r
F P
0 g
s
.48195 .7694 m .36266 .68431 L .27572 .74326 L p .786 .48 .472 r
F P
0 g
s
.27572 .74326 m .36266 .68431 L .28045 .57486 L p .886 .679 .617 r
F P
0 g
s
.40429 .49697 m .28045 .57486 L .36266 .68431 L p .787 .68 .746 r
F P
0 g
s
.57453 .50225 m .49715 .38786 L .40429 .49697 L p .714 .663 .798 r
F P
0 g
s
.49715 .38786 m .57453 .50225 L .58814 .37701 L p .651 .641 .827 r
F P
0 g
s
.57453 .50225 m .6956 .58662 L .71358 .46357 L p .575 .572 .812 r
F P
0 g
s
.71358 .46357 m .58814 .37701 L .57453 .50225 L p .575 .572 .812 r
F P
0 g
s
.48195 .7694 m .57728 .83616 L .69944 .75291 L p .608 .341 .488 r
F P
0 g
s
.57728 .83616 m .48195 .7694 L .39994 .83264 L p .66 .291 .334 r
F P
0 g
s
.27572 .74326 m .39994 .83264 L .48195 .7694 L p .786 .48 .472 r
F P
0 g
s
.41197 .3708 m .40429 .49697 L .28045 .57486 L p .824 .791 .821 r
F P
0 g
s
.40429 .49697 m .49715 .38786 L .50832 .25532 L p .757 .735 .832 r
F P
0 g
s
.50832 .25532 m .41197 .3708 L .40429 .49697 L p .757 .735 .832 r
F P
0 g
s
.69944 .75291 m .7999 .64637 L .6956 .58662 L p .53 .386 .63 r
F P
0 g
s
.71358 .46357 m .6956 .58662 L .7999 .64637 L p .418 .424 .759 r
F P
0 g
s
.28045 .57486 m .18744 .63019 L .27572 .74326 L p .886 .679 .617 r
F P
0 g
s
.2838 .44962 m .28045 .57486 L .18744 .63019 L p .93 .872 .758 r
F P
0 g
s
.28045 .57486 m .2838 .44962 L .41197 .3708 L p .824 .791 .821 r
F P
0 g
s
.58814 .37701 m .50832 .25532 L .49715 .38786 L p .651 .641 .827 r
F P
0 g
s
.82942 .69855 m .72249 .81029 L .69944 .75291 L p .189 0 .281 r
F P
0 g
s
.69944 .75291 m .7999 .64637 L .82942 .69855 L p .189 0 .281 r
F P
0 g
s
.57728 .83616 m .69944 .75291 L .72249 .81029 L p .387 .024 .222 r
F P
0 g
s
.58814 .37701 m .71358 .46357 L .63645 .34332 L p .481 .567 .865 r
F P
0 g
s
.63645 .34332 m .50832 .25532 L .58814 .37701 L p .481 .567 .865 r
F P
0 g
s
.2838 .44962 m .41197 .3708 L .50832 .25532 L p .836 .889 .879 r
F P
0 g
s
.40556 .89605 m .27392 .80094 L .27572 .74326 L p .788 .322 .13 r
F P
0 g
s
.27572 .74326 m .39994 .83264 L .40556 .89605 L p .788 .322 .13 r
F P
0 g
s
.18744 .63019 m .27572 .74326 L .27392 .80094 L p .899 .485 .112 r
F P
0 g
s
.72249 .81029 m .59341 .89939 L .57728 .83616 L p .387 .024 .222 r
F P
0 g
s
.59341 .89939 m .57728 .83616 L .49642 .90523 L p .509 .097 .194 r
F P
0 g
s
.39994 .83264 m .49642 .90523 L .57728 .83616 L p .66 .291 .334 r
F P
0 g
s
.74496 .39656 m .82247 .52042 L .71358 .46357 L p .254 .443 .854 r
F P
0 g
s
.71358 .46357 m .63645 .34332 L .74496 .39656 L p .254 .443 .854 r
F P
0 g
s
.7999 .64637 m .82247 .52042 L .71358 .46357 L p .418 .424 .759 r
F P
0 g
s
.85454 .56682 m .82247 .52042 L .7999 .64637 L p 0 0 .386 r
F P
0 g
s
.7999 .64637 m .82942 .69855 L .85454 .56682 L p 0 0 .386 r
F P
0 g
s
.50832 .97599 m .40556 .89605 L .39994 .83264 L p .688 .228 .153 r
F P
0 g
s
.39994 .83264 m .49642 .90523 L .50832 .97599 L p .688 .228 .153 r
F P
0 g
s
.18744 .63019 m .18746 .50094 L .2838 .44962 L p .93 .872 .758 r
F P
0 g
s
.18746 .50094 m .2838 .44962 L .37908 .33395 L p .847 .994 .841 r
F P
0 g
s
.50832 .25532 m .37908 .33395 L .2838 .44962 L p .836 .889 .879 r
F P
0 g
s
.37908 .33395 m .50832 .25532 L .42248 .2974 L p .562 .927 .769 r
F P
0 g
s
.42248 .2974 m .50832 .25532 L .5206 .28457 L p .284 0 0 r
F P
0 g
s
.63645 .34332 m .50832 .25532 L .61069 .30449 L p .016 .415 .859 r
F P
0 g
s
.63001 .33818 m .61069 .30449 L .50832 .25532 L p .514 0 0 r
F P
0 g
s
.50832 .25532 m .5206 .28457 L .63001 .33818 L p .514 0 0 r
F P
0 g
s
.27392 .80094 m .1802 .68252 L .18744 .63019 L p .899 .485 .112 r
F P
0 g
s
.18746 .50094 m .18744 .63019 L .1802 .68252 L p .789 .66 .107 r
F P
0 g
s
.61069 .30449 m .74496 .39656 L .63645 .34332 L p .016 .415 .859 r
F P
0 g
s
.37908 .33395 m .28547 .38059 L .18746 .50094 L p .847 .994 .841 r
F P
0 g
s
.42248 .2974 m .28547 .38059 L .37908 .33395 L p .562 .927 .769 r
F P
0 g
s
.85454 .56682 m .82247 .52042 L .74496 .39656 L p 0 0 .411 r
F P
0 g
s
.59341 .89939 m .72249 .81029 L .64521 .88121 L p 0 0 0 r
F P
0 g
s
.82942 .69855 m .72249 .81029 L .64521 .88121 L p .595 .887 .587 r
F P
0 g
s
.49642 .90523 m .50832 .97599 L .59341 .89939 L p .509 .097 .194 r
F P
0 g
s
.50832 .97599 m .40556 .89605 L .27392 .80094 L p .511 0 0 r
F P
0 g
s
.27392 .80094 m .37017 .87615 L .50832 .97599 L p .511 0 0 r
F P
0 g
s
.37017 .87615 m .27392 .80094 L .1802 .68252 L p 0 .255 .765 r
F P
0 g
s
.64521 .88121 m .50832 .97599 L .59341 .89939 L p 0 0 0 r
F P
0 g
s
.74496 .39656 m .77299 .43637 L .85454 .56682 L p 0 0 .411 r
F P
0 g
s
.77299 .43637 m .74496 .39656 L .61069 .30449 L p .602 .038 0 r
F P
0 g
s
.61069 .30449 m .63001 .33818 L .77299 .43637 L p .602 .038 0 r
F P
0 g
s
.1802 .68252 m .17993 .54716 L .18746 .50094 L p .789 .66 .107 r
F P
0 g
s
.18746 .50094 m .17993 .54716 L .28414 .42002 L p 0 0 0 r
F P
0 g
s
.28414 .42002 m .28547 .38059 L .18746 .50094 L p 0 0 0 r
F P
0 g
s
.75597 .76526 m .82942 .69855 L .85454 .56682 L p .957 .948 .701 r
F P
0 g
s
.64521 .88121 m .75597 .76526 L .82942 .69855 L p .595 .887 .587 r
F P
0 g
s
.42991 .33086 m .42248 .2974 L .28547 .38059 L p .103 0 0 r
F P
0 g
s
.5206 .28457 m .42991 .33086 L .42248 .2974 L p .284 0 0 r
F P
0 g
s
.54098 .38958 m .63001 .33818 L .5206 .28457 L p .585 .12 .115 r
F P
0 g
s
.5206 .28457 m .42991 .33086 L .54098 .38958 L p .585 .12 .115 r
F P
0 g
s
.28547 .38059 m .28414 .42002 L .42991 .33086 L p .103 0 0 r
F P
0 g
s
.17993 .54716 m .1802 .68252 L .27494 .7545 L p .259 .329 .746 r
F P
0 g
s
.1802 .68252 m .27494 .7545 L .37017 .87615 L p 0 .255 .765 r
F P
0 g
s
.64521 .88121 m .75597 .76526 L .61795 .86017 L p .825 .976 .889 r
F P
0 g
s
.61795 .86017 m .50832 .97599 L .64521 .88121 L p .825 .976 .889 r
F P
0 g
s
.41635 .85632 m .27494 .7545 L .37017 .87615 L p .345 .53 .894 r
F P
0 g
s
.37017 .87615 m .50832 .97599 L .41635 .85632 L p .345 .53 .894 r
F P
0 g
s
.85454 .56682 m .7794 .62927 L .69113 .49353 L p .938 .703 .556 r
F P
0 g
s
.69113 .49353 m .77299 .43637 L .85454 .56682 L p .938 .703 .556 r
F P
0 g
s
.85454 .56682 m .7794 .62927 L .75597 .76526 L p .957 .948 .701 r
F P
0 g
s
.50832 .97599 m .61795 .86017 L .636 .72581 L p .766 .781 .865 r
F P
0 g
s
.636 .72581 m .52148 .84934 L .50832 .97599 L p .766 .781 .865 r
F P
0 g
s
.52148 .84934 m .50832 .97599 L .41635 .85632 L p .627 .657 .86 r
F P
0 g
s
.75597 .76526 m .7794 .62927 L .636 .72581 L p .849 .856 .847 r
F P
0 g
s
.636 .72581 m .61795 .86017 L .75597 .76526 L p .849 .856 .847 r
F P
0 g
s
.54098 .38958 m .63001 .33818 L .77299 .43637 L p .794 .422 .353 r
F P
0 g
s
.27494 .7545 m .27862 .61577 L .17993 .54716 L p .259 .329 .746 r
F P
0 g
s
.28414 .42002 m .17993 .54716 L .27862 .61577 L p .454 .307 .59 r
F P
0 g
s
.42602 .72085 m .27862 .61577 L .27494 .7545 L p .521 .562 .838 r
F P
0 g
s
.27494 .7545 m .41635 .85632 L .42602 .72085 L p .521 .562 .838 r
F P
0 g
s
.54098 .38958 m .42991 .33086 L .28414 .42002 L p .553 .238 .388 r
F P
0 g
s
.77299 .43637 m .69113 .49353 L .54098 .38958 L p .794 .422 .353 r
F P
0 g
s
.41635 .85632 m .42602 .72085 L .52148 .84934 L p .627 .657 .86 r
F P
0 g
s
.27862 .61577 m .39013 .48407 L .28414 .42002 L p .454 .307 .59 r
F P
0 g
s
.28414 .42002 m .39013 .48407 L .54098 .38958 L p .553 .238 .388 r
F P
0 g
s
.52148 .84934 m .636 .72581 L .54181 .59059 L p .713 .685 .821 r
F P
0 g
s
.54181 .59059 m .42602 .72085 L .52148 .84934 L p .713 .685 .821 r
F P
0 g
s
.69113 .49353 m .7794 .62927 L .636 .72581 L p .808 .709 .755 r
F P
0 g
s
.39013 .48407 m .27862 .61577 L .42602 .72085 L p .634 .56 .753 r
F P
0 g
s
.636 .72581 m .54181 .59059 L .69113 .49353 L p .808 .709 .755 r
F P
0 g
s
.54098 .38958 m .69113 .49353 L .54181 .59059 L p .726 .528 .623 r
F P
0 g
s
.54181 .59059 m .39013 .48407 L .54098 .38958 L p .726 .528 .623 r
F P
0 g
s
.42602 .72085 m .54181 .59059 L .39013 .48407 L p .634 .56 .753 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{269, 286},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004=00017R000`400?l00000o`00003oooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>
ooooo`00ooooool>ooooo`00ooooool>ooooo`00ooooool>ooooo`00Qoooool3o`0008?ooooo0025
ooooo`;o000000<0B000o`00002300000_l00021ooooo`00Poooool2o`0000@0B00000?o000008<0
002300000_l0001oooooo`00POooool2o`0000H0B00000?o000008<0002300000P230002o`0007go
oooo001oooooo`;o0000201800000ol00000P`0008<0000408<000;o0000Noooool007cooooo0ol0
000;04P00003o`0000230000P`0000D0P`000_l0001iooooo`00N_ooool2o`0000h0B00000?o0000
08<0002300001`230003o`0007Kooooo001hooooo`;o0000401800000ol00000P`0008<0000:08<0
00;o0000M?ooool007Kooooo0_l0000B04P000?o000030230002o`0007;ooooo001dooooo`;o0000
4P180002o`0000<0UAhM0_l0000<08<000;o0000L?ooool007;ooooo0_l0000B04P000;o00001`2E
7Qd2o`0000`0P`000_l0001^ooooo`00L?ooool2o`000180B0000_l0000;09DN7@;o000030230002
o`0006cooooo001_ooooo`03o`00000J003o00000100B0000_l0000?09DN7@;o000030230002o`00
06[ooooo001]ooooo`;o00000P0J00000ol00000B00004P0000<04P000;o00004`2E7Qd2o`0000`0
P`000_l0001Xooooo`00Joooool2o`0000D06P0000?o000004P0001800002@180002o`0001L0UAhM
0_l0000:08<00003o`00002J2@3o000006Oooooo001Zooooo`03o`00000J00006P0000D06P0000?o
000004P0001800001`180002o`0001/0UAhM0ol0000808<00004o`00002J2@3o0000o`0006Gooooo
001Xooooo`;o0000200J00000ol00000B00004P0000504P000;o0000802E7Qd2o`0000H0P`0000Go
000009X9002J2@00VPT0o`00001Tooooo`00Ioooool00ol000006P0001X0000801X00003o`000018
0000B00000<0B0000_l0000T09DN7@;o00001@2300001Ol00000VPT009X9002J2@3o000006?ooooo
001Uooooo`;o00002`0J00001?l00000B00004P000180002o`0002P0UAhM0_l0000408<00004o`00
002J2@00VPT009X900;o0000HOooool006?ooooo0_l0000>01X000?o0000;02E7Qd2o`000080P`00
00?o000009X9002J2@000`2J2@000ol0003oooooooooo`1Nooooo`00H_ooool00ol000006P0001X0
000=01X000?o0000;`2E7Qd2o`00000308<00?l00000VPT000@0VPT00_l0001Nooooo`00H?ooool2
o`0000l06P0000Co000008dlH`2=?6<0SCaS0_l0000_09DN7@;o00001`2J2@000ol0003ooooooooo
o`1Kooooo`00G_ooool2o`0000l06P000_l0000608dlH`;o0000;P2E7Qd3o`0000H0VPT00_l0001K
ooooo`00GOooool00ol000006P0001X0000=01X000;o00002P2=?6<00ol00000UAhM09DN7@0Y09DN
7@;o00000`3;K5X00ol00000VPT009X9000509X90003o`000?oooooooooo05Sooooo001Kooooo`;o
00003`0J00000ol00000SCaS08dlH`0;08dlH`;o0000:02E7Qd00ol00000bfaJ0<]/FP040<]/FP;o
00001P2J2@02o`0005Sooooo001Jooooo`03o`00000J00006P0000d06P000_l0000@08dlH`;o0000
902E7Qd2o`0000T0bfaJ00?o000009X9002J2@001@2J2@000ol0003oooooooooo`1Eooooo`00F?oo
ool2o`0000h06P000_l0000D08dlH`;o0000802E7Qd2o`0000`0bfaJ0_l0000609X90003o`000?oo
oooooooo05Cooooo001Fooooo`;o00003`0J00000ol00000SCaS08dlH`0F08dlH`;o00007@2E7Qd0
0ol00000bfaJ0<]/FP0>0<]/FP03o`00002J2@00VPT000@0VPT00_l0001Dooooo`00EOooool00ol0
00006P0001X0000=01X000;o00006`2=?6<00ol00000UAhM09DN7@0H09DN7@;o00004P3;K5X2o`00
00H0VPT000?o0000ooooooooool0DOooool005?ooooo0_l0000?01X00003o`00002=?6<0SCaS01`0
SCaS0_l0000F09DN7@;o00005P3;K5X00ol00000VPT009X9000409X900;o0000DOooool005;ooooo
00?o000001X0000J00003@0J0002o`000240SCaS0_l0000B09DN7@;o00006@3;K5X2o`0000H0VPT0
00?o0000ooooooooool0C_ooool0053ooooo0_l0000>01X000;o00009@2=?6<2o`0000l0UAhM00?o
00000<]/FP3;K5X06`3;K5X00ol00000VPT009X9000409X900;o0000C_ooool004kooooo0_l0000?
01X00003o`00002=?6<0SCaS02L0SCaS0_l0000;09DN7@;o00007`3;K5X2o`0000H0VPT000?o0000
ooooooooool0Boooool004gooooo00?o000001X0000J00003@0J0002o`0002`0SCaS00?o000009DN
7@2E7Qd01P2E7Qd2o`0002<0bfaJ00?o000009X9002J2@00102J2@02o`0004_ooooo001<ooooo`03
o`00000J00006P0000`06P000_l0000_08dlH`;o00001@2E7Qd00ol00000bfaJ0<]/FP0T0<]/FP;o
00001P2J2@000ol0003oooooooooo`18ooooo`00C?ooool00ol000006P0001X0000;01X00003o`00
002=?6<0SCaS0340SCaS0_l000000`2E7Qgo0000o`00000Y0<]/FP03o`00002J2@00VPT000@0VPT0
00?o0000ooooooooool0Aoooool004_ooooo0_l0000;01X000;o0000=@2=?6<3o`0002/0bfaJ0_l0
000509X900;o0000Aoooool004[ooooo00?o000000000?l000002P0J00000ol00000SCaS08dlH`0d
08dlH`05o`00002iQil0^HNO0;V7Wol00000;03;K5X00ol00000VPT009X9000409X90003o`000?oo
oooooooo04Cooooo0019ooooo`04o`00000000000000o`0000P06P000_l0000e08dlH`;o00001@2i
Qil2o`0002/0bfaJ0_l0000509X90003o`000?oooooooooo04?ooooo0018ooooo`05o`0000000000
000000000?l000001P0J0002o`0003D0SCaS0_l000090;V7W`03o`00003;K5X0bfaJ02X0bfaJ00?o
000009X9002J2@000P2J2@000ol0003oooooooooo`13ooooo`00B?ooool01Ol00000000000000000
003o000000D06P0000?o000008dlH`2=?6<0=02=?6<00ol00000^HNO0;V7W`0:0;V7W`;o0000:`3;
K5X2o`0000<0VPT000?o0000ooooooooool0@_ooool004Oooooo00?o00000000000000000P000000
1?l000006P0001X0000J0002o`0003D0SCaS0_l0000?0;V7W`03o`00003;K5X0bfaJ02X0bfaJ00Go
000009X9002J2@00VPT0o`000013ooooo`00A_ooool00ol0000000000000000300000004o`00000J
003o0000o`0003H0SCaS00?o00000;V7W`2iQil0402iQil2o`0002/0bfaJ0_l0000209X90003o`00
0?oooooooooo043ooooo0015ooooo`03o`0000000000000000@000000_l0000f08dlH`;o00005@2i
Qil00ol00000bfaJ0<]/FP0Z0<]/FP04o`00002J2@00VPT0o`00047ooooo0014ooooo`03o`000000
0000000000D000000_l0000d08dlH`;o0000602iQil00ol00000bfaJ0<]/FP0Z0<]/FP?o0000@Ooo
ool004?ooooo00?o00000000000000001P00000207A>U`03o`00002=?6<0SCaS0300SCaS00?o0000
0;V7W`2iQil06@2iQil2o`0002`0bfaJ0_l00010ooooo`00@oooool00ol000000000000000050000
0004o`00001dCYL0M4jG07A>U`;o0000;P2=?6<2o`0001h0^HNO00?o00000<]/FP3;K5X0:P3;K5X2
o`0003oooooo0012ooooo`03o`0000000000000000D0000000?o000007A>U`1dCYL0101dCYL2o`00
02/0SCaS00?o00000;V7W`2iQil07`2iQil2o`0002`0bfaJ00?o0000ooooooooool0??ooool0047o
oooo00?o00000000000000001@0000000ol00000M4jG07A>U`0707A>U`03o`00002=?6<0SCaS02H0
SCaS0_l0000T0;V7W`03o`00003;K5X0bfaJ02T0bfaJ0_l0000mooooo`00@?ooool00ol000000000
0000000500000003o`00001dCYL0M4jG00T0M4jG0_l0000T08dlH`;o00009`2iQil2o`0002P0bfaJ
00?o00000?2cS_l00000?Oooool003oooooo00?o00000000000000001@0000000ol00000M4jG07A>
U`0<07A>U`;o00008@2=?6<00ol00000^HNO0;V7W`0Y0;V7W`03o`00003;K5X0bfaJ02@0bfaJ00Go
00000?2cSP3`/hh0l;>>o`00000looooo`00?oooool00ol0000000000000000500000003o`00001d
CYL0M4jG00h0M4jG00?o000008dlH`2=?6<0702=?6<2o`0002d0^HNO0_l0000R0<]/FP;o00001@3`
/hh00ol0003oooooooooo`0iooooo`00?_ooool00ol0000000000000000500000003o`00001dCYL0
M4jG0100M4jG0_l0000K08dlH`03o`00002iQil0^HNO02l0^HNO00?o00000<]/FP3;K5X07P3;K5X0
0ol00000l;>>0?2cSP050?2cSP03o`000?oooooooooo03Wooooo000mooooo`03o`00000000000000
00D0000000?o000007A>U`1dCYL04`1dCYL2o`0001L0SCaS0_l0000c0;V7W`;o0000703;K5X2o`00
00T0l;>>00?o0000ooooooooool0>?ooool003cooooo00?o00000000000000001@0000000ol00000
M4jG07A>U`0F07A>U`03o`00002=?6<0SCaS0180SCaS0_l0000g0;V7W`03o`00003;K5X0bfaJ01P0
bfaJ00?o00000?2cSP3`/hh02@3`/hh00ol0003oooooooooo`0hooooo`00>oooool00ol000000000
0000000500000003o`00001dCYL0M4jG01P0M4jG0_l0000A08dlH`03o`00002iQil0^HNO03P0^HNO
0_l0000G0<]/FP03o`00003`/hh0l;>>00/0l;>>00?o0000ooooooooool0=oooool003_ooooo00?o
00000000000000001@0000000ol00000M4jG07A>U`0J07A>U`;o00003@2=?6<2o`0003d0^HNO00?o
00000<]/FP3;K5X04P3;K5X2o`0000l0l;>>00?o0000ooooooooool0=_ooool003[ooooo00?o0000
0000000000001@0000000ol00000M4jG07A>U`0M07A>U`03o`00002=?6<0SCaS00T0SCaS00?o0000
0;V7W`2iQil0?P2iQil00ol00000bfaJ0<]/FP0@0<]/FP03o`00003`/hh0l;>>00l0l;>>00?o0000
ooooooooool0=_ooool003Wooooo00?o00000000000000001@0000000ol00000M4jG07A>U`0O07A>
U`;o00001`2=?6<2o`000480^HNO0_l0000?0<]/FP03o`00003`/hh0l;>>0140l;>>00?o0000oooo
ooooool0=Oooool003Sooooo00?o00000000000000001@0000000ol00000M4jG07A>U`0R07A>U`;o
00000`2=?6<2o`0004H0^HNO00?o00000<]/FP3;K5X02P3;K5X2o`0001D0l;>>00?o0000oooooooo
ool0=?ooool003Oooooo00?o00000000000000001@0000000ol00000M4jG07A>U`0U07A>U`03o`00
002=?6?o000004T0^HNO0_l000090<]/FP03o`00003`/hh0l;>>01D0l;>>00?o0000ooooooooool0
=?ooool003Kooooo00?o00000000000000001@0000000ol00000M4jG07A>U`0W07A>U`;o0000B`2i
Qil00ol00000bfaJ0<]/FP040<]/FP;o00006@3`/hh00ol0003oooooooooo`0cooooo`00=_ooool0
0ol0000000000000000500000003o`00001dCYL0M4jG02L0M4jG0P2RSl000ol00000^HNO0;V7W`19
0;V7W`;o00000`3;K5X00ol00000l;>>0?2cSP0I0?2cSP03o`000?oooooooooo03?ooooo000eoooo
o`03o`0000000000000000D0000000?o000007A>U`1dCYL09`1dCYL01?l00000XXo00::?`02RSl02
o`0004/0^HNO00?o00000<]/F_l000007@3`/hh00ol0003oooooooooo`0booooo`00=?ooool00ol0
000000000000000500000003o`00001dCYL0M4jG02L0M4jG00?o00000::?`02RSl00102RSl000ol0
0000^HNO0;V7W`180;V7W`;o00007`3`/hh00ol0003oooooooooo`0aooooo`00<oooool00ol00000
00000000000500000003o`00001dCYL0M4jG02L0M4jG00?o00000::?`02RSl001P2RSl000ol00000
^HNO0;V7W`160;V7W`03o`00003>]L7o000001l0l;>>00?o0000ooooooooool0<Oooool003;ooooo
00?o00000000000000001@0000000ol00000M4jG07A>U`0W07A>U`03o`00002RSl00XXo000P0XXo0
0_l000140;V7W`;o00000`3>]L400ol00000l;>>0?2cSP0M0?2cSP03o`000?oooooooooo033ooooo
000booooo`03o`0000000000000000@0000000?o000007A>U`1dCYL09`1dCYL00ol00000XXo00::?
`00;0::?`003o`00002iQil0^HNO0400^HNO00?o00000<je`@3>]L40103>]L400ol00000l;>>0?2c
SP0M0?2cSP03o`000?oooooooooo02oooooo000booooo`03o`0000000000000000@0000000?o0000
07A>U`1dCYL09`1dCYL00ol00000XXo00::?`00<0::?`0;o0000?P2iQil2o`0000L0c[G100?o0000
0?2cSP3`/hh07@3`/hh00ol0003oooooooooo`0_ooooo`00<_ooool00ol000000000000000030000
0003o`00001dCYL0M4jG02L0M4jG00?o00000::?`02RSl003`2RSl000ol00000^HNO0;V7W`0j0;V7
W`03o`00003>]L40c[G100P0c[G100?o00000?2cSP3`/hh07@3`/hh00ol0003oooooooooo`0^oooo
o`00<Oooool00ol0000000000000000300000003o`00001dCYL0M4jG02L0M4jG00?o00000::?`02R
Sl004@2RSl000ol00000^HNO0;V7W`0g0;V7W`;o0000303>]L400ol00000l;>>0?2cSP0M0?2cSP03
o`000?oooooooooo02gooooo000aooooo`03o`000000000000000080000000?o000007A>U`1dCYL0
9`1dCYL00ol00000XXo00::?`00C0::?`0;o0000=@2iQil2o`0000h0c[G100?o00000?2cSP3`/hh0
7@3`/hh00ol0003oooooooooo`0]ooooo`00<Oooool01Ol00000000000000000003o000002T0M4jG
00?o00000::?`02RSl005P2RSl000ol00000^HNO0;V7W`0a0;V7W`03o`00003>]L40c[G100l0c[G1
00?o00000?2cSP3`/hh07@3`/hh00ol0003oooooooooo`0/ooooo`00<Oooool01Ol0000000000000
0000003o000002P0M4jG00?o00000::?`02RSl00602RSl02o`0002l0^HNO0_l0000B0<je`@03o`00
003`/hh0l;>>01d0l;>>00?o0000ooooooooool0;?ooool0037ooooo00Co000000000000003o0000
:@1dCYL00ol00000XXo00::?`00J0::?`003o`00002iQil0^HNO02/0^HNO00?o00000<je`@3>]L40
4`3>]L400ol00000l;>>0?2cSP0M0?2cSP03o`000?oooooooooo02_ooooo000aooooo`03o`000000
003o000002T0M4jG00?o00000::?`02RSl00702RSl02o`0002T0^HNO0_l0000G0<je`@03o`00003`
/hh0l;>>01d0l;>>00?o0000ooooooooool0:_ooool0033ooooo00?o000000000?l00000:@1dCYL0
0ol00000XXo00::?`00O0::?`003o`00002iQil0^HNO02D0^HNO00?o00000<je`@3>]L405`3>]L40
0ol00000l;>>0?2cSP0M0?2cSP03o`000?oooooooooo02[ooooo000`ooooo`;o0000:@1dCYL00ol0
0000XXo00::?`00Q0::?`003o`00002iQil0^HNO0280^HNO0_l0000K0<je`@03o`00003`/hh0l;>>
01d0l;>>00?o0000ooooooooool0:Oooool0033ooooo0_l0000X07A>U`03o`00002RSl00XXo002<0
XXo00_l0000Q0;V7W`03o`00003>]L40c[G101`0c[G100?o00000?2cSP3`/hh07@3`/hh00ol0003o
ooooooooo`0Xooooo`00<?ooool2049D_P03o`00001dCYL0M4jG02@0M4jG00?o00000::?`02RSl00
9P2RSl000ol00000^HNO0;V7W`0L0;V7W`;o00007`3>]L400ol00000l;>>0?2cSP0M0?2cSP03o`00
0?oooooooooo02Sooooo000`ooooo`04o`000012E;h0@UBno`0002D0M4jG00?o00000::?`02RSl00
9`2RSl02o`0001/0^HNO00?o00000<je`@3>]L40803>]L400ol00000l;>>0?2cSP0M0?2cSP03o`00
0?oooooooooo02Oooooo000`ooooo`04o`000012E;h0@UBn049D_P;o00008P1dCYL00ol00000XXo0
0::?`00Z0::?`003o`00002iQil0^HNO01H0^HNO0_l0000T0<je`@03o`00003`/hh0l;>>01`0l;>>
00?o0000ooooooooool09oooool0033ooooo00?o0000049D_P12E;h00`12E;h00ol00000M4jG07A>
U`0N07A>U`03o`00002RSl00XXo002`0XXo000?o00000;V7W`2iQil0502iQil00ol00000c[G10<je
`@0T0<je`@03o`00003`/hh0l;>>01d0l;>>00?o0000ooooooooool09_ooool0033ooooo00?o0000
049D_P12E;h01012E;h2o`0001d0M4jG00?o00000::?`02RSl00;P2RSl02o`000180^HNO0_l0000X
0<je`@03o`00003`/hh0l;>>01`0l;>>0_l0000Wooooo`00<?ooool00ol00000@UBn049D_P06049D
_P03o`00001dCYL0M4jG01T0M4jG00?o00000::?`02RSl00<@2RSl000ol00000^HNO0;V7W`0=0;V7
W`;o0000:P3>]L400ol00000l;>>0?2cSP0K0?2cSP03o`00003dl[?o000002Oooooo000`ooooo`03
o`000012E;h0@UBn00L0@UBn00?o000007A>U`1dCYL05`1dCYL00ol00000XXo00::?`00c0::?`0;o
0000302iQil00ol00000c[G10<je`@0[0<je`@03o`00003`/hh0l;>>01T0l;>>00Co00000?Cb/`3d
l[?o00009oooool0033ooooo00?o0000049D_P12E;h02012E;h2o`0001L0M4jG00?o00000::?`02R
Sl00=@2RSl000ol00000^HNO0;V7W`070;V7W`;o0000;`3>]L400ol00000l;>>0?2cSP0G0?2cSP05
o`00003dl[<0m?:c0?Cb/ol000009oooool0033ooooo00?o0000049D_P12E;h02P12E;h00ol00000
M4jG07A>U`0C07A>U`03o`00002RSl00XXo003L0XXo000?o00000;V7W`2iQil01@2iQil00ol00000
c[G10<je`@0_0<je`@03o`00003`/hh0l;>>01D0l;>>0_l000030?Cb/`03o`000?oooooooooo02Ko
oooo000`ooooo`03o`000012E;h0@UBn00/0@UBn00?o000007A>U`1dCYL04@1dCYL00ol00000XXo0
0::?`00i0::?`0;o00000`2iQil2o`0003<0c[G100?o00000?2cSP3`/hh04`3`/hh00ol00000m?:c
0?Cb/`030?Cb/`03o`000?oooooooooo02Kooooo000`ooooo`03o`000012E;h0@UBn00`0@UBn0_l0
000@07A>U`03o`00002RSl00XXo003`0XXo000?o00000;V7Wol00000=P3>]L400ol00000l;>>0?2c
SP0A0?2cSP03o`00003dl[<0m?:c00@0m?:c00?o0000ooooooooool09_ooool0033ooooo00?o0000
049D_P12E;h03P12E;h00ol00000M4jG07A>U`0<07A>U`03o`00002RSl00XXo003h0XXo000?o0000
0<je`@3>]L40=@3>]L400ol00000l;>>0?2cSP0@0?2cSP03o`00003dl[<0m?:c00D0m?:c00?o0000
ooooooooool09_ooool0033ooooo00?o0000049D_P12E;h03`12E;h00ol00000M4jG07A>U`0:07A>
U`03o`00002RSl00XXo003l0XXo000?o00000<je`@3>]L40=P3>]L400ol00000l;>>0?2cSP0=0?2c
SP;o0000203dl[<00ol0003oooooooooo`0Vooooo`00<?ooool00ol00000@UBn049D_P0@049D_P;o
00002P1dCYL00ol00000XXo00::?`00n0::?`003o`00002f[m;o000003P0c[G100?o00000?2cSP3`
/hh02`3`/hh00ol00000m?:c0?Cb/`070?Cb/`03o`000?oooooooooo02Oooooo000`ooooo`03o`00
0012E;h0@UBn0180@UBn00?o000007A>U`1dCYL01P1dCYL00ol00000XXo00::?`00n0::?`005o`00
002f[m80]ZoB0;J_d_l00000=`3>]L400ol00000l;>>0?2cSP0:0?2cSP03o`00003dl[<0m?:c00P0
m?:c00?o0000ooooooooool09oooool0033ooooo00?o0000049D_P12E;h04`12E;h2o`0000D0M4jG
00?o00000::?`02RSl00?P2RSl000ol00000]ZoB0;J_dP020;J_dP03o`00003>]L40c[G103H0c[G1
00?o00000?2cSP3`/hh0203`/hh00ol00000m?:c0?Cb/`090?Cb/`03o`000?oooooooooo02Oooooo
000`ooooo`03o`000012E;h0@UBn01D0@UBn00Go000007A>U`1dCYL0M4jGo`0000100::?`003o`00
002f[m80]ZoB00@0]ZoB00?o00000<je`@3>]L40=@3>]L400ol00000l;>>0?2cSP070?2cSP03o`00
003dl[<0m?:c00X0m?:c00?o0000ooooooooool09oooool0033ooooo00?o0000049D_P12E;h05P12
E;h00ol00000M4jGo`0000100::?`003o`00002f[m80]ZoB00H0]ZoB00?o00000<je`@3>]L40=@3>
]L400ol00000l;>>0?2cSP040?2cSP;o00003@3dl[<00ol0003oooooooooo`0Wooooo`00<?ooool0
0ol00000@UBn049D_P0G049D_P;o0000?`2RSl000ol00000]ZoB0;J_dP080;J_dP03o`00003>]L40
c[G103D0c[G100?o00000?2cSP3`/hh00P3`/hh00ol00000m?:c0?Cb/`0<0?Cb/`03o`000?oooooo
oooo02Sooooo000`ooooo`03o`000012E;h0@UBn01L0@UBn00?o000008F?e_l00000?@2RSl000ol0
0000]ZoB0;J_dP090;J_dP03o`00003>]L40c[G103D0c[G100Go00000?2cSP3`/hh0l;>>o`00000?
0?Cb/`03o`000?oooooooooo02Sooooo000`ooooo`03o`000012E;h0@UBn01L0@UBn00?o000008F?
eP25SmH00_l0000j0::?`003o`00002f[m80]ZoB00/0]ZoB00?o00000<je`@3>]L40=@3>]L400ol0
0000l;>>o`00000@0?Cb/`03o`000?oooooooooo02Sooooo000`ooooo`03o`000012E;h0@UBn01L0
@UBn00?o000008F?eP25SmH00P25SmH00ol00000XXo00::?`00g0::?`003o`00002f[m80]ZoB00`0
]ZoB00?o00000<je`@3>]L40=03>]L42o`000140m?:c00?o0000ooooooooool0:?ooool0033ooooo
00?o0000049D_P12E;h05`12E;h00ol00000QHoF08F?eP0308F?eP03o`00002RSl00XXo003D0XXo0
00?o00000;J_dP2f[m803@2f[m800ol00000c[G10<je`@0c0<je`@03o`00003IfmSo00000140m?:c
00?o0000ooooooooool0:?ooool0033ooooo00?o0000049D_P12E;h05`12E;h00ol00000QHoF08F?
eP0408F?eP;o0000=02RSl000ol00000]ZoB0;J_dP0?0;J_dP03o`00003>]L40c[G10300c[G10_l0
00020=WKf003o`00003dl[<0m?:c00h0m?:c00?o0000ooooooooool0:Oooool0033ooooo00?o0000
049D_P12E;h05`12E;h00ol00000QHoF08F?eP0608F?eP03o`00002RSl00XXo00300XXo000?o0000
0;J_dP2f[m804@2f[m800ol00000c[G10<je`@0^0<je`@03o`00003IfmP0fM_H0080fM_H00?o0000
0?Cb/`3dl[<03P3dl[<00ol0003oooooooooo`0Yooooo`00<?ooool00ol00000@UBn049D_P0G049D
_P03o`000025SmH0QHoF00L0QHoF0_l0000_0::?`003o`00002f[m80]ZoB0180]ZoB00?o00000<je
`@3>]L40;03>]L42o`0000@0fM_H00?o00000?Cb/`3dl[<03`3dl[<00ol0003oooooooooo`0Yoooo
o`00<?ooool00ol00000@UBn049D_P0G049D_P03o`000025SmH0QHoF00T0QHoF00?o00000::?`02R
Sl00:`2RSl000ol00000]ZoB0;J_dP0D0;J_dP03o`00003>]L40c[G102X0c[G100?o00000=WKf03I
fmP0103IfmP00ol00000m?:c0?Cb/`0?0?Cb/`03o`000?oooooooooo02Wooooo000`ooooo`03o`00
0012E;h0@UBn01L0@UBn00?o000008F?eP25SmH02P25SmH2o`0002X0XXo000?o00000;J_dP2f[m80
5P2f[m800ol00000c[G10<je`@0W0<je`@;o00001`3IfmP00ol00000m?:c0?Cb/`0?0?Cb/`03o`00
0?oooooooooo02Wooooo000`ooooo`03o`000012E;h0@UBn01L0@UBn00?o000008F?eP25SmH03025
SmH00ol00000XXo00::?`00V0::?`003o`00002f[m80]ZoB01L0]ZoB00?o00000<je`@3>]L409P3>
]L400ol00000fM_H0=WKf0070=WKf003o`00003dl[<0m?:c00h0m?:c00?o0000ooooooooool0:_oo
ool0033ooooo00?o0000049D_P12E;h05`12E;h00ol00000QHoF08F?eP0=08F?eP03o`00002RSl00
XXo002@0XXo000?o00000;J_dP2f[m806@2f[m800ol00000c[G10<je`@0T0<je`@03o`00003IfmP0
fM_H00P0fM_H00?o00000?Cb/`3dl[<03P3dl[<00ol0003oooooooooo`0Zooooo`00<?ooool00ol0
0000@UBn049D_P0G049D_P03o`000025SmH0QHoF00h0QHoF0_l0000T0::?`003o`00002f[m80]ZoB
01X0]ZoB00?o00000<je`@3>]L408@3>]L42o`0000/0fM_H00?o00000?Cb/`3dl[<03P3dl[<00ol0
003oooooooooo`0Zooooo`00<?ooool00ol00000@UBn049D_P0G049D_P03o`000025SmH0QHoF0100
QHoF00?o00000::?`02RSl00802RSl000ol00000]ZoB0;J_dP0L0;J_dP03o`00003>]L40c[G101l0
c[G100?o00000=WKf03IfmP02P3IfmP00ol00000m?:c0?Cb/`0?0?Cb/`03o`000?oooooooooo02[o
oooo000`ooooo`03o`000012E;h0@UBn01L0@UBn00?o000008F?eP25SmH04@25SmH2o`0001l0XXo0
00?o00000;J_dP2f[m807@2f[m800ol00000c[G10<je`@0M0<je`@;o00003@3IfmP00ol00000m?:c
0?Cb/`0?0?Cb/`03o`000?oooooooooo02[ooooo000`ooooo`03o`000012E;h0@UBn01L0@UBn00?o
000008F?eP25SmH04`25SmH00ol00000XXo00::?`00K0::?`003o`00002f[m80]ZoB01l0]ZoB00?o
00000<je`@3>]L406`3>]L400ol00000fM_H0=WKf00=0=WKf003o`00003dl[<0m?:c00h0m?:c00?o
0000ooooooooool0:oooool0033ooooo00?o0000049D_P12E;h05`12E;h00ol00000QHoF08F?eP0D
08F?eP;o00006P2RSl000ol00000]ZoB0;J_dP0Q0;J_dP03o`00003>]L40c[G101P0c[G10_l0000@
0=WKf003o`00003dl[<0m?:c00h0m?:c00?o0000ooooooooool0:oooool0033ooooo0_l0000H049D
_P03o`000025SmH0QHoF01H0QHoF00?o00000::?`02RSl005P2RSl000ol00000]ZoB0;J_dP0R0;J_
dP03o`00003>]L40c[G101L0c[G100?o00000=WKf03IfmP0403IfmP00ol00000m?:c0?Cb/`0>0?Cb
/`03o`000?oooooooooo02_ooooo000`ooooo`80047300?o0000049D_P12E;h05@12E;h00ol00000
QHoF08F?eP0G08F?eP03o`00002RSl00XXo001@0XXo000?o00000;J_dP2f[m80902f[m800ol00000
c[G10<je`@0D0<je`@;o00004`3IfmP00ol00000m?:c0?Cb/`0>0?Cb/`03o`000?oooooooooo02_o
oooo000aooooo`80047300?o0000049D_P12E;h04`12E;h00ol00000QHoF08F?eP0I08F?eP;o0000
4`2RSl000ol00000]ZoB0;J_dP0V0;J_dP03o`00003>]L40c[G10180c[G100?o00000=WKf03IfmP0
4P3IfmP00ol00000m?:c0?Cb/`0?0?Cb/`03o`000?oooooooooo02_ooooo000booooo`80047300?o
0000049D_P12E;h04P12E;h00ol00000QHoF08F?eP0K08F?eP03o`00002RSl00XXo00100XXo000?o
00000;J_dP2f[m809P2f[m800ol00000c[G10<je`@0@0<je`@;o00005@3IfmP00ol00000m?:c0?Cb
/`0>0?Cb/`03o`000?oooooooooo02cooooo000cooooo`8004730_l0000B049D_P03o`000025SmH0
QHoF01`0QHoF0_l0000?0::?`003o`00002f[m80]ZoB02P0]ZoB00?o00000<je`@3>]L403P3>]L40
0ol00000fM_H0=WKf00E0=WKf003o`00003dl[<0m?:c00h0m?:c00?o0000ooooooooool0;?ooool0
03Cooooo0`00@L<00ol00000@UBn049D_P0?049D_P03o`000025SmH0QHoF01h0QHoF00?o00000::?
`02RSl002`2RSl000ol00000]ZoB0;J_dP0Z0;J_dP03o`00003>]L40c[G100/0c[G10_l0000H0=WK
f003o`00003dl[<0m?:c00d0m?:c0_l0000^ooooo`00=?ooool01Ol0000004730011``00@L?o0000
0100@UBn00?o000008F?eP25SmH07`25SmH2o`0000X0XXo000?o00000;J_dP2f[m80:`2f[m800ol0
0000c[G10<je`@0:0<je`@03o`00003IfmP0fM_H01P0fM_H00?o00000?Cb/`3dl[<0303dl[<00ol0
0000V>>Fo`00000^ooooo`00=Oooool01Ol0000004730011``00@L?o000000l0@UBn00?o000008F?
eP25SmH08@25SmH00ol00000XXo00::?`0060::?`003o`00002f[m80]ZoB02d0]ZoB00?o00000<je
`@3>]L40203>]L400ol00000fM_H0=WKf00I0=WKf003o`00003dl[<0m?:c00/0m?:c00?o000009SS
U_l00000;oooool003Kooooo00Co00000011``00@L<004730_l0000=049D_P03o`000025SmH0QHoF
0280QHoF00?o00000::?`02RSl00102RSl000ol00000]ZoB0;J_dP0_0;J_dP03o`00003>]L40c[G1
00D0c[G10_l0000L0=WKf003o`00003dl[<0m?:c00X0m?:c00?o000009SSU_l00000<?ooool003Oo
oooo00?o00000011``00@L<00P00@L<00ol00000@UBn049D_P0:049D_P03o`000025SmH0QHoF02<0
QHoF0_l000030::?`003o`00002f[m80]ZoB0340]ZoB00?o00000<je`@3>]L400`3>]L400ol00000
fM_H0=WKf00K0=WKf003o`00003dl[<0m?:c00X0m?:c00?o000009SSU_l00000<Oooool003Oooooo
00?o00000011``00@L<00`00@L<00ol00000@UBn049D_P09049D_P03o`000025SmH0QHoF02D0QHoF
00?o00000::?`?l00000=02f[m801?l00000c[G10<je`@3>]L42o`0001h0fM_H00?o00000?Cb/`3d
l[<02@3dl[<00ol00000V>>Fo`00000booooo`00>?ooool00ol0000004730011``030011``03o`00
0012E;h0@UBn00P0@UBn00?o000008F?eP25SmH09P25SmH00ol00000]ZoB0;J_dP0d0;J_dP03o`00
003>]L7o00000200fM_H00?o00000?Cb/`3dl[<0203dl[<00ol00000V>>Fo`00000cooooo`00>Ooo
ool00ol0000004730011``030011``;o00002012E;h00ol00000QHoF08F?eP0V08F?eP03o`00002f
[m80]ZoB03D0]ZoB00?o00000=WKf03IfmP07`3IfmP00ol00000m?:c0?Cb/`070?Cb/`03o`00002H
hiKo000003Cooooo000jooooo`03o`000000@L<0047300@0047300?o0000049D_P12E;h01@12E;h0
0ol00000QHoF08F?eP0V08F?eP;o0000=P2f[m800ol00000fM_H0=WKf00O0=WKf003o`00003dl[<0
m?:c00H0m?:c00?o000009SSU_l00000=Oooool003_ooooo00?o00000011``00@L<01000@L<00ol0
0000@UBn049D_P04049D_P03o`000025SmH0QHoF02H0QHoF00?o00000:2Xg?l00000=02f[m82o`00
0240fM_H00?o00000?Cb/`3dl[<0103dl[<2o`00000309SSU_l0003ooooo03Gooooo000kooooo`03
o`000000@L<0047300D0047300?o0000049D_P12E;h00`12E;h00ol00000QHoF08F?eP0V08F?eP04
o`00002PZ=`0X:SLo`000380]ZoB00?o00000<C7gOl00000803IfmP00ol00000m?:c0?Cb/`040?Cb
/`04o`00002HhiH0V>>Fo`0003Oooooo000looooo`03o`000000@L<0047300D004730_l00003049D
_P03o`000025SmH0QHoF02H0QHoF00Co00000:2Xg02PZ=co0000<@2f[m801?l00000a<OM0<C7gOl0
000P0=WKf003o`00003dl[<0m?:c00<0m?:c00Co000009SSUP2HhiKo0000>?ooool003gooooo00?o
00000011``00@L<01P00@L<01?l00000@UBn049D__l0000X08F?eP05o`00002PZ=`0X:SL0:2Xg?l0
0000;`2f[m801?l00000a<OM0<C7gOl0000Q0=WKf003o`00003dl[<0m?:c0080m?:c00Co000009SS
UP2HhiKo0000>Oooool003kooooo00?o00000011``00@L<01P00@L<00ol00000@UBno`00000W08F?
eP03o`00002PZ=`0X:SL00<0X:SL00?o00000;J_dP2f[m80:`2f[m801Ol00000a<OM0<C7g@34amgo
00000240fM_H00Go00000?Cb/`3dl[<0m?:co`00000209SSUP03o`000?oooooooooo03Sooooo000n
ooooo`03o`000000@L<0047300L0047300<0@UBno`000025SmH09P25SmH00ol00000X:SL0:2Xg004
0:2Xg003o`00002f[m80]ZoB02T0]ZoB00?o00000<C7g@34amd00P34amd00ol00000fM_H0=WKf00O
0=WKf004o`00003dl[<0m?:co`000080V>>F00?o0000ooooooooool0>Oooool003oooooo00?o0000
0011``00@L<01`00@L<2o`0002H0QHoF00?o00000:2Xg02PZ=`0102PZ=`00ol00000]ZoB0;J_dP0X
0;J_dP03o`000034amd0a<OM00<0a<OM00?o00000=WKf03IfmP07`3IfmP00ol00000m?:co`000002
09SSUP03o`000?oooooooooo03[ooooo0010ooooo`03o`000000@L<0047300H0047300?o000005R7
i?l000009@25SmH00ol00000X:SL0:2Xg0050:2Xg003o`00002f[m80]ZoB02H0]ZoB00?o00000<C7
g@34amd01034amd00ol00000fM_H0=WKf00N0=WKf003o`00003dl[?o00000080V>>F00?o0000oooo
ooooool0>oooool0047ooooo00?o00000011``00@L<01P00@L<01?l00000F8OTo`000?l0000S08F?
eP03o`00002PZ=`0X:SL00H0X:SL00?o00000;J_dP2f[m80902f[m800ol00000a<OM0<C7g@050<C7
g@03o`00003IfmP0fM_H01h0fM_H0_l0000209SSUP03o`000?oooooooooo03cooooo0012ooooo`03
o`000000@L<0047300H0047300Co000005R7i01HQnCo00008P25SmH00ol00000X:SL0:2Xg0060:2X
g003o`00002f[m80]ZoB02<0]ZoB00?o00000<C7g@34amd01P34amd00ol00000fM_H0=WKf00M0=WK
f0;o00000P2HhiH00ol0003oooooooooo`0mooooo`00@_ooool00ol0000004730011``070011``04
o`00001HQn@0F8OTo`000240QHoF00?o00000:2Xg02PZ=`01`2PZ=`00ol00000]ZoB0;J_dP0Q0;J_
dP03o`000034amd0a<OM00H0a<OM00?o00000=WKf03IfmP07@3IfmP01Ol00000doWSo`00002HhiKo
0000043ooooo0013ooooo`03o`000000@L<0047300L0047300?o000005R7i01HQn@00_l0000O08F?
eP03o`00002PZ=`0X:SL00P0X:SL00?o00000;J_dP2f[m807`2f[m800ol00000a<OM0<C7g@070<C7
g@03o`00003IfmP0fM_H01/0fM_H0_l00000103CnN?o000009SSU_l00011ooooo`00A?ooool00ol0
000004730011``060011``03o`00001HQn@0F8OT0080F8OT00?o000008F?eP25SmH07025SmH00ol0
0000X:SL0:2Xg0090:2Xg003o`00002f[m80]ZoB01d0]ZoB00?o00000<C7g@34amd02034amd00ol0
0000fM_H0=WKf00J0=WKf006o`00003CnN<0doWSo`00002HhiKo0000@_ooool004Gooooo00?o0000
0011``00@L<01P00@L<00ol00000F8OT05R7i00205R7i0;o00007025SmH00ol00000X:SL0:2Xg009
0:2Xg003o`00002f[m80]ZoB01`0]ZoB00?o00000<C7g@34amd02@34amd00ol00000fM_H0=WKf00H
0=WKf0;o00000P3CnN<00ol00000V>>Fo`000013ooooo`00AOooool00ol0000004730011``070011
``03o`00001HQn@0F8OT00<0F8OT00?o000008F?eP25SmH06@25SmH00ol00000X:SL0:2Xg00:0:2X
g003o`00002f[m80]ZoB01X0]ZoB00?o00000<C7g@34amd02P34amd00ol00000fM_H0=WKf00G0=WK
f007o`00003CnN<0doWS0=?ihol00000V>>Fo`000014ooooo`00A_ooool00ol0000004730011``07
0011``03o`00001HQn@0F8OT00<0F8OT00?o000008F?eP25SmH06025SmH00ol00000X:SL0:2Xg00;
0:2Xg003o`00002f[m80]ZoB01P0]ZoB00?o00000<C7g@34amd02`34amd00ol00000fM_H0=WKf00E
0=WKf0;o00000`3CnN<00ol00000V>>Fo`000015ooooo`00Aoooool00ol0000004730011``070011
``03o`00001HQn@0F8OT00<0F8OT0_l0000G08F?eP03o`00002PZ=`0X:SL00d0X:SL00?o00000;J_
dP2f[m805`2f[m800ol00000a<OM0<C7g@0;0<C7g@03o`00003IfmP0fM_H01@0fM_H00?o00000=?i
h`3CnN<00P3CnN<00ol00000V>>Fo`000016ooooo`00B?ooool00ol0000004730011``070011``03
o`00001HQn@0F8OT00@0F8OT00?o000008F?eP25SmH05025SmH00ol00000X:SL0:2Xg00=0:2Xg003
o`00002f[m80]ZoB01H0]ZoB00?o00000<C7g@34amd02`34amd00ol00000fM_H0=WKf00C0=WKf0;o
0000103CnN<00ol00000V>>Fo`000017ooooo`00BOooool2o`0000L0047300?o000005R7i01HQn@0
1@1HQn@2o`0001@0QHoF00?o00000:2Xg02PZ=`03P2PZ=`00ol00000]ZoB0;J_dP0D0;J_dP03o`00
0034amd0a<OM00`0a<OM00?o00000=WKf03IfmP04P3IfmP00ol00000doWS0=?ih`030=?ih`03o`00
002HhiKo000004Sooooo001;ooooo`03o`000000@L<0047300D0047300?o000005R7i01HQn@01P1H
Qn@00ol00000QHoF08F?eP0A08F?eP03o`00002PZ=`0X:SL00l0X:SL00?o00000;J_dP2f[m804P2f
[m800ol00000a<OM0<C7g@0=0<C7g@03o`00003IfmP0fM_H0100fM_H0_l000050=?ih`03o`00002H
hiKo000004Wooooo001<ooooo`03o`000000@L<0047300D0047300?o000005R7i01HQn@01P1HQn@0
0ol00000QHoF08F?eP0@08F?eP03o`00002PZ=`0X:SL0100X:SL00?o00000;J_dP2f[m80402f[m80
0ol00000a<OM0<C7g@0>0<C7g@03o`00003IfmP0fM_H00l0fM_H00?o00000=?ih`3CnN<0103CnN<0
0ol00000V>>Fo`00001:ooooo`00COooool2o`0000H0047300?o000005R7i01HQn@01P1HQn@2o`00
0100QHoF00?o00000:2Xg02PZ=`0402PZ=`00ol00000]ZoB0;J_dP0?0;J_dP03o`000034amd0a<OM
00l0a<OM00?o00000=WKf03IfmP03@3IfmP2o`0000H0doWS0ol0001;ooooo`00Coooool00ol00000
04730011``040011``03o`00001HQn@0F8OT00L0F8OT00?o000008F?eP25SmH03@25SmH00ol00000
X:SL0:2Xg00A0:2Xg003o`00002f[m80]ZoB00d0]ZoB00?o00000<C7g@34amd04034amd00ol00000
fM_H0=WKf00<0=WKf003o`00003CnN<0doWS00D0doWS0_l0001=ooooo`00D?ooool00ol000000473
0011``030011``03o`00001HQn@0F8OT00P0F8OT0_l0000=08F?eP03o`00002PZ=`0X:SL0180X:SL
00?o00000;J_dP2f[m802`2f[m800ol00000a<OM0<C7g@0A0<C7g@03o`00003IfmP0fM_H00/0fM_H
00?o00000=?ih`3CnN<01@3CnN<2o`0004kooooo001Aooooo`03o`000000@L<0047300<0047300?o
000005R7i01HQn@02@1HQn@00ol00000QHoF08F?eP0:08F?eP03o`00002PZ=`0X:SL0180X:SL00?o
00000;J_dP2f[m802P2f[m800ol00000a<OM0<C7g@0A0<C7g@03o`00003IfmP0fM_H00X0fM_H0_l0
00070=?ih`;o0000Coooool005;ooooo0_l000040011``03o`00001HQn@0F8OT00T0F8OT00?o0000
08F?eP25SmH02@25SmH00ol00000X:SL0:2Xg00C0:2Xg003o`00002f[m80]ZoB00P0]ZoB00?o0000
0<C7g@34amd04P34amd00ol00000fM_H0=WKf0090=WKf003o`00003CnN<0doWS00H0doWS0_l0001@
ooooo`00E?ooool00ol0000004730011``020011``03o`00001HQn@0F8OT00T0F8OT0_l0000908F?
eP03o`00002PZ=`0X:SL01@0X:SL00?o00000;J_dP2f[m801P2f[m800ol00000a<OM0<C7g@0C0<C7
g@03o`00003IfmP0fM_H00L0fM_H0_l000080=?ih`;o0000DOooool005Gooooo00?o00000011``00
@L<00P00@L<00ol00000F8OT05R7i00:05R7i003o`000025SmH0QHoF00H0QHoF00?o00000:2Xg02P
Z=`05@2PZ=`00ol00000]ZoB0;J_dP040;J_dP03o`000034amd0a<OM01@0a<OM00?o00000=WKf03I
fmP01P3IfmP00ol00000doWS0=?ih`070=?ih`;o0000D_ooool005Kooooo0_l000020011``03o`00
001HQn@0F8OT00/0F8OT0_l0000508F?eP03o`00002PZ=`0X:SL01H0X:SL00?o00000;J_dP2f[m80
0`2f[m800ol00000a<OM0<C7g@0E0<C7g@03o`00003IfmP0fM_H00@0fM_H0_l000090=?ih`;o0000
Doooool005Sooooo00Co00000011``00@L?o00003P1HQn@00ol00000QHoF08F?eP0208F?eP03o`00
002PZ=`0X:SL01L0X:SL00Go00000;J_dP2f[m80]ZoBo`00000H0<C7g@03o`00003IfmP0fM_H00<0
fM_H00?o00000=?ih`3CnN<0203CnN<2o`0005Cooooo001Iooooo`04o`000000@L<00473o`0000h0
F8OT00Go000008F?eP25SmH0QHoFo`00000J0:2Xg003o`00002f[m;o000001T0a<OM00Co00000=WK
f03IfmP0fM_H0_l0000:0=?ih`;o0000EOooool005[ooooo0_l000000`00@L?o000005R7i00=05R7
i0;o000000<0QHoFo`00002PZ=`06P2PZ=`00ol00000a<OM0<C7g@0G0<C7g@05o`00003IfmP0fM_H
0=WKf?l000002`3CnN<00ol0003oooooooooo`1Eooooo`00G?ooool00ol000000473o`00000?05R7
i0;o00006`2PZ=`00ol00000a<OM0<C7g@0G0<C7g@04o`00003IfmSo0000o`0000/0doWS00?o0000
ooooooooool0E_ooool005gooooo00?o00000011`ol000003`1HQn@00ol00000X:SL0:2Xg00I0:2X
g003o`000034amd0a<OM01L0a<OM0_l0000<0=?ih`03o`000?oooooooooo05Oooooo001Nooooo`;o
00003`1HQn@00ol00000X:SL0:2Xg00I0:2Xg003o`000034amd0a<OM01L0a<OM00?o00000=?ih`3C
nN<02P3CnN<00ol0003oooooooooo`1Hooooo`00Goooool2o`0000l0F8OT00?o00000:2Xg02PZ=`0
602PZ=`00ol00000a<OM0<C7g@0G0<C7g@03o`00003CnN<0doWS00T0doWS00?o0000ooooooooool0
FOooool0067ooooo00?o000005R7i01HQn@03@1HQn@00ol00000X:SL0:2Xg00G0:2Xg003o`000034
amd0a<OM01H0a<OM00?o00000=?ih`3CnN<02@3CnN<00ol0003oooooooooo`1Jooooo`00H_ooool0
0ol00000F8OT05R7i00=05R7i003o`00002PZ=`0X:SL01H0X:SL00?o00000<C7g@34amd05@34amd0
0ol00000doWS0=?ih`090=?ih`03o`000?oooooooooo05_ooooo001Sooooo`;o00003P1HQn@00ol0
0000X:SL0:2Xg00D0:2Xg003o`000034amd0a<OM01D0a<OM00?o00000=?ih`3CnN<02@3CnN<00ol0
003oooooooooo`1Looooo`00IOooool00ol00000F8OT05R7i00;05R7i003o`00002PZ=`0X:SL01@0
X:SL00?o00000<C7g@34amd05034amd00ol00000doWS0=?ih`090=?ih`03o`000?oooooooooo05go
oooo001Vooooo`03o`00001HQn@0F8OT00/0F8OT00?o00000:2Xg02PZ=`04`2PZ=`00ol00000a<OM
0<C7g@0C0<C7g@03o`00003CnN<0doWS00P0doWS0_l0001Pooooo`00Ioooool2o`0000`0F8OT00?o
00000:2Xg02PZ=`04P2PZ=`00ol00000a<OM0<C7g@0B0<C7g@03o`00003CnN<0doWS00P0doWS00?o
0000ooooooooool0H?ooool006Wooooo00?o000005R7i01HQn@02P1HQn@00ol00000X:SL0:2Xg00A
0:2Xg003o`000034amd0a<OM0140a<OM00?o00000=?ih`3CnN<01`3CnN<2o`0006?ooooo001Zoooo
o`;o00002P1HQn@00ol00000X:SL0:2Xg00A0:2Xg003o`000034amd0a<OM0100a<OM00?o00000=?i
h`3CnN<01`3CnN<00ol0003oooooooooo`1Sooooo`00K?ooool00ol00000F8OT05R7i00805R7i003
o`00002PZ=`0X:SL0100X:SL00?o00000<C7g@34amd03`34amd00ol00000doWS0=?ih`070=?ih`03
o`000?oooooooooo06Cooooo001]ooooo`03o`00001HQn@0F8OT00P0F8OT00?o00000:2Xg02PZ=`0
3`2PZ=`00ol00000a<OM0<C7g@0>0<C7g@03o`00003CnN<0doWS00H0doWS0_l0001Wooooo`00K_oo
ool2o`0000T0F8OT00?o00000:2Xg02PZ=`03P2PZ=`00ol00000a<OM0<C7g@0=0<C7g@03o`00003C
nN<0doWS00H0doWS00?o0000ooooooooool0Ioooool0073ooooo00?o000005R7i01HQn@01`1HQn@0
0ol00000X:SL0:2Xg00=0:2Xg003o`000034amd0a<OM00`0a<OM00?o00000=?ih`3CnN<01@3CnN<2
o`0006[ooooo001aooooo`03o`00001HQn@0F8OT00H0F8OT00?o00000:2Xg02PZ=`03@2PZ=`00ol0
0000a<OM0<C7g@0;0<C7g@03o`00003CnN<0doWS00D0doWS00?o0000ooooooooool0J_ooool007;o
oooo0_l0000705R7i003o`00002PZ=`0X:SL00/0X:SL00?o00000<C7g@34amd02`34amd00ol00000
doWS0=?ih`040=?ih`;o0000KOooool007Cooooo00?o000005R7i01HQn@01@1HQn@00ol00000X:SL
0:2Xg00:0:2Xg003o`000034amd0a<OM00X0a<OM00?o00000=?ih`3CnN<0103CnN<00ol0003ooooo
ooooo`1]ooooo`00MOooool2o`0000H0F8OT00?o00000:2Xg02PZ=`02@2PZ=`00ol00000a<OM0<C7
g@0:0<C7g@03o`00003CnN<0doWS0080doWS0_l0001`ooooo`00Moooool00ol00000F8OT05R7i003
05R7i003o`00002PZ=`0X:SL00T0X:SL00?o00000<C7g@34amd02@34amd00ol00000doWS0=?ih`02
0=?ih`03o`000?oooooooooo073ooooo001hooooo`03o`00001HQn@0F8OT00<0F8OT00?o00000:2X
g02PZ=`0202PZ=`00ol00000a<OM0<C7g@080<C7g@03o`00003CnN<0doWS0080doWS00?o0000oooo
ooooool0LOooool007Wooooo0_l0000405R7i003o`00002PZ=`0X:SL00L0X:SL00?o00000<C7g@34
amd01`34amd01?l00000doWS0=?ih`3CnN<2o`0007Cooooo001kooooo`03o`00001HQn@0F8OT0080
F8OT00?o00000:2Xg02PZ=`01P2PZ=`00ol00000a<OM0<C7g@060<C7g@05o`00003CnN<0doWS0=?i
hol00000M_ooool007cooooo00?o000005R7i01HQn@00P1HQn@00ol00000X:SL0:2Xg0050:2Xg003
o`000034amd0a<OM00D0a<OM00?o00000=?ih`3CnN<00_l0001gooooo`00OOooool2o`000080F8OT
00?o00000:2Xg02PZ=`01@2PZ=`00ol00000a<OM0<C7g@040<C7g@04o`00003CnN<0doWSo`0007Wo
oooo001oooooo`04o`00001HQn@0F8OTo`0000H0X:SL00?o00000<C7g@34amd00`34amd01?l00000
doWSo`000?l0001jooooo`00P?ooool01?l00000F8OT05R7i?l000050:2Xg003o`000034amd0a<OM
0080a<OM00?o00000=?ihol00000O?ooool0087ooooo0_l000000`1HQnCo00000:2Xg0020:2Xg003
o`000034amd0a<OM0080a<OM0ol0001mooooo`00Poooool2o`0000<0X:SL00Co00000<C7g@34amd0
a<OM0_l0001oooooo`00Q?ooool2o`000080X:SL00?o00000<C7g@34amd00_l00020ooooo`00Q_oo
ool01?l00000X:SLo`000034amd2o`00087ooooo0027ooooo`?o0000Poooool008Sooooo00?o0000
ooooooooool0P_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_oo
ool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_oo
ool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_oo
ool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_oo
ool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00?oooooo3_ooool00001\
\>"],
  ImageRangeCache->{{{0, 268}, {285, 0}} -> {0.0761903, -7.23142*^-5, \
0.00311099, 0.00311099}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show[poly0=
\tGraphics3D[
\tJoin[{PointSize[0.02]},
\t\tPoint /@ genc]
\t],Boxed->True,ViewPoint->viewpt];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06327 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0913892 1.19942 0 1.19942 [
[ 0 0 0 0 ]
[ 1 1.06327 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04584 .22049 m
0 .98833 L
s
0 .98833 m
.46991 1.06327 L
s
.46991 1.06327 m
.47283 .40945 L
s
.47283 .40945 m
.04584 .22049 L
s
.55801 0 m
.95699 .25669 L
s
.95699 .25669 m
1 1.00287 L
s
1 1.00287 m
.56394 .89792 L
s
.56394 .89792 m
.55801 0 L
s
.04584 .22049 m
0 .98833 L
s
0 .98833 m
.56394 .89792 L
s
.56394 .89792 m
.55801 0 L
s
.55801 0 m
.04584 .22049 L
s
.47283 .40945 m
.95699 .25669 L
s
.95699 .25669 m
1 1.00287 L
s
1 1.00287 m
.46991 1.06327 L
s
.46991 1.06327 m
.47283 .40945 L
s
0 0 m
1 0 L
1 1.06327 L
0 1.06327 L
closepath
clip
newpath
.02 w
.48246 .60675 Mdot
.60081 .69021 Mdot
.36266 .68431 Mdot
.57453 .50225 Mdot
.48195 .7694 Mdot
.40429 .49697 Mdot
.6956 .58662 Mdot
.52503 .58178 Mdot
.45381 .57977 Mdot
.49265 .48743 Mdot
.28045 .57486 Mdot
.57587 .66581 Mdot
.57587 .66581 Mdot
.61517 .57305 Mdot
.49715 .38786 Mdot
.40216 .66136 Mdot
.40216 .66136 Mdot
.69944 .75291 Mdot
.3688 .56598 Mdot
.62073 .4736 Mdot
.52538 .74894 Mdot
.58814 .37701 Mdot
.45268 .74729 Mdot
.49233 .65334 Mdot
.49233 .65334 Mdot
.37231 .46564 Mdot
.67337 .55828 Mdot
.41197 .3708 Mdot
.27572 .74326 Mdot
.57728 .83616 Mdot
.71358 .46357 Mdot
.6174 .74178 Mdot
.49691 .55312 Mdot
.49691 .55312 Mdot
.49691 .55312 Mdot
.7999 .64637 Mdot
.39994 .83264 Mdot
.53705 .45784 Mdot
.46332 .45545 Mdot
.31837 .54789 Mdot
.36587 .73598 Mdot
.62309 .6417 Mdot
.62309 .6417 Mdot
.54924 .63974 Mdot
.2838 .44962 Mdot
.58982 .54379 Mdot
.58982 .54379 Mdot
.58982 .54379 Mdot
.44417 .63697 Mdot
.49199 .82626 Mdot
.50832 .25532 Mdot
.36942 .63499 Mdot
.36942 .63499 Mdot
.67686 .72966 Mdot
.40993 .53845 Mdot
.40993 .53845 Mdot
.40993 .53845 Mdot
.71794 .63325 Mdot
.71794 .63325 Mdot
.59535 .44066 Mdot
.18744 .63019 Mdot
.49667 .72542 Mdot
.49667 .72542 Mdot
.49667 .72542 Mdot
.63645 .34332 Mdot
.53767 .62842 Mdot
.53767 .62842 Mdot
.41391 .43465 Mdot
.46235 .62641 Mdot
.46235 .62641 Mdot
.72464 .53025 Mdot
.31429 .72113 Mdot
.50346 .5288 Mdot
.62556 .81701 Mdot
.37908 .33395 Mdot
.69116 .42992 Mdot
.27897 .62149 Mdot
.27897 .62149 Mdot
.5428 .52475 Mdot
.59158 .71776 Mdot
.59158 .71776 Mdot
.59158 .71776 Mdot
.6332 .61969 Mdot
.46683 .52245 Mdot
.50832 .42379 Mdot
.50832 .42379 Mdot
.50832 .42379 Mdot
.50832 .42379 Mdot
.36642 .81168 Mdot
.82247 .52042 Mdot
.40779 .71337 Mdot
.40779 .71337 Mdot
.40779 .71337 Mdot
.72249 .81029 Mdot
.28183 .51685 Mdot
.59725 .61394 Mdot
.59725 .61394 Mdot
.32323 .41757 Mdot
.3725 .61261 Mdot
.63925 .5148 Mdot
.63925 .5148 Mdot
.63925 .5148 Mdot
.49642 .90523 Mdot
.53831 .80645 Mdot
.56269 .51245 Mdot
.41184 .60887 Mdot
.41184 .60887 Mdot
.60481 .41268 Mdot
.46135 .80485 Mdot
.72937 .70663 Mdot
.45375 .50911 Mdot
.50336 .70544 Mdot
.37624 .50673 Mdot
.37624 .50673 Mdot
.37624 .50673 Mdot
.69518 .60489 Mdot
.69518 .60489 Mdot
.41827 .40633 Mdot
.27392 .80094 Mdot
.54356 .70211 Mdot
.73783 .50463 Mdot
.59341 .89939 Mdot
.61069 .30449 Mdot
.46592 .70022 Mdot
.18746 .50094 Mdot
.50832 .59971 Mdot
.50832 .59971 Mdot
.50832 .59971 Mdot
.50832 .59971 Mdot
.50832 .59971 Mdot
.50832 .59971 Mdot
.82942 .69855 Mdot
.55088 .49882 Mdot
.40556 .89605 Mdot
.42248 .2974 Mdot
.2768 .69562 Mdot
.47276 .49639 Mdot
.74496 .39656 Mdot
.59922 .79493 Mdot
.31911 .59446 Mdot
.31911 .59446 Mdot
.64216 .69393 Mdot
.64216 .69393 Mdot
.64216 .69393 Mdot
.51337 .49203 Mdot
.5639 .69199 Mdot
.28246 .49046 Mdot
.55634 .39001 Mdot
.40968 .79089 Mdot
.60697 .59034 Mdot
.60697 .59034 Mdot
.45253 .68924 Mdot
.47751 .38727 Mdot
.5206 .28457 Mdot
.37327 .68729 Mdot
.37327 .68729 Mdot
.37327 .68729 Mdot
.64849 .58639 Mdot
.69938 .78772 Mdot
.41624 .58498 Mdot
.41624 .58498 Mdot
.743 .68556 Mdot
.28547 .38059 Mdot
.613 .48135 Mdot
.613 .48135 Mdot
.613 .48135 Mdot
.1802 .68252 Mdot
.65664 .37814 Mdot
.50832 .78359 Mdot
.50832 .78359 Mdot
.50832 .78359 Mdot
.50832 .78359 Mdot
.55185 .68077 Mdot
.37715 .57872 Mdot
.42053 .47524 Mdot
.42053 .47524 Mdot
.42053 .47524 Mdot
.47195 .67877 Mdot
.75034 .57672 Mdot
.75034 .57672 Mdot
.3148 .77941 Mdot
.64521 .88121 Mdot
.38359 .36851 Mdot
.51349 .67518 Mdot
.71491 .47043 Mdot
.2773 .67389 Mdot
.55743 .57118 Mdot
.55743 .57118 Mdot
.60923 .77612 Mdot
.4768 .56887 Mdot
.4768 .56887 Mdot
.37017 .87615 Mdot
.52088 .46417 Mdot
.52088 .46417 Mdot
.52088 .46417 Mdot
.85454 .56682 Mdot
.41412 .77185 Mdot
.28033 .56323 Mdot
.28033 .56323 Mdot
.61542 .66639 Mdot
.61542 .66639 Mdot
.61542 .66639 Mdot
.32431 .45783 Mdot
.66008 .56115 Mdot
.66008 .56115 Mdot
.50832 .97599 Mdot
.52625 .35095 Mdot
.57878 .55879 Mdot
.41849 .66135 Mdot
.41849 .66135 Mdot
.41849 .66135 Mdot
.75597 .76526 Mdot
.46305 .55541 Mdot
.38067 .55301 Mdot
.38067 .55301 Mdot
.66682 .44807 Mdot
.71974 .65738 Mdot
.55858 .76085 Mdot
.47606 .759 Mdot
.63001 .33818 Mdot
.17993 .54716 Mdot
.52117 .65222 Mdot
.52117 .65222 Mdot
.52117 .65222 Mdot
.38477 .43878 Mdot
.27494 .7545 Mdot
.42991 .33086 Mdot
.77299 .43637 Mdot
.61795 .86017 Mdot
.31995 .64699 Mdot
.66367 .75284 Mdot
.52668 .53815 Mdot
.52668 .53815 Mdot
.57243 .42966 Mdot
.41635 .85632 Mdot
.48856 .42685 Mdot
.37762 .74634 Mdot
.67062 .63894 Mdot
.28414 .42002 Mdot
.63293 .52733 Mdot
.63293 .52733 Mdot
.52148 .84934 Mdot
.38179 .63127 Mdot
.42801 .52113 Mdot
.42801 .52113 Mdot
.7794 .62927 Mdot
.52712 .73446 Mdot
.57399 .62373 Mdot
.48808 .62142 Mdot
.27862 .61577 Mdot
.636 .72581 Mdot
.54098 .38958 Mdot
.42602 .72085 Mdot
.69113 .49353 Mdot
.39013 .48407 Mdot
.54181 .59059 Mdot
.25 Mabswid
.55801 0 m
.95699 .25669 L
s
.95699 .25669 m
1 1.00287 L
s
1 1.00287 m
.56394 .89792 L
s
.56394 .89792 m
.55801 0 L
s
.04584 .22049 m
0 .98833 L
s
0 .98833 m
.56394 .89792 L
s
.56394 .89792 m
.55801 0 L
s
.55801 0 m
.04584 .22049 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{266, 282.812},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004:00016R000`400?l00000o`00003oT_ooool3
000007Gooooo002@ooooo`80000000Cooooo00000?ooool00000M?ooool008gooooo0`000003oooo
o`0300000?oooooooooo00800000L_ooool008_ooooo0P000006ooooo`0300000?oooooooooo00;o
oooo00<00000ooooooooool0Koooool008Wooooo0P000008ooooo`0300000?oooooooooo00?ooooo
0P00001_ooooo`00Q_ooool3000000[ooooo00<00000ooooooooool01Oooool2000006gooooo0024
ooooo`8000003Oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo06[ooooo0022oooo
o`8000003oooool00`00003oooooooooo`08ooooo`800000J_ooool007oooooo0`00000Aooooo`03
00000?oooooooooo00[ooooo00<00000ooooooooool0Ioooool007gooooo0P00000Dooooo`030000
0?oooooooooo00_ooooo0P00001Wooooo`00Noooool2000001Kooooo00<00000ooooooooool03Ooo
ool00`00003oooooooooo`1Tooooo`00N?ooool3000001Sooooo00<00000ooooooooool03_ooool2
000006Cooooo001fooooo`8000006oooool00`00003oooooooooo`0@ooooo`0300000?oooooooooo
067ooooo001dooooo`8000007Oooool00`00003oooooooooo`0Aooooo`800000HOooool0077ooooo
0`00000Oooooo`0300000?oooooooooo01?ooooo0P00001Oooooo`00Koooool2000002;ooooo00<0
0000ooooooooool05Oooool00`00003oooooooooo`1Looooo`00KOooool2000002Cooooo00<00000
ooooooooool05_ooool2000005cooooo001Zooooo`<000009_ooool00`00003oooooooooo`0Hoooo
o`0300000?oooooooooo05Wooooo001Xooooo`800000:Oooool00`00003oooooooooo`0Iooooo`80
0000FOooool006Kooooo0P00000[ooooo`0300000?oooooooooo01_ooooo00<00000ooooooooool0
E_ooool006?ooooo0`00000]ooooo`0300000?oooooooooo01cooooo0P00001Fooooo`00HOooool2
0000033ooooo00<00000ooooooooool07_ooool2000005Cooooo001Oooooo`800000<_ooool00`00
003oooooooooo`0Pooooo`0300000?oooooooooo057ooooo001Looooo`<00000=?ooool00`00003o
ooooooooo`0Qooooo`800000DOooool005[ooooo0P00000gooooo`0300000?oooooooooo02?ooooo
00<00000ooooooooool0C_ooool005Sooooo0P00000iooooo`0300000?oooooooooo02Cooooo0P00
001>ooooo`00EOooool3000003_ooooo00<00000ooooooooool09_ooool00`00003oooooooooo`1;
ooooo`00Doooool2000003kooooo00<00000ooooooooool09oooool2000004_ooooo001Aooooo`80
0000@?ooool00`00003oooooooooo`0Yooooo`0300000?oooooooooo04Sooooo001>ooooo`<00000
@_ooool00`00003oooooooooo`0Zooooo`800000B?ooool004cooooo0P000015ooooo`0300000?oo
oooooooo02cooooo0P000016ooooo`00B_ooool2000004Oooooo00<00000ooooooooool0;_ooool0
0`00003oooooooooo`13ooooo`00Aoooool3000004Wooooo00<00000ooooooooool0;oooool20000
04?ooooo0015ooooo`800000C?ooool00`00003oooooooooo`0aooooo`0300000?oooooooooo043o
oooo0013ooooo`800000C_ooool00`00003oooooooooo`0booooo`800000@?ooool0043ooooo0`00
001@ooooo`0300000?oooooooooo03Cooooo00<00000ooooooooool0?Oooool003kooooo0P00001C
ooooo`0300000?oooooooooo03Gooooo0P00000mooooo`00??ooool2000005Gooooo00<00000oooo
ooooool0=oooool00`00003oooooooooo`0jooooo`00>Oooool3000005Oooooo00<00000oooooooo
ool0>?ooool2000003[ooooo000gooooo`800000F_ooool00`00003oooooooooo`0jooooo`800000
>?ooool003Gooooo0P00001Looooo`0300000?oooooooooo03cooooo00<00000ooooooooool0=Ooo
ool003;ooooo0`00001Nooooo`0300000?oooooooooo03gooooo0P00000eooooo`00<?ooool20000
067ooooo00<00000ooooooooool0?oooool00`00003oooooooooo`0booooo`00;_ooool2000006?o
oooo00<00000ooooooooool0@?ooool2000003;ooooo000[ooooo`<00000IOooool00`00003ooooo
ooooo`12ooooo`0300000?oooooooooo02oooooo000Yooooo`800000J?ooool00`00003ooooooooo
o`13ooooo`800000;oooool002Oooooo0P00001Zooooo`0300000?oooooooooo04Gooooo00<00000
ooooooooool0;?ooool002Cooooo0`00001/ooooo`0300000?oooooooooo04Kooooo0P00000/oooo
o`008_ooool2000006oooooo00<00000ooooooooool0B?ooool2000002[ooooo000Pooooo`800000
LOooool00`00003oooooooooo`1:ooooo`0300000?oooooooooo02Oooooo000Mooooo`<00000Looo
ool00`00003oooooooooo`1;ooooo`8000009oooool001_ooooo0P00001fooooo`0300000?oooooo
oooo04gooooo00<00000ooooooooool09?ooool001Wooooo0P00001hooooo`0300000?oooooooooo
04kooooo0P00000Tooooo`005_ooool3000007[ooooo00<00000ooooooooool0D?ooool00`00003o
ooooooooo`0Qooooo`005?ooool2000007gooooo00<00000ooooooooool0DOooool20000027ooooo
000Booooo`800000Ooooool00`00003oooooooooo`1Cooooo`8000007oooool000oooooo0`000021
ooooo`0300000?oooooooooo05Gooooo00<00000ooooooooool07?ooool000gooooo0P000024oooo
o`0300000?oooooooooo05Kooooo0P00000Looooo`003?ooool2000008Gooooo00<00000oooooooo
ool0F?ooool00`00003oooooooooo`0Iooooo`003?ooool01000003ooooo000000000023ooooo`03
00000?oooooooooo05Wooooo0P00000Iooooo`003?ooool01000003oooooooooooooool30000087o
oooo00<00000ooooooooool0F_ooool00`00003oooooooooo`0Fooooo`003?ooool00`00003ooooo
ooooo`04ooooo`800000Ooooool00`00003oooooooooo`1Kooooo`8000005_ooool000cooooo00<0
0000ooooooooool01_ooool2000007gooooo00<00000ooooooooool0GOooool00`00003ooooooooo
o`0Cooooo`003?ooool00`00003oooooooooo`08ooooo`800000Noooool00`00003oooooooooo`1N
ooooo`8000004oooool000cooooo00<00000ooooooooool02_ooool3000007Sooooo00<00000oooo
ooooool0H?ooool20000017ooooo000<ooooo`0300000?oooooooooo00gooooo0P00001Wooooo`?o
00003?ooool00`00003oooooooooo`1Rooooo`0300000?oooooooooo00kooooo000<ooooo`030000
0?oooooooooo00oooooo0P00001Tooooo`Go00002oooool00`00003oooooooooo`1Sooooo`800000
3_ooool000_ooooo00<00000ooooooooool04_ooool2000006;ooooo1Ol0000;ooooo`0300000?oo
oooooooo06Gooooo00<00000ooooooooool02oooool000_ooooo00<00000ooooooooool05?ooool3
000005oooooo1Ol0000;ooooo`0300000?oooooooooo06Cooooo0`00000<ooooo`002oooool00`00
003oooooooooo`0Gooooo`800000G_ooool3o`0000cooooo00<00000ooooooooool0HOooool30000
00;ooooo00<00000ooooooooool02_ooool000_ooooo00<00000ooooooooool06Oooool2000006_o
oooo00<00000ooooooooool0G_ooool3000000Gooooo00<00000ooooooooool02_ooool000_ooooo
00<00000ooooooooool06oooool3000006Sooooo00<00000ooooooooool0Foooool3000000Sooooo
00<00000ooooooooool02_ooool000_ooooo00<00000ooooooooool07_ooool2000006Kooooo00<0
0000ooooooooool0F?ooool3000000_ooooo00<00000ooooooooool02_ooool000_ooooo00<00000
ooooooooool08?ooool2000005Sooooo0ol00009ooooo`0300000?oooooooooo05Cooooo1000000>
ooooo`0300000?oooooooooo00[ooooo000;ooooo`0300000?oooooooooo02;ooooo0P00001Eoooo
o`Go00002?ooool00`00003oooooooooo`1Aooooo`<000004_ooool00`00003oooooooooo`0:oooo
o`002oooool00`00003oooooooooo`0Tooooo`<00000D_ooool5o`0000Sooooo00<00000oooooooo
ool0C_ooool3000001Gooooo00<00000ooooooooool02_ooool000_ooooo00<00000ooooooooool0
9oooool20000053ooooo1Ol00008ooooo`0300000?oooooooooo04_ooooo0`00000Hooooo`030000
0?oooooooooo00[ooooo000;ooooo`0300000?oooooooooo02Wooooo0P00000eooooo`?o00005ooo
ool3o`0000Wooooo00<00000ooooooooool0B?ooool3000001cooooo00<00000ooooooooool02Ooo
ool000_ooooo00<00000ooooooooool0:oooool2000003;ooooo1Ol0000Rooooo`0300000?oooooo
oooo04Cooooo1000000Oooooo`0300000?oooooooooo00Wooooo000;ooooo`0300000?oooooooooo
02gooooo0`00000_ooooo`Go00008_ooool00`00003oooooooooo`09ooooo`?o0000=Oooool30000
02?ooooo00<00000ooooooooool02Oooool000_ooooo00<00000ooooooooool0<?ooool2000002go
oooo1Ol0000Rooooo`0300000?oooooooooo00Sooooo1Ol0000aooooo`<000009_ooool00`00003o
ooooooooo`09ooooo`002oooool00`00003oooooooooo`0booooo`800000;?ooool3o`0002?ooooo
00<00000ooooooooool02?ooool5o`0002kooooo0`00000Yooooo`0300000?oooooooooo00Wooooo
000;ooooo`0300000?oooooooooo03Cooooo0P00001@ooooo`0300000?oooooooooo00Sooooo1Ol0
000[ooooo`<00000;?ooool00`00003oooooooooo`09ooooo`002oooool00`00003oooooooooo`0f
ooooo`<00000COooool00`00003oooooooooo`09ooooo`?o0000:?ooool4000002oooooo00<00000
ooooooooool02Oooool000[ooooo00<00000ooooooooool0>_ooool2000004_ooooo00<00000oooo
ooooool0<Oooool3000003?ooooo00<00000ooooooooool02Oooool000[ooooo00<00000oooooooo
ool0??ooool2000004Wooooo00<00000ooooooooool0;_ooool3000003Kooooo00<00000oooooooo
ool02Oooool000[ooooo00<00000ooooooooool0?_ooool2000001Kooooo0ol0000:ooooo`?o0000
8Oooool00`00003oooooooooo`0[ooooo`<00000>Oooool00`00003oooooooooo`09ooooo`002_oo
ool00`00003oooooooooo`10ooooo`<000004_ooool5o`0000Sooooo1Ol0000Pooooo`0300000?oo
oooooooo00kooooo0ol0000Gooooo`<00000??ooool00`00003oooooooooo`09ooooo`002_ooool0
0`00003oooooooooo`13ooooo`8000004?ooool5o`0000Sooooo1Ol0000Pooooo`0300000?oooooo
oooo00gooooo1Ol0000Booooo`@00000?oooool00`00003oooooooooo`09ooooo`002_ooool00`00
003oooooooooo`15ooooo`8000003_ooool5o`0000Sooooo1Ol0000Pooooo`0300000?oooooooooo
00gooooo1_l0000>ooooo`<00000@oooool00`00003oooooooooo`09ooooo`002_ooool00`00003o
ooooooooo`17ooooo`8000003Oooool3o`0000[ooooo0ol0000Qooooo`0300000?oooooooooo00go
oooo1ol0000:ooooo`<00000A_ooool00`00003oooooooooo`09ooooo`002_ooool00`00003ooooo
ooooo`19ooooo`<00000<Oooool3o`0000Oooooo00<00000ooooooooool03_ooool6o`0000Oooooo
0`000019ooooo`0300000?oooooooooo00Wooooo000:ooooo`0300000?oooooooooo04cooooo0P00
000^ooooo`Go00001_ooool00`00003oooooooooo`0?ooooo`Go00001?ooool3000004cooooo00<0
0000ooooooooool02Oooool000[ooooo00<00000ooooooooool0C_ooool2000002cooooo1Ol00006
ooooo`0300000?oooooooooo013ooooo0ol000000oooool0000000000002000004oooooo00<00000
ooooooooool02Oooool000[ooooo00<00000ooooooooool0D?ooool2000002[ooooo1Ol00006oooo
o`0300000?oooooooooo017ooooo0`00001Dooooo`0300000?oooooooooo00Sooooo000:ooooo`03
00000?oooooooooo05;ooooo0`000002ooooo`?o00008oooool3o`0000Oooooo00<00000oooooooo
ool03_ooool3000005Oooooo00<00000ooooooooool02?ooool000[ooooo00<00000ooooooooool0
EOooool00`00003o0000o`000003o`0000Cooooo0ol0000Uooooo`0300000?oooooooooo00_ooooo
0`00001Jooooo`0300000?oooooooooo00Sooooo000:ooooo`0300000?oooooooooo05Kooooo1Ol0
0003ooooo`Go00009?ooool00`00003oooooooooo`08ooooo`<00000GOooool00`00003ooooooooo
o`08ooooo`002_ooool00`00003oooooooooo`1Fooooo`Go000000<00000ooooooooool01Ol0000T
ooooo`0300000?oooooooooo00?ooooo0ol00002000000gooooo0ol0001@ooooo`0300000?oooooo
oooo00Sooooo000:ooooo`0300000?oooooooooo03gooooo0ol0000Gooooo`?o00000_ooool20000
00Go00009?ooool01@00003oooooooooooooool0000000Go00003Oooool5o`0004oooooo00<00000
ooooooooool02?ooool000[ooooo00<00000ooooooooool0??ooool5o`0001gooooo00@00000o`00
0?l0003o00003_ooool3o`0001Cooooo100000000ooooooo0000o`000003o`0000gooooo1Ol0001?
ooooo`0300000?oooooooooo00Sooooo0009ooooo`0300000?oooooooooo03gooooo1Ol0000Ooooo
o`8000003Oooool5o`000004ooooool0003o0000o`0000Wooooo0ol000001?oooooo0000o`000000
0004ooooo`Go00003Oooool5o`0004oooooo00<00000ooooooooool02?ooool000Wooooo00<00000
ooooooooool0?Oooool5o`00027ooooo0`00000:ooooo`[o00001oooool7o`00000300000?l0003o
oooo00?ooooo0ol0000?ooooo`?o0000D?ooool00`00003oooooooooo`08ooooo`002Oooool00`00
003oooooooooo`0nooooo`?o00009Oooool2000000Sooooo2_l00005ooooo`8000001ol000000`00
003o0000ooooo`0]ooooo`?o0000>?ooool00`00003oooooooooo`08ooooo`002Oooool00`00003o
ooooooooo`1Xooooo`8000001oooool3o`000003ooooool0003o000000?o00000_ooool3000000;o
oooo1ol000000`00003o0000ooooo`0/ooooo`Go0000=oooool00`00003oooooooooo`08ooooo`00
2Oooool00`00003oooooooooo`1Zooooo`8000002_ooool3o`0000<000001_ooool3o`000004oooo
ool0003o0000000002kooooo1Ol0000gooooo`0300000?oooooooooo00Sooooo0009ooooo`030000
0?oooooooooo067ooooo0ol00008ooooo`<000001oooool3000000oooooo00<00000ooooooooool0
;?ooool5o`0003Oooooo00<00000ooooooooool02?ooool000Wooooo00<00000ooooooooool0H?oo
ool5o`0000[ooooo0P000002ooooo`<000004_ooool00`00003oooooooooo`08ooooo`?o00008_oo
ool3o`0003Sooooo00<00000ooooooooool02?ooool000Wooooo00<00000ooooooooool0B?ooool3
o`0001Gooooo1Ol0000<ooooo`8000005Oooool00`00003oooooooooo`07ooooo`Go0000G?ooool0
0`00003oooooooooo`08ooooo`002Oooool00`00003oooooooooo`0nooooo`?o00001_ooool5o`00
01Cooooo1Ol0000<ooooo`0300000?oooooooooo01Cooooo00<00000ooooooooool01oooool5o`00
05cooooo00<00000ooooooooool02?ooool000Wooooo00<00000ooooooooool0?Oooool5o`0000Go
oooo1Ol0000Eooooo`?o00003Oooool00`00003oooooooooo`05ooooo`?o00003?ooool00`00003o
ooooooooo`07ooooo`Go0000GOooool00`00003oooooooooo`07ooooo`002Oooool00`00003ooooo
ooooo`0mooooo`Go00001Oooool5o`0002Gooooo00<00000ooooooooool00ol000000ooooooo0000
o`000003o`0000_ooooo00<00000ooooooooool02?ooool3o`0005kooooo00<00000ooooooooool0
1oooool000Wooooo00<00000ooooooooool0?Oooool5o`0000Kooooo0ol0000Vooooo`0300000?oo
oooo000000Wo00002oooool00`00003oooooo`000002o`0001gooooo0ol00017ooooo`0300000?oo
oooooooo00Oooooo0009ooooo`0300000?oooooooooo03kooooo0ol0000Oooooo`?o00003_ooool0
0`00003oooooo`000009o`0000_ooooo00<00000o`000?l000000ol0000Kooooo`Go00004Oooool3
o`0003;ooooo00<00000ooooooooool01oooool000Wooooo00<00000ooooooooool0F?ooool3o`00
00Cooooo1Ol0000=ooooo`0300000?oooooo000000Co000000Coooooo`000?l0003o00003?ooool0
0`00003o0000o`000003o`0001_ooooo1Ol0000@ooooo`Go0000<Oooool00`00003oooooooooo`07
ooooo`002Oooool00`00003oooooooooo`1Gooooo`Go00000oooool5o`0000gooooo00<00000oooo
ooooool00ol0000Aooooo`0300000?l0003o000000?o00000_ooool3o`0001Kooooo1Ol0000@oooo
o`Go0000<Oooool00`00003oooooooooo`07ooooo`002Oooool00`00003oooooooooo`1Gooooo`Go
00000oooool5o`0000gooooo00<00000ooooooooool05?ooool00`00003oooooo`000002o`0000;o
oooo1Ol0000Fooooo`?o00004Oooool5o`00037ooooo00<00000ooooooooool01oooool000Wooooo
00<00000ooooooooool0?_ooool3o`0001Kooooo1Ol00004ooooo`?o00003_ooool00`00003ooooo
ooooo`0Dooooo`0300000?oooooooooo00Cooooo1Ol0000?ooooo`?o00006Oooool3o`0003;ooooo
00<00000ooooooooool01oooool000Sooooo00<00000ooooooooool0?_ooool5o`0001Kooooo0ol0
000Fooooo`0300000?oooooooooo01Cooooo00<00000ooooooooool01?ooool5o`0000kooooo1Ol0
001=ooooo`0300000?oooooooooo00Oooooo0008ooooo`0300000?oooooooooo03kooooo1Ol00006
ooooo`?o00008_ooool3o`000003ooooo`00003ooooo00kooooo0ol00004ooooo`0300000?oooooo
oooo00Gooooo0ol0000?ooooo`Go0000COooool00`00003oooooooooo`07ooooo`002?ooool00`00
003oooooooooo`0nooooo`Go00001Oooool5o`00023ooooo1Ol000000`00003oooooooooo`0<oooo
o`Go00000oooool00`00003oooooooooo`0Gooooo`Go0000COooool00`00003oooooooooo`07oooo
o`002?ooool00`00003oooooooooo`0oooooo`?o00001_ooool5o`0000Wooooo0ol0000Dooooo`Go
000000<00000ooooooooool02?ooool3o`000003ooooool0003o000000?o00000oooool00`00003o
ooooooooo`0Hooooo`?o00002Oooool3o`0004;ooooo00<00000ooooooooool01oooool000Sooooo
00<00000ooooooooool0B?ooool5o`0000Sooooo1Ol0000Cooooo`Go000000<00000ooooooooool0
1oooool:o`0000?ooooo00<00000ooooooooool08oooool5o`00047ooooo00<00000ooooooooool0
1oooool000Sooooo00<00000ooooooooool0BOooool3o`0000Wooooo1Ol0000Dooooo`?o000000?o
oooo00000?ooool02?ooool5o`000004ooooool0003o0000o`0000Cooooo00<00000ooooooooool0
3?ooool3o`0001Cooooo1_l00010ooooo`0300000?oooooooooo00Oooooo0008ooooo`0300000?oo
oooooooo05Gooooo1Ol00009ooooo`?o00003?ooool00`00003oooooooooo`07ooooo`Go00002?oo
ool00`00003oooooooooo`0;ooooo`Go00004oooool6o`00043ooooo00<00000ooooooooool01ooo
ool000Sooooo00<00000ooooooooool0E_ooool3o`0000Wooooo1Ol0000;ooooo`0300000?oooooo
oooo00Sooooo0ol00009ooooo`0300000?oooooooooo00[ooooo1_l0000Dooooo`Go0000@?ooool0
0`00003oooooooooo`07ooooo`002?ooool00`00003oooooooooo`1Kooooo`?o00001?ooool5o`00
00_ooooo00<00000ooooooooool05?ooool00`00003oooooooooo`09ooooo`Oo00005Oooool3o`00
04;ooooo00<00000ooooooooool01_ooool000Sooooo00<00000ooooooooool0F_ooool5o`0000?o
oooo1Ol0000;ooooo`0400000?ooooooooooooooo`?o00004?ooool00`00003oooooooooo`09oooo
o`Ko0000Foooool00`00003oooooooooo`06ooooo`002?ooool00`00003oooooooooo`0nooooo`?o
00006Oooool5o`0000Cooooo0ol0000<ooooo`0300000?oooooooooo00Go000000Coooooo`000?l0
003o00002oooool00`00003oooooooooo`09ooooo`Go0000G?ooool00`00003oooooooooo`06oooo
o`002?ooool00`00003oooooooooo`0mooooo`Go00006?ooool5o`0001;ooooo0ol000000ooooooo
0000o`000008o`0000[ooooo00<00000ooooooooool02_ooool3o`0001;ooooo0ol00018ooooo`03
00000?oooooooooo00Kooooo0008ooooo`0300000?oooooooooo03gooooo1Ol0000Iooooo`?o0000
00Coooooo`000?l0003o00003_ooool?o`0000Kooooo0ol000000oooool00000ooooo`0Oooooo`Go
0000Aoooool00`00003oooooooooo`06ooooo`002?ooool00`00003oooooooooo`0Uooooo`?o0000
5Oooool5o`0001cooooo1Ol0000=ooooo`Go000000Goooooo`000?l0003o0000ooooo`05o`0000Go
oooo1Ol000000`00003oooooooooo`03o`0001_ooooo1Ol00017ooooo`0300000?oooooooooo00Ko
oooo0008ooooo`0300000?oooooooooo02Cooooo1Ol0000Eooooo`?o00005_ooool3o`0000Cooooo
1Ol0000=ooooo`Go00001_ooool3o`0000Kooooo1Ol000000`00003oooooo`000004o`0001[ooooo
1Ol00008ooooo`?o0000??ooool00`00003oooooooooo`06ooooo`002?ooool00`00003ooooooooo
o`0Tooooo`Go0000;Oooool5o`0000?ooooo1Ol00009ooooo`?o00000_ooool3o`00013ooooo1Ol0
00000`00003oooooo`000004o`0001_ooooo0ol00008ooooo`Go0000>oooool00`00003ooooooooo
o`06ooooo`002?ooool00`00003oooooooooo`0Tooooo`Go0000;Oooool5o`0000Cooooo0ol00009
ooooo`Go00000_ooool00`00003oooooooooo`0@ooooo`Co000000<00000o`000?l000001?l0000=
ooooo`?o00005_ooool5o`0003_ooooo00<00000ooooooooool01_ooool000Oooooo00<00000oooo
ooooool09_ooool3o`0001Kooooo0ol0000Eooooo`Go00004?ooool5o`0000;ooooo00<00000oooo
ooooool04_ooool2o`00000300000?l0003o000000?o00003Oooool5o`0001Gooooo1Ol0000koooo
o`0300000?oooooooooo00Kooooo0007ooooo`0300000?oooooooooo03kooooo1Ol0000Eooooo`?o
00002oooool3o`0000?ooooo1ol000000`00003oooooooooo`0Booooo`;o000000<00000o`000?l0
00004?ooool5o`0001Kooooo0ol0000Cooooo`?o00009_ooool00`00003oooooooooo`06ooooo`00
1oooool00`00003oooooooooo`0nooooo`Go00008_ooool5o`0000?ooooo1ol0000@ooooo`?o0000
00Coooooo`000?l0000000000_l0000@ooooo`Go0000:oooool5o`0002Gooooo00<00000oooooooo
ool01_ooool000Oooooo00<00000ooooooooool0?_ooool5o`0002;ooooo1Ol00005ooooo`Go0000
1_ooool3o`0000Kooooo1Ol000001?oooooo000000000?l0000@ooooo`Go00004oooool3o`0001Ko
oooo1Ol0000Uooooo`0300000?oooooooooo00Kooooo0007ooooo`0300000?oooooooooo03oooooo
0ol0000Sooooo`Go00001Oooool5o`0000Gooooo1Ol00005ooooo`Go00000_ooool00`00003ooooo
ooooo`0>ooooo`Go00004oooool5o`0001Gooooo1Ol0000Uooooo`0300000?oooooooooo00Kooooo
0007ooooo`0300000?oooooooooo06Kooooo0ol00007ooooo`?o000000<00000ooooooooool00ooo
ool5o`0000;ooooo2?l00002ooooo`0300000?oooooooooo00kooooo1Ol0000Cooooo`Go00005_oo
ool3o`0002Kooooo00<00000ooooooooool01_ooool000Oooooo00<00000ooooooooool0HOooool3
o`0000oooooo00<00000ooooooooool00oooool5o`000003ooooool0003o000000Ko00000oooool0
0`00003oooooooooo`0>ooooo`Go00004oooool5o`0003oooooo00<00000ooooooooool01_ooool0
00Oooooo00<00000ooooooooool0H?ooool5o`0000kooooo00<00000ooooooooool01?ooool3o`00
00;ooooo1Ol00006ooooo`0300000?oooooooooo00Cooooo0ol00008ooooo`?o00005Oooool3o`00
043ooooo00<00000ooooooooool01_ooool000Oooooo00<00000ooooooooool09?ooool3o`0002;o
oooo0ol0000Dooooo`Go00003_ooool00`00003oooooooooo`09ooooo`Go00001_ooool00`00003o
ooooooooo`03ooooo`Go0000Hoooool00`00003oooooooooo`05ooooo`001oooool00`00003ooooo
ooooo`0Sooooo`Go00008?ooool5o`0000cooooo0ol00004ooooo`Go00003_ooool00`00003ooooo
ooooo`02ooooo`?o00001Oooool3o`0000Oooooo00<00000ooooooooool00oooool5o`0006?ooooo
00<00000ooooooooool01Oooool000Oooooo00<00000ooooooooool08oooool5o`00023ooooo1Ol0
000;ooooo`Go00001?ooool3o`0000_ooooo0ol000000oooool00000ooooo`02ooooo`Go00003_oo
ool00`00003oooooooooo`03ooooo`Go0000Hoooool00`00003oooooooooo`05ooooo`001oooool0
0`00003oooooooooo`0Sooooo`Go00008?ooool5o`0000_ooooo1Ol0000Aooooo`Go000000@00000
oooooooooooooooo1Ol0000>ooooo`0400000?ooooooooooooooo`Ko00004oooool3o`0004kooooo
00<00000ooooooooool01Oooool000Oooooo00<00000ooooooooool09?ooool3o`0001Sooooo0ol0
0007ooooo`?o00003?ooool5o`00017ooooo1Ol000001000003oooooooooooooool5o`0000kooooo
00<00000ooooooooool01Ol0000Aooooo`So0000COooool00`00003oooooooooo`05ooooo`001ooo
ool00`00003oooooooooo`0nooooo`Go00004oooool6o`0001;ooooo1Ol000000`00003ooooooooo
o`02ooooo`?o00003oooool00`00003oooooooooo`05o`00013ooooo2Ol0000/ooooo`?o00007_oo
ool00`00003oooooooooo`05ooooo`001oooool00`00003oooooooooo`0nooooo`Go00004_ooool5
o`0001Gooooo0ol000001?oooooo0000o`000?l0000Booooo`;o000000<00000ooooooooool01Ol0
000@ooooo`Wo0000:oooool5o`0001gooooo00<00000ooooooooool01Oooool000Oooooo00<00000
ooooooooool0?_ooool5o`0001;ooooo1Ol0000Hooooo`Go00004?ooool3o`00000400000?l0003o
ooooooooo`?o00001_ooool3o`0000Sooooo2?l0000/ooooo`Go00007Oooool00`00003ooooooooo
o`05ooooo`001oooool00`00003oooooooooo`0nooooo`Go00004_ooool6o`0001;ooooo0ol00002
ooooo`Go00004?ooool3o`00000300000?l0003ooooo00Wooooo1Ol00008ooooo`?o00005Oooool3
o`0001Sooooo1Ol0000Mooooo`0300000?oooooooooo00Gooooo0006ooooo`0300000?oooooooooo
03oooooo1Ol0000Cooooo`Ko00004?ooool5o`000003ooooool0003o000000?o00002Oooool3o`00
00Cooooo0ol000000`00003o0000ooooo`09ooooo`Go00007oooool5o`0001Sooooo0ol0000Noooo
o`0300000?oooooooooo00Gooooo0006ooooo`0300000?oooooooooo03oooooo1Ol0000Dooooo`Go
00001oooool3o`0000Kooooo1Ol00002ooooo`?o00002Oooool5o`0000Cooooo0_l000000`00003o
ooooooooo`09ooooo`Go00001Oooool3o`0000[ooooo0ol0000:ooooo`Go0000>Oooool00`00003o
ooooooooo`05ooooo`001_ooool00`00003oooooooooo`10ooooo`?o00005Oooool5o`0000Kooooo
1Ol00005ooooo`Go00000_ooool00`00003oooooooooo`09ooooo`So00000oooool00`00003ooooo
ooooo`08ooooo`Go00001Oooool5o`0000Sooooo1Ol00009ooooo`Go0000>Oooool00`00003ooooo
ooooo`05ooooo`001_ooool00`00003oooooooooo`1:ooooo`?o00003?ooool3o`0000Oooooo1Ol0
0006ooooo`?o00000oooool00`00003oooooooooo`09ooooo`Wo00000_ooool00`00003ooooooooo
o`07ooooo`Go00001_ooool5o`0000Sooooo1Ol0000:ooooo`?o0000>_ooool00`00003ooooooooo
o`05ooooo`001_ooool00`00003oooooooooo`19ooooo`Go00005Oooool5o`0000cooooo00<00000
ooooooooool02_ooool8o`0000;ooooo00<00000ooooooooool01oooool5o`0000Kooooo1Ol00008
ooooo`Go0000Aoooool00`00003oooooooooo`05ooooo`001_ooool00`00003oooooooooo`19oooo
o`Go00005_ooool3o`0000gooooo00<00000ooooooooool01Oooool3o`0000Gooooo1Ol00002oooo
o`0300000?oooooooooo00Oooooo1Ol00007ooooo`?o00002_ooool3o`0004Sooooo00<00000oooo
ooooool01Oooool000Kooooo00<00000ooooooooool0BOooool5o`0002Kooooo00<00000oooooooo
ool01?ooool5o`0000Gooooo0ol00003ooooo`0300000?oooooooooo00Sooooo0ol0000Eooooo`?o
0000B?ooool00`00003oooooooooo`05ooooo`001_ooool00`00003oooooooooo`1:ooooo`?o0000
5_ooool3o`0000kooooo00@00000o`000?l0003o00000oooool5o`0000_ooooo00<00000oooooooo
ool07oooool5o`0004Sooooo00<00000ooooooooool01?ooool000Kooooo00<00000ooooooooool0
F?ooool3o`0000Oooooo1Ol0000=ooooo`Go00000_ooool5o`0000_ooooo00<00000ooooooooool0
7oooool5o`0004Sooooo00<00000ooooooooool01?ooool000Kooooo00<00000ooooooooool0?ooo
ool3o`0001Gooooo1Ol00006ooooo`Go00003Oooool5o`0000?ooooo0ol0000<ooooo`0300000?oo
oooooooo00Kooooo0ol0000Fooooo`Go0000B?ooool00`00003oooooooooo`04ooooo`001_ooool0
0`00003oooooooooo`0nooooo`Go00005?ooool5o`0000Kooooo1Ol0000=ooooo`Go00004_ooool0
0`00003oooooooooo`05ooooo`Go00001Oooool3o`0000kooooo0ol00019ooooo`0300000?oooooo
oooo00Cooooo0006ooooo`0300000?oooooooooo03kooooo1Ol0000Dooooo`Go00001oooool3o`00
00kooooo00<00000o`000?l000000ol0000Aooooo`0300000?oooooo000000;o00000oooool5o`00
00Cooooo1Ol0001Iooooo`0300000?oooooooooo00Cooooo0006ooooo`0300000?oooooooooo03ko
oooo1Ol0000Eooooo`?o00005Oooool3o`000003ooooo`00003ooooo00Go00002Oooool3o`0000Co
oooo00<00000o`000?l000000ol00002ooooo`Go00001?ooool5o`0005Wooooo00<00000oooooooo
ool01?ooool000Kooooo00<00000ooooooooool09oooool3o`0001Cooooo1Ol0000Hooooo`?o0000
4Oooool5o`00000300000?oooooo000000Co00002?ooool5o`0000?ooooo00<00000o`000?l00000
0ol00003ooooo`?o00001Oooool5o`0002?ooooo0ol0000cooooo`0300000?oooooooooo00Cooooo
0006ooooo`0300000?oooooooooo02Kooooo1Ol0000Cooooo`Go00005?ooool8o`00013ooooo1Ol0
00000`00003oooooo`000004o`0000Sooooo1Ol00003ooooo`0300000?l0003o000000?o00003?oo
ool3o`0001Cooooo0ol0000<ooooo`Go0000<_ooool00`00003oooooooooo`04ooooo`001_ooool0
0`00003oooooooooo`0Vooooo`Go00005?ooool3o`0001Cooooo2Ol0000<ooooo`?o000000?ooooo
o`000?l000000ol000000`00003oooooooooo`03o`0000Wooooo1ol000000oooool00000ooooo`03
o`0001Oooooo0ol00009ooooo`Go00002oooool5o`0003;ooooo00<00000ooooooooool01?ooool0
00Kooooo00<00000ooooooooool09_ooool5o`0002_ooooo2Ol0000;ooooo`Go000000Koooooo`00
0?l0003o0000ooooo`00000?ooooo`Oo000000<00000ooooooooool03?ooool3o`0000Wooooo1Ol0
0008ooooo`Go00002oooool5o`0003;ooooo00<00000ooooooooool01?ooool000Gooooo00<00000
ooooooooool0:?ooool3o`00023ooooo0ol00009ooooo`So00003?ooool5o`0000Gooooo00<00000
ooooooooool03oooool5o`00000300000?oooooooooo00_ooooo1Ol00008ooooo`Go00002?ooool5
o`0000cooooo0ol00002ooooo`?o0000;_ooool00`00003oooooooooo`04ooooo`001Oooool00`00
003oooooooooo`1:ooooo`Go00002Oooool3o`00013ooooo1Ol00005ooooo`0300000?oooooooooo
00oooooo1Ol000000`00003oooooooooo`0;ooooo`Go00002?ooool5o`0000Wooooo0ol0000Aoooo
o`Go0000;Oooool00`00003oooooooooo`04ooooo`001Oooool00`00003oooooooooo`1:ooooo`Go
00007Oooool3o`0000Kooooo00@00000oooooooooooooooo0ol00004ooooo`?o00001Oooool3o`00
0003ooooo`00003ooooo00cooooo1Ol00009ooooo`?o00007_ooool5o`0002gooooo00<00000oooo
ooooool01?ooool000Gooooo00<00000ooooooooool0B_ooool5o`0002Kooooo00<00000oooooooo
ool01Ol00002ooooo`Go00002?ooool00`00003oooooooooo`0<ooooo`?o00005oooool3o`00017o
oooo1Ol0000]ooooo`0300000?oooooooooo00Cooooo0005ooooo`0300000?oooooooooo04_ooooo
0ol0000Cooooo`?o000000Coooooo`000?l0003o00003Oooool00`00003oooooooooo`05o`0000;o
oooo1Ol00008ooooo`0300000?oooooooooo02Gooooo1Ol0000Aooooo`?o0000;_ooool00`00003o
ooooooooo`04ooooo`001Oooool00`00003oooooooooo`1Pooooo`Wo00003?ooool00`00003ooooo
ooooo`05o`0000;ooooo1Ol00008ooooo`0300000?oooooooooo00?o00001oooool3o`0001Sooooo
1Ol00012ooooo`0300000?oooooooooo00Cooooo0005ooooo`0300000?oooooooooo063ooooo2Ol0
000<ooooo`0400000?ooooooooooooooo`?o00001?ooool3o`0000Wooooo00<00000ooooool00000
1?l00005ooooo`Go00005oooool5o`0004;ooooo00<00000ooooooooool01?ooool000Gooooo00<0
0000ooooooooool0@?ooool3o`0001gooooo2Ol0000<ooooo`0300000?oooooooooo01Cooooo00<0
0000ooooool000001?l00005ooooo`Go00006?ooool3o`0004Cooooo00<00000ooooooooool00ooo
ool000Gooooo00<00000ooooooooool0?oooool5o`0001gooooo0ol000001?oooooo0000o`000?l0
000=ooooo`0300000?oooooooooo00Kooooo0ol0000;ooooo`0300000?oooooo000000Co00001Ooo
ool5o`0005oooooo00<00000ooooooooool00oooool000Gooooo00<00000ooooooooool0?oooool5
o`0002oooooo0ol00007ooooo`Go00001oooool3o`00000300000?oooooooooo00?o00001oooool3
o`00063ooooo00<00000ooooooooool00oooool000Gooooo00<00000ooooooooool09_ooool3o`00
01Kooooo1Ol0000Booooo`?o00006Oooool5o`0000Kooooo1Ol00006ooooo`Go000000<00000oooo
ooooool0K?ooool00`00003oooooooooo`03ooooo`001Oooool00`00003oooooooooo`0Uooooo`Go
00005_ooool3o`0001;ooooo1ol0000Booooo`?o000000?oooooo`000?l000000ol00006ooooo`Go
00001_ooool5o`00000300000?oooooooooo02_ooooo0ol0000nooooo`0300000?oooooooooo00?o
oooo0005ooooo`0300000?oooooooooo02Gooooo1Ol0000[ooooo`So00004?ooool:o`0000Oooooo
0ol00007ooooo`Go000000<00000o`000?ooool01_ooool3o`00027ooooo1Ol0000mooooo`030000
0?oooooooooo00?ooooo0005ooooo`0300000?oooooooooo02Gooooo1Ol0000Fooooo`?o00004_oo
ool8o`00013ooooo1Ol000001?oooooo0000o`000?l0000Cooooo`Co000000<00000o`000?l00000
1Oooool5o`0000Oooooo0ol0000Fooooo`Go0000?Oooool00`00003oooooooooo`03ooooo`001Ooo
ool00`00003oooooooooo`0Vooooo`?o00005_ooool5o`0001;ooooo1ol0000@ooooo`So000000<0
0000ooooooooool04oooool2o`00000300000?l0003o000000Gooooo1Ol00006ooooo`Go00005Ooo
ool5o`0001?ooooo0ol0000Wooooo`0300000?oooooooooo00?ooooo0005ooooo`0300000?oooooo
oooo03oooooo1Ol0000Eooooo`?o00004_ooool8o`00013ooooo0ol00002ooooo`;o000000<00000
o`000?l000001Oooool5o`0000Kooooo1Ol0000Fooooo`?o00004oooool5o`0002Kooooo00<00000
ooooooooool00oooool000Gooooo00<00000ooooooooool0?oooool5o`0002gooooo1Ol00006oooo
o`?o00001_ooool5o`0000;ooooo00?o000000000?l000001oooool3o`0000Oooooo1Ol0000Coooo
o`?o00005_ooool5o`0002Kooooo00<00000ooooooooool00oooool000Cooooo00<00000oooooooo
ool0@Oooool3o`0002kooooo1Ol00005ooooo`Go00001Oooool5o`0000?ooooo00<00000oooooooo
ool04Oooool3o`0001?ooooo1Ol0000Eooooo`Go00009_ooool00`00003oooooooooo`03ooooo`00
1?ooool00`00003oooooooooo`1Sooooo`?o00003Oooool3o`00000300000?oooooooooo00?ooooo
1Ol00005ooooo`Go00000oooool00`00003oooooooooo`0Wooooo`Go00005_ooool3o`0002Oooooo
00<00000ooooooooool00oooool000Cooooo00<00000ooooooooool0H_ooool5o`0000oooooo00<0
0000ooooooooool00oooool5o`0000Kooooo0ol00004ooooo`0300000?oooooooooo00?ooooo0ol0
000Qooooo`Go0000@?ooool00`00003oooooooooo`03ooooo`001?ooool00`00003oooooooooo`1;
ooooo`?o00005?ooool5o`000004ooooool0003o0000o`0000_ooooo00<00000ooooooooool01?oo
ool3o`0000kooooo00<00000ooooooooool00_ooool5o`00027ooooo0ol00011ooooo`0300000?oo
oooooooo00?ooooo0004ooooo`0300000?oooooooooo04[ooooo1Ol0000Cooooo`[o00002_ooool0
0`00003oooooooooo`02ooooo`?o00004?ooool00`00003oooooooooo`02ooooo`Go00002?ooool3
o`0005[ooooo00<00000ooooooooool00oooool000Cooooo00<00000ooooooooool0B_ooool5o`00
01Cooooo0ol000000ooooooo0000o`000003o`0000[ooooo00@00000oooooooooooooooo1Ol0000?
ooooo`0300000?oooooooooo00;ooooo1Ol00007ooooo`Go00001oooool3o`0004oooooo00<00000
ooooooooool00oooool000Cooooo00<00000ooooooooool0B_ooool5o`0001Sooooo1Ol0000:oooo
o`0400000?ooooooooooooooo`Go00001?ooool3o`0000Sooooo00<00000ooooooooool00oooool3
o`0000Sooooo1Ol00006ooooo`Go0000Coooool00`00003oooooooooo`02ooooo`001?ooool00`00
003oooooooooo`1;ooooo`?o00002_ooool3o`0000gooooo0ol0000;ooooo`0400000?oooooooooo
ooooo`Go00000oooool5o`0000Oooooo00<00000ooooooooool03_ooool5o`0000Kooooo1Ol0001?
ooooo`0300000?oooooooooo00;ooooo0004ooooo`0300000?oooooooooo05Oooooo1Ol0000Joooo
o`0300000?oooooooooo00;ooooo0ol00004ooooo`Go00001oooool00`00003oooooooooo`0:oooo
o`?o00000_ooool3o`0000Oooooo1Ol0001?ooooo`0300000?oooooooooo00;ooooo0004ooooo`03
00000?oooooooooo043ooooo0ol0000Dooooo`Go00006Oooool00`00003oooooooooo`0:ooooo`Go
00001oooool00`00003oooooooooo`09ooooo`Go00003?ooool3o`00053ooooo00<00000oooooooo
ool00_ooool000Cooooo00<00000ooooooooool0?oooool5o`0001?ooooo1ol0000Aooooo`?o0000
0oooool00`00003oooooooooo`0;ooooo`?o00002?ooool00`00003oooooooooo`09ooooo`Go0000
Goooool00`00003oooooooooo`02ooooo`001?ooool00`00003oooooooooo`0oooooo`Go00005?oo
ool7o`0000oooooo1Ol00002ooooo`0300000?oooooooooo00[ooooo1Ol00007ooooo`0300000?oo
oooooooo00Wooooo1Ol00008ooooo`?o00001oooool3o`0004[ooooo00<00000ooooooooool00_oo
ool000Cooooo00<00000ooooooooool0?oooool5o`0001Kooooo1Ol0000?ooooo`Go00000_ooool0
0`00003oooooooooo`0:ooooo`Go00001oooool00`00003oooooooooo`0:ooooo`?o00002?ooool5
o`0000Gooooo1Ol00019ooooo`0300000?oooooooooo00;ooooo0004ooooo`0300000?oooooooooo
03oooooo1Ol0000Fooooo`Go00003oooool5o`0000;ooooo00@00000o`000?l0003o00002Oooool5
o`0000Cooooo0ol000000`00003oooooooooo`0Eooooo`Go00001Oooool5o`0004Wooooo00<00000
ooooooooool00_ooool000Cooooo00<00000ooooooooool0?oooool5o`0001Oooooo0ol0000Aoooo
o`?o00000oooool5o`0000Wooooo0ol00004ooooo`Co000000<00000ooooooooool05Oooool5o`00
00Gooooo1Ol00019ooooo`0300000?oooooooooo00;ooooo0004ooooo`0300000?oooooooooo03oo
oooo1Ol0000aooooo`Go00004?ooool4o`00000300000?oooooooooo01Kooooo0ol00007ooooo`?o
00003?ooool3o`0003_ooooo00<00000ooooooooool00_ooool000Cooooo00<00000ooooooooool0
@?ooool3o`0002;ooooo0ol0000=ooooo`Go00004?ooool4o`00000300000?oooooooooo02kooooo
1Ol0000jooooo`0300000?oooooooooo00;ooooo0003ooooo`0300000?oooooooooo06Gooooo1Ol0
000<ooooo`0300000?l0003o000000?o00004?ooool3o`00000300000?oooooooooo02kooooo1Ol0
000jooooo`0300000?oooooooooo00;ooooo0003ooooo`0300000?oooooooooo04cooooo0ol0000F
ooooo`Go00003?ooool00`00003o0000o`000003o`0001?ooooo00<00000ooooooooool02?ooool3
o`0002?ooooo1Ol0000jooooo`0300000?oooooooooo00;ooooo0003ooooo`0300000?oooooooooo
04_ooooo1Ol0000Eooooo`Go00003?ooool00`00003o0000o`000003o`0000?ooooo0ol0000=oooo
o`0300000?oooooooooo00Oooooo1Ol0000Sooooo`?o0000>oooool00`00003oooooooooo`02oooo
o`000oooool00`00003oooooooooo`1;ooooo`Go00005_ooool3o`0000gooooo00<00000ooooool0
00000_l00003ooooo`Go00003?ooool00`00003oooooooooo`07ooooo`Go0000HOooool00`00003o
ooooooooo`02ooooo`000oooool00`00003oooooooooo`1;ooooo`Go00005Oooool3o`0000kooooo
00<00000ooooooooool01Oooool5o`0000cooooo00<00000ooooooooool01oooool5o`0001Cooooo
0ol0001:ooooo`0300000?oooooooooo00;ooooo0003ooooo`0300000?oooooooooo04cooooo0ol0
000Eooooo`Go00003Oooool00`00003oooooooooo`05ooooo`Go00003?ooool00`00003ooooooooo
o`05ooooo`Ko00005?ooool5o`0004Wooooo00<00000ooooooooool00_ooool000?ooooo00<00000
ooooooooool0I?ooool5o`0000gooooo00<00000ooooooooool01_ooool3o`0000gooooo00<00000
ooooooooool01?ooool5o`0001Kooooo1Ol0001:ooooo`0300000?oooooooooo007ooooo0003oooo
o`0300000?oooooooooo047ooooo0ol0000Pooooo`Go00003Oooool00`00003oooooooooo`0Foooo
o`0300000?oooooooooo00Cooooo1Ol0000Fooooo`Go0000B_ooool00`00003oooooooooo`01oooo
o`000oooool00`00003oooooooooo`10ooooo`Go00008?ooool3o`0000_ooooo0ol000000`00003o
ooooooooo`0Fooooo`0300000?oooooooooo00Cooooo1Ol0000Gooooo`?o0000Boooool00`00003o
ooooooooo`01ooooo`000oooool00`00003oooooooooo`10ooooo`Go0000;Oooool5o`00013ooooo
0ol00005ooooo`0300000?oooooooooo00Gooooo0ol0001Vooooo`0300000?oooooooooo007ooooo
0003ooooo`0300000?oooooooooo043ooooo1Ol0000Dooooo`?o00005_ooool5o`0000oooooo1Ol0
0004ooooo`0300000?oooooooooo02Kooooo0ol00015ooooo`0300000?oooooooooo007ooooo0003
ooooo`0300000?oooooooooo047ooooo0ol0000Dooooo`Go00005Oooool5o`0000oooooo1Ol00004
ooooo`0300000?oooooooooo00cooooo0ol0000Fooooo`Go0000A?ooool00`00003oooooooooo`01
ooooo`000oooool00`00003oooooooooo`1Hooooo`Go00005_ooool3o`00000300000?oooooooooo
00gooooo1Ol00004ooooo`0300000?oooooooooo00_ooooo1Ol0000Eooooo`Go0000A?ooool00`00
003oooooooooo`01ooooo`000oooool00`00003oooooooooo`1Hooooo`Go00006Oooool00`00003o
ooooooooo`0>ooooo`?o00001Oooool00`00003oooooooooo`0;ooooo`Go00005Oooool5o`0004Co
oooo00<00000ooooooooool00Oooool000?ooooo00<00000ooooooooool0FOooool3o`0001[ooooo
00<00000ooooooooool00_ooool3o`00017ooooo00<00000ooooooooool02oooool5o`0001Kooooo
0ol00015ooooo`0300000?oooooooooo007ooooo0003ooooo`0300000?oooooooooo06;ooooo0ol0
000Aooooo`0400000?ooooooooooooooo`Go00004?ooool00`00003oooooooooo`0<ooooo`?o0000
Goooool00`00003oooooooooo`01ooooo`000oooool00`00003oooooooooo`1Qooooo`Go00004?oo
ool01000003oooooooooooooool5o`00013ooooo00<00000ooooool000000_l0001/ooooo`030000
0?oooooooooo007ooooo0002ooooo`0300000?oooooooooo06;ooooo1Ol0000@ooooo`0400000?oo
ooooooooooooo`Go00004?ooool00`00003o0000o`000003o`0006_ooooo00<00000ooooooooool0
0Oooool000;ooooo00<00000ooooooooool0H_ooool5o`00013ooooo00<00000ooooooooool00_oo
ool3o`00017ooooo00<00000o`000?l000000ol0001[ooooo`0300000?oooooooooo007ooooo0002
ooooo`0300000?oooooooooo06?ooooo0ol0000Aooooo`0300000?oooooooooo01Kooooo00<00000
o`000?l000000ol0001[ooooo`0300000?oooooooooo007ooooo0002ooooo`0300000?oooooooooo
07Oooooo00<00000ooooooooool02_ooool3o`0000Wooooo00<00000ooooool000000_l0001/oooo
o`0300000?oooooooooo007ooooo0002ooooo`0300000?oooooooooo07Oooooo00<00000oooooooo
ool02Oooool5o`0000Sooooo00<00000ooooooooool0K_ooool00`00003oooooooooo`01ooooo`00
0_ooool00`00003oooooooooo`1Xooooo`?o00003?ooool00`00003oooooooooo`09ooooo`Go0000
2?ooool00`00003oooooooooo`1_ooooo`4000000Oooool1ooooo`000_ooool00`00003ooooooooo
o`1Wooooo`Go00002oooool00`00003oooooooooo`09ooooo`Go00002?ooool00`00003ooooooooo
o`0:ooooo`?o0000H_ooool10000007ooooo0Oooool000;ooooo00<00000ooooooooool0Ioooool5
o`0000_ooooo00<00000ooooooooool02_ooool3o`0000Wooooo00<00000ooooooooool02Oooool5
o`00067ooooo0@000001ooooo`7ooooo0002ooooo`0300000?oooooooooo06Oooooo1Ol0000;oooo
o`0300000?oooooooooo01Kooooo00<00000ooooooooool02Oooool5o`00067ooooo0@000001oooo
o`7ooooo0002ooooo`0300000?oooooooooo06Sooooo0ol0000<ooooo`0300000?oooooooooo01Ko
oooo00<00000ooooooooool02Oooool5o`00067ooooo0@000001ooooo`7ooooo0002ooooo`030000
0?oooooooooo05_ooooo0ol0000Iooooo`0300000?oooooooooo01Kooooo00<00000ooooooooool0
2_ooool3o`0006;ooooo0@000001ooooo`7ooooo0002ooooo`0300000?oooooooooo05[ooooo1Ol0
000Hooooo`0300000?oooooooooo01Kooooo00<00000ooooooooool04Oooool3o`0005_ooooo0@00
0001ooooo`7ooooo0002ooooo`0300000?oooooooooo05[ooooo1Ol0000Hooooo`0300000?oooooo
oooo01Kooooo00<00000ooooooooool04?ooool5o`0005[ooooo0@000001ooooo`7ooooo0002oooo
o`0300000?oooooooooo05[ooooo1Ol0000Hooooo`0300000?oooooooooo01Kooooo00<00000oooo
ooooool04?ooool5o`0005[ooooo0@000001ooooo`7ooooo0002ooooo`0300000?oooooooooo05_o
oooo0ol0000Iooooo`0300000?oooooooooo01Kooooo00<00000ooooooooool04?ooool5o`0005[o
oooo0@000001ooooo`7ooooo0002ooooo`0300000?oooooooooo06Gooooo0ol0000?ooooo`030000
0?oooooooooo01Kooooo00<00000ooooooooool04Oooool3o`0005_ooooo0@000001ooooo`7ooooo
0002ooooo`0300000?oooooooooo06Cooooo1Ol0000>ooooo`0300000?oooooooooo01Kooooo00<0
0000ooooooooool01?ooool3o`0006Sooooo0@000001ooooo`7ooooo00000oooool00000ooooo`1V
ooooo`Go00003_ooool00`00003oooooooooo`0Fooooo`0300000?oooooooooo00?ooooo1Ol0001W
ooooo`4000000Oooool1ooooo`0000?ooooo00000?ooool0I_ooool5o`0000kooooo00<00000oooo
ooooool00oooool3o`0000gooooo1P000003ooooo`Go0000Ioooool10000007ooooo0Oooool00003
ooooo`00003ooooo06Oooooo0ol0000?ooooo`0300000?oooooooooo00;ooooo1Ol00006ooooo`H0
00001_ooool4000000Co0000Ioooool10000007ooooo0Oooool00003ooooo`00003ooooo07Wooooo
00<00000ooooooooool00_ooool4o`0000L000004?ooool5000006Kooooo0@000001ooooo`7ooooo
00000oooool00000ooooo`1iooooo`0300000?oooooooooo00H0000000?o0000ooooooooool06Ooo
ool4000006?ooooo0@000001ooooo`0000?ooooo00000?ooool0M_ooool6000000?ooooo0ol0000P
ooooo`@00000Goooool10000007ooooo00000oooool00000ooooo`1`ooooo`H000000oooool00`00
003oooooooooo`0Zooooo`D00000F_ooool10000007ooooo00000oooool00000ooooo`1Zooooo`H0
00002Oooool00`00003oooooooooo`0_ooooo`@00000E_ooool10000007ooooo00000oooool00000
ooooo`1Sooooo`L000003oooool00`00003oooooooooo`0cooooo`@00000D_ooool10000007ooooo
00000oooool00000ooooo`1Mooooo`H000005_ooool00`00003oooooooooo`0gooooo`D00000COoo
ool10000007ooooo00000oooool00000ooooo`1Gooooo`H000007?ooool00`00003oooooooooo`0l
ooooo`@00000BOooool10000007ooooo00000oooool00000ooooo`1Aooooo`H000008_ooool00`00
003oooooooooo`10ooooo`@00000AOooool10000007ooooo00000oooool00000ooooo`1;ooooo`H0
0000:?ooool00`00003oooooooooo`14ooooo`@00000@Oooool10000007ooooo00000oooool00000
ooooo`14ooooo`L00000;_ooool00`00003oooooooooo`18ooooo`D00000??ooool10000007ooooo
00000oooool00000ooooo`0nooooo`H00000=Oooool00`00003oooooooooo`1=ooooo`@00000>?oo
ool10000007ooooo00000oooool00000ooooo`0hooooo`H00000>oooool00`00003oooooooooo`1A
ooooo`@00000=?ooool10000007ooooo00000oooool00000ooooo`0booooo`H00000@Oooool00`00
003oooooooooo`1Eooooo`D00000;oooool10000007ooooo00000`00003oooooooooo`0/ooooo`H0
0000Aoooool00`00003oooooooooo`1Jooooo`@00000:oooool10000007ooooo00000`00003ooooo
ooooo`0Uooooo`L00000COooool00`00003oooooooooo`1Nooooo`@000009oooool10000007ooooo
00000`00003oooooooooo`0Oooooo`H00000E?ooool00`00003oooooooooo`06ooooo`?o0000FOoo
ool4000002?ooooo0@000001ooooo`0000<00000ooooooooool06Oooool6000005[ooooo00<00000
ooooooooool01Oooool5o`0005cooooo1@00000Nooooo`4000000Oooool0000300000?oooooooooo
01?ooooo1P00001Pooooo`0300000?oooooooooo00Gooooo1Ol0001Qooooo`@000006oooool10000
000000<00000ooooooooool03Oooool6000006Kooooo00<00000ooooooooool01Oooool5o`0006Go
oooo1000000Gooooo`40000000000`00003oooooooooo`06ooooo`L00000K?ooool00`00003ooooo
ooooo`06ooooo`?o0000J_ooool5000001;ooooo0@000000000300000?oooooooooo00H00000Looo
ool00`00003oooooooooo`1hooooo`@000003_ooool1000000001000001hooooo`0300000?oooooo
oooo07cooooo1000000:ooooo`4000000004ooooo`L00000LOooool00`00003oooooooooo`20oooo
o`D000001Oooool1000000002oooool6000006_ooooo00<00000ooooooooool0QOooool40000007o
oooo0@000000017ooooo1`00001Tooooo`0300000?oooooooooo08Kooooo1@00000001Sooooo1P00
001Nooooo`0300000?oooooooooo07gooooo2@000005ooooo`007_ooool7000005Oooooo00<00000
ooooooooool0M?ooool9000000kooooo000Uooooo`H00000DOooool00`00003oooooooooo`1[oooo
o`T000005oooool002_ooooo1`00001:ooooo`0300000?oooooooooo06;ooooo2@00000Pooooo`00
<_ooool6000004Cooooo00<00000ooooooooool0F_ooool8000002Wooooo000hooooo`L00000?Ooo
ool00`00003oooooooooo`1Aooooo`T00000<Oooool003oooooo1`00000fooooo`0300000?oooooo
oooo04Sooooo2@00000jooooo`00A_ooool60000033ooooo00<00000ooooooooool0?oooool90000
04?ooooo001<ooooo`L00000:Oooool00`00003oooooooooo`0fooooo`T00000C?ooool005?ooooo
1P00000Sooooo`0300000?oooooooooo02gooooo2@00001Eooooo`00FOooool7000001cooooo00<0
0000ooooooooool09Oooool8000005kooooo001Pooooo`H000005_ooool00`00003oooooooooo`0L
ooooo`T00000I_ooool006Kooooo1`00000?ooooo`0300000?oooooooooo01?ooooo2@00001_oooo
o`00KOooool6000000Wooooo00<00000ooooooooool02_ooool9000007Sooooo001cooooo`L00000
0_ooool01000003oooooooooooooool90000087ooooo001jooooo`H00000R_ooool00001\
\>"],
  ImageRangeCache->{{{0, 265}, {281.812, 0}} -> {0.0761903, -7.67166*^-5, \
0.00314621, 0.00314621}}]
}, Open  ]]
}, Open  ]],

Cell["\<\
amat=-Map[Drop[#,1]&, inelist];
bvec=Map[First[#]&, inelist];
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
skel3D[vp_]:= 
\tGraphics3D[
\t\tVisibleSkeleton[genc, ecd, ead, 
     \t{amat, bvec}, vp]
     ]; 
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
uvp={20,20,20};
Show[skel3D[uvp], 
\t\tBoxed->False, 
 \t\tViewPoint -> getMmaViewPoint[uvp,skel3D[uvp]],
 \t\tSphericalRegion->True
 \t]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.5 .57693 m
.59588 .63364 L
s
.5 .57693 m
.40412 .63364 L
s
.5671 .48395 m
.5 .57693 L
s
.4329 .48395 m
.5 .57693 L
s
.5671 .48395 m
.66488 .53943 L
s
.56829 .37214 m
.5671 .48395 L
s
.4329 .48395 m
.33512 .53943 L
s
.43171 .37214 m
.4329 .48395 L
s
.5 .38962 m
.5671 .48395 L
s
.5 .38962 m
.4329 .48395 L
s
.5 .2753 m
.5 .38962 L
s
.40412 .63364 m
.5 .69238 L
s
.40412 .63364 m
.32906 .6565 L
s
.33512 .53943 m
.40412 .63364 L
s
.59588 .63364 m
.67094 .6565 L
s
.59588 .63364 m
.5 .69238 L
s
.66488 .53943 m
.59588 .63364 L
s
.56829 .37214 m
.66785 .4266 L
s
.43171 .37214 m
.33215 .4266 L
s
.5 .2753 m
.56829 .37214 L
s
.5 .2753 m
.43171 .37214 L
s
.66488 .53943 m
.7436 .55826 L
s
.66785 .4266 m
.66488 .53943 L
s
.33512 .53943 m
.2564 .55826 L
s
.33215 .4266 m
.33512 .53943 L
s
.5 .2753 m
.59907 .32841 L
s
.5 .2753 m
.5719 .28237 L
s
.5 .2753 m
.5 .26257 L
s
.5 .2753 m
.4281 .28237 L
s
.5 .2753 m
.40093 .32841 L
s
.5 .69238 m
.57213 .71833 L
s
.5 .69238 m
.42787 .71833 L
s
.66785 .4266 m
.7482 .44064 L
s
.59907 .32841 m
.66785 .4266 L
s
.33215 .4266 m
.2518 .44064 L
s
.40093 .32841 m
.33215 .4266 L
s
.59907 .32841 m
.67689 .33805 L
s
.40093 .32841 m
.32311 .33805 L
s
.32906 .6565 m
.42787 .71833 L
s
.32906 .6565 m
.31908 .66564 L
s
.2564 .55826 m
.32906 .6565 L
s
.67094 .6565 m
.68092 .66564 L
s
.67094 .6565 m
.57213 .71833 L
s
.7436 .55826 m
.67094 .6565 L
s
.2564 .55826 m
.24206 .56169 L
s
.2518 .44064 m
.2564 .55826 L
s
.7436 .55826 m
.75794 .56169 L
s
.7482 .44064 m
.7436 .55826 L
s
.5719 .28237 m
.67689 .33805 L
s
.5719 .28237 m
.57617 .26945 L
s
.4281 .28237 m
.42383 .26945 L
s
.4281 .28237 m
.32311 .33805 L
s
.57213 .71833 m
.57643 .73133 L
s
.57213 .71833 m
.5 .74674 L
s
.42787 .71833 m
.5 .74674 L
s
.42787 .71833 m
.42357 .73133 L
s
.0085 w
[ ] 0 setdash
.5 .26257 m
.57617 .26945 L
s
.5 .26257 m
.42383 .26945 L
s
.0035 w
[ .01 .012 ] 0 setdash
.7482 .44064 m
.7631 .43708 L
s
.67689 .33805 m
.7482 .44064 L
s
.2518 .44064 m
.2369 .43708 L
s
.32311 .33805 m
.2518 .44064 L
s
.67689 .33805 m
.6876 .32824 L
s
.32311 .33805 m
.3124 .32824 L
s
.0085 w
[ ] 0 setdash
.68092 .66564 m
.61121 .69262 L
s
.68092 .66564 m
.57643 .73133 L
s
.75794 .56169 m
.68092 .66564 L
s
.31908 .66564 m
.42357 .73133 L
s
.31908 .66564 m
.38879 .69262 L
s
.24206 .56169 m
.31908 .66564 L
s
.75794 .56169 m
.69146 .58372 L
s
.7631 .43708 m
.75794 .56169 L
s
.24206 .56169 m
.30854 .58372 L
s
.2369 .43708 m
.24206 .56169 L
s
.0035 w
[ .01 .012 ] 0 setdash
.5 .74674 m
.5 .76218 L
s
.0085 w
[ ] 0 setdash
.57617 .26945 m
.6876 .32824 L
s
.57617 .26945 m
.5 .27702 L
s
.42383 .26945 m
.5 .27702 L
s
.42383 .26945 m
.3124 .32824 L
s
.57643 .73133 m
.5 .76218 L
s
.42357 .73133 m
.5 .76218 L
s
.2369 .43708 m
.30451 .45325 L
s
.3124 .32824 m
.2369 .43708 L
s
.7631 .43708 m
.69549 .45325 L
s
.6876 .32824 m
.7631 .43708 L
s
.3124 .32824 m
.38448 .33898 L
s
.6876 .32824 m
.61552 .33898 L
s
.61121 .69262 m
.5 .76218 L
s
.69146 .58372 m
.61121 .69262 L
s
.38879 .69262 m
.5 .76218 L
s
.30854 .58372 m
.38879 .69262 L
s
.69146 .58372 m
.58097 .6516 L
s
.69549 .45325 m
.69146 .58372 L
s
.30854 .58372 m
.41903 .6516 L
s
.30451 .45325 m
.30854 .58372 L
s
.5 .27702 m
.61552 .33898 L
s
.5 .27702 m
.38448 .33898 L
s
.5 .63388 m
.5 .76218 L
s
.58097 .6516 m
.5 .76218 L
s
.41903 .6516 m
.5 .76218 L
s
.69549 .45325 m
.58271 .51978 L
s
.61552 .33898 m
.69549 .45325 L
s
.30451 .45325 m
.41729 .51978 L
s
.38448 .33898 m
.30451 .45325 L
s
.58271 .51978 m
.58097 .6516 L
s
.41729 .51978 m
.41903 .6516 L
s
.38448 .33898 m
.5 .40363 L
s
.61552 .33898 m
.5 .40363 L
s
.58271 .51978 m
.5 .63388 L
s
.41729 .51978 m
.5 .63388 L
s
.5 .40363 m
.58271 .51978 L
s
.5 .40363 m
.41729 .51978 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00QP3oool<o`0008P0oooo001k
0?ooob;o0000O@3oool007D0oooo4_l000050?ooo`030000003oool0oooo0080oooo4_l0001g0?oo
o`00L`3ooolEo`0000@0oooo00@000000?ooo`3oool0oooo5Ol0001e0?ooo`00L@3oool5o`000003
0?ooo`000000oooo00<0oooo8?l000050?ooo`0300000?l0003o000000?o0000L`3oool006l0oooo
1Ol000040?ooo`030000003oool0oooo0080oooo100000020?ooo`8000000P3oool:o`0000@0oooo
00<000000?ooo`3oool0100000040?ooo`040000003oool0oooo0?ooo`Go0000L@3oool006h0oooo
1?l000050?ooo`@00000303oool4o`0000030?ooo`00003o000000?o00003@3oool5000000<0oooo
1?l0001`0?ooo`00K03oool4o`0000D0oooo0P00000>0?ooo`Co00000`3oool00`000000oooo0?oo
o`04o`0000030000003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool4o`0006h0oooo001Z
0?ooo`Go0000503oool5o`0000P0oooo1Ol0000D0?ooo`Go0000K03oool006P0oooo1Ol000040?oo
o`8000003P3oool5o`000080oooo00<000000?ooo`3oool01@3oool00`000000ooooo`000004o`00
00l0oooo0P0000030?ooo`Go0000JP3oool006H0oooo1Ol000050?ooo`030000003oool0oooo00`0
oooo1Ol000040?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`3oool5
o`0000l0oooo00<000000?ooo`3oool00P3oool5o`0006P0oooo001T0?ooo`Go00005@3oool4o`00
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo1?l0000E0?ooo`Go0000IP3oool00680oooo1Ol000050?ooo`8000003P3oool4o`0000`0
oooo00<000000?ooo`3oool02@3oool4o`0000l0oooo0`0000030?ooo`Go0000I03oool00600oooo
1Ol000050?ooo`8000003P3oool5o`0000d0oooo00<000000?ooo`3oool02P3oool5o`0000030000
003oool0oooo00d0oooo00<000000?ooo`3oool00P3oool5o`000680oooo001N0?ooo`Go00005@3o
ool5o`0000P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`Go00005@3o
ool5o`000600oooo001M0?ooo`Co00001@3oool2000000l0oooo1?l000090?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool01P3oool4o`000100oooo0P0000040?ooo`Co0000G`3oool0
05/0oooo1?l000060?ooo`030000003oool0oooo00d0oooo1?l0000:0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`Co000000<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`030?ooo`Co0000G@3oool005T0oooo1Ol000030?ooo`80
0000403oool5o`0001@0oooo00<000000?ooo`3oool04@3oool5o`000140oooo0P0000020?ooo`Go
0000F`3oool005L0oooo1Ol000040?ooo`030000003oool0oooo00h0oooo1Ol0000F0?ooo`030000
003oool0oooo01<0oooo1_l0000@0?ooo`040000003oool0oooo0?ooo`Go0000F@3oool005H0oooo
1_l000030?ooo`030000003oool0oooo00/0oooo0P000005o`0000d0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo1Ol00003000000d0oooo
00@000000?ooo`3oool0oooo1Ol0001H0?ooo`00EP3oool=o`00008000000P3oool4000000<0oooo
1?l0000?0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool4o`0000@0oooo
100000020?ooo`8000003?l0001H0?ooo`00E@3oool3o`000080oooo00<00000o`000?l000003Ol0
00020?ooo`Co0000403oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00d0oooo1?l0
00030?ooo`oo000000<000000?ooool000000_l0001G0?ooo`00E03oool3o`0000<0oooo00<00000
0?ooo`3oool01@3oool=o`0001d0oooo00<000000?ooo`3oool06P3oool>o`0000L0oooo00<00000
0?ooo`3oool00ol0001F0?ooo`00E03oool2o`0000<0oooo00<000000?ooo`3oool03@3oool7o`00
01`0oooo00<000000?ooo`3oool06@3oool8o`0000l0oooo00<000000?ooo`3oool00_l0001F0?oo
o`00D`3oool3o`0000<0oooo00<000000?ooo`3oool03P3oool7o`0000d0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo1ol0000A0?ooo`03
0000003oool0oooo00?o0000E@3oool00580oooo0ol0000D0?ooo`?o000000<000000?ooo`3oool0
1?l0000:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`070?ooo`Co00000`3oool3o`0001@0oooo0ol0001D0?ooo`00D@3oool3o`0001@0oooo0ol0
00000`000000oooo0?ooo`020?ooo`Go00001`3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo00@0oooo1Ol000050?ooo`?o0000503oool3o`0005<0oooo001A0?ooo`;o0000103oool0
0`000000oooo0?ooo`0>0?ooo`;o0000203oool5o`0002X0oooo1Ol000080?ooo`;o00004@3oool0
10000000oooo0?ooo`3oool2o`0005<0oooo001@0?ooo`?o00000`3oool00`000000oooo0?ooo`0>
0?ooo`?o00002P3oool5o`0002H0oooo1Ol0000:0?ooo`?o00004@3oool00`000000oooo0?ooo`03
o`000580oooo001?0?ooo`?o00000`3oool00`000000oooo0?ooo`0>0?ooo`?o000000<000000?oo
o`3oool02P3oool4o`0000030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool4o`00
00d0oooo0ol0000A0?ooo`030000003oool0oooo00?o0000D@3oool004l0oooo0_l0000E0?ooo`;o
000000<000000?ooo`3oool03@3oool4o`000100oooo00<000000?ooo`3oool03@3oool4o`000100
oooo0_l0000E0?ooo`;o0000D@3oool004h0oooo0ol0000D0?ooo`?o0000403oool00`00003o0000
o`000003o`0000h0oooo00<000000?ooo`3oool02`3oool5o`0000<000003P3oool3o`0001@0oooo
0ol0001@0?ooo`00C@3oool3o`0000<0oooo00<000000?ooo`3oool03P3oool3o`0000l0oooo0P00
00000`3oool000000?ooo`05o`0001P0oooo1Ol000020?ooo`040000003oool0oooo000000h0oooo
0ol0000A0?ooo`030000003oool0oooo00?o0000C`3oool004d0oooo0_l000040?ooo`030000003o
ool0oooo00d0oooo0ol0000C0?ooo`040000003oool0oooo0?ooo`Co00005P3oool4o`0000@0oooo
00<000000?ooo`3oool0403oool3o`000100oooo00@000000?ooo`3oool0oooo0_l0001?0?ooo`00
C03oool3o`0000<0oooo00<000000?ooo`3oool03P3oool2o`0000030000003oool0oooo00X0oooo
0P0000050?ooo`030000003oool0oooo00<0oooo1?l0000B0?ooo`Co00001P3oool00`000000oooo
0?ooo`030?ooo`8000002`3oool00`00003o0000o`00000A0?ooo`030000003oool0oooo00?o0000
CP3oool004/0oooo0ol0000D0?ooo`?o000000<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0<0?ooo`Go00001`3oool00ol00000oooo0?ooo`040?ooo`Go00003`3oool00`000000oooo0?oo
o`090?ooo`?o0000503oool3o`0004d0oooo001:0?ooo`?o0000503oool3o`0000030000003oool0
oooo01/0oooo1Ol000050?ooo`03o`00003oool0oooo0080oooo1Ol0000N0?ooo`?o0000503oool3
o`0004`0oooo001:0?ooo`;o0000103oool00`000000oooo0?ooo`0>0?ooo`;o00002P3oool20000
00X0oooo00<000000?ooo`3oool0203oool5o`000080oooo00@000000?ooo`000000oooo1Ol0000;
0?ooo`030000003oool0oooo00P0oooo0`0000080?ooo`;o00004@3oool010000000oooo0?ooo`3o
ool2o`0004`0oooo00190?ooo`?o00000`3oool00`000000oooo0?ooo`0>0?ooo`?o0000203oool2
000000`0oooo00<000000?ooo`3oool02P3oool4o`0000040000003oool0oooo0?ooo`Co00003@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo0ol0000A0?ooo`030000003o
ool0oooo00?o0000B`3oool004P0oooo0ol000030?ooo`030000003oool0oooo00h0oooo0ol00000
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00`0oooo2?l0000?0?ooo`030000003oool0
oooo01@0oooo0ol0000A0?ooo`030000003oool0oooo00?o0000BP3oool004P0oooo0_l0000D0?oo
o`?o000000<000000?ooo`3oool0103oool2000000l0oooo00<000000?ooo`3oool03@3oool6o`00
0100oooo00<000000?ooo`3oool03@3oool3000000D0oooo0ol0000D0?ooo`;o0000BP3oool004L0
oooo0ol0000D0?ooo`;o000000<000000?ooo`3oool00`3oool200000200oooo00<000000?ooo`3o
ool00_l000030?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool00`3oool2o`0001@0
oooo0ol000190?ooo`00AP3oool3o`0000<0oooo00<000000?ooo`3oool03P3oool3o`0002P0oooo
00<000000?ooool000000ol000020?ooo`030000003oool0oooo02D0oooo0ol0000A0?ooo`030000
003oool0oooo00?o0000B03oool004H0oooo0_l000040?ooo`030000003oool0oooo00d0oooo0ol0
00030?ooo`8000005@3oool00`000000oooo0?ooo`0;0?ooo`030000003ooooo000000Go00000P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01<0oooo0P0000020?ooo`?o0000403o
ool010000000oooo0?ooo`3oool2o`0004P0oooo00150?ooo`?o00000`3oool00`000000oooo0?oo
o`0>0?ooo`;o000000@000000?ooo`3oool000005`3oool00`000000oooo0?ooo`0=0?ooo`;o0000
0P3oool2o`000100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`02o`000140oooo
00<000000?ooo`3oool00ol000170?ooo`00A03oool3o`0001@0oooo0ol000000`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo00`0oooo0ol000020?ooo`?o00003`3oool00`000000oooo0?oo
o`0H0?ooo`?o0000503oool3o`0004H0oooo00130?ooo`?o0000503oool3o`00000300000?l00000
oooo01T0oooo00<000000?ooo`3oool02@3oool00`000000ooooo`000002o`0000@0oooo0ol00002
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0603oool4o`0001@0oooo0ol00015
0?ooo`00@`3oool2o`0000@0oooo00<000000?ooo`3oool02P3oool2000000060?ooool0003o0000
o`00003oool000009P3oool00`000000ooooo`000002o`0000H0oooo0ol000020?ooo`030000003o
ool0oooo02@0oooo00@00000o`000?l0003o00000P3oool3000000/0oooo00@000000?ooo`3oool0
oooo0_l000150?ooo`00@P3oool3o`0000<0oooo00<000000?ooo`3oool02@3oool2000000<0oooo
0_l000020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool00_l000080?ooo`;o0000
0`3oool00`000000oooo0?ooo`0S0?ooo`040000003ooooo0000o`0000D0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`03o`0004@0oooo00110?ooo`Co00000P3oool00`000000oooo
0?ooo`040?ooo`@000001P3oool3o`000080oooo00<000000?ooo`3oool09@3oool3o`0000P0oooo
0ol0000X0?ooo`030000003ooooo000000;o00001`3oool4000000H0oooo00<000000?ooool00000
0ol000130?ooo`00@@3oool8o`0000<000002`3oool3o`0001l0oooo00<000000?ooo`3oool0203o
ool3o`0000X0oooo0ol0000;0?ooo`030000003oool0oooo01`0oooo0ol0000<0?ooo`8000002?l0
00130?ooo`00@@3oool2o`0000030?ooool0003o000000Oo00002P3oool2o`000200oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`02o`0000`0oooo0_l000030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool07@3oool2o`0000X0oooo2Ol000000`3ooooo0000o`000013
0?ooo`00@@3oool2o`0000<0oooo00<000000?ooool000001ol000060?ooo`?o0000803oool00`00
0000oooo0?ooo`050?ooo`030000003ooooo000000;o0000303oool3o`000080oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0M0?ooo`?o00001P3oool8o`000080oooo00<000000?oo
o`3oool00_l000130?ooo`00@@3oool2o`0000<0oooo00<000000?ooo`3oool00`3oool8o`000004
0?ooool0003o0000o`0000D0oooo00<000000?ooo`3oool0803oool00`000000ooooo`000002o`00
00h0oooo0ol000020?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool00P3oool3o`00
00030?ooool0003o000000Ko00001P3oool00`000000oooo0?ooo`02o`0004<0oooo00110?ooo`;o
0000303oool8o`0000H0oooo00<000000?ooo`3oool08P3oool2o`000100oooo0_l0000U0?ooo`03
0000003oool0oooo00<0oooo2?l0000<0?ooo`;o0000@`3oool00440oooo0_l0000@0?ooo`Ko0000
103oool00`000000oooo0?ooo`0Q0?ooo`?o0000403oool3o`0002@0oooo00@000000?ooo`3oool0
oooo1_l0000@0?ooo`;o0000@`3oool00440oooo0_l0000A0?ooo`Ko00007`3oool00`000000oooo
0?ooo`020?ooo`030000003ooooo000000;o00004P3oool3o`000080oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0L0?ooo`Ko00004@3oool2o`0004<0oooo00110?ooo`;o00000`3o
ool00`000000oooo0?ooo`0;0?ooo`;o00000P3oool4o`0001d0oooo00H000000?ooo`3oool0oooo
0000003oool3o`0001@0oooo0ol000020?ooo`050000003oool0oooo0?ooo`000000703oool4o`00
0080oooo0_l0000=0?ooo`040000003oool0oooo0?ooo`;o0000@`3oool00440oooo0_l000030?oo
o`030000003oool0oooo00/0oooo0_l000030?ooo`Go00006`3oool010000000oooo0?ooo`000002
0?ooo`;o00005P3oool2o`0000<0oooo00@000000?ooo`3oool000006P3oool5o`0000<0oooo0_l0
000=0?ooo`040000003oool0oooo0?ooo`;o0000@`3oool00440oooo0ol000030?ooo`030000003o
ool0oooo00X0oooo0_l000050?ooo`Co00006P3oool00`000000oooo0?ooo`020?ooo`?o00005P3o
ool3o`0000D0oooo00<000000?ooo`3oool05`3oool4o`0000D0oooo0_l0000=0?ooo`030000003o
ool0oooo00?o0000@`3oool00480oooo0_l0000@0?ooo`;o00001`3oool4o`0001`0oooo0ol0000H
0?ooo`?o0000703oool4o`0000030000003oool0oooo00@0oooo0_l0000@0?ooo`;o0000A03oool0
0480oooo0_l0000@0?ooo`;o00001`3oool00`00003o0000o`000003o`0001L0oooo00?o00000?oo
o`3oool00_l0000J0?ooo`;o00000`3oool00ol00000oooo0?ooo`0D0?ooo`Go000000<0oooo0000
003oool01@3oool2o`000100oooo0_l000140?ooo`00@P3oool2o`000100oooo0_l000070?ooo`03
0000003oool0oooo00Co00005@3oool00ol00000oooo0?ooo`03o`0001X0oooo0ol000030?ooo`03
o`00003oool0oooo0180oooo1?l000030?ooo`030000003oool0oooo00@0oooo0_l0000@0?ooo`;o
0000A03oool00480oooo0_l000030?ooo`030000003oool0oooo00X0oooo0_l0000<0?ooo`Co0000
4P3oool2000000040?ooool0003o0000o`0001`0oooo0ol000020?ooo`8000004@3oool4o`0000`0
oooo0_l0000=0?ooo`030000003oool0oooo00;o0000A03oool00480oooo0_l000030?ooo`030000
003oool0oooo00X0oooo0_l0000=0?ooo`Go00003`3oool010000000oooo0?ooo`000002o`0001h0
oooo0_l000001@3oool000000?ooo`3oool0000000h0oooo1Ol0000=0?ooo`;o00003@3oool00`00
0000oooo0?ooo`02o`0004@0oooo00120?ooo`;o00000`3oool00`000000oooo0?ooo`0:0?ooo`;o
00001`3oool00`000000oooo0?ooo`050?ooo`Co00004@3oool3o`0001h0oooo0ol0000A0?ooo`Co
0000203oool00`000000oooo0?ooo`040?ooo`;o00003@3oool00`000000oooo0?ooo`02o`0004@0
oooo00120?ooo`;o00000`3oool00`000000oooo0?ooo`0:0?ooo`;o00001`3oool00`000000oooo
0?ooo`070?ooo`Co0000203oool2000000@0oooo0ol0000P0?ooo`?o00001@3oool3000000H0oooo
1?l0000:0?ooo`030000003oool0oooo00@0oooo0_l0000=0?ooo`030000003oool0oooo00;o0000
A03oool00480oooo0_l0000@0?ooo`;o00001`3oool00`000000oooo0?ooo`080?ooo`Go0000103o
ool2000000H0oooo0_l0000R0?ooo`;o0000203oool010000000oooo0?ooo`3oool5o`0000/0oooo
00<000000?ooo`3oool0103oool2o`000100oooo0_l000140?ooo`00@P3oool2o`000100oooo0_l0
00070?ooo`030000003oool0oooo00X0oooo1?l0000:0?ooo`?o00000P3oool00`000000oooo0?oo
o`0K0?ooo`030000003ooooo000000;o00002P3oool4o`0000d0oooo00<000000?ooo`3oool0103o
ool2o`000100oooo0_l000140?ooo`00@P3oool2o`0000<0oooo00<000000?ooo`3oool02P3oool2
o`0001H0oooo1?l000070?ooo`?o00000`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00?o00001`3oool4o`0001H0oooo0_l0000=0?ooo`030000003oool0oooo00;o0000A03oool0
0480oooo0_l000030?ooo`030000003oool0oooo00X0oooo0_l0000F0?ooo`0300000?l0003o0000
00?o0000103oool3o`0000D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`020?oo
o`?o0000103oool5o`0000030?ooo`000000oooo01@0oooo0_l0000=0?ooo`030000003oool0oooo
00;o0000A03oool00480oooo0_l000030?ooo`030000003oool0oooo00X0oooo0_l000070?ooo`03
0000003oool0oooo00l0oooo1?l000030?ooo`;o0000:03oool2o`0000<0oooo1?l0000A0?ooo`03
0000003oool0oooo00D0oooo0_l0000=0?ooo`030000003oool0oooo00;o0000A03oool00480oooo
0_l000030?ooo`030000003oool0oooo00X0oooo0_l000070?ooo`030000003oool0oooo00P0oooo
0P0000070?ooo`Oo0000:03oool7o`0000P0oooo0P0000090?ooo`030000003oool0oooo00D0oooo
0_l0000=0?ooo`030000003oool0oooo00;o0000A03oool00480oooo0_l0000@0?ooo`?o00001`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo1Ol000090?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool01P3oool5o`0000/0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`040?ooo`?o0000403oool2o`0004@0oooo00120?ooo`;o00004@3oool2
o`0000L0oooo00<000000?ooo`3oool04`3oool2o`0000/0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`080?ooo`;o00005P3oool00`000000oooo0?ooo`040?ooo`;o00004@3oool2
o`0004@0oooo00120?ooo`;o00000`3oool00`000000oooo0?ooo`0;0?ooo`;o0000303oool20000
00l0oooo0ol0000;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0203oool3o`00
0100oooo0`00000:0?ooo`;o00003P3oool00`000000oooo0?ooo`02o`0004@0oooo00120?ooo`?o
00000P3oool00`000000oooo0?ooo`0;0?ooo`;o00002P3oool200000140oooo1?l0000X0?ooo`Co
00004`3oool00`000000oooo0?ooo`070?ooo`;o00003P3oool00`000000ooooo`000002o`0004@0
oooo00130?ooo`;o00000P3oool00`000000oooo0?ooo`0;0?ooo`;o00001`3oool00ol00000oooo
0?ooo`0C0?ooo`Go00009P3oool5o`0001H0oooo00?o00000?ooo`3oool0103oool2o`0000h0oooo
00@000000?ooool0003o0000A@3oool004<0oooo0_l000020?ooo`030000003oool0oooo00/0oooo
0_l000060?ooo`0300000?l00000oooo01@0oooo0_l000000`3ooooo0000o`00000;0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0203oool2o`0000030?ooool0003o000001H0oooo
00?o0000000000000000103oool2o`0000h0oooo00@000000?ooool0003o0000A@3oool004<0oooo
0_l0000@0?ooo`;o0000103oool2000000030?ooo`000000oooo01@0oooo0_l00000103ooooo0000
o`000?l0000;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool3o`000003
0?ooool0003o000001H0oooo00@000000?ooo`3oool000000`3oool2o`000100oooo0_l000150?oo
o`00@`3oool2o`000100oooo0_l00002000000H0oooo00<000000?ooo`3oool04P3oool2o`000080
oooo0ol0000;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool3o`000080
oooo0_l0000E0?ooo`030000003oool0oooo00@0oooo00@00000o`000?l0000000003`3oool2o`00
04D0oooo00130?ooo`;o00000P3oool00`000000oooo0?ooo`070?ooo`8000000P3oool2o`0001d0
oooo0_l000030?ooo`;o00008P3oool2o`0000<0oooo0_l0000M0?ooo`;o00000`3oool3000000P0
oooo00@000000?ooool0003o0000A@3oool004<0oooo0_l000020?ooo`040000003oool0oooo0?oo
o`8000000P3oool2000000@0oooo0_l0000M0?ooo`;o00000`3oool3o`000200oooo0ol000030?oo
o`;o00007@3oool2o`0000H0oooo00<000000?ooo`3oool00`0000020?ooo`040000003ooooo0000
o`0004D0oooo00130?ooo`;o00000P3oool4000000X0oooo0_l0000:0?ooo`030000003oool0oooo
0100oooo0_l000040?ooo`?o00002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00P0oooo0ol000040?ooo`;o00004`3oool00`000000oooo0?ooo`070?ooo`;o0000303oool40000
00;o0000A@3oool004<0oooo0ol000000`000000oooo0000000<0?ooo`;o00002`3oool00`000000
oooo0?ooo`0?0?ooo`;o00001@3oool3o`0000X0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`?o00001@3oool2o`000180oooo00<000000?ooo`3oool0203oool2o`0000d0
oooo00<000000?ooool000000_l000150?ooo`00@`3oool6o`0000030000003oool0oooo00T0oooo
0_l0000<0?ooo`030000003oool0oooo00h0oooo0_l000060?ooo`;o00002`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00P0oooo0_l000060?ooo`;o00004@3oool00`000000oooo
0?ooo`090?ooo`;o0000303oool6o`0004D0oooo00130?ooo`So00002P3oool2o`0001d0oooo0_l0
00060?ooo`?o00006P3oool3o`0000H0oooo0_l0000M0?ooo`;o00002P3oool8o`0004D0oooo0014
0?ooo`?o000000<0ooooo`000?l000001?l000070?ooo`;o00007@3oool2o`0000L0oooo0ol0000H
0?ooo`?o00001`3oool2o`0001d0oooo0_l000070?ooo`Ko000000@0ooooo`000?l0003o0000AP3o
ool004D0oooo0_l000030?ooo`Oo0000103oool2o`0000h0oooo00<000000?ooo`3oool0303oool2
o`0000P0oooo0_l0000;0?ooo`03o`00003ooooo000000X0oooo0_l000080?ooo`;o00003`3oool0
0`000000oooo0?ooo`0;0?ooo`;o0000103oool7o`0000<0oooo0_l000170?ooo`00A@3oool3o`00
00<0oooo00<000000?ooool000001Ol000020?ooo`;o00003`3oool00`000000oooo0?ooo`0;0?oo
o`;o0000203oool3o`0000X0oooo00<00000o`00000000002@3oool3o`0000P0oooo0_l0000>0?oo
o`030000003oool0oooo00`0oooo0_l000020?ooo`Ko00000P3oool00`000000oooo0?ooo`03o`00
04L0oooo00160?ooo`?o00000`3oool010000000oooo0?ooo`3oool7o`000100oooo00<000000?oo
o`3oool02P3oool2o`0000T0oooo0ol000080?ooo`050000003oool0oooo0?ooo`0000001`3oool3
o`0000T0oooo0_l0000=0?ooo`030000003oool0oooo00d0oooo1ol000040?ooo`030000003oool0
oooo00?o0000B03oool004L0oooo0ol000030?ooo`030000003oool0oooo0080oooo1_l0000L0?oo
o`;o00002P3oool3o`000180oooo0ol0000:0?ooo`;o0000703oool6o`0000D0oooo00<000000?oo
o`3oool00ol000190?ooo`00B03oool2o`0000/0oooo1?l0000K0?ooo`;o00002`3oool2o`0000<0
oooo0P0000090?ooo`<0000000<0ooooo`000?l000002`3oool2o`0001/0oooo1?l0000;0?ooo`;o
0000BP3oool004P0oooo0ol000040?ooo`030000003oool0oooo00<0oooo1_l0000>0?ooo`030000
003oool0oooo00P0oooo0_l0000;0?ooo`?o00000P00000>0?ooo`?o00002`3oool2o`0000/0oooo
00<000000?ooo`3oool02`3oool6o`0000H0oooo00@000000?ooo`3oool0oooo0ol0001:0?ooo`00
B@3oool3o`0000<0oooo00<000000?ooo`3oool0103oool7o`0000`0oooo00<000000?ooo`3oool0
203oool2o`0000`0oooo0ol0000>0?ooo`?o0000303oool2o`0000/0oooo00<000000?ooo`3oool0
2@3oool7o`0000L0oooo00<000000?ooo`3oool00ol0001;0?ooo`00BP3oool2o`0000@0oooo00<0
00000?ooo`3oool0103oool7o`0000`0oooo00<000000?ooo`3oool01`3oool2o`0000X0oooo0P00
00000`3ooooo0000o`00000>0?ooo`;o00000P3oool2000000T0oooo0_l0000:0?ooo`030000003o
ool0oooo00T0oooo1ol000070?ooo`040000003oool0oooo0?ooo`;o0000C03oool004X0oooo0ol0
00040?ooo`030000003oool0oooo00@0oooo0_l000020?ooo`Co0000503oool2o`0000T0oooo00@0
00000?ooo`3oool0oooo0ol0000<0?ooo`?o0000103oool00`000000oooo0?ooo`060?ooo`;o0000
503oool4o`000080oooo0_l000070?ooo`040000003oool0oooo0?ooo`?o0000C03oool004/0oooo
0ol0000:0?ooo`?o00000P3oool5o`000180oooo0_l0000>0?ooo`?o00002P3oool3o`0000h0oooo
0_l0000B0?ooo`Go00000P3oool3o`0000X0oooo0ol0001=0?ooo`00C03oool2o`0000D0oooo00<0
00000?ooo`3oool00`3oool3o`0000<0oooo1?l000090?ooo`030000003oool0oooo00D0oooo0_l0
00050?ooo`800000203oool3o`0000P0oooo0ol000090?ooo`800000103oool2o`0000P0oooo00<0
00000?ooo`3oool01P3oool4o`0000<0oooo0ol000060?ooo`030000003oool0oooo0080oooo0_l0
001>0?ooo`00C03oool3o`0000@0oooo00<000000?ooo`3oool0103oool3o`0000@0oooo1?l00008
0?ooo`030000003oool0oooo00@0oooo0_l000040?ooo`030000003oool0oooo00T0oooo0_l00008
0?ooo`;o0000303oool010000000oooo0?ooo`3oool2o`0000L0oooo00<000000?ooo`3oool01@3o
ool4o`0000@0oooo0ol000070?ooo`040000003oool0oooo0?ooo`?o0000CP3oool004d0oooo0ol0
00040?ooo`030000003oool0oooo00@0oooo0ol000040?ooo`Go00001`3oool00`000000oooo0?oo
o`030?ooo`;o0000403oool3o`0000H0oooo0ol0000@0?ooo`;o00001P3oool00`000000oooo0?oo
o`040?ooo`Go0000103oool3o`0000L0oooo00@000000?ooo`3oool0oooo0ol0001?0?ooo`00CP3o
ool3o`0000<0oooo00<000000?ooo`3oool01@3oool2o`0000H0oooo1?l0000<0?ooo`;o00000P00
000?0?ooo`?o0000103oool3o`000100oooo00<00000o`000?l00000303oool4o`0000H0oooo0_l0
00080?ooo`030000003oool0oooo00?o0000D03oool004l0oooo0_l0000;0?ooo`?o00001`3oool4
o`0000X0oooo0_l0000B0?ooo`;o0000103oool2o`000180oooo0_l0000:0?ooo`Co00001`3oool3
o`0000/0oooo0_l0001A0?ooo`00C`3oool3o`0000@0oooo00<000000?ooo`3oool0103oool3o`00
00L0oooo1?l000050?ooo`040000003oool0oooo0?ooo`;o00004P3oool3o`000080oooo0ol0000B
0?ooo`;o000000D000000?ooo`3oool0oooo000000040?ooo`Co00001`3oool3o`0000L0oooo00@0
00000?ooo`3oool0oooo0ol0001A0?ooo`00D03oool3o`0000<0oooo00<000000?ooo`3oool01@3o
ool3o`0000P0oooo1?l000030?ooo`0400000?l00000oooo0?ooo`;o00004`3oool6o`0001<0oooo
0_l000030?ooo`04o`0000000000oooo0?ooo`Co0000203oool3o`0000P0oooo00<000000?ooo`3o
ool00ol0001B0?ooo`00D@3oool2o`0000@0oooo00<000000?ooo`3oool01@3oool2o`0000T0oooo
1Ol00004000000030?ooool0003o000001@0oooo1?l0000D0?ooo`;o00000P3oool3000000Go0000
2@3oool2o`0000P0oooo00@000000?ooo`3oool0oooo0_l0001C0?ooo`00D@3oool3o`0000@0oooo
00<000000?ooo`3oool0103oool3o`0000P0oooo0P000004o`0000<0oooo00<00000o`000?l00000
5@3oool2o`0001D0oooo0_l00000103oool000000?ooo`3oool4o`0000040?ooo`00000000000000
00H0oooo0ol000070?ooo`040000003oool0oooo0?ooo`?o0000D`3oool00580oooo0ol0000;0?oo
o`?o00001@3oool2000000@0oooo1?l000020?ooo`;o00005@3oool2o`0001D0oooo0_l000020?oo
o`Co00001P3oool00`000000oooo0?ooo`020?ooo`?o00002`3oool3o`0005@0oooo001C0?ooo`;o
00001@3oool00`000000oooo0?ooo`040?ooo`?o00000P0000090?ooo`Oo00000`00000B0?ooo`;o
0000503oool00`00003o0000o`000005o`0000X0oooo00@00000o`000?l0003o00001`3oool00`00
0000oooo0?ooo`020?ooo`;o0000E@3oool005<0oooo0ol000050?ooo`030000003oool0oooo00@0
oooo0_l0000=0?ooo`Go00000`3oool00`000000oooo0?ooo`0?0?ooo`;o00004P3oool200000003
0?ooool0003o000000?o00003@3oool2o`0000L0oooo00<000000?ooo`3oool00P3oool3o`0005D0
oooo001D0?ooo`?o00001@3oool010000000oooo0000000000020?ooo`?o00003P3oool3o`0001D0
oooo0_l0000E0?ooo`?o00003P3oool3o`0000<0oooo0P0000000`3oool000000?ooo`030?ooo`?o
0000EP3oool005D0oooo0ol000040?ooo`8000001@3oool3o`0000h0oooo0_l000060?ooo`800000
3@3oool2o`0000h0oooo0P0000050?ooo`;o00003P3oool3o`0000H0oooo0P0000030?ooo`?o0000
E`3oool005H0oooo0_l000030?ooo`040000003oool0oooo000000D0oooo0ol0000=0?ooo`?o0000
1`3oool00`000000oooo0?ooo`0:0?ooo`;o00003@3oool00`000000oooo0?ooo`040?ooo`?o0000
3@3oool3o`0000H0oooo00@000000?ooo`3oool000000P3oool2o`0005P0oooo001F0?ooo`?o0000
00<0oooo0000003oool02@3oool2o`0000h0oooo0ol0000C0?ooo`;o00004`3oool3o`0000h0oooo
0_l0000;0?ooo`0400000?l0003o0000o`0005P0oooo001G0?ooo`Co00001P3oool200000080oooo
0ol0000>0?ooo`?o0000203oool00`000000oooo0?ooo`070?ooo`;o00002P3oool00`000000oooo
0?ooo`050?ooo`?o00003P3oool3o`0000<0oooo0P0000050?ooo`Co0000F@3oool005P0oooo1_l0
00050?ooo`030000003oool0oooo00?o00003P3oool2o`0000T0oooo00<000000?ooo`3oool01P3o
ool2o`0000T0oooo00<000000?ooo`3oool01P3oool2o`0000h0oooo0ol000030?ooo`030000003o
ool0oooo0080oooo1_l0001J0?ooo`00FP3oool7o`0000<0oooo00<000000?ooo`3oool00ol0000=
0?ooo`?o00002@3oool00`000000oooo0?ooo`050?ooo`;o0000203oool00`000000oooo0?ooo`06
0?ooo`?o00003@3oool3o`0000<0oooo00<000000?ooo`3oool01ol0001L0?ooo`00G03oool8o`00
00@0oooo0ol0000=0?ooo`?o00002`3oool00`000000oooo0?ooo`020?ooo`;o0000103oool20000
00X0oooo0ol0000=0?ooo`?o0000103oool8o`0005h0oooo001M0?ooo`[o00000P000002o`0000h0
oooo0ol0000;0?ooo`040000003oool0oooo0?ooo`;o00000`3oool00`000000oooo0?ooo`090?oo
o`?o00003P3oool2o`000080oooo2_l0001O0?ooo`00G`3oool=o`0000h0oooo0_l0000<0?ooo`03
0000003oool0oooo00;o00000P3oool00`000000oooo0?ooo`0:0?ooo`;o00003P3oool=o`000640
oooo001Q0?ooo`Co000000<0ooooo`000?l000001Ol0000=0?ooo`?o00003P3oool2o`0000h0oooo
0ol0000=0?ooo`Oo000000<0ooooo`000?l000000_l0001S0?ooo`00HP3oool5o`000080oooo1_l0
000<0?ooo`?o00003@3oool2o`00008000002`3oool3o`0000`0oooo1_l000020?ooo`Go0000I03o
ool006@0oooo1?l000040?ooo`Co0000303oool3o`0000X0oooo0P000002o`000080oooo00<00000
0?ooo`3oool01`3oool3o`0000`0oooo1?l000040?ooo`Co0000IP3oool006H0oooo1?l000040?oo
o`Co00002`3oool2o`0000H0oooo0P0000040?ooo`;o00001@3oool2000000D0oooo0_l0000;0?oo
o`Co0000103oool4o`0006P0oooo001W0?ooo`Go00000`3oool4o`0000X0oooo0ol000040?ooo`03
0000003oool0oooo00@0oooo0_l000070?ooo`040000003oool0oooo0?ooo`?o00002P3oool4o`00
00<0oooo1Ol0001Y0?ooo`00J@3oool4o`0000@0oooo1?l000090?ooo`?o00002P3oool2o`0000X0
oooo0ol000090?ooo`Co0000103oool4o`0006/0oooo001[0?ooo`Co00000`3oool5o`0000L0oooo
00@00000o`000?l0003o00002@3oool2o`0000T0oooo0ol000000`3oool000000?ooo`050?ooo`Go
00000`3oool4o`0006d0oooo001/0?ooo`Go00000`3oool4o`000080oooo0P0000040?ooo`;o0000
2@3oool2o`0000T0oooo0_l000050?ooo`<000001?l000030?ooo`Go0000KP3oool006h0oooo1?l0
00040?ooo`Co00001P3oool3o`0000P0oooo0_l000080?ooo`?o00001P3oool4o`0000@0oooo1?l0
001`0?ooo`00L03oool4o`0000<0oooo1?l000060?ooo`?o00001`3oool2o`0000L0oooo0ol00006
0?ooo`Co00000`3oool4o`000780oooo001a0?ooo`Go000000<0oooo0000003oool01?l000050?oo
o`;o00001`3oool2o`0000L0oooo0_l000050?ooo`Co00000P3oool00`00003o0000o`000003o`00
07<0oooo001c0?ooo`Co000000<000000?ooo`3oool01?l0000200000080oooo0ol000060?ooo`;o
00001P3oool3o`0000@0oooo1?l000030?ooo`Co0000M@3oool007D0oooo1?l000030?ooo`Co0000
00<000000?ooo`3oool00ol000050?ooo`;o00001@3oool3o`0000<0oooo1?l000030?ooo`Co0000
M`3oool007H0oooo1_l000000`3ooooo0000o`000002o`000080oooo00@00000o`000?l0003o0000
103oool2o`0000@0oooo0ol00002000000030?ooool0003o000000;o000000<0ooooo`000?l00000
1?l0001h0?ooo`00N03oool6o`0000030?ooool0003o000000;o00000P3oool2o`0000@0oooo0_l0
00040?ooo`;o000000<000000?ooool000000ol000000`3ooooo0000o`000004o`0007X0oooo001k
0?ooo`Wo000000D0ooooo`000?l0003o00000?ooo`02000000;o000000<0oooo0000000000000ol0
00000`3ooooo0000o`000007o`0007d0oooo001m0?ooo`co00000P3oool2o`0000030000003ooooo
000000_o0000O`3oool007l0oooo2ol00000103ooooo0000o`00003oool;o`000840oooo00220?oo
o`So000000@0ooooo`000?l00000oooo2?l000240?ooo`00Q03oool@o`0008H0oooo00260?ooo`co
0000R03oool008T0oooo1_l0002;0?ooo`00R`3oool2o`0008d0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oo
oa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo003o0?oooa/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Do[ vp=circle[a,10,2];
\tShow[skel3D[getUserViewPoint[vp, skel3D[{0,0,0}]]], 
\t\tBoxed->False, 
 \t\tViewPoint -> vp, SphericalRegion->True
 \t],
 \t{a,Pi/11,Pi,Pi/18}
 ]
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->8.28333,
  AnimationCycleOffset->1.0625,
  AnimationCycleRepetitions->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.47129 .55236 m
.57036 .61872 L
s
.47129 .55236 m
.37994 .61507 L
s
.57005 .47538 m
.47129 .55236 L
s
.38047 .4713 m
.47129 .55236 L
s
.57005 .47538 m
.66999 .54137 L
s
.62079 .38492 m
.57005 .47538 L
s
.47955 .39373 m
.57005 .47538 L
s
.38047 .4713 m
.28774 .53354 L
s
.47955 .39373 m
.38047 .4713 L
s
.34944 .37868 m
.38047 .4713 L
s
.57036 .61872 m
.62188 .67544 L
s
.57036 .61872 m
.47937 .68249 L
s
.66999 .54137 m
.57036 .61872 L
s
.52951 .30184 m
.47955 .39373 L
s
.44974 .2999 m
.47955 .39373 L
s
.66999 .54137 m
.72324 .59696 L
s
.72224 .45108 m
.66999 .54137 L
s
.37994 .61507 m
.47937 .68249 L
s
.37994 .61507 m
.34808 .67043 L
s
.28774 .53354 m
.37994 .61507 L
s
.62079 .38492 m
.72224 .45108 L
s
.52951 .30184 m
.62079 .38492 L
s
.59263 .29038 m
.62079 .38492 L
s
.28774 .53354 m
.25409 .58777 L
s
.2552 .44082 m
.28774 .53354 L
s
.47937 .68249 m
.52991 .74082 L
s
.47937 .68249 m
.44905 .73943 L
s
.34944 .37868 m
.2552 .44082 L
s
.39841 .28561 m
.34944 .37868 L
s
.44974 .2999 m
.34944 .37868 L
s
.5 .20569 m
.52951 .30184 L
s
.5 .20569 m
.44974 .2999 L
s
.72224 .45108 m
.77698 .50584 L
s
.69522 .35676 m
.72224 .45108 L
s
.62188 .67544 m
.5939 .73261 L
s
.62188 .67544 m
.52991 .74082 L
s
.72324 .59696 m
.62188 .67544 L
s
.72324 .59696 m
.69701 .65286 L
s
.77698 .50584 m
.72324 .59696 L
s
.59263 .29038 m
.69522 .35676 L
s
.5 .20569 m
.59263 .29038 L
s
.34808 .67043 m
.44905 .73943 L
s
.34808 .67043 m
.39701 .7292 L
s
.25409 .58777 m
.34808 .67043 L
s
.2552 .44082 m
.22051 .49411 L
s
.30353 .34756 m
.2552 .44082 L
s
.39841 .28561 m
.30353 .34756 L
s
.5 .20569 m
.39841 .28561 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.60251 .27185 L
s
.5 .20569 m
.5517 .25703 L
s
.5 .20569 m
.46957 .25497 L
s
.5 .20569 m
.40593 .26697 L
s
.25409 .58777 m
.30172 .64549 L
s
.22051 .49411 m
.25409 .58777 L
s
.0035 w
[ .01 .012 ] 0 setdash
.52991 .74082 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.69522 .35676 m
.75024 .41069 L
s
.60251 .27185 m
.69522 .35676 L
s
.0035 w
[ .01 .012 ] 0 setdash
.44905 .73943 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.77698 .50584 m
.7514 .56078 L
s
.75024 .41069 m
.77698 .50584 L
s
.60251 .27185 m
.65629 .32466 L
s
.30353 .34756 m
.2693 .3998 L
s
.40593 .26697 m
.30353 .34756 L
s
.5939 .73261 m
.5 .79975 L
s
.69701 .65286 m
.5939 .73261 L
s
.40593 .26697 m
.37347 .31787 L
s
.69701 .65286 m
.60394 .71934 L
s
.7514 .56078 m
.69701 .65286 L
s
.39701 .7292 m
.5 .79975 L
s
.30172 .64549 m
.39701 .7292 L
s
.22051 .49411 m
.26822 .55103 L
s
.2693 .3998 m
.22051 .49411 L
s
.5517 .25703 m
.65629 .32466 L
s
.5517 .25703 m
.5217 .30808 L
s
.30172 .64549 m
.40462 .71585 L
s
.26822 .55103 m
.30172 .64549 L
s
.46957 .25497 m
.5217 .30808 L
s
.46957 .25497 m
.37347 .31787 L
s
.75024 .41069 m
.72383 .46463 L
s
.65629 .32466 m
.75024 .41069 L
s
.55243 .70872 m
.5 .79975 L
s
.60394 .71934 m
.5 .79975 L
s
.40462 .71585 m
.5 .79975 L
s
.46914 .70725 m
.5 .79975 L
s
.65775 .62712 m
.60394 .71934 L
s
.7514 .56078 m
.65775 .62712 L
s
.72383 .46463 m
.7514 .56078 L
s
.65629 .32466 m
.628 .37732 L
s
.37228 .62168 m
.40462 .71585 L
s
.2693 .3998 m
.31843 .45581 L
s
.37347 .31787 m
.2693 .3998 L
s
.37347 .31787 m
.42451 .37261 L
s
.26822 .55103 m
.37228 .62168 L
s
.31843 .45581 m
.26822 .55103 L
s
.65775 .62712 m
.55243 .70872 L
s
.5219 .61383 m
.55243 .70872 L
s
.5219 .61383 m
.46914 .70725 L
s
.37228 .62168 m
.46914 .70725 L
s
.62861 .53088 m
.65775 .62712 L
s
.5217 .30808 m
.628 .37732 L
s
.5217 .30808 m
.42451 .37261 L
s
.72383 .46463 m
.62861 .53088 L
s
.628 .37732 m
.72383 .46463 L
s
.42415 .52666 m
.37228 .62168 L
s
.628 .37732 m
.53123 .44304 L
s
.31843 .45581 m
.42415 .52666 L
s
.42451 .37261 m
.31843 .45581 L
s
.62861 .53088 m
.5219 .61383 L
s
.42415 .52666 m
.5219 .61383 L
s
.42451 .37261 m
.53123 .44304 L
s
.53123 .44304 m
.62861 .53088 L
s
.53123 .44304 m
.42415 .52666 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003oo`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00o`3ooolK
0?ooo`00o`3ooolK0?ooo`00o`3ooolK0?ooo`00RP3oool4o`0008`0oooo00290?ooo`Ko0000R`3o
ool008L0oooo2_l000290?ooo`00QP3oool6o`0000030?ooool0003o000000?o0000R03oool008@0
oooo1?l000000`3ooooo0000o`0000030?ooo`Ko0000QP3oool008<0oooo1?l00000103ooooo0000
o`000?l000040?ooo`Ko0000Q@3oool00880oooo0ol000000`000000ooooo`000002o`0000@0oooo
00<000000?ooool000001_l000230?ooo`00P03oool4o`0000<0oooo0_l000000`000000oooo0?oo
o`020?ooo`030000003oool0oooo00Oo0000PP3oool007l0oooo1?l000030?ooo`?o00001P3oool0
0`000000oooo0?ooo`03o`0000030?ooool0003o000000;o0000P03oool007d0oooo1?l000000`00
0000oooo0?ooo`020?ooo`;o00001`3oool010000000oooo0?ooo`3oool3o`0000030?ooool0003o
000000?o0000OP3oool007`0oooo1?l000000`000000oooo0?ooo`020?ooo`?o0000303oool3o`00
0080oooo1?l0001m0?ooo`00NP3oool4o`0000H0oooo0ol0000>0?ooo`?o00000`3oool4o`0007/0
oooo001i0?ooo`Co000000<000000?ooo`3oool0103oool2o`0000030000003oool0oooo00L0oooo
00<000000?ooo`3oool00`3oool3o`0000<0oooo1?l0001j0?ooo`00M`3oool4o`0000030?ooo`00
0000oooo00D0oooo0ol0000:0?ooo`030000003oool0oooo00@0oooo0ol0000010000000oooo0?oo
o`3oool4o`0007P0oooo001f0?ooo`Co000000<0oooo0000003oool0103oool4o`0000030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool3o`0000040000003oool0oooo0?ooo`Co0000
M`3oool007D0oooo0ol000080?ooo`Go00002`3oool00`000000oooo0?ooo`060?ooo`Co0000103o
ool4o`0007D0oooo001c0?ooo`Co000000<0oooo000000000000103oool4o`0000040?ooool0003o
0000o`0001@0oooo1?l000040?ooo`Co0000M03oool00780oooo1?l00002000000D0oooo1?l00002
0?ooo`0400000?l0003o0000o`000180oooo1ol000040?ooo`Co0000LP3oool00700oooo1?l00007
0?ooo`Co0000103oool00`000000ooooo`000002o`0000T0oooo00<000000?ooo`3oool0103oool3
o`000080oooo1?l000040?ooo`Co0000L@3oool006l0oooo1?l000000`3oool000000?ooo`040?oo
o`Co0000103oool010000000oooo0?ooo`3oool3o`0000P0oooo00<000000?ooo`3oool0103oool2
o`0000D0oooo1?l000040?ooo`Co0000K`3oool006h0oooo1Ol000000`000000oooo0?ooo`020?oo
o`Co00002`3oool3o`0000P0oooo00<000000?ooo`3oool00P3oool3o`0000H0oooo1?l000040?oo
o`Co0000KP3oool006`0oooo1_l000000`000000oooo0?ooo`020?ooo`Co00003@3oool3o`0000L0
oooo00@000000?ooo`3oool0oooo0ol000090?ooo`Co00000`3oool4o`0006d0oooo001[0?ooo`Ko
0000103oool4o`0000L0oooo00<000000?ooo`3oool01P3oool3o`0000X0oooo0_l0000;0?ooo`Co
00000`3oool4o`0006`0oooo001Z0?ooo`?o000000<0ooooo`000?l00000103oool4o`0000P0oooo
00<000000?ooo`3oool01`3oool3o`0000P0oooo0ol0000=0?ooo`Co00000P3oool4o`0006/0oooo
001X0?ooo`Co000000@0ooooo`000?l0003o00000P3oool4o`0000T0oooo00<000000?ooo`3oool0
2@3oool3o`0000D0oooo00@000000?ooool0003o00003`3oool5o`0000030?ooool0003o000000;o
0000JP3oool006L0oooo1?l00000103ooooo0000o`000?l000020?ooo`Co00002P3oool00`000000
oooo0?ooo`0:0?ooo`?o0000103oool01000003o0000o`000?l0000?0?ooo`8000001?l000000`3o
oooo0000o`000002o`0006T0oooo001V0?ooo`?o000000<0oooo0000003oool00_l000000`3ooooo
0000o`000002o`0001X0oooo0ol000030?ooo`?o00004@3oool2000000030?ooool0003o000000Ko
0000J03oool006@0oooo1?l000000`3oool000000?ooo`07o`0000`0oooo00<000000?ooo`3oool0
3@3oool3o`000080oooo0_l0000B0?ooo`040000003oool0oooo0?ooo`So0000I`3oool006<0oooo
1?l000000`3oool000000?ooo`06o`0000d0oooo0P00000@0?ooo`Ko000000<000000?ooo`3oool0
5@3oool7o`0006H0oooo001R0?ooo`?o0000103oool6o`0000d0oooo00@000000?ooo`3oool00000
403oool4o`000080oooo00<000000?ooo`3oool05@3oool7o`0006D0oooo001Q0?ooo`?o00000P00
00030?ooo`Co00008P3oool6o`0001<0oooo00<000000?ooo`3oool01@3oool6o`0006@0oooo001O
0?ooo`Co000000<000000?ooo`3oool00P3oool4o`0000`0oooo0P00000C0?ooo`Co00000P3oool4
o`000140oooo00<000000?ooo`3oool01@3oool00`00003o0000o`000005o`000680oooo001N0?oo
o`Co0000103oool4o`0000d0oooo00<000000?ooo`3oool04P3oool4o`0000@0oooo1?l000000`3o
ool000000000000>0?ooo`030000003oool0oooo00L0oooo1_l0001Q0?ooo`00G@3oool3o`000003
0000003oool0oooo0080oooo1Ol0000F0?ooo`030000003oool0oooo00L0oooo1?l000030?ooo`03
0000003oool0oooo0080oooo1?l000000`3oool000000?ooo`0<0?ooo`030000003oool0oooo00P0
oooo1_l0001P0?ooo`00F`3oool4o`0000D0oooo0ol00000103ooooo0000o`000?l000090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool4o`0000@0oooo00<000000?ooo`3o
ool00`3oool4o`0001/0oooo1Ol0001O0?ooo`00FP3oool4o`0000D0oooo0ol000030?ooo`?o0000
1`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo1?l000050?ooo`030000
003oool0oooo00H0oooo1?l0000J0?ooo`Go0000GP3oool005T0oooo0ol000050?ooo`Co00000`3o
ool00`000000ooooo`000002o`0000D0oooo00<000000?ooo`3oool04@3oool4o`000100oooo1?l0
000<0?ooo`030000003oool0oooo00T0oooo1ol0001M0?ooo`00E`3oool4o`0000D0oooo1?l00007
0?ooo`?o00005P3oool4o`0001@0oooo1?l0000:0?ooo`030000003oool0oooo00T0oooo0_l00002
0?ooo`Co0000G03oool005H0oooo1?l000050?ooo`?o00002P3oool3o`0000030000003oool0oooo
0140oooo1?l000070?ooo`030000003oool0oooo00`0oooo1?l000090?ooo`030000003oool0oooo
00P0oooo0ol000030?ooo`Co0000F`3oool005D0oooo0ol000060?ooo`?o00001P3oool00`000000
oooo0?ooo`030?ooo`?o00004@3oool4o`0000T0oooo00<000000?ooo`3oool03P3oool4o`0000L0
oooo00<000000?ooo`3oool0203oool2o`0000D0oooo1?l0001J0?ooo`00E03oool3o`0000D0oooo
1?l000070?ooo`030000003oool0oooo00<0oooo00@00000o`000?l0003o00003`3oool4o`0000T0
oooo00<000000?ooo`3oool0403oool4o`000100oooo0ol000060?ooo`Co0000F@3oool005@0oooo
0_l000050?ooo`Co00001`3oool00`000000oooo0?ooo`060?ooo`?o0000303oool4o`0000030000
003oool0oooo00P0oooo00<000000?ooo`3oool04P3oool4o`0000h0oooo0_l000080?ooo`Co0000
F03oool005<0oooo0ol000040?ooo`?o0000203oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo0ol0000:0?ooo`Co00008P3oool4o`0000@0oooo00<000000?ooo`3oool01@3o
ool3o`0000T0oooo1?l0001G0?ooo`00DP3oool3o`0000<0oooo1?l0000=0?ooo`030000003oool0
oooo00D0oooo0ol000070?ooo`Co00009P3oool4o`000080oooo00<000000?ooo`3oool0103oool3
o`0000/0oooo1?l0001F0?ooo`00DP3oool2o`0000<0oooo1?l0000=0?ooo`030000003oool0oooo
00L0oooo0ol000050?ooo`Co00001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
01P0oooo1?l000020?ooo`030000003oool0oooo00<0oooo0_l0000=0?ooo`Co0000E@3oool00540
oooo0ol000020?ooo`?o00002`3oool00`000000oooo0?ooo`0<0?ooo`?o00000P3oool4o`0000L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0J0?ooo`Co000000<000000?ooo`3o
ool00P3oool3o`0000h0oooo1?l0001D0?ooo`00D03oool3o`000080oooo0ol0000<0?ooo`<00000
3@3oool7o`0000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0L0?ooo`Co0000
103oool2o`000100oooo1?l0001C0?ooo`00D03oool2o`00000300000?l0003o000000;o0000303o
ool200000100oooo1?l0000;0?ooo`030000003oool0oooo02@0oooo1?l00000103ooooo0000o`00
0?l0000A0?ooo`Co0000DP3oool004l0oooo1ol0000=0?ooo`030000003oool0oooo00h0oooo1_l0
000a0?ooo`0300000?l0003o000000Co0000503oool3o`000540oooo001>0?ooo`Ko00003@3oool2
00000100oooo0ol000020?ooo`Co0000303oool00`000000oooo0?ooo`0Q0?ooo`8000001?l0000C
0?ooo`030000003ooooo000000;o0000D03oool004h0oooo1Ol0000<0?ooo`80000000<0oooo0000
003oool03P3oool3o`0000@0oooo1?l000080?ooo`040000003oool0oooo000002@0oooo1_l0000B
0?ooo`030000003oool0oooo00?o0000C`3oool004d0oooo1Ol0000A0?ooo`030000003oool0oooo
00X0oooo1?l000070?ooo`Co00001P3oool00`000000oooo0000000S0?ooo`Co000000<000000?oo
ool000000_l0000A0?ooo`040000003oool0oooo0?ooo`?o0000CP3oool004`0oooo1Ol0000;0?oo
o`8000001@3oool00`000000oooo0?ooo`090?ooo`Co00002@3oool4o`0000H0oooo0P00000R0?oo
o`Co000000@000000?ooo`000000oooo0ol0000E0?ooo`?o0000C@3oool004`0oooo0ol0000<0?oo
o`030000003oool0oooo0100oooo0ol0000=0?ooo`Co0000103oool00`000000oooo0?ooo`0O0?oo
o`Co000000<0oooo0000003oool0103oool3o`0001D0oooo0ol0001<0?ooo`00B`3oool3o`000003
0000003oool0oooo00T0oooo00<000000?ooo`3oool0403oool3o`0000l0oooo1?l000020?ooo`03
0000003oool0000001l0oooo1?l000080?ooo`0400000?l0003o0000o`0001D0oooo0ol0001;0?oo
o`00BP3oool3o`0001L0oooo00<000000?ooo`3oool0103oool4o`000180oooo1?l000030?ooo`03
0000003oool0oooo01X0oooo1?l0000;0?ooo`0400000?l0003o0000o`0000h0oooo00<000000?oo
o`3oool0103oool3o`0004X0oooo001:0?ooo`;o00002P3oool2000000`0oooo00<000000?ooo`3o
ool00`3oool4o`0001@0oooo1?l0000N0?ooo`Co00000`3oool00`000000oooo0?ooo`070?ooo`04
00000?l0003o0000o`0000d0oooo00<000000?ooo`3oool01@3oool3o`0004T0oooo00190?ooo`Co
0000203oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo0?ooo`?o00005@3oool00`00
0000oooo0?ooo`04o`0000<0oooo00<000000?ooo`3oool0503oool4o`0000D0oooo00<000000?oo
o`3oool02@3oool4o`0000`0oooo00<000000?ooo`3oool01@3oool3o`0004P0oooo00190?ooo`Go
00006P3oool3o`0001D0oooo00<000000?ooo`3oool00P3oool4o`0000<0oooo00<000000?ooo`3o
ool04P3oool4o`0000D0oooo00<000000?ooo`3oool02`3oool4o`0001@0oooo0ol000170?ooo`00
B03oool3o`00000400000?l0003o0000o`0000<0oooo00<000000?ooo`3oool04@3oool4o`0001D0
oooo00<000000?ooo`3oool01@3oool4o`000080oooo00<000000?ooo`3oool03`3oool4o`0000L0
oooo00<000000?ooo`3oool03@3oool3o`0001@0oooo0_l000170?ooo`00B03oool2o`0000<0oooo
0ol000000`3oool000000?ooo`0B0?ooo`Co00007`3oool4o`000180oooo1?l0000I0?ooo`?o0000
4P3oool3o`0004L0oooo00170?ooo`?o0000103oool3o`0001<0oooo0ol0000E0?ooo`800000303o
ool4o`0000030?ooo`000000000000/0oooo1?l000080?ooo`030000003oool0oooo0140oooo0ol0
00000`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo1?l000160?ooo`00AP3oool3
o`0000030000003oool0oooo00<0oooo0ol0000A0?ooo`?o000000<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0=0?ooo`Co00000P3oool00`000000oooo0?ooo`070?ooo`Co00002@3oool0
0`000000oooo0?ooo`0B0?ooo`?o000000<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`Go0000AP3oool004H0oooo0_l00000103oool000000?ooo`3oool200000080oooo0ol0000>
0?ooo`Co000000<0oooo0000003oool04P3oool00`000000oooo0?ooo`0@0?ooo`Co000000<0oooo
0000003oool01@3oool4o`0000X0oooo00<000000?ooo`3oool0503oool3o`0000P0oooo00<00000
0?ooo`3oool00`3oool2o`0000030?ooool0003o000004H0oooo00150?ooo`?o000000@000000?oo
o`3oool000001@3oool2o`0000d0oooo1?l0000Z0?ooo`Co00001P3oool4o`0000X0oooo00<00000
0?ooo`3oool05P3oool3o`0000030?ooo`000000oooo00T0oooo0ol00000103ooooo0000o`000?l0
00150?ooo`00A@3oool2o`0000030?ooo`000000oooo00L0oooo0ol0000;0?ooo`?o00005@3oool2
000001L0oooo1?l000020?ooo`Co00009P3oool4o`0000030000003oool0oooo00L0oooo0_l00003
0?ooo`;o0000A@3oool004@0oooo0ol000000`00003o00000?ooo`080?ooo`?o00002@3oool3o`00
01@0oooo0P00000J0?ooo`So0000:03oool4o`0000030000003oool0oooo00D0oooo0ol000030?oo
o`;o0000A@3oool004@0oooo0_l000000`3oool000000?ooo`0:0?ooo`?o00001P3oool4o`0000P0
oooo00<000000?ooo`3oool0:03oool4o`0000h0oooo00<000000?ooo`3oool06`3oool3o`0000@0
oooo00<000000?ooo`3oool00_l000040?ooo`?o0000A03oool004<0oooo0ol000000`000000oooo
0000000;0?ooo`?o0000103oool4o`0000T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0L0?ooo`Ko0000303oool00`000000oooo0?ooo`0M0?ooo`?o000000@0oooo000000000000
00000P3oool2o`0000D0oooo0_l000140?ooo`00@`3oool2o`0000040?ooo`000000oooo000000`0
oooo0ol000020?ooo`?o00002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01`0
oooo0ol000020?ooo`?o00002P3oool00`000000oooo0?ooo`0O0?ooo`?o00000P3oool00`000000
ooooo`000002o`0000D0oooo0_l000140?ooo`00@P3oool3o`000140oooo1_l0000E0?ooo`030000
003oool0oooo01/0oooo1?l000040?ooo`?o0000;03oool3o`0000030?ooo`000000000000;o0000
1P3oool2o`0004@0oooo00120?ooo`;o00004`3oool4o`0003<0oooo1?l000060?ooo`?o0000;03o
ool3o`0000040?ooool0003o0000o`0000H0oooo0ol000130?ooo`00@@3oool3o`0000030000003o
ool0oooo0080oooo00<000000?ooo`3oool0303oool4o`0000h0oooo00D000000?ooo`3oool0oooo
0000000N0?ooo`?o00002@3oool3o`0000H0oooo00<000000?ooo`3oool08`3oool5o`0000P0oooo
0_l000130?ooo`00@@3oool2o`0000030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3o
ool7o`0000`0oooo00@000000?ooo`3oool000007P3oool3o`0000/0oooo0ol000050?ooo`030000
003oool0oooo02@0oooo1?l000080?ooo`;o0000@`3oool00400oooo0ol000070?ooo`030000003o
ool0oooo00X0oooo0_l000020?ooo`Go00002P3oool00`000000oooo0000000M0?ooo`Co00003@3o
ool3o`0000<0oooo00<000000?ooo`3oool0903oool4o`0000<0oooo00<000000?ooo`3oool00`3o
ool3o`000480oooo000o0?ooo`?o0000203oool00`000000oooo0?ooo`090?ooo`?o0000103oool4
o`0000T0oooo00<000000?ooo`3oool0703oool4o`0000l0oooo0ol000000`3oool000000?ooo`0T
0?ooo`Ko0000103oool00`000000oooo0?ooo`030?ooo`;o0000@P3oool003l0oooo0_l0000E0?oo
o`;o00001`3oool4o`0000H0oooo00<000000?ooo`000000703oool3o`000180oooo0ol000000`00
0000oooo0?ooo`0R0?ooo`Co000000@0ooooo`000?l0003o0000103oool00`000000oooo0?ooo`02
0?ooo`;o0000@P3oool003h0oooo0ol0000D0?ooo`?o0000203oool4o`0000@0oooo00D000000?oo
o`3oool0oooo0000000I0?ooo`Co0000503oool3o`0000030000003oool0oooo0200oooo0ol00004
0?ooo`;o00002@3oool2o`000480oooo000n0?ooo`;o000000<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`060?ooo`?o00002`3oool4o`0001l0oooo1?l0000D0?ooo`030000003ooooo0000
00;o000000<000000?ooo`3oool07@3oool4o`0000D0oooo0_l000060?ooo`030000003oool0oooo
00?o0000@@3oool003d0oooo0ol0000;0?ooo`030000003oool0oooo00H0oooo0_l0000=0?ooo`Co
0000203oool00`000000oooo0?ooo`0B0?ooo`?o00006@3oool4o`0001d0oooo1?l000060?ooo`?o
00001P3oool00`000000oooo0?ooo`02o`000440oooo000m0?ooo`;o00003@3oool00`000000oooo
0?ooo`040?ooo`?o00003@3oool00`000000ooooo`000003o`0000L0oooo00<000000?ooo`3oool0
3`3oool4o`0001D0oooo00<000000?ooo`3oool00`3oool4o`0000800000603oool4o`0000030?oo
o`000000oooo00H0oooo0_l000070?ooo`040000003ooooo0000o`000440oooo000l0?ooo`?o0000
3@3oool00`000000oooo0?ooo`040?ooo`;o00004@3oool5o`0000H0oooo00<000000?ooo`3oool0
3@3oool4o`0001D0oooo00<000000?ooo`3oool01P3oool3o`0000030?ooo`000000oooo01D0oooo
1?l000020?ooo`030000003oool0oooo00D0oooo0_l000090?ooo`?o0000@03oool003`0oooo0_l0
000D0?ooo`?o00002P3oool2000000L0oooo1?l0000D0?ooo`?o00005P3oool00`000000oooo0?oo
o`080?ooo`?o00005@3oool4o`0000<0oooo00<000000?ooo`3oool01P3oool3o`0000T0oooo0_l0
00100?ooo`00?03oool3o`0001<0oooo0_l0000:0?ooo`030000003oool0oooo00T0oooo1?l00006
0?ooo`030000003oool0oooo00L0oooo1?l0000S0?ooo`?o00000P3oool2000000l0oooo1?l0000>
0?ooo`;o00002@3oool2o`000400oooo000m0?ooo`?o00003@3oool010000000oooo0?ooo`3oool3
o`0001L0oooo1?l000060?ooo`030000003oool0oooo00D0oooo1?l0000D0?ooo`8000003`3oool3
o`0000<0oooo00<000000?ooo`3oool02`3oool3o`000100oooo0_l000090?ooo`?o0000?`3oool0
03d0oooo1?l0000<0?ooo`040000003oool0oooo0?ooo`;o0000203oool00`000000oooo0?ooo`0?
0?ooo`Co00001@3oool00`000000oooo0?ooo`030?ooo`?o00005@3oool00`000000oooo0?ooo`0@
0?ooo`?o00003P3oool4o`0000D0oooo00<000000?ooo`3oool02@3oool2o`0000X0oooo0_l0000o
0?ooo`00?@3oool5o`0000`0oooo00<000000?ooool000000_l000070?ooo`030000003oool0oooo
0140oooo1?l000090?ooo`?o0000:P3oool3o`0000@0oooo00<000000?ooo`3oool01@3oool4o`00
00H0oooo00<000000?ooo`3oool02@3oool3o`0000T0oooo0_l0000o0?ooo`00?P3oool5o`0000/0
oooo00@000000?ooool0003o00001`3oool00`000000oooo0?ooo`0D0?ooo`Co0000103oool00`00
003o0000o`000002o`0002`0oooo0ol000040?ooo`030000003oool0oooo0080oooo1?l000070?oo
o`030000003oool0oooo00/0oooo0_l000080?ooo`?o0000?`3oool003h0oooo0_l00000103ooooo
0000o`000?l0000;0?ooo`?o00007`3oool5o`000080oooo1?l0000D0?ooo`800000603oool3o`00
00@0oooo00<000000?ooo`3oool01?l000080?ooo`030000003oool0oooo00/0oooo0_l000080?oo
o`;o0000@03oool003h0oooo0ol00000103ooooo0000o`000?l0000:0?ooo`;o0000103oool20000
01`0oooo1ol000000`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01T0oooo0ol000050?oo
o`?o0000603oool3o`0000H0oooo0ol000100?ooo`00?`3oool2o`000080oooo0_l000090?ooo`?o
00000`3oool00`000000oooo0?ooo`0N0?ooo`Co0000<`3oool3o`000080oooo1?l00002000001P0
oooo0_l000060?ooo`;o0000@@3oool003l0oooo0ol00000103ooooo0000o`000?l000070?ooo`?o
00009P3oool4o`0000<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0N0?ooo`Oo
00000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00h0oooo0_l000050?ooo`?o
0000@@3oool00400oooo0_l000020?ooo`?o00001P3oool2o`0000030?ooo`00003o000002<0oooo
1_l000030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0803oool4o`0000`0oooo
00<000000?ooo`3oool03P3oool2o`0000@0oooo00<00000o`000?l00000@P3oool00400oooo0_l0
00030?ooo`?o0000103oool3o`0000030?ooo`000000000002<0oooo0_l000020?ooo`?o00000`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0200oooo1?l000080?ooo`8000000P3o
ool00`000000oooo0?ooo`0?0?ooo`?o00000`3oool3o`000480oooo00100?ooo`?o00000`3oool3
o`0000<0oooo0_l000001@3oool000000?ooo`3oool000000240oooo0ol000030?ooo`?o0000;`3o
ool5o`0000X0oooo00<000000?ooo`3oool04P3oool2o`0000<0oooo0_l000130?ooo`00@@3oool2
o`0000@0oooo0ol000001P3ooooo0000o`000?l00000oooo000002<0oooo0ol000050?ooo`?o0000
2@3oool00`000000oooo0?ooo`0P0?ooo`Co000000@0ooooo`000?l0003o00002@3oool2000001<0
oooo0_l000020?ooo`0300000?l0003o000004<0oooo00110?ooo`;o00001@3oool5o`0002H0oooo
0_l000070?ooo`?o00000P3oool300000080oooo00<000000?ooo`3oool0803oool4o`0000<0oooo
0_l000080?ooo`040000003oool0oooo00000180oooo0ol00000103ooooo0000o`000?l000130?oo
o`00@@3oool3o`0000D0oooo1?l000080?ooo`8000006`3oool3o`0000P0oooo0ol000040?ooo`80
00008P3oool3o`0000D0oooo0_l0000<0?ooo`030000003oool0oooo0100oooo0_l000000`00003o
0000o`0000140?ooo`00@P3oool2o`0000H0oooo1?l000090?ooo`030000003oool0oooo01P0oooo
0_l0000:0?ooo`?o00000P3oool300000240oooo0ol000060?ooo`?o0000103oool00`000000oooo
0?ooo`0G0?ooo`Go0000A03oool00480oooo0_l000060?ooo`Ko00008@3oool3o`0000/0oooo0ol0
00001@000000oooo0?ooo`3oool0000001h0oooo1?l000080?ooo`;o00000`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00h0oooo1?l000150?ooo`00@P3oool3o`0000H0oooo1_l0
000P0?ooo`;o00003@3oool3o`000240oooo1?l000090?ooo`;o00000P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00d0oooo1?l000150?ooo`00@`3oool2o`0000H0oooo0_l00002
0?ooo`Co00001`3oool2000001@0oooo0ol0000;0?ooo`80000000@0ooooo`000?l0003o00001@3o
ool00`000000oooo0?ooo`0G0?ooo`?o00002`3oool3o`0000h0oooo00<000000?ooo`3oool02`3o
ool4o`0004H0oooo00130?ooo`?o00001@3oool3o`000080oooo1?l000080?ooo`030000003oool0
oooo0140oooo0_l0000;0?ooo`030000003oool0oooo0080oooo1?l000040?ooo`030000003oool0
oooo01@0oooo1?l0000=0?ooo`;o00006P3oool6o`0004H0oooo00140?ooo`;o0000103oool01000
0000ooooo`000?l000040?ooo`?o00006P3oool3o`0000X0oooo00<000000?ooo`3oool0103oool4
o`0000@0oooo00<000000?ooo`3oool04P3oool4o`0000d0oooo00<00000o`000?l000006@3oool6
o`0004L0oooo00140?ooo`;o00000`3oool00`000000oooo0?ooo`02o`0000D0oooo1?l0000G0?oo
o`?o0000503oool3o`0001L0oooo0ol0000>0?ooo`040000003ooooo0000o`000100oooo00<00000
0?ooo`3oool01@3oool3o`0000030?ooool0003o000004P0oooo00140?ooo`?o000000<0oooo0000
003oool00P3oool3o`0000D0oooo1?l000060?ooo`030000003oool0oooo00d0oooo0_l000090?oo
o`8000002`3oool3o`0000D0oooo0P00000=0?ooo`Co00004@3oool3o`000100oooo00<000000?oo
o`3oool00P3oool4o`0000040?ooool0003o0000o`0004P0oooo00150?ooo`;o00001P3oool2o`00
00L0oooo1?l000050?ooo`030000003oool0oooo00/0oooo0ol000070?ooo`8000003P3oool3o`00
00H0oooo00<000000?ooo`3oool02@3oool4o`0000d0oooo00<000000?ooo`3oool00`3oool2o`00
0140oooo00<000000?ooo`3oool01?l0000010000000ooooo`000?l000190?ooo`00A@3oool2o`00
00H0oooo0_l000080?ooo`Co00001@3oool00`000000oooo0?ooo`0:0?ooo`;o00006@3oool3o`00
0100oooo0ol0000>0?ooo`030000003oool0oooo00@0oooo0_l0000B0?ooo`Co00000P3oool01000
003o0000o`000?l000190?ooo`00A@3oool3o`0000D0oooo0ol000090?ooo`Co00003`3oool3o`00
00D0oooo0P00000C0?ooo`?o00001`3oool2000000@0oooo1?l0000>0?ooo`030000003oool0oooo
00D0oooo0ol0000@0?ooo`Co00000P3oool01000003o0000o`000?l0001:0?ooo`00AP3oool2o`00
00030000003oool0oooo00<0oooo0_l0000:0?ooo`Co00001@3oool00`000000oooo0?ooo`060?oo
o`;o00001@3oool00`000000oooo0?ooo`0D0?ooo`?o0000203oool00`000000oooo0?ooo`04o`00
01P0oooo0_l0000>0?ooo`Co00000P3oool00`000000oooo0?ooo`02o`0004/0oooo00160?ooo`?o
000000<000000?ooo`3oool00P3oool2o`0000`0oooo1?l000040?ooo`030000003oool0oooo00@0
oooo0ol000040?ooo`030000003oool0oooo01H0oooo0ol000080?ooo`0400000?l0003o0000o`00
00h0oooo00<000000?ooo`3oool02@3oool2o`0000d0oooo1?l000030?ooo`8000000ol0001;0?oo
o`00A`3oool3o`0000@0oooo0ol0000<0?ooo`Co0000103oool00`000000oooo0?ooo`030?ooo`;o
00007`3oool3o`0000L0oooo0ol000000`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0
oooo0_l0000<0?ooo`?o0000103oool00`000000oooo00000002o`0004`0oooo00180?ooo`?o0000
00@0oooo0000003oool0oooo0_l0000>0?ooo`?o0000203oool3o`000080oooo0P00000L0?ooo`?o
0000103oool4o`000080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`?o
00002@3oool4o`0000@0oooo00<000000?ooo`0000000ol0001<0?ooo`00B@3oool3o`0000030?oo
o`000000oooo00;o00003`3oool4o`0000<0oooo0P000003o`0000030?ooo`000000000001l0oooo
0ol000020?ooo`Co0000103oool00`000000oooo0?ooo`0G0?ooo`;o0000203oool4o`0000H0oooo
00@00000o`000?l0003o0000C@3oool004X0oooo0_l000020?ooo`0400000?l0003o0000o`0000l0
oooo1?l000040?ooo`;o0000903oool6o`0000d0oooo0P00000A0?ooo`;o00001P3oool4o`0000D0
oooo00@000000?ooo`3oool0oooo0_l0001>0?ooo`00BP3oool3o`0000<0oooo0_l0000A0?ooo`Co
000000D0ooooo`000?l0003o00000000000T0?ooo`Co00002P3oool2000000030?ooo`000000oooo
0180oooo0ol000040?ooo`Co00001@3oool010000000oooo0?ooo`3oool3o`0004h0oooo001;0?oo
o`?o00000P3oool2o`000180oooo1_l000000`000000oooo0000000T0?ooo`;o0000303oool20000
01D0oooo0_l000030?ooo`?o00001P3oool010000000oooo0?ooo`3oool3o`0004l0oooo001<0?oo
o`?o000000@0ooooo`000?l0003o00004`3oool4o`0000<0oooo00<000000?ooo`3oool0803oool4
o`0000X0oooo00@000000?ooo`3oool00000503oool2o`0000030?ooool0003o000000;o00002`3o
ool2o`000500oooo001=0?ooo`?o000000<0ooooo`000?l00000503oool4o`0002D0oooo1?l00009
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool6o`0000D0oooo00<00000
0?ooo`3oool00`3oool3o`000500oooo001>0?ooo`Go0000503oool5o`0000<0oooo0`00000M0?oo
o`Go00008P3oool4o`0000H0oooo00<000000?ooo`3oool0103oool2o`000540oooo001?0?ooo`Go
000000<0oooo0000003oool04@3oool5o`0000D0oooo00<000000?ooo`3oool06@3oool3o`000004
0?ooool0003o0000o`0000D0oooo0P00000I0?ooo`Co00001P3oool00`000000oooo0?ooo`040?oo
o`?o0000D@3oool004l0oooo1Ol000020?ooo`030000003oool0oooo00h0oooo00@00000o`000?l0
0000oooo0ol0000P0?ooo`;o00000`3oool2o`0000@0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0=0?ooo`Go0000303oool3o`000580oooo001@0?ooo`Co00000`3oool00`000000
oooo0?ooo`0=0?ooo`0500000?l0003o0000o`00003oool00ol000050?ooo`8000005`3oool3o`00
00<0oooo0_l000030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool5o`00
00<0oooo0P0000080?ooo`;o0000D`3oool00540oooo1?l0000A0?ooo`030000003oool0oooo00;o
00000P3oool3o`0000H0oooo00<000000?ooo`3oool0503oool2o`0000@0oooo0ol000000`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo1ol000020?ooo`030000003oool0oooo00L0
oooo0ol0001C0?ooo`00DP3oool4o`0000<0oooo0P00000>0?ooo`;o00000`3oool3o`0000H0oooo
00<000000?ooo`3oool04P3oool3o`0000D0oooo0_l0000J0?ooo`Oo00003@3oool2o`0005@0oooo
001C0?ooo`Co0000103oool00`000000oooo0?ooo`0;0?ooo`?o00000`3oool4o`0001T0oooo0_l0
00050?ooo`0300000?l0003o000001T0oooo0ol000020?ooo`;o000000<0oooo0000003oool02P3o
ool3o`0005@0oooo001E0?ooo`Co00000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo0_l000040?ooo`Co00001P3oool2000000l0oooo0ol000060?ooo`?o00004@3oool0
0`000000oooo0?ooo`030?ooo`?o00000P3oool3o`0000030000003oool0oooo00P0oooo1?l0001E
0?ooo`00EP3oool4o`0000X0oooo00<000000?ooo`3oool00`3oool2o`0000H0oooo0ol000070?oo
o`030000003oool0oooo00/0oooo0ol000030?ooo`8000000`3oool2o`000180oooo00<000000?oo
o`3oool01?l000030?ooo`;o000000<000000?ooo`3oool0203oool4o`0005H0oooo001G0?ooo`Go
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0ol000060?ooo`?o
0000503oool2o`0000<0oooo00<000000?ooo`3oool00`3oool2o`0001<0oooo00<00000o`000?l0
00000_l000030?ooo`?o00002P3oool3o`0005P0oooo001H0?ooo`Go00000P3oool01@000000oooo
0?ooo`3oool0000000L0oooo0_l000070?ooo`?o0000203oool00`000000oooo0?ooo`070?ooo`?o
00000P3oool00`000000oooo0?ooo`040?ooo`?o00004P3oool3o`0000D0oooo0_l000090?ooo`Co
0000F@3oool005T0oooo1Ol000020?ooo`030000003oool0oooo00P0oooo0_l000080?ooo`?o0000
203oool00`000000oooo0?ooo`060?ooo`;o00002`3oool2o`000100oooo1?l000000`000000oooo
0?ooo`020?ooo`?o0000203oool4o`0005X0oooo001J0?ooo`Ko000000<0oooo000000000000203o
ool3o`0000P0oooo0ol000080?ooo`030000003oool0oooo00@0oooo0ol00002000000T0oooo0_l0
000?0?ooo`Co00000P3oool00`000000oooo0?ooo`03o`0000L0oooo1?l0001L0?ooo`00G03oool5
o`0000030?ooo`000000000000P0oooo0_l000090?ooo`?o00003@3oool3o`0000030000003oool0
oooo00T0oooo0ol0000=0?ooo`?o00001@3oool010000000ooooo`000?l000070?ooo`Co0000G@3o
ool005d0oooo1_l00002000000L0oooo0_l0000:0?ooo`Co0000203oool2000000030?ooool0003o
000000h0oooo0_l0000<0?ooo`?o00001@3oool2000000?o00001P3oool4o`0005h0oooo001N0?oo
o`Ko00000P3oool2000000@0oooo0ol0000:0?ooo`Co00002@3oool3o`0000h0oooo0_l0000:0?oo
o`Co00001@3oool2000000030?ooool0003o000000D0oooo1?l0001P0?ooo`00G`3oool7o`000080
oooo00<000000?ooo`3oool00P3oool2o`0000`0oooo0ol000080?ooo`;o00003`3oool3o`0000P0
oooo1?l000070?ooo`0400000?l0003o0000o`0000@0oooo1?l0001Q0?ooo`00H03oool7o`000080
oooo00@000000?ooo`3oool0oooo0_l0000=0?ooo`?o00001P3oool3o`0000030000003oool0oooo
00d0oooo0_l000070?ooo`?o00001@3oool010000000oooo0?ooo`3oool3o`0000@0oooo1?l0001R
0?ooo`00HP3oool7o`0000@0oooo0ol0000=0?ooo`?o00001@3oool2o`000140oooo0_l000060?oo
o`?o00001@3oool00`000000oooo0?ooo`020?ooo`;o00000`3oool4o`0006@0oooo001S0?ooo`Oo
00000P3oool010000000ooooo`000?l0000>0?ooo`?o00000`3oool3o`000140oooo0ol000030?oo
o`Co00001@3oool01@000000oooo0?ooo`3oool0000000?o00000P3oool4o`0006D0oooo001T0?oo
o`?o000000@0ooooo`000?l0003o00000P3oool00`00003o0000o`00000?0?ooo`?o000000@0oooo
o`000?l0003o0000103oool00`000000oooo0?ooo`0<0?ooo`;o00000P3oool4o`0000<0oooo00<0
00000?ooo`3oool0103oool00`00003o0000o`0000020?ooo`Co0000IP3oool006D0oooo0ol00000
0`3ooooo0000o`000002o`0000040?ooool0003o0000o`0000l0oooo1Ol000060?ooo`030000003o
ool0oooo00/0oooo0_l00000103ooooo0000o`000?l000040?ooo`030000003oool0oooo00@0oooo
00<00000o`000?l000001_l0001W0?ooo`00IP3oool8o`0000040?ooool0003o0000000000l0oooo
1?l000070?ooo`030000003oool0oooo00X0oooo1Ol000040?ooo`030000003oool0oooo00H0oooo
1_l0001Y0?ooo`00I`3oool4o`0000030?ooool0003o000000?o000000<0oooo0000003oool03P3o
ool2o`0001H0oooo0ol0000=0?ooo`Ko0000JP3oool006T0oooo0ol000000`3ooooo0000o`000003
o`0000030?ooo`000000oooo00d0oooo0ol0000E0?ooo`;o00000`3oool00`000000oooo0?ooo`07
0?ooo`Ko0000J`3oool006X0oooo0ol000020?ooo`Co0000403oool2o`0000T0oooo00<000000?oo
o`3oool0203oool3o`000080oooo00<000000?ooo`3oool0203oool4o`0006d0oooo001[0?ooo`?o
00000P3oool4o`000080oooo0P0000080?ooo`030000003oool0oooo00;o00002P3oool00`000000
oooo0?ooo`060?ooo`?o00000P3oool00`000000oooo0?ooo`070?ooo`Go0000KP3oool006`0oooo
0ol000030?ooo`?o00000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00?o0000
2P3oool00`000000oooo0?ooo`050?ooo`;o0000303oool5o`0006l0oooo001]0?ooo`Co00000P3o
ool3o`0000T0oooo00<000000?ooo`3oool00P3oool2o`000140oooo0ol000000`000000oooo0?oo
o`080?ooo`Co0000L@3oool006h0oooo1?l000020?ooo`?o0000103oool01@000000oooo0?ooo`3o
ool0000000@0oooo0_l0000<0?ooo`030000003oool0oooo0080oooo0_l0000:0?ooo`Go0000LP3o
ool00700oooo1?l00000103ooooo0000o`000?l000040?ooo`030000003oool0oooo00D0oooo0ol0
000<0?ooo`030000003oool0oooo00?o00002@3oool5o`0007<0oooo001a0?ooo`Co000000<0oooo
o`000?l000000_l000030?ooo`8000001P3oool2o`0000d0oooo00@00000o`000?l0003o00002@3o
ool4o`0007D0oooo001c0?ooo`So00000`3oool00`000000oooo0?ooo`040?ooo`;o00003@3oool0
0`00003o0000o`0000080?ooo`Go0000MP3oool007@0oooo1?l00000103ooooo0000o`000?l00003
0?ooo`030000003oool0oooo00<0oooo0ol0000<0?ooo`?o00001`3oool5o`0007L0oooo001f0?oo
o`?o000000@0ooooo`000?l0003o00002@3oool2o`0000/0oooo00<00000o`000?l000001`3oool4
o`0007T0oooo001g0?ooo`Oo0000203oool2o`0000/0oooo0ol000050?ooo`Go0000NP3oool007P0
oooo2?l000020?ooo`040000003oool0oooo0?ooo`?o00002@3oool3o`0000D0oooo1?l0001l0?oo
o`00NP3oool7o`0000030?ooo`000000oooo00<0oooo0_l000090?ooo`;o00001@3oool4o`0007d0
oooo001k0?ooo`Oo000000<0oooo0000003oool00P3oool2o`0000P0oooo0ol000040?ooo`Co0000
OP3oool007d0oooo1_l000040?ooo`?o00001`3oool2o`0000<0oooo1?l000200?ooo`00OP3oool6
o`0000@0oooo0_l000060?ooo`?o00000P3oool4o`000840oooo00200?ooo`Go000000<0oooo0000
003oool00_l000050?ooo`?o00000P3oool4o`000880oooo00210?ooo`Ko000000@0ooooo`000?l0
003o0000103oool2o`0000030?ooool0003o000000;o0000Q03oool008<0oooo1Ol000000`3ooooo
0000o`0000030?ooo`Oo0000Q@3oool008@0oooo1ol000030?ooo`Ko0000QP3oool008D0oooo1ol0
00000`3ooooo0000o`000003o`0008P0oooo00270?ooo`[o0000R@3oool008P0oooo1ol0002;0?oo
o`00RP3oool4o`0008`0oooo002;0?ooo`;o0000S@3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool0
0?l0oooo6`3oool00?l0oooo6`3oool00?l0oooo6`3oool00001\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.51809 .55254 m
.61117 .61589 L
s
.51809 .55254 m
.42016 .61819 L
s
.61068 .47221 m
.51809 .55254 L
s
.42051 .47478 m
.51809 .55254 L
s
.42051 .47478 m
.3216 .54006 L
s
.51289 .39387 m
.42051 .47478 L
s
.37327 .38387 m
.42051 .47478 L
s
.61068 .47221 m
.70505 .53513 L
s
.6455 .37994 m
.61068 .47221 L
s
.51289 .39387 m
.61068 .47221 L
s
.42016 .61819 m
.513 .68261 L
s
.42016 .61819 m
.37213 .6746 L
s
.3216 .54006 m
.42016 .61819 L
s
.54656 .30033 m
.51289 .39387 L
s
.46652 .30155 m
.51289 .39387 L
s
.61117 .61589 m
.64681 .67144 L
s
.61117 .61589 m
.513 .68261 L
s
.70505 .53513 m
.61117 .61589 L
s
.3216 .54006 m
.2718 .59533 L
s
.27282 .44926 m
.3216 .54006 L
s
.70505 .53513 m
.7425 .58954 L
s
.74141 .4428 m
.70505 .53513 L
s
.37327 .38387 m
.27282 .44926 L
s
.40538 .28953 m
.37327 .38387 L
s
.46652 .30155 m
.37327 .38387 L
s
.513 .68261 m
.54719 .73974 L
s
.513 .68261 m
.46607 .74062 L
s
.6455 .37994 m
.74141 .4428 L
s
.54656 .30033 m
.6455 .37994 L
s
.60026 .28653 m
.6455 .37994 L
s
.5 .20569 m
.46652 .30155 L
s
.5 .20569 m
.54656 .30033 L
s
.27282 .44926 m
.2216 .50369 L
s
.30387 .35507 m
.27282 .44926 L
s
.37213 .6746 m
.46607 .74062 L
s
.37213 .6746 m
.40408 .73201 L
s
.2718 .59533 m
.37213 .6746 L
s
.64681 .67144 m
.60164 .72986 L
s
.64681 .67144 m
.54719 .73974 L
s
.7425 .58954 m
.64681 .67144 L
s
.2718 .59533 m
.30207 .65151 L
s
.2216 .50369 m
.2718 .59533 L
s
.74141 .4428 m
.77999 .49629 L
s
.69692 .34927 m
.74141 .4428 L
s
.40538 .28953 m
.30387 .35507 L
s
.5 .20569 m
.40538 .28953 L
s
.60026 .28653 m
.69692 .34927 L
s
.5 .20569 m
.60026 .28653 L
s
.0085 w
[ ] 0 setdash
.7425 .58954 m
.69873 .64686 L
s
.77999 .49629 m
.7425 .58954 L
s
.5 .20569 m
.59598 .26784 L
s
.5 .20569 m
.53451 .25527 L
s
.5 .20569 m
.45208 .25657 L
s
.5 .20569 m
.3987 .27092 L
s
.0035 w
[ .01 .012 ] 0 setdash
.46607 .74062 m
.5 .79975 L
s
.54719 .73974 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.30387 .35507 m
.2525 .40861 L
s
.3987 .27092 m
.30387 .35507 L
s
.2216 .50369 m
.25135 .55892 L
s
.2525 .40861 m
.2216 .50369 L
s
.69692 .34927 m
.73519 .40175 L
s
.59598 .26784 m
.69692 .34927 L
s
.3987 .27092 m
.34869 .3233 L
s
.40408 .73201 m
.5 .79975 L
s
.30207 .65151 m
.40408 .73201 L
s
.59598 .26784 m
.63255 .31902 L
s
.60164 .72986 m
.5 .79975 L
s
.69873 .64686 m
.60164 .72986 L
s
.30207 .65151 m
.39729 .71868 L
s
.25135 .55892 m
.30207 .65151 L
s
.77999 .49629 m
.73628 .55277 L
s
.73519 .40175 m
.77999 .49629 L
s
.69873 .64686 m
.59732 .71647 L
s
.73628 .55277 m
.69873 .64686 L
s
.45208 .25657 m
.48632 .30793 L
s
.45208 .25657 m
.34869 .3233 L
s
.53451 .25527 m
.63255 .31902 L
s
.53451 .25527 m
.48632 .30793 L
s
.535 .70746 m
.5 .79975 L
s
.59732 .71647 m
.5 .79975 L
s
.39729 .71868 m
.5 .79975 L
s
.45141 .70839 m
.5 .79975 L
s
.2525 .40861 m
.28321 .46286 L
s
.34869 .3233 m
.2525 .40861 L
s
.34727 .62603 m
.39729 .71868 L
s
.6338 .6226 m
.59732 .71647 L
s
.25135 .55892 m
.34727 .62603 L
s
.28321 .46286 m
.25135 .55892 L
s
.73519 .40175 m
.69015 .45731 L
s
.63255 .31902 m
.73519 .40175 L
s
.34869 .3233 m
.38131 .37627 L
s
.63255 .31902 m
.58559 .3733 L
s
.73628 .55277 m
.6338 .6226 L
s
.69015 .45731 m
.73628 .55277 L
s
.48619 .6137 m
.45141 .70839 L
s
.34727 .62603 m
.45141 .70839 L
s
.6338 .6226 m
.535 .70746 L
s
.48619 .6137 m
.535 .70746 L
s
.38075 .52994 m
.34727 .62603 L
s
.48632 .30793 m
.58559 .3733 L
s
.48632 .30793 m
.38131 .37627 L
s
.586 .52728 m
.6338 .6226 L
s
.28321 .46286 m
.38075 .52994 L
s
.38131 .37627 m
.28321 .46286 L
s
.69015 .45731 m
.586 .52728 L
s
.58559 .3733 m
.69015 .45731 L
s
.38131 .37627 m
.48031 .44283 L
s
.586 .52728 m
.48619 .6137 L
s
.38075 .52994 m
.48619 .6137 L
s
.58559 .3733 m
.48031 .44283 L
s
.48031 .44283 m
.38075 .52994 L
s
.48031 .44283 m
.586 .52728 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`0008cooooo0029ooooo`Ko0000Rooo
ool008Oooooo2_l00029ooooo`00Q_ooool<o`0008Sooooo0024ooooo`Oo00000_ooool7o`0008Ko
oooo0023ooooo`Oo00001?ooool2o`000003ooooool0003o000000;o0000QOooool0087ooooo1?l0
00001P00003o0000o`000?l0003ooooo000000?ooooo0ol00002ooooo`Co0000Poooool0083ooooo
1?l000001?oooooo0000o`000?l00002ooooo`0300000?oooooooooo00;ooooo0ol00002ooooo`Co
0000P_ooool007kooooo1?l00002ooooo`?o00000_ooool00`00003oooooooooo`04ooooo`;o0000
1?ooool4o`00083ooooo001mooooo`Co000000?ooooo0000000000000_l00003ooooo`0300000?oo
oooooooo00Cooooo0ol00004ooooo`Co0000Ooooool007cooooo0ol00002ooooo`0300000?oooooo
000000;o00002oooool3o`0000Cooooo00<00000o`000?l000000_l0001mooooo`00N_ooool4o`00
00Cooooo0ol0000<ooooo`0400000?l0003o0000o`0000Gooooo1?l0001looooo`00NOooool4o`00
00Cooooo0ol00004ooooo`0300000?oooooooooo00Kooooo00@00000ooooool0003o00001Oooool2
000000Co0000N_ooool007Oooooo1?l00002ooooo`80000000Coooooo`000?l0003o00001Oooool0
0`00003oooooooooo`07ooooo`0400000?l0003o0000o`0000Kooooo00<00000o`000?l000000_l0
001iooooo`00M_ooool4o`0000;ooooo00<00000ooooooooool00ol00005ooooo`0300000?oooooo
oooo00Wooooo00<00000o`000?l000000_l00005ooooo`0300000?oooooo000000?o0000Moooool0
07Cooooo1?l00005ooooo`Co00001_ooool00`00003oooooooooo`0;ooooo`Co00001oooool4o`00
07Kooooo001cooooo`Co00001?ooool5o`0001Cooooo1ol00004ooooo`0300000?oooooooooo00Co
0000M?ooool0077ooooo1?l00004ooooo`0300000?l0003o000000Go00004_ooool3o`0000;ooooo
1?l00004ooooo`0300000?oooooooooo00Co0000Loooool0073ooooo1?l00004ooooo`Co00000ooo
ool3o`0000Cooooo00<00000ooooooooool02Oooool3o`0000Gooooo1?l00003ooooo`0400000?oo
ooooooooooooo`Co0000LOooool006kooooo1?l00004ooooo`Go00001Oooool2o`0000Cooooo00<0
0000ooooooooool02?ooool3o`000003ooooo`00003ooooo00Cooooo1?l00007ooooo`Co0000L?oo
ool006gooooo1?l00004ooooo`Co00001oooool3o`0000;ooooo00<00000ooooooooool02?ooool3
o`0000[ooooo1?l00003ooooo`0300000?oooooo000000Co0000Koooool006cooooo0ol00004oooo
o`Co00002_ooool3o`0000_ooooo0ol0000<ooooo`Co00000oooool00`00003oooooo`000004o`00
06kooooo001[ooooo`?o00000oooool5o`0000cooooo0_l0000:ooooo`?o00003oooool4o`0000;o
oooo00<00000ooooool000001?l0001]ooooo`00J_ooool3o`0000?ooooo1?l0000>ooooo`?o0000
2?ooool3o`0000Oooooo00<00000ooooooooool01oooool4o`0000?ooooo00<00000o`000?l00000
1?l0001[ooooo`00JOooool3o`0000;ooooo1?l0000Aooooo`;o00001oooool3o`0000Sooooo00<0
0000ooooooooool02Oooool4o`000003ooooo`00003o000000Ko0000J_ooool006Oooooo1?l00000
0ooooooo0000o`000003o`00000300000?oooooooooo00oooooo0ol00005ooooo`?o00002_ooool0
0`00003oooooooooo`09ooooo`Co000000?ooooo00000?l000000_l000001?oooooo0000o`000?l0
001Yooooo`00I_ooool4o`000003ooooool0003o000000;o000000?ooooo00000?ooool04Oooool0
1000003o0000o`000?l00003ooooo`?o00006Oooool4o`000003ooooool0003o0000008000000ol0
001Xooooo`00IOooool8o`0000?ooooo00<00000ooooooooool03oooool200000003ooooool0003o
000000;ooooo0ol0000=ooooo`0300000?oooooooooo00_ooooo1ol000000oooool00000o`000003
o`0006Kooooo001Tooooo`So00005Oooool01000003ooooo00000?ooool6o`0000kooooo0P00000>
ooooo`Ko000000?ooooo00000?l000000ol0001Uooooo`00Hoooool7o`00000300000?oooooooooo
01?ooooo00H00000oooooooooooooooo00000?ooool4o`0000kooooo00@00000ooooooooool00000
3_ooool6o`0000?ooooo0ol0001Tooooo`00HOooool7o`0000Oooooo00<00000ooooooooool04_oo
ool00`00003o0000o`000004o`0000gooooo00<00000ooooooooool04?ooool00`00003o0000o`00
0002o`0000?ooooo00@00000o`000?l0003o0000Hoooool0063ooooo1ol000000`00003ooooooooo
o`05ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool00_ooool4o`0000;ooooo1?l0
000Aooooo`0300000?oooooooooo00_ooooo00<00000o`000?l000000_l00004ooooo`?o0000H_oo
ool005oooooo1_l000000`00003oooooooooo`06ooooo`0300000?oooooooooo00cooooo00<00000
ooooooooool00_ooool4o`0000Cooooo1?l0000Aooooo`0300000?oooooooooo00gooooo1?l00003
ooooo`Co0000H?ooool005kooooo1Ol0000Iooooo`0400000?ooooooooooooooo`Co000000?ooooo
00000?ooool01Oooool4o`0000Oooooo00<00000ooooooooool01_ooool00`00003oooooooooo`0=
ooooo`Co00000oooool4o`0005oooooo001Mooooo`Go000000<00000ooooooooool06_ooool4o`00
00?ooooo00<00000ooooooooool01?ooool5o`0000Gooooo00<00000ooooooooool05?ooool00`00
003o0000o`000004o`0000Cooooo0ol0001Nooooo`00G?ooool7o`0001Kooooo00@00000oooooooo
oooooooo1?l00006ooooo`0300000?oooooooooo00Gooooo1?l00003ooooo`0300000?oooooooooo
00[ooooo0P000009ooooo`?o00000_ooool3o`0000Cooooo0ol0001Mooooo`00F_ooool5o`0000;o
oooo0ol00009ooooo`0300000?oooooooooo00Sooooo00@00000oooooooooooooooo1?l0000Aoooo
o`Co00004?ooool00`00003oooooooooo`05ooooo`?o00001?ooool4o`0000?ooooo1?l0001Koooo
o`00FOooool5o`0000Cooooo0_l00009ooooo`0300000?oooooooooo00Oooooo00<00000oooooooo
ool01?l0000Dooooo`Co00005_ooool3o`00000300000?oooooooooo00?ooooo1?l00003ooooo`Co
0000F_ooool005Sooooo1Ol00005ooooo`?o00001oooool00`00003oooooooooo`09ooooo`Go0000
2oooool00`00003oooooooooo`09ooooo`Co00004oooool3o`0000Wooooo0ol00004ooooo`?o0000
FOooool005Oooooo1Ol00007ooooo`?o00004Oooool4o`0000gooooo00<00000ooooooooool02_oo
ool4o`0000oooooo0P000003o`0000_ooooo0ol00004ooooo`?o0000F?ooool005Kooooo1Ol00009
ooooo`;o00003_ooool00`00003o0000o`000002o`00013ooooo00<00000ooooooooool02Oooool0
0`00003oooooo`000003o`0000kooooo0ol00004ooooo`0300000?oooooooooo00Kooooo1?l00003
ooooo`?o0000Eoooool005Gooooo1Ol0000:ooooo`?o00001?ooool00`00003oooooooooo`05oooo
o`0300000?l0003o000000;o00004Oooool00`00003oooooooooo`08ooooo`0400000?oooooooooo
ooooo`Co00003Oooool2o`0000Gooooo00<00000ooooooooool01oooool4o`0000?ooooo0ol0001F
ooooo`00E?ooool5o`0000cooooo0ol00003ooooo`0300000?oooooooooo00Cooooo1?l0000Toooo
o`Co00002_ooool3o`000003ooooo`000000000000?ooooo00<00000ooooooooool02?ooool3o`00
00?ooooo0_l000000`00003oooooooooo`1Cooooo`00Doooool4o`0000oooooo0_l00003ooooo`03
00000?oooooooooo00?ooooo1?l0000Vooooo`Go00001oooool3o`0000Cooooo00<00000oooooooo
ool03?ooool4o`000005ooooool0003o0000o`0000000000E?ooool005;ooooo1?l0000@ooooo`?o
00000_ooool01000003oooooooooooooool4o`0001Sooooo00<00000ooooooooool01Oooool00`00
003oooooooooo`07ooooo`Co00001Oooool3o`0000Kooooo00<00000ooooooooool03?ooool4o`00
0004ooooool0003o0000o`0005Cooooo001Aooooo`Co00004_ooool3o`0000Cooooo1?l0000Ioooo
o`0300000?oooooooooo00Gooooo00<00000ooooooooool02Oooool4o`0000;ooooo0ol0000;oooo
o`0300000?oooooooooo00[ooooo0ol000001?oooooo0000o`000?l0001Cooooo`00D?ooool4o`00
01Cooooo0_l00002ooooo`Co00007?ooool00`00003oooooooooo`03ooooo`0300000?oooooooooo
00_ooooo1ol0000:ooooo`0300000?ooool0000000gooooo0ol000001?oooooo0000o`000?l0001B
ooooo`00Coooool4o`0001Gooooo1ol0000Sooooo`0300000?oooooooooo00gooooo1?l0000<oooo
o`0300000?ooool0000000gooooo1_l0001Booooo`00C_ooool4o`000003ooooo`00003ooooo01Co
oooo1?l0000dooooo`Ko00003?ooool2000000kooooo1_l0001Aooooo`00COooool4o`0000;ooooo
00<00000ooooooooool04_ooool6o`00023ooooo00<00000ooooooooool03_ooool4o`0000;ooooo
0ol0000=ooooo`0300000?oooooooooo00gooooo1Ol0001@ooooo`00C?ooool4o`0000;ooooo00<0
0000ooooooooool04_ooool3o`0000;ooooo1?l0000Nooooo`0400000?oooooooooo000000cooooo
1?l00004ooooo`?o00003?ooool2000000oooooo1Ol0001?ooooo`00Boooool3o`0000Cooooo00<0
0000ooooooooool04Oooool3o`0000Cooooo1?l0000Nooooo`0300000?ooool0000000[ooooo1?l0
0007ooooo`?o00002_ooool01000003oooooooooo`00000?ooooo`Co0000Coooool004[ooooo0ol0
000Hooooo`?o000000?ooooo00000?ooool01?ooool3o`0001gooooo0P00000:ooooo`Co00002Ooo
ool4o`0000Sooooo00<00000ooooooooool04Oooool4o`0004kooooo0019ooooo`?o00006?ooool3
o`0000?ooooo00<00000ooooooooool00oooool4o`0001_ooooo0P000008ooooo`Co00003?ooool4
o`0000gooooo0P00000=ooooo`0400000?l0003o0000o`0004gooooo0018ooooo`?o00001_ooool0
0`00003oooooooooo`0>ooooo`0400000?l0003o0000o`0000_ooooo1?l0000Iooooo`0400000?oo
oooooooo000000Kooooo1?l0000?ooooo`?o00003_ooool00`00003oooooooooo`0;ooooo`040000
0?l0003o0000o`0004cooooo0017ooooo`?o00001oooool00`00003oooooooooo`0=ooooo`040000
0?l0003o0000o`0000kooooo1?l0000Fooooo`0300000?oooooooooo00;ooooo00@00000oooooooo
oooooooo1?l0000Booooo`?o00001?ooool00`00003oooooooooo`0Fooooo`?o0000Boooool004Ko
oooo0ol00007ooooo`0300000?oooooooooo00gooooo1?l00007ooooo`0300000?oooooooooo00Ko
oooo1?l0000Mooooo`Co00005?ooool3o`0000?ooooo00<00000ooooooooool02Oooool2000000co
oooo0_l0001;ooooo`00AOooool3o`0000Sooooo00<00000ooooooooool02oooool00`00003o0000
o`000002o`0000Wooooo00<00000ooooooooool01oooool4o`00017ooooo00<00000ooooooooool0
1Oooool4o`0001Oooooo1?l000000`00003oooooooooo`0<ooooo`0300000?oooooooooo00Oooooo
00<00000o`000?l000000_l0001:ooooo`00AOooool2o`0001Kooooo00@00000o`000?l0003o0000
3?ooool00`00003oooooooooo`07ooooo`Co00003oooool00`00003oooooooooo`05ooooo`Co0000
00<00000ooooooooool05_ooool4o`0000oooooo00<00000ooooooooool01_ooool5o`0004[ooooo
0015ooooo`?o00005?ooool01000003o0000o`000?l0000Iooooo`?o00003Oooool00`00003ooooo
ooooo`04ooooo`Co00000oooool00`00003oooooooooo`0Gooooo`?o00004?ooool2000000Cooooo
0ol000001?oooooo0000o`000?l00019ooooo`00A?ooool4o`0000Oooooo00<00000ooooooooool0
1_ooool2000000;ooooo0ol0000Kooooo`Co00004Oooool4o`0001oooooo0ol0000Aooooo`030000
0?oooooooooo00?o000000<00000ooooooooool00_l00019ooooo`00A?ooool5o`0000Kooooo00<0
0000ooooooooool01Oooool01000003oooooooooooooool3o`00013ooooo00<00000ooooooooool0
2_ooool4o`0000Oooooo00<00000ooooooooool01?ooool4o`0000Sooooo00<00000ooooooooool0
5Oooool00`00003oooooo`000003o`00013ooooo00@00000ooooool0003o00001?ooool3o`0004So
oooo0014ooooo`;o000000Coooooo`000?l0003o00001?ooool00`00003oooooooooo`05ooooo`04
00000?ooooooooooooooo`?o00004Oooool00`00003oooooooooo`0<ooooo`Co00001?ooool00`00
003oooooooooo`04ooooo`Co00002_ooool00`00003oooooooooo`0Dooooo`0300000?oooooooooo
00Co00004?ooool3o`0000Gooooo0_l00018ooooo`00@oooool3o`0000;ooooo0_l00004ooooo`03
00000?oooooooooo00Sooooo0ol0000Cooooo`0300000?oooooooooo00cooooo1?l00002ooooo`03
00000?oooooooooo00?ooooo1?l0000=ooooo`0300000?oooooooooo01;ooooo00<00000oooooooo
ool00oooool3o`0000kooooo0ol00002000000;ooooo00<00000ooooool000000_l00017ooooo`00
@oooool2o`0000?ooooo0ol00008ooooo`8000000oooool3o`0001Cooooo00<00000ooooooooool0
3_ooool3o`0000Kooooo1?l0000Sooooo`0300000?oooooooooo00Cooooo0ol0000<ooooo`?o0000
0oooool00`00003ooooo00000002ooooo`;o0000Aoooool004?ooooo0_l00004ooooo`;o00001_oo
ool2000000?ooooo1?l0000Wooooo`Co00000_ooool4o`0001?ooooo00<00000ooooooooool05ooo
ool3o`0000[ooooo0ol00007ooooo`0300000?oooooo000000;o0000A_ooool004;ooooo0ol00004
ooooo`?o000000?ooooo00000?ooool01_ooool4o`0002Sooooo00<00000o`000?l000001_l0000E
ooooo`0300000?oooooooooo01Oooooo1?l00007ooooo`?o00002?ooool00`00003oooooooooo`02
o`0004Kooooo0012ooooo`;o00001_ooool2o`000003ooooo`000000000000Gooooo0ol0000Joooo
o`0300000?oooooooooo00cooooo00@00000oooooooooooooooo1?l0000Hooooo`0300000?oooooo
oooo00_ooooo00<00000ooooooooool02Oooool4o`0000Kooooo0_l0000:ooooo`0300000?oooooo
000000;o0000AOooool004;ooooo0_l00006ooooo`?o000000<00000ooooooooool00oooool3o`00
01_ooooo00<00000ooooooooool03oooool6o`0002Gooooo00<00000ooooooooool02oooool3o`00
00Cooooo0ol0000:ooooo`0300000?oooooooooo00;o0000AOooool004;ooooo0_l00007ooooo`;o
00001Oooool3o`0001gooooo00<00000ooooooooool02?ooool00`00003oooooooooo`02ooooo`?o
00000_ooool3o`0001Wooooo0P000008ooooo`0300000?oooooooooo00gooooo0ol00002ooooo`?o
00002_ooool01000003ooooo00000?ooool3o`0004Cooooo0011ooooo`?o00001oooool3o`0000?o
oooo0ol0000Xooooo`0300000?oooooooooo00;ooooo0ol00004ooooo`?o00006_ooool00`00003o
ooooooooo`0Fooooo`Ko00002oooool00`00003oooooooooo`02ooooo`;o0000A?ooool0047ooooo
0_l00007ooooo`0300000?oooooo000000;o000000Coooooo`000?l0003o0000:?ooool00`00003o
ooooooooo`02ooooo`?o00001_ooool4o`0003;ooooo1?l0000Aooooo`;o0000A?ooool0047ooooo
0_l0000:ooooo`Go00008_ooool00`00003oooooooooo`08ooooo`?o00002?ooool4o`0001kooooo
00<00000ooooooooool03oooool4o`00017ooooo00@00000o`000?l0003o0000@oooool0043ooooo
0ol00005ooooo`0300000?oooooooooo00;ooooo1?l0000Sooooo`0300000?oooooooooo00Kooooo
1?l0000;ooooo`?o00006Oooool2000000;ooooo00<00000ooooooooool03Oooool7o`0000_ooooo
00<00000ooooooooool00oooool00`00003o0000o`000013ooooo`00@?ooool2o`0000Gooooo00<0
0000ooooooooool01?ooool4o`0002?ooooo00@00000ooooo`00000000000oooool4o`0000gooooo
0ol0000Jooooo`8000003oooool4o`0000;ooooo0_l0000;ooooo`0300000?oooooooooo00Cooooo
0ol00012ooooo`00@?ooool2o`0000Cooooo00<00000ooooooooool01?ooool7o`00027ooooo0P00
0004ooooo`?o00004?ooool4o`0001Wooooo00<00000ooooooooool02oooool4o`0000Cooooo0ol0
0009ooooo`0300000?oooooooooo00Kooooo0_l00012ooooo`00@?ooool2o`0000_ooooo0_l00000
0oooool00000o`000003o`00023ooooo0P000003ooooo`?o00004_ooool4o`0001Oooooo00<00000
ooooo`0000002oooool4o`0000Kooooo0_l0000Booooo`?o0000@Oooool003oooooo0ol0000;oooo
o`;o000000Cooooo00000?oooooooooo1?l0000Looooo`8000000_ooool00`00003oooooo`000002
o`0001Gooooo0ol0000Eooooo`0500000?ooooooooooooooo`0000002Oooool3o`0000Sooooo0ol0
000Booooo`;o0000@Oooool003oooooo0_l00003ooooo`0300000?oooooooooo00Gooooo0ol00005
ooooo`Co00008?ooool3o`0001Oooooo0ol0000Pooooo`Co00002_ooool2o`0000Kooooo00<00000
ooooooooool02Oooool3o`00043ooooo000oooooo`;o00000_ooool00`00003oooooooooo`06oooo
o`;o00002?ooool4o`0001Kooooo00<00000ooooooooool00oooool4o`0001Wooooo1?l0000?oooo
o`0300000?oooooooooo00Oooooo0`0000000ooooooo0000o`000002o`0000_ooooo0ol00005oooo
o`0300000?oooooooooo00[ooooo0_l00010ooooo`00?_ooool3o`000003ooooo`00003ooooo00So
oooo0_l00004ooooo`0300000?oooooooooo00;ooooo1?l0000Dooooo`0300000?oooooooooo00?o
oooo1?l000000oooool000000000000Hooooo`Co00003Oooool00`00003oooooooooo`0:ooooo`Co
00003_ooool2o`0000Cooooo00<00000ooooooooool02oooool3o`0003oooooo000nooooo`;o0000
2oooool3o`0000Cooooo00<00000ooooooooool01?ooool4o`00017ooooo00<00000ooooooooool0
0oooool3o`0000Gooooo00<00000ooooooooool05oooool3o`0000_ooooo00<00000ooooooooool0
2_ooool4o`0000oooooo0ol00003ooooo`0300000?oooooooooo00cooooo0_l0000oooooo`00?_oo
ool2o`0000_ooooo0_l00006ooooo`0300000?oooooooooo00Cooooo1?l0000Eooooo`?o00001ooo
ool00`00003oooooooooo`0Gooooo`?o00005Oooool4o`0000;ooooo0P00000>ooooo`;o00004_oo
ool3o`0003kooooo000mooooo`?o00002oooool2o`0000oooooo1?l0000:ooooo`8000001_ooool3
o`0002?ooooo1?l00006ooooo`0300000?oooooooooo00Wooooo1?l00005ooooo`0300000?oooooo
oooo00_ooooo0ol0000Booooo`;o0000?_ooool003gooooo0_l0000;ooooo`?o00004?ooool4o`00
00Sooooo00<00000ooooooooool01Oooool3o`0000_ooooo0P00000Hooooo`Co00001?ooool00`00
003oooooooooo`08ooooo`Co00002?ooool00`00003oooooooooo`0;ooooo`;o000000?ooooo0000
0?ooool03_ooool3o`0003kooooo000mooooo`;o00002oooool2o`0000Wooooo00<00000oooooooo
ool01oooool4o`0000cooooo1?l0000>ooooo`0300000?oooooooooo01Oooooo0ol00002ooooo`03
00000?oooooooooo00Sooooo1?l0000Gooooo`?o000000<00000ooooooooool03?ooool3o`0003oo
oooo000mooooo`?o00002_ooool2o`0000Wooooo00<00000ooooooooool02?ooool4o`0000;ooooo
00<00000ooooooooool01Oooool4o`0002[ooooo0ol0000;ooooo`?o00003_ooool2000000[ooooo
0_l0000>ooooo`Co0000?oooool003kooooo0_l00009ooooo`?o00002_ooool00`00003ooooooooo
o`09ooooo`Co00001oooool3o`0001Cooooo00<00000ooooooooool05_ooool4o`0000Oooooo1?l0
000Aooooo`0300000?oooooooooo00Oooooo0_l0000=ooooo`Go0000?oooool003kooooo0ol00008
ooooo`;o00002oooool00`00003oooooooooo`0:ooooo`Co00001Oooool3o`0001Kooooo00<00000
ooooooooool05?ooool00`00003oooooo`000003o`0000Gooooo1?l0000Looooo`?o00003?ooool4
o`00043ooooo000oooooo`;o000000<00000ooooooooool01Oooool2o`0001[ooooo1?l00002oooo
o`?o00006?ooool00`00003oooooooooo`0Booooo`0300000?oooooooooo00;ooooo0ol00002oooo
o`Co00005oooool2000000Kooooo0_l0000;ooooo`Go0000@?ooool003oooooo0ol00006ooooo`?o
00005Oooool2000000Cooooo1ol0000dooooo`Oo00006_ooool00`00003oooooooooo`02ooooo`04
00000?l0003o0000o`0000Wooooo1Ol00011ooooo`00@?ooool2o`00000300000?oooooooooo00?o
oooo0_l0000>ooooo`0300000?oooooooooo00Cooooo00<00000ooooooooool01_ooool4o`0001go
oooo00<00000ooooooooool03?ooool00`00003oooooooooo`07ooooo`Co00008Oooool01000003o
ooooo`000?l00008ooooo`Ko0000@Oooool0043ooooo0ol00005ooooo`;o00003_ooool00`00003o
ooooooooo`0>ooooo`Co00007Oooool00`00003oooooooooo`0:ooooo`0300000?oooooooooo00Oo
oooo1?l0000Pooooo`04o`000000003oooooooooo`?o00001_ooool3o`000003ooooool0003o0000
04;ooooo0011ooooo`;o00001?ooool3o`0000oooooo00@00000ooooo`00000000002oooool6o`00
01gooooo00<00000ooooooooool02?ooool00`00003oooooooooo`07ooooo`Ko00007oooool20000
00?ooooo0_l00005ooooo`?o00000_ooool2o`0004;ooooo0011ooooo`?o00000oooool2o`00017o
oooo00<00000ooooooooool02oooool2o`0000;ooooo0ol0000`ooooo`?o00000_ooool2o`0001ko
oooo00<00000ooooo`0000000oooool3o`0000Cooooo0_l00002ooooo`?o0000@_ooool004;ooooo
0_l000000`00003oooooooooo`02o`00013ooooo00<00000ooooo`0000003?ooool2o`0000?ooooo
1?l0000Mooooo`0300000?oooooooooo00gooooo0ol00003ooooo`?o00007?ooool01@00003ooooo
ooooooooool0000000?ooooo0_l00003ooooo`?o00000_ooool2o`0004?ooooo0012ooooo`?o0000
00Coooooo`000?l0003o00003oooool01@00003oooooooooooooool0000000[ooooo0ol00004oooo
o`Co00007Oooool01000003oooooooooooooool2000000Sooooo0ol00005ooooo`;o00009?ooool3
o`000004ooooool0003o0000o`0000;ooooo0ol00013ooooo`00@oooool2o`00000300000?l0003o
000001oooooo0_l00007ooooo`?o00007Oooool00`00003ooooo00000008ooooo`Co00001_ooool3
o`0001Wooooo00<00000ooooooooool02?ooool5o`0000?ooooo0_l00014ooooo`00@oooool5o`00
01Oooooo00<00000ooooooooool01Oooool2o`0000Sooooo0ol0000Looooo`<000001oooool4o`00
00Sooooo0ol0000Gooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01?l00003oooo
o`?o0000A?ooool004Cooooo1?l0000>ooooo`0300000?oooooooooo00Oooooo00<00000oooooooo
ool00oooool3o`0000Wooooo1?l0000Iooooo`0500000?ooooooooooooooo`0000001Oooool3o`00
00_ooooo0_l0000Fooooo`0300000?oooooooooo00Sooooo00<00000o`000?l000000_l00004oooo
o`;o0000AOooool004Cooooo1?l0000=ooooo`0300000?oooooooooo00Wooooo00<00000oooooooo
ool00_ooool2o`0000_ooooo1?l0000Qooooo`?o00003?ooool3o`0001oooooo1_l00004ooooo`;o
0000AOooool004Gooooo1?l0000;ooooo`0300000?oooooooooo00oooooo0_l0000=ooooo`?o0000
5?ooool00`00003oooooooooo`07ooooo`0400000?l0003o0000o`0000kooooo0_l0000Booooo`03
00000?oooooooooo00Wooooo1_l00004ooooo`?o0000AOooool004Gooooo1_l0000Iooooo`040000
0?l0003o0000o`0000kooooo0ol0000Booooo`0300000?oooooooooo00Sooooo0ol0000?ooooo`?o
00004?ooool00`00003oooooooooo`08ooooo`Co00000_ooool2o`0000Cooooo0_l00016ooooo`00
A_ooool6o`0001Wooooo0_l0000@ooooo`Co00003oooool00`00003oooooooooo`07ooooo`Co0000
00<00000ooooooooool03_ooool2o`0000oooooo00<00000ooooooooool02?ooool4o`0000;ooooo
0ol00003ooooo`?o0000A_ooool004Kooooo0ol000000ooooooo0000o`000002o`0000Cooooo00<0
0000ooooooooool04?ooool2o`00017ooooo1?l0000Gooooo`Co00004_ooool3o`0001Oooooo1?l0
0004ooooo`;o000000@00000oooooooooooooooo0_l00017ooooo`00Aoooool2o`0000;ooooo1?l0
0002ooooo`0300000?oooooooooo013ooooo0ol0000Cooooo`?o00002Oooool2000000[ooooo0ol0
0006ooooo`<000003?ooool2o`0000_ooooo0P000009ooooo`Co00001?ooool3o`000003ooooo`00
003ooooo00?o0000Aoooool004Oooooo0ol000000`00003oooooooooo`04o`0001?ooooo0_l00002
ooooo`8000004Oooool3o`0000Kooooo0P00000;ooooo`?o00002_ooool00`00003oooooooooo`09
ooooo`?o00002Oooool00`00003oooooooooo`07ooooo`Co00001_ooool2o`0000Cooooo0_l00018
ooooo`00B?ooool3o`0000?ooooo1?l0000Booooo`;o00001?ooool00`00003oooooooooo`0?oooo
o`Co00004?ooool3o`0001Sooooo0_l00008ooooo`0300000?oooooooooo00Oooooo1?l00007oooo
o`;o00001?ooool2o`0004Sooooo0019ooooo`;o000000<00000ooooo`0000000_ooool4o`0000oo
oooo0ol00005ooooo`0300000?oooooooooo00oooooo1?l00002000000cooooo0ol0000>ooooo`80
00002Oooool3o`00013ooooo0ol00008ooooo`?o00000oooool3o`0004Sooooo0019ooooo`?o0000
00?ooooo00000?ooool00_ooool4o`0000kooooo0_l0000Jooooo`?o00002oooool4o`00017ooooo
00<00000ooooooooool01oooool2o`0000Gooooo00<00000ooooooooool01_ooool4o`0000Wooooo
0_l00004ooooo`;o0000BOooool004[ooooo0_l000000`00003oooooooooo`04ooooo`Co00003?oo
ool2o`0000Sooooo0P00000@ooooo`0400000?l0003o0000o`0000Wooooo1?l0000Cooooo`030000
0?oooooooooo00Kooooo0ol00003ooooo`0300000?oooooooooo00Kooooo1?l0000:ooooo`;o0000
0oooool3o`0004Wooooo001:ooooo`?o000000<00000ooooooooool01?ooool4o`0000[ooooo0ol0
000:ooooo`0300000?oooooooooo00oooooo1?l00006ooooo`?o00007oooool3o`000003ooooo`00
003ooooo00Kooooo1?l0000;ooooo`?o00000_ooool3o`0004[ooooo001;ooooo`;o00000P000007
ooooo`Co00002?ooool2o`0001Sooooo0P000004ooooo`Co00001?ooool3o`0001Sooooo0`000006
ooooo`;o00002?ooool4o`0000cooooo0_l000000oooool00000o`000002o`0004_ooooo001;oooo
o`?o00002Oooool4o`0000Oooooo0_l0000>ooooo`0300000?oooooooooo00Gooooo0P000008oooo
o`?o00000_ooool3o`0001cooooo00<00000ooooooooool00oooool3o`0000Gooooo1?l0000=oooo
o`?o000000@00000ooooool0003o0000C?ooool004cooooo0_l00003ooooo`8000001_ooool4o`00
00Cooooo0ol0000?ooooo`0300000?oooooooooo00oooooo1_l0000Rooooo`0400000?oooooo0000
o`0000Cooooo1?l0000>ooooo`;o000000<00000ooooool000000_l0001<ooooo`00C?ooool3o`00
000500000?ooooooooooooooo`0000001_ooool4o`0000?ooooo0_l0000Aooooo`0400000?oooooo
ooooo`0000kooooo1?l0000Qooooo`04o`000000003oooooooooo`?o000000?oooooo`000?l00000
0_l0000@ooooo`;o000000Coooooo`000?l0003o0000COooool004gooooo0_l000000`00003ooooo
ooooo`0:ooooo`Co000000?oooooo`000?l000004oooool00`00003oooooooooo`0>ooooo`;o0000
8Oooool2000000Cooooo1_l0000@ooooo`Ko0000C_ooool004gooooo0ol000000`00003ooooooooo
o`03ooooo`0300000?oooooooooo00Cooooo1_l0000Booooo`0300000?ooool0000000kooooo1?l0
000Oooooo`0400000?oooooooooo000000?ooooo1?l0000Booooo`;o000000?oooooo`000?l00000
Coooool004kooooo0_l000000`00003oooooooooo`04ooooo`0300000?oooooooooo00Gooooo1?l0
000Aooooo`0500000?ooooooooooooooo`0000003Oooool4o`0002?ooooo00<00000ooooool00000
0ol0000Booooo`Ko0000Coooool004kooooo0ol00007ooooo`0300000?oooooooooo00Gooooo1?l0
000Rooooo`Go00006oooool00`00003oooooooooo`05ooooo`Go00004_ooool5o`00053ooooo001?
ooooo`?o00003_ooool5o`0001Kooooo0P000008ooooo`?o000000?oooooo`000?l000006_ooool0
0`00003oooooooooo`05ooooo`Go00004?ooool00`00003oooooooooo`04o`00057ooooo001@oooo
o`;o000000<00000ooooooooool01Oooool2000000Gooooo1Ol0000<ooooo`0300000?oooooooooo
00Sooooo00<00000ooooooooool01Oooool2o`0000;ooooo0ol0000Hooooo`0300000?oooooooooo
00Gooooo0ol000000`00003o0000o`00000?ooooo`0300000?oooooooooo00Co0000D_ooool0053o
oooo0ol00009ooooo`0300000?oooooooooo00;ooooo1_l0000:ooooo`0300000?oooooooooo017o
oooo0_l00003ooooo`?o00007_ooool3o`000004ooooool0003o0000o`0000kooooo00@00000oooo
oooooooooooo1?l0001Booooo`00DOooool2o`00000300000?oooooooooo00Oooooo00<00000oooo
ooooool00_ooool2o`000003ooooool0003o000000;o00001oooool00`00003oooooooooo`0=oooo
o`0400000?ooooooooooooooo`?o00001?ooool2o`0001?ooooo0P000007ooooo`Co00000_ooool2
o`0001?ooooo0ol0001Cooooo`00DOooool3o`0000kooooo0ol000000ooooooo0000o`000002o`00
01Oooooo00<00000ooooooooool00_l00005ooooo`?o00004Oooool00`00003oooooooooo`06oooo
o`Co00000_ooool3o`0000cooooo00<00000ooooooooool00_ooool4o`0005Cooooo001Booooo`;o
00002oooool01000003oooooooooooooool3o`0000;ooooo0ol0000Gooooo`0400000?l0003o0000
o`0000Kooooo0_l0000Iooooo`?o00001?ooool2o`0000cooooo00<00000ooooooooool00_ooool4
o`0005Gooooo001Booooo`Co00002_ooool01000003oooooooooooooool2o`0000?ooooo0ol00002
ooooo`0300000?oooooooooo01;ooooo0_l00007ooooo`?o00003Oooool00`00003oooooooooo`07
ooooo`?o00001Oooool2o`0000;ooooo00<00000ooooooooool01_ooool01000003ooooooooooooo
ool4o`0005Oooooo001Cooooo`Co00002_ooool00`00003oooooooooo`03o`0000?ooooo0ol00000
0`00003oooooooooo`0Cooooo`;o00000P000006ooooo`;o00003?ooool00`00003oooooooooo`07
ooooo`?o00001Oooool3o`0000;ooooo00<00000ooooooooool02Oooool4o`0005Sooooo001Eoooo
o`Co00003?ooool2o`0000Cooooo1?l0000Cooooo`?o00000_ooool00`00003oooooooooo`03oooo
o`?o00002_ooool00`00003oooooooooo`07ooooo`?o00001_ooool2o`0000Cooooo00<00000oooo
ooooool00oooool00`00003oooooooooo`05o`0005Wooooo001Fooooo`Co00002_ooool01000003o
0000o`000?l00004ooooo`Co00004_ooool2o`0000[ooooo0_l00006ooooo`8000002_ooool4o`00
00Kooooo0ol00009ooooo`0300000?oooooooooo00Go0000F_ooool005Oooooo1Ol00009ooooo`03
00000?l0003o000000;ooooo00@00000oooooooooooooooo0ol0000Aooooo`;o00001_ooool01000
003oooooooooooooool3o`0000Cooooo00<00000ooooooooool02Oooool4o`0000Oooooo0_l00009
ooooo`0300000?oooooooooo00Go0000Foooool005Wooooo1?l00009ooooo`?o000000<00000oooo
ooooool00oooool3o`0000oooooo0ol00007ooooo`0400000?ooooooooooooooo`;o00000oooool0
0`00003oooooooooo`09ooooo`?o00002?ooool3o`0000Oooooo00<00000ooooooooool01_l0001L
ooooo`00F_ooool5o`0000Sooooo0_l00007ooooo`Co00003Oooool2o`0000Wooooo00<00000oooo
ooooool00ol0000=ooooo`?o00002Oooool2o`0000Oooooo0P0000000ooooooo0000o`000004o`00
05gooooo001Kooooo`Go00001oooool3o`0000Oooooo1?l0000<ooooo`;o00003Oooool2o`000003
00000?oooooooooo00Wooooo0ol0000:ooooo`;o00001_ooool2000000Oo0000G_ooool005gooooo
1Ol00006ooooo`;o000000<00000ooooooooool01_ooool3o`0000[ooooo0ol0000<ooooo`Co0000
2_ooool3o`0000[ooooo0ol00007ooooo`Ko0000H?ooool005kooooo1Ol00005ooooo`?o00002Ooo
ool3o`0000Wooooo0_l0000=ooooo`8000000ol00007ooooo`Co00002oooool2o`0000?ooooo0P00
00000ooooooo0000o`000005o`00067ooooo001Oooooo`Ko00001?ooool2o`0000;ooooo0P000006
ooooo`?o00001oooool3o`0000cooooo00@00000ooooooooool000000_l00006ooooo`Co00002ooo
ool3o`0000;ooooo00<00000ooooooooool01ol0001Rooooo`00HOooool5o`0000?ooooo0ol00003
ooooo`0300000?oooooooooo00Cooooo1?l00005ooooo`;o00004?ooool01000003o0000o`000?l0
0004ooooo`?o00003Oooool2o`0000Cooooo1?l000001?oooooo0000o`000?l0001Sooooo`00H_oo
ool6o`0000;ooooo0ol0000:ooooo`Co00001?ooool2o`0001;ooooo0_l00003ooooo`?o00003_oo
ool2o`00000300000?oooooooooo00Co000000Coooooo`000?l0003o0000I?ooool006?ooooo1_l0
0002ooooo`;o00001Oooool00`00003oooooooooo`04ooooo`?o00000_ooool3o`0000_ooooo00<0
0000ooooooooool01?ooool3o`000004ooooool0003o0000o`0000kooooo0ol00002ooooo`?o0000
0_ooool3o`0006Gooooo001Tooooo`[o00001Oooool00`00003oooooooooo`04ooooo`?o000000?o
ooooo`000?l000002oooool00`00003oooooooooo`05ooooo`0300000?l0003o000000?o00003ooo
ool2o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0001Vooooo`00I_ooool8
o`0000Kooooo00<00000ooooooooool01?ooool5o`0000[ooooo00<00000ooooooooool01_ooool0
0`00003o0000o`000002o`0000oooooo1ol000000`00003o0000o`000002o`0006Oooooo001Woooo
o`So00003Oooool4o`0001Cooooo00<00000o`000?l000003_ooool2000000Go000000?ooooo0000
0?l000000_l0001Yooooo`00J?ooool7o`0000Sooooo0`000003ooooo`;o00005Oooool3o`0000go
oooo00<00000ooooooooool01?l000000oooool00000o`000002o`0006[ooooo001Zooooo`Oo0000
2Oooool00`00003oooooooooo`03o`0000Sooooo00<00000ooooooooool02Oooool2o`0000oooooo
1?l00003ooooo`?o0000Joooool006_ooooo1ol0000<ooooo`;o00001oooool00`00003ooooooooo
o`0:ooooo`;o000000<00000ooooooooool02?ooool00`00003oooooooooo`04o`0000?ooooo0ol0
001/ooooo`00K?ooool7o`0000Wooooo0P000003o`0000Gooooo00<00000ooooooooool02_ooool3
o`00000300000?oooooooooo00Oooooo00<00000ooooooooool00ol00004ooooo`?o0000KOooool0
06kooooo1_l0000:ooooo`0400000?l0003o0000o`00017ooooo0_l00002ooooo`0300000?oooooo
oooo00Gooooo00<00000ooooooooool00ol00004ooooo`?o0000K_ooool006oooooo1ol00009oooo
o`0300000?l0003o0000013ooooo0ol0000<ooooo`?o00000oooool4o`0006oooooo001`ooooo`Oo
00002Oooool3o`000003ooooo`00003ooooo00cooooo0_l00007ooooo`8000000oooool3o`0000?o
oooo1?l0001`ooooo`00L_ooool6o`0000Wooooo0_l000000`00003oooooooooo`0<ooooo`;o0000
1Oooool2000000?ooooo1?l00002ooooo`Co0000L_ooool007?ooooo1_l00008ooooo`?o00003Ooo
ool3o`0000Gooooo00@00000oooooooooooooooo1?l00002ooooo`Co0000Loooool007Gooooo1_l0
0007ooooo`;o00003Oooool2o`0000Gooooo00@00000oooooooooooooooo0ol00002ooooo`Co0000
MOooool007Kooooo1_l00006ooooo`?o00003?ooool2o`0000Gooooo00<00000ooooooooool00ol0
0002ooooo`Co0000M_ooool007Oooooo1_l00006ooooo`;o00002oooool3o`0000Oooooo0ol00000
0ooooooo0000o`000002o`0007Sooooo001iooooo`Ko00001?ooool3o`0000[ooooo0_l00003oooo
o`0300000?oooooooooo00Co000000?oooooo`000?l000000_l0001iooooo`00N_ooool6o`0000Co
oooo0ol00008ooooo`?o00000oooool00`00003oooooo`000007o`0007_ooooo001looooo`Go0000
1?ooool2o`0000Sooooo0_l00003ooooo`0300000?oooooo000000Oo0000O?ooool007gooooo1Ol0
0003ooooo`?o00001oooool2o`0000Cooooo1ol0001nooooo`00Ooooool5o`0000;ooooo0_l00006
ooooo`?o00000oooool6o`00083ooooo0020ooooo`Go000000Coooooo`000?l0003o00001Oooool2
o`0000;ooooo00<00000o`000?l000001?l00021ooooo`00POooool5o`000004ooooool0003o0000
000000?ooooo0ol000000ooooooo0000o`000004o`0008?ooooo0023ooooo`Oo00000oooool2o`00
0003ooooool0003o000000Co0000Q?ooool008Cooooo1_l000000`00003oooooooooo`07o`0008Ko
oooo0026ooooo`Go000000?oooooo`000?l000001Ol00027ooooo`00Qoooool:o`0008Wooooo0028
ooooo`So0000R_ooool008[ooooo1?l0002<ooooo`00Roooool2o`0008gooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.56441 .55118 m
.64894 .61182 L
s
.56441 .55118 m
.46254 .62002 L
s
.64828 .46767 m
.56441 .55118 L
s
.4627 .47682 m
.56441 .55118 L
s
.4627 .47682 m
.36036 .54533 L
s
.54587 .39278 m
.4627 .47682 L
s
.40068 .38809 m
.4627 .47682 L
s
.46254 .62002 m
.54628 .68173 L
s
.46254 .62002 m
.39979 .67798 L
s
.36036 .54533 m
.46254 .62002 L
s
.36036 .54533 m
.29607 .60218 L
s
.29698 .45691 m
.36036 .54533 L
s
.64828 .46767 m
.73439 .52777 L
s
.66604 .37409 m
.64828 .46767 L
s
.54587 .39278 m
.64828 .46767 L
s
.56225 .29817 m
.54587 .39278 L
s
.48428 .30253 m
.54587 .39278 L
s
.40068 .38809 m
.29698 .45691 L
s
.41516 .2931 m
.40068 .38809 L
s
.48428 .30253 m
.40068 .38809 L
s
.64894 .61182 m
.66754 .66675 L
s
.64894 .61182 m
.54628 .68173 L
s
.73439 .52777 m
.64894 .61182 L
s
.29698 .45691 m
.23105 .51302 L
s
.31012 .36241 m
.29698 .45691 L
s
.54628 .68173 m
.5631 .7382 L
s
.54628 .68173 m
.48407 .74131 L
s
.5 .20569 m
.48428 .30253 L
s
.73439 .52777 m
.75469 .58157 L
s
.75353 .4339 m
.73439 .52777 L
s
.39979 .67798 m
.48407 .74131 L
s
.39979 .67798 m
.414 .73457 L
s
.29607 .60218 m
.39979 .67798 L
s
.29607 .60218 m
.30839 .65739 L
s
.23105 .51302 m
.29607 .60218 L
s
.66604 .37409 m
.75353 .4339 L
s
.56225 .29817 m
.66604 .37409 L
s
.6049 .28242 m
.66604 .37409 L
s
.5 .20569 m
.56225 .29817 L
s
.41516 .2931 m
.31012 .36241 L
s
.5 .20569 m
.41516 .2931 L
s
.31012 .36241 m
.24348 .41784 L
s
.39459 .27509 m
.31012 .36241 L
s
.66754 .66675 m
.60634 .72692 L
s
.66754 .66675 m
.5631 .7382 L
s
.75469 .58157 m
.66754 .66675 L
s
.0085 w
[ ] 0 setdash
.23105 .51302 m
.2423 .56719 L
s
.24348 .41784 m
.23105 .51302 L
s
.0035 w
[ .01 .012 ] 0 setdash
.6049 .28242 m
.69261 .34179 L
s
.5 .20569 m
.6049 .28242 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.58647 .26415 L
s
.5 .20569 m
.51623 .25424 L
s
.5 .20569 m
.43611 .25885 L
s
.5 .20569 m
.39459 .27509 L
s
.0035 w
[ .01 .012 ] 0 setdash
.48407 .74131 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.75353 .4339 m
.77446 .48672 L
s
.69261 .34179 m
.75353 .4339 L
s
.0035 w
[ .01 .012 ] 0 setdash
.5631 .7382 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.39459 .27509 m
.32877 .32958 L
s
.75469 .58157 m
.69439 .64086 L
s
.77446 .48672 m
.75469 .58157 L
s
.0035 w
[ .01 .012 ] 0 setdash
.414 .73457 m
.5 .79975 L
s
.30839 .65739 m
.414 .73457 L
s
.0085 w
[ ] 0 setdash
.30839 .65739 m
.39313 .72166 L
s
.2423 .56719 m
.30839 .65739 L
s
.69261 .34179 m
.71263 .39346 L
s
.58647 .26415 m
.69261 .34179 L
s
.58647 .26415 m
.60451 .31438 L
s
.24348 .41784 m
.25512 .47099 L
s
.32877 .32958 m
.24348 .41784 L
s
.60634 .72692 m
.5 .79975 L
s
.69439 .64086 m
.60634 .72692 L
s
.43611 .25885 m
.4514 .30915 L
s
.43611 .25885 m
.32877 .32958 L
s
.2423 .56719 m
.32717 .63106 L
s
.25512 .47099 m
.2423 .56719 L
s
.51623 .25424 m
.60451 .31438 L
s
.51623 .25424 m
.4514 .30915 L
s
.51646 .70672 m
.5 .79975 L
s
.58768 .71382 m
.5 .79975 L
s
.39313 .72166 m
.5 .79975 L
s
.43522 .71002 m
.5 .79975 L
s
.32717 .63106 m
.39313 .72166 L
s
.77446 .48672 m
.71363 .54534 L
s
.71263 .39346 m
.77446 .48672 L
s
.32877 .32958 m
.34211 .38146 L
s
.69439 .64086 m
.58768 .71382 L
s
.71363 .54534 m
.69439 .64086 L
s
.6055 .61888 m
.58768 .71382 L
s
.45094 .61468 m
.43522 .71002 L
s
.32717 .63106 m
.43522 .71002 L
s
.34136 .53459 m
.32717 .63106 L
s
.71263 .39346 m
.65013 .45126 L
s
.60451 .31438 m
.71263 .39346 L
s
.60451 .31438 m
.54029 .37093 L
s
.25512 .47099 m
.34136 .53459 L
s
.34211 .38146 m
.25512 .47099 L
s
.6055 .61888 m
.51646 .70672 L
s
.45094 .61468 m
.51646 .70672 L
s
.4514 .30915 m
.54029 .37093 L
s
.4514 .30915 m
.34211 .38146 L
s
.71363 .54534 m
.6055 .61888 L
s
.65013 .45126 m
.71363 .54534 L
s
.34211 .38146 m
.43008 .44444 L
s
.54048 .52515 m
.6055 .61888 L
s
.54048 .52515 m
.45094 .61468 L
s
.34136 .53459 m
.45094 .61468 L
s
.43008 .44444 m
.34136 .53459 L
s
.65013 .45126 m
.54048 .52515 L
s
.54029 .37093 m
.65013 .45126 L
s
.54029 .37093 m
.43008 .44444 L
s
.43008 .44444 m
.54048 .52515 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.50591 .47737 m
.60899 .54832 L
s
.50591 .47737 m
.40293 .54924 L
s
.57757 .39048 m
.50591 .47737 L
s
.43089 .39122 m
.50591 .47737 L
s
.40293 .54924 m
.50593 .62051 L
s
.40293 .54924 m
.32611 .60814 L
s
.32689 .46356 m
.40293 .54924 L
s
.60899 .54832 m
.6826 .60661 L
s
.60899 .54832 m
.50593 .62051 L
s
.68179 .46185 m
.60899 .54832 L
s
.50593 .62051 m
.57827 .67989 L
s
.50593 .62051 m
.43028 .68049 L
s
.43089 .39122 m
.32689 .46356 L
s
.42745 .29623 m
.43089 .39122 L
s
.50249 .30279 m
.43089 .39122 L
s
.57757 .39048 m
.68179 .46185 L
s
.57613 .29543 m
.57757 .39048 L
s
.50249 .30279 m
.57757 .39048 L
s
.32689 .46356 m
.2484 .52183 L
s
.32201 .36937 m
.32689 .46356 L
s
.68179 .46185 m
.75708 .51949 L
s
.68177 .36753 m
.68179 .46185 L
s
.32611 .60814 m
.43028 .68049 L
s
.32611 .60814 m
.3204 .66298 L
s
.2484 .52183 m
.32611 .60814 L
s
.6826 .60661 m
.68342 .66149 L
s
.6826 .60661 m
.57827 .67989 L
s
.75708 .51949 m
.6826 .60661 L
s
.43028 .68049 m
.50252 .7415 L
s
.43028 .68049 m
.42646 .73681 L
s
.5 .20569 m
.50249 .30279 L
s
.57827 .67989 m
.57717 .73623 L
s
.57827 .67989 m
.50252 .7415 L
s
.42745 .29623 m
.32201 .36937 L
s
.5 .20569 m
.42745 .29623 L
s
.57613 .29543 m
.68177 .36753 L
s
.5 .20569 m
.57613 .29543 L
s
.2484 .52183 m
.24119 .57556 L
s
.24237 .42719 m
.2484 .52183 L
s
.32201 .36937 m
.24237 .42719 L
s
.39371 .27935 m
.32201 .36937 L
s
.68177 .36753 m
.75811 .42464 L
s
.60637 .27818 m
.68177 .36753 L
s
.75708 .51949 m
.75929 .57328 L
s
.75811 .42464 m
.75708 .51949 L
s
.50252 .7415 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.60637 .27818 L
s
.5 .20569 m
.57426 .26089 L
s
.5 .20569 m
.49743 .25396 L
s
.5 .20569 m
.42216 .26173 L
s
.5 .20569 m
.39371 .27935 L
s
.0035 w
[ .01 .012 ] 0 setdash
.3204 .66298 m
.42646 .73681 L
s
.0085 w
[ ] 0 setdash
.3204 .66298 m
.39224 .72471 L
s
.24119 .57556 m
.3204 .66298 L
s
.39371 .27935 m
.31429 .33649 L
s
.60637 .27818 m
.68233 .33455 L
s
.0035 w
[ .01 .012 ] 0 setdash
.68342 .66149 m
.57717 .73623 L
s
.0085 w
[ ] 0 setdash
.68342 .66149 m
.60784 .72388 L
s
.75929 .57328 m
.68342 .66149 L
s
.0035 w
[ .01 .012 ] 0 setdash
.42646 .73681 m
.5 .79975 L
s
.57717 .73623 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.24237 .42719 m
.23495 .4799 L
s
.31429 .33649 m
.24237 .42719 L
s
.75811 .42464 m
.76037 .47741 L
s
.68233 .33455 m
.75811 .42464 L
s
.24119 .57556 m
.31256 .63661 L
s
.23495 .4799 m
.24119 .57556 L
s
.75929 .57328 m
.68402 .63506 L
s
.76037 .47741 m
.75929 .57328 L
s
.42216 .26173 m
.41808 .31172 L
s
.42216 .26173 m
.31429 .33649 L
s
.57426 .26089 m
.68233 .33455 L
s
.57426 .26089 m
.57305 .31089 L
s
.31429 .33649 m
.30816 .388 L
s
.39224 .72471 m
.5 .79975 L
s
.31256 .63661 m
.39224 .72471 L
s
.60784 .72388 m
.5 .79975 L
s
.68402 .63506 m
.60784 .72388 L
s
.68233 .33455 m
.68317 .38609 L
s
.49739 .70652 m
.5 .79975 L
s
.5753 .71149 m
.5 .79975 L
s
.42107 .71209 m
.5 .79975 L
s
.49743 .25396 m
.57305 .31089 L
s
.49743 .25396 m
.41808 .31172 L
s
.23495 .4799 m
.30725 .54045 L
s
.30816 .388 m
.23495 .4799 L
s
.31256 .63661 m
.42107 .71209 L
s
.30725 .54045 m
.31256 .63661 L
s
.68402 .63506 m
.5753 .71149 L
s
.68403 .53874 m
.68402 .63506 L
s
.76037 .47741 m
.68403 .53874 L
s
.68317 .38609 m
.76037 .47741 L
s
.41731 .61674 m
.42107 .71209 L
s
.57375 .61608 m
.5753 .71149 L
s
.41808 .31172 m
.49361 .37029 L
s
.41808 .31172 m
.30816 .388 L
s
.57375 .61608 m
.49739 .70652 L
s
.41731 .61674 m
.49739 .70652 L
s
.57305 .31089 m
.68317 .38609 L
s
.57305 .31089 m
.49361 .37029 L
s
.30816 .388 m
.38223 .44779 L
s
.68317 .38609 m
.60505 .44671 L
s
.30725 .54045 m
.41731 .61674 L
s
.38223 .44779 m
.30725 .54045 L
s
.68403 .53874 m
.57375 .61608 L
s
.60505 .44671 m
.68403 .53874 L
s
.49358 .52458 m
.41731 .61674 L
s
.49358 .52458 m
.57375 .61608 L
s
.49361 .37029 m
.60505 .44671 L
s
.49361 .37029 m
.38223 .44779 L
s
.38223 .44779 m
.49358 .52458 L
s
.60505 .44671 m
.49358 .52458 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.44811 .5517 m
.54917 .61965 L
s
.44811 .5517 m
.361 .61305 L
s
.54895 .47641 m
.44811 .5517 L
s
.36161 .46904 m
.44811 .5517 L
s
.54895 .47641 m
.65064 .54402 L
s
.60711 .38704 m
.54895 .47641 L
s
.46304 .3932 m
.54895 .47641 L
s
.54917 .61965 m
.60807 .67714 L
s
.54917 .61965 m
.46271 .68207 L
s
.65064 .54402 m
.54917 .61965 L
s
.65064 .54402 m
.71116 .60039 L
s
.71021 .45491 m
.65064 .54402 L
s
.36161 .46904 m
.27299 .52988 L
s
.33911 .37576 m
.36161 .46904 L
s
.46304 .3932 m
.36161 .46904 L
s
.44187 .29882 m
.46304 .3932 L
s
.52063 .30233 m
.46304 .3932 L
s
.361 .61305 m
.46271 .68207 L
s
.361 .61305 m
.33766 .66809 L
s
.27299 .52988 m
.361 .61305 L
s
.60711 .38704 m
.71021 .45491 L
s
.58777 .29217 m
.60711 .38704 L
s
.52063 .30233 m
.60711 .38704 L
s
.46271 .68207 m
.52091 .74117 L
s
.46271 .68207 m
.44107 .73866 L
s
.71021 .45491 m
.77234 .51051 L
s
.69216 .36044 m
.71021 .45491 L
s
.27299 .52988 m
.2479 .58379 L
s
.24904 .43637 m
.27299 .52988 L
s
.5 .20569 m
.52063 .30233 L
s
.33911 .37576 m
.24904 .43637 L
s
.39606 .28356 m
.33911 .37576 L
s
.44187 .29882 m
.33911 .37576 L
s
.5 .20569 m
.44187 .29882 L
s
.60807 .67714 m
.58897 .7339 L
s
.60807 .67714 m
.52091 .74117 L
s
.71116 .60039 m
.60807 .67714 L
s
.71116 .60039 m
.69391 .65581 L
s
.77234 .51051 m
.71116 .60039 L
s
.58777 .29217 m
.69216 .36044 L
s
.5 .20569 m
.58777 .29217 L
s
.33766 .66809 m
.44107 .73866 L
s
.33766 .66809 m
.39462 .72773 L
s
.2479 .58379 m
.33766 .66809 L
s
.69216 .36044 m
.75484 .4153 L
s
.6046 .27394 m
.69216 .36044 L
s
.39606 .28356 m
.30562 .34381 L
s
.5 .20569 m
.39606 .28356 L
s
.0085 w
[ ] 0 setdash
.24904 .43637 m
.22318 .48931 L
s
.30562 .34381 m
.24904 .43637 L
s
.5 .20569 m
.6046 .27394 L
s
.5 .20569 m
.55971 .25816 L
s
.5 .20569 m
.47871 .25444 L
s
.5 .20569 m
.41065 .26512 L
s
.0035 w
[ .01 .012 ] 0 setdash
.52091 .74117 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.77234 .51051 m
.75602 .56491 L
s
.75484 .4153 m
.77234 .51051 L
s
.0035 w
[ .01 .012 ] 0 setdash
.44107 .73866 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.2479 .58379 m
.30382 .64248 L
s
.22318 .48931 m
.2479 .58379 L
s
.6046 .27394 m
.66632 .32779 L
s
.58897 .7339 m
.5 .79975 L
s
.69391 .65581 m
.58897 .7339 L
s
.69391 .65581 m
.60605 .72084 L
s
.75602 .56491 m
.69391 .65581 L
s
.30562 .34381 m
.28051 .39564 L
s
.41065 .26512 m
.30562 .34381 L
s
.41065 .26512 m
.38746 .31554 L
s
.39462 .72773 m
.5 .79975 L
s
.30382 .64248 m
.39462 .72773 L
s
.75484 .4153 m
.73797 .46868 L
s
.66632 .32779 m
.75484 .4153 L
s
.55971 .25816 m
.66632 .32779 L
s
.55971 .25816 m
.53919 .30868 L
s
.22318 .48931 m
.27948 .5473 L
s
.28051 .39564 m
.22318 .48931 L
s
.47871 .25444 m
.53919 .30868 L
s
.47871 .25444 m
.38746 .31554 L
s
.47841 .70687 m
.5 .79975 L
s
.56055 .70953 m
.5 .79975 L
s
.60605 .72084 m
.5 .79975 L
s
.40941 .71452 m
.5 .79975 L
s
.75602 .56491 m
.66787 .62963 L
s
.73797 .46868 m
.75602 .56491 L
s
.66787 .62963 m
.60605 .72084 L
s
.30382 .64248 m
.40941 .71452 L
s
.27948 .5473 m
.30382 .64248 L
s
.66632 .32779 m
.64767 .3799 L
s
.3864 .6198 m
.40941 .71452 L
s
.28051 .39564 m
.3384 .45277 L
s
.38746 .31554 m
.28051 .39564 L
s
.38746 .31554 m
.44716 .37141 L
s
.53956 .61431 m
.56055 .70953 L
s
.66787 .62963 m
.56055 .70953 L
s
.64837 .53319 m
.66787 .62963 L
s
.53956 .61431 m
.47841 .70687 L
s
.3864 .6198 m
.47841 .70687 L
s
.73797 .46868 m
.64837 .53319 L
s
.64767 .3799 m
.73797 .46868 L
s
.27948 .5473 m
.3864 .6198 L
s
.3384 .45277 m
.27948 .5473 L
s
.53919 .30868 m
.64767 .3799 L
s
.53919 .30868 m
.44716 .37141 L
s
.4469 .52558 m
.3864 .6198 L
s
.64767 .3799 m
.55639 .44382 L
s
.64837 .53319 m
.53956 .61431 L
s
.4469 .52558 m
.53956 .61431 L
s
.55639 .44382 m
.64837 .53319 L
s
.3384 .45277 m
.4469 .52558 L
s
.44716 .37141 m
.3384 .45277 L
s
.44716 .37141 m
.55639 .44382 L
s
.55639 .44382 m
.4469 .52558 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.49468 .55264 m
.59107 .61746 L
s
.49468 .55264 m
.39971 .61679 L
s
.59067 .47397 m
.49468 .55264 L
s
.40015 .47322 m
.49468 .55264 L
s
.59067 .47397 m
.68817 .5384 L
s
.63362 .38255 m
.59067 .47397 L
s
.49621 .39395 m
.59067 .47397 L
s
.40015 .47322 m
.30399 .53695 L
s
.36086 .38139 m
.40015 .47322 L
s
.49621 .39395 m
.40015 .47322 L
s
.45798 .30081 m
.49621 .39395 L
s
.53817 .30117 m
.49621 .39395 L
s
.59107 .61746 m
.63482 .67353 L
s
.59107 .61746 m
.49617 .68267 L
s
.68817 .5384 m
.59107 .61746 L
s
.39971 .61679 m
.49617 .68267 L
s
.39971 .61679 m
.3596 .67261 L
s
.30399 .53695 m
.39971 .61679 L
s
.68817 .5384 m
.73372 .59333 L
s
.73266 .44703 m
.68817 .5384 L
s
.30399 .53695 m
.26208 .59163 L
s
.26315 .44513 m
.30399 .53695 L
s
.63362 .38255 m
.73266 .44703 L
s
.59681 .28849 m
.63362 .38255 L
s
.53817 .30117 m
.63362 .38255 L
s
.49617 .68267 m
.53869 .74034 L
s
.49617 .68267 m
.4574 .74008 L
s
.36086 .38139 m
.26315 .44513 L
s
.40153 .28761 m
.36086 .38139 L
s
.45798 .30081 m
.36086 .38139 L
s
.5 .20569 m
.53817 .30117 L
s
.5 .20569 m
.45798 .30081 L
s
.73266 .44703 m
.77954 .50109 L
s
.69681 .35303 m
.73266 .44703 L
s
.63482 .67353 m
.59814 .73126 L
s
.63482 .67353 m
.53869 .74034 L
s
.73372 .59333 m
.63482 .67353 L
s
.26315 .44513 m
.21999 .49891 L
s
.30295 .35132 m
.26315 .44513 L
s
.3596 .67261 m
.4574 .74008 L
s
.3596 .67261 m
.40017 .73063 L
s
.26208 .59163 m
.3596 .67261 L
s
.0085 w
[ ] 0 setdash
.73372 .59333 m
.69862 .64987 L
s
.77954 .50109 m
.73372 .59333 L
s
.0035 w
[ .01 .012 ] 0 setdash
.59681 .28849 m
.69681 .35303 L
s
.5 .20569 m
.59681 .28849 L
s
.40153 .28761 m
.30295 .35132 L
s
.5 .20569 m
.40153 .28761 L
s
.0085 w
[ ] 0 setdash
.26208 .59163 m
.30114 .6485 L
s
.21999 .49891 m
.26208 .59163 L
s
.5 .20569 m
.59963 .26982 L
s
.5 .20569 m
.54328 .25606 L
s
.5 .20569 m
.46067 .25568 L
s
.5 .20569 m
.40193 .26891 L
s
.0035 w
[ .01 .012 ] 0 setdash
.53869 .74034 m
.5 .79975 L
s
.4574 .74008 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.69681 .35303 m
.74368 .40616 L
s
.59963 .26982 m
.69681 .35303 L
s
.30295 .35132 m
.25995 .40414 L
s
.40193 .26891 m
.30295 .35132 L
s
.59963 .26982 m
.64501 .32173 L
s
.77954 .50109 m
.74481 .55672 L
s
.74368 .40616 m
.77954 .50109 L
s
.40193 .26891 m
.36052 .32047 L
s
.59814 .73126 m
.5 .79975 L
s
.69862 .64987 m
.59814 .73126 L
s
.21999 .49891 m
.25883 .55491 L
s
.25995 .40414 m
.21999 .49891 L
s
.40017 .73063 m
.5 .79975 L
s
.30114 .6485 m
.40017 .73063 L
s
.69862 .64987 m
.60102 .71789 L
s
.74481 .55672 m
.69862 .64987 L
s
.30114 .6485 m
.40057 .71724 L
s
.25883 .55491 m
.30114 .6485 L
s
.54328 .25606 m
.64501 .32173 L
s
.54328 .25606 m
.50403 .30783 L
s
.46067 .25568 m
.50403 .30783 L
s
.46067 .25568 m
.36052 .32047 L
s
.46011 .70776 m
.5 .79975 L
s
.54389 .70803 m
.5 .79975 L
s
.60102 .71789 m
.5 .79975 L
s
.40057 .71724 m
.5 .79975 L
s
.74368 .40616 m
.70785 .46082 L
s
.64501 .32173 m
.74368 .40616 L
s
.64637 .62477 m
.60102 .71789 L
s
.35921 .62376 m
.40057 .71724 L
s
.25995 .40414 m
.29999 .45919 L
s
.36052 .32047 m
.25995 .40414 L
s
.64501 .32173 m
.60725 .37511 L
s
.74481 .55672 m
.64637 .62477 L
s
.70785 .46082 m
.74481 .55672 L
s
.36052 .32047 m
.4025 .37424 L
s
.25883 .55491 m
.35921 .62376 L
s
.29999 .45919 m
.25883 .55491 L
s
.50406 .61362 m
.54389 .70803 L
s
.64637 .62477 m
.54389 .70803 L
s
.50406 .61362 m
.46011 .70776 L
s
.35921 .62376 m
.46011 .70776 L
s
.60776 .5289 m
.64637 .62477 L
s
.50403 .30783 m
.60725 .37511 L
s
.50403 .30783 m
.4025 .37424 L
s
.40203 .52812 m
.35921 .62376 L
s
.70785 .46082 m
.60776 .5289 L
s
.60725 .37511 m
.70785 .46082 L
s
.29999 .45919 m
.40203 .52812 L
s
.4025 .37424 m
.29999 .45919 L
s
.60725 .37511 m
.50579 .44271 L
s
.4025 .37424 m
.50579 .44271 L
s
.60776 .5289 m
.50406 .61362 L
s
.40203 .52812 m
.50406 .61362 L
s
.50579 .44271 m
.60776 .5289 L
s
.50579 .44271 m
.40203 .52812 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.54139 .55205 m
.6305 .614 L
s
.54139 .55205 m
.44115 .61927 L
s
.62992 .47011 m
.54139 .55205 L
s
.44141 .47599 m
.54139 .55205 L
s
.44141 .47599 m
.34043 .54286 L
s
.38657 .38611 m
.44141 .47599 L
s
.52948 .39348 m
.44141 .47599 L
s
.44115 .61927 m
.52975 .68229 L
s
.44115 .61927 m
.38555 .67639 L
s
.34043 .54286 m
.44115 .61927 L
s
.62992 .47011 m
.7205 .53158 L
s
.65633 .37711 m
.62992 .47011 L
s
.52948 .39348 m
.62992 .47011 L
s
.34043 .54286 m
.28316 .59886 L
s
.28413 .4532 m
.34043 .54286 L
s
.47531 .30213 m
.52948 .39348 L
s
.55461 .29933 m
.52948 .39348 L
s
.6305 .614 m
.65774 .66918 L
s
.6305 .614 m
.52975 .68229 L
s
.7205 .53158 m
.6305 .614 L
s
.38657 .38611 m
.28413 .4532 L
s
.40994 .29137 m
.38657 .38611 L
s
.47531 .30213 m
.38657 .38611 L
s
.52975 .68229 m
.55535 .73903 L
s
.52975 .68229 m
.47498 .74103 L
s
.7205 .53158 m
.74952 .58561 L
s
.74839 .43841 m
.7205 .53158 L
s
.28413 .4532 m
.2253 .5084 L
s
.30627 .35877 m
.28413 .4532 L
s
.5 .20569 m
.47531 .30213 L
s
.65633 .37711 m
.74839 .43841 L
s
.60297 .2845 m
.65633 .37711 L
s
.55461 .29933 m
.65633 .37711 L
s
.5 .20569 m
.55461 .29933 L
s
.38555 .67639 m
.47498 .74103 L
s
.38555 .67639 m
.4087 .73332 L
s
.28316 .59886 m
.38555 .67639 L
s
.28316 .59886 m
.3045 .65448 L
s
.2253 .5084 m
.28316 .59886 L
s
.40994 .29137 m
.30627 .35877 L
s
.5 .20569 m
.40994 .29137 L
s
.65774 .66918 m
.60439 .7284 L
s
.65774 .66918 m
.55535 .73903 L
s
.74952 .58561 m
.65774 .66918 L
s
.0085 w
[ ] 0 setdash
.74839 .43841 m
.7783 .49149 L
s
.69551 .34551 m
.74839 .43841 L
s
.0035 w
[ .01 .012 ] 0 setdash
.60297 .2845 m
.69551 .34551 L
s
.5 .20569 m
.60297 .2845 L
s
.30627 .35877 m
.247 .41319 L
s
.39625 .27299 m
.30627 .35877 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.59158 .26595 L
s
.5 .20569 m
.52547 .25466 L
s
.5 .20569 m
.44387 .25763 L
s
.5 .20569 m
.39625 .27299 L
s
.0035 w
[ .01 .012 ] 0 setdash
.47498 .74103 m
.5 .79975 L
s
.55535 .73903 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.74952 .58561 m
.69732 .64385 L
s
.7783 .49149 m
.74952 .58561 L
s
.2253 .5084 m
.24583 .56302 L
s
.247 .41319 m
.2253 .5084 L
s
.39625 .27299 m
.33808 .32634 L
s
.4087 .73332 m
.5 .79975 L
s
.3045 .65448 m
.4087 .73332 L
s
.3045 .65448 m
.39481 .72016 L
s
.24583 .56302 m
.3045 .65448 L
s
.69551 .34551 m
.72481 .39751 L
s
.59158 .26595 m
.69551 .34551 L
s
.59158 .26595 m
.61902 .31657 L
s
.60439 .7284 m
.5 .79975 L
s
.69732 .64385 m
.60439 .7284 L
s
.7783 .49149 m
.72587 .54897 L
s
.72481 .39751 m
.7783 .49149 L
s
.247 .41319 m
.26822 .46681 L
s
.33808 .32634 m
.247 .41319 L
s
.44387 .25763 m
.46873 .30837 L
s
.44387 .25763 m
.33808 .32634 L
s
.52547 .25466 m
.61902 .31657 L
s
.52547 .25466 m
.46873 .30837 L
s
.44309 .70915 m
.5 .79975 L
s
.52583 .70702 m
.5 .79975 L
s
.59286 .71511 m
.5 .79975 L
s
.39481 .72016 m
.5 .79975 L
s
.69732 .64385 m
.59286 .71511 L
s
.72587 .54897 m
.69732 .64385 L
s
.33656 .62847 m
.39481 .72016 L
s
.24583 .56302 m
.33656 .62847 L
s
.26822 .46681 m
.24583 .56302 L
s
.33808 .32634 m
.36113 .37868 L
s
.62014 .62063 m
.59286 .71511 L
s
.72481 .39751 m
.67086 .45411 L
s
.61902 .31657 m
.72481 .39751 L
s
.61902 .31657 m
.56321 .3719 L
s
.46843 .61405 m
.44309 .70915 L
s
.33656 .62847 m
.44309 .70915 L
s
.36047 .5321 m
.33656 .62847 L
s
.46843 .61405 m
.52583 .70702 L
s
.62014 .62063 m
.52583 .70702 L
s
.72587 .54897 m
.62014 .62063 L
s
.67086 .45411 m
.72587 .54897 L
s
.26822 .46681 m
.36047 .5321 L
s
.36113 .37868 m
.26822 .46681 L
s
.46873 .30837 m
.56321 .3719 L
s
.46873 .30837 m
.36113 .37868 L
s
.56351 .52603 m
.62014 .62063 L
s
.36113 .37868 m
.455 .44341 L
s
.56351 .52603 m
.46843 .61405 L
s
.36047 .5321 m
.46843 .61405 L
s
.67086 .45411 m
.56351 .52603 L
s
.56321 .3719 m
.67086 .45411 L
s
.455 .44341 m
.36047 .5321 L
s
.56321 .3719 m
.455 .44341 L
s
.455 .44341 m
.56351 .52603 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.48425 .47729 m
.58699 .54993 L
s
.48425 .47729 m
.38124 .54747 L
s
.41549 .3898 m
.48425 .47729 L
s
.56194 .39178 m
.48425 .47729 L
s
.58699 .54993 m
.66635 .60935 L
s
.58699 .54993 m
.48418 .62043 L
s
.66561 .46491 m
.58699 .54993 L
s
.38124 .54747 m
.48418 .62043 L
s
.38124 .54747 m
.31043 .60528 L
s
.31127 .46037 m
.38124 .54747 L
s
.48418 .62043 m
.56249 .68093 L
s
.48418 .62043 m
.41474 .67935 L
s
.56194 .39178 m
.66561 .46491 L
s
.49336 .30275 m
.56194 .39178 L
s
.56945 .29687 m
.56194 .39178 L
s
.66561 .46491 m
.74662 .52373 L
s
.67454 .37088 m
.66561 .46491 L
s
.41549 .3898 m
.31127 .46037 L
s
.42102 .29473 m
.41549 .3898 L
s
.49336 .30275 m
.41549 .3898 L
s
.31127 .46037 m
.23877 .5175 L
s
.31539 .36595 m
.31127 .46037 L
s
.66635 .60935 m
.67612 .66419 L
s
.66635 .60935 m
.56249 .68093 L
s
.74662 .52373 m
.66635 .60935 L
s
.56249 .68093 m
.5704 .73726 L
s
.56249 .68093 m
.49327 .74147 L
s
.31043 .60528 m
.41474 .67935 L
s
.31043 .60528 m
.3137 .66023 L
s
.23877 .5175 m
.31043 .60528 L
s
.5 .20569 m
.49336 .30275 L
s
.41474 .67935 m
.49327 .74147 L
s
.41474 .67935 m
.41993 .73573 L
s
.56945 .29687 m
.67454 .37088 L
s
.5 .20569 m
.56945 .29687 L
s
.74662 .52373 m
.75796 .57745 L
s
.75679 .4293 m
.74662 .52373 L
s
.67454 .37088 m
.75679 .4293 L
s
.60603 .28031 m
.67454 .37088 L
s
.42102 .29473 m
.31539 .36595 L
s
.5 .20569 m
.42102 .29473 L
s
.31539 .36595 m
.24194 .42252 L
s
.39375 .27721 m
.31539 .36595 L
s
.0085 w
[ ] 0 setdash
.23877 .5175 m
.24075 .57138 L
s
.24194 .42252 m
.23877 .5175 L
s
.0035 w
[ .01 .012 ] 0 setdash
.49327 .74147 m
.5 .79975 L
s
.5 .20569 m
.60603 .28031 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.58068 .26246 L
s
.5 .20569 m
.50686 .254 L
s
.5 .20569 m
.42886 .26022 L
s
.5 .20569 m
.39375 .27721 L
s
.0035 w
[ .01 .012 ] 0 setdash
.67612 .66419 m
.5704 .73726 L
s
.0085 w
[ ] 0 setdash
.67612 .66419 m
.6075 .7254 L
s
.75796 .57745 m
.67612 .66419 L
s
.0035 w
[ .01 .012 ] 0 setdash
.60603 .28031 m
.6882 .33813 L
s
.0085 w
[ ] 0 setdash
.39375 .27721 m
.32082 .33297 L
s
.0035 w
[ .01 .012 ] 0 setdash
.5704 .73726 m
.5 .79975 L
s
.3137 .66023 m
.41993 .73573 L
s
.0085 w
[ ] 0 setdash
.3137 .66023 m
.39228 .72318 L
s
.24075 .57138 m
.3137 .66023 L
s
.75679 .4293 m
.76847 .48201 L
s
.6882 .33813 m
.75679 .4293 L
s
.0035 w
[ .01 .012 ] 0 setdash
.41993 .73573 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.75796 .57745 m
.68995 .63792 L
s
.76847 .48201 m
.75796 .57745 L
s
.24194 .42252 m
.24401 .47537 L
s
.32082 .33297 m
.24194 .42252 L
s
.58068 .26246 m
.6882 .33813 L
s
.58068 .26246 m
.58915 .31248 L
s
.24075 .57138 m
.31915 .63378 L
s
.24401 .47537 m
.24075 .57138 L
s
.6882 .33813 m
.69871 .38965 L
s
.42886 .26022 m
.43447 .31027 L
s
.42886 .26022 m
.32082 .33297 L
s
.6075 .7254 m
.5 .79975 L
s
.68995 .63792 m
.6075 .7254 L
s
.39228 .72318 m
.5 .79975 L
s
.31915 .63378 m
.39228 .72318 L
s
.32082 .33297 m
.3244 .38457 L
s
.42786 .71101 m
.5 .79975 L
s
.50695 .70655 m
.5 .79975 L
s
.58181 .71261 m
.5 .79975 L
s
.50686 .254 m
.58915 .31248 L
s
.50686 .254 m
.43447 .31027 L
s
.76847 .48201 m
.69965 .54192 L
s
.69871 .38965 m
.76847 .48201 L
s
.68995 .63792 m
.58181 .71261 L
s
.69965 .54192 m
.68995 .63792 L
s
.58999 .61735 m
.58181 .71261 L
s
.31915 .63378 m
.42786 .71101 L
s
.32357 .53738 m
.31915 .63378 L
s
.24401 .47537 m
.32357 .53738 L
s
.3244 .38457 m
.24401 .47537 L
s
.43385 .61558 m
.42786 .71101 L
s
.58915 .31248 m
.69871 .38965 L
s
.58915 .31248 m
.51702 .37039 L
s
.43385 .61558 m
.50695 .70655 L
s
.58999 .61735 m
.50695 .70655 L
s
.69871 .38965 m
.62813 .44879 L
s
.43447 .31027 m
.51702 .37039 L
s
.43447 .31027 m
.3244 .38457 L
s
.3244 .38457 m
.40575 .4459 L
s
.69965 .54192 m
.58999 .61735 L
s
.62813 .44879 m
.69965 .54192 L
s
.5171 .52467 m
.58999 .61735 L
s
.32357 .53738 m
.43385 .61558 L
s
.40575 .4459 m
.32357 .53738 L
s
.5171 .52467 m
.43385 .61558 L
s
.51702 .37039 m
.62813 .44879 L
s
.51702 .37039 m
.40575 .4459 L
s
.62813 .44879 m
.5171 .52467 L
s
.40575 .4459 m
.5171 .52467 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.52752 .47708 m
.63026 .54635 L
s
.52752 .47708 m
.42526 .55066 L
s
.44678 .39236 m
.52752 .47708 L
s
.59267 .3889 m
.52752 .47708 L
s
.42526 .55066 m
.52764 .62025 L
s
.42526 .55066 m
.34301 .61073 L
s
.34371 .46645 m
.42526 .55066 L
s
.63026 .54635 m
.69758 .60362 L
s
.63026 .54635 m
.52764 .62025 L
s
.69669 .45851 m
.63026 .54635 L
s
.52764 .62025 m
.5935 .67863 L
s
.52764 .62025 m
.4463 .6814 L
s
.44678 .39236 m
.34371 .46645 L
s
.43442 .2976 m
.44678 .39236 L
s
.5116 .30265 m
.44678 .39236 L
s
.34371 .46645 m
.25984 .52596 L
s
.32994 .37265 m
.34371 .46645 L
s
.59267 .3889 m
.69669 .45851 L
s
.5116 .30265 m
.59267 .3889 L
s
.58225 .29386 m
.59267 .3889 L
s
.34301 .61073 m
.4463 .6814 L
s
.34301 .61073 m
.3284 .6656 L
s
.25984 .52596 m
.34301 .61073 L
s
.69669 .45851 m
.76568 .51508 L
s
.68766 .36403 m
.69669 .45851 L
s
.4463 .6814 m
.51176 .7414 L
s
.4463 .6814 m
.43352 .73779 L
s
.5 .20569 m
.5116 .30265 L
s
.69758 .60362 m
.68937 .6587 L
s
.69758 .60362 m
.5935 .67863 L
s
.76568 .51508 m
.69758 .60362 L
s
.5935 .67863 m
.58338 .73511 L
s
.5935 .67863 m
.51176 .7414 L
s
.25984 .52596 m
.24359 .57971 L
s
.24475 .43182 m
.25984 .52596 L
s
.43442 .2976 m
.32994 .37265 L
s
.5 .20569 m
.43442 .2976 L
s
.32994 .37265 m
.24475 .43182 L
s
.39449 .28147 m
.32994 .37265 L
s
.58225 .29386 m
.68766 .36403 L
s
.5 .20569 m
.58225 .29386 L
s
.68766 .36403 m
.75746 .41997 L
s
.60589 .27605 m
.68766 .36403 L
s
.0085 w
[ ] 0 setdash
.76568 .51508 m
.75865 .56909 L
s
.75746 .41997 m
.76568 .51508 L
s
.0035 w
[ .01 .012 ] 0 setdash
.3284 .6656 m
.43352 .73779 L
s
.0085 w
[ ] 0 setdash
.3284 .6656 m
.39303 .72623 L
s
.24359 .57971 m
.3284 .6656 L
s
.0035 w
[ .01 .012 ] 0 setdash
.51176 .7414 m
.5 .79975 L
s
.5 .20569 m
.39449 .28147 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.60589 .27605 L
s
.5 .20569 m
.56725 .25945 L
s
.5 .20569 m
.48802 .25411 L
s
.5 .20569 m
.41608 .26337 L
s
.0035 w
[ .01 .012 ] 0 setdash
.39449 .28147 m
.30921 .34011 L
s
.0085 w
[ ] 0 setdash
.24475 .43182 m
.22799 .48457 L
s
.30921 .34011 m
.24475 .43182 L
s
.0035 w
[ .01 .012 ] 0 setdash
.43352 .73779 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.60589 .27605 m
.67502 .3311 L
s
.0035 w
[ .01 .012 ] 0 setdash
.68937 .6587 m
.58338 .73511 L
s
.0085 w
[ ] 0 setdash
.68937 .6587 m
.60736 .72235 L
s
.75865 .56909 m
.68937 .6587 L
s
.0035 w
[ .01 .012 ] 0 setdash
.58338 .73511 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.24359 .57971 m
.30744 .63952 L
s
.22799 .48457 m
.24359 .57971 L
s
.75746 .41997 m
.75018 .47296 L
s
.67502 .3311 m
.75746 .41997 L
s
.41608 .26337 m
.40237 .31348 L
s
.41608 .26337 m
.30921 .34011 L
s
.30921 .34011 m
.29349 .3917 L
s
.39303 .72623 m
.5 .79975 L
s
.30744 .63952 m
.39303 .72623 L
s
.56725 .25945 m
.67502 .3311 L
s
.56725 .25945 m
.55635 .30962 L
s
.75865 .56909 m
.67665 .63229 L
s
.75018 .47296 m
.75865 .56909 L
s
.60736 .72235 m
.5 .79975 L
s
.67665 .63229 m
.60736 .72235 L
s
.41491 .71326 m
.5 .79975 L
s
.48785 .70663 m
.5 .79975 L
s
.56819 .71046 m
.5 .79975 L
s
.48802 .25411 m
.55635 .30962 L
s
.48802 .25411 m
.40237 .31348 L
s
.67502 .3311 m
.66611 .38284 L
s
.22799 .48457 m
.29252 .54376 L
s
.29349 .3917 m
.22799 .48457 L
s
.30744 .63952 m
.41491 .71326 L
s
.29252 .54376 m
.30744 .63952 L
s
.40145 .61815 m
.41491 .71326 L
s
.67665 .63229 m
.56819 .71046 L
s
.6669 .53582 m
.67665 .63229 L
s
.55689 .61506 m
.56819 .71046 L
s
.75018 .47296 m
.6669 .53582 L
s
.66611 .38284 m
.75018 .47296 L
s
.40237 .31348 m
.47026 .37063 L
s
.40237 .31348 m
.29349 .3917 L
s
.29349 .3917 m
.35972 .45009 L
s
.40145 .61815 m
.48785 .70663 L
s
.55689 .61506 m
.48785 .70663 L
s
.55635 .30962 m
.66611 .38284 L
s
.55635 .30962 m
.47026 .37063 L
s
.29252 .54376 m
.40145 .61815 L
s
.35972 .45009 m
.29252 .54376 L
s
.66611 .38284 m
.58107 .44505 L
s
.47012 .52489 m
.40145 .61815 L
s
.6669 .53582 m
.55689 .61506 L
s
.58107 .44505 m
.6669 .53582 L
s
.47012 .52489 m
.55689 .61506 L
s
.47026 .37063 m
.58107 .44505 L
s
.47026 .37063 m
.35972 .45009 L
s
.35972 .45009 m
.47012 .52489 L
s
.58107 .44505 m
.47012 .52489 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.47129 .55236 m
.57036 .61872 L
s
.47129 .55236 m
.37994 .61507 L
s
.38047 .4713 m
.47129 .55236 L
s
.57005 .47538 m
.47129 .55236 L
s
.57005 .47538 m
.66999 .54137 L
s
.47955 .39373 m
.57005 .47538 L
s
.62079 .38492 m
.57005 .47538 L
s
.38047 .4713 m
.28774 .53354 L
s
.34944 .37868 m
.38047 .4713 L
s
.47955 .39373 m
.38047 .4713 L
s
.57036 .61872 m
.62188 .67544 L
s
.57036 .61872 m
.47937 .68249 L
s
.66999 .54137 m
.57036 .61872 L
s
.44974 .2999 m
.47955 .39373 L
s
.52951 .30184 m
.47955 .39373 L
s
.66999 .54137 m
.72324 .59696 L
s
.72224 .45108 m
.66999 .54137 L
s
.37994 .61507 m
.47937 .68249 L
s
.37994 .61507 m
.34808 .67043 L
s
.28774 .53354 m
.37994 .61507 L
s
.62079 .38492 m
.72224 .45108 L
s
.52951 .30184 m
.62079 .38492 L
s
.59263 .29038 m
.62079 .38492 L
s
.28774 .53354 m
.25409 .58777 L
s
.2552 .44082 m
.28774 .53354 L
s
.47937 .68249 m
.52991 .74082 L
s
.47937 .68249 m
.44905 .73943 L
s
.34944 .37868 m
.2552 .44082 L
s
.39841 .28561 m
.34944 .37868 L
s
.44974 .2999 m
.34944 .37868 L
s
.5 .20569 m
.52951 .30184 L
s
.5 .20569 m
.44974 .2999 L
s
.72224 .45108 m
.77698 .50584 L
s
.69522 .35676 m
.72224 .45108 L
s
.62188 .67544 m
.5939 .73261 L
s
.62188 .67544 m
.52991 .74082 L
s
.72324 .59696 m
.62188 .67544 L
s
.72324 .59696 m
.69701 .65286 L
s
.77698 .50584 m
.72324 .59696 L
s
.59263 .29038 m
.69522 .35676 L
s
.5 .20569 m
.59263 .29038 L
s
.34808 .67043 m
.44905 .73943 L
s
.34808 .67043 m
.39701 .7292 L
s
.25409 .58777 m
.34808 .67043 L
s
.2552 .44082 m
.22051 .49411 L
s
.30353 .34756 m
.2552 .44082 L
s
.39841 .28561 m
.30353 .34756 L
s
.5 .20569 m
.39841 .28561 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.60251 .27185 L
s
.5 .20569 m
.5517 .25703 L
s
.5 .20569 m
.46957 .25497 L
s
.5 .20569 m
.40593 .26697 L
s
.25409 .58777 m
.30172 .64549 L
s
.22051 .49411 m
.25409 .58777 L
s
.0035 w
[ .01 .012 ] 0 setdash
.52991 .74082 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.69522 .35676 m
.75024 .41069 L
s
.60251 .27185 m
.69522 .35676 L
s
.0035 w
[ .01 .012 ] 0 setdash
.44905 .73943 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.77698 .50584 m
.7514 .56078 L
s
.75024 .41069 m
.77698 .50584 L
s
.60251 .27185 m
.65629 .32466 L
s
.30353 .34756 m
.2693 .3998 L
s
.40593 .26697 m
.30353 .34756 L
s
.5939 .73261 m
.5 .79975 L
s
.69701 .65286 m
.5939 .73261 L
s
.40593 .26697 m
.37347 .31787 L
s
.69701 .65286 m
.60394 .71934 L
s
.7514 .56078 m
.69701 .65286 L
s
.39701 .7292 m
.5 .79975 L
s
.30172 .64549 m
.39701 .7292 L
s
.22051 .49411 m
.26822 .55103 L
s
.2693 .3998 m
.22051 .49411 L
s
.5517 .25703 m
.65629 .32466 L
s
.5517 .25703 m
.5217 .30808 L
s
.30172 .64549 m
.40462 .71585 L
s
.26822 .55103 m
.30172 .64549 L
s
.46957 .25497 m
.5217 .30808 L
s
.46957 .25497 m
.37347 .31787 L
s
.75024 .41069 m
.72383 .46463 L
s
.65629 .32466 m
.75024 .41069 L
s
.40462 .71585 m
.5 .79975 L
s
.46914 .70725 m
.5 .79975 L
s
.55243 .70872 m
.5 .79975 L
s
.60394 .71934 m
.5 .79975 L
s
.65775 .62712 m
.60394 .71934 L
s
.7514 .56078 m
.65775 .62712 L
s
.72383 .46463 m
.7514 .56078 L
s
.65629 .32466 m
.628 .37732 L
s
.37228 .62168 m
.40462 .71585 L
s
.2693 .3998 m
.31843 .45581 L
s
.37347 .31787 m
.2693 .3998 L
s
.37347 .31787 m
.42451 .37261 L
s
.26822 .55103 m
.37228 .62168 L
s
.31843 .45581 m
.26822 .55103 L
s
.5219 .61383 m
.55243 .70872 L
s
.65775 .62712 m
.55243 .70872 L
s
.37228 .62168 m
.46914 .70725 L
s
.5219 .61383 m
.46914 .70725 L
s
.62861 .53088 m
.65775 .62712 L
s
.5217 .30808 m
.628 .37732 L
s
.5217 .30808 m
.42451 .37261 L
s
.72383 .46463 m
.62861 .53088 L
s
.628 .37732 m
.72383 .46463 L
s
.42415 .52666 m
.37228 .62168 L
s
.628 .37732 m
.53123 .44304 L
s
.31843 .45581 m
.42415 .52666 L
s
.42451 .37261 m
.31843 .45581 L
s
.42415 .52666 m
.5219 .61383 L
s
.62861 .53088 m
.5219 .61383 L
s
.42451 .37261 m
.53123 .44304 L
s
.53123 .44304 m
.62861 .53088 L
s
.53123 .44304 m
.42415 .52666 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.51809 .55254 m
.61117 .61589 L
s
.51809 .55254 m
.42016 .61819 L
s
.42051 .47478 m
.51809 .55254 L
s
.61068 .47221 m
.51809 .55254 L
s
.42051 .47478 m
.3216 .54006 L
s
.37327 .38387 m
.42051 .47478 L
s
.51289 .39387 m
.42051 .47478 L
s
.61068 .47221 m
.70505 .53513 L
s
.51289 .39387 m
.61068 .47221 L
s
.6455 .37994 m
.61068 .47221 L
s
.42016 .61819 m
.513 .68261 L
s
.42016 .61819 m
.37213 .6746 L
s
.3216 .54006 m
.42016 .61819 L
s
.46652 .30155 m
.51289 .39387 L
s
.54656 .30033 m
.51289 .39387 L
s
.61117 .61589 m
.64681 .67144 L
s
.61117 .61589 m
.513 .68261 L
s
.70505 .53513 m
.61117 .61589 L
s
.3216 .54006 m
.2718 .59533 L
s
.27282 .44926 m
.3216 .54006 L
s
.70505 .53513 m
.7425 .58954 L
s
.74141 .4428 m
.70505 .53513 L
s
.37327 .38387 m
.27282 .44926 L
s
.40538 .28953 m
.37327 .38387 L
s
.46652 .30155 m
.37327 .38387 L
s
.513 .68261 m
.54719 .73974 L
s
.513 .68261 m
.46607 .74062 L
s
.6455 .37994 m
.74141 .4428 L
s
.54656 .30033 m
.6455 .37994 L
s
.60026 .28653 m
.6455 .37994 L
s
.5 .20569 m
.46652 .30155 L
s
.5 .20569 m
.54656 .30033 L
s
.27282 .44926 m
.2216 .50369 L
s
.30387 .35507 m
.27282 .44926 L
s
.37213 .6746 m
.46607 .74062 L
s
.37213 .6746 m
.40408 .73201 L
s
.2718 .59533 m
.37213 .6746 L
s
.64681 .67144 m
.60164 .72986 L
s
.64681 .67144 m
.54719 .73974 L
s
.7425 .58954 m
.64681 .67144 L
s
.2718 .59533 m
.30207 .65151 L
s
.2216 .50369 m
.2718 .59533 L
s
.74141 .4428 m
.77999 .49629 L
s
.69692 .34927 m
.74141 .4428 L
s
.40538 .28953 m
.30387 .35507 L
s
.5 .20569 m
.40538 .28953 L
s
.60026 .28653 m
.69692 .34927 L
s
.5 .20569 m
.60026 .28653 L
s
.0085 w
[ ] 0 setdash
.7425 .58954 m
.69873 .64686 L
s
.77999 .49629 m
.7425 .58954 L
s
.5 .20569 m
.59598 .26784 L
s
.5 .20569 m
.53451 .25527 L
s
.5 .20569 m
.45208 .25657 L
s
.5 .20569 m
.3987 .27092 L
s
.0035 w
[ .01 .012 ] 0 setdash
.46607 .74062 m
.5 .79975 L
s
.54719 .73974 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.30387 .35507 m
.2525 .40861 L
s
.3987 .27092 m
.30387 .35507 L
s
.2216 .50369 m
.25135 .55892 L
s
.2525 .40861 m
.2216 .50369 L
s
.69692 .34927 m
.73519 .40175 L
s
.59598 .26784 m
.69692 .34927 L
s
.3987 .27092 m
.34869 .3233 L
s
.40408 .73201 m
.5 .79975 L
s
.30207 .65151 m
.40408 .73201 L
s
.59598 .26784 m
.63255 .31902 L
s
.60164 .72986 m
.5 .79975 L
s
.69873 .64686 m
.60164 .72986 L
s
.30207 .65151 m
.39729 .71868 L
s
.25135 .55892 m
.30207 .65151 L
s
.77999 .49629 m
.73628 .55277 L
s
.73519 .40175 m
.77999 .49629 L
s
.69873 .64686 m
.59732 .71647 L
s
.73628 .55277 m
.69873 .64686 L
s
.45208 .25657 m
.48632 .30793 L
s
.45208 .25657 m
.34869 .3233 L
s
.53451 .25527 m
.63255 .31902 L
s
.53451 .25527 m
.48632 .30793 L
s
.39729 .71868 m
.5 .79975 L
s
.45141 .70839 m
.5 .79975 L
s
.535 .70746 m
.5 .79975 L
s
.59732 .71647 m
.5 .79975 L
s
.2525 .40861 m
.28321 .46286 L
s
.34869 .3233 m
.2525 .40861 L
s
.34727 .62603 m
.39729 .71868 L
s
.6338 .6226 m
.59732 .71647 L
s
.25135 .55892 m
.34727 .62603 L
s
.28321 .46286 m
.25135 .55892 L
s
.73519 .40175 m
.69015 .45731 L
s
.63255 .31902 m
.73519 .40175 L
s
.34869 .3233 m
.38131 .37627 L
s
.63255 .31902 m
.58559 .3733 L
s
.73628 .55277 m
.6338 .6226 L
s
.69015 .45731 m
.73628 .55277 L
s
.34727 .62603 m
.45141 .70839 L
s
.48619 .6137 m
.45141 .70839 L
s
.48619 .6137 m
.535 .70746 L
s
.6338 .6226 m
.535 .70746 L
s
.38075 .52994 m
.34727 .62603 L
s
.48632 .30793 m
.58559 .3733 L
s
.48632 .30793 m
.38131 .37627 L
s
.586 .52728 m
.6338 .6226 L
s
.28321 .46286 m
.38075 .52994 L
s
.38131 .37627 m
.28321 .46286 L
s
.69015 .45731 m
.586 .52728 L
s
.58559 .3733 m
.69015 .45731 L
s
.38131 .37627 m
.48031 .44283 L
s
.38075 .52994 m
.48619 .6137 L
s
.586 .52728 m
.48619 .6137 L
s
.58559 .3733 m
.48031 .44283 L
s
.48031 .44283 m
.38075 .52994 L
s
.48031 .44283 m
.586 .52728 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`0008cooooo0029ooooo`Ko0000Rooo
ool008Oooooo2_l00029ooooo`00Q_ooool<o`0008Sooooo0024ooooo`Oo00000_ooool7o`0008Ko
oooo0023ooooo`Oo00001?ooool2o`000003ooooool0003o000000;o0000QOooool0087ooooo1?l0
00001P00003o0000o`000?l0003ooooo000000?ooooo0ol00002ooooo`Co0000Poooool0083ooooo
1?l000001?oooooo0000o`000?l00002ooooo`0300000?oooooooooo00;ooooo0ol00002ooooo`Co
0000P_ooool007kooooo1?l00002ooooo`?o00000_ooool00`00003oooooooooo`04ooooo`;o0000
1?ooool4o`00083ooooo001mooooo`Co000000?ooooo0000000000000_l00003ooooo`0300000?oo
oooooooo00Cooooo0ol00004ooooo`Co0000Ooooool007cooooo0ol00002ooooo`0300000?oooooo
000000;o00002oooool3o`0000Cooooo00<00000o`000?l000000_l0001mooooo`00N_ooool4o`00
00Cooooo0ol0000<ooooo`0400000?l0003o0000o`0000Gooooo1?l0001looooo`00NOooool4o`00
00Cooooo0ol00004ooooo`0300000?oooooooooo00Kooooo00@00000ooooool0003o00001Oooool2
000000Co0000N_ooool007Oooooo1?l00002ooooo`80000000Coooooo`000?l0003o00001Oooool0
0`00003oooooooooo`07ooooo`0400000?l0003o0000o`0000Kooooo00<00000o`000?l000000_l0
001iooooo`00M_ooool4o`0000;ooooo00<00000ooooooooool00ol00005ooooo`0300000?oooooo
oooo00Wooooo00<00000o`000?l000000_l00005ooooo`0300000?oooooo000000?o0000Moooool0
07Cooooo1?l00005ooooo`Co00001_ooool00`00003oooooooooo`0;ooooo`Co00001oooool4o`00
07Kooooo001cooooo`Co00001?ooool5o`0001Cooooo1ol00004ooooo`0300000?oooooooooo00Co
0000M?ooool0077ooooo1?l00004ooooo`0300000?l0003o000000Go00004_ooool3o`0000;ooooo
1?l00004ooooo`0300000?oooooooooo00Co0000Loooool0073ooooo1?l00004ooooo`Co00000ooo
ool3o`0000Cooooo00<00000ooooooooool02Oooool3o`0000Gooooo1?l00003ooooo`0400000?oo
ooooooooooooo`Co0000LOooool006kooooo1?l00004ooooo`Go00001Oooool2o`0000Cooooo00<0
0000ooooooooool02?ooool3o`000003ooooo`00003ooooo00Cooooo1?l00007ooooo`Co0000L?oo
ool006gooooo1?l00004ooooo`Co00001oooool3o`0000;ooooo00<00000ooooooooool02?ooool3
o`0000[ooooo1?l00003ooooo`0300000?oooooo000000Co0000Koooool006cooooo0ol00004oooo
o`Co00002_ooool3o`0000_ooooo0ol0000<ooooo`Co00000oooool00`00003oooooo`000004o`00
06kooooo001[ooooo`?o00000oooool5o`0000cooooo0_l0000:ooooo`?o00003oooool4o`0000;o
oooo00<00000ooooool000001?l0001]ooooo`00J_ooool3o`0000?ooooo1?l0000>ooooo`?o0000
2?ooool3o`0000Oooooo00<00000ooooooooool01oooool4o`0000?ooooo00<00000o`000?l00000
1?l0001[ooooo`00JOooool3o`0000;ooooo1?l0000Aooooo`;o00001oooool3o`0000Sooooo00<0
0000ooooooooool02Oooool4o`000003ooooo`00003o000000Ko0000J_ooool006Oooooo1?l00000
0ooooooo0000o`000003o`00000300000?oooooooooo00oooooo0ol00005ooooo`?o00002_ooool0
0`00003oooooooooo`09ooooo`Co000000?ooooo00000?l000000_l000001?oooooo0000o`000?l0
001Yooooo`00I_ooool4o`000003ooooool0003o000000;o000000?ooooo00000?ooool04Oooool0
1000003o0000o`000?l00003ooooo`?o00006Oooool4o`000003ooooool0003o0000008000000ol0
001Xooooo`00IOooool8o`0000?ooooo00<00000ooooooooool03oooool200000003ooooool0003o
000000;ooooo0ol0000=ooooo`0300000?oooooooooo00_ooooo1ol000000oooool00000o`000003
o`0006Kooooo001Tooooo`So00005Oooool01000003ooooo00000?ooool6o`0000kooooo0P00000>
ooooo`Ko000000?ooooo00000?l000000ol0001Uooooo`00Hoooool7o`00000300000?oooooooooo
01?ooooo00H00000oooooooooooooooo00000?ooool4o`0000kooooo00@00000ooooooooool00000
3_ooool6o`0000?ooooo0ol0001Tooooo`00HOooool7o`0000Oooooo00<00000ooooooooool04_oo
ool00`00003o0000o`000004o`0000gooooo00<00000ooooooooool04?ooool00`00003o0000o`00
0002o`0000?ooooo00@00000o`000?l0003o0000Hoooool0063ooooo1ol000000`00003ooooooooo
o`05ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool00_ooool4o`0000;ooooo1?l0
000Aooooo`0300000?oooooooooo00_ooooo00<00000o`000?l000000_l00004ooooo`?o0000H_oo
ool005oooooo1_l000000`00003oooooooooo`06ooooo`0300000?oooooooooo00cooooo00<00000
ooooooooool00_ooool4o`0000Cooooo1?l0000Aooooo`0300000?oooooooooo00gooooo1?l00003
ooooo`Co0000H?ooool005kooooo1Ol0000Iooooo`0400000?ooooooooooooooo`Co000000?ooooo
00000?ooool01Oooool4o`0000Oooooo00<00000ooooooooool01_ooool00`00003oooooooooo`0=
ooooo`Co00000oooool4o`0005oooooo001Mooooo`Go000000<00000ooooooooool06_ooool4o`00
00?ooooo00<00000ooooooooool01?ooool5o`0000Gooooo00<00000ooooooooool05?ooool00`00
003o0000o`000004o`0000Cooooo0ol0001Nooooo`00G?ooool7o`0001Kooooo00@00000oooooooo
oooooooo1?l00006ooooo`0300000?oooooooooo00Gooooo1?l00003ooooo`0300000?oooooooooo
00[ooooo0P000009ooooo`?o00000_ooool3o`0000Cooooo0ol0001Mooooo`00F_ooool5o`0000;o
oooo0ol00009ooooo`0300000?oooooooooo00Sooooo00@00000oooooooooooooooo1?l0000Aoooo
o`Co00004?ooool00`00003oooooooooo`05ooooo`?o00001?ooool4o`0000?ooooo1?l0001Koooo
o`00FOooool5o`0000Cooooo0_l00009ooooo`0300000?oooooooooo00Oooooo00<00000oooooooo
ool01?l0000Dooooo`Co00005_ooool3o`00000300000?oooooooooo00?ooooo1?l00003ooooo`Co
0000F_ooool005Sooooo1Ol00005ooooo`?o00001oooool00`00003oooooooooo`09ooooo`Go0000
2oooool00`00003oooooooooo`09ooooo`Co00004oooool3o`0000Wooooo0ol00004ooooo`?o0000
FOooool005Oooooo1Ol00007ooooo`?o00004Oooool4o`0000gooooo00<00000ooooooooool02_oo
ool4o`0000oooooo0P000003o`0000_ooooo0ol00004ooooo`?o0000F?ooool005Kooooo1Ol00009
ooooo`;o00003_ooool00`00003o0000o`000002o`00013ooooo00<00000ooooooooool02Oooool0
0`00003oooooo`000003o`0000kooooo0ol00004ooooo`0300000?oooooooooo00Kooooo1?l00003
ooooo`?o0000Eoooool005Gooooo1Ol0000:ooooo`?o00001?ooool00`00003oooooooooo`05oooo
o`0300000?l0003o000000;o00004Oooool00`00003oooooooooo`08ooooo`0400000?oooooooooo
ooooo`Co00003Oooool2o`0000Gooooo00<00000ooooooooool01oooool4o`0000?ooooo0ol0001F
ooooo`00E?ooool5o`0000cooooo0ol00003ooooo`0300000?oooooooooo00Cooooo1?l0000Toooo
o`Co00002_ooool3o`000003ooooo`000000000000?ooooo00<00000ooooooooool02?ooool3o`00
00?ooooo0_l000000`00003oooooooooo`1Cooooo`00Doooool4o`0000oooooo0_l00003ooooo`03
00000?oooooooooo00?ooooo1?l0000Vooooo`Go00001oooool3o`0000Cooooo00<00000oooooooo
ool03?ooool4o`000005ooooool0003o0000o`0000000000E?ooool005;ooooo1?l0000@ooooo`?o
00000_ooool01000003oooooooooooooool4o`0001Sooooo00<00000ooooooooool01Oooool00`00
003oooooooooo`07ooooo`Co00001Oooool3o`0000Kooooo00<00000ooooooooool03?ooool4o`00
0004ooooool0003o0000o`0005Cooooo001Aooooo`Co00004_ooool3o`0000Cooooo1?l0000Ioooo
o`0300000?oooooooooo00Gooooo00<00000ooooooooool02Oooool4o`0000;ooooo0ol0000;oooo
o`0300000?oooooooooo00[ooooo0ol000001?oooooo0000o`000?l0001Cooooo`00D?ooool4o`00
01Cooooo0_l00002ooooo`Co00007?ooool00`00003oooooooooo`03ooooo`0300000?oooooooooo
00_ooooo1ol0000:ooooo`0300000?ooool0000000gooooo0ol000001?oooooo0000o`000?l0001B
ooooo`00Coooool4o`0001Gooooo1ol0000Sooooo`0300000?oooooooooo00gooooo1?l0000<oooo
o`0300000?ooool0000000gooooo1_l0001Booooo`00C_ooool4o`000003ooooo`00003ooooo01Co
oooo1?l0000dooooo`Ko00003?ooool2000000kooooo1_l0001Aooooo`00COooool4o`0000;ooooo
00<00000ooooooooool04_ooool6o`00023ooooo00<00000ooooooooool03_ooool4o`0000;ooooo
0ol0000=ooooo`0300000?oooooooooo00gooooo1Ol0001@ooooo`00C?ooool4o`0000;ooooo00<0
0000ooooooooool04_ooool3o`0000;ooooo1?l0000Nooooo`0400000?oooooooooo000000cooooo
1?l00004ooooo`?o00003?ooool2000000oooooo1Ol0001?ooooo`00Boooool3o`0000Cooooo00<0
0000ooooooooool04Oooool3o`0000Cooooo1?l0000Nooooo`0300000?ooool0000000[ooooo1?l0
0007ooooo`?o00002_ooool01000003oooooooooo`00000?ooooo`Co0000Coooool004[ooooo0ol0
000Hooooo`?o000000?ooooo00000?ooool01?ooool3o`0001gooooo0P00000:ooooo`Co00002Ooo
ool4o`0000Sooooo00<00000ooooooooool04Oooool4o`0004kooooo0019ooooo`?o00006?ooool3
o`0000?ooooo00<00000ooooooooool00oooool4o`0001_ooooo0P000008ooooo`Co00003?ooool4
o`0000gooooo0P00000=ooooo`0400000?l0003o0000o`0004gooooo0018ooooo`?o00001_ooool0
0`00003oooooooooo`0>ooooo`0400000?l0003o0000o`0000_ooooo1?l0000Iooooo`0400000?oo
oooooooo000000Kooooo1?l0000?ooooo`?o00003_ooool00`00003oooooooooo`0;ooooo`040000
0?l0003o0000o`0004cooooo0017ooooo`?o00001oooool00`00003oooooooooo`0=ooooo`040000
0?l0003o0000o`0000kooooo1?l0000Fooooo`0300000?oooooooooo00;ooooo00@00000oooooooo
oooooooo1?l0000Booooo`?o00001?ooool00`00003oooooooooo`0Fooooo`?o0000Boooool004Ko
oooo0ol00007ooooo`0300000?oooooooooo00gooooo1?l00007ooooo`0300000?oooooooooo00Ko
oooo1?l0000Mooooo`Co00005?ooool3o`0000?ooooo00<00000ooooooooool02Oooool2000000co
oooo0_l0001;ooooo`00AOooool3o`0000Sooooo00<00000ooooooooool02oooool00`00003o0000
o`000002o`0000Wooooo00<00000ooooooooool01oooool4o`00017ooooo00<00000ooooooooool0
1Oooool4o`0001Oooooo1?l000000`00003oooooooooo`0<ooooo`0300000?oooooooooo00Oooooo
00<00000o`000?l000000_l0001:ooooo`00AOooool2o`0001Kooooo00@00000o`000?l0003o0000
3?ooool00`00003oooooooooo`07ooooo`Co00003oooool00`00003oooooooooo`05ooooo`Co0000
00<00000ooooooooool05_ooool4o`0000oooooo00<00000ooooooooool01_ooool5o`0004[ooooo
0015ooooo`?o00005?ooool01000003o0000o`000?l0000Iooooo`?o00003Oooool00`00003ooooo
ooooo`04ooooo`Co00000oooool00`00003oooooooooo`0Gooooo`?o00004?ooool2000000Cooooo
0ol000001?oooooo0000o`000?l00019ooooo`00A?ooool4o`0000Oooooo00<00000ooooooooool0
1_ooool2000000;ooooo0ol0000Kooooo`Co00004Oooool4o`0001oooooo0ol0000Aooooo`030000
0?oooooooooo00?o000000<00000ooooooooool00_l00019ooooo`00A?ooool5o`0000Kooooo00<0
0000ooooooooool01Oooool01000003oooooooooooooool3o`00013ooooo00<00000ooooooooool0
2_ooool4o`0000Oooooo00<00000ooooooooool01?ooool4o`0000Sooooo00<00000ooooooooool0
5Oooool00`00003oooooo`000003o`00013ooooo00@00000ooooool0003o00001?ooool3o`0004So
oooo0014ooooo`;o000000Coooooo`000?l0003o00001?ooool00`00003oooooooooo`05ooooo`04
00000?ooooooooooooooo`?o00004Oooool00`00003oooooooooo`0<ooooo`Co00001?ooool00`00
003oooooooooo`04ooooo`Co00002_ooool00`00003oooooooooo`0Dooooo`0300000?oooooooooo
00Co00004?ooool3o`0000Gooooo0_l00018ooooo`00@oooool3o`0000;ooooo0_l00004ooooo`03
00000?oooooooooo00Sooooo0ol0000Cooooo`0300000?oooooooooo00cooooo1?l00002ooooo`03
00000?oooooooooo00?ooooo1?l0000=ooooo`0300000?oooooooooo01;ooooo00<00000oooooooo
ool00oooool3o`0000kooooo0ol00002000000;ooooo00<00000ooooool000000_l00017ooooo`00
@oooool2o`0000?ooooo0ol00008ooooo`8000000oooool3o`0001Cooooo00<00000ooooooooool0
3_ooool3o`0000Kooooo1?l0000Sooooo`0300000?oooooooooo00Cooooo0ol0000<ooooo`?o0000
0oooool00`00003ooooo00000002ooooo`;o0000Aoooool004?ooooo0_l00004ooooo`;o00001_oo
ool2000000?ooooo1?l0000Wooooo`Co00000_ooool4o`0001?ooooo00<00000ooooooooool05ooo
ool3o`0000[ooooo0ol00007ooooo`0300000?oooooo000000;o0000A_ooool004;ooooo0ol00004
ooooo`?o000000?ooooo00000?ooool01_ooool4o`0002Sooooo00<00000o`000?l000001_l0000E
ooooo`0300000?oooooooooo01Oooooo1?l00007ooooo`?o00002?ooool00`00003oooooooooo`02
o`0004Kooooo0012ooooo`;o00001_ooool2o`000003ooooo`000000000000Gooooo0ol0000Joooo
o`0300000?oooooooooo00cooooo00@00000oooooooooooooooo1?l0000Hooooo`0300000?oooooo
oooo00_ooooo00<00000ooooooooool02Oooool4o`0000Kooooo0_l0000:ooooo`0300000?oooooo
000000;o0000AOooool004;ooooo0_l00006ooooo`?o000000<00000ooooooooool00oooool3o`00
01_ooooo00<00000ooooooooool03oooool6o`0002Gooooo00<00000ooooooooool02oooool3o`00
00Cooooo0ol0000:ooooo`0300000?oooooooooo00;o0000AOooool004;ooooo0_l00007ooooo`;o
00001Oooool3o`0001gooooo00<00000ooooooooool02?ooool00`00003oooooooooo`02ooooo`?o
00000_ooool3o`0001Wooooo0P000008ooooo`0300000?oooooooooo00gooooo0ol00002ooooo`?o
00002_ooool01000003ooooo00000?ooool3o`0004Cooooo0011ooooo`?o00001oooool3o`0000?o
oooo0ol0000Xooooo`0300000?oooooooooo00;ooooo0ol00004ooooo`?o00006_ooool00`00003o
ooooooooo`0Fooooo`Ko00002oooool00`00003oooooooooo`02ooooo`;o0000A?ooool0047ooooo
0_l00007ooooo`0300000?oooooo000000;o000000Coooooo`000?l0003o0000:?ooool00`00003o
ooooooooo`02ooooo`?o00001_ooool4o`0003;ooooo1?l0000Aooooo`;o0000A?ooool0047ooooo
0_l0000:ooooo`Go00008_ooool00`00003oooooooooo`08ooooo`?o00002?ooool4o`0001kooooo
00<00000ooooooooool03oooool4o`00017ooooo00@00000o`000?l0003o0000@oooool0043ooooo
0ol00005ooooo`0300000?oooooooooo00;ooooo1?l0000Sooooo`0300000?oooooooooo00Kooooo
1?l0000;ooooo`?o00006Oooool2000000;ooooo00<00000ooooooooool03Oooool7o`0000_ooooo
00<00000ooooooooool00oooool00`00003o0000o`000013ooooo`00@?ooool2o`0000Gooooo00<0
0000ooooooooool01?ooool4o`0002?ooooo00@00000ooooo`00000000000oooool4o`0000gooooo
0ol0000Jooooo`8000003oooool4o`0000;ooooo0_l0000;ooooo`0300000?oooooooooo00Cooooo
0ol00012ooooo`00@?ooool2o`0000Cooooo00<00000ooooooooool01?ooool7o`00027ooooo0P00
0004ooooo`?o00004?ooool4o`0001Wooooo00<00000ooooooooool02oooool4o`0000Cooooo0ol0
0009ooooo`0300000?oooooooooo00Kooooo0_l00012ooooo`00@?ooool2o`0000_ooooo0_l00000
0oooool00000o`000003o`00023ooooo0P000003ooooo`?o00004_ooool4o`0001Oooooo00<00000
ooooo`0000002oooool4o`0000Kooooo0_l0000Booooo`?o0000@Oooool003oooooo0ol0000;oooo
o`;o000000Cooooo00000?oooooooooo1?l0000Looooo`8000000_ooool00`00003oooooo`000002
o`0001Gooooo0ol0000Eooooo`0500000?ooooooooooooooo`0000002Oooool3o`0000Sooooo0ol0
000Booooo`;o0000@Oooool003oooooo0_l00003ooooo`0300000?oooooooooo00Gooooo0ol00005
ooooo`Co00008?ooool3o`0001Oooooo0ol0000Pooooo`Co00002_ooool2o`0000Kooooo00<00000
ooooooooool02Oooool3o`00043ooooo000oooooo`;o00000_ooool00`00003oooooooooo`06oooo
o`;o00002?ooool4o`0001Kooooo00<00000ooooooooool00oooool4o`0001Wooooo1?l0000?oooo
o`0300000?oooooooooo00Oooooo0`0000000ooooooo0000o`000002o`0000_ooooo0ol00005oooo
o`0300000?oooooooooo00[ooooo0_l00010ooooo`00?_ooool3o`000003ooooo`00003ooooo00So
oooo0_l00004ooooo`0300000?oooooooooo00;ooooo1?l0000Dooooo`0300000?oooooooooo00?o
oooo1?l000000oooool000000000000Hooooo`Co00003Oooool00`00003oooooooooo`0:ooooo`Co
00003_ooool2o`0000Cooooo00<00000ooooooooool02oooool3o`0003oooooo000nooooo`;o0000
2oooool3o`0000Cooooo00<00000ooooooooool01?ooool4o`00017ooooo00<00000ooooooooool0
0oooool3o`0000Gooooo00<00000ooooooooool05oooool3o`0000_ooooo00<00000ooooooooool0
2_ooool4o`0000oooooo0ol00003ooooo`0300000?oooooooooo00cooooo0_l0000oooooo`00?_oo
ool2o`0000_ooooo0_l00006ooooo`0300000?oooooooooo00Cooooo1?l0000Eooooo`?o00001ooo
ool00`00003oooooooooo`0Gooooo`?o00005Oooool4o`0000;ooooo0P00000>ooooo`;o00004_oo
ool3o`0003kooooo000mooooo`?o00002oooool2o`0000oooooo1?l0000:ooooo`8000001_ooool3
o`0002?ooooo1?l00006ooooo`0300000?oooooooooo00Wooooo1?l00005ooooo`0300000?oooooo
oooo00_ooooo0ol0000Booooo`;o0000?_ooool003gooooo0_l0000;ooooo`?o00004?ooool4o`00
00Sooooo00<00000ooooooooool01Oooool3o`0000_ooooo0P00000Hooooo`Co00001?ooool00`00
003oooooooooo`08ooooo`Co00002?ooool00`00003oooooooooo`0;ooooo`;o000000?ooooo0000
0?ooool03_ooool3o`0003kooooo000mooooo`;o00002oooool2o`0000Wooooo00<00000oooooooo
ool01oooool4o`0000cooooo1?l0000>ooooo`0300000?oooooooooo01Oooooo0ol00002ooooo`03
00000?oooooooooo00Sooooo1?l0000Gooooo`?o000000<00000ooooooooool03?ooool3o`0003oo
oooo000mooooo`?o00002_ooool2o`0000Wooooo00<00000ooooooooool02?ooool4o`0000;ooooo
00<00000ooooooooool01Oooool4o`0002[ooooo0ol0000;ooooo`?o00003_ooool2000000[ooooo
0_l0000>ooooo`Co0000?oooool003kooooo0_l00009ooooo`?o00002_ooool00`00003ooooooooo
o`09ooooo`Co00001oooool3o`0001Cooooo00<00000ooooooooool05_ooool4o`0000Oooooo1?l0
000Aooooo`0300000?oooooooooo00Oooooo0_l0000=ooooo`Go0000?oooool003kooooo0ol00008
ooooo`;o00002oooool00`00003oooooooooo`0:ooooo`Co00001Oooool3o`0001Kooooo00<00000
ooooooooool05?ooool00`00003oooooo`000003o`0000Gooooo1?l0000Looooo`?o00003?ooool4
o`00043ooooo000oooooo`;o000000<00000ooooooooool01Oooool2o`0001[ooooo1?l00002oooo
o`?o00006?ooool00`00003oooooooooo`0Booooo`0300000?oooooooooo00;ooooo0ol00002oooo
o`Co00005oooool2000000Kooooo0_l0000;ooooo`Go0000@?ooool003oooooo0ol00006ooooo`?o
00005Oooool2000000Cooooo1ol0000dooooo`Oo00006_ooool00`00003oooooooooo`02ooooo`04
00000?l0003o0000o`0000Wooooo1Ol00011ooooo`00@?ooool2o`00000300000?oooooooooo00?o
oooo0_l0000>ooooo`0300000?oooooooooo00Cooooo00<00000ooooooooool01_ooool4o`0001go
oooo00<00000ooooooooool03?ooool00`00003oooooooooo`07ooooo`Co00008Oooool01000003o
ooooo`000?l00008ooooo`Ko0000@Oooool0043ooooo0ol00005ooooo`;o00003_ooool00`00003o
ooooooooo`0>ooooo`Co00007Oooool00`00003oooooooooo`0:ooooo`0300000?oooooooooo00Oo
oooo1?l0000Pooooo`04o`000000003oooooooooo`?o00001_ooool3o`000003ooooool0003o0000
04;ooooo0011ooooo`;o00001?ooool3o`0000oooooo00@00000ooooo`00000000002oooool6o`00
01gooooo00<00000ooooooooool02?ooool00`00003oooooooooo`07ooooo`Ko00007oooool20000
00?ooooo0_l00005ooooo`?o00000_ooool2o`0004;ooooo0011ooooo`?o00000oooool2o`00017o
oooo00<00000ooooooooool02oooool2o`0000;ooooo0ol0000`ooooo`?o00000_ooool2o`0001ko
oooo00<00000ooooo`0000000oooool3o`0000Cooooo0_l00002ooooo`?o0000@_ooool004;ooooo
0_l000000`00003oooooooooo`02o`00013ooooo00<00000ooooo`0000003?ooool2o`0000?ooooo
1?l0000Mooooo`0300000?oooooooooo00gooooo0ol00003ooooo`?o00007?ooool01@00003ooooo
ooooooooool0000000?ooooo0_l00003ooooo`?o00000_ooool2o`0004?ooooo0012ooooo`?o0000
00Coooooo`000?l0003o00003oooool01@00003oooooooooooooool0000000[ooooo0ol00004oooo
o`Co00007Oooool01000003oooooooooooooool2000000Sooooo0ol00005ooooo`;o00009?ooool3
o`000004ooooool0003o0000o`0000;ooooo0ol00013ooooo`00@oooool2o`00000300000?l0003o
000001oooooo0_l00007ooooo`?o00007Oooool00`00003ooooo00000008ooooo`Co00001_ooool3
o`0001Wooooo00<00000ooooooooool02?ooool5o`0000?ooooo0_l00014ooooo`00@oooool5o`00
01Oooooo00<00000ooooooooool01Oooool2o`0000Sooooo0ol0000Looooo`<000001oooool4o`00
00Sooooo0ol0000Gooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01?l00003oooo
o`?o0000A?ooool004Cooooo1?l0000>ooooo`0300000?oooooooooo00Oooooo00<00000oooooooo
ool00oooool3o`0000Wooooo1?l0000Iooooo`0500000?ooooooooooooooo`0000001Oooool3o`00
00_ooooo0_l0000Fooooo`0300000?oooooooooo00Sooooo00<00000o`000?l000000_l00004oooo
o`;o0000AOooool004Cooooo1?l0000=ooooo`0300000?oooooooooo00Wooooo00<00000oooooooo
ool00_ooool2o`0000_ooooo1?l0000Qooooo`?o00003?ooool3o`0001oooooo1_l00004ooooo`;o
0000AOooool004Gooooo1?l0000;ooooo`0300000?oooooooooo00oooooo0_l0000=ooooo`?o0000
5?ooool00`00003oooooooooo`07ooooo`0400000?l0003o0000o`0000kooooo0_l0000Booooo`03
00000?oooooooooo00Wooooo1_l00004ooooo`?o0000AOooool004Gooooo1_l0000Iooooo`040000
0?l0003o0000o`0000kooooo0ol0000Booooo`0300000?oooooooooo00Sooooo0ol0000?ooooo`?o
00004?ooool00`00003oooooooooo`08ooooo`Co00000_ooool2o`0000Cooooo0_l00016ooooo`00
A_ooool6o`0001Wooooo0_l0000@ooooo`Co00003oooool00`00003oooooooooo`07ooooo`Co0000
00<00000ooooooooool03_ooool2o`0000oooooo00<00000ooooooooool02?ooool4o`0000;ooooo
0ol00003ooooo`?o0000A_ooool004Kooooo0ol000000ooooooo0000o`000002o`0000Cooooo00<0
0000ooooooooool04?ooool2o`00017ooooo1?l0000Gooooo`Co00004_ooool3o`0001Oooooo1?l0
0004ooooo`;o000000@00000oooooooooooooooo0_l00017ooooo`00Aoooool2o`0000;ooooo1?l0
0002ooooo`0300000?oooooooooo013ooooo0ol0000Cooooo`?o00002Oooool2000000[ooooo0ol0
0006ooooo`<000003?ooool2o`0000_ooooo0P000009ooooo`Co00001?ooool3o`000003ooooo`00
003ooooo00?o0000Aoooool004Oooooo0ol000000`00003oooooooooo`04o`0001?ooooo0_l00002
ooooo`8000004Oooool3o`0000Kooooo0P00000;ooooo`?o00002_ooool00`00003oooooooooo`09
ooooo`?o00002Oooool00`00003oooooooooo`07ooooo`Co00001_ooool2o`0000Cooooo0_l00018
ooooo`00B?ooool3o`0000?ooooo1?l0000Booooo`;o00001?ooool00`00003oooooooooo`0?oooo
o`Co00004?ooool3o`0001Sooooo0_l00008ooooo`0300000?oooooooooo00Oooooo1?l00007oooo
o`;o00001?ooool2o`0004Sooooo0019ooooo`;o000000<00000ooooo`0000000_ooool4o`0000oo
oooo0ol00005ooooo`0300000?oooooooooo00oooooo1?l00002000000cooooo0ol0000>ooooo`80
00002Oooool3o`00013ooooo0ol00008ooooo`?o00000oooool3o`0004Sooooo0019ooooo`?o0000
00?ooooo00000?ooool00_ooool4o`0000kooooo0_l0000Jooooo`?o00002oooool4o`00017ooooo
00<00000ooooooooool01oooool2o`0000Gooooo00<00000ooooooooool01_ooool4o`0000Wooooo
0_l00004ooooo`;o0000BOooool004[ooooo0_l000000`00003oooooooooo`04ooooo`Co00003?oo
ool2o`0000Sooooo0P00000@ooooo`0400000?l0003o0000o`0000Wooooo1?l0000Cooooo`030000
0?oooooooooo00Kooooo0ol00003ooooo`0300000?oooooooooo00Kooooo1?l0000:ooooo`;o0000
0oooool3o`0004Wooooo001:ooooo`?o000000<00000ooooooooool01?ooool4o`0000[ooooo0ol0
000:ooooo`0300000?oooooooooo00oooooo1?l00006ooooo`?o00007oooool3o`000003ooooo`00
003ooooo00Kooooo1?l0000;ooooo`?o00000_ooool3o`0004[ooooo001;ooooo`;o00000P000007
ooooo`Co00002?ooool2o`0001Sooooo0P000004ooooo`Co00001?ooool3o`0001Sooooo0`000006
ooooo`;o00002?ooool4o`0000cooooo0_l000000oooool00000o`000002o`0004_ooooo001;oooo
o`?o00002Oooool4o`0000Oooooo0_l0000>ooooo`0300000?oooooooooo00Gooooo0P000008oooo
o`?o00000_ooool3o`0001cooooo00<00000ooooooooool00oooool3o`0000Gooooo1?l0000=oooo
o`?o000000@00000ooooool0003o0000C?ooool004cooooo0_l00003ooooo`8000001_ooool4o`00
00Cooooo0ol0000?ooooo`0300000?oooooooooo00oooooo1_l0000Rooooo`0400000?oooooo0000
o`0000Cooooo1?l0000>ooooo`;o000000<00000ooooool000000_l0001<ooooo`00C?ooool3o`00
000500000?ooooooooooooooo`0000001_ooool4o`0000?ooooo0_l0000Aooooo`0400000?oooooo
ooooo`0000kooooo1?l0000Qooooo`04o`000000003oooooooooo`?o000000?oooooo`000?l00000
0_l0000@ooooo`;o000000Coooooo`000?l0003o0000COooool004gooooo0_l000000`00003ooooo
ooooo`0:ooooo`Co000000?oooooo`000?l000004oooool00`00003oooooooooo`0>ooooo`;o0000
8Oooool2000000Cooooo1_l0000@ooooo`Ko0000C_ooool004gooooo0ol000000`00003ooooooooo
o`03ooooo`0300000?oooooooooo00Cooooo1_l0000Booooo`0300000?ooool0000000kooooo1?l0
000Oooooo`0400000?oooooooooo000000?ooooo1?l0000Booooo`;o000000?oooooo`000?l00000
Coooool004kooooo0_l000000`00003oooooooooo`04ooooo`0300000?oooooooooo00Gooooo1?l0
000Aooooo`0500000?ooooooooooooooo`0000003Oooool4o`0002?ooooo00<00000ooooool00000
0ol0000Booooo`Ko0000Coooool004kooooo0ol00007ooooo`0300000?oooooooooo00Gooooo1?l0
000Rooooo`Go00006oooool00`00003oooooooooo`05ooooo`Go00004_ooool5o`00053ooooo001?
ooooo`?o00003_ooool5o`0001Kooooo0P000008ooooo`?o000000?oooooo`000?l000006_ooool0
0`00003oooooooooo`05ooooo`Go00004?ooool00`00003oooooooooo`04o`00057ooooo001@oooo
o`;o000000<00000ooooooooool01Oooool2000000Gooooo1Ol0000<ooooo`0300000?oooooooooo
00Sooooo00<00000ooooooooool01Oooool2o`0000;ooooo0ol0000Hooooo`0300000?oooooooooo
00Gooooo0ol000000`00003o0000o`00000?ooooo`0300000?oooooooooo00Co0000D_ooool0053o
oooo0ol00009ooooo`0300000?oooooooooo00;ooooo1_l0000:ooooo`0300000?oooooooooo017o
oooo0_l00003ooooo`?o00007_ooool3o`000004ooooool0003o0000o`0000kooooo00@00000oooo
oooooooooooo1?l0001Booooo`00DOooool2o`00000300000?oooooooooo00Oooooo00<00000oooo
ooooool00_ooool2o`000003ooooool0003o000000;o00001oooool00`00003oooooooooo`0=oooo
o`0400000?ooooooooooooooo`?o00001?ooool2o`0001?ooooo0P000007ooooo`Co00000_ooool2
o`0001?ooooo0ol0001Cooooo`00DOooool3o`0000kooooo0ol000000ooooooo0000o`000002o`00
01Oooooo00<00000ooooooooool00_l00005ooooo`?o00004Oooool00`00003oooooooooo`06oooo
o`Co00000_ooool3o`0000cooooo00<00000ooooooooool00_ooool4o`0005Cooooo001Booooo`;o
00002oooool01000003oooooooooooooool3o`0000;ooooo0ol0000Gooooo`0400000?l0003o0000
o`0000Kooooo0_l0000Iooooo`?o00001?ooool2o`0000cooooo00<00000ooooooooool00_ooool4
o`0005Gooooo001Booooo`Co00002_ooool01000003oooooooooooooool2o`0000?ooooo0ol00002
ooooo`0300000?oooooooooo01;ooooo0_l00007ooooo`?o00003Oooool00`00003oooooooooo`07
ooooo`?o00001Oooool2o`0000;ooooo00<00000ooooooooool01_ooool01000003ooooooooooooo
ool4o`0005Oooooo001Cooooo`Co00002_ooool00`00003oooooooooo`03o`0000?ooooo0ol00000
0`00003oooooooooo`0Cooooo`;o00000P000006ooooo`;o00003?ooool00`00003oooooooooo`07
ooooo`?o00001Oooool3o`0000;ooooo00<00000ooooooooool02Oooool4o`0005Sooooo001Eoooo
o`Co00003?ooool2o`0000Cooooo1?l0000Cooooo`?o00000_ooool00`00003oooooooooo`03oooo
o`?o00002_ooool00`00003oooooooooo`07ooooo`?o00001_ooool2o`0000Cooooo00<00000oooo
ooooool00oooool00`00003oooooooooo`05o`0005Wooooo001Fooooo`Co00002_ooool01000003o
0000o`000?l00004ooooo`Co00004_ooool2o`0000[ooooo0_l00006ooooo`8000002_ooool4o`00
00Kooooo0ol00009ooooo`0300000?oooooooooo00Go0000F_ooool005Oooooo1Ol00009ooooo`03
00000?l0003o000000;ooooo00@00000oooooooooooooooo0ol0000Aooooo`;o00001_ooool01000
003oooooooooooooool3o`0000Cooooo00<00000ooooooooool02Oooool4o`0000Oooooo0_l00009
ooooo`0300000?oooooooooo00Go0000Foooool005Wooooo1?l00009ooooo`?o000000<00000oooo
ooooool00oooool3o`0000oooooo0ol00007ooooo`0400000?ooooooooooooooo`;o00000oooool0
0`00003oooooooooo`09ooooo`?o00002?ooool3o`0000Oooooo00<00000ooooooooool01_l0001L
ooooo`00F_ooool5o`0000Sooooo0_l00007ooooo`Co00003Oooool2o`0000Wooooo00<00000oooo
ooooool00ol0000=ooooo`?o00002Oooool2o`0000Oooooo0P0000000ooooooo0000o`000004o`00
05gooooo001Kooooo`Go00001oooool3o`0000Oooooo1?l0000<ooooo`;o00003Oooool2o`000003
00000?oooooooooo00Wooooo0ol0000:ooooo`;o00001_ooool2000000Oo0000G_ooool005gooooo
1Ol00006ooooo`;o000000<00000ooooooooool01_ooool3o`0000[ooooo0ol0000<ooooo`Co0000
2_ooool3o`0000[ooooo0ol00007ooooo`Ko0000H?ooool005kooooo1Ol00005ooooo`?o00002Ooo
ool3o`0000Wooooo0_l0000=ooooo`8000000ol00007ooooo`Co00002oooool2o`0000?ooooo0P00
00000ooooooo0000o`000005o`00067ooooo001Oooooo`Ko00001?ooool2o`0000;ooooo0P000006
ooooo`?o00001oooool3o`0000cooooo00@00000ooooooooool000000_l00006ooooo`Co00002ooo
ool3o`0000;ooooo00<00000ooooooooool01ol0001Rooooo`00HOooool5o`0000?ooooo0ol00003
ooooo`0300000?oooooooooo00Cooooo1?l00005ooooo`;o00004?ooool01000003o0000o`000?l0
0004ooooo`?o00003Oooool2o`0000Cooooo1?l000001?oooooo0000o`000?l0001Sooooo`00H_oo
ool6o`0000;ooooo0ol0000:ooooo`Co00001?ooool2o`0001;ooooo0_l00003ooooo`?o00003_oo
ool2o`00000300000?oooooooooo00Co000000Coooooo`000?l0003o0000I?ooool006?ooooo1_l0
0002ooooo`;o00001Oooool00`00003oooooooooo`04ooooo`?o00000_ooool3o`0000_ooooo00<0
0000ooooooooool01?ooool3o`000004ooooool0003o0000o`0000kooooo0ol00002ooooo`?o0000
0_ooool3o`0006Gooooo001Tooooo`[o00001Oooool00`00003oooooooooo`04ooooo`?o000000?o
ooooo`000?l000002oooool00`00003oooooooooo`05ooooo`0300000?l0003o000000?o00003ooo
ool2o`000003ooooool0003o000000;o000000?oooooo`000?l000000_l0001Vooooo`00I_ooool8
o`0000Kooooo00<00000ooooooooool01?ooool5o`0000[ooooo00<00000ooooooooool01_ooool0
0`00003o0000o`000002o`0000oooooo1ol000000`00003o0000o`000002o`0006Oooooo001Woooo
o`So00003Oooool4o`0001Cooooo00<00000o`000?l000003_ooool2000000Go000000?ooooo0000
0?l000000_l0001Yooooo`00J?ooool7o`0000Sooooo0`000003ooooo`;o00005Oooool3o`0000go
oooo00<00000ooooooooool01?l000000oooool00000o`000002o`0006[ooooo001Zooooo`Oo0000
2Oooool00`00003oooooooooo`03o`0000Sooooo00<00000ooooooooool02Oooool2o`0000oooooo
1?l00003ooooo`?o0000Joooool006_ooooo1ol0000<ooooo`;o00001oooool00`00003ooooooooo
o`0:ooooo`;o000000<00000ooooooooool02?ooool00`00003oooooooooo`04o`0000?ooooo0ol0
001/ooooo`00K?ooool7o`0000Wooooo0P000003o`0000Gooooo00<00000ooooooooool02_ooool3
o`00000300000?oooooooooo00Oooooo00<00000ooooooooool00ol00004ooooo`?o0000KOooool0
06kooooo1_l0000:ooooo`0400000?l0003o0000o`00017ooooo0_l00002ooooo`0300000?oooooo
oooo00Gooooo00<00000ooooooooool00ol00004ooooo`?o0000K_ooool006oooooo1ol00009oooo
o`0300000?l0003o0000013ooooo0ol0000<ooooo`?o00000oooool4o`0006oooooo001`ooooo`Oo
00002Oooool3o`000003ooooo`00003ooooo00cooooo0_l00007ooooo`8000000oooool3o`0000?o
oooo1?l0001`ooooo`00L_ooool6o`0000Wooooo0_l000000`00003oooooooooo`0<ooooo`;o0000
1Oooool2000000?ooooo1?l00002ooooo`Co0000L_ooool007?ooooo1_l00008ooooo`?o00003Ooo
ool3o`0000Gooooo00@00000oooooooooooooooo1?l00002ooooo`Co0000Loooool007Gooooo1_l0
0007ooooo`;o00003Oooool2o`0000Gooooo00@00000oooooooooooooooo0ol00002ooooo`Co0000
MOooool007Kooooo1_l00006ooooo`?o00003?ooool2o`0000Gooooo00<00000ooooooooool00ol0
0002ooooo`Co0000M_ooool007Oooooo1_l00006ooooo`;o00002oooool3o`0000Oooooo0ol00000
0ooooooo0000o`000002o`0007Sooooo001iooooo`Ko00001?ooool3o`0000[ooooo0_l00003oooo
o`0300000?oooooooooo00Co000000?oooooo`000?l000000_l0001iooooo`00N_ooool6o`0000Co
oooo0ol00008ooooo`?o00000oooool00`00003oooooo`000007o`0007_ooooo001looooo`Go0000
1?ooool2o`0000Sooooo0_l00003ooooo`0300000?oooooo000000Oo0000O?ooool007gooooo1Ol0
0003ooooo`?o00001oooool2o`0000Cooooo1ol0001nooooo`00Ooooool5o`0000;ooooo0_l00006
ooooo`?o00000oooool6o`00083ooooo0020ooooo`Go000000Coooooo`000?l0003o00001Oooool2
o`0000;ooooo00<00000o`000?l000001?l00021ooooo`00POooool5o`000004ooooool0003o0000
000000?ooooo0ol000000ooooooo0000o`000004o`0008?ooooo0023ooooo`Oo00000oooool2o`00
0003ooooool0003o000000Co0000Q?ooool008Cooooo1_l000000`00003oooooooooo`07o`0008Ko
oooo0026ooooo`Go000000?oooooo`000?l000001Ol00027ooooo`00Qoooool:o`0008Wooooo0028
ooooo`So0000R_ooool008[ooooo1?l0002<ooooo`00Roooool2o`0008gooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo
003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.56441 .55118 m
.64894 .61182 L
s
.56441 .55118 m
.46254 .62002 L
s
.4627 .47682 m
.56441 .55118 L
s
.64828 .46767 m
.56441 .55118 L
s
.4627 .47682 m
.36036 .54533 L
s
.40068 .38809 m
.4627 .47682 L
s
.54587 .39278 m
.4627 .47682 L
s
.46254 .62002 m
.54628 .68173 L
s
.46254 .62002 m
.39979 .67798 L
s
.36036 .54533 m
.46254 .62002 L
s
.36036 .54533 m
.29607 .60218 L
s
.29698 .45691 m
.36036 .54533 L
s
.64828 .46767 m
.73439 .52777 L
s
.54587 .39278 m
.64828 .46767 L
s
.66604 .37409 m
.64828 .46767 L
s
.48428 .30253 m
.54587 .39278 L
s
.56225 .29817 m
.54587 .39278 L
s
.40068 .38809 m
.29698 .45691 L
s
.41516 .2931 m
.40068 .38809 L
s
.48428 .30253 m
.40068 .38809 L
s
.64894 .61182 m
.66754 .66675 L
s
.64894 .61182 m
.54628 .68173 L
s
.73439 .52777 m
.64894 .61182 L
s
.29698 .45691 m
.23105 .51302 L
s
.31012 .36241 m
.29698 .45691 L
s
.54628 .68173 m
.5631 .7382 L
s
.54628 .68173 m
.48407 .74131 L
s
.5 .20569 m
.48428 .30253 L
s
.73439 .52777 m
.75469 .58157 L
s
.75353 .4339 m
.73439 .52777 L
s
.39979 .67798 m
.48407 .74131 L
s
.39979 .67798 m
.414 .73457 L
s
.29607 .60218 m
.39979 .67798 L
s
.29607 .60218 m
.30839 .65739 L
s
.23105 .51302 m
.29607 .60218 L
s
.66604 .37409 m
.75353 .4339 L
s
.56225 .29817 m
.66604 .37409 L
s
.6049 .28242 m
.66604 .37409 L
s
.5 .20569 m
.56225 .29817 L
s
.41516 .2931 m
.31012 .36241 L
s
.5 .20569 m
.41516 .2931 L
s
.31012 .36241 m
.24348 .41784 L
s
.39459 .27509 m
.31012 .36241 L
s
.66754 .66675 m
.60634 .72692 L
s
.66754 .66675 m
.5631 .7382 L
s
.75469 .58157 m
.66754 .66675 L
s
.0085 w
[ ] 0 setdash
.23105 .51302 m
.2423 .56719 L
s
.24348 .41784 m
.23105 .51302 L
s
.0035 w
[ .01 .012 ] 0 setdash
.6049 .28242 m
.69261 .34179 L
s
.5 .20569 m
.6049 .28242 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.58647 .26415 L
s
.5 .20569 m
.51623 .25424 L
s
.5 .20569 m
.43611 .25885 L
s
.5 .20569 m
.39459 .27509 L
s
.0035 w
[ .01 .012 ] 0 setdash
.48407 .74131 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.75353 .4339 m
.77446 .48672 L
s
.69261 .34179 m
.75353 .4339 L
s
.0035 w
[ .01 .012 ] 0 setdash
.5631 .7382 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.39459 .27509 m
.32877 .32958 L
s
.75469 .58157 m
.69439 .64086 L
s
.77446 .48672 m
.75469 .58157 L
s
.0035 w
[ .01 .012 ] 0 setdash
.414 .73457 m
.5 .79975 L
s
.30839 .65739 m
.414 .73457 L
s
.0085 w
[ ] 0 setdash
.30839 .65739 m
.39313 .72166 L
s
.2423 .56719 m
.30839 .65739 L
s
.69261 .34179 m
.71263 .39346 L
s
.58647 .26415 m
.69261 .34179 L
s
.58647 .26415 m
.60451 .31438 L
s
.24348 .41784 m
.25512 .47099 L
s
.32877 .32958 m
.24348 .41784 L
s
.60634 .72692 m
.5 .79975 L
s
.69439 .64086 m
.60634 .72692 L
s
.43611 .25885 m
.4514 .30915 L
s
.43611 .25885 m
.32877 .32958 L
s
.2423 .56719 m
.32717 .63106 L
s
.25512 .47099 m
.2423 .56719 L
s
.51623 .25424 m
.60451 .31438 L
s
.51623 .25424 m
.4514 .30915 L
s
.39313 .72166 m
.5 .79975 L
s
.43522 .71002 m
.5 .79975 L
s
.51646 .70672 m
.5 .79975 L
s
.58768 .71382 m
.5 .79975 L
s
.32717 .63106 m
.39313 .72166 L
s
.77446 .48672 m
.71363 .54534 L
s
.71263 .39346 m
.77446 .48672 L
s
.32877 .32958 m
.34211 .38146 L
s
.69439 .64086 m
.58768 .71382 L
s
.71363 .54534 m
.69439 .64086 L
s
.6055 .61888 m
.58768 .71382 L
s
.32717 .63106 m
.43522 .71002 L
s
.45094 .61468 m
.43522 .71002 L
s
.34136 .53459 m
.32717 .63106 L
s
.71263 .39346 m
.65013 .45126 L
s
.60451 .31438 m
.71263 .39346 L
s
.60451 .31438 m
.54029 .37093 L
s
.25512 .47099 m
.34136 .53459 L
s
.34211 .38146 m
.25512 .47099 L
s
.45094 .61468 m
.51646 .70672 L
s
.6055 .61888 m
.51646 .70672 L
s
.4514 .30915 m
.54029 .37093 L
s
.4514 .30915 m
.34211 .38146 L
s
.71363 .54534 m
.6055 .61888 L
s
.65013 .45126 m
.71363 .54534 L
s
.34211 .38146 m
.43008 .44444 L
s
.54048 .52515 m
.6055 .61888 L
s
.34136 .53459 m
.45094 .61468 L
s
.54048 .52515 m
.45094 .61468 L
s
.43008 .44444 m
.34136 .53459 L
s
.65013 .45126 m
.54048 .52515 L
s
.54029 .37093 m
.65013 .45126 L
s
.54029 .37093 m
.43008 .44444 L
s
.43008 .44444 m
.54048 .52515 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`0008cooooo0029ooooo`Ko0000Rooo
ool008Oooooo2_l00029ooooo`00Q_ooool4o`0000;ooooo1_l00028ooooo`00Q?ooool5o`0000?o
oooo0_l00002ooooo`?o0000Qoooool008?ooooo1Ol000001000003oooooooooooooool3o`000003
00000?oooooo000000?o0000QOooool0087ooooo1_l000001P00003oooooooooooooool00000oooo
o`;o000000<00000ooooooooool01?l00024ooooo`00P?ooool5o`000003ooooo`00003ooooo00?o
oooo00H00000ooooool0003o0000ooooo`000003ooooo`Co0000P_ooool007kooooo1_l00007oooo
o`0300000?oooooo000000;o000000?ooooo00000?ooool00_ooool4o`00087ooooo001mooooo`Ko
000000<00000ooooooooool01Oooool00`00003oooooooooo`02o`0000Oooooo0ol00020ooooo`00
Noooool7o`00000300000?oooooooooo00Wooooo0_l00008ooooo`Co0000O_ooool007[ooooo1ol0
00000`00003oooooooooo`0:ooooo`?o00000_ooool00`00003oooooooooo`03ooooo`Co0000OOoo
ool007Sooooo1ol0000@ooooo`;o00000_ooool00`00003oooooooooo`05ooooo`Co0000Noooool0
07Oooooo1ol0000<ooooo`0300000?oooooooooo00;ooooo0_l00003ooooo`0300000?oooooooooo
00Gooooo1?l0001jooooo`00MOooool4o`000004ooooool0003o0000o`0000;ooooo00<00000oooo
ooooool02?ooool00`00003oooooooooo`02ooooo`Co00002oooool3o`0007Wooooo001dooooo`So
00000_ooool00`00003oooooooooo`09ooooo`0400000?ooooooooooooooo`Ko00002oooool4o`00
07Oooooo001booooo`Co000000?oooooo`000?l000000_l00002ooooo`0300000?oooooooooo00go
oooo0ol00002ooooo`Co000000<00000ooooooooool01oooool4o`0007Kooooo001aooooo`[o0000
4Oooool3o`0000Cooooo1?l000000`00003oooooooooo`08ooooo`Co0000M?ooool006oooooo1?l0
00000ooooooo0000o`000002o`000004ooooool0003o0000o`0000kooooo1?l00007ooooo`?o0000
00<00000ooooooooool02?ooool4o`0007?ooooo001^ooooo`So00001?ooool2o`0000gooooo1?l0
0009ooooo`Co00002Oooool5o`0007;ooooo001/ooooo`Co000000?oooooo`000?l000000_l00004
ooooo`0300000?l0003o000000cooooo0ol0000<ooooo`Co00002Oooool6o`00073ooooo001[oooo
o`So00001oooool3o`0000Wooooo1?l0000?ooooo`Co00001oooool2o`000003ooooool0003o0000
00;o0000Koooool006[ooooo0ol000000ooooooo0000o`000002o`0000Cooooo00<00000oooooooo
ool00_ooool2o`0000Sooooo1?l0000Aooooo`Co00001_ooool3o`0000;ooooo1?l0001]ooooo`00
JOooool7o`0000Gooooo00<00000ooooooooool00oooool2o`0000Oooooo0ol0000Dooooo`040000
0?l0003o0000o`0000Kooooo0_l00003ooooo`Co0000K?ooool006Sooooo1ol00005ooooo`030000
0?oooooooooo00Cooooo0_l00006ooooo`?o00005oooool4o`0000Cooooo0_l00004ooooo`040000
0?l0003o0000o`0006_ooooo001Vooooo`Oo00001_ooool2000000Kooooo0ol00003ooooo`Co0000
0oooool00`00003oooooooooo`0Cooooo`Co00000oooool3o`0000Gooooo1?l0001Yooooo`00IOoo
ool7o`0000Kooooo00<00000ooooo`0000001oooool2o`0000;ooooo1?l00004ooooo`0300000?oo
oooooooo01;ooooo00?o000000000?ooool01?l00002ooooo`;o00001_ooool4o`0006Sooooo001T
ooooo`Ko00002_ooool00`00003oooooooooo`05ooooo`;o000000Coooooo`000?l0003o00001_oo
ool00`00003oooooooooo`0Booooo`0400000?ooool00000ooooo`Co000000?oooooo`000?l00000
1Oooool00`00003oooooooooo`03o`0006Oooooo001Sooooo`Ko00001_ooool00`00003ooooooooo
o`02ooooo`0300000?oooooooooo00Gooooo1Ol00007ooooo`0300000?oooooooooo01;ooooo00@0
0000ooooooooool000000_ooool6o`0000Cooooo00@00000oooooooooooooooo1?l0001Uooooo`00
H_ooool5o`0000Oooooo00<00000ooooooooool02oooool4o`0000Oooooo0P00000Dooooo`030000
0?oooooooooo00Cooooo1Ol00005ooooo`0400000?ooooooooooooooo`Co0000I?ooool0063ooooo
1_l00007ooooo`0300000?oooooooooo00_ooooo1_l00005ooooo`0400000?oooooooooo000001So
oooo0P0000000ooooooo0000o`000002o`0000_ooooo0ol0001Sooooo`00Goooool5o`0000030000
0?oooooooooo00cooooo00<00000ooooooooool00oooool4o`0000;ooooo0ol0000Rooooo`030000
0?oooooooooo00Co00002_ooool4o`00067ooooo001Nooooo`Go00001_ooool2000000Sooooo00<0
0000ooooooooool00_ooool4o`0000Cooooo1?l0000Hooooo`0300000?oooooooooo00Kooooo00<0
0000o`000?l000001?l00004ooooo`0300000?oooooooooo00?ooooo1?l0001Pooooo`00GOooool4
o`00000300000?oooooooooo00?ooooo0P00000:ooooo`0400000?ooooooooooooooo`?o00001ooo
ool4o`0000Kooooo00<00000ooooooooool03_ooool00`00003oooooooooo`06ooooo`?o00000_oo
ool4o`0000?ooooo00<00000ooooooooool01?ooool4o`0005kooooo001Looooo`Co000000?ooooo
00000?ooool04?ooool00`00003oooooo`000003o`0000Sooooo00<00000ooooool000000ol00005
ooooo`0300000?oooooooooo00gooooo00<00000ooooooooool01Oooool3o`0000<0000000?ooooo
o`000?l000000_l00003ooooo`0300000?oooooooooo00Cooooo1?l0001Mooooo`00Foooool3o`00
00;ooooo00@00000oooooooooooooooo0P00000>ooooo`Co00003?ooool4o`0000Gooooo00<00000
ooooooooool03?ooool00`00003oooooooooo`04ooooo`?o00001?ooool00`00003oooooooooo`03
o`0000_ooooo0ol0001Looooo`00Foooool2o`0000Kooooo00<00000ooooooooool03?ooool4o`00
00Wooooo00<00000ooooooooool01?ooool3o`0001Wooooo0ol00009ooooo`Co00002_ooool4o`00
05[ooooo001Jooooo`?o00001Oooool00`00003oooooooooo`0<ooooo`Co00002Oooool00`00003o
ooooooooo`06ooooo`Co00005_ooool3o`0000Sooooo0P0000000ooooooo0000o`000002o`000003
ooooo`00003ooooo00Oooooo1?l0001Iooooo`00FOooool5o`00017ooooo1?l0000:ooooo`030000
0?oooooooooo00Sooooo1?l00003ooooo`0300000?oooooooooo00Wooooo00<00000ooooooooool0
0_ooool3o`0000_ooooo00<00000ooooooooool01?l0000:ooooo`?o0000F?ooool005Sooooo0ol0
00000ooooooo0000o`000002000000kooooo1?l000000`00003oooooooooo`0Eooooo`Co000000?o
oooo00000?ooool02_ooool00`00003oooooooooo`04o`0000gooooo00<00000ooooooooool01?l0
000:ooooo`?o0000Eoooool005Oooooo0ol000001?ooool00000o`000?l0000?ooooo`?o00000_oo
ool00`00003oooooooooo`0Fooooo`Co000000?ooooo00000?ooool02Oooool00`00003oooooo`00
0003o`0001?ooooo0ol0000:ooooo`;o0000Eoooool005Kooooo0ol00003ooooo`;o00003Oooool4
o`0000cooooo00<00000ooooooooool03oooool3o`0000_ooooo00@00000o`000?l0003o00004_oo
ool2000000;ooooo1?l00008ooooo`?o0000E_ooool005Gooooo0ol000001?ooool0000000000?oo
ool3o`0000_ooooo1?l0000<ooooo`0300000?oooooooooo017ooooo1?l00009ooooo`?o00005Ooo
ool00`00003oooooooooo`04o`0000Sooooo0ol0001Eooooo`00E?ooool3o`000003ooooo`00003o
oooo00?ooooo0_l00009ooooo`Co00001Oooool00`00003oooooooooo`05ooooo`0300000?oooooo
oooo01?ooooo1?l00007ooooo`?o00005oooool01000003oooooooooo`000004o`0000Kooooo0ol0
001Eooooo`00Doooool3o`00008000001Oooool2o`0000Sooooo1?l00006ooooo`0300000?oooooo
oooo01gooooo1?l00004ooooo`?o00007?ooool00`00003o0000o`000002o`0000Kooooo0ol0001D
ooooo`00D_ooool3o`00000300000?ooool0000000Gooooo0ol00005ooooo`Co00002?ooool00`00
003oooooooooo`02ooooo`0300000?oooooooooo01Wooooo1?l00002ooooo`?o00006oooool40000
0004ooooool0003o0000o`0000Gooooo1?l0001Cooooo`00DOooool3o`00000300000?ooool00000
00Oooooo0_l00004ooooo`Co00002Oooool01@00003oooooooooooooool0000001kooooo1_l00000
0`00003oooooooooo`0Looooo`0300000?oooooooooo00Co00000oooool4o`0005?ooooo001@oooo
o`?o00000oooool00`00003oooooooooo`05ooooo`;o00000oooool3o`0000kooooo00<00000oooo
ooooool07_ooool4o`000003ooooo`00003ooooo027ooooo1?l00003ooooo`Co0000D_ooool004oo
oooo0ol000000`00003oooooooooo`09ooooo`;o000000?oooooo`000?l000000_l0000_ooooo`Ko
00008Oooool01?l000000000ooooooooool4o`000003ooooool0003o000000?o0000DOooool004ko
oooo0ol000000`00003oooooooooo`0:ooooo`Ko00003?ooool00`00003oooooooooo`0Oooooo`Co
000000<00000ooooool000000ol0000Oooooo`0300000?ooool0000000;ooooo1?l000000ooooooo
0000o`000002o`00057ooooo001=ooooo`?o000000<00000ooooooooool00oooool00`00003ooooo
ooooo`06ooooo`?o00003_ooool00`00003ooooo0000000Nooooo`Co00000_ooool00`00003ooooo
o`000003o`0001gooooo00<00000ooooooooool01Oooool8o`00053ooooo001<ooooo`?o00001ooo
ool00`00003oooooooooo`05ooooo`Go00003Oooool2000001gooooo1?l00006ooooo`0300000?oo
oooo000000;o00008_ooool00`00003oooooooooo`08o`0004oooooo001;ooooo`?o00001oooool0
0`00003oooooooooo`05ooooo`?o000000?oooooo`000?l000000_l0000:ooooo`8000007?ooool5
o`0000Oooooo00<00000ooooooooool01?l0000Qooooo`0300000?oooooooooo00Co000000Cooooo
o`000?l0003o0000C_ooool004[ooooo0ol00008ooooo`0300000?oooooooooo00Cooooo0ol00003
ooooo`Co00002?ooool01000003oooooooooo`00000Jooooo`Co00002Oooool01000003ooooooooo
ooooool4o`00027ooooo00@00000oooooooooooooooo0ol000000ooooooo0000o`00001>ooooo`00
BOooool3o`0000oooooo0ol00006ooooo`?o00002oooool00`00003oooooooooo`0Eooooo`Co0000
2_ooool00`00003ooooo00000004ooooo`Co00005_ooool00`00003oooooooooo`09ooooo`Co0000
00Coooooo`000?l0003o0000COooool004Sooooo0ol0000?ooooo`?o00002?ooool4o`0000;ooooo
00<00000ooooooooool06oooool4o`0000[ooooo00D00000oooooooooooooooo00000004ooooo`Co
00005Oooool00`00003oooooooooo`08ooooo`Ko000000Coooooo`000?l0003o0000C?ooool004Oo
oooo0ol0000?ooooo`?o00002_ooool4o`00000300000?oooooooooo01[ooooo1?l0000Gooooo`?o
00005?ooool00`00003oooooooooo`07ooooo`?o000000?ooooo00000?l000000_l000000ooooooo
0000o`00001<ooooo`00A_ooool3o`0000cooooo00<00000ooooooooool00ol0000=ooooo`Co0000
2?ooool00`00003oooooooooo`0?ooooo`Co00002oooool00`00003oooooooooo`06ooooo`800000
0oooool4o`0001_ooooo0ol00004ooooo`;o000000Coooooo`000?l0003o0000Boooool004Gooooo
0ol0000=ooooo`0300000?oooooo000000;o00002oooool2000000;ooooo1?l00007ooooo`030000
0?oooooooooo00gooooo1?l0000<ooooo`0300000?oooooooooo00Wooooo00@00000oooooooooooo
oooo1?l0000Iooooo`?o00001Oooool3o`000004ooooool0003o0000o`0004[ooooo0014ooooo`?o
00003_ooool01000003o0000o`000?l0000;ooooo`0300000?oooooooooo00Cooooo0ol00007oooo
o`0300000?oooooooooo00_ooooo1?l0000<ooooo`0300000?oooooooooo013ooooo1?l0000Foooo
o`?o00001oooool3o`000003ooooool0003o000004[ooooo0013ooooo`?o00003oooool3o`0000_o
oooo00<00000ooooooooool01_ooool4o`00017ooooo1?l0000Nooooo`0400000?oooooooooooooo
o`Co00003Oooool00`00003oooooooooo`04ooooo`?o00002Oooool2o`000004ooooool0003o0000
o`0004Wooooo0013ooooo`;o00003oooool3o`0001Kooooo1?l0000?ooooo`Co00008?ooool00`00
003oooooooooo`02ooooo`?o00003?ooool00`00003oooooooooo`02ooooo`Co00002_ooool3o`00
0004ooooool0003o0000o`0004Sooooo0013ooooo`;o00003_ooool3o`0000[ooooo0P00000=oooo
o`Co00001?ooool00`00003oooooooooo`04ooooo`Co00003_ooool00`00003oooooooooo`0Boooo
o`0300000?oooooooooo00;ooooo1?l0000:ooooo`0400000?ooooooooooooooo`Co00003?ooool3
o`00000300000?l0003o000004Sooooo0013ooooo`?o00003?ooool3o`0000Wooooo0P00000@oooo
o`Co00001?ooool01000003oooooooooooooool5o`0000kooooo00<00000ooooooooool06Oooool4
o`0000Wooooo00<00000ooooooooool00ol0000?ooooo`;o000000Coooooo`000?l0003o0000Aooo
ool004;ooooo1?l0000;ooooo`?o000000<00000ooooooooool06oooool3o`0000Cooooo00<00000
ooooool000000ol0000?ooooo`0300000?oooooooooo01Oooooo0P000003ooooo`Co00002Oooool3
o`00013ooooo0ol000001?oooooo0000o`000?l00016ooooo`00@_ooool4o`0000[ooooo0ol00000
0oooool00000ooooo`05ooooo`0300000?oooooooooo01Gooooo1?l00002ooooo`Co0000;Oooool0
1000003oooooooooooooool4o`0000Oooooo0ol0000Booooo`?o000000?oooooo`000?l00000A_oo
ool004;ooooo1?l00009ooooo`?o00000_ooool00`00003oooooooooo`03ooooo`0300000?oooooo
oooo01Oooooo2?l0000@ooooo`0300000?oooooooooo027ooooo0ol00004ooooo`0400000?l0003o
0000o`0001Cooooo0_l000001?oooooo0000o`000?l00015ooooo`00@_ooool4o`0000Sooooo0ol0
0008ooooo`0300000?oooooooooo01[ooooo1?l000000oooool00000ooooo`0>ooooo`0300000?oo
oooooooo01oooooo00@00000oooooooooooooooo1?l00002ooooo`?o00005Oooool3o`000003oooo
ool0003o000004Gooooo0012ooooo`Go00001_ooool3o`0002Oooooo1?l000000`00003ooooooooo
o`0<ooooo`0300000?oooooooooo027ooooo00@00000oooooooooooooooo1ol0000Gooooo`;o0000
00?oooooo`000?l00000AOooool004;ooooo0_l000000ooooooo0000o`000005ooooo`?o00001?oo
ool01000003ooooo00000000000Oooooo`Ko000000<00000ooooooooool0<?ooool00`00003ooooo
ooooo`02ooooo`Co00006?ooool6o`0004Cooooo0012ooooo`;o000000?oooooo`000?l000001?oo
ool3o`0000Gooooo0P00000Pooooo`?o00000_ooool4o`0000Wooooo00<00000ooooooooool0:Ooo
ool4o`0001[ooooo1Ol00014ooooo`00@Oooool3o`000003ooooool0003o000000?ooooo0ol00006
ooooo`0300000?oooooooooo01kooooo0ol00004ooooo`Co00002?ooool00`00003oooooooooo`0W
ooooo`Oo00006_ooool5o`0004?ooooo0011ooooo`;o00000_ooool2o`0000;ooooo0ol00006oooo
o`0300000?ooool0000001kooooo0ol00007ooooo`?o00001_ooool00`00003oooooooooo`0Woooo
o`Co00000_ooool3o`0001Sooooo00<00000o`000?l000000ol00013ooooo`00@Oooool2o`0000;o
oooo1_l00006ooooo`0500000?ooooooooooooooo`0000007?ooool3o`0000Wooooo1?l0000/oooo
o`Co00000_ooool00`00003ooooo00000002o`0001Sooooo00<00000ooooool000000ol00013oooo
o`00@Oooool2o`0000?ooooo1?l0000Wooooo`?o00002oooool4o`0002[ooooo1?l00005ooooo`04
00000?l0003o0000o`0001[ooooo1?l00012ooooo`00@Oooool2o`0000?ooooo0ol00005ooooo`03
00000?oooooooooo01oooooo0ol0000>ooooo`?o00009oooool4o`0000Kooooo00<00000ooooo`00
00000ol0000Iooooo`Co0000@_ooool0047ooooo0_l00003ooooo`Co00000oooool00`00003ooooo
ooooo`07ooooo`0300000?oooooooooo01Gooooo0ol0000?ooooo`0300000?l0003o000000;o0000
9?ooool4o`0000Kooooo00D00000oooooooooooooooo00000002o`0001[ooooo1?l00011ooooo`00
@Oooool2o`0000?ooooo1Ol000000oooool00000ooooo`09ooooo`0300000?oooooooooo01Cooooo
0ol0000?ooooo`0300000?oooooooooo00Co00008Oooool4o`0000gooooo0ol0000Eooooo`030000
0?oooooooooo00;ooooo0ol00011ooooo`00@?ooool3o`0000?ooooo0_l000000ooooooo0000o`00
0002o`0000_ooooo00<00000ooooooooool04_ooool3o`0000oooooo00<00000ooooooooool00_oo
ool00`00003o0000o`000002o`0001kooooo1?l00006ooooo`0300000?oooooooooo00Kooooo0ol0
000Dooooo`0300000?oooooooooo00;ooooo0ol00011ooooo`00@?ooool2o`0000Cooooo0_l00000
0oooool00000o`000003o`0001kooooo0ol0000Gooooo`Co00006oooool4o`0000Oooooo00<00000
ooooooooool02?ooool2o`00000300000?oooooooooo013ooooo00<00000ooooooooool01?ooool3
o`00043ooooo0010ooooo`;o00000oooool3o`00000400000?ooooooooooooooo`?o00007?ooool3
o`0000kooooo00<00000ooooooooool01oooool2000000?o00006Oooool4o`0000Oooooo00<00000
ooooooooool02Oooool3o`0001Wooooo0ol00010ooooo`00@?ooool2o`0000?ooooo0_l000000`00
003oooooooooo`03ooooo`Co00002Oooool00`00003oooooooooo`0=ooooo`?o00003_ooool00`00
003oooooooooo`0:ooooo`0300000?l0003o000000;o00005_ooool3o`0001Kooooo0ol000000ooo
ool00000ooooo`0Dooooo`Co0000@?ooool0043ooooo0_l00003ooooo`;o00001oooool4o`0000Wo
oooo00<00000ooooooooool02oooool3o`0000kooooo00<00000ooooooooool03?ooool00`00003o
0000o`000002o`0001?ooooo1?l0000Hooooo`;o00000_ooool00`00003oooooooooo`0Aooooo`Go
0000@?ooool0043ooooo0_l00003ooooo`;o00002Oooool3o`0000Wooooo00<00000ooooooooool0
2Oooool3o`0000cooooo00<00000ooooooooool04_ooool3o`00017ooooo1?l00009ooooo`030000
0?oooooooooo00gooooo0ol00002ooooo`0300000?oooooooooo00[ooooo00<00000ooooooooool0
0_ooool6o`00043ooooo0010ooooo`;o00000_ooool00`00003o0000o`00000:ooooo`Co00004_oo
ool3o`0000cooooo00<00000ooooooooool04_ooool2000000Co00003Oooool4o`0000[ooooo00<0
0000ooooooooool03oooool3o`0000kooooo00@00000oooooooooooooooo0ol000000ooooooo0000
o`000011ooooo`00?oooool3o`000003ooooo`00003ooooo00;o00002oooool4o`00013ooooo0ol0
000<ooooo`0300000?oooooooooo01Kooooo1?l0000;ooooo`Co00002_ooool00`00003ooooooooo
o`0Aooooo`;o00001?ooool2000000Sooooo00<00000ooooooooool00ol00002ooooo`;o0000@Ooo
ool003oooooo0_l00004ooooo`;o00003Oooool3o`0000Oooooo00<00000ooooooooool01?ooool3
o`0002Sooooo0ol00008ooooo`Co00008?ooool3o`0000Gooooo00<00000ooooooooool01oooool3
o`0000?ooooo0_l00011ooooo`00?oooool2o`0000Cooooo0_l0000>ooooo`Co00001Oooool00`00
003oooooooooo`03ooooo`?o00002_ooool2000001gooooo00<00000o`000?l000000_l00005oooo
o`Co00002_ooool00`00003oooooooooo`0Eooooo`?o00003Oooool3o`0000Cooooo0_l00011oooo
o`00?oooool2o`00000400000?ooooooooooooooo`;o00003oooool4o`0000Gooooo00@00000oooo
oooooooooooo0ol0000:ooooo`0300000?oooooooooo01oooooo1?l00002ooooo`Co00003?ooool0
0`00003oooooooooo`0Fooooo`;o00001oooool00`00003oooooooooo`02ooooo`?o00001?ooool3
o`00047ooooo000oooooo`;o000000?ooooo00000?ooool00ol0000Aooooo`?o00001oooool3o`00
02kooooo00<00000o`000?l000001Ol0000<ooooo`0300000?oooooooooo01Oooooo0ol00007oooo
o`0300000?oooooooooo00?o00001Oooool2o`0004;ooooo000oooooo`?o00000_ooool2o`0001?o
oooo1?l00004ooooo`?o00002Oooool00`00003oooooooooo`0Uooooo`Co0000:Oooool3o`0000Oo
oooo00@00000o`000?l0003o00001_ooool2o`0004;ooooo0010ooooo`;o00000_ooool2o`0001Co
oooo1?l00002ooooo`?o00002Oooool00`00003oooooooooo`0Vooooo`?o00003?ooool00`00003o
ooooooooo`0Looooo`;o00001oooool3o`0000Oooooo0_l00012ooooo`00@?ooool2o`0000;ooooo
0_l0000Fooooo`Ko000000<00000ooooooooool01_ooool00`00003oooooooooo`0Vooooo`Go0000
2_ooool00`00003oooooooooo`0Mooooo`?o00001Oooool3o`00000300000?oooooooooo00Gooooo
0_l00012ooooo`00@?ooool2o`0000;ooooo0_l0000Gooooo`Co00000_ooool00`00003ooooooooo
o`0]ooooo`?o000000Coooooo`000?l0003o00002?ooool00`00003oooooooooo`0Oooooo`?o0000
0oooool3o`0000;ooooo00<00000ooooooooool00oooool3o`0004;ooooo0010ooooo`?o000000Co
ooooo`000?l0000000005oooool4o`0000Gooooo0P00000Yooooo`?o00000oooool3o`0002[ooooo
0_l00002ooooo`?o00002Oooool2o`0004?ooooo0011ooooo`;o000000?oooooo`000?l000006?oo
ool6o`000003ooooo`000000000002[ooooo0ol00005ooooo`;o00000P00000Xooooo`Ko00002_oo
ool2o`0004?ooooo0011ooooo`;o000000?oooooo`000?l000006?ooool2o`000003ooooool0003o
000000;o00000P00000Yooooo`?o00001_ooool3o`000003ooooo`00003ooooo008000009Oooool4
o`0000_ooooo0_l00013ooooo`00@Oooool5o`0000;ooooo00<00000ooooooooool04_ooool3o`00
00?ooooo0ol000000oooool00000ooooo`0Vooooo`?o00002?ooool3o`000003ooooo`00003ooooo
02Gooooo1?l00007ooooo`0300000?oooooooooo00;ooooo0_l00013ooooo`00@_ooool4o`0000;o
oooo00<00000ooooooooool04_ooool2o`0000Cooooo00<00000o`000?l000000_l0000Vooooo`?o
00002_ooool2o`00000300000?ooool0000002?ooooo1_l00007ooooo`0300000?oooooooooo00;o
oooo0_l00013ooooo`00@_ooool3o`0000Cooooo00<00000ooooooooool04Oooool2o`0000Kooooo
1?l000000oooool00000ooooo`0Qooooo`?o00002oooool3o`0000;ooooo00<00000ooooooooool0
7oooool4o`000003ooooool0003o000000Sooooo00<00000ooooooooool00ol00013ooooo`00@_oo
ool3o`0001Sooooo0_l000000oooool00000ooooo`05ooooo`Co000000<00000ooooooooool07_oo
ool3o`0000gooooo0ol0000Qooooo`Co000000<00000ooooool000000_l0000;ooooo`;o0000A?oo
ool004;ooooo0ol0000Hooooo`;o000000<00000ooooooooool01_ooool4o`00000300000?oooooo
oooo01cooooo0ol0000:ooooo`8000000oooool3o`0000?ooooo00<00000ooooooooool06Oooool4
o`00000300000?oooooooooo00;o00003?ooool2o`0004Cooooo0013ooooo`?o00001Oooool00`00
003oooooooooo`0?ooooo`;o00002oooool3o`0001gooooo0ol0000:ooooo`0300000?oooooooooo
00Cooooo0_l00004ooooo`0300000?oooooooooo01Kooooo1?l00005ooooo`;o00002_ooool01000
003oooooo`000?l00014ooooo`00@oooool4o`0000Gooooo00<00000ooooooooool03_ooool2o`00
00cooooo1?l000000`00003oooooooooo`0Gooooo`?o00004_ooool3o`0000Cooooo00<00000oooo
ooooool05?ooool4o`0000Kooooo0_l0000:ooooo`0400000?oooooo0000o`0004Cooooo0013oooo
o`Go00001Oooool00`00003oooooooooo`0;ooooo`0400000?l0003o0000o`0000gooooo1?l00000
0`00003oooooooooo`0Eooooo`?o00002?ooool2000000[ooooo0ol0000Hooooo`Co00000oooool0
0`00003oooooooooo`02ooooo`;o00002oooool3o`0004Cooooo0014ooooo`Go00004Oooool01000
003oooooo`000?l0000@ooooo`Co00005Oooool3o`0000Sooooo00<00000ooooooooool02oooool3
o`0000Gooooo0P00000?ooooo`Co00000oooool00`00003oooooooooo`02ooooo`?o00002oooool2
o`0004Gooooo0015ooooo`Ko00003_ooool00`00003oooooooooo`02o`00017ooooo1?l0000Coooo
o`?o00002?ooool00`00003oooooooooo`0=ooooo`;o00001oooool00`00003oooooooooo`0:oooo
o`Co00001?ooool00`00003oooooooooo`03ooooo`;o00003?ooool2o`0004Gooooo0016ooooo`Ko
00000oooool00`00003oooooooooo`0:ooooo`;o00004oooool3o`00008000003oooool3o`0001Wo
oooo0ol0000Booooo`Co00002oooool2o`0000_ooooo0ol00015ooooo`00A_ooool3o`000004oooo
ool0003o0000o`0000?ooooo00<00000ooooooooool01?ooool00`00003oooooooooo`02ooooo`;o
00005?ooool4o`00000300000?oooooooooo00_ooooo0ol00007ooooo`8000004_ooool3o`0000So
oooo00<00000ooooooooool01?ooool4o`0000Cooooo00<00000ooooooooool01_ooool2o`0000[o
oooo0ol00016ooooo`00Aoooool3o`000003ooooool0003o000000;o00000_ooool00`00003ooooo
ooooo`02ooooo`0300000?oooooooooo00?ooooo0_l0000Eooooo`Co00003?ooool3o`0000Kooooo
0P00000Eooooo`?o00002?ooool00`00003oooooooooo`02ooooo`Co00001?ooool00`00003ooooo
ooooo`07ooooo`;o00002Oooool3o`0004Oooooo0018ooooo`;o00000_ooool4o`0000Gooooo00<0
0000ooooooooool01?ooool2o`0001Oooooo1?l000000`00003oooooooooo`06ooooo`?o00007ooo
ool2o`0000Wooooo00<00000ooooool000000ol00005ooooo`0300000?oooooooooo00Oooooo0ol0
0008ooooo`?o0000B?ooool004Sooooo0ol00003ooooo`?o00002_ooool3o`0001Sooooo1?l00000
0`00003oooooooooo`04ooooo`?o00001Oooool2000001Wooooo0ol00009ooooo`Co00004?ooool2
o`0000Sooooo0ol00019ooooo`00BOooool3o`0000?ooooo0ol000000ooooooo000000000006oooo
o`;o00006oooool3o`00000300000?oooooooooo00;ooooo0ol00005ooooo`0300000?oooooooooo
01[ooooo0ol00006ooooo`Co00000P000004ooooo`0300000?oooooooooo00Wooooo0_l00007oooo
o`?o0000B_ooool004[ooooo0ol00003ooooo`Co000000?ooooo00000?ooool01?ooool2o`0001co
oooo1?l00002ooooo`?o00001Oooool00`00003oooooooooo`0Looooo`;o00001Oooool4o`0000?o
oooo00@00000ooooooooool000003?ooool2o`0000Kooooo0ol0001;ooooo`00Boooool2o`0000Co
oooo1?l00006ooooo`;o00007Oooool7o`0002Gooooo0ol00002ooooo`Co00001_ooool2000000go
oooo0_l00005ooooo`?o0000C?ooool004_ooooo0ol00005ooooo`?o00000_ooool00`00003ooooo
ooooo`02o`0001oooooo1?l00003ooooo`8000008_ooool7o`0000Kooooo00<00000ooooo`000000
3Oooool2o`0000Cooooo0ol0001=ooooo`00C?ooool3o`0000Gooooo1?l000000oooool00000oooo
o`02o`00023ooooo0_l000001?ooool00000ooooo`00000Uooooo`Co00001oooool01@00003ooooo
ooooooooool0000000_ooooo0ol00003ooooo`?o0000C_ooool004gooooo0_l00006ooooo`Co0000
00Cooooo00000?l0003o00008?ooool3o`000004ooooo`0000000000000002Cooooo0ol0000<oooo
o`0300000?oooooooooo00Wooooo0_l00003ooooo`?o0000Coooool004gooooo0ol00004ooooo`03
00000?oooooooooo00Ko00008?ooool4o`0000?ooooo00<00000ooooooooool08?ooool4o`0000Go
oooo0P00000Aooooo`;o00000_ooool3o`00053ooooo001>ooooo`?o00000oooool01000003ooooo
ooooooooool4o`000003ooooo`00003ooooo01gooooo1_l0000Tooooo`Go00001?ooool00`00003o
ooooooooo`0Aooooo`;o000000Coooooo`000?l0003o0000DOooool004oooooo0ol00003ooooo`04
00000?ooooooooooooooo`Co000000?ooooo00000?ooool07?ooool2o`0000;ooooo0_l00004oooo
o`8000007Oooool6o`0000?ooooo00<00000ooooooooool01oooool00`00003oooooooooo`08oooo
o`Go0000D_ooool0053ooooo0_l00003ooooo`0300000?oooooooooo00;ooooo1?l000000oooool0
0000ooooo`0Kooooo`;o00000_ooool3o`0000Gooooo00<00000ooooooooool06Oooool3o`000004
ooooool0003o0000ooooo`8000002oooool00`00003oooooooooo`07ooooo`Go0000Doooool0053o
oooo0ol00007ooooo`Ko00007?ooool2o`0000?ooooo0ol00005ooooo`0300000?oooooooooo01Oo
oooo0ol00002ooooo`;o000000<00000ooooooooool03?ooool00`00003oooooooooo`06ooooo`Co
0000E?ooool0057ooooo0ol00007ooooo`Ko000000?ooooo0000000000005oooool00`00003o0000
o`000004ooooo`;o00007_ooool3o`0000?ooooo0_l0000?ooooo`0300000?oooooooooo00Gooooo
1?l0001Eooooo`00D_ooool2o`000003ooooo`00003ooooo00Gooooo1_l00002ooooo`0300000?oo
oooooooo01Gooooo0_l00004ooooo`?o00001_ooool2000001Cooooo0ol00004ooooo`;o00005_oo
ool4o`0005Kooooo001Booooo`?o000000<00000ooooooooool01Oooool2o`000003ooooool0003o
000000;o00005?ooool01000003oooooooooooooool2o`0000Gooooo0ol00007ooooo`0300000?oo
oooooooo013ooooo0ol00003ooooo`0400000?l0003o0000o`0001Cooooo1?l0001Hooooo`00Dooo
ool3o`00000300000?oooooooooo00Cooooo0ol000000ooooooo0000o`000002o`0000;ooooo00<0
0000ooooooooool03Oooool01000003oooooooooooooool3o`0000Kooooo0ol00007ooooo`030000
0?oooooooooo00kooooo0ol00002ooooo`80000000?oooooo`000?l000004Oooool00`00003ooooo
ooooo`04o`0005Wooooo001Dooooo`Co00001_ooool3o`0000;ooooo1?l000000oooool00000oooo
o`0<ooooo`0300000?oooooooooo00;ooooo0_l00008ooooo`;o00005oooool3o`0000Kooooo0_l0
000Aooooo`0300000?l0003o000000?o0000F_ooool005Gooooo1?l00006ooooo`?o00000_ooool4
o`000003ooooo`00003ooooo013ooooo0_l00008ooooo`?o00002?ooool3000000[ooooo0ol00000
0oooool00000ooooo`04ooooo`;o00004Oooool5o`0005_ooooo001Gooooo`?o00001_ooool2o`00
00Cooooo0ol0000;ooooo`0300000?oooooooooo00Cooooo0_l00009ooooo`?o00002_ooool00`00
003oooooooooo`06ooooo`?o000000?ooooo00000?ooool01Oooool2o`0000oooooo1_l0001Loooo
o`00F?ooool4o`0000Cooooo0ol00004ooooo`Co000000?ooooo00000?ooool01Oooool00`00003o
ooooooooo`05ooooo`;o00002_ooool3o`00017ooooo0ol000000oooool00000ooooo`05ooooo`?o
00003_ooool6o`0005gooooo001Iooooo`Co00001?ooool3o`0000Cooooo1?l000000oooool00000
ooooo`03ooooo`0300000?oooooooooo00Kooooo0_l0000;ooooo`;o00002oooool2000000?ooooo
0ol00009ooooo`;o00003Oooool7o`0005kooooo001Kooooo`?o00001?ooool3o`0000Gooooo1?l0
00000`00003oooooooooo`0:ooooo`;o00002oooool3o`0000cooooo00<00000ooooool000000_l0
00000`00003oooooooooo`07ooooo`;o00003?ooool7o`0005oooooo001Looooo`Co00000oooool3
o`0000Gooooo1?l000000oooool00000ooooo`08ooooo`?o00003?ooool3o`0000cooooo0ol0000;
ooooo`;o00002_ooool4o`00000400000?l0003o0000o`00063ooooo001Mooooo`Co00000oooool2
o`0000Oooooo0ol00002000000Sooooo0_l0000>ooooo`?o00002_ooool3o`0000cooooo0_l00009
ooooo`Co000000@00000o`000?l0003o0000HOooool005oooooo0ol00002ooooo`?o00001oooool4
o`00000300000?oooooooooo00Gooooo0_l0000?ooooo`;o00002Oooool3o`00000300000?oooooo
oooo00[ooooo0_l00007ooooo`Co000000?ooooo00000?l000000_l0001Rooooo`00H?ooool4o`00
0004ooooool0003o0000o`0000Oooooo1?l00007ooooo`;o00003oooool3o`0000Oooooo0ol00002
ooooo`0300000?oooooooooo00Sooooo0ol00006ooooo`Co00000_ooool3o`0006?ooooo001Qoooo
o`Co000000Coooooo`000?l0003o00002?ooool4o`00008000000oooool2o`00013ooooo0ol00005
ooooo`?o00000oooool00`00003oooooooooo`08ooooo`;o00001Oooool4o`000080000000Cooooo
o`000?l0003o0000I?ooool006?ooooo0ol000000ooooooo0000o`000009ooooo`Co000000Cooooo
00000?oooooooooo0_l0000Aooooo`;o00001?ooool3o`0000oooooo0_l00004ooooo`Co000000<0
0000ooooooooool00ol0001Uooooo`00I?ooool6o`0000Oooooo00<00000ooooooooool00ol00003
ooooo`;o00004Oooool3o`0000;ooooo0ol0000@ooooo`;o00000_ooool4o`0000Cooooo0ol0001V
ooooo`00IOooool6o`0000Kooooo00@00000oooooooooooooooo1ol0000Booooo`Ko00001oooool0
0`00003oooooooooo`07ooooo`;o000000?oooooo`000?l000000_l000001000003ooooooooooooo
ool3o`0006Oooooo001Wooooo`Go00001_ooool01000003oooooooooooooool5o`00000300000?oo
oooooooo017ooooo1?l00008ooooo`0300000?oooooooooo00Kooooo1_l000000`00003ooooooooo
o`02ooooo`?o0000J?ooool006Sooooo1?l00006ooooo`0300000?oooooooooo00?ooooo0ol00000
0oooool00000ooooo`0Booooo`;o00002_ooool00`00003oooooooooo`05ooooo`Go000000<00000
ooooooooool00_ooool3o`0006Wooooo001Yooooo`Co00003?ooool2o`0001Gooooo0_l0000:oooo
o`0300000?oooooooooo00Cooooo1?l00006ooooo`?o0000J_ooool006_ooooo0ol0000;ooooo`?o
00000oooool00`00003oooooooooo`0=ooooo`0300000?l0003o0000013ooooo1?l00002000000Co
oooo0ol0001[ooooo`00K?ooool4o`0000?ooooo00<00000ooooooooool01?ooool3o`0000?ooooo
00<00000ooooooooool02oooool01000003o0000o`000?l0000?ooooo`?o00000P000005ooooo`?o
0000K?ooool006gooooo1?l00002ooooo`0300000?oooooooooo00Gooooo0ol00003ooooo`030000
0?oooooooooo00_ooooo0_l0000<ooooo`0300000?oooooooooo00?o00001oooool3o`0006gooooo
001_ooooo`?o00000_ooool00`00003oooooooooo`05ooooo`;o00003_ooool00`00003ooooooooo
o`02o`0000cooooo00<00000ooooool000000_l000000`00003oooooooooo`03ooooo`Co0000K_oo
ool0073ooooo1?l000000`00003oooooooooo`05ooooo`?o00001Oooool00`00003oooooooooo`04
ooooo`0400000?ooooooooooooooo`;o00003?ooool01000003o0000o`000?l00006ooooo`Co0000
Koooool0077ooooo1?l00008ooooo`?o00001Oooool00`00003oooooooooo`02ooooo`0300000?oo
oooooooo00;ooooo0_l0000<ooooo`?o00001Oooool4o`00077ooooo001cooooo`Co00001oooool2
o`0000Kooooo00<00000ooooooooool01Oooool3o`0000_ooooo0ol00005ooooo`Co0000L_ooool0
07Cooooo1?l00006ooooo`?o00001oooool00`00003oooooooooo`03ooooo`;o00002oooool3o`00
00Cooooo1?l0001dooooo`00M_ooool3o`0000Kooooo0ol00006ooooo`0300000?oooooooooo00?o
oooo0_l0000:ooooo`?o00001?ooool4o`0007Gooooo001gooooo`Co00001Oooool3o`0000Gooooo
00<00000ooooooooool00oooool2o`0000Wooooo0ol00003ooooo`Co0000Moooool007Sooooo1?l0
0005ooooo`;o00001Oooool00`00003oooooooooo`03ooooo`;o00002?ooool3o`0000?ooooo1?l0
001hooooo`00N_ooool3o`0000Cooooo0ol00009ooooo`?o00001oooool3o`0000;ooooo1?l0001j
ooooo`00Noooool4o`0000?ooooo0ol00008ooooo`;o00001oooool3o`0000;ooooo1?l0001koooo
o`00O?ooool4o`0000?ooooo0_l00004ooooo`0400000?ooooooooooooooo`;o00001_ooool3o`00
0003ooooool0003o000000;o0000OOooool007kooooo0ol00002ooooo`?o00000oooool01000003o
ooooooooooooool2o`0000Gooooo0ol000000ooooooo0000o`000002o`0007kooooo001oooooo`Co
000000Coooooo`000?l0003o00000oooool00`00003oooooooooo`02o`0000Cooooo1ol00020oooo
o`00P?ooool4o`000004ooooool0003o0000o`0000Cooooo0ol00003ooooo`Oo0000POooool008;o
oooo1_l00004ooooo`;o00000oooool6o`0008?ooooo0023ooooo`Ko00000oooool2o`0000;ooooo
1_l00024ooooo`00QOooool5o`000005ooooo`00003o0000o`000?ooool01Ol00026ooooo`00Q_oo
ool4o`000003ooooo`00003o000000Ko0000Qoooool008Oooooo2_l00029ooooo`00ROooool7o`00
08[ooooo002:ooooo`Co0000S?ooool008_ooooo0_l0002=ooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.50591 .47737 m
.40293 .54924 L
s
.50591 .47737 m
.60899 .54832 L
s
.43089 .39122 m
.50591 .47737 L
s
.57757 .39048 m
.50591 .47737 L
s
.40293 .54924 m
.32611 .60814 L
s
.40293 .54924 m
.50593 .62051 L
s
.32689 .46356 m
.40293 .54924 L
s
.60899 .54832 m
.6826 .60661 L
s
.60899 .54832 m
.50593 .62051 L
s
.68179 .46185 m
.60899 .54832 L
s
.50593 .62051 m
.57827 .67989 L
s
.50593 .62051 m
.43028 .68049 L
s
.43089 .39122 m
.32689 .46356 L
s
.42745 .29623 m
.43089 .39122 L
s
.50249 .30279 m
.43089 .39122 L
s
.57757 .39048 m
.68179 .46185 L
s
.50249 .30279 m
.57757 .39048 L
s
.57613 .29543 m
.57757 .39048 L
s
.32689 .46356 m
.2484 .52183 L
s
.32201 .36937 m
.32689 .46356 L
s
.68179 .46185 m
.75708 .51949 L
s
.68177 .36753 m
.68179 .46185 L
s
.32611 .60814 m
.3204 .66298 L
s
.32611 .60814 m
.43028 .68049 L
s
.2484 .52183 m
.32611 .60814 L
s
.6826 .60661 m
.68342 .66149 L
s
.6826 .60661 m
.57827 .67989 L
s
.75708 .51949 m
.6826 .60661 L
s
.43028 .68049 m
.50252 .7415 L
s
.43028 .68049 m
.42646 .73681 L
s
.5 .20569 m
.50249 .30279 L
s
.57827 .67989 m
.57717 .73623 L
s
.57827 .67989 m
.50252 .7415 L
s
.42745 .29623 m
.32201 .36937 L
s
.5 .20569 m
.42745 .29623 L
s
.57613 .29543 m
.68177 .36753 L
s
.5 .20569 m
.57613 .29543 L
s
.2484 .52183 m
.24119 .57556 L
s
.24237 .42719 m
.2484 .52183 L
s
.32201 .36937 m
.24237 .42719 L
s
.39371 .27935 m
.32201 .36937 L
s
.68177 .36753 m
.75811 .42464 L
s
.60637 .27818 m
.68177 .36753 L
s
.75708 .51949 m
.75929 .57328 L
s
.75811 .42464 m
.75708 .51949 L
s
.50252 .7415 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.57426 .26089 L
s
.5 .20569 m
.49743 .25396 L
s
.5 .20569 m
.42216 .26173 L
s
.5 .20569 m
.39371 .27935 L
s
.5 .20569 m
.60637 .27818 L
s
.0035 w
[ .01 .012 ] 0 setdash
.3204 .66298 m
.42646 .73681 L
s
.0085 w
[ ] 0 setdash
.3204 .66298 m
.39224 .72471 L
s
.24119 .57556 m
.3204 .66298 L
s
.39371 .27935 m
.31429 .33649 L
s
.60637 .27818 m
.68233 .33455 L
s
.0035 w
[ .01 .012 ] 0 setdash
.68342 .66149 m
.57717 .73623 L
s
.0085 w
[ ] 0 setdash
.68342 .66149 m
.60784 .72388 L
s
.75929 .57328 m
.68342 .66149 L
s
.0035 w
[ .01 .012 ] 0 setdash
.42646 .73681 m
.5 .79975 L
s
.57717 .73623 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.24237 .42719 m
.23495 .4799 L
s
.31429 .33649 m
.24237 .42719 L
s
.75811 .42464 m
.76037 .47741 L
s
.68233 .33455 m
.75811 .42464 L
s
.24119 .57556 m
.31256 .63661 L
s
.23495 .4799 m
.24119 .57556 L
s
.75929 .57328 m
.68402 .63506 L
s
.76037 .47741 m
.75929 .57328 L
s
.42216 .26173 m
.41808 .31172 L
s
.42216 .26173 m
.31429 .33649 L
s
.57426 .26089 m
.57305 .31089 L
s
.57426 .26089 m
.68233 .33455 L
s
.31429 .33649 m
.30816 .388 L
s
.39224 .72471 m
.5 .79975 L
s
.31256 .63661 m
.39224 .72471 L
s
.60784 .72388 m
.5 .79975 L
s
.68402 .63506 m
.60784 .72388 L
s
.68233 .33455 m
.68317 .38609 L
s
.42107 .71209 m
.5 .79975 L
s
.49739 .70652 m
.5 .79975 L
s
.5753 .71149 m
.5 .79975 L
s
.49743 .25396 m
.57305 .31089 L
s
.49743 .25396 m
.41808 .31172 L
s
.23495 .4799 m
.30725 .54045 L
s
.30816 .388 m
.23495 .4799 L
s
.31256 .63661 m
.42107 .71209 L
s
.30725 .54045 m
.31256 .63661 L
s
.68402 .63506 m
.5753 .71149 L
s
.68403 .53874 m
.68402 .63506 L
s
.76037 .47741 m
.68403 .53874 L
s
.68317 .38609 m
.76037 .47741 L
s
.41731 .61674 m
.42107 .71209 L
s
.57375 .61608 m
.5753 .71149 L
s
.41808 .31172 m
.49361 .37029 L
s
.41808 .31172 m
.30816 .388 L
s
.41731 .61674 m
.49739 .70652 L
s
.57375 .61608 m
.49739 .70652 L
s
.57305 .31089 m
.49361 .37029 L
s
.57305 .31089 m
.68317 .38609 L
s
.30816 .388 m
.38223 .44779 L
s
.68317 .38609 m
.60505 .44671 L
s
.30725 .54045 m
.41731 .61674 L
s
.38223 .44779 m
.30725 .54045 L
s
.68403 .53874 m
.57375 .61608 L
s
.60505 .44671 m
.68403 .53874 L
s
.49358 .52458 m
.41731 .61674 L
s
.49358 .52458 m
.57375 .61608 L
s
.49361 .37029 m
.38223 .44779 L
s
.49361 .37029 m
.60505 .44671 L
s
.38223 .44779 m
.49358 .52458 L
s
.60505 .44671 m
.49358 .52458 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`0008cooooo0029ooooo`Ko0000Rooo
ool008Oooooo2_l00029ooooo`00Q_ooool4o`00000400000?l0003o0000ooooo`Co0000R?ooool0
08Gooooo1?l00002ooooo`;o00000_ooool4o`0008Oooooo0023ooooo`Co000000Cooooo00000?oo
oooooooo0_l00003ooooo`0300000?l0003o000000;o0000QOooool008;ooooo1?l000000oooool0
0000ooooo`02ooooo`;o00001?ooool00`00003o0000o`000002o`0008Cooooo0020ooooo`Co0000
0_ooool00`00003oooooooooo`02ooooo`;o00001Oooool00`00003o0000o`000003o`0008;ooooo
001oooooo`Co00001oooool3o`0000Sooooo1?l00021ooooo`00OOooool5o`0000Sooooo0_l00000
0`00003oooooooooo`07ooooo`Go0000Ooooool007cooooo1?l00004ooooo`0300000?oooooooooo
00?ooooo0_l00008ooooo`0300000?oooooooooo00Go0000O_ooool007_ooooo1?l00004ooooo`03
00000?oooooooooo00Cooooo0_l00009ooooo`0300000?oooooooooo00Go0000OOooool007Wooooo
1Ol00004ooooo`0300000?oooooooooo00Gooooo0_l0000:ooooo`0400000?ooooooooooooooo`Go
0000Noooool007Sooooo1?l0000>ooooo`;o000000<00000ooooooooool03?ooool5o`0007[ooooo
001fooooo`Go00003_ooool4o`0000_ooooo00@00000oooooooooooooooo1_l0001hooooo`00MOoo
ool4o`0000Oooooo00<00000ooooooooool01Oooool6o`0000[ooooo00<00000ooooooooool00ooo
ool5o`0007Oooooo001cooooo`Go00002?ooool00`00003oooooooooo`04ooooo`?o00000_ooool3
o`0000[ooooo00<00000ooooooooool00oooool6o`0007Gooooo001booooo`Go00002?ooool00`00
003oooooooooo`03ooooo`Co00001?ooool4o`0000Wooooo00<00000ooooooooool00oooool6o`00
07Cooooo001aooooo`Ko00003Oooool4o`0000Kooooo1?l0000>ooooo`Oo0000Loooool006oooooo
1Ol000000ooooooo0000o`00000;ooooo`Co00001_ooool01000003oooooooooooooool4o`0000So
oooo00@00000oooooooooooooooo0_l000000ooooooo0000o`000004o`00077ooooo001^ooooo`Co
00000oooool2o`0000Kooooo00@00000oooooooooooooooo1?l00007ooooo`0300000?oooooooooo
00;ooooo1?l00008ooooo`0300000?oooooooooo00;o00000oooool5o`00073ooooo001/ooooo`Go
00001?ooool2o`0000Gooooo00@00000oooooooooooooooo0ol0000:ooooo`0300000?oooooooooo
00?ooooo0ol00008ooooo`0400000?oooooo0000o`0000Cooooo1_l0001^ooooo`00Joooool5o`00
00Gooooo0_l00004ooooo`0300000?oooooooooo00Co00002oooool00`00003oooooooooo`04oooo
o`Co00002?ooool2o`0000Gooooo1_l0001]ooooo`00J_ooool4o`0000Oooooo0_l00006ooooo`Co
00005?ooool4o`0000Oooooo0_l00007ooooo`Go0000K?ooool006Sooooo1Ol00007ooooo`?o0000
0_ooool00`00003oooooooooo`03o`0001Sooooo0ol00006ooooo`;o00002?ooool6o`0006[ooooo
001Wooooo`Co00002Oooool2o`0000?ooooo00<00000o`000?l000000_l0000?ooooo`0300000?oo
oooooooo00Sooooo1?l00004ooooo`;o00002_ooool5o`0006Wooooo001Uooooo`Go000000<00000
ooooooooool01oooool2o`000003ooooo`000000000000Co00004?ooool00`00003oooooooooo`09
ooooo`Co00000oooool2o`00008000002Oooool5o`0006Sooooo001Tooooo`Co00000_ooool00`00
003oooooooooo`07ooooo`;o000000<00000o`000?l000000_l0000Booooo`0300000?oooooooooo
00_ooooo1?l000000ooooooo0000o`000002ooooo`0300000?oooooooooo00Sooooo1Ol0001Voooo
o`00Hoooool4o`0000;ooooo00<00000ooooooooool02?ooool6o`0001?ooooo00<00000oooooooo
ool03?ooool6o`0000kooooo1Ol0001Uooooo`00HOooool5o`0000cooooo00<00000ooooool00000
0ol000000`00003oooooooooo`0Aooooo`0300000?ooool0000000oooooo1?l00004ooooo`800000
2Oooool5o`0006Cooooo001Pooooo`Co00003Oooool00`00003oooooo`000003o`0001Cooooo00D0
0000oooooooooooooooo0000000?ooooo`Co00001Oooool00`00003oooooooooo`07ooooo`030000
0?l0003o000000;o0000Hoooool005oooooo1?l00003ooooo`0300000?oooooooooo00Oooooo00<0
0000ooooool000001Ol0000Vooooo`Ko00001Oooool00`00003oooooooooo`07ooooo`0300000?l0
003o000000?o0000HOooool005gooooo1?l00005ooooo`0300000?oooooooooo00Oooooo1?l00002
ooooo`?o00004?ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Wooooo0ol00000
0oooool00000o`000003o`0000kooooo00<00000ooooool000000ol0001Pooooo`00G?ooool4o`00
00Gooooo00<00000ooooooooool01?ooool200000003ooooool0003o000000;o00001?ooool3o`00
00oooooo00<00000ooooooooool01_ooool00`00003oooooooooo`06ooooo`Co00000_ooool00`00
003oooooo`000003o`0000Gooooo0P000009ooooo`Co0000Goooool005[ooooo1?l0000=ooooo`03
00000?oooooooooo00?o00001oooool4o`0000cooooo00<00000ooooooooool02?ooool00`00003o
ooooooooo`04ooooo`Co00001?ooool00`00003oooooooooo`03o`0000Kooooo00<00000oooooooo
ool02?ooool4o`0005gooooo001Iooooo`Co00001_ooool00`00003oooooooooo`06ooooo`Co0000
2?ooool00`00003o0000o`000002o`0000[ooooo00<00000ooooooooool03oooool3o`0000Kooooo
00@00000oooooooooooooooo1?l0000<ooooo`0400000?ooooooooooooooo`Co0000G?ooool005So
oooo1?l00007ooooo`0300000?oooooooooo00;ooooo00<00000ooooooooool01?l0000<ooooo`?o
00006Oooool4o`0000cooooo1?l00006ooooo`0300000?oooooooooo00?ooooo00@00000oooooooo
oooooooo1?l0001Kooooo`00Eoooool3o`0000Sooooo00<00000ooooooooool00_ooool00`00003o
ooooo`000003o`0000oooooo0ol00006ooooo`0300000?oooooooooo00gooooo00<00000o`000?l0
00000_l0000?ooooo`Co00001Oooool00`00003oooooooooo`03ooooo`0300000?oooooooooo00;o
oooo0ol0001Jooooo`00Eoooool2o`0000Sooooo00<00000ooooooooool00_ooool00`00003ooooo
o`000003o`0000cooooo00<00000ooooooooool00_ooool4o`0000?ooooo00<00000ooooooooool0
3Oooool4o`0000[ooooo00<00000ooooooooool01Oooool4o`0000Gooooo00<00000ooooooooool0
2?ooool2o`0005[ooooo001Fooooo`?o00003_ooool3o`0000kooooo00<00000ooooooooool00ooo
ool4o`000003ooooo`00003ooooo00kooooo1?l000000`00003oooooooooo`08ooooo`0300000?oo
oooooooo00Oooooo1?l00006ooooo`0300000?oooooooooo00Gooooo0ol0001Iooooo`00EOooool4
o`0000Kooooo00<00000ooooooooool00P0000000ooooooo0000o`000002o`0000oooooo00<00000
ooooooooool01Oooool3o`0000oooooo0ol0000=ooooo`0300000?oooooooooo00Sooooo1?l00006
ooooo`0400000?oooooooooo000000?ooooo1?l0001Hooooo`00E?ooool5o`0000Kooooo00<00000
ooooo`0000000_ooool4o`00013ooooo00<00000ooooooooool01_ooool3o`0000cooooo1?l0000>
ooooo`0300000?oooooooooo00[ooooo0ol00006ooooo`0400000?oooooooooo000000;ooooo1Ol0
001Gooooo`00E?ooool5o`0000Gooooo00@00000oooooooooooooooo1?l0000Kooooo`0400000?l0
003o0000o`0000[ooooo1?l00006ooooo`0300000?oooooooooo01Cooooo1?l00008ooooo`050000
0?oooooo0000o`000?ooool00ol0001Fooooo`00Doooool5o`0000Gooooo0P000002ooooo`Co0000
6oooool00`00003oooooooooo`04o`0000Oooooo0ol00009ooooo`0300000?oooooooooo01Cooooo
1?l00006ooooo`0300000?oooooooooo00;o00000_ooool3o`0005Gooooo001Booooo`?o000000?o
ooooo`000?l000001Oooool00`00003oooooooooo`03o`0001Gooooo00<00000ooooooooool01?oo
ool00`00003oooooooooo`02ooooo`Co00001?ooool4o`0000_ooooo00<00000ooooooooool01?oo
ool00`00003oooooooooo`0>ooooo`Co00001Oooool01000003oooooo`000?l00003ooooo`?o0000
E?ooool0057ooooo0ol00002ooooo`;o00000oooool00ol000000000ooooo`04o`0001Kooooo00<0
0000ooooooooool02oooool3o`0000;ooooo1?l0000Cooooo`0300000?oooooooooo00oooooo1?l0
0005ooooo`0300000?l0003o000000Cooooo0ol0001Cooooo`00D?ooool3o`0000?ooooo0_l00002
ooooo`03o`000?oooooooooo00Co00005oooool00`00003oooooooooo`0<ooooo`Ko00004?ooool0
0`00003oooooooooo`02ooooo`0300000?oooooooooo017ooooo1?l00004ooooo`;o000000<00000
ooooooooool00_ooool2o`0005?ooooo001@ooooo`;o00001?ooool2o`000003ooooo`0000000000
00Co00006Oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo00Sooooo1?l0000Aoooo
o`0300000?oooooooooo00;ooooo00<00000ooooooooool04_ooool4o`0000?ooooo0_l000000ooo
ool00000ooooo`02ooooo`?o0000D_ooool004oooooo0ol00004ooooo`;o000000<00000ooooool0
00000ol0000Nooooo`0300000?oooooooooo00Sooooo1_l0000Aooooo`0300000?oooooooooo01So
oooo0ol00002ooooo`;o00001_ooool3o`00057ooooo001>ooooo`?o00001?ooool3o`000004oooo
ool0003o0000o`0001oooooo00<00000ooooooooool01oooool4o`0000;ooooo1?l0000@ooooo`03
00000?oooooooooo01Sooooo1_l00007ooooo`?o0000D?ooool004gooooo0ol00005ooooo`Ko0000
7Oooool00`00003oooooooooo`09ooooo`Co00001?ooool4o`0001;ooooo00<00000ooooooooool0
5_ooool5o`0000Cooooo0P000002ooooo`?o0000Coooool004gooooo0_l00005ooooo`0300000?l0
003o000000?o00007_ooool00`00003oooooooooo`07ooooo`Co00002?ooool4o`0000oooooo00?o
000000000?ooool06Oooool3o`0000Kooooo00<00000ooooooooool00ol0001>ooooo`00C?ooool3
o`0000Cooooo00<00000ooooool000000_l00002ooooo`0300000?oooooooooo01_ooooo00<00000
o`000?ooool01_ooool4o`0000[ooooo1?l0000?ooooo`0300000?oooooooooo01Oooooo1?l0000:
ooooo`?o0000COooool004_ooooo0ol00007ooooo`Co000000?ooooo00000?ooool06oooool00`00
003ooooo00000005ooooo`Co00003_ooool4o`0000cooooo00<00000ooooo`0000005oooool6o`00
00Sooooo00<00000ooooool000000_l0001<ooooo`00B_ooool3o`0000;ooooo0P000003ooooo`Ko
000000<00000ooooooooool06Oooool01@00003oooooooooooooool0000000?ooooo1?l0000@oooo
o`Co00002_ooool01@00003oooooooooooooool0000001Gooooo0ol00002ooooo`?o00002?ooool0
0`00003oooooo`000002o`0004_ooooo001:ooooo`;o00000_ooool00`00003oooooooooo`02oooo
o`?o00000_ooool4o`0001kooooo00<00000ooooool000000ol0000Dooooo`Co00008?ooool4o`00
00?ooooo00@00000o`000?l0003o00002?ooool01000003oooooo`000?l0001;ooooo`00BOooool3
o`0000Kooooo0ol00004ooooo`Co00005_ooool00`00003oooooooooo`05ooooo`Co00005_ooool4
o`0000kooooo0P00000>ooooo`Co00001_ooool3o`0000Wooooo0ol0001:ooooo`00B?ooool3o`00
000300000?oooooooooo00?ooooo0ol00007ooooo`?o00005?ooool00`00003oooooooooo`04oooo
o`Co000000<00000ooooooooool05oooool4o`0000?ooooo00<00000ooooooooool02?ooool00`00
003oooooooooo`0:ooooo`?o00002Oooool3o`0000Wooooo0ol00019ooooo`00Aoooool3o`000003
00000?oooooooooo00Cooooo0_l00009ooooo`Co00004Oooool00`00003oooooooooo`04ooooo`Co
000000?ooooo00000?ooool06Oooool5o`00000300000?oooooooooo01Gooooo0ol00007ooooo`04
00000?ooooooooooooooo`?o00002Oooool3o`0004Sooooo0016ooooo`?o000000<00000oooooooo
ool01?ooool3o`0000Sooooo00<00000ooooool000000ol0000Fooooo`?o00001?ooool00`00003o
ooooooooo`0Iooooo`Co00003_ooool00`00003oooooooooo`04ooooo`Co00002?ooool00`00003o
ooooooooo`02ooooo`;o00002_ooool3o`0004Oooooo0016ooooo`;o00001oooool3o`0000Wooooo
00@00000oooooooooooooooo0ol0000;ooooo`8000001_ooool4o`0002?ooooo1?l0000=ooooo`03
00000?oooooooooo00;ooooo1?l00009ooooo`0300000?oooooooooo00;ooooo0ol0000:ooooo`?o
0000A_ooool004Gooooo0ol00006ooooo`?o00002_ooool00`00003oooooooooo`02ooooo`?o0000
2Oooool00`00003oooooooooo`05ooooo`Co00009Oooool4o`0000gooooo00<00000ooooooooool0
0ol0000;ooooo`0300000?oooooooooo00?ooooo0ol0000:ooooo`?o0000AOooool004Cooooo0ol0
0006ooooo`?o00004Oooool4o`0000gooooo1?l0000;ooooo`0300000?oooooooooo01Kooooo00<0
0000ooooooooool00_ooool4o`0000gooooo0ol0000Cooooo`?o00002_ooool3o`0004Cooooo0013
ooooo`?o00001oooool2o`0001?ooooo1?l00003ooooo`0300000?oooooooooo00Gooooo1?l0000=
ooooo`0300000?oooooooooo01Cooooo00<00000ooooooooool01?ooool4o`0000_ooooo0ol00000
0`00003oooooooooo`0Booooo`?o00002_ooool2o`0004Cooooo0013ooooo`;o00001oooool3o`00
01Gooooo0ol000000oooool00000ooooo`05ooooo`Co00004?ooool00`00003oooooooooo`0Boooo
o`0300000?oooooooooo00Oooooo1?l00007ooooo`Co00000_ooool00`00003oooooooooo`09oooo
o`0300000?oooooooooo00Kooooo0ol00009ooooo`;o0000A?ooool004?ooooo0_l00006ooooo`?o
00003Oooool00`00003oooooooooo`07ooooo`Co00001Oooool4o`00037ooooo1?l00005ooooo`Co
00003oooool00`00003oooooooooo`07ooooo`;o00002Oooool2o`0004Cooooo0013ooooo`;o0000
1Oooool3o`0000kooooo00<00000ooooooooool02?ooool4o`0000;ooooo1?l0000Eooooo`030000
0?oooooooooo01gooooo1?l00002ooooo`?o00002?ooool00`00003oooooooooo`06ooooo`030000
0?oooooooooo00Oooooo0ol00008ooooo`;o0000A?ooool004;ooooo0ol00004ooooo`?o00003ooo
ool00`00003oooooooooo`05ooooo`8000000oooool7o`0001Kooooo00<00000ooooooooool03_oo
ool00`00003oooooooooo`0=ooooo`Oo00002_ooool00`00003oooooooooo`05ooooo`0300000?oo
oooooooo00Sooooo0ol00007ooooo`;o0000A?ooool004;ooooo0_l00005ooooo`;o00004?ooool0
0`00003oooooooooo`04ooooo`0300000?oooooooooo00Cooooo1?l0000Iooooo`0300000?oooooo
oooo00cooooo00<00000ooooooooool04?ooool4o`0000cooooo00<00000ooooooooool04?ooool3
o`0000Kooooo0_l00014ooooo`00@_ooool2o`00000400000?ooooooooooooooo`?o00007oooool4
o`0001Wooooo00<00000ooooooooool02_ooool00`00003oooooooooo`0@ooooo`Co00008Oooool3
o`0000Gooooo0_l00014ooooo`00@_ooool2o`00000300000?oooooooooo00?o00005Oooool00`00
003oooooooooo`07ooooo`Oo0000=Oooool7o`0000oooooo0`00000?ooooo`?o00001?ooool2o`00
04Cooooo0012ooooo`;o000000<00000ooooool000000_l0000Booooo`0400000?oooooooooo0000
00Wooooo0ol00002ooooo`Co00006?ooool00`00003oooooooooo`06ooooo`0300000?oooooooooo
00oooooo1?l00002ooooo`?o00004Oooool00`00003o0000ooooo`0=ooooo`?o00000oooool2o`00
04Cooooo0012ooooo`;o000000@00000o`000?l0003o00004oooool00`00003ooooo00000009oooo
o`?o00001Oooool3o`0001Sooooo00<00000ooooooooool01Oooool00`00003oooooooooo`0=oooo
o`Co00001Oooool3o`00017ooooo00?o0000ooooooooool03Oooool2o`0000?ooooo0_l00014oooo
o`00@_ooool2o`000003ooooool0003o000001?ooooo0P00000:ooooo`?o00001oooool4o`0001Oo
oooo00<00000ooooooooool00oooool00`00003oooooooooo`0=ooooo`Co00001oooool3o`0000oo
oooo00<00000ooooo`0000003_ooool3o`0000;ooooo0_l00014ooooo`00@Oooool6o`0001;ooooo
00@00000ooooooooool000002Oooool2o`0000Wooooo1?l0000Kooooo`0300000?oooooooooo00go
oooo0ol0000:ooooo`?o00003Oooool01@00003oooooooooooooool0000000kooooo0ol000000ooo
oooo0000o`000014ooooo`00@Oooool5o`0001Oooooo00<00000ooooooooool01Oooool3o`0000_o
oooo1?l0000Wooooo`Co00003?ooool3o`00023ooooo1Ol00014ooooo`00@Oooool4o`00017ooooo
00<00000ooooooooool02oooool3o`0000gooooo1?l0000Eooooo`;o00003_ooool4o`0000kooooo
0_l0000Cooooo`0300000?oooooooooo00_ooooo1?l00014ooooo`00@Oooool3o`000003ooooo`00
003ooooo00kooooo00<00000ooooooooool01oooool01000003oooooooooooooool3o`00013ooooo
0ol0000Dooooo`0300000?l00000000000_ooooo1?l0000@ooooo`?o00002Oooool00`00003ooooo
ooooo`07ooooo`0300000?oooooooooo00_ooooo0ol00014ooooo`00@Oooool4o`00000300000?oo
oooooooo00cooooo00<00000ooooooooool02?ooool00`00003oooooooooo`03o`0001;ooooo1?l0
000@ooooo`8000000oooool00`00003oooooooooo`07ooooo`Co00004_ooool3o`0000Oooooo00<0
0000ooooooooool02Oooool00`00003oooooooooo`09ooooo`Co0000A?ooool0047ooooo1Ol0000J
ooooo`0400000?oooooo0000o`0001Cooooo1?l0000Looooo`Co00005Oooool3o`0000Gooooo00<0
0000ooooooooool05Oooool5o`0004Cooooo0011ooooo`;o000000Coooooo`000?l0003o00002_oo
ool00`00003oooooooooo`0=ooooo`?o00005_ooool4o`0000[ooooo0P000009ooooo`0400000?oo
ooooooooooooo`Co00005oooool3o`0001Cooooo00<00000ooooooooool01?ooool3o`000003oooo
ool0003o000004Cooooo0011ooooo`;o00000_ooool3o`0000Sooooo00<00000ooooooooool03Ooo
ool3o`0001Sooooo1?l00008ooooo`0300000?oooooooooo00[ooooo00<00000o`000?l000000_l0
000Jooooo`?o00005?ooool01000003oooooooooooooool4o`0000;ooooo0_l00014ooooo`00@Ooo
ool2o`0000;ooooo00@00000o`000?l0003o00001_ooool00`00003oooooooooo`0=ooooo`?o0000
0_ooool00`00003oooooooooo`0Fooooo`?o00001_ooool00`00003oooooooooo`0;ooooo`Co0000
7?ooool2o`000003ooooo`00003ooooo01;ooooo00<00000ooooool000000ol00003ooooo`;o0000
A?ooool0047ooooo0_l00002ooooo`0300000?oooooo000000?o00004oooool3o`0000?ooooo00<0
0000ooooooooool05oooool4o`00013ooooo1?l0000Nooooo`?o00005Oooool3o`0000Gooooo0_l0
0014ooooo`00@Oooool2o`0000;ooooo00<00000ooooooooool01?l000000`00003oooooooooo`0>
ooooo`?o00001Oooool00`00003oooooooooo`0Gooooo`Co000000<00000ooooooooool02oooool4
o`0000?ooooo0P00000Kooooo`?o00004oooool3o`00008000001?ooool2o`0004Cooooo0011oooo
o`;o00001oooool3o`00013ooooo0_l0000Rooooo`Co00002oooool3o`0000Oooooo00<00000oooo
ooooool06Oooool3o`00013ooooo1?l00003ooooo`0400000?ooooooooooooooo`;o0000A?ooool0
047ooooo0_l00007ooooo`0400000?l0003o0000o`0000kooooo0ol0000Sooooo`Co00002?ooool4
o`0002Gooooo0ol0000>ooooo`Co00002?ooool2o`0004Cooooo0011ooooo`;o00000_ooool00`00
003oooooooooo`04ooooo`?o00003?ooool3o`0000[ooooo00<00000ooooooooool04oooool00`00
003oooooooooo`03ooooo`?o00001_ooool4o`0000cooooo00<00000ooooooooool04oooool00`00
003oooooooooo`02ooooo`?o00003?ooool3o`0000Wooooo0ol00014ooooo`00@Oooool2o`0000;o
oooo0`000005ooooo`Co00002Oooool3o`0000_ooooo00<00000ooooooooool04_ooool00`00003o
ooooooooo`05ooooo`Co00000_ooool4o`0000oooooo00<00000ooooooooool04Oooool00`00003o
ooooooooo`04ooooo`?o00002_ooool3o`0000_ooooo0_l00014ooooo`00@Oooool2o`0000;ooooo
00<00000ooooooooool01_ooool4o`0000Oooooo0ol0000=ooooo`0300000?oooooooooo013ooooo
00<00000ooooooooool01oooool8o`00017ooooo00<00000ooooooooool03oooool00`00003ooooo
ooooo`06ooooo`;o00002Oooool3o`0000cooooo0_l00014ooooo`00@Oooool2o`0000;ooooo0P00
0009ooooo`?o00001_ooool2o`0002gooooo1?l0000^ooooo`?o00001_ooool4o`0000cooooo00<0
0000o`000?l00000A?ooool0047ooooo0ol000001?ooool00000ooooo`000009ooooo`?o00001?oo
ool3o`00017ooooo00<00000ooooooooool02Oooool2000000oooooo0_l0000Gooooo`8000002ooo
ool00`00003oooooooooo`09ooooo`?o00001?ooool4o`0000cooooo00@00000ooooool0003o0000
A?ooool004;ooooo0_l000000oooool00000ooooo`0;ooooo`?o00000_ooool3o`0001?ooooo00<0
0000ooooooooool01oooool00`00003oooooooooo`0>ooooo`Co00006?ooool00`00003ooooooooo
o`07ooooo`0300000?oooooooooo00_ooooo0ol00002ooooo`?o00004?ooool2o`0004Cooooo0012
ooooo`;o00003oooool6o`0001Gooooo00<00000ooooooooool05_ooool6o`00023ooooo00<00000
ooooooooool03Oooool6o`0000gooooo00@00000oooooooooooooooo0_l00014ooooo`00@_ooool2
o`0000Gooooo00<00000ooooooooool02?ooool4o`0001cooooo00<00000ooooooooool03oooool3
o`0000;ooooo0ol0000Iooooo`0300000?oooooooooo01Cooooo1?l0000=ooooo`0300000?oooooo
oooo00;ooooo0_l00014ooooo`00@_ooool2o`00000300000?oooooooooo00?ooooo00<00000oooo
ooooool02?ooool4o`0001[ooooo00<00000ooooooooool03oooool3o`0000Cooooo0ol0000Ioooo
o`0300000?oooooooooo01;ooooo1?l0000=ooooo`0300000?oooooooooo00?ooooo0_l00014oooo
o`00@_ooool2o`00000300000?oooooooooo00Cooooo00<00000ooooooooool01oooool6o`0001Go
oooo00?o0000ooooo`0000004_ooool2o`0000Kooooo0ol0000Iooooo`0300000?oooooo000000oo
oooo1_l0000Cooooo`;o0000A?ooool004;ooooo0_l000000`00003oooooooooo`0>ooooo`;o0000
00?oooooo`000?l000000_l0000Dooooo`0300000?l000000000017ooooo0ol00007ooooo`?o0000
6Oooool00`00003o00000000000=ooooo`Co000000?oooooo`000?l000004oooool2o`0004Cooooo
0012ooooo`;o000000<00000ooooooooool01oooool00`00003oooooooooo`04ooooo`;o00000ooo
ool3o`0001;ooooo00D00000oooooooooooooooo0000000?ooooo`?o00002Oooool3o`0001Kooooo
0P000003ooooo`0300000?oooooooooo00Wooooo0ol00003ooooo`;o00002oooool00`00003ooooo
ooooo`05ooooo`;o0000A?ooool004;ooooo0_l0000:ooooo`0300000?oooooooooo00Cooooo0_l0
0004ooooo`Co00003oooool00`00003oooooooooo`0Aooooo`?o00002oooool3o`0002Cooooo1?l0
0004ooooo`;o00002_ooool00`00003oooooooooo`06ooooo`;o0000A?ooool004;ooooo0_l0000;
ooooo`0300000?oooooooooo00?ooooo0_l00005ooooo`Co00005_ooool00`00003oooooooooo`08
ooooo`?o00003Oooool2o`0001;ooooo0P000008ooooo`8000001Oooool4o`0000Gooooo0_l00009
ooooo`0300000?oooooooooo00Oooooo0_l00014ooooo`00@_ooool2o`00000300000?oooooooooo
00kooooo0_l00007ooooo`Co00002Oooool2000000[ooooo00<00000ooooooooool01oooool2o`00
00kooooo0ol0000@ooooo`0300000?oooooooooo00[ooooo00<00000ooooooooool01?l00007oooo
o`;o00004oooool2o`0004Cooooo0012ooooo`;o000000<00000ooooooooool03_ooool2o`0000So
oooo1?l00007ooooo`0300000?oooooooooo00_ooooo00<00000ooooooooool01Oooool3o`0000oo
oooo0ol0000>ooooo`0300000?oooooooooo00cooooo00<00000o`000?l000000_l00008ooooo`;o
00004oooool2o`0004Cooooo0012ooooo`;o00003_ooool00`00003oooooooooo`02o`0000[ooooo
0ol0000Kooooo`?o00004Oooool3o`0001cooooo0ol0000:ooooo`;o00001oooool00`00003ooooo
ooooo`09ooooo`;o0000A?ooool004;ooooo0ol0000>ooooo`0400000?oooooo0000o`0000_ooooo
1?l000000oooool00000ooooo`0Booooo`0300000?oooooooooo00?o00004oooool3o`0000Sooooo
0P00000?ooooo`Co00000P000009ooooo`;o00001_ooool00`00003oooooooooo`09ooooo`?o0000
A?ooool004;ooooo1?l0000>ooooo`0300000?l0003o000000cooooo1?l0000Eooooo`0400000?l0
003o0000o`0001Gooooo0ol00006ooooo`0300000?oooooooooo00kooooo1?l00003ooooo`030000
0?oooooooooo00Kooooo0_l00005ooooo`0300000?oooooooooo00Wooooo1?l00014ooooo`00@_oo
ool5o`0000kooooo0_l0000>ooooo`Co00004oooool3o`0001Oooooo0ol0000Dooooo`Co00001_oo
ool00`00003oooooooooo`05ooooo`;o00004?ooool5o`0004Cooooo0013ooooo`Go00003Oooool2
o`0000oooooo1?l0000Booooo`;o00000_ooool00`00003oooooooooo`0Dooooo`?o000000?ooooo
00000?ooool03oooool4o`0000oooooo0_l00003ooooo`0300000?oooooooooo00Wooooo1Ol00015
ooooo`00A?ooool5o`0000cooooo0ol0000:ooooo`0300000?oooooooooo00?ooooo0ol0000@oooo
o`?o00000oooool00`00003oooooooooo`0Dooooo`;o000000<00000ooooooooool03_ooool3o`00
00_ooooo00<00000ooooooooool00oooool2o`0000;ooooo00<00000ooooooooool02?ooool6o`00
04Kooooo0015ooooo`Go00003?ooool2o`0000Wooooo00<00000ooooooooool01Oooool4o`0000go
oooo0ol00005ooooo`0300000?oooooooooo01?ooooo0ol0000>ooooo`Co00003Oooool00`00003o
ooooooooo`02ooooo`;o000000?ooooo00000?ooool02Oooool6o`0004Oooooo0016ooooo`Ko0000
2_ooool2o`00000300000?oooooooooo00Gooooo00<00000ooooooooool01oooool4o`0000_ooooo
0ol0000Mooooo`?o00003?ooool4o`0000oooooo00@00000oooooooooooooooo0_l0000;ooooo`Ko
0000B?ooool004Oooooo1_l00009ooooo`;o00005?ooool4o`0000Sooooo0ol0000:ooooo`030000
0?oooooooooo00gooooo0P000003ooooo`?o00002Oooool4o`0001Gooooo0_l0000:ooooo`Ko0000
BOooool004Sooooo1_l00008ooooo`;o00000_ooool01?l0003ooooo00000000000?ooooo`Co0000
1oooool2o`0000cooooo00<00000ooooooooool02oooool00`00003oooooooooo`04ooooo`?o0000
1oooool4o`0001Gooooo0ol00008ooooo`Oo0000B_ooool004Wooooo1_l00007ooooo`;o00000ooo
ool00ol0003oooooooooo`0Aooooo`?o00001Oooool3o`0000gooooo00<00000ooooooooool04_oo
ool3o`0000Gooooo0ol0000Hooooo`;o00001oooool4o`000003ooooool0003o000004_ooooo001:
ooooo`Ko00001_ooool2o`0000?ooooo0P00000Cooooo`Co00000_ooool3o`00017ooooo00<00000
ooooooooool01?ooool00`00003oooooooooo`09ooooo`?o00000_ooool4o`0001Sooooo00<00000
o`000?l000001_ooool3o`0000;ooooo0ol0001;ooooo`00Boooool7o`0000Cooooo0_l00003oooo
o`0300000?ooool0000001?ooooo1ol0000Cooooo`0300000?oooooooooo00;ooooo00<00000oooo
ooooool02oooool7o`0001Sooooo00@00000ooooool0003o00001Oooool3o`0000;ooooo0ol0001<
ooooo`00C?ooool7o`0000?ooooo0_l00003ooooo`0300000?oooooooooo01Gooooo1?l0000Eoooo
o`0400000?oooooooooo000000oooooo1?l0000Looooo`;o00001?ooool3o`0000;ooooo0ol0001=
ooooo`00COooool3o`000004ooooool0003o0000o`0000;ooooo0_l00008ooooo`8000004_ooool2
o`0001Oooooo0P00000Aooooo`;o00005oooool2000000Cooooo0_l00002ooooo`Co00000_ooool3
o`0004kooooo001>ooooo`;o00000_ooool3o`000003ooooool0003o000000[ooooo00<00000oooo
ooooool03oooool3o`0001Gooooo00@00000ooooooooool000003oooool3o`0001Kooooo00<00000
ooooooooool01?ooool2o`000003ooooool0003o000000;o00000_ooool3o`0004oooooo001>oooo
o`?o00000_ooool5o`0000_ooooo00<00000ooooooooool03_ooool4o`0001?ooooo00<00000oooo
ooooool00_ooool00`00003oooooooooo`0;ooooo`Co00007Oooool5o`0000?ooooo0ol0001@oooo
o`00Coooool3o`0000;ooooo1?l00002ooooo`0300000?oooooooooo00Sooooo0P00000=ooooo`Go
00009?ooool5o`0001?ooooo00<00000ooooooooool01oooool4o`0000?ooooo0ol0001Aooooo`00
D?ooool3o`0000;ooooo1?l000000oooool00000ooooo`0;ooooo`0300000?oooooooooo00[ooooo
0_l000001?oooooo0000o`000?l0000>ooooo`8000002?ooool2000000Sooooo0ol000000ooooooo
0000o`00000Booooo`0300000?oooooooooo00Oooooo1?l00004ooooo`;o0000D_ooool0057ooooo
0ol00002ooooo`Co000000<00000ooooooooool02oooool00`00003oooooooooo`09ooooo`;o0000
0_ooool3o`0000cooooo00<00000ooooooooool02_ooool00`00003oooooooooo`04ooooo`?o0000
0_ooool2o`00017ooooo00<00000ooooooooool01oooool4o`0000Cooooo0ol0001Booooo`00D_oo
ool3o`000003ooooool0003o000000Co00006?ooool2o`0000?ooooo0ol0000Iooooo`0300000?oo
oooooooo00;ooooo0ol00003ooooo`;o00006Oooool6o`0000?ooooo0ol0001Cooooo`00Doooool3
o`000003ooooool0003o000000Co00003Oooool2000000Sooooo0_l00004ooooo`?o00007?ooool3
o`0000Cooooo0_l0000=ooooo`8000002Oooool6o`0000?ooooo0ol0001Dooooo`00E?ooool3o`00
0003ooooool0003o000000Co00003_ooool00`00003oooooooooo`05ooooo`;o00001Oooool2o`00
00Kooooo0P00000Booooo`0400000?oooooo0000o`0000Gooooo0_l0000<ooooo`0300000?oooooo
oooo00Oooooo1ol000000`00003oooooooooo`03o`0005Gooooo001Eooooo`?o000000?oooooo`00
0?l000001Ol0000=ooooo`0300000?oooooooooo00Cooooo0_l00005ooooo`?o00001?ooool00`00
003oooooooooo`0Cooooo`?o00001Oooool2o`0001Gooooo1ol000000oooool00000ooooo`03o`00
05Kooooo001Fooooo`?o000000?oooooo`000?l000001Ol0000Cooooo`;o00001_ooool3o`0001So
oooo0ol00006ooooo`;o00002Oooool00`00003oooooooooo`07ooooo`Co000000Coooooo`000?l0
003o00000_ooool01000003o0000o`000?l0001Gooooo`00Eoooool3o`00000500000?l0003o0000
o`000?ooool01?l0000<ooooo`<000000_ooool2o`0000Oooooo0ol0000Fooooo`?o00001oooool2
o`0000Sooooo00<00000ooooooooool01oooool4o`000004ooooool0003o0000o`0000;ooooo1?l0
001Hooooo`00F?ooool7o`000003ooooool0003o000000;o00003_ooool01000003oooooo`000?l0
0008ooooo`?o00005?ooool3o`0000Cooooo0P000002ooooo`;o00001oooool00`00003ooooooooo
o`06ooooo`Co00000_ooool3o`0000;ooooo1?l0001Iooooo`00FOooool7o`0000;ooooo0ol0000?
ooooo`?o00001_ooool00`00003oooooo`000002o`0001;ooooo0ol00007ooooo`0400000?oooooo
0000o`0000oooooo1?l00003ooooo`;o00000_ooool3o`0005_ooooo001Kooooo`Ko00000_ooool4
o`0000kooooo0_l00009ooooo`?o00004?ooool3o`0000[ooooo0_l00003ooooo`8000002?ooool4
o`0000Cooooo0ol000001?oooooo0000o`000?l0001Looooo`00G?ooool6o`0000;ooooo1?l0000=
ooooo`;o00000oooool00`00003oooooooooo`04ooooo`?o00003_ooool3o`0000_ooooo0_l00002
ooooo`0300000?oooooooooo00Oooooo1?l00004ooooo`Oo0000GOooool005gooooo1_l00003oooo
o`Co00002oooool2o`00000300000?ooool0000000Sooooo0ol0000<ooooo`?o00003?ooool2o`00
00_ooooo0ol00005ooooo`Oo0000G_ooool005kooooo1_l00003ooooo`Co00002_ooool2o`000003
ooooo`000000000000Wooooo0_l0000<ooooo`;o00003Oooool2o`00000300000?oooooooooo00Ko
oooo1?l00005ooooo`Ko0000H?ooool005oooooo1Ol00005ooooo`?o00002Oooool2o`000004oooo
o`00003ooooo000000Sooooo0ol0000:ooooo`?o00003Oooool2o`00000300000?oooooooooo00Go
oooo1?l00005ooooo`Ko0000HOooool0063ooooo1Ol000000`00003oooooooooo`02ooooo`Co0000
1oooool2o`000005ooooo`00003oooooooooo`0000002?ooool3o`0000Sooooo0ol0000>ooooo`;o
000000<00000ooooooooool00oooool4o`0000Kooooo1_l0001Rooooo`00H_ooool4o`0000030000
0?oooooooooo00;ooooo1?l00006ooooo`;o000000?ooooo00000?ooool02oooool3o`0000Kooooo
0ol0000<ooooo`0300000?oooooooooo00;o00001Oooool4o`0000Kooooo1_l0001Sooooo`00Hooo
ool4o`0000Kooooo1?l00004ooooo`;o00001_ooool00`00003oooooooooo`06ooooo`?o00001?oo
ool3o`0000cooooo00@00000oooooooooooooooo0_l00003ooooo`Co00001oooool6o`0006Cooooo
001Tooooo`Co000000?ooooo00000?ooool00oooool4o`0000?ooooo0_l00007ooooo`0300000?oo
oooooooo00Kooooo0ol00002ooooo`?o00003?ooool00`00003oooooooooo`02ooooo`;o00000_oo
ool4o`0000Sooooo1?l0001Vooooo`00IOooool4o`000003ooooo`00003ooooo00Cooooo0ol00002
ooooo`;o000000?ooooo00000?ooool01Oooool00`00003oooooooooo`06ooooo`Ko00004_ooool6
o`0000Wooooo1?l0001Wooooo`00I_ooool4o`000003ooooo`00003ooooo00Cooooo1_l000000ooo
ool00000ooooo`0?ooooo`Co00002oooool00`00003oooooooooo`05ooooo`Go00002Oooool4o`00
06Sooooo001Xooooo`?o00001oooool5o`000003ooooo`00003ooooo00Sooooo00<00000oooooooo
ool01Oooool2o`0000_ooooo00<00000ooooooooool01_ooool3o`0000[ooooo1?l0001Yooooo`00
JOooool3o`0000;ooooo00<00000ooooooooool00oooool3o`000003ooooo`00003ooooo00Wooooo
00<00000ooooooooool01?ooool2o`0000[ooooo00<00000ooooooooool01oooool2o`0000030000
0?oooooooooo00Gooooo0P000003o`0006_ooooo001Zooooo`?o00000_ooool00`00003ooooooooo
o`03ooooo`;o00003Oooool00`00003oooooooooo`03ooooo`;o00004oooool3o`0000Oooooo00<0
0000ooooool000000_l0001/ooooo`00Joooool3o`0000;ooooo00<00000ooooooooool00_ooool3
o`0001;ooooo0_l00007ooooo`8000002Oooool3o`0000Wooooo0ol0001]ooooo`00K?ooool4o`00
00?ooooo00<00000ooooooooool00ol0000>ooooo`0300000?oooooooooo00;o00001_ooool00`00
003oooooooooo`08ooooo`?o00000_ooool01P00003oooooooooooooool00000ooooo`Co0000K_oo
ool006gooooo1?l00003ooooo`0300000?oooooooooo00?o00003_ooool01000003oooooo`000?l0
0005ooooo`0300000?oooooooooo00Sooooo0ol00003ooooo`0500000?oooooooooo00000?ooool0
1?l0001_ooooo`00Koooool4o`0000;ooooo00<00000ooooo`0000000ol0000>ooooo`0300000?l0
003o000000oooooo0ol00004ooooo`0300000?ooool0000000Co0000LOooool0073ooooo1?l00003
ooooo`0300000?oooooo000000;o00003_ooool2o`0000?ooooo00<00000ooooooooool02Oooool2
o`0000Cooooo0P0000000ooooooo0000o`000002o`0007;ooooo001booooo`?o00000_ooool20000
0004ooooool0003o0000o`0000gooooo0_l000000`00003ooooo0000000;ooooo`?o00000oooool0
0`00003oooooooooo`03o`0007Cooooo001cooooo`Co00000_ooool00`00003oooooo`000002o`00
00cooooo0_l000000oooool00000ooooo`0:ooooo`?o00000oooool00`00003oooooo`000003o`00
07Gooooo001dooooo`Co00001?ooool3o`0000_ooooo0_l000000oooool00000ooooo`09ooooo`?o
00001Oooool4o`0007Kooooo001fooooo`Co00000oooool3o`0000[ooooo0_l000000oooool00000
ooooo`08ooooo`?o00000oooool00`00003o0000o`000002o`0007Sooooo001gooooo`Co000000?o
oooo0000000000000ol00009ooooo`;o000000?ooooo00000?ooool01oooool3o`0000?ooooo00<0
0000o`000?l000000_l0001iooooo`00NOooool4o`000003ooooo`00003o000000;o00002?ooool3
o`0000Sooooo0ol00003ooooo`Co0000Noooool007[ooooo1?l00002ooooo`;o00002Oooool2o`00
00Sooooo0_l00003ooooo`Co0000O?ooool007cooooo0ol000001?oooooo0000o`000?l00008oooo
o`;o00001oooool3o`000003ooooo`00003o000000;o0000O_ooool007gooooo1ol00007ooooo`;o
00001_ooool3o`000003ooooool0003o000000;o0000Ooooool007kooooo1ol00006ooooo`;o0000
1Oooool3o`000003ooooool0003o000000;o0000P?ooool0083ooooo1_l00005ooooo`;o00001?oo
ool7o`0008;ooooo0021ooooo`Ko00001?ooool2o`0000?ooooo1ol00023ooooo`00Poooool5o`00
00?ooooo0_l00003ooooo`Go0000QOooool008Cooooo1Ol00002ooooo`;o00000_ooool5o`0008Ko
oooo0026ooooo`Co000000Coooooo`000?l0003ooooo1?l00028ooooo`00Qoooool:o`0008Wooooo
0028ooooo`So0000R_ooool008[ooooo1?l0002<ooooo`00Roooool2o`0008gooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_o
oooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.44811 .5517 m
.361 .61305 L
s
.44811 .5517 m
.54917 .61965 L
s
.36161 .46904 m
.44811 .5517 L
s
.54895 .47641 m
.44811 .5517 L
s
.54895 .47641 m
.65064 .54402 L
s
.46304 .3932 m
.54895 .47641 L
s
.60711 .38704 m
.54895 .47641 L
s
.54917 .61965 m
.60807 .67714 L
s
.54917 .61965 m
.46271 .68207 L
s
.65064 .54402 m
.54917 .61965 L
s
.65064 .54402 m
.71116 .60039 L
s
.71021 .45491 m
.65064 .54402 L
s
.36161 .46904 m
.27299 .52988 L
s
.33911 .37576 m
.36161 .46904 L
s
.46304 .3932 m
.36161 .46904 L
s
.44187 .29882 m
.46304 .3932 L
s
.52063 .30233 m
.46304 .3932 L
s
.361 .61305 m
.33766 .66809 L
s
.361 .61305 m
.46271 .68207 L
s
.27299 .52988 m
.361 .61305 L
s
.60711 .38704 m
.71021 .45491 L
s
.52063 .30233 m
.60711 .38704 L
s
.58777 .29217 m
.60711 .38704 L
s
.46271 .68207 m
.52091 .74117 L
s
.46271 .68207 m
.44107 .73866 L
s
.71021 .45491 m
.77234 .51051 L
s
.69216 .36044 m
.71021 .45491 L
s
.27299 .52988 m
.2479 .58379 L
s
.24904 .43637 m
.27299 .52988 L
s
.5 .20569 m
.52063 .30233 L
s
.33911 .37576 m
.24904 .43637 L
s
.39606 .28356 m
.33911 .37576 L
s
.44187 .29882 m
.33911 .37576 L
s
.5 .20569 m
.44187 .29882 L
s
.60807 .67714 m
.58897 .7339 L
s
.60807 .67714 m
.52091 .74117 L
s
.71116 .60039 m
.60807 .67714 L
s
.71116 .60039 m
.69391 .65581 L
s
.77234 .51051 m
.71116 .60039 L
s
.58777 .29217 m
.69216 .36044 L
s
.5 .20569 m
.58777 .29217 L
s
.33766 .66809 m
.39462 .72773 L
s
.33766 .66809 m
.44107 .73866 L
s
.2479 .58379 m
.33766 .66809 L
s
.69216 .36044 m
.75484 .4153 L
s
.6046 .27394 m
.69216 .36044 L
s
.39606 .28356 m
.30562 .34381 L
s
.5 .20569 m
.39606 .28356 L
s
.0085 w
[ ] 0 setdash
.24904 .43637 m
.22318 .48931 L
s
.30562 .34381 m
.24904 .43637 L
s
.5 .20569 m
.55971 .25816 L
s
.5 .20569 m
.47871 .25444 L
s
.5 .20569 m
.41065 .26512 L
s
.5 .20569 m
.6046 .27394 L
s
.0035 w
[ .01 .012 ] 0 setdash
.52091 .74117 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.77234 .51051 m
.75602 .56491 L
s
.75484 .4153 m
.77234 .51051 L
s
.0035 w
[ .01 .012 ] 0 setdash
.44107 .73866 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.2479 .58379 m
.30382 .64248 L
s
.22318 .48931 m
.2479 .58379 L
s
.6046 .27394 m
.66632 .32779 L
s
.58897 .7339 m
.5 .79975 L
s
.69391 .65581 m
.58897 .7339 L
s
.69391 .65581 m
.60605 .72084 L
s
.75602 .56491 m
.69391 .65581 L
s
.30562 .34381 m
.28051 .39564 L
s
.41065 .26512 m
.30562 .34381 L
s
.41065 .26512 m
.38746 .31554 L
s
.39462 .72773 m
.5 .79975 L
s
.30382 .64248 m
.39462 .72773 L
s
.75484 .4153 m
.73797 .46868 L
s
.66632 .32779 m
.75484 .4153 L
s
.55971 .25816 m
.53919 .30868 L
s
.55971 .25816 m
.66632 .32779 L
s
.22318 .48931 m
.27948 .5473 L
s
.28051 .39564 m
.22318 .48931 L
s
.47871 .25444 m
.53919 .30868 L
s
.47871 .25444 m
.38746 .31554 L
s
.40941 .71452 m
.5 .79975 L
s
.47841 .70687 m
.5 .79975 L
s
.56055 .70953 m
.5 .79975 L
s
.60605 .72084 m
.5 .79975 L
s
.75602 .56491 m
.66787 .62963 L
s
.73797 .46868 m
.75602 .56491 L
s
.66787 .62963 m
.60605 .72084 L
s
.30382 .64248 m
.40941 .71452 L
s
.27948 .5473 m
.30382 .64248 L
s
.66632 .32779 m
.64767 .3799 L
s
.3864 .6198 m
.40941 .71452 L
s
.28051 .39564 m
.3384 .45277 L
s
.38746 .31554 m
.28051 .39564 L
s
.38746 .31554 m
.44716 .37141 L
s
.53956 .61431 m
.56055 .70953 L
s
.66787 .62963 m
.56055 .70953 L
s
.64837 .53319 m
.66787 .62963 L
s
.3864 .6198 m
.47841 .70687 L
s
.53956 .61431 m
.47841 .70687 L
s
.73797 .46868 m
.64837 .53319 L
s
.64767 .3799 m
.73797 .46868 L
s
.27948 .5473 m
.3864 .6198 L
s
.3384 .45277 m
.27948 .5473 L
s
.53919 .30868 m
.44716 .37141 L
s
.53919 .30868 m
.64767 .3799 L
s
.4469 .52558 m
.3864 .6198 L
s
.64767 .3799 m
.55639 .44382 L
s
.4469 .52558 m
.53956 .61431 L
s
.64837 .53319 m
.53956 .61431 L
s
.55639 .44382 m
.64837 .53319 L
s
.3384 .45277 m
.4469 .52558 L
s
.44716 .37141 m
.3384 .45277 L
s
.44716 .37141 m
.55639 .44382 L
s
.55639 .44382 m
.4469 .52558 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.49468 .55264 m
.39971 .61679 L
s
.49468 .55264 m
.59107 .61746 L
s
.40015 .47322 m
.49468 .55264 L
s
.59067 .47397 m
.49468 .55264 L
s
.59067 .47397 m
.68817 .5384 L
s
.49621 .39395 m
.59067 .47397 L
s
.63362 .38255 m
.59067 .47397 L
s
.40015 .47322 m
.30399 .53695 L
s
.36086 .38139 m
.40015 .47322 L
s
.49621 .39395 m
.40015 .47322 L
s
.45798 .30081 m
.49621 .39395 L
s
.53817 .30117 m
.49621 .39395 L
s
.59107 .61746 m
.63482 .67353 L
s
.59107 .61746 m
.49617 .68267 L
s
.68817 .5384 m
.59107 .61746 L
s
.39971 .61679 m
.3596 .67261 L
s
.39971 .61679 m
.49617 .68267 L
s
.30399 .53695 m
.39971 .61679 L
s
.68817 .5384 m
.73372 .59333 L
s
.73266 .44703 m
.68817 .5384 L
s
.30399 .53695 m
.26208 .59163 L
s
.26315 .44513 m
.30399 .53695 L
s
.63362 .38255 m
.73266 .44703 L
s
.53817 .30117 m
.63362 .38255 L
s
.59681 .28849 m
.63362 .38255 L
s
.49617 .68267 m
.53869 .74034 L
s
.49617 .68267 m
.4574 .74008 L
s
.36086 .38139 m
.26315 .44513 L
s
.40153 .28761 m
.36086 .38139 L
s
.45798 .30081 m
.36086 .38139 L
s
.5 .20569 m
.53817 .30117 L
s
.5 .20569 m
.45798 .30081 L
s
.73266 .44703 m
.77954 .50109 L
s
.69681 .35303 m
.73266 .44703 L
s
.63482 .67353 m
.59814 .73126 L
s
.63482 .67353 m
.53869 .74034 L
s
.73372 .59333 m
.63482 .67353 L
s
.26315 .44513 m
.21999 .49891 L
s
.30295 .35132 m
.26315 .44513 L
s
.3596 .67261 m
.40017 .73063 L
s
.3596 .67261 m
.4574 .74008 L
s
.26208 .59163 m
.3596 .67261 L
s
.0085 w
[ ] 0 setdash
.73372 .59333 m
.69862 .64987 L
s
.77954 .50109 m
.73372 .59333 L
s
.0035 w
[ .01 .012 ] 0 setdash
.59681 .28849 m
.69681 .35303 L
s
.5 .20569 m
.59681 .28849 L
s
.40153 .28761 m
.30295 .35132 L
s
.5 .20569 m
.40153 .28761 L
s
.0085 w
[ ] 0 setdash
.26208 .59163 m
.30114 .6485 L
s
.21999 .49891 m
.26208 .59163 L
s
.5 .20569 m
.54328 .25606 L
s
.5 .20569 m
.46067 .25568 L
s
.5 .20569 m
.40193 .26891 L
s
.5 .20569 m
.59963 .26982 L
s
.0035 w
[ .01 .012 ] 0 setdash
.53869 .74034 m
.5 .79975 L
s
.4574 .74008 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.69681 .35303 m
.74368 .40616 L
s
.59963 .26982 m
.69681 .35303 L
s
.30295 .35132 m
.25995 .40414 L
s
.40193 .26891 m
.30295 .35132 L
s
.59963 .26982 m
.64501 .32173 L
s
.77954 .50109 m
.74481 .55672 L
s
.74368 .40616 m
.77954 .50109 L
s
.40193 .26891 m
.36052 .32047 L
s
.59814 .73126 m
.5 .79975 L
s
.69862 .64987 m
.59814 .73126 L
s
.21999 .49891 m
.25883 .55491 L
s
.25995 .40414 m
.21999 .49891 L
s
.40017 .73063 m
.5 .79975 L
s
.30114 .6485 m
.40017 .73063 L
s
.69862 .64987 m
.60102 .71789 L
s
.74481 .55672 m
.69862 .64987 L
s
.30114 .6485 m
.40057 .71724 L
s
.25883 .55491 m
.30114 .6485 L
s
.54328 .25606 m
.50403 .30783 L
s
.54328 .25606 m
.64501 .32173 L
s
.46067 .25568 m
.50403 .30783 L
s
.46067 .25568 m
.36052 .32047 L
s
.40057 .71724 m
.5 .79975 L
s
.46011 .70776 m
.5 .79975 L
s
.54389 .70803 m
.5 .79975 L
s
.60102 .71789 m
.5 .79975 L
s
.74368 .40616 m
.70785 .46082 L
s
.64501 .32173 m
.74368 .40616 L
s
.64637 .62477 m
.60102 .71789 L
s
.35921 .62376 m
.40057 .71724 L
s
.25995 .40414 m
.29999 .45919 L
s
.36052 .32047 m
.25995 .40414 L
s
.64501 .32173 m
.60725 .37511 L
s
.74481 .55672 m
.64637 .62477 L
s
.70785 .46082 m
.74481 .55672 L
s
.36052 .32047 m
.4025 .37424 L
s
.25883 .55491 m
.35921 .62376 L
s
.29999 .45919 m
.25883 .55491 L
s
.50406 .61362 m
.54389 .70803 L
s
.64637 .62477 m
.54389 .70803 L
s
.35921 .62376 m
.46011 .70776 L
s
.50406 .61362 m
.46011 .70776 L
s
.60776 .5289 m
.64637 .62477 L
s
.50403 .30783 m
.4025 .37424 L
s
.50403 .30783 m
.60725 .37511 L
s
.40203 .52812 m
.35921 .62376 L
s
.70785 .46082 m
.60776 .5289 L
s
.60725 .37511 m
.70785 .46082 L
s
.29999 .45919 m
.40203 .52812 L
s
.4025 .37424 m
.29999 .45919 L
s
.60725 .37511 m
.50579 .44271 L
s
.4025 .37424 m
.50579 .44271 L
s
.40203 .52812 m
.50406 .61362 L
s
.60776 .5289 m
.50406 .61362 L
s
.50579 .44271 m
.60776 .5289 L
s
.50579 .44271 m
.40203 .52812 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.54139 .55205 m
.44115 .61927 L
s
.54139 .55205 m
.6305 .614 L
s
.44141 .47599 m
.54139 .55205 L
s
.62992 .47011 m
.54139 .55205 L
s
.44141 .47599 m
.34043 .54286 L
s
.38657 .38611 m
.44141 .47599 L
s
.52948 .39348 m
.44141 .47599 L
s
.44115 .61927 m
.38555 .67639 L
s
.44115 .61927 m
.52975 .68229 L
s
.34043 .54286 m
.44115 .61927 L
s
.62992 .47011 m
.7205 .53158 L
s
.52948 .39348 m
.62992 .47011 L
s
.65633 .37711 m
.62992 .47011 L
s
.34043 .54286 m
.28316 .59886 L
s
.28413 .4532 m
.34043 .54286 L
s
.47531 .30213 m
.52948 .39348 L
s
.55461 .29933 m
.52948 .39348 L
s
.6305 .614 m
.65774 .66918 L
s
.6305 .614 m
.52975 .68229 L
s
.7205 .53158 m
.6305 .614 L
s
.38657 .38611 m
.28413 .4532 L
s
.40994 .29137 m
.38657 .38611 L
s
.47531 .30213 m
.38657 .38611 L
s
.52975 .68229 m
.55535 .73903 L
s
.52975 .68229 m
.47498 .74103 L
s
.7205 .53158 m
.74952 .58561 L
s
.74839 .43841 m
.7205 .53158 L
s
.28413 .4532 m
.2253 .5084 L
s
.30627 .35877 m
.28413 .4532 L
s
.5 .20569 m
.47531 .30213 L
s
.65633 .37711 m
.74839 .43841 L
s
.55461 .29933 m
.65633 .37711 L
s
.60297 .2845 m
.65633 .37711 L
s
.5 .20569 m
.55461 .29933 L
s
.38555 .67639 m
.4087 .73332 L
s
.38555 .67639 m
.47498 .74103 L
s
.28316 .59886 m
.38555 .67639 L
s
.28316 .59886 m
.3045 .65448 L
s
.2253 .5084 m
.28316 .59886 L
s
.40994 .29137 m
.30627 .35877 L
s
.5 .20569 m
.40994 .29137 L
s
.65774 .66918 m
.60439 .7284 L
s
.65774 .66918 m
.55535 .73903 L
s
.74952 .58561 m
.65774 .66918 L
s
.0085 w
[ ] 0 setdash
.74839 .43841 m
.7783 .49149 L
s
.69551 .34551 m
.74839 .43841 L
s
.0035 w
[ .01 .012 ] 0 setdash
.60297 .2845 m
.69551 .34551 L
s
.5 .20569 m
.60297 .2845 L
s
.30627 .35877 m
.247 .41319 L
s
.39625 .27299 m
.30627 .35877 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.52547 .25466 L
s
.5 .20569 m
.44387 .25763 L
s
.5 .20569 m
.39625 .27299 L
s
.5 .20569 m
.59158 .26595 L
s
.0035 w
[ .01 .012 ] 0 setdash
.47498 .74103 m
.5 .79975 L
s
.55535 .73903 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.74952 .58561 m
.69732 .64385 L
s
.7783 .49149 m
.74952 .58561 L
s
.2253 .5084 m
.24583 .56302 L
s
.247 .41319 m
.2253 .5084 L
s
.39625 .27299 m
.33808 .32634 L
s
.4087 .73332 m
.5 .79975 L
s
.3045 .65448 m
.4087 .73332 L
s
.3045 .65448 m
.39481 .72016 L
s
.24583 .56302 m
.3045 .65448 L
s
.69551 .34551 m
.72481 .39751 L
s
.59158 .26595 m
.69551 .34551 L
s
.59158 .26595 m
.61902 .31657 L
s
.60439 .7284 m
.5 .79975 L
s
.69732 .64385 m
.60439 .7284 L
s
.7783 .49149 m
.72587 .54897 L
s
.72481 .39751 m
.7783 .49149 L
s
.247 .41319 m
.26822 .46681 L
s
.33808 .32634 m
.247 .41319 L
s
.44387 .25763 m
.46873 .30837 L
s
.44387 .25763 m
.33808 .32634 L
s
.52547 .25466 m
.46873 .30837 L
s
.52547 .25466 m
.61902 .31657 L
s
.39481 .72016 m
.5 .79975 L
s
.44309 .70915 m
.5 .79975 L
s
.52583 .70702 m
.5 .79975 L
s
.59286 .71511 m
.5 .79975 L
s
.69732 .64385 m
.59286 .71511 L
s
.72587 .54897 m
.69732 .64385 L
s
.33656 .62847 m
.39481 .72016 L
s
.24583 .56302 m
.33656 .62847 L
s
.26822 .46681 m
.24583 .56302 L
s
.33808 .32634 m
.36113 .37868 L
s
.62014 .62063 m
.59286 .71511 L
s
.72481 .39751 m
.67086 .45411 L
s
.61902 .31657 m
.72481 .39751 L
s
.61902 .31657 m
.56321 .3719 L
s
.33656 .62847 m
.44309 .70915 L
s
.46843 .61405 m
.44309 .70915 L
s
.36047 .5321 m
.33656 .62847 L
s
.46843 .61405 m
.52583 .70702 L
s
.62014 .62063 m
.52583 .70702 L
s
.72587 .54897 m
.62014 .62063 L
s
.67086 .45411 m
.72587 .54897 L
s
.26822 .46681 m
.36047 .5321 L
s
.36113 .37868 m
.26822 .46681 L
s
.46873 .30837 m
.36113 .37868 L
s
.46873 .30837 m
.56321 .3719 L
s
.56351 .52603 m
.62014 .62063 L
s
.36113 .37868 m
.455 .44341 L
s
.36047 .5321 m
.46843 .61405 L
s
.56351 .52603 m
.46843 .61405 L
s
.67086 .45411 m
.56351 .52603 L
s
.56321 .3719 m
.67086 .45411 L
s
.455 .44341 m
.36047 .5321 L
s
.56321 .3719 m
.455 .44341 L
s
.455 .44341 m
.56351 .52603 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0035 w
[ .01 .012 ] 0 setdash
.48425 .47729 m
.38124 .54747 L
s
.48425 .47729 m
.58699 .54993 L
s
.41549 .3898 m
.48425 .47729 L
s
.56194 .39178 m
.48425 .47729 L
s
.58699 .54993 m
.48418 .62043 L
s
.58699 .54993 m
.66635 .60935 L
s
.66561 .46491 m
.58699 .54993 L
s
.38124 .54747 m
.31043 .60528 L
s
.38124 .54747 m
.48418 .62043 L
s
.31127 .46037 m
.38124 .54747 L
s
.48418 .62043 m
.41474 .67935 L
s
.48418 .62043 m
.56249 .68093 L
s
.56194 .39178 m
.66561 .46491 L
s
.49336 .30275 m
.56194 .39178 L
s
.56945 .29687 m
.56194 .39178 L
s
.66561 .46491 m
.74662 .52373 L
s
.67454 .37088 m
.66561 .46491 L
s
.41549 .3898 m
.31127 .46037 L
s
.42102 .29473 m
.41549 .3898 L
s
.49336 .30275 m
.41549 .3898 L
s
.31127 .46037 m
.23877 .5175 L
s
.31539 .36595 m
.31127 .46037 L
s
.66635 .60935 m
.67612 .66419 L
s
.66635 .60935 m
.56249 .68093 L
s
.74662 .52373 m
.66635 .60935 L
s
.56249 .68093 m
.5704 .73726 L
s
.56249 .68093 m
.49327 .74147 L
s
.31043 .60528 m
.3137 .66023 L
s
.31043 .60528 m
.41474 .67935 L
s
.23877 .5175 m
.31043 .60528 L
s
.5 .20569 m
.49336 .30275 L
s
.41474 .67935 m
.41993 .73573 L
s
.41474 .67935 m
.49327 .74147 L
s
.56945 .29687 m
.67454 .37088 L
s
.5 .20569 m
.56945 .29687 L
s
.74662 .52373 m
.75796 .57745 L
s
.75679 .4293 m
.74662 .52373 L
s
.67454 .37088 m
.75679 .4293 L
s
.60603 .28031 m
.67454 .37088 L
s
.42102 .29473 m
.31539 .36595 L
s
.5 .20569 m
.42102 .29473 L
s
.31539 .36595 m
.24194 .42252 L
s
.39375 .27721 m
.31539 .36595 L
s
.0085 w
[ ] 0 setdash
.23877 .5175 m
.24075 .57138 L
s
.24194 .42252 m
.23877 .5175 L
s
.0035 w
[ .01 .012 ] 0 setdash
.49327 .74147 m
.5 .79975 L
s
.5 .20569 m
.60603 .28031 L
s
.0085 w
[ ] 0 setdash
.5 .20569 m
.50686 .254 L
s
.5 .20569 m
.42886 .26022 L
s
.5 .20569 m
.39375 .27721 L
s
.5 .20569 m
.58068 .26246 L
s
.0035 w
[ .01 .012 ] 0 setdash
.67612 .66419 m
.5704 .73726 L
s
.0085 w
[ ] 0 setdash
.67612 .66419 m
.6075 .7254 L
s
.75796 .57745 m
.67612 .66419 L
s
.0035 w
[ .01 .012 ] 0 setdash
.60603 .28031 m
.6882 .33813 L
s
.0085 w
[ ] 0 setdash
.39375 .27721 m
.32082 .33297 L
s
.0035 w
[ .01 .012 ] 0 setdash
.5704 .73726 m
.5 .79975 L
s
.3137 .66023 m
.41993 .73573 L
s
.0085 w
[ ] 0 setdash
.3137 .66023 m
.39228 .72318 L
s
.24075 .57138 m
.3137 .66023 L
s
.75679 .4293 m
.76847 .48201 L
s
.6882 .33813 m
.75679 .4293 L
s
.0035 w
[ .01 .012 ] 0 setdash
.41993 .73573 m
.5 .79975 L
s
.0085 w
[ ] 0 setdash
.75796 .57745 m
.68995 .63792 L
s
.76847 .48201 m
.75796 .57745 L
s
.24194 .42252 m
.24401 .47537 L
s
.32082 .33297 m
.24194 .42252 L
s
.58068 .26246 m
.58915 .31248 L
s
.58068 .26246 m
.6882 .33813 L
s
.24075 .57138 m
.31915 .63378 L
s
.24401 .47537 m
.24075 .57138 L
s
.6882 .33813 m
.69871 .38965 L
s
.42886 .26022 m
.43447 .31027 L
s
.42886 .26022 m
.32082 .33297 L
s
.6075 .7254 m
.5 .79975 L
s
.68995 .63792 m
.6075 .7254 L
s
.39228 .72318 m
.5 .79975 L
s
.31915 .63378 m
.39228 .72318 L
s
.32082 .33297 m
.3244 .38457 L
s
.42786 .71101 m
.5 .79975 L
s
.50695 .70655 m
.5 .79975 L
s
.58181 .71261 m
.5 .79975 L
s
.50686 .254 m
.43447 .31027 L
s
.50686 .254 m
.58915 .31248 L
s
.76847 .48201 m
.69965 .54192 L
s
.69871 .38965 m
.76847 .48201 L
s
.68995 .63792 m
.58181 .71261 L
s
.69965 .54192 m
.68995 .63792 L
s
.58999 .61735 m
.58181 .71261 L
s
.31915 .63378 m
.42786 .71101 L
s
.32357 .53738 m
.31915 .63378 L
s
.24401 .47537 m
.32357 .53738 L
s
.3244 .38457 m
.24401 .47537 L
s
.43385 .61558 m
.42786 .71101 L
s
.58915 .31248 m
.51702 .37039 L
s
.58915 .31248 m
.69871 .38965 L
s
.43385 .61558 m
.50695 .70655 L
s
.58999 .61735 m
.50695 .70655 L
s
.69871 .38965 m
.62813 .44879 L
s
.43447 .31027 m
.3244 .38457 L
s
.43447 .31027 m
.51702 .37039 L
s
.3244 .38457 m
.40575 .4459 L
s
.69965 .54192 m
.58999 .61735 L
s
.62813 .44879 m
.69965 .54192 L
s
.5171 .52467 m
.58999 .61735 L
s
.32357 .53738 m
.43385 .61558 L
s
.40575 .4459 m
.32357 .53738 L
s
.5171 .52467 m
.43385 .61558 L
s
.51702 .37039 m
.40575 .4459 L
s
.51702 .37039 m
.62813 .44879 L
s
.62813 .44879 m
.5171 .52467 L
s
.40575 .4459 m
.5171 .52467 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{282, 282},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.383333,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J00016R000`400?l00000o`00003ooooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolKooooo`00oooooolK
ooooo`00oooooolKooooo`00oooooolKooooo`00R_ooool4o`0008cooooo0029ooooo`Ko0000Rooo
ool008Oooooo2_l00029ooooo`00Q_ooool4o`000004ooooool0003o0000ooooo`Co0000R?ooool0
08Cooooo1Ol00002ooooo`?o00000_ooool3o`0008Oooooo0023ooooo`Go000000@00000oooooooo
oooooooo0_l00002ooooo`0300000?l0003o000000;o0000QOooool0087ooooo1Ol000000oooool0
0000ooooo`03ooooo`;o00000_ooool00`00003oooooo`000003o`0008Cooooo0020ooooo`Go0000
00?ooooo00000?ooool01?ooool2o`0000?ooooo00<00000ooooooooool01?l00022ooooo`00O_oo
ool6o`0000Oooooo00<00000o`000?l000001oooool4o`00087ooooo001mooooo`Ko00002?ooool0
0`00003o0000o`000009ooooo`Co0000Ooooool007_ooooo1_l00003ooooo`0300000?oooooooooo
00Gooooo0_l00005ooooo`0300000?oooooooooo00;ooooo1?l0001nooooo`00N_ooool6o`0000?o
oooo00<00000ooooooooool01_ooool3o`0000Gooooo00<00000ooooooooool00oooool4o`0007co
oooo001hooooo`Oo00000oooool00`00003oooooooooo`08ooooo`;o00001_ooool00`00003ooooo
ooooo`03ooooo`Co0000Noooool007Oooooo1ol0000=ooooo`0400000?oooooo0000o`0000kooooo
0ol0001jooooo`00MOooool7o`0000Cooooo00<00000ooooooooool02?ooool00`00003o0000o`00
0002o`0000kooooo1?l0001hooooo`00M?ooool7o`0000Cooooo00<00000ooooooooool02Oooool6
o`0000Kooooo00<00000ooooooooool01Oooool4o`0007Oooooo001booooo`So00001?ooool00`00
003oooooooooo`09ooooo`?o00000_ooool4o`0000Gooooo00<00000ooooooooool01_ooool4o`00
07Gooooo001aooooo`So00004?ooool3o`0000Cooooo1?l00005ooooo`0300000?oooooooooo00Ko
oooo1?l0001dooooo`00Koooool:o`0000kooooo1?l00007ooooo`?o00003Oooool5o`0007?ooooo
001^ooooo`So000000?oooooo`000?l000000oooool00`00003oooooooooo`07ooooo`Co000000?o
oooo00000?ooool01_ooool4o`0000_ooooo0_l000000ooooooo0000o`000002o`00077ooooo001/
ooooo`So00000oooool3o`000003ooooo`00003ooooo00Sooooo0ol00003ooooo`0300000?oooooo
oooo00Kooooo1?l00003ooooo`0300000?oooooooooo00Cooooo0ol000000ooooooo0000o`000002
o`00073ooooo001[ooooo`So00001Oooool2o`00000300000?oooooooooo00Oooooo0ol00004oooo
o`0300000?oooooooooo00Sooooo1?l00002ooooo`0300000?oooooooooo00Cooooo0_l00003oooo
o`Co0000K_ooool006[ooooo1ol00007ooooo`;o00002?ooool4o`0000Gooooo00<00000oooooooo
ool02Oooool4o`0000;ooooo00<00000ooooooooool00oooool2o`0000Cooooo1?l0001]ooooo`00
JOooool7o`0000Oooooo00<00000o`000?l000001oooool4o`0001Cooooo1?l00006ooooo`;o0000
1_ooool3o`0006cooooo001Wooooo`Oo00002Oooool00`00003o0000o`000006ooooo`?o00005ooo
ool4o`0000Gooooo0_l00006ooooo`0300000?l0003o000000;o0000J_ooool006Kooooo1ol00008
ooooo`80000000?oooooo`000?l000001Oooool3o`0000Sooooo00<00000ooooooooool03oooool4
o`0000?ooooo0_l00008ooooo`Co0000JOooool006Gooooo1_l00009ooooo`0400000?ooool00000
ooooo`;o00000oooool4o`0000Wooooo00<00000ooooooooool04?ooool4o`0000;ooooo0_l00008
ooooo`0300000?oooooo000000;o0000J?ooool006Cooooo1_l00009ooooo`0500000?oooooooooo
00000?ooool00ol000000ooooooo0000o`000002o`0000[ooooo00<00000ooooooooool04_ooool3
o`000004ooooool0003o0000o`0000Sooooo00<00000ooooool000000ol0001Vooooo`00H_ooool6
o`0000kooooo00<00000ooooooooool01Ol0000<ooooo`0300000?oooooooooo01;ooooo00<00000
o`000?l000001?l00009ooooo`0300000?oooooo000000?o0000IOooool0067ooooo1_l00009oooo
o`8000001oooool4o`0000cooooo00<00000ooooo`0000004oooool00`00003oooooo`000004o`00
00gooooo0ol0001Tooooo`00H?ooool5o`000003ooooo`00003ooooo00Kooooo0P000008ooooo`Co
00003?ooool01@00003oooooooooooooool0000001Kooooo1?l0000=ooooo`Co0000H_ooool005oo
oooo1Ol000000oooool00000ooooo`0@ooooo`Ko00009Oooool6o`0000Wooooo00@00000oooooooo
oooooooo1?l0001Qooooo`00GOooool5o`0000;ooooo00<00000ooooooooool01?ooool2000000So
oooo1?l00002ooooo`?o00002?ooool00`00003oooooooooo`0Fooooo`0300000?oooooo000000;o
00000_ooool4o`0000Sooooo00<00000ooooooooool00_ooool4o`0005oooooo001Looooo`Go0000
2Oooool00`00003oooooooooo`07ooooo`Co00001?ooool4o`0000Gooooo00<00000ooooooooool0
1_ooool00`00003oooooooooo`0>ooooo`0400000?l0003o0000o`0000Cooooo1?l00008ooooo`03
00000?oooooooooo00;ooooo1?l0001Nooooo`00Foooool4o`0000?ooooo00<00000ooooooooool0
1?ooool00`00003oooooooooo`06ooooo`Co00001oooool4o`0000?ooooo00<00000ooooooooool0
2?ooool00`00003oooooooooo`0=ooooo`?o00001oooool3o`0000kooooo0ol0001Mooooo`00F_oo
ool4o`0000?ooooo00<00000ooooooooool03Oooool4o`0000[ooooo0ol0000>ooooo`0300000?oo
oooooooo00_ooooo0ol00009ooooo`Co00003Oooool4o`0005_ooooo001Iooooo`?o00001?ooool0
0`00003oooooooooo`02ooooo`8000002?ooool4o`0000gooooo1?l0000Hooooo`Co00002oooool4
o`0000Kooooo00<00000ooooooooool01?ooool4o`0005[ooooo001Iooooo`;o00002Oooool00`00
003oooooooooo`07ooooo`Co00003oooool4o`0000gooooo00<00000ooooooooool01_ooool4o`00
00kooooo1?l00005ooooo`0300000?oooooooooo00Gooooo0ol0001Iooooo`00F?ooool3o`00017o
oooo1?l00005ooooo`0300000?oooooooooo00Wooooo00<00000ooooool000000ol0000;ooooo`03
00000?oooooooooo00Gooooo0ol00002ooooo`0300000?oooooooooo00cooooo1?l00005ooooo`03
00000?oooooooooo00Gooooo0ol0001Hooooo`00Eoooool4o`0000?ooooo00@00000ooooooooool0
00002Oooool4o`0000Kooooo00<00000ooooooooool02?ooool01000003oooooooooooooool4o`00
00_ooooo00<00000ooooooooool00oooool3o`0000?ooooo00<00000ooooooooool03_ooool3o`00
00gooooo0_l0001Hooooo`00E_ooool5o`0000;ooooo00@00000ooooooooool000002?ooool4o`00
00Sooooo00<00000ooooooooool03_ooool3o`0000[ooooo00<00000ooooooooool00_ooool3o`00
00?ooooo00<00000ooooooooool04?ooool4o`0000_ooooo0ol0001Gooooo`00EOooool3o`000005
ooooool0003o0000ooooo`0000000_ooool00`00003oooooooooo`06ooooo`Co00002Oooool00`00
003oooooooooo`06ooooo`0300000?oooooooooo00Kooooo1?l0000;ooooo`Co00001?ooool00`00
003oooooooooo`0Aooooo`Co00000oooool00`00003oooooooooo`04ooooo`Co0000E_ooool005Co
oooo0ol00002ooooo`;o00003?ooool3o`0001Cooooo00<00000ooooooooool01oooool4o`0000Wo
oooo1?l0000Kooooo`Co000000?ooooo00000?ooool01_ooool4o`0005Gooooo001Cooooo`?o0000
0oooool2o`00008000002?ooool4o`0001Cooooo00<00000ooooooooool02_ooool3o`0000Oooooo
0ol0000Nooooo`Co000000?ooooo00000?ooool01Oooool4o`0005Gooooo001Booooo`?o00001?oo
ool3o`0000Sooooo1?l0000=ooooo`0300000?oooooooooo00Cooooo00<00000ooooooooool03?oo
ool4o`0000Cooooo0ol000000`00003oooooooooo`05ooooo`0300000?oooooooooo01Kooooo0ol0
00000`00003oooooooooo`04ooooo`Go0000E?ooool0057ooooo0ol00004ooooo`0400000?oooooo
0000o`0000Kooooo1?l0000?ooooo`0300000?oooooooooo01Cooooo1?l00002ooooo`?o00000_oo
ool00`00003oooooooooo`04ooooo`0300000?oooooooooo01Oooooo1?l00005ooooo`;o000000Co
ooooo`000?l0003o0000Doooool0053ooooo0ol00004ooooo`80000000?oooooo`000?l000001Ooo
ool4o`00013ooooo00<00000ooooooooool00_ooool00`00003oooooooooo`0Aooooo`Ko00002_oo
ool00`00003oooooooooo`0Hooooo`Co00001?ooool3o`000004ooooool0003o0000o`0005;ooooo
001?ooooo`?o00001?ooool01000003ooooo00000?ooool2o`0000?ooooo1?l0000Booooo`050000
0?ooooooooooooooo`0000005Oooool4o`0000Kooooo00<00000ooooooooool00_ooool00`00003o
ooooooooo`0Jooooo`Co00000oooool2o`0000;ooooo0_l0001Booooo`00C_ooool3o`0000Oooooo
00@00000ooooool0003o00000_ooool4o`0001Kooooo00<00000ooooooooool04oooool6o`0000Ko
oooo00<00000ooooooooool07oooool4o`0000;ooooo0_l00002ooooo`?o0000DOooool004gooooo
0ol00003ooooo`0300000?oooooooooo00Cooooo1_l0000/ooooo`Co00000_ooool4o`0000Gooooo
00<00000ooooooooool07oooool01@00003o0000o`000?l0003ooooo00;o00000oooool3o`00053o
oooo001=ooooo`;o00000oooool00`00003oooooooooo`05ooooo`Go00005Oooool00`00003ooooo
ooooo`0Dooooo`Co00001?ooool4o`0002Kooooo00<00000ooooool000001?l00004ooooo`?o0000
Coooool004cooooo0ol00002ooooo`0300000?oooooooooo00Kooooo0ol0000Gooooo`<000004_oo
ool4o`0000Sooooo0ol00006ooooo`0300000?oooooooooo01oooooo1Ol00004ooooo`?o0000C_oo
ool004_ooooo0ol0000:ooooo`0300000?oooooo000000?o00005_ooool00`00003oooooooooo`0A
ooooo`Co00002_ooool4o`0000?ooooo00?o000000000?ooool08_ooool3o`0000Gooooo0_l0001>
ooooo`00B_ooool3o`000003ooooo`00003ooooo00Sooooo00<00000o`000?l000001?l0000Doooo
o`0300000?ooool00000013ooooo1?l0000=ooooo`Co00000_ooool3000001cooooo00<00000oooo
ooooool00_ooool4o`0000Gooooo0ol0001=ooooo`00BOooool3o`000003ooooo`00003ooooo00Wo
oooo0ol00002ooooo`Co00004Oooool01@00003oooooooooooooool0000000kooooo1?l0000@oooo
o`Co00000oooool00`00003oooooooooo`0Iooooo`0400000?ooooooooooooooo`Ko000000?ooooo
00000?ooool00_ooool3o`0004cooooo0018ooooo`?o000000?ooooo00000?ooool02Oooool3o`00
00Cooooo1?l0000Qooooo`Co00004oooool4o`0001kooooo00<00000ooooooooool00ol00002oooo
o`?o000000?ooooo00000?ooool00_ooool3o`0004_ooooo0017ooooo`?o00003?ooool3o`0000Oo
oooo0ol0000;ooooo`8000004_ooool4o`0001Kooooo0ol00003ooooo`8000006?ooool00`00003o
ooooo`000002o`0000Cooooo0ol000000oooool00000ooooo`02ooooo`;o0000Boooool004Kooooo
0ol000000`00003oooooooooo`09ooooo`?o00002Oooool4o`0000Sooooo00<00000ooooooooool0
2?ooool00`00003oooooooooo`05ooooo`Co00005Oooool01000003oooooooooooooool4o`0000?o
oooo00<00000ooooooooool05_ooool3o`0000Kooooo0_l00004ooooo`0400000?l0003o0000o`00
04[ooooo0015ooooo`?o00003?ooool3o`000003ooooo`00003ooooo00Sooooo1?l0000Cooooo`03
00000?oooooooooo00?ooooo1?l0000Eooooo`0300000?oooooooooo00?ooooo1?l00003ooooo`03
00000?oooooooooo01?ooooo1?l00007ooooo`?o00001?ooool01000003o0000o`000?l00019oooo
o`00A?ooool3o`0000cooooo0ol00002ooooo`0300000?oooooooooo00Wooooo1?l00002ooooo`03
00000?oooooooooo00gooooo00@00000oooooooooooooooo0ol0000Fooooo`0300000?oooooooooo
00Kooooo1?l0000Fooooo`Co00002Oooool3o`0000Cooooo00@00000o`000?l0003o0000B?ooool0
04?ooooo0ol0000<ooooo`?o00000_ooool00`00003oooooooooo`0;ooooo`Co000000<00000oooo
ooooool04?ooool4o`00027ooooo1?l00002ooooo`<000003oooool3o`00000300000?oooooooooo
00Wooooo0_l00006ooooo`;o0000B?ooool004;ooooo0ol0000<ooooo`?o00000oooool00`00003o
ooooooooo`0=ooooo`?o00004Oooool4o`0002Cooooo0ol00004ooooo`0300000?oooooooooo00_o
oooo0ol000000oooool00000ooooo`0:ooooo`?o00001Oooool3o`0004Oooooo0012ooooo`;o0000
3?ooool3o`0001;ooooo00<00000ooooooooool01?l0000=ooooo`Co00006?ooool00`00003ooooo
ooooo`0<ooooo`Co00003oooool3o`0000;ooooo00<00000ooooooooool02_ooool3o`0000Gooooo
0ol00016ooooo`00@_ooool2o`0000_ooooo0ol0000Booooo`0300000?oooooooooo00;ooooo1?l0
000;ooooo`Co000000?ooooo00000?ooool05Oooool00`00003oooooooooo`0>ooooo`Co00001?oo
ool00`00003oooooooooo`05ooooo`Co00004Oooool3o`0000Gooooo0ol00015ooooo`00@_ooool2
o`0000[ooooo0ol00006ooooo`0300000?oooooooooo00Wooooo00<00000ooooooooool01Oooool3
o`0000Sooooo1?l00004ooooo`0300000?oooooooooo01;ooooo00<00000ooooooooool04Oooool4
o`0000?ooooo00<00000ooooooooool00oooool4o`0001?ooooo0_l00006ooooo`;o0000AOooool0
04;ooooo0_l0000:ooooo`;o00001oooool00`00003oooooooooo`0Booooo`Co00001Oooool4o`00
02oooooo1?l00003ooooo`0400000?ooooooooooooooo`?o00001Oooool00`00003oooooooooo`0=
ooooo`?o00001Oooool2o`0004Gooooo0012ooooo`;o00002Oooool3o`0000Oooooo00<00000oooo
ooooool01Oooool2000000cooooo1?l00002ooooo`Co00006_ooool00`00003oooooooooo`0Foooo
o`?o00001Oooool3o`0000Kooooo00<00000ooooooooool03_ooool3o`0000Cooooo0ol00014oooo
o`00@_ooool2o`0000Sooooo0ol00008ooooo`0300000?oooooooooo00?ooooo0P00000@ooooo`Oo
00002_ooool00`00003oooooooooo`0=ooooo`0300000?oooooooooo01Sooooo1?l00002ooooo`?o
00001oooool00`00003oooooooooo`0?ooooo`?o00001?ooool2o`0004Cooooo0012ooooo`;o0000
1oooool3o`0002;ooooo1?l0000<ooooo`0300000?oooooooooo00cooooo00<00000ooooooooool0
6_ooool7o`00000300000?oooooooooo00Gooooo00<00000ooooooooool04?ooool2o`0000Cooooo
0_l00014ooooo`00@_ooool3o`0000Gooooo0ol0000=ooooo`8000005Oooool4o`0000cooooo00<0
0000ooooooooool0:_ooool4o`0000;ooooo00<00000ooooooooool05oooool3o`0000;ooooo00<0
0000o`000?l00000A?ooool004;ooooo0ol00004ooooo`?o00002oooool00`00003ooooo0000000F
ooooo`Oo0000=_ooool4o`0000Kooooo00<00000ooooooooool05Oooool3o`000004ooooo`00003o
0000o`0004Cooooo0012ooooo`?o00000oooool3o`0000cooooo0P00000Fooooo`?o00000_ooool4
o`0000cooooo00<00000ooooooooool01_ooool00`00003oooooooooo`0Kooooo`Oo00001_ooool0
1000003oooooooooo`00000Dooooo`?o000000@00000o`000?l0003o0000@oooool004;ooooo0ol0
0002ooooo`?o00003Oooool00`00003oooooooooo`0Dooooo`?o00001Oooool3o`0000_ooooo00<0
0000ooooooooool01Oooool00`00003oooooooooo`0Kooooo`Co00000_ooool3o`0000Kooooo00<0
0000ooooo`0000005Oooool2o`00000400000?oooooo0000o`0004?ooooo0012ooooo`?o000000Co
ooooo`000?l0003o00003Oooool00`00003ooooo0000000Dooooo`?o00001oooool4o`0000[ooooo
00<00000ooooooooool00oooool00`00003oooooooooo`0Jooooo`Co00001Oooool3o`0000Oooooo
00<00000ooooooooool04oooool3o`000003ooooool0003o000004?ooooo0012ooooo`Ko00003Ooo
ool01@00003oooooooooooooool0000001;ooooo0ol00009ooooo`Co00002Oooool00`00003ooooo
ooooo`0Oooooo`Co00001oooool2o`0000Kooooo00<00000ooooo`0000005Oooool5o`0004?ooooo
0012ooooo`Go00009?ooool3o`0000cooooo1?l0000;ooooo`0300000?oooooooooo01Wooooo1?l0
0009ooooo`?o00001?ooool01@00003oooooooooooooool0000001Gooooo1?l00013ooooo`00@_oo
ool4o`0000_ooooo0P00000Gooooo`?o00003_ooool4o`0000Sooooo00?o0000ooooo`0000006_oo
ool4o`0000_ooooo0ol0000Mooooo`Go0000@_ooool004;ooooo1Ol00009ooooo`0300000?oooooo
oooo00Sooooo00<00000ooooooooool02oooool3o`00017ooooo0ol00007ooooo`<000006?ooool4
o`0000kooooo0ol00009ooooo`8000004?ooool00`00003oooooo`000003o`0004;ooooo0012oooo
o`Ko00005?ooool00`00003oooooooooo`09ooooo`?o00004oooool4o`0000?ooooo0P000003oooo
o`0300000?oooooooooo01Cooooo1?l0000@ooooo`?o00002_ooool00`00003oooooooooo`0=oooo
o`0300000?oooooooooo00?o0000@_ooool004;ooooo0ol000001?oooooo0000o`000?l0000Doooo
o`0300000?oooooooooo00Oooooo0ol0000Eooooo`Co00007?ooool4o`0001;ooooo00<00000o`00
0?l000007?ooool4o`0004;ooooo0012ooooo`?o00000_ooool4o`000003ooooo`000000000001So
oooo0ol0000Hooooo`Co00002?ooool00`00003oooooooooo`0>ooooo`Co00004_ooool00`00003o
ooooo`000002o`0000cooooo00<00000ooooooooool02oooool5o`0004;ooooo0012ooooo`?o0000
0oooool4o`0001Wooooo0ol0000Iooooo`0300000?l0003o000000;o00002?ooool00`00003ooooo
ooooo`0<ooooo`?o00005oooool3o`0000cooooo00<00000ooooooooool02Oooool3o`000003oooo
ool0003o000004;ooooo0012ooooo`?o00001Oooool3o`0001;ooooo00<00000ooooooooool00ooo
ool2o`0001Wooooo00@00000oooooooooooooooo0ol00008ooooo`0300000?oooooooooo00Wooooo
1?l0000Cooooo`0300000?oooooooooo00?ooooo0ol0000<ooooo`0300000?oooooooooo00Oooooo
0ol00002ooooo`;o0000@_ooool004;ooooo0ol00003ooooo`0300000?oooooooooo00?o00004Ooo
ool00`00003oooooooooo`02ooooo`?o00007_ooool4o`00017ooooo1?l0000Cooooo`0300000?oo
oooooooo00Gooooo0_l0000Eooooo`?o00000_ooool3o`0004;ooooo0012ooooo`?o00000_ooool0
0`00003oooooooooo`02ooooo`?o00004Oooool00`00003oooooooooo`03o`0001Kooooo0P000008
ooooo`Co00002?ooool2000000Cooooo1?l0000Dooooo`0300000?oooooooooo00Kooooo0ol0000>
ooooo`0300000?oooooooooo00;ooooo0ol000000`00003oooooooooo`02o`0004?ooooo0012oooo
o`?o000000?ooooo00000?ooool01Oooool4o`00017ooooo0ol0000Fooooo`0300000?oooooooooo
00[ooooo1?l00008ooooo`0300000?oooooooooo00Co00007oooool3o`0000kooooo00<00000oooo
ooooool00ol00004ooooo`;o0000@oooool004;ooooo0ol00009ooooo`Co00003oooool3o`0002Go
oooo1?l00008ooooo`Co00008_ooool3o`0000kooooo1?l00005ooooo`;o0000@oooool004;ooooo
0ol0000;ooooo`?o00003Oooool3o`00000300000?oooooooooo01;ooooo00<00000ooooooooool0
4?ooool3o`0000Kooooo1?l0000Fooooo`0300000?oooooooooo00_ooooo0_l0000=ooooo`Co0000
1_ooool2o`0004?ooooo0012ooooo`?o00003?ooool3o`0000_ooooo0ol00002ooooo`0300000?oo
oooooooo013ooooo00<00000ooooooooool04_ooool4o`0000;ooooo1?l00002ooooo`0300000?oo
oooooooo01;ooooo00<00000ooooooooool03?ooool3o`0000_ooooo0ol00002ooooo`<000000ooo
ool2o`0004?ooooo0012ooooo`?o00003Oooool4o`0000Sooooo0ol00003ooooo`0300000?oooooo
oooo00oooooo00<00000ooooooooool05?ooool8o`0000Cooooo00<00000ooooooooool04?ooool0
0`00003oooooooooo`0>ooooo`?o00002Oooool3o`0000Gooooo00@00000oooooooooooooooo0_l0
0013ooooo`00@_ooool3o`0000kooooo1?l00006ooooo`?o0000;oooool4o`0002_ooooo0ol00007
ooooo`?o00001_ooool01000003oooooooooooooool2o`0004?ooooo0012ooooo`;o00004Oooool3
o`0000Cooooo0ol00007ooooo`0300000?oooooooooo00Wooooo0P00000Looooo`;o00002_ooool0
0`00003oooooooooo`0;ooooo`0300000?oooooooooo01;ooooo0ol00005ooooo`?o00001_ooool2
000000?ooooo0_l00013ooooo`00@_ooool2o`0001;ooooo0ol00002ooooo`?o00002Oooool00`00
003oooooooooo`07ooooo`0300000?oooooooooo01_ooooo1?l0000:ooooo`0300000?oooooooooo
00Wooooo00<00000ooooooooool05?ooool2o`0000Cooooo0ol00006ooooo`0500000?oooooooooo
00000?ooool00ol00013ooooo`00@_ooool2o`0000;ooooo00<00000ooooooooool03_ooool6o`00
00_ooooo00<00000ooooooooool08oooool6o`0000[ooooo00<00000ooooooooool01oooool00`00
003oooooooooo`0Eooooo`?o00000_ooool3o`0000cooooo0_l00014ooooo`00@_ooool2o`0000?o
oooo00<00000ooooooooool03_ooool4o`0001;ooooo00<00000ooooooooool07?ooool3o`0000;o
oooo0ol0000<ooooo`0300000?oooooooooo01gooooo1_l00006ooooo`0300000?oooooooooo00Co
oooo0_l00014ooooo`00@_ooool2o`0000Cooooo00<00000ooooooooool03_ooool4o`00013ooooo
00<00000ooooooooool07?ooool3o`0000Cooooo0_l0000=ooooo`0300000?oooooooooo01gooooo
1?l00006ooooo`0300000?oooooooooo00Gooooo0_l00014ooooo`00@_ooool2o`0001Gooooo1_l0
000;ooooo`;o000000<00000ooooooooool07?ooool3o`0000Gooooo0ol0000=ooooo`0400000?oo
ool00000000001[ooooo1?l00006ooooo`0300000?oooooooooo00Gooooo00<00000o`000?l00000
A?ooool004;ooooo0_l0000Eooooo`;o000000?oooooo`000?l000000_l00009ooooo`0400000?oo
oooooooo000001gooooo0ol00007ooooo`?o00003Oooool2000001Wooooo1_l0000>ooooo`030000
0?l0003o000004Cooooo0012ooooo`;o00001_ooool00`00003oooooooooo`0<ooooo`;o00000ooo
ool4o`0000Kooooo00<00000ooooooooool00_ooool00`00003oooooooooo`0Iooooo`?o00002Ooo
ool3o`0000_ooooo00@00000ooooooooool000005oooool4o`000003ooooool0003o000000kooooo
00<00000o`000?l00000A?ooool004;ooooo0_l00007ooooo`0300000?oooooooooo00_ooooo0_l0
0004ooooo`Co00009Oooool3o`0000_ooooo0ol00009ooooo`0300000?oooooooooo00;ooooo00<0
0000ooooooooool04_ooool4o`0000?ooooo0_l00004ooooo`0300000?oooooooooo00Sooooo0_l0
0014ooooo`00@_ooool2o`0000Sooooo00<00000ooooooooool02_ooool2o`0000Kooooo1?l00000
0oooool00000ooooo`08ooooo`0300000?oooooooooo01Cooooo0ol0000=ooooo`;o00008_ooool4
o`0000?ooooo0ol00003ooooo`0300000?oooooooooo00Wooooo0_l00014ooooo`00@_ooool2o`00
01Gooooo0_l00007ooooo`Co00002oooool00`00003oooooooooo`0Booooo`?o00003_ooool3o`00
00Cooooo0P000009ooooo`<000003Oooool4o`0000Gooooo0_l00003ooooo`0300000?oooooooooo
00Wooooo0ol00014ooooo`00@_ooool2o`0000[ooooo00<00000ooooooooool02?ooool2o`0000Wo
oooo1?l0000:ooooo`0300000?oooooooooo013ooooo0ol0000@ooooo`?o00000_ooool00`00003o
ooooooooo`0<ooooo`0300000?oooooooooo00Wooooo1?l00006ooooo`;o00003oooool2o`0004Go
oooo0012ooooo`?o00002_ooool00`00003oooooooooo`07ooooo`;o00002_ooool4o`0001_ooooo
0ol0000Booooo`?o00006_ooool4o`0000Sooooo0_l000000oooool00000ooooo`0<ooooo`;o0000
AOooool004;ooooo1?l0000:ooooo`0300000?oooooooooo00Kooooo0_l00006ooooo`0300000?oo
oooooooo00?ooooo1?l0000:ooooo`8000003?ooool3o`0001Cooooo0_l0000Booooo`8000001Ooo
ool4o`0000Wooooo0_l000000`00003oooooooooo`0<ooooo`;o0000AOooool004;ooooo1Ol0000B
ooooo`;o00001Oooool00`00003oooooooooo`05ooooo`Co00002oooool00`00003oooooooooo`08
ooooo`?o00005?ooool01000003o0000o`000?l0000Cooooo`0300000?oooooooooo00Co00002ooo
ool2o`0000kooooo0ol00015ooooo`00@oooool5o`00017ooooo0_l00004ooooo`0300000?oooooo
oooo00Sooooo0ol0000Dooooo`?o00005?ooool00`00003oooooooooo`03o`0001?ooooo00<00000
o`000?l000000_l0000<ooooo`;o00003Oooool4o`0004Gooooo0014ooooo`Ko00002?ooool00`00
003oooooooooo`04ooooo`;o00004?ooool4o`0000_ooooo00<00000ooooooooool00oooool3o`00
01Wooooo0ol0000Booooo`?o00003_ooool2o`0000cooooo1Ol00015ooooo`00AOooool6o`0000So
oooo00<00000ooooooooool00_ooool3o`000003ooooo`00003ooooo00kooooo1?l0000;ooooo`04
00000?ooooooooooooooo`?o00004_ooool2000000Oooooo0_l0000@ooooo`Co00000P00000;oooo
o`0400000?oooooo0000o`0000_ooooo1Ol00016ooooo`00A_ooool6o`0000Sooooo00@00000oooo
oooooooooooo0_l000000oooool00000ooooo`0Aooooo`Co00002_ooool00`00003oooooo`000002
o`0001;ooooo00<00000ooooooooool01oooool3o`0000kooooo1?l00003ooooo`0300000?oooooo
oooo00Oooooo00<00000ooooool000000_l0000:ooooo`Go0000Aoooool004Oooooo0_l000001?oo
oooo0000o`000?l0000;ooooo`;o000000<00000ooooooooool04_ooool4o`0000[ooooo0ol0000N
ooooo`?o00002oooool4o`0000Kooooo00<00000ooooooooool01Oooool00`00003oooooooooo`02
o`0000[ooooo1Ol00018ooooo`00Aoooool3o`000004ooooool0003o0000o`0000[ooooo0_l0000G
ooooo`Co00001oooool3o`00008000003oooool00`00003oooooooooo`0<ooooo`?o00002Oooool4
o`0001;ooooo0_l00009ooooo`Go0000BOooool004Sooooo0ol000000ooooooo0000o`000002o`00
00Kooooo1?l0000Hooooo`Co00001Oooool3o`0000?ooooo00<00000ooooooooool02oooool00`00
003oooooooooo`0>ooooo`?o00001_ooool4o`0000_ooooo00D00000oooooooooooooooo00000004
ooooo`;o00002?ooool5o`0004[ooooo0019ooooo`?o000000?oooooo`000?l000000_l00006oooo
o`?o00006_ooool4o`0000;ooooo0ol0000Aooooo`0300000?oooooooooo013ooooo0_l00005oooo
o`Co00003Oooool01000003oooooooooo`000004ooooo`;o00001_ooool6o`0004_ooooo001:oooo
o`?o00000_ooool3o`0000Gooooo00<00000o`000?l000006oooool7o`0000Sooooo00<00000oooo
ooooool06_ooool3o`0000;ooooo1?l0000@ooooo`8000001Oooool2o`0000Gooooo1_l0001<oooo
o`00Boooool3o`0000;ooooo0ol00004ooooo`0300000?l0003o000001gooooo1?l0000:ooooo`03
00000?oooooooooo00;ooooo0P00000Fooooo`Oo00003oooool200000003ooooo`00003ooooo00Co
oooo0_l00004ooooo`Ko0000COooool004cooooo0ol00002ooooo`Co00000oooool2o`0000;ooooo
00<00000ooooooooool06Oooool2o`0000cooooo00@00000ooooooooool000006Oooool4o`0001Co
oooo00<00000ooooooooool00oooool2o`0000?ooooo1_l0001>ooooo`00COooool2o`0000?ooooo
1?l00002ooooo`;o00000oooool00`00003oooooooooo`0Hooooo`?o00003?ooool2000001_ooooo
0_l0000?ooooo`8000001?ooool00`00003oooooooooo`03ooooo`;o00000_ooool6o`0004oooooo
001=ooooo`?o00001?ooool3o`000003ooooool0003o000000Cooooo00<00000ooooooooool05ooo
ool4o`0000[ooooo00@00000ooooooooool000006Oooool3o`0000kooooo00<00000ooooooooool0
2Oooool3o`000003ooooool0003o000000Co0000D?ooool004kooooo0ol00004ooooo`Go00007_oo
ool5o`0000Sooooo00<00000ooooooooool00_ooool00`00003oooooooooo`0Eooooo`Co00003Ooo
ool00`00003oooooooooo`0:ooooo`;o000000?oooooo`000?l000001?l0001Aooooo`00Coooool3
o`0000Cooooo1?l00007ooooo`8000005Oooool2o`000004ooooool0003o0000o`0002?ooooo1Ol0
000Fooooo`0400000?ooooooooooooooo`So0000D_ooool0053ooooo0ol00004ooooo`Co00002?oo
ool00`00003oooooooooo`0Booooo`;o00000_ooool2o`0000Gooooo00<00000ooooooooool01_oo
ool30000017ooooo0ol000000ooooooo0000o`00000:ooooo`8000002_ooool01000003ooooooooo
ooooool7o`0005?ooooo001Aooooo`?o00000oooool00`00003o0000o`000002o`0001cooooo0_l0
0002ooooo`?o00000oooool00`00003oooooooooo`0:ooooo`0300000?oooooooooo00gooooo0ol0
0002ooooo`;o00002?ooool2000000cooooo00<00000ooooooooool01ol0001Dooooo`00D_ooool2
o`0000Cooooo1_l00008ooooo`0300000?oooooooooo00oooooo0_l00003ooooo`?o000000?ooooo
00000?ooool06oooool3o`0000?ooooo0_l0000Fooooo`0300000?oooooo000000Ko0000EOooool0
05;ooooo0ol00004ooooo`Ko00002?ooool00`00003oooooooooo`0>ooooo`;o00001?ooool3o`00
013ooooo0P00000:ooooo`?o00000oooool3o`0000Gooooo00<00000ooooooooool03_ooool8o`00
05Kooooo001Cooooo`?o000000Cooooo00000?oooooooooo1ol00007ooooo`0300000?oooooooooo
00gooooo0_l00004ooooo`0400000?l0003o0000o`00017ooooo00<00000ooooooooool01_ooool3
o`0000Cooooo0_l00005ooooo`0300000?oooooooooo00kooooo2?l0001Gooooo`00E?ooool3o`00
000400000?ooooooooooooooo`Oo00005_ooool2o`0000?ooooo00<00000ooooooooool00_l0000B
ooooo`0300000?oooooooooo00Cooooo0ol00005ooooo`;o00001?ooool00`00003oooooooooo`0>
ooooo`So0000F?ooool005Gooooo0ol000001000003oooooooooooooool3o`000003ooooool0003o
000000;o00001oooool00`00003oooooooooo`0:ooooo`;o00000_ooool01000003ooooooooooooo
ool3o`0001Oooooo0ol00006ooooo`;o00004oooool9o`0005Wooooo001Fooooo`Co00000oooool2
o`0000;ooooo1?l00007ooooo`0300000?oooooooooo00Wooooo0_l00007ooooo`?o00004_ooool0
0`00003oooooooooo`03o`0000Oooooo0_l000020000013ooooo2Ol0001Jooooo`00Eoooool4o`00
00;ooooo0ol00003ooooo`Co00001_ooool00`00003oooooooooo`07ooooo`?o00002?ooool3o`00
01;ooooo00@00000o`000?l0003o00002?ooool2o`00013ooooo1?l000000ooooooo0000o`000003
o`0005_ooooo001Iooooo`?o00000_ooool3o`0000?ooooo1?l0000?ooooo`;o00002_ooool3o`00
01;ooooo0_l00009ooooo`;o00003oooool4o`000003ooooool0003o000000?o0000G?ooool005[o
oooo0ol00002ooooo`?o00001?ooool4o`0000Kooooo0P000005ooooo`;o00002oooool3o`00013o
oooo0ol00007ooooo`0400000?oooooo0000o`0000gooooo1?l00002ooooo`Co0000G_ooool005_o
oooo1?l000001?oooooo0000o`000?l00004ooooo`Co00001oooool00`00003oooooooooo`02oooo
o`;o00003?ooool2o`0000oooooo0ol00002ooooo`0300000?oooooooooo00;ooooo00<00000oooo
ooooool00_l0000<ooooo`Co00000_ooool4o`0005oooooo001Looooo`Co000000Coooooo`000?l0
003o00001Oooool3o`0000Sooooo00<00000o`000?ooool00_l0000<ooooo`?o00003Oooool3o`00
00Cooooo00@00000ooooooooool000000oooool2o`0000_ooooo0ol00003ooooo`Co0000H?ooool0
05kooooo0ol000001?oooooo0000o`000?l00005ooooo`Co00001_ooool200000003ooooool0003o
000000gooooo0ol0000;ooooo`?o00001_ooool2000000Cooooo0_l00009ooooo`Co00000oooool4
o`00067ooooo001Oooooo`?o000000<00000o`000?l000001_ooool4o`0000Gooooo00<00000oooo
o`0000000_l0000>ooooo`?o00002Oooool3o`0000Kooooo00<00000ooooo`0000001?ooool2o`00
00Sooooo1?l00003ooooo`Co0000H_ooool0063ooooo1_l00007ooooo`Co00000oooool00`00003o
ooooooooo`02o`0000oooooo0ol00007ooooo`?o00001_ooool01000003oooooooooo`000004oooo
o`;o00001_ooool4o`0000Cooooo1?l0001Sooooo`00HOooool6o`0000Oooooo1?l00005ooooo`;o
000000<00000ooooooooool03Oooool2o`0000Kooooo0ol0000:ooooo`0400000?oooooooooooooo
o`?o00001Oooool4o`0000Cooooo1?l0001Tooooo`00H_ooool6o`0000Sooooo1?l00003ooooo`;o
000000?ooooo00000?ooool03Oooool3o`0000Cooooo0ol00006ooooo`0300000?oooooooooo00Ko
oooo0_l00004ooooo`Co00001Oooool4o`0006Gooooo001Tooooo`Go00002?ooool4o`0000;ooooo
0_l00002ooooo`0300000?oooooooooo00cooooo0ol00002ooooo`?o00001_ooool00`00003ooooo
ooooo`07ooooo`;o00000oooool4o`0000Gooooo0ol0001Wooooo`00IOooool5o`0000Wooooo1_l0
000Booooo`Ko00001_ooool00`00003oooooooooo`04ooooo`0400000?ooooooooooooooo`;o0000
0_ooool3o`0000Cooooo0P000003o`0006Sooooo001Vooooo`Co00002_ooool5o`0000Gooooo00<0
0000ooooooooool02oooool4o`0000kooooo00@00000oooooooooooooooo1_l00004ooooo`030000
0?oooooo000000;o0000JOooool006Oooooo1?l000000oooool00000ooooo`07ooooo`0400000?l0
003o0000o`0000Kooooo00<00000ooooooooool02oooool2o`0000Gooooo00<00000ooooooooool0
2?ooool00`00003oooooooooo`05o`0000Kooooo0ol0001Zooooo`00JOooool3o`000003ooooo`00
003ooooo00Sooooo0_l00007ooooo`0300000?oooooooooo00[ooooo0_l00004ooooo`0300000?oo
oooooooo00Wooooo00<00000ooooooooool00ol00004ooooo`0300000?oooooooooo00?o0000Jooo
ool006[ooooo0ol000000oooool00000ooooo`07ooooo`?o00004oooool2o`0000?ooooo00<00000
ooooooooool03Oooool2o`0000Cooooo00<00000ooooooooool00ol0001/ooooo`00Joooool3o`00
00[ooooo0ol00008ooooo`0300000?oooooooooo00Oooooo0_l0000Booooo`?o00000oooool00`00
003oooooooooo`03o`0006gooooo001/ooooo`Co000000?ooooo00000?ooool00_ooool01000003o
ooooooooooooool3o`0000Sooooo00<00000ooooooooool01_ooool2o`00008000003_ooool01000
003o0000o`000?l00005ooooo`Co0000K_ooool006gooooo1?l000001Oooool00000ooooooooool0
000000Cooooo0ol00008ooooo`0300000?oooooooooo00Gooooo0_l0000@ooooo`?o000000?ooooo
0000000000000_ooool4o`0006oooooo001_ooooo`Co000000<00000ooooo`0000001Oooool2o`00
00oooooo0ol0000?ooooo`?o000000Cooooo00000?oooooooooo1?l0001aooooo`00L?ooool4o`00
0003ooooo`000000000000Cooooo0ol00009ooooo`8000000oooool2o`0000oooooo0ol000001000
003oooooooooooooool4o`0007;ooooo001booooo`?o00000_ooool00`00003oooooooooo`02oooo
o`?o00002_ooool00`00003oooooo`000002o`0000kooooo0ol000001?ooool00000ooooooooool3
o`0007Cooooo001cooooo`Co000000?ooooo00000?ooool00oooool3o`0000[ooooo00@00000oooo
ool0003o00003Oooool3o`000003ooooo`00003ooooo00Co0000MOooool007Cooooo1?l00006oooo
o`?o00002Oooool01000003oooooo`000?l0000<ooooo`?o000000?ooooo00000?ooool01?l0001f
ooooo`00M_ooool4o`00008000000oooool2o`0000Wooooo00@00000ooooool0003o00002oooool3
o`0000;ooooo1?l0001hooooo`00Moooool4o`000004ooooo`00003oooooooooo`?o00002?ooool0
1000003oooooo`000?l0000:ooooo`?o000000<00000ooooool000000ol0001iooooo`00NOooool4
o`00000300000?oooooooooo00?o00002Oooool2o`0000Wooooo0ol000000`00003o0000o`000002
o`0007_ooooo001jooooo`Co00000oooool3o`0000Sooooo0_l00008ooooo`?o000000<00000o`00
0?l000000_l0001looooo`00O?ooool3o`00000300000?oooooooooo00?o00001_ooool00`00003o
0000o`000007ooooo`?o000000Coooooo`000?l0003o0000O_ooool007gooooo1?l00002ooooo`;o
00001_ooool00`00003o0000o`000006ooooo`Oo0000Ooooool007kooooo1?l000001?oooooo0000
o`000?l00005ooooo`0300000?l0003o000000Gooooo1ol00020ooooo`00P?ooool7o`0000Cooooo
00<00000o`000?l000001?ooool6o`0008;ooooo0021ooooo`Oo00000oooool3o`0000?ooooo1_l0
0023ooooo`00Poooool6o`0000;ooooo0_l00003ooooo`Go0000QOooool008Cooooo1Ol00002oooo
o`;o00000_ooool5o`0008Kooooo0026ooooo`Co000000Coooooo`000?l0003ooooo1?l00028oooo
o`00Qoooool:o`0008Wooooo0028ooooo`So0000R_ooool008[ooooo1?l0002<ooooo`00Roooool2
o`0008gooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003ooooooa_ooooo003o
oooooa_ooooo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {281, 0}} -> {-5.00005*^-6, -5.00005*^-6, \
0.00355875, 0.00355875}}]
}, Closed]]
}, Open  ]],

Cell["UnfoldPolytope[facets1]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 1152}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 624},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 783, 26, 319, "Title"],

Cell[CellGroupData[{
Cell[2513, 80, 118, 2, 27, "Input",
  InitializationCell->True],
Cell[2634, 84, 900, 30, 462, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3559, 118, 177, 7, 72, "Input",
  InitializationCell->True],
Cell[3739, 127, 54, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3830, 133, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[3948, 137, 84, 1, 27, "Output"]
}, Open  ]],
Cell[4047, 141, 112, 2, 27, "Input",
  InitializationCell->True],
Cell[4162, 145, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[4261, 149, 96, 2, 27, "Input",
  InitializationCell->True],
Cell[4360, 153, 98, 2, 27, "Input",
  InitializationCell->True],
Cell[4461, 157, 93, 2, 27, "Input",
  InitializationCell->True],
Cell[4557, 161, 363, 11, 162, "Input",
  InitializationCell->True],
Cell[4923, 174, 203, 8, 87, "Input",
  InitializationCell->True],
Cell[5129, 184, 283, 9, 132, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5437, 197, 144, 5, 42, "Input",
  InitializationCell->True],
Cell[5584, 204, 42, 1, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5675, 211, 147, 4, 42, "Input"],

Cell[CellGroupData[{
Cell[5847, 219, 75, 1, 27, "Input"],
Cell[5925, 222, 41, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6003, 228, 84, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[6112, 233, 64, 1, 27, "Input"],
Cell[6179, 236, 36, 1, 27, "Output"]
}, Open  ]],
Cell[6230, 240, 78, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[6333, 245, 69, 1, 27, "Input"],
Cell[6405, 248, 51, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6493, 254, 132, 4, 57, "Input"],
Cell[6628, 260, 41735, 894, 294, 9022, 486, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48400, 1159, 164, 7, 87, "Input"],
Cell[48567, 1168, 45070, 853, 291, 6193, 369, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],
Cell[93664, 2025, 120, 5, 57, "Input"],
Cell[93787, 2032, 158, 8, 102, "Input"],

Cell[CellGroupData[{
Cell[93970, 2044, 195, 8, 117, "Input"],
Cell[94168, 2054, 32032, 732, 290, 4269, 385, "GraphicsData", "PostScript", \
"Graphics"],
Cell[126203, 2788, 132, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[126372, 2796, 334, 13, 147, "Input"],
Cell[126709, 2811, 33656, 751, 290, 4409, 385, "GraphicsData", "PostScript", \
"Graphics"],
Cell[160368, 3564, 33914, 751, 290, 4327, 381, "GraphicsData", "PostScript", \
"Graphics"],
Cell[194285, 4317, 4678, 398, 290, 4525, 393, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[198966, 4717, 4633, 394, 290, 4480, 389, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[203602, 5113, 4556, 390, 290, 4403, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[208161, 5505, 4587, 390, 290, 4434, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[212751, 5897, 4541, 390, 290, 4388, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[217295, 6289, 4722, 402, 290, 4569, 397, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[222020, 6693, 4773, 406, 290, 4620, 401, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[226796, 7101, 4562, 390, 290, 4409, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[231361, 7493, 33914, 751, 290, 4327, 381, "GraphicsData", "PostScript", \
"Graphics"],
Cell[265278, 8246, 33938, 761, 290, 4525, 393, "GraphicsData", "PostScript", \
"Graphics"],
Cell[299219, 9009, 34638, 766, 290, 4480, 389, "GraphicsData", "PostScript", \
"Graphics"],
Cell[333860, 9777, 4556, 390, 290, 4403, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[338419, 10169, 4587, 390, 290, 4434, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[343009, 10561, 4541, 390, 290, 4388, 385, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[347553, 10953, 34266, 769, 290, 4569, 397, "GraphicsData", "PostScript", \
"Graphics"]
}, Closed]]
}, Open  ]],
Cell[381846, 11726, 73, 1, 27, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

