// ESSO: Extensible Shell with Scheme Orientation
// Written by Matthias Koeppe <mkoeppe@csmd.cs.uni-magdeburg.de>

// This is the main file intended for use with Linux.

#include <stdio.h>
#include <fstream.h>
#include "stpipe.h"
#include "lisp.h"

int statistics[33];

extern int mmopgood;
#if defined(USESHM)
void initmmop();
#endif

void *maxstack;

int main()
{
#if defined(USESHM)
  if (!mmopgood) {
    initmmop();
    mmopgood = 1;
  }
#endif
  asm("movl %%esp, %%eax" : "=a" (maxstack));
  RegisterThreadWithTries((void *) 0, maxstack);
  // init globals
  _LispNull = new TLispRef(NEW TLispNull());
  _LispFalse = new TLispRef(NEW TLispBoolean(false));
  _LispTrue = new TLispRef(NEW TLispBoolean(true));
  _GlobalFrame = new TLispRef(MakeGlobalFrame());
  SyntaxAListName = new string("syntax-alist");
  //
  TIstreamPipe isp(cin);
  TOstreamPipe osp(cout);
  TIstreamPipe csp(cin);
  {
    ifstream ls("essolib.scm");
    TIstreamPipe lsp(ls);

    TRY {
      lisp_write(osp, lisp_load(lsp, GlobalFrame));
    } 
#ifdef OWNEXCEPTIONS
    else {
      osp.Put(strdup(Exception->Message().c_str()));	
      osp.Put(strdup("\n"));				
      delete Exception;
      Exception = 0;
#else
    catch (...) {
#endif
      osp.Put(strdup("Error reading essolib.scm; probably nothing will work."));
    }
    osp.Put(strdup("\n"));
  }
  read_eval_write_loop(isp, csp, osp);  
  UnregisterThreadWithTries();

//   for (int i = 0; i<=33; i++) cout << statistics[i] << ' ';
//   cout << endl;
}

