// This provides some libg++ and libc things.

#include <string>
#include <tree.h>

__rb_tree_node_base __rb_NIL;

typedef void (*new_handler)();
extern "C" new_handler set_new_handler (new_handler) 
{
}

extern "C" void *malloc(size_t size);

extern "C" void *memcpy(void *dest, const void *src, size_t n)
{
  const char *s;
  char *d;
  int i;
  for (s = (const char *) src, d = (char *) dest, i = 0; i<n; i++) *d++ = *s++;
  return dest;
} 

#if 0
extern "C" void *memmove(void *dest, const void *src, size_t n)
{
  //& Ignore overlappings.
  memcpy(dest, src, n);
}
#endif

extern "C" __pure_virtual(void)
{
}

extern "C" char *strchr(const char *s, int c)
{
  const char *t = s;
  while (*t && *t!=c) t++;
  return (char *) (*t?t:0);
}

extern "C" unsigned int strlen(const char *s)
{
  int l = 0;
  while (*s++) l++;
  return l;
}

extern "C" char *strcat(char *dest, const char *src)
{
  strcpy(dest + strlen(dest), src);
  return dest;
}

extern "C" char *strdup(const char *s)
{
  int l = strlen(s);
  char *t = (char *) malloc(l+1);
  memcpy(t, s, l+1);
  return t;
}

extern "C" char *strcpy(char *t, const char *s)
{
  return (char *) memcpy(t, s, strlen(s) + 1);
}

#if 0
extern "C" char *strncpy(char *t, const char *s, size_t n)
{
  return (char *) memcpy(t, s, MAX(strlen(s) + 1, n));
}
#endif
