"Esso: Procedural-style loops"
"Written by Daniel Mahrenholz <mahrenho@csmd.cs.uni-magdeburg.de>"

(define (eval-while-aux frame condition clause)
  (if (eval condition frame)
      (begin 
	(eval clause frame)
	(eval-while-aux frame condition clause)
	)
      )
  )

(define (eval-while frame condition . clause)
  (if (and (not (null? condition))
	   (not (null? (car clause))))
      (eval-while-aux frame condition (car clause)))
  )

(define (eval-do--aux frame clause condition)
  (begin 
    (eval clause frame)
    (if (eval condition frame)
	(eval-do--aux frame clause condition)
	)
    )
  )

  
(define (eval-do- frame clause . condition)
  (if (and (not (null? clause))
	   (not (null? (cadr condition)))
	   (eq? (car condition) (quote while)))
      (eval-do--aux frame clause (cadr condition))
      )
  )

(set! syntax-alist (append (list (cons 'while eval-while)
				 (cons 'do- eval-do-))
			   syntax-alist))

(set! info-file-list (append (list "loops.sci")
			      info-file-list))

"return name of feature"

"loops"