// This is a -*- C++ -*- header file.

#if !defined(_STPIPE_H)
#define _STPIPE_H

#include <stdio.h>
#include <iostream.h>
#include "pipebase.h"

class TIstreamPipe : public TPipeBase<char> {
  istream *is;
  bool deleteis;
public:
  TIstreamPipe(istream &i) : is(&i), deleteis(false) {}
  TIstreamPipe(istream *i) : is(i), deleteis(true) {}
  virtual ~TIstreamPipe() { if (deleteis) delete is; }
  virtual char *Get() { 
    char *Buf = new char[256]; //&
    if (*is) {
      is->getline(Buf, 254);
      int l = strlen(Buf);
      Buf[l+1] = 0;
      if (!*is) Buf[l] = '\004';
      else Buf[l] = '\n';
    }    
    else { Buf[0] = '\004'; Buf[1] = 0; }
    return Buf;
  }
  virtual char *Read() { return Get(); }
  virtual void Put(const char *Item) {}
  virtual void Write(const char* Item) {}
};

class TOstreamPipe : public TPipeBase<char> {
public: //&
  ostream *os;
  bool deleteos;
public:
  TOstreamPipe(ostream &o) : os(&o), deleteos(false) {}
  TOstreamPipe(ostream *o) : os(o), deleteos(true) {}
  virtual ~TOstreamPipe() { if (deleteos) { 
    delete os; }}
  virtual char *Get() { return 0; } 
  virtual char *Read() { return 0; }
  virtual void Put(const char *Item) {
    (*os) << Item << flush;
    delete[] Item;
  }
  virtual void Write(const char* Item) { Put(Item); }
};

class TIstreampPipe : public TIstreamPipe {
  FILE *file;
public:
  TIstreampPipe(FILE *f) :
    TIstreamPipe(new ifstream(fileno(f))), file(f) {}
  virtual ~TIstreampPipe() {
    pclose(file);
  }
};

#endif
