## Create a LaTeX table from Maple.

latex_toprule := proc()
  printf("\\toprule\n");
end:

latex_midrule := proc()
  printf("\\midrule\n");
end:

latex_bottomrule := proc()
  printf("\\bottomrule\n");
end:

latex_cmidrule := proc(a, b)
  printf("\\cmidrule{%d-%d}\n", a, b);
end:

latex_tab := proc()
  printf(" & ");
end:

latex_newline := proc()
  printf("\\\\\n");
end:

latex_tablehead := proc(columns_description, columns, rows_description)
  local M;
  printf("\\begin{tabular}{r*{%d}r}\n", nops(columns));
  latex_toprule();
  latex_tab();
  printf("\\multicolumn{%d}{c}{%s}", nops(columns), columns_description);
  latex_newline();
  latex_cmidrule(2, 1+nops(columns));
  printf("%s", rows_description);
  for M in columns do
    latex_tab();
    printf("%d", M);
  od;
  latex_newline();
  latex_midrule();
end:

latex_tablefoot := proc()
  printf("\\bottomrule\n");
  printf("\\end{tabular}\n");
end:

dimension_degree_table := proc(dimensions, degrees, entry_proc, time_limit)
  local n, M, R, poly;
  R := rand(1..100);
  latex_tablehead("Degree", degrees, "Dimension");
  for n in dimensions do
    printf("%d", n);
    for M in degrees do
      latex_tab();
      try 
        if time_limit = -1 then
          entry_proc(n, M);
	else
	  timelimit(time_limit, 
            proc()
	      entry_proc(n, M);
            end ())
        fi
       catch "time expired":
         printf("%% Time expired\n");
	 break;
       end;
    od;
    latex_newline();
  od;
  latex_tablefoot();
end:

dimension_degree_avg_runtime_table := proc(dimensions, degrees, compute_proc, 
				           num_samples, time_limit)
  dimension_degree_table(dimensions, degrees, 
    proc(n, M)
      local min_time, max_time, sum_time, time_before, time_after, i,
      	    avg_time, dev_time;
      min_time := 1e8;
      max_time := 0;
      sum_time := 0;
      for i from 1 to num_samples do
        time_before := time();
        timelimit(time_limit, 
          proc()
	    compute_proc(n, M);
          end ());
	time_after := time();
	min_time := min(min_time, time_after - time_before);
	max_time := max(max_time, time_after - time_before);
	sum_time := sum_time + time_after - time_before
      od;
      avg_time := sum_time / num_samples;
      dev_time := max(max_time - avg_time, avg_time - min_time);
      #printf("%7.2g \\pm %7.2g", avg_time, dev_time);
      printf("\\minavgmax{%7.2g}{%7.2g}{%7.2g}\n", min_time, avg_time, max_time);
    end,
    -1):
end:
    

