###
### Maple program
### accompanying the paper "How to integrate a polynomial over a simplex"
### by V. Baldoni, N. Berline, J. A. De Loera, M. Koeppe, and M. Vergne
###
### $Header: /home/mkoeppe/cvsroot/mkoeppe/w/papers/rat/pisa/programs/velleda-experiments-2008-05-18/table-comparison-integration.mpl,v 1.1 2008/09/09 19:32:10 mkoeppe Exp $
###
### This creates the tables for the section "comparison of integration methods"

with(combinat):

read("integration.mpl");
read("latex-table.mpl");
read("examples.mpl");

table_integration_of_random_monomial := proc(dimensions, degrees, num_samples, time_limit, procedure)
  printf("%%%%integration of random monomial by %s:\n", procedure);
  dimension_degree_avg_runtime_table(dimensions, degrees, 
    proc(n, M)
      local S, mono;
      S := lattice_random_simplex(n, 100);
      mono := random_monomial(n, M);
      procedure(S, n, mono);
    end,
    num_samples, time_limit);
end:


table_integration_by_decomposition_powerlinform := proc(dimensions, degrees, num_samples, time_limit)
  printf("%%%%integration_by_decomposition_powerlinform:\n");
  table_integration_of_random_monomial(dimensions, degrees, num_samples, 
                                       time_limit, 
                                       without_from_monome_to_linear_integral);
end:

#table_integration_by_decomposition_powerlinform([1, 2, 3],[1, 2, 3], 50, 60);
#table_integration_by_decomposition_powerlinform([2, 3, 4, 5, 8, 10, 15, 20, 30, 40, 50], [1, 2, 5, 10, 20, 30, 40, 50], 50, 600);
#table_integration_by_decomposition_powerlinform([1], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);
#table_integration_by_decomposition_powerlinform([2], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);
table_integration_by_decomposition_powerlinform([6,7], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);

table_integration_by_iterated_laurent := proc(dimensions, degrees, num_samples, time_limit)
  printf("%%%%integration_by_iterated_laurent:\n");
  table_integration_of_random_monomial(dimensions, degrees, num_samples, 
                                       time_limit, 
                                       Nicole_simplex_integral);
end:
#table_integration_by_iterated_laurent([2, 3, 4, 5, 8, 10, 15, 20, 30, 40, 50], [1, 2, 5, 10, 20, 30, 40, 50], 50, 600);
#table_integration_by_iterated_laurent([2], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);
#table_integration_by_iterated_laurent([6], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);

table_integration_with_polarization := proc(dimensions, degrees, num_samples, time_limit)
  printf("%%%%integration_with_polarization:\n");
  table_integration_of_random_monomial(dimensions, degrees, num_samples, 
                                       time_limit, 
                                       integrate_with_polarization);
end:

#table_integration_with_polarization([2, 3, 4], [1, 2, 5], 50, 600);
#table_integration_with_polarization([2, 3, 4, 5, 8, 10, 15, 20, 30, 40, 50], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);
#table_integration_with_polarization([3], [1, 2, 5, 10, 20, 30, 40, 50, 100, 200, 300, 1000], 50, 600);
#table_integration_with_polarization([4,5,8,10,15,20,30,40,50], [1, 2], 50, 600);
