###
### Maple program
### accompanying the paper "How to integrate a polynomial over a simplex"
### by V. Baldoni, N. Berline, J. A. De Loera, M. Koeppe, and M. Vergne
###
### $Header: /home/mkoeppe/cvsroot/mkoeppe/w/papers/rat/pisa/programs/velleda-experiments-2008-05-18/table-decomposition-powerlinform.mpl,v 1.1 2008/09/09 19:32:10 mkoeppe Exp $
###
### This creates the table "Decomposition-powerlinform"

with(combinat):

read("integration.mpl");
read("latex-table.mpl");

all_monomials_of_given_degree := proc(dimension, degree)
  local all_monomials, i;
  assert(dimension>=0);			      
  if (dimension = 0) then
    # Base case.
    if (degree = 0) then [[]]
    else []
    end if
  elif (dimension = 1) then
    [[degree]]
  else
    all_monomials := [];
    for i from 0 to degree do
      all_monomials := [ op(all_monomials),
      		         op(map(exps -> [i, op(exps)],
			     all_monomials_of_given_degree(dimension - 1, degree - i))) ];
    od;
  end if;
end:

##all_monomials_of_given_degree(3,7);

table_decomposition_powerlinform := proc(dimensions, degrees, time_limit)
  printf("%%%% Monomial by monomial\n");
  dimension_degree_table(dimensions, degrees, 
          proc(n, M)
	    local poly;
            # Create a dense homogeneous polynomial represented as a list of
            # [COEFFICIENT, EXPONENT-VECTOR] elements.
            poly := map(exp -> [R(), exp],
       	            all_monomials_of_given_degree(n, M));
            printf("%d", add(nops(from_monome_to_linear(`d`, op(2, coeff_and_exp))),
              coeff_and_exp in poly));
 	 end,
  	 time_limit);
end:

#table_decomposition_powerlinform([2, 5, 10, 20, 30, 40, 50],[1, 2, 5, 10, 20, 30, 40, 50], 600):
table_decomposition_powerlinform([3, 4, 8, 15],[1, 2, 5, 10, 20, 30, 40, 50], 600):

table_waring_bounds := proc(dimensions, degrees, time_limit)
  printf("%%%% Waring bounds:\n");
  dimension_degree_table(dimensions, degrees,
    proc(n, M) 
      local wb;
      wb := waring_bound(n, M);
      if wb < 1000000 then
      printf("%d", wb)
      else
      printf("%7.2g", wb)
      end if;
    end, time_limit)
end:

table_waring_bounds([2, 3, 4, 5, 8, 10, 15, 20, 30, 40, 50], [1, 2, 5, 10, 20, 30, 40, 50], 600);

