###
### Maple program
### accompanying the paper "How to integrate a polynomial over a simplex"
### by V. Baldoni, N. Berline, J. A. De Loera, M. Koeppe, and M. Vergne
###
### $Header: /home/mkoeppe/cvsroot/mkoeppe/w/papers/rat/pisa/programs/velleda-experiments-2008-05-18/table-integration-of-powerlinform.mpl,v 1.1 2008/09/09 19:32:10 mkoeppe Exp $
###
### This creates the table "integration-of-powerlinform"

with(combinat):

read("integration.mpl");
read("latex-table.mpl");

random_linear_form:=proc(d) local R,U;
  R := rand(10):
  U := proc()  R()  end proc:
  [ seq( U(), i=1..d) ];
end:

lattice_random_simplex:=proc(d,N) local R,U;
  R := rand(N):
  U:=proc()[seq(R(),i=1..d)] end proc:
  [ seq(U(), i=1..d+1) ];
  end:
  standard_basis:=proc(d) local i,v;
  for i from 1 to d do
  v[i]:=[seq(0,j=1..i-1),1,seq(0,j=i+1..d)]
  od;[seq(v[j],j=1..d)];
  end:
  standard_simplex:=proc(d) local a, output;
  a:=[seq(0,i=1..d)];
  output:=[a,op(standard_basis(d))];
end:

one_random_integral := proc(n, M)
  local S, alpha;
  S := lattice_random_simplex(n, M);
  alpha := random_linear_form(n);
  without_basic_simplex_integral(S, n, M, alpha);
end:

#one_random_integral(3, 7);

table_integration_of_powerlinform := proc(dimensions, degrees, time_limit)
  printf("%%%% integration-of-powerlinform:\n");
  dimension_degree_table(dimensions, degrees,
    proc(n, M)
      local integral, time_before, time_after;
      time_before := time();
      integral := one_random_integral(n, M);
      time_after := time();
      printf("%5.2g", time_after - time_before);
    end, time_limit)
end:

#table_integration_of_powerlinform([10, 20, 50, 100, 300, 1000], [2, 10, 20, 50, 100, 300, 1000], 600);

table_integration_of_powerlinform([200, 400], [2, 10, 20, 50, 100, 300, 1000], 600);
