###
### Maple program
### accompanying the paper "How to integrate a polynomial over a simplex"
### by V. Baldoni, N. Berline, J. A. De Loera, M. Koeppe, and M. Vergne
###
### $Header: /home/mkoeppe/cvsroot/mkoeppe/w/papers/rat/pisa/programs/velleda-experiments-2008-05-18/test-decomposition-powerlinform.mpl,v 1.2 2008/09/09 19:41:15 mkoeppe Exp $
###

read("integration.mpl");
#
# The monomial x^2 y^2.
m := [2,2];
#
# Its total degree.
#
totaldegree := add(m[i], i=1..nops(m));
#
# The decomposition.
#
powerlinformdecomposition := from_monome_to_linear(d, m);
#
# Decoded.
#
decode_powerlinform_element := proc(variables, totaldegree)
  proc(term)
    local coeff, linform, j;
    coeff := op(1, term);
    linform := op(2,term);
    coeff * add(linform[j] * variables[j], j=1..nops(variables))^totaldegree;
  end;
end:

polynomial := add(decode_powerlinform_element([x,y], totaldegree)
	      	    (powerlinformdecomposition[i]),
	          i=1..nops(powerlinformdecomposition));
#
# Expand to check it's the same polynomial.
#
expanded_polynomial := expand(polynomial);
#
# Success?
#
decode_monomial := proc(variables)
  proc(exponents)
    assert(nops(variables) = nops(exponents));
    product(variables[j]^exponents[j], j=1..nops(exponents));
  end;
end:
evalb(expanded_polynomial = decode_monomial([x,y])(m));
