#  Data for computing examples
  random_vertex:=proc(d) local R,U;
  R := rand(1..10^2):
  U := proc()  R()/R()  end proc:
  [ seq( U(), i=1..d) ];
  end:
#   random_vertex(5);
  random_cone:=proc(d,N) local R,U,V;
  R := rand(N):
  U:=proc()[seq(R(),i=1..d)] end proc:
  [ seq(U(), i=1..d) ];
  end:
#  random_cone(2,100);
#OUTPUT:                              [[82, 8], [63, 42]]
  lattice_random_simplex:=proc(d,N) local R,U;
  R := rand(N):
  U:=proc()[seq(R(),i=1..d)] end proc:
  [ seq(U(), i=1..d+1) ];
  end:
  random_simplex:=proc(d,N) local R,U,V;
  R := rand(N):
  U:=proc()[seq(R(),i=1..2*d)] end proc:
  V:=proc() [seq(U()[i]/U()[i+d],i=1..d)] end proc:
  [ seq(V(), i=1..d+1) ];
  end:
  dilated_random_simplex:=proc(d,N,n)local R,U,V;
  R := rand(N):
  U:=proc()[seq(R(),i=1..2*d)] end proc:
  V:=proc() [seq(n*U()[i]/U()[i+d],i=1..d)] end proc:
  [ seq(V(), i=1..d+1) ];
  end:
  standard_basis:=proc(d) local i,v;
  for i from 1 to d do
  v[i]:=[seq(0,j=1..i-1),1,seq(0,j=i+1..d)]
  od;[seq(v[j],j=1..d)];
  end:
#  standard_basis(3);
#OUTPUT:                       [[1, 0, 0], [0, 1, 0], [0, 0, 1]]
  standard_simplex:=proc(d) local a, output;
  a:=[seq(0,i=1..d)];
  output:=[a,op(standard_basis(d))];
  end:
##  standard_simplex(4);
#OUTPUT:    [[0, 0, 0, 0], [1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]]


# Experiments
  st:=time();Nicole_simplex_integral([[1,2,3,4,5,6],[1,1,1,1,1,1],[0,2,3,4,5,6],[0,0,3,4,5,7],[0,0,0,4,5,6],
  [0,0,0,0,5,6], [0,0,0,0,0,6] ],6,[2,2,2,2,2,2]);T:=time()-st; #8.9;
#OUTPUT:                                     0.118
#OUTPUT:                                89134414957997
#OUTPUT:                                --------------
#OUTPUT:                                 78153975900  
#OUTPUT:                                     6.670

