# EXPERIMENTS ON POWERS OF LINEAR FORMS:

read("integration.mpl"):

# 
# 
# Datas for examples.
  random_linear_form:=proc(d) local R,U;
  R := rand(10):
  U := proc()  R()  end proc:
  [ seq( U(), i=1..d) ];
  end:
  random_monomial:=proc(d,K) local R,U;
  R := rand(K..K+1):
  U := proc()  R()  end proc:
  [ seq( U(), i=1..d) ];
  end:
  #random_monomial with fixed degree
  random_monomial_with_degree:=proc(d,M) local initial,s,l,j,R,U;l:=[];
  initial:=M;j:=1; while j<=d do
  R:=rand(0..initial);
  s:=R();#print("s",s,j);
  l:=[ op(l), s];initial:=initial-s;
  j:=j+1;
  od:
  l;
  end:
  
  lattice_random_simplex:=proc(d,N) local R,U;
  R := rand(N):
  U:=proc()[seq(R(),i=1..d)] end proc:
  [ seq(U(), i=1..d+1) ];
  end:
  standard_basis:=proc(d) local i,v;
  for i from 1 to d do
  v[i]:=[seq(0,j=1..i-1),1,seq(0,j=i+1..d)]
  od;[seq(v[j],j=1..d)];
  end:
  standard_simplex:=proc(d) local a, output;
  a:=[seq(0,i=1..d)];
  output:=[a,op(standard_basis(d))];
  end:
#  standard_simplex(4);
#OUTPUT:    [[0, 0, 0, 0], [1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1]]
  
  
#  random_monomial_with_degree(5,4);
#OUTPUT:                                [4, 0, 0, 0, 0]


  #we compare Nicole method via iterated residue and the new one  for a linear form d is the dimension of the simplex the  monome is x^j (the linear form is alpha=[1,0,0...] with  exponent  j. The simplex is random
  ExperimentNV:=proc(d,i) local listN,listV,R,alpha,j,r; 
  listN:=[]; 
  listV:=[]; R:=lattice_random_simplex(d,100);#print(R);
  alpha:=[1,seq(0,u=1..d-1)];  
  for j from 1 to i do 
  r:=time(); 
  Nicole_simplex_integral(R,d,[j, seq(0,u=1..(d-1))]);
  listN:=[op(listN),time()-r];
  od;
  for j from 1 to i do 
  r:=time(); 
  without_basic_simplex_integral(R,d,j,alpha);
  listV:=[op(listV),time()-r];
  od; 
  [[N,listN],[V,listV]];
  end:
  ExperimentNV(2^3,4);
#OUTPUT:          [[N, [0., 0., 0., 0.]], [V, [0.023, 0.008, 0.006, 0.007]]]
  
  
  partial_the_ExperimentValpha:=proc(d,j) local output, 
  out1,out2,list1,s,data,average,k,list2,R,alpha,beta,r; 
  out1:=[]; average:[];out2:=[];
  list2:=[];list1:=[];output:=0;
  #for j from 1 by 2 to 9 do
  
  R:=[seq(lattice_random_simplex(d,100),k=1..5)];
  
  beta:=[seq(random_linear_form(d),k=1..5)];#print("simplex",R,"linear form",beta);
  for s from 1 to 5 do
  r:=time(); 
  without_basic_simplex_integral(R[s],d,j,beta[s]);
  list2:=[op(list2),"simplex",R[s],s,j,"alpha",beta[s],[time()-r,"exponent",j]];
  list1:=[op(list1),time()-r];output:=output+time()-r;
  #data:=[R[s],beta];od;
  out2:=[op(out2),list2];
  
  out1:=[op(out1),list1];
   list2:=[];
  list1:=[];
  od;
  average:=output/5;
  #print("out2",out2);
  #[data,average];
  average;
  end:
  
  
  
  the_ExperimentValpha:=proc(d) local out,q,j;
  out:=[];
  for j from 1 by 2 to 9 do
  q:=partial_the_ExperimentValpha(d,j):
  out:=[op(out),q];
  od:
  out:
  end:
  
  ExperimentValphabeta:=proc(d,i) local 
  list1,list2,R,alpha,beta,j,r; 
  list1:=[]; 
  list2:=[];
   R:=lattice_random_simplex(d,100);
  #alpha:=[1,seq(0,u=1..d-1)];
  beta:=random_linear_form(d);#print("simplex",R,"linear form",beta);
  #for j from 1 to i do 
  #r:=time(); 
  #sn:=simplex_integral(R,d,[j,seq(0,u=1..d-1)]);
  #sv:=basic_simplex_integral(R,d,j,alpha);
  #list1:=[op(list1),[sn,sv]];
  #od; 
  for j from 1 to i do 
  r:=time(); 
  without_basic_simplex_integral(R,d,j,beta);
  list2:=[op(list2),[time()-r]];
  od; 
  list2;
  end:
  ExperimentValphabeta(4,3);
#OUTPUT:                          [[0.003], [0.002], [0.002]]
# Decomposing  a monomial in powers of linear forms.
#  with(LinearAlgebra):  with(combinat): with(linalg):
  decomposition_multindex_monomial:=proc(MM) 
  local output,newvector,i,M,k,list,f,g,term:output:=0;newvector:=[];
     for i from 1 to nops(MM) do
     newvector:=[op(newvector),seq(y[i],j=1..MM[i])];
     od;
  #print(newvector);
  M:=add(MM[l],l=1..nops(MM));
  g[nops(MM)]:=0;
      k:=1;
      f:=add((-1)^(p)*binomial(MM[k],p)*(p*y[k]+g[k])^M,p=0..MM[k]);
          for k from 2 to nops(MM) do 
          f:=add((-1)^(p)*binomial(MM[k],p)*subs(g[k-1]=p*y[k]+g[k],f),p=0..MM[k]);
          od;
  #print("ECCO",simplify(1/M!*(-1)^M*f)):
  1/M!*(-1)^M*f;
  end:
#
#  Integration of a monomial by decomposing it in powers of linear forms.
#
# 
  S:=lattice_random_simplex(4,100);
#OUTPUT:    [[39, 65, 86, 15], [97, 42, 52, 60], [46, 27, 74, 2], [4, 10, 36, 74], 
#OUTPUT: 
#OUTPUT:      [3, 90, 21, 39]]
  without_from_monome_to_linear_integral(S,4,[1,1,1,1]);
#OUTPUT: without_from_monome_to_linear_integral([[39, 65, 86, 15], [97, 42, 52, 60], 
#OUTPUT: 
#OUTPUT:   [46, 27, 74, 2], [4, 10, 36, 74], [3, 90, 21, 39]], 4, [1, 1, 1, 1])
  
#  Experiments. 
  ExperimentVM:=proc(d,K) local listN,R,m,rN,intN, 
  listV,i,iv,exV,rV,iM,exM; 
   listV:=[];
   R:=lattice_random_simplex(d,100);
   for i from K to K+1 do 
  m:=random_monomial(d,i); #print(m);
  rN:=time();
  intN:=simplex_integral(R,d,m);
  listN:=[op(listN),time()-rN]; 
  #print(timeN,time()-rN); 
  rV:=time();
  iv:=from_monome_to_linear_integral(R,d,m);
  listV:=[op(listV),time()-rV];
  #print(timeV,time()-rV);
  #rM:=time(); 
  #iM:=simplex_integral_michele(R,d,m);
  #exM:=[iM,time()-rM]; 
  od;
  [[N,listN],[V,listV]];
  end: 
  ExperimentNVM:=proc(d,K) local R,m,rN,intN, 
  listN,listV,i,iv,exV,rV,iM,exM; 
  listN:=[]; listV:=[];
   R:=lattice_random_simplex(d,100);
   for i from K to K+1 do 
  m:=random_monomial(d,i); #print(m);
  rN:=time();
  intN:=Nicole_simplex_integral(R,d,m);
  listN:=[intN,time()-rN]; 
  #print(timeN,time()-rN); 
  rV:=time();
  iv:=from_monome_to_linear_integral(R,d,m);
  listV:=[iv,time()-rV];
  #print(timeV,time()-rV);
  rM:=time(); 
  iM:=without_from_monome_to_linear_integral(R,d,m);
  exM:=[iM,time()-rM]; 
  od;
  [[Nicole,listN],[without,listV],[with,exM]];
  end: 
#OUTPUT: 
#OUTPUT: Warning, `rM` is implicitly declared local to procedure `ExperimentNVM`
  ExperimentNVM(7,0);
#OUTPUT:        [[        [602205410979537376466266443335943969797         ]]  
#OUTPUT:        [[Nicole, [---------------------------------------, 245.593]], 
#OUTPUT:        [[        [            11115232128000                      ]]  
#OUTPUT: 
#OUTPUT:          [         [602205410979537376466266443335943969797       ]]  
#OUTPUT:          [without, [---------------------------------------, 6.203]], 
#OUTPUT:          [         [            11115232128000                    ]]  
#OUTPUT: 
#OUTPUT:          [      [602205410979537376466266443335943969797       ]]]
#OUTPUT:          [with, [---------------------------------------, 2.542]]]
#OUTPUT:          [      [            11115232128000                    ]]]
  
